﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ScriptNET.Runtime.Operators
{
  public class PowOperator : BinaryOperator
  {
    public PowOperator() :
      base("^")
    {
      RegisterEvaluator(typeof(Int16), typeof(Int16), (x, y) => Math.Pow((Int16)x, (Int16)y));
      RegisterEvaluator(typeof(Int16), typeof(Int32), (x, y) => Math.Pow((Int16)x, (Int32)y));
      RegisterEvaluator(typeof(Int16), typeof(Int64), (x, y) => Math.Pow((Int16)x, (Int64)y));
      RegisterEvaluator(typeof(Int16), typeof(double), (x, y) => Math.Pow((Int16)x, (double)y));
      RegisterEvaluator(typeof(Int16), typeof(float), (x, y) => Math.Pow((Int16)x, (float)y));

      RegisterEvaluator(typeof(Int32), typeof(Int16), (x, y) => Math.Pow((Int32)x , (Int16)y));
      RegisterEvaluator(typeof(Int32), typeof(Int32), (x, y) => Math.Pow((Int32)x , (Int32)y));
      RegisterEvaluator(typeof(Int32), typeof(Int64), (x, y) => Math.Pow((Int32)x , (Int64)y));
      RegisterEvaluator(typeof(Int32), typeof(double), (x, y) => Math.Pow((Int32)x , (double)y));
      RegisterEvaluator(typeof(Int32), typeof(float), (x, y) => Math.Pow((Int32)x , (float)y));

      RegisterEvaluator(typeof(Int64), typeof(Int16), (x, y) => Math.Pow((Int64)x , (Int16)y));
      RegisterEvaluator(typeof(Int64), typeof(Int32), (x, y) => Math.Pow((Int64)x , (Int32)y));
      RegisterEvaluator(typeof(Int64), typeof(Int64), (x, y) => Math.Pow((Int64)x , (Int64)y));
      RegisterEvaluator(typeof(Int64), typeof(double), (x, y) => Math.Pow((Int64)x , (double)y));
      RegisterEvaluator(typeof(Int64), typeof(float), (x, y) => Math.Pow((Int64)x , (float)y));

      RegisterEvaluator(typeof(double), typeof(Int16), (x, y) => Math.Pow((double)x , (Int16)y));
      RegisterEvaluator(typeof(double), typeof(Int32), (x, y) => Math.Pow((double)x , (Int32)y));
      RegisterEvaluator(typeof(double), typeof(Int64), (x, y) => Math.Pow((double)x , (Int64)y));
      RegisterEvaluator(typeof(double), typeof(double), (x, y) => Math.Pow((double)x , (double)y));
      RegisterEvaluator(typeof(double), typeof(float), (x, y) => Math.Pow((double)x , (float)y));

      RegisterEvaluator(typeof(float), typeof(Int16), (x, y) => Math.Pow((float)x , (Int16)y));
      RegisterEvaluator(typeof(float), typeof(Int32), (x, y) => Math.Pow((float)x , (Int32)y));
      RegisterEvaluator(typeof(float), typeof(Int64), (x, y) => Math.Pow((float)x , (Int64)y));
      RegisterEvaluator(typeof(float), typeof(double), (x, y) => Math.Pow((float)x , (double)y));
      RegisterEvaluator(typeof(float), typeof(float), (x, y) => Math.Pow((float)x, (float)y));

    }
  }
}
