#include "stdafx.h"
#include "AppTimer.h"
#include <ctime>

AppTimer* AppTimer::singleton = nullptr;

AppTimer::AppTimer()
{
	singleton = this;

	timerStopped = true;

	ll_baseTime = 0;
	mllStopTime = 0;
	ll_LastElapsedTime = 0;

	baseTime = 0;
	stopTime = 0;
	lastElapsedTime = 0;

	mllQPFTicksPerSec = 0;

	usingQPF = false;
}

AppTimer::~AppTimer()
{
	singleton = nullptr;
}

void AppTimer::Start()
{
	if (usingQPF)
	{
		LARGE_INTEGER qwTime;
		QueryPerformanceCounter(&qwTime);

		if (timerStopped)
		{
			ll_baseTime += qwTime.QuadPart - mllStopTime;
		}

		mllStopTime = 0;
		ll_LastElapsedTime = qwTime.QuadPart;
		timerStopped = false;
	}
	else
	{
		unsigned long time;
		time = std::time(nullptr);

		if (timerStopped)
		{
			baseTime += time - stopTime;
		}

		stopTime = 0;
		lastElapsedTime = time;
		timerStopped = false;
	}
}

void AppTimer::Stop()
{
	if (usingQPF)
	{
		LARGE_INTEGER qwTime;
		if (mllStopTime != 0)
		{
			qwTime.QuadPart = mllStopTime;
		}
		else
		{
			QueryPerformanceCounter(&qwTime);
		}

		if (!timerStopped)
		{
			mllStopTime = qwTime.QuadPart;
			ll_LastElapsedTime = qwTime.QuadPart;
			timerStopped = true;
		}
	}
	else
	{
		unsigned long time;
		if (stopTime != 0)
		{
			time = stopTime;
		}
		else
		{
			time = std::time(nullptr);
		}

		if (!timerStopped)
		{
			stopTime = time;
			lastElapsedTime = time;
			timerStopped = true;
		}
	}
}

void AppTimer::Reset()
{
	if (usingQPF)
	{
		LARGE_INTEGER qwTime;
		if (mllStopTime != 0)
		{
			qwTime.QuadPart = mllStopTime;
		}
		else
		{
			QueryPerformanceCounter(&qwTime);
		}

		ll_baseTime = qwTime.QuadPart;
		ll_LastElapsedTime = qwTime.QuadPart;
		mllStopTime = 0;
		timerStopped = false;
	}
	else
	{
		unsigned long time;
		if (stopTime != 0.0)
		{
			time = stopTime;
		}
		else
		{
			time = std::time(nullptr);
		}

		baseTime = time;
		lastElapsedTime = time;
		stopTime = 0;
		timerStopped = false;
	}
}

void AppTimer::Advance()
{
	if (usingQPF)
	{
		///
		LARGE_INTEGER qwTime;
		if (mllStopTime != 0)
		{
			qwTime.QuadPart = mllStopTime;
		}
		else
		{
			QueryPerformanceCounter(&qwTime);
		}

		mllStopTime += mllQPFTicksPerSec / static_cast<LONGLONG>(10);
	}
	else
	{
		///
		unsigned long time;
		if (stopTime != 0)
			time = stopTime;
		else
			time = std::time(nullptr);

		stopTime += 100; /// += 0.1f
	}
}

unsigned long AppTimer::GetAbsoluteTime()
{
	unsigned long absoluteTime;
	if (usingQPF)
	{
		LARGE_INTEGER qwTime;
		QueryPerformanceCounter(&qwTime);

		absoluteTime = (unsigned long)((long double)qwTime.QuadPart / (long double)mllQPFTicksPerSec * 1000.0);
	}
	else
	{
		absoluteTime = std::time(nullptr);
	}
	return absoluteTime;
}

unsigned long AppTimer::GetCurrentTime()
{
	unsigned long currentTime;
	if (usingQPF)
	{
		LARGE_INTEGER qwTime;
		if (mllStopTime != 0)
		{
			qwTime.QuadPart = mllStopTime;
		}
		else
		{
			QueryPerformanceCounter(&qwTime);
		}

		currentTime = (unsigned long)((long double)(qwTime.QuadPart - ll_baseTime) / (long double)mllQPFTicksPerSec * 1000.0);
	}
	else
	{
		if (stopTime != 0)
		{
			if (stopTime < baseTime)		// DWORD  Ѱ踦 Ѿ
				currentTime = stopTime - baseTime + 4294967295; //( 2^32 - 1 )
			else
				currentTime = stopTime - baseTime;
		}
		else
		{
			unsigned long time = std::time(nullptr);
			if (time < baseTime)		// DWORD  Ѱ踦 Ѿ
				currentTime = time - baseTime + 4294967295; //( 2^32 - 1 )
			else
				currentTime = time - baseTime;
		}
	}
	return currentTime;
}

unsigned long AppTimer::GetDeltaTime()
{
	unsigned long deltaTime;
	if (usingQPF)
	{
		LARGE_INTEGER qwTime;
		if (mllStopTime != 0)
		{
			qwTime.QuadPart = mllStopTime;
		}
		else
		{
			QueryPerformanceCounter(&qwTime);
		}

		deltaTime = (unsigned long)(((long double)qwTime.QuadPart - (long double)ll_LastElapsedTime) * 1000.0f / (long double)mllQPFTicksPerSec);
		ll_LastElapsedTime = qwTime.QuadPart;
	}
	else
	{
		if (stopTime != 0)
		{
			if (stopTime < lastElapsedTime)		// DWORD  Ѱ踦 Ѿ
				deltaTime = stopTime - lastElapsedTime + 4294967295; //( 2^32 - 1 )
			else
				deltaTime = stopTime - lastElapsedTime;

			lastElapsedTime = stopTime;
		}
		else
		{
			unsigned long time = std::time(nullptr);
			if (time < lastElapsedTime)		// DWORD  Ѱ踦 Ѿ
				deltaTime = time - lastElapsedTime + 4294967295; //( 2^32 - 1 )
			else
				deltaTime = time - lastElapsedTime;

			lastElapsedTime = time;
		}
	}
	return deltaTime;
}

TIMESTAMP_STRUCT AppTimer::GetRealTime()
{
	TIMESTAMP_STRUCT timestamp;

	struct tm datetime;

	time_t now;
	errno_t err;

	time(&now);

	//datetime = *localtime( &now );
	err = localtime_s(&datetime, &now);

	timestamp.year = static_cast<SQLSMALLINT>(datetime.tm_year + 1900);
	timestamp.month = static_cast<SQLSMALLINT>(datetime.tm_mon + 1);
	timestamp.day = static_cast<SQLSMALLINT>(datetime.tm_mday);
	timestamp.hour = static_cast<SQLSMALLINT>(datetime.tm_hour);
	timestamp.minute = static_cast<SQLSMALLINT>(datetime.tm_min);
	timestamp.second = static_cast<SQLSMALLINT>(datetime.tm_sec);
	timestamp.fraction = 0;

	return timestamp;
}

TIMESTAMP_STRUCT AppTimer::GetRealPlusTime(unsigned long sec)
{
	TIMESTAMP_STRUCT timestamp;

	struct tm datetime;

	time_t now, result;
	errno_t err;

	time(&now);
	//datetime = *localtime( &now );
	err = localtime_s(&datetime, &now);

	timestamp.year = static_cast<SQLSMALLINT>(datetime.tm_year) + 1900;
	timestamp.month = static_cast<SQLSMALLINT>(datetime.tm_mon) + 1;
	timestamp.day = static_cast<SQLSMALLINT>(datetime.tm_mday);
	timestamp.hour = static_cast<SQLSMALLINT>(datetime.tm_hour);
	timestamp.minute = static_cast<SQLSMALLINT>(datetime.tm_min);
	timestamp.second = static_cast<SQLSMALLINT>(datetime.tm_sec);

	datetime.tm_sec = datetime.tm_sec + (sec / 1000);

	if ((result = mktime(&datetime)) != (time_t)-1)
	{
		//datetime = *localtime( &result );
		err = localtime_s(&datetime, &result);
	}

	timestamp.year = static_cast<SQLSMALLINT>(datetime.tm_year + 1900);
	timestamp.month = static_cast<SQLSMALLINT>(datetime.tm_mon + 1);
	timestamp.day = static_cast<SQLSMALLINT>(datetime.tm_mday);
	timestamp.hour = static_cast<SQLSMALLINT>(datetime.tm_hour);
	timestamp.minute = static_cast<SQLSMALLINT>(datetime.tm_min);
	timestamp.second = static_cast<SQLSMALLINT>(datetime.tm_sec);
	timestamp.fraction = 0;

	return timestamp;
}

tm AppTimer::ConvertTStoTM(TIMESTAMP_STRUCT timestamp)
{
	struct tm datetime;

	datetime.tm_year = timestamp.year - 1900;
	datetime.tm_mon = timestamp.month - 1;
	datetime.tm_mday = timestamp.day;
	datetime.tm_hour = timestamp.hour;
	datetime.tm_min = timestamp.minute;
	datetime.tm_sec = timestamp.second;

	return datetime;
}

TIMESTAMP_STRUCT AppTimer::ConvertTMtoTS(tm datetime)
{
	TIMESTAMP_STRUCT timestamp;

	timestamp.year = static_cast<SQLSMALLINT>(datetime.tm_year + 1900);
	timestamp.month = static_cast<SQLSMALLINT>(datetime.tm_mon + 1);
	timestamp.day = static_cast<SQLSMALLINT>(datetime.tm_mday);
	timestamp.hour = static_cast<SQLSMALLINT>(datetime.tm_hour);
	timestamp.minute = static_cast<SQLSMALLINT>(datetime.tm_min);
	timestamp.second = static_cast<SQLSMALLINT>(datetime.tm_sec);
	timestamp.fraction = 0;

	return timestamp;
}

long AppTimer::DiffRealTime(TIMESTAMP_STRUCT timestamp)
{
	///  ð time_t ȯ
	struct tm tempTime = ConvertTStoTM(GetRealTime());
	time_t realTime = mktime(&tempTime);

	/// Էµ ð time_t ȯ
	tempTime = TIMER->ConvertTStoTM(timestamp);
	time_t endTime = mktime(&tempTime);

	///  
	return static_cast<long>(difftime(endTime, realTime)) * 1000;
}

tm AppTimer::ConvertSTtoTM(SYSTEMTIME systime)
{
	struct tm datetime;
	memset(&datetime, 0, sizeof(tm));
	datetime.tm_year = (int)systime.wYear - 1900;
	datetime.tm_mon = (int)systime.wMonth - 1;
	datetime.tm_wday = (int)systime.wDayOfWeek;
	datetime.tm_mday = (int)systime.wDay;
	datetime.tm_hour = (int)systime.wHour;
	datetime.tm_min = (int)systime.wMinute;
	datetime.tm_sec = (int)systime.wSecond;

	return datetime;
}

