#pragma once

#include "sqltypes.h"

class AppTimer
{
	static AppTimer* singleton;

public:
	AppTimer();
	~AppTimer();

	void Start();
	void Stop();

	void Reset();

	void Advance();

	unsigned long GetAbsoluteTime();

	unsigned long GetCurrentTime();

	unsigned long GetDeltaTime();

	bool IsStopped() { return timerStopped; }

	TIMESTAMP_STRUCT GetRealTime();

	TIMESTAMP_STRUCT GetRealPlusTime(unsigned long sec);

	tm ConvertTStoTM(TIMESTAMP_STRUCT timestamp);
	TIMESTAMP_STRUCT ConvertTMtoTS(tm datetime);

	long DiffRealTime(TIMESTAMP_STRUCT timestamp);

	tm ConvertSTtoTM(SYSTEMTIME systime);

	static AppTimer* GetSingleton();

private:
	bool usingQPF;

	bool timerStopped;

	LONGLONG mllQPFTicksPerSec;
	LONGLONG mllStopTime;
	LONGLONG ll_LastElapsedTime;
	LONGLONG ll_baseTime;

	unsigned long lastElapsedTime;
	unsigned long baseTime;
	unsigned long stopTime;
};

inline AppTimer* AppTimer::GetSingleton()
{
	return singleton;
}

#define TIMER AppTimer::GetSingleton()