// Copyright 2018 RED Software, LLC. All Rights Reserved.
#include "stdafx.h"
#include "AppWindow.h"

TCHAR AppWindow::windowClassName[] = _T("Project Torch");
HANDLE AppWindow::mutexHandle = nullptr;

AppWindow::AppWindow()
{
}

AppWindow::~AppWindow()
{
	if (mutexHandle)
	{
		::CloseHandle(mutexHandle);
	}

	::DestroyWindow(wnd);		
}

NiWindowRef AppWindow::Create(NiInstanceRef hi, unsigned int width, unsigned int height)
{
	width = width;
	height = height;

	RECT rect = { 0, 0, width, height };
	windowStyle = WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_CLIPCHILDREN;

	::AdjustWindowRect(&rect, windowStyle, FALSE);

	wnd = ::CreateWindow(GetWindowClassName(), GetWindowClassName(), windowStyle,
		CW_USEDEFAULT, CW_USEDEFAULT, rect.right - rect.left, rect.bottom - rect.top, nullptr, nullptr, hi, nullptr);

	if (wnd)
	{
		::SetWindowPos(wnd, nullptr, 0, 0, rect.right - rect.left, rect.bottom - rect.top, SWP_FRAMECHANGED | SWP_HIDEWINDOW | SWP_NOACTIVATE);

		HMENU hMenu = GetSystemMenu(wnd, FALSE);
		EnableMenuItem(hMenu, SC_CLOSE, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);

		windowStyle = ::GetWindowLong(wnd, GWL_STYLE);
		::ShowWindow(wnd, SW_HIDE);
	}

	return wnd;
}

void AppWindow::AdjustWindowForChange(bool isFullScreen)
{
	HWND order = HWND_TOPMOST;
	if (isFullScreen)
	{
		windowStyle = WS_POPUP | WS_SYSMENU | WS_VISIBLE;
	}
	else
	{
		windowStyle = WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_CLIPCHILDREN;

#if (defined(_DEVSYS) || defined(_DEBUG))
		order = HWND_NOTOPMOST;
#endif
	}
	::SetWindowLong(wnd, GWL_STYLE, windowStyle);

	windowStyle = ::GetWindowLong(wnd, GWL_STYLE);
	::SetWindowPos(wnd, order, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE | SWP_NOACTIVATE);
}

void AppWindow::AdjustWindowRect(unsigned int width, unsigned int height, bool Init)
{
	width = width;
	height = height;

	if (width >= (unsigned int)GetSystemMetrics(SM_CXSCREEN) ||
		height >= (unsigned int)GetSystemMetrics(SM_CYSCREEN))
	{
		windowStyle = WS_OVERLAPPED | WS_SYSMENU | WS_MINIMIZEBOX | WS_CLIPCHILDREN;
		::SetWindowLong(wnd, GWL_STYLE, windowStyle);

		windowStyle = ::GetWindowLong(wnd, GWL_STYLE);
	}

	RECT rect = { 0, 0, width, height };
	::AdjustWindowRect(&rect, windowStyle, FALSE);

	if (Init)
		::SetWindowPos(wnd, 0, 0, 0, rect.right - rect.left, rect.bottom - rect.top, SWP_FRAMECHANGED | SWP_HIDEWINDOW | SWP_NOACTIVATE);
	else
		::SetWindowPos(wnd, 0, 0, 0, rect.right - rect.left, rect.bottom - rect.top, SWP_FRAMECHANGED | SWP_SHOWWINDOW | SWP_NOACTIVATE);

	::InvalidateRect(NULL, 0, TRUE);
}

#if (defined(_DEVSYS) || defined(_DEBUG))
void AppWindow::ChangeWindowOrder(bool /*top*/)
{
}
#else
void cAppWindow::ChangeWindowOrder(bool top)
{
	if (top)
		::SetWindowPos(GetHWND(), HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE | SWP_FRAMECHANGED);
	else
		::SetWindowPos(GetHWND(), HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE | SWP_FRAMECHANGED | SWP_NOACTIVATE);
}
#endif