// Copyright 2018 RED Software, LLC. All Rights Reserved.
#pragma once

class AppWindow
{
public:
	AppWindow();
	~AppWindow();

	static HANDLE mutexHandle;

	static LPCTSTR GetWindowClassName() { return windowClassName; }

	unsigned int GetWidth() const { return width; }
	unsigned int GetHeight() const { return height; }

	NiWindowRef GetHWND() const { return wnd; }

	NiWindowRef Create(NiInstanceRef hi, unsigned int width, unsigned int height);

	void AdjustWindowForChange(bool isFullScreen);
	void AdjustWindowRect(unsigned int width, unsigned int height, bool Init = false);

	void ChangeWindowOrder(bool top);

	static TCHAR windowClassName[];

private:
	NiWindowRef wnd;

	unsigned int width;
	unsigned int height;

	unsigned long windowStyle;
};

