// Copyright 2018 RED Software, LLC. All Rights Reserved.
#include "Folder.h"
#include <NiFilename.h>

std::string ExecutableRootPath;
bool RootInitialized;

/**
 * \brief Get path to game data relative to executable
 * \param flType FolderType of desired folder
 * \param pcFile Sub-path to desired file
 * \return Full file path as std::string
 */
std::string Folder::GetFolderPath(const FolderType flType, const char * pcFile)
{
	if (!RootInitialized)
	{
		Init();
	}

	std::string buf = ExecutableRootPath;
	switch (flType)
	{
		case FL_CHARACTER: 
			buf.append("reschar\\");
			break;
		case FL_CTRL: 
			buf.append("resctrl\\");
			break;
		case FL_EFFECT:
			buf.append("reseffect\\");
			break;
		case FL_ITEM: 
			buf.append("resitem\\");	
			break;
		case FL_MAIN: 
			break;
		case FL_MENU:
			buf.append("resmenu\\");
			break;
		case FL_SOUND: 
			buf.append("ressound\\");
			break;
		case FL_SYSTEM: 
			buf.append("ressystem\\");
			break;
		default: 
			return nullptr;
	}

	buf.append(pcFile);

	return buf;
}

void Folder::Init()
{
	char buf[NI_MAX_PATH];
	NiPath::GetExecutableDirectory(buf, NI_MAX_PATH);
	NiPath::RemoveDotDots(buf);
	ExecutableRootPath = buf;

	RootInitialized = true;
}
