// Copyright 2018 RED Software, LLC. All Rights Reserved.
#include "MainApp.h"

#include "AppWindow.h"
#include "AppTimer.h"

#include "Folder.h"
#include "Renderer.h"

MainApp* MainApp::mpSingleton = nullptr;

MainApp::MainApp()
{
	mpSingleton = this;

	mIsActive = false;
	mIsMinimize = false;

	mpWindow = new AppWindow;

	mpTimer = nullptr;
}

MainApp::~MainApp()
{
	SAFE_DELETE(mpWindow);
	SAFE_DELETE(mpTimer);

	mpSingleton = nullptr;
}

HWND MainApp::GetHWND()
{
	return (mpWindow) ? mpWindow->GetHWND() : nullptr;
}

HINSTANCE MainApp::GetWindowInstance()
{
	return mpInstance;
}

MainApp* MainApp::Create()
{
	return new MainApp;
}

LRESULT CALLBACK MainApp::WinProc(HWND wnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
	/// window message parsing !!
	/*
	if (INPUTSYS && INPUTSYS->WindowMessageParser(wnd, msg, wparam, lparam))
	{
		/// Ŀü ϴ 
		/// DX_INPUT Ű  ..
		INPUTSYS->KeyInfoClear();
		return 0;
	}

	*/

	switch (msg)
	{
	case WM_CREATE:
	{
		::SetTimer(wnd, 0, 60000, NULL);

		/*		HIMC hImc = ImmGetContext( wnd );
		DWORD dwConversion, dwSentence;
		ImmGetConversionStatus( hImc, &dwConversion, &dwSentence );
		dwSentence |= IME_SMODE_SINGLECONVERT;
		ImmSetConversionStatus( hImc, dwConversion, dwSentence );
		ImmReleaseContext( wnd, hImc );
		*/
	}
	break;
	case WM_CHAR:
	case WM_IME_CHAR:
		return 0;
	case WM_IME_STARTCOMPOSITION:
	{
		/*
		if (UIMAN && !UIMAN->GetFocusedNode())
		{
			HIMC hImc = ImmGetContext(wnd);
			ImmNotifyIME(hImc, NI_COMPOSITIONSTR, CPS_CANCEL, 0);
			ImmReleaseContext(wnd, hImc);
		}
			*/
	}
	return 0;
	case WM_TIMER:
	{
		///
		//NETWORK->SendHeartbeat();
	}
	break;
	//case WM_SOCKEVENTMSG2:
	//	NETWORK->Process(wparam, lparam);
	//	break;
	case WM_ACTIVATEAPP:
	{
		if (THEAPP)
		{
			if (wparam == TRUE)
			{
				THEAPP->SetActive(true);
			}
			else
			{
				THEAPP->SetActive(false);
#if !(defined(_DEVSYS) || defined(_DEBUG))
				if (GetForegroundWindow() != wnd)
					::SetWindowPos(wnd, GetForegroundWindow(), 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE | SWP_NOACTIVATE);
#endif
			}
		}
	}
	break;
	case WM_ACTIVATE:
	{
		if (THEAPP)
		{
			if (wparam == WA_INACTIVE)
			{
				THEAPP->SetActive(false);

#if !(defined(_DEVSYS) || defined(_DEBUG))
				if (GetForegroundWindow() != wnd)
					::SetWindowPos(wnd, GetForegroundWindow(), 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE | SWP_NOACTIVATE);
#endif
			}
			else
			{
				THEAPP->SetActive(true);
			}
		}
	}
	break;
	case WM_SETCURSOR:
	{
		/*
		if (CURSOR != NULL)
		{
			CURSOR->Process(0);
		}
		*/
	}
	break;
	//case WM_IME_SETCONTEXT:
	//	{
	////		// ݵ DefWindowProc Ѵ ( ĺ   )
	////		/*if( wparam == TRUE )
	////		{
	//			lparam &= ~( ISC_SHOWUICOMPOSITIONWINDOW );
	////		}

	//		::DefWindowProc( wnd, WM_IME_SETCONTEXT, wparam, lparam);

	//		//::DefWindowProc( wnd, WM_IME_SETCONTEXT, true, ISC_SHOWUICANDIDATEWINDOW );
	//		return 0;
	//	}
	//	break;
	case WM_SYSCOMMAND:
		switch (wparam)
		{
		case SC_MOVE:
		case SC_SIZE:
		case SC_MAXIMIZE:
		case SC_MONITORPOWER:
		{
			/*
			if (RENDERSYS && RENDERSYS->IsFullScreenMode())
			{
				return 1;
			}
			*/
		}
		return 0;
		case SC_KEYMENU:
		{
			return 1;
		}
		case SC_MINIMIZE:
		{
			THEAPP->SetMinimize(true);
		}
		break;
		case SC_RESTORE:
		{
			THEAPP->SetMinimize(false);
		}
		break;
		case SC_PREVWINDOW: /// alt + f6  ´.
			return 0;
		}
		break;
		/// ޴ PC  ϴ 쿡  ó
	case WM_POWERBROADCAST:
	{
		switch (wparam)
		{
#ifndef	PBT_APMQUERYSUSPEND
#define	PBT_APMQUERYSUSPEND 0x0000
#endif
		case PBT_APMQUERYSUSPEND:
			return true;
#ifndef	PBT_APMRESUMESUSPEND
#define PBT_APMRESUMESUSPEND 0x0007
#endif
		case PBT_APMRESUMESUSPEND:
			return true;
		}
	}
	break;
	case WM_MOVE:
	{
#ifdef _GMTOOL
		if (GMTOOL)
			GMTOOL->OnMove();
#endif
	}
	break;

	case WM_CLOSE:
	case WM_DESTROY:
	{
		::PostQuitMessage(0);
	}
	return 0;
	case WM_DISPLAYCHANGE:
	{
		///  ػ  üũ
		unsigned int width = LOWORD(lparam);
		unsigned int height = HIWORD(lparam);
		unsigned int bpp = wparam;

		// if (RENDERSYS)
			// RENDERSYS->SetMonitorDisplay(width, height, bpp);
	}
	break;
	}

	return ::DefWindowProc(wnd, msg, wparam, lparam);
}

void MainApp::SetActive(bool active)
{
}

bool MainApp::Init(NiInstanceRef hi)
{
	//filesystem

	//sound system
	if (!CreateMainWindow())
	{
		NiMessageBox("Failed to create window.", "Error");
		return false;
	}
	//sound system ->set hwnd

	//option manager

	//render system

	//resource manager

	//cursor

	//input system

	mpTimer = new AppTimer;
	if (!mpTimer)
	{
		return false;
	}
	mpTimer->Reset();

	//camera manager

	//scene manager

	//stage manager

	mpTimer->Start();

	// mpWindow->AdjustWindowForChange(mpRenderSystem->IsFullScreenMode());
	// mpWindow->AdjustWindowRect(mpRenderSystem->GetScreenWidth(), mpRenderSystem->GetScreenHeight(), true);

	// UpdateScreenSize(mpRenderSystem->GetScreenWidth(), mpRenderSystem->GetScreenHeight(), mpRenderSystem->GetScreenBpp(), !mpRenderSystem->IsFullScreenMode());

	//
	// ::ShowWindow(THEAPP->GetHWND(), SW_SHOW);

	DWORD topID = GetWindowThreadProcessId(GetForegroundWindow(), NULL);
	DWORD curID = GetCurrentThreadId();

	if (topID != curID)
	{
		if (AttachThreadInput(topID, curID, TRUE))
		{
			BringWindowToTop(THEAPP->GetHWND());
			AttachThreadInput(topID, curID, FALSE);
		}
	}
	else
	{
		BringWindowToTop(THEAPP->GetHWND());
	}


	return true;
}

void MainApp::Run()
{
	MainLoop();
}

void MainApp::Exit()
{
	// todo
	if (mpTimer)
		mpTimer->Stop();
}

void MainApp::Invalidate()
{
	//if (mpRenderSystem)
		// mpRenderSystem->Invalidate();
}

void MainApp::Restore()
{
	// if (mpRenderSystem)
		// mpRenderSystem->Restore();
}

void MainApp::UpdateScreenSize(unsigned int width, unsigned int height, unsigned char bpp, bool windowed)
{
	// mpRenderSystem->Reset(width, height, bpp, windowed);
}

bool MainApp::CreateMainWindow()
{
	/// 츦 
	WNDCLASS wndclass;
	wndclass.style = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wndclass.lpfnWndProc = WinProc;
	wndclass.cbClsExtra = 0;
	wndclass.cbWndExtra = 0;
	wndclass.hInstance = mpInstance;
	//todo: figure out icon embedding
	//wndclass.hIcon = ::LoadIcon(mpInstance, MAKEINTRESOURCE(IDR_MAINFRAME));
	//wndclass.hCursor = ::LoadCursor(mpInstance, IDC_ARROW);
	wndclass.hbrBackground = static_cast<HBRUSH>(::GetStockObject(NULL_BRUSH));
	wndclass.lpszClassName = AppWindow::GetWindowClassName();
	wndclass.lpszMenuName = nullptr;

	if (::RegisterClass(&wndclass) == 0)
	{
		NiMessageBox("Can't Create Window!", "Error!!");
		return false;
	}

	NiWindowRef hWnd = mpWindow->Create(mpInstance, 0, 0);

	//mVersion.Format(_T("v%d.%.2d.%d"), LOBYTE(VERSION_HEADER), HIBYTE(VERSION_HEADER), BUILD_NUM);

	// cStringT str;
	// str.Format(_T("IRIS ONLINE %s"), mVersion.Cstr());

	std::string str("Ignite Project");
	::SetWindowText(hWnd, str.c_str());

	return true;
}

void MainApp::MainLoop()
{
	if (!mIsActive)
	{
		NiSleep(1);
	}

	mDeltaTime = mpTimer->GetDeltaTime();
	mAccumTime += mDeltaTime;

	NiMessageBox("hi", "hi");

	//mpInputSystem->Process();
}

void MainApp::Process()
{
}

void MainApp::Render()
{
}

/**
 * \brief Displays splash screen with progress bar
 * \param pcBGPath Splash background image path
 * \param pcPBPath Splash progress bar image path
 * \param ProgPercentage Progress bar percentage (0-100)
 */
void MainApp::DisplaySplash(const char* pcBGPath, const char* pcPBPath, int ProgPercentage, AppWindow *window, Renderer *renderer) const
{
    const float fDesiredAspect = 4.0f/3.0f;
	const float fAspect = static_cast<float>(window->GetWidth())/static_cast<float>(window->GetHeight());
    if (NiAbs(fAspect - fDesiredAspect) > 0.01f)
    {
            // bad aspect ratio
            NiOutputDebugString("AW: Splash aspect incorrect.\n");
    }

	const auto pkSplashData = NiNew NiScreenElementsData(false, true, 1);
	const auto pkProgressBarData = NiNew NiScreenElementsData(false, true, 1);

	auto* pkSplash = NiNew NiScreenElements(pkSplashData);
	auto* pkProgressBar = NiNew NiScreenElements(pkProgressBarData);

    pkSplash->Insert(4);
    pkProgressBar->Insert(4);
 
    pkSplash->SetRectangle(0, 0.0f, 0.0f, 1.0f, 1.0f);
    pkProgressBar->SetRectangle(0, 0.2773475f, 0.7552f, static_cast<float>(ProgPercentage)/100 * 0.5f, 0.015f); // screen
 
    pkSplash->UpdateBound();
    pkProgressBar->UpdateBound();
 
    pkSplash->SetColors(0, NiColorA::WHITE);
    pkProgressBar->SetColors(0, NiColorA::WHITE);
 
    pkSplash->SetTextures(0, 0, 0.0f, 0.0f, 1.0f, 1.0f); // texture
    pkProgressBar->SetTextures(0,0,0.0f,0.0f,static_cast<float>(ProgPercentage)/100, 1.0f);

    // textures
	auto* pkTex = NiNew NiTexturingProperty(pcBGPath);
    pkTex->SetBaseClampMode(NiTexturingProperty::CLAMP_S_CLAMP_T);

	auto* pkProgressBarTex = NiNew NiTexturingProperty(pcPBPath);
    pkProgressBarTex->SetBaseClampMode(NiTexturingProperty::CLAMP_S_CLAMP_T);
 
    pkSplash->AttachProperty(pkTex);
    pkProgressBar->AttachProperty(pkProgressBarTex);
 
    // use vertex colors
	auto* pkVertex = NiNew NiVertexColorProperty;
    pkVertex->SetSourceMode(NiVertexColorProperty::SOURCE_EMISSIVE);
    pkVertex->SetLightingMode(NiVertexColorProperty::LIGHTING_E);
 
    pkSplash->AttachProperty(pkVertex);
    pkProgressBar->AttachProperty(pkVertex);
 
    // no alpha blending
	auto* pkAlpha = NiNew NiAlphaProperty;
    pkAlpha->SetAlphaBlending(false);
 
    pkSplash->AttachProperty(pkAlpha);
    pkProgressBar->AttachProperty(pkAlpha);
 
    pkSplash->UpdateProperties();
    pkSplash->Update(0.0f);
 
    pkProgressBar->UpdateProperties();
    pkProgressBar->Update(0.0f);
 
    renderer->BeginFrame();
    renderer->BeginUsingDefaultRenderTargetGroup(NiRenderer::CLEAR_ALL);
    renderer->SetScreenSpaceCameraData();

    pkSplash->RenderImmediate(renderer);
    pkProgressBar->RenderImmediate(renderer);
 
   renderer->EndUsingRenderTargetGroup();
   renderer->EndFrame();
   renderer->DisplayFrame();
 
   delete pkSplash;
   delete pkProgressBar;
}