// Copyright 2018 RED Software, LLC. All Rights Reserved.
#pragma once
#include "stdafx.h"
#include "Renderer.h"

class AppWindow;
class AppTimer;

class MainApp
{
	static MainApp* mpSingleton;

public:
	MainApp();
	~MainApp();

	static MainApp* GetSingleton();

	static MainApp* Create();

	static LRESULT CALLBACK	WinProc(HWND wnd, UINT msg, WPARAM wparam, LPARAM lparam);

	bool IsActive() { return mIsActive; }
	void SetActive(bool active);

	void SetMinimize(bool mini) { mIsMinimize = mini; }

	bool Init(NiInstanceRef hi);

	void Run();
	void Exit();

	void UpdateScreenSize(unsigned int width, unsigned int height, unsigned char bpp, bool windowed);

	void Invalidate();
	void Restore();

	bool IsReset() { return mResetFlag; }

	unsigned long GetWorldAccumTime() { return mAccumTime; }
	unsigned long GetWorldDeltaTime() { return mDeltaTime; }

	AppWindow* GetAppWindow() const { return mpWindow; }

	HWND GetHWND();
	HINSTANCE GetWindowInstance();

private:
	void DisplaySplash(const char* pcName, const char* pcProgressBarName, int LoadingRate, AppWindow *window, Renderer *renderer) const;

	bool CreateMainWindow();
	
	void MainLoop();

	void Process();
	void Render();

	NiInstanceRef mpInstance;

	AppWindow* mpWindow;
	AppTimer* mpTimer;

	bool mIsActive;
	bool mIsMinimize;

	unsigned long mAccumTime;
	unsigned long mDeltaTime;

	bool mResetFlag;
};

inline
MainApp* MainApp::GetSingleton()
{
	return mpSingleton;
}

#define THEAPP MainApp::GetSingleton()