#pragma once
#include "Lexer.h"

class OptionLexer : Lexer
{
public:
	OptionLexer(const char* pBuffer, unsigned int size);
};

struct GameOption
{
	union
	{
		struct
		{
			bool showName : 1;
			bool showSP : 1;
			bool showMonsterName : 1;
		} option1;
		long optionData1;
	};
};

class OptionManager
{
	static OptionManager* singleton; 

public:
	OptionManager();
	virtual ~OptionManager();

	static OptionManager* GetSingleton();

	bool Init();

	void SetOptionValue(long option1);
	void ReqOptionValue();
	GameOption* GetGameOption() { return &gameOption; }

	void SetWindowedOption(bool pWindowed, unsigned int pWidth, unsigned int pHeight, unsigned char pBpp);
	void SetVolume(float pEnv, float pEff);
	void SetWindowedNoReset(bool pWindowed) { windowed = pWindowed; }

	// retrievals

	bool IsWindowed() { return windowed; }
	unsigned int GetWindowWidth() { return width; }
	unsigned int GetWindowHeight() { return height; }
	unsigned char GetWindowBpp() { return bpp; }

protected:
	bool Save(const char* pPathName);
	bool Load(const char* pPathName);

	bool windowed;
	unsigned int width;
	unsigned int height;
	unsigned char bpp;
	float gamma;

	float envVolume;
	float effVolume;

	GameOption gameOption;
};

inline void OptionManager::SetOptionValue(long option1)
{
	gameOption.optionData1 = option1;
}

inline OptionManager* OptionManager::GetSingleton()
{
	return singleton;
}

#define OPTIONMAN	OptionManager::GetSingleton()