// Copyright 2018 RED Software, LLC. All Rights Reserved.
#pragma once

#include "Renderer.h"

class AppWindow;
class FontAgent;
class LightAgent;
class FogAgent;
class SceneManager;

class BrightShader;

const unsigned int DEFAULT_WIDTH = 1024;
const unsigned int DEFAULT_HEIGHT = 768;
const unsigned int DEFAULT_BPP = 32;
/*
class PostProcess
{
public:
	PostProcess();
	~PostProcess();

	bool Init(Renderer* r);
	void Recreate(Renderer* r, unsigned int width, unsigned int height, unsigned char bpp);

	void Render(Renderer* r);

	NiRenderTargetGroup* GetRenderTarget() { return renderTargetGroup; }

protected:
	void RenderImmediate(Renderer* r);

	LPDIRECT3DVERTEXDECLARATION9 vertexDeclaration;
	LPDIRECT3DVERTEXBUFFER9 posCoordBuffer;
	LPDIRECT3DVERTEXBUFFER9 texCoordBuffer;

	NiRenderedTexturePtr renderedTexture;
	NiRenderTargetGroupPtr renderTargetGroup;

public:
	BrightShader* shader;
};

*/

class RenderSystem
{
	static RenderSystem* mpSingleton;

public:
	/// ü 
	static RenderSystem* GetSingleton();

public:
	RenderSystem(AppWindow* pwindow);
	~RenderSystem();

	struct sRenderOption
	{
		unsigned int Width;
		unsigned int Height;
		unsigned char Bpp;

		/// Gamebryo Option
		unsigned int Flags;
					 
		unsigned int Adapter;

		NiDX9Renderer::DeviceDesc DevDesc;

		NiDX9Renderer::FrameBufferFormat FBformat;

		NiDX9Renderer::DepthStencilFormat DSformat;

		NiDX9Renderer::PresentationInterval Interval;

		NiDX9Renderer::SwapEffect SwapEffect;

		unsigned int FBmode;
					 
		unsigned int Backbuffercount;
					 
		unsigned int Refreshrate;

		sRenderOption()
		{
			Width = 1024;
			Height = 768;
			Bpp = 32;

			Flags = NiDX9Renderer::USE_FULLSCREEN | NiDX9Renderer::USE_STENCIL | NiDX9Renderer::USE_MULTITHREADED;

			Adapter = D3DADAPTER_DEFAULT;
			DevDesc = NiDX9Renderer::DEVDESC_PURE;
			FBformat = NiDX9Renderer::FBFMT_X8R8G8B8;
			DSformat = NiDX9Renderer::DSFMT_D24S8;
			Interval = NiDX9Renderer::PRESENT_INTERVAL_IMMEDIATE;
			SwapEffect = NiDX9Renderer::SWAPEFFECT_DISCARD;
			FBmode = NiDX9Renderer::FBMODE_LOCKABLE;
			//			FBmode				= NiDX9Renderer::FBMODE_MULTISAMPLES_4;
			Backbuffercount = 1;
			Refreshrate = NiDX9Renderer::REFRESHRATE_DEFAULT;
		}
	};

	bool Init();

	void Exit();

	bool RenderOnce(NiTexture* tex);

	void Render();

	bool Reset(unsigned int width, unsigned int height, unsigned char bpp, bool winmode);

	void Invalidate();
	void Restore();

	inline void	SetClearColor(NiColorA color) { mClearColor = color; }

	void			ToggleFullScreenMode();

	Renderer* GetRenderer() const;

	inline AppWindow* GetWindowRef() { return mpWindowRef; }
	inline sRenderOption* GetOption() { return &mRenderOption; }
	inline unsigned int	GetScreenWidth() { return mRenderOption.Width; }
	inline unsigned int	GetScreenHeight() { return mRenderOption.Height; }
	inline unsigned char GetScreenBpp() { return mRenderOption.Bpp; }

	//inline Array<void*>*			GetResolutionArr() { return &mResolutionArr; };
	inline NiDX9AdapterDesc::ModeDesc* GetCurrentMode() { return mCurrentMode; }
	inline NiDX9AdapterDesc* GetCurrentAdapter() { return mCurrentAdapter; }

	inline const bool IsFullScreenMode() { return (mRenderOption.Flags & NiDX9Renderer::USE_FULLSCREEN) ? true : false; }

	HWND GetHWND();

	bool mReCreateContinue;
	unsigned long mReCreateTime;

	void SetWorldRendering(bool set) { mWorldRendering = set; }

	void SetBrightness(float br);

	inline unsigned int	GetMonitorWidth() { return mMonWidth; }
	inline unsigned int	GetMonitorHeight() { return mMonHeight; }
	void SetMonitorDisplay(unsigned int width, unsigned int height, unsigned int bpp);

	void ToggleVideoCapture();
	void SaveScreenShot();
	bool IsVideoCapturing();

	/// post process
protected:

	//PostProcess * mPostProcess;

private:
	bool CreateRenderer();

	bool EnumAdapters();
	void EnumResolutions(unsigned int curWidth, unsigned int curheight, unsigned int curBpp, bool windowed);
	void EnumMultisamples();

private:

	/// monitor resolution
	unsigned int mMonWidth;
	unsigned int mMonHeight;
	unsigned int mMonBpp;

	sRenderOption mRenderOption;

	RendererPtr mRenderer;

	AppWindow* mpWindowRef;

	FontAgent* mpFontAgent;

	LightAgent* mpLightAgent;

	FogAgent* mpFogAgent;

	NiColorA mClearColor;

	typedef NiTArray<void*, void*>	Array;

	/// adapter and device
	Array	mAdapterArr;
	NiDX9AdapterDesc* mCurrentAdapter;
	NiDX9DeviceDesc* mCurrentDevice;

	/// mode
	Array	mResolutionArr;
	NiDX9AdapterDesc::ModeDesc*	mCurrentMode;

	/// multi sample
	Array	mMultisampleArr;

	bool mWorldRendering;

	TCHAR mVideoPathName[MAX_PATH];
	unsigned long mVideoCaptureTime;
};