// Copyright 2018 RED Software, LLC. All Rights Reserved.
#pragma once
#include <NiDX9Renderer.h>
#include <string>

class Renderer : public NiDX9Renderer
{
public:
	Renderer();
	virtual ~Renderer();

	static Renderer* Create(unsigned int uiWidth, unsigned int uiHeight,
		unsigned int uiUseFlags, NiWindowRef kWndDevice,
		NiWindowRef kWndFocus, unsigned int uiAdapter = D3DADAPTER_DEFAULT,
		DeviceDesc eDesc = DEVDESC_PURE,
		FrameBufferFormat eFBFormat = FBFMT_UNKNOWN,
		DepthStencilFormat eDSFormat = DSFMT_UNKNOWN,
		PresentationInterval ePresentationInterval = PRESENT_INTERVAL_ONE,
		SwapEffect eSwapEffect = SWAPEFFECT_DISCARD,
		unsigned int uiFBMode = FBMODE_LOCKABLE,
		unsigned int uiBackBufferCount = 1,
		unsigned int uiRefreshRate = REFRESHRATE_DEFAULT);

	bool Init();

	LPDIRECT3DVERTEXBUFFER9 CreateVertexBuffer(unsigned int vertexCount, unsigned int vertexStride, const void* data);
	LPDIRECT3DINDEXBUFFER9 CreateIndexBuffer(unsigned int indexCount, const unsigned short* indexArray);

	LPD3DXEFFECT GetTerrainEffect() const;
	LPD3DXEFFECT GetTrailEffect() const;
	LPD3DXEFFECT GetBrightEffect() const;

	D3DXMATRIX GetD3DViewProj() const;

	void OnLostDevice();
	void OnResetDevice();

protected:
	bool CreateEffect(const std::string& pathName, LPD3DXEFFECT* effect);

	LPD3DXEFFECT mTerrainEffect;
	LPD3DXEFFECT mTrailEffect;
	LPD3DXEFFECT mBrightEffect;
};

inline
LPD3DXEFFECT Renderer::GetTerrainEffect() const
{
	return mTerrainEffect;
}

inline
LPD3DXEFFECT Renderer::GetTrailEffect() const
{
	return mTrailEffect;
}

inline
LPD3DXEFFECT Renderer::GetBrightEffect() const
{
	return mBrightEffect;
}

inline 
D3DXMATRIX Renderer::GetD3DViewProj() const
{
	D3DXMATRIX view( GetD3DView() );
	D3DXMATRIX proj( GetD3DProj() );
	return view * proj;
}

typedef NiPointer<Renderer> RendererPtr;
