#pragma once
#include <D3DX9Math.h>

class Camera;
class LightSceneNode;

class Shader
{
public:
	Shader();

	virtual void Init(LPD3DXEFFECT effect);

	bool Begin(Camera* cam, const D3DXMATRIX& worldViewProj);
	void End();

	void CommitChanges();
	void SetAmbientLight(NiAmbientLight* ambientLight);
	void SetFog(NiFogProperty* fogProp);

	//void SetTexture( LPDIRECT3DBASETEXTURE9 tex );

protected:
	virtual void SetEffect();

protected:
	Camera * camera;
	LPD3DXEFFECT effect;
	D3DXHANDLE hTechnique;
	D3DXHANDLE hWorldViewProj;
	D3DXHANDLE hAmbientLight;
	D3DXHANDLE hFogColor;
	D3DXHANDLE hFogEnd;
	D3DXHANDLE hFogRange;
	//D3DXHANDLE mHTexture;
};

inline
void Shader::CommitChanges()
{
	effect->CommitChanges();
}

///  ̴
class cTerrainShader : public Shader
{
public:
	cTerrainShader();

	/// ʱȭ
	void Init(LPD3DXEFFECT effect);

	///
	void SetOrigin(float x, float y);
	void SetPointLight(LightSceneNode* light);

protected:
	virtual void SetEffect();

protected:
	D3DXHANDLE mHOrgX;
	D3DXHANDLE mHOrgY;
	D3DXHANDLE mHPointLightPos;
	D3DXHANDLE mHPointLightDiffuse;
	D3DXHANDLE mHPointLightAtten;
};

class cBrightShader
{
public:
	cBrightShader();

	void Init(LPD3DXEFFECT effect);

	bool Begin(const D3DXMATRIX& worldViewProj);
	void End();

	///
	void CommitChanges();

	void SetBright(float br);

	///
protected:
	LPD3DXEFFECT mEffect;
	D3DXHANDLE mHTechnique;
	D3DXHANDLE mHWorldViewProj;
	D3DXHANDLE mHBright;
};

inline
void cBrightShader::CommitChanges()
{
	mEffect->CommitChanges();
}


/// ̳ʸ ̴
#include <NiBinaryShader.h>
class cBinaryShader : public NiBinaryShader
{
public:
	bool Initialize(const std::string& path);

protected:
	bool LoadVertexShaderProgram(NiD3DPass& pass, const std::string& path);
	bool LoadPixelShaderProgram(NiD3DPass& pass, const std::string& path);

protected:
	std::string mPath;
};

/// NSB ̴
#include <NSBShader.h>

class cNSBShader : public NSBShader
{
public:
	// Get the BINARY shader
	NiBinaryShader * GetBinaryShader(NiD3DRenderer* renderer, const std::string& path, unsigned int implementation = NiShader::DEFAULT_IMPLEMENTATION);
};

typedef NiPointer<cNSBShader> cNSBShaderPtr;
