// Copyright 2018 RED Software, LLC. All Rights Reserved.
#pragma once
#define WIN32_LEAN_AND_MEAN		// Exclude rarely used data from the Windows header
// Windows header files:
#include <Windows.h>
#include <d3d9.h>

// Gamebryo specific
#include <NiDX9Renderer.h>
#include <NiParticle.h>
//#include <NiCollision.h>
#include <NiAnimation.h>
#include <NiMemStream.h>
#include <NiD3DUtility.h>

#include <NiApplicationMetrics.h>
#include <NiDX9RendererMetrics.h>
#include <NiD3DShaderProgramFactory.h>
#include <NiDX9RenderedTextureData.h>
#include <NiRenderedTexture.h>
#include <NiDX9SystemDesc.h>
#include <NiAmbientLight.h>

#include <hash_map>
#include <deque>
#include <queue>
#include <vector>
#include <string>
#include <ctime>

#include <tchar.h>
#include <atlstr.h>

#define SAFE_DELETE(x) if(x) { delete x; x = NULL; }
#define SAFE_DELETE_ARRAY(x) if(x) { delete[] x; x = NULL; }
#define SAFE_RELEASE(x) if(x) { x->Release(); x = NULL; }
#define SAFE_NIDELETE(x) if(x) { NiDelete x; x = NULL; }
#define SAFE_EXIT_DELETE(x) if(x) { x->Exit(); delete x; x = NULL; }