﻿// Copyright 2018 RED Software, LLC. All Rights Reserved.

using System.Collections.Generic;

namespace IgniteEngine
{
    /// <summary>
    /// Class that extends the use of the List class.
    /// </summary>
    public static class ListExtensions
    {
        /// <summary>
        /// Copies the elements from the source list to the output list.
        /// </summary>
        /// <param name="source">The source list.</param>
        /// <param name="output">The output list.</param>
        public static void Copy<T>(this List<T> source, out List<T> output)
        {
            output = new List<T>(source);
        }
    }
}
