﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ScriptNET.Runtime.Operators
{
  public class MinusOperator : BinaryOperator
  {
    public MinusOperator() :
      base("-")
    {
      RegisterEvaluator(typeof(Int16), typeof(Int16), (x, y) => (Int16)x - (Int16)y);
      RegisterEvaluator(typeof(Int16), typeof(Int32), (x, y) => (Int16)x - (Int32)y);
      RegisterEvaluator(typeof(Int16), typeof(Int64), (x, y) => (Int16)x - (Int64)y);
      RegisterEvaluator(typeof(Int16), typeof(double), (x, y) => (Int16)x - (double)y);
      RegisterEvaluator(typeof(Int16), typeof(float), (x, y) => (Int16)x - (float)y);
      RegisterEvaluator(typeof(Int16), typeof(decimal), (x, y) => (Int16)x - (decimal)y);

      RegisterEvaluator(typeof(Int32), typeof(Int16), (x, y) => (Int32)x - (Int16)y);
      RegisterEvaluator(typeof(Int32), typeof(Int32), (x, y) => (Int32)x - (Int32)y);
      RegisterEvaluator(typeof(Int32), typeof(Int64), (x, y) => (Int32)x - (Int64)y);
      RegisterEvaluator(typeof(Int32), typeof(double), (x, y) => (Int32)x - (double)y);
      RegisterEvaluator(typeof(Int32), typeof(float), (x, y) => (Int32)x - (float)y);
      RegisterEvaluator(typeof(Int32), typeof(decimal), (x, y) => (Int32)x - (decimal)y);

      RegisterEvaluator(typeof(Int64), typeof(Int16), (x, y) => (Int64)x - (Int16)y);
      RegisterEvaluator(typeof(Int64), typeof(Int32), (x, y) => (Int64)x - (Int32)y);
      RegisterEvaluator(typeof(Int64), typeof(Int64), (x, y) => (Int64)x - (Int64)y);
      RegisterEvaluator(typeof(Int64), typeof(double), (x, y) => (Int64)x - (double)y);
      RegisterEvaluator(typeof(Int64), typeof(float), (x, y) => (Int64)x - (float)y);
      RegisterEvaluator(typeof(Int64), typeof(decimal), (x, y) => (Int64)x - (decimal)y);

      RegisterEvaluator(typeof(double), typeof(Int16), (x, y) => (double)x - (Int16)y);
      RegisterEvaluator(typeof(double), typeof(Int32), (x, y) => (double)x - (Int32)y);
      RegisterEvaluator(typeof(double), typeof(Int64), (x, y) => (double)x - (Int64)y);
      RegisterEvaluator(typeof(double), typeof(double), (x, y) => (double)x - (double)y);
      RegisterEvaluator(typeof(double), typeof(float), (x, y) => (double)x - (float)y);

      RegisterEvaluator(typeof(float), typeof(Int16), (x, y) => (float)x - (Int16)y);
      RegisterEvaluator(typeof(float), typeof(Int32), (x, y) => (float)x - (Int32)y);
      RegisterEvaluator(typeof(float), typeof(Int64), (x, y) => (float)x - (Int64)y);
      RegisterEvaluator(typeof(float), typeof(double), (x, y) => (float)x - (double)y);
      RegisterEvaluator(typeof(float), typeof(float), (x, y) => (float)x - (float)y);

      RegisterEvaluator(typeof(decimal), typeof(Int16), (x, y) => (decimal)x - (Int16)y);
      RegisterEvaluator(typeof(decimal), typeof(Int32), (x, y) => (decimal)x - (Int32)y);
      RegisterEvaluator(typeof(decimal), typeof(Int64), (x, y) => (decimal)x - (Int64)y);
      RegisterEvaluator(typeof(decimal), typeof(decimal), (x, y) => (decimal)x - (decimal)y);
    }
  }
}
