﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ScriptNET.Runtime.Operators
{
  public abstract class BinaryOperator : IOperator
  {
    protected delegate object evaluator(object left, object right);
    private Dictionary<Type, Dictionary<Type, evaluator>> operators = new Dictionary<Type, Dictionary<Type, evaluator>>();

    public BinaryOperator(string name)
    {
      Name = name;      
    }

    #region IOperator Members

    public virtual string Name
    {
      get;
      private set;
    }

    public object Evaluate(object left, object right)
    {
      evaluator function;
      try
      {
        function = operators[left.GetType()][right.GetType()];
      }
      catch(KeyNotFoundException)
      {
        throw new NotSupportedException("Operator does not support given arguments"); 
      }

      return function(left, right);
    }

    protected void RegisterEvaluator(Type left, Type right, evaluator eval)
    {
      if (operators.ContainsKey(left))
      {
        operators[left].Add(right, eval);         
      }
      else
      {
        Dictionary<Type, evaluator> op = new Dictionary<Type, evaluator>();
        op.Add(right, eval);

        operators.Add(left, op);
      }
    }

    protected void RegisterEvaluator<TL, TR>(evaluator eval)
    {
      RegisterEvaluator(typeof(TL), typeof(TR), eval);
    }
    #endregion

    #region Unary functions
    public bool Unary
    {
      get { return false; }
    }

    public object Evaluate(object value)
    {
      throw new NotImplementedException();
    }
    #endregion
  }
}
