﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using System.Text;
using HändlerEditor.XAML;

namespace HändlerEditor.Code
{
    public static class DataProvider
    {
        public static void Initialize()
        {
            Items = new List<Item>();

            // TODO: Read Data from SHN's!
            SHNFile ItemInfo = new SHNFile(Settings.DataPath + "\\ItemInfo.shn");
            SHNFile ItemViewInfo = new SHNFile(Settings.DataPath + "\\ItemViewInfo.shn");

            foreach (DataRow iiRow in ItemInfo.table.Rows)
            {
                DataRow r = ItemViewInfo.table.Rows.Cast<DataRow>().FirstOrDefault(iviRow => iiRow["InxName"].Equals(iviRow["InxName"]));

                if (r == null)
                    continue;

                Item i = new Item
                             {
                                 ID = (ushort) iiRow["ID"],
                                 InxName = (string) iiRow["InxName"],
                                 Name = (string) iiRow["Name"],
                                 DemandLevel = (uint) iiRow["DemandLv"],
                                 IconFile = ((string) r["IconFile"]).ToLower(),
                                 IconIndex = (uint) r["IconIndex"]
                             };

                Items.Add(i);
            }
        }

        public static List<Item> Items;
    }
}
