﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Imaging;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using Fiesta.FileFormats;

namespace SHBDEditor
{
	public partial class fSHBDEditor : Form
	{
		SHBD shbd;

		public fSHBDEditor()
		{
			InitializeComponent();
		}

		private void menuItemMenuFileOpen_Click(object sender, EventArgs e)
		{
			OpenFileDialog openFileDialog = new OpenFileDialog();

			openFileDialog.Title = "Open SHBD File";
			openFileDialog.Filter = "SHBD Files|*.shbd";

			openFileDialog.InitialDirectory = @"D:\Games\Fiesta\CN_Mix\resmap\field\Eld";

			DialogResult dialogResult = openFileDialog.ShowDialog();

			if (dialogResult == DialogResult.OK)
			{
				shbd = SHBD.Load(openFileDialog.FileName);

				pbSHBD.Image = shbd.Export();

				miMenuFileExport.Enabled = true;

				var imageSize = pbSHBD.Image.Size;
				var fitSize = pbSHBD.ClientSize;

				if (pbSHBD.Image.Size.Width > pbSHBD.ClientSize.Width || pbSHBD.Image.Size.Height > pbSHBD.ClientSize.Height)
				{
					pbSHBD.SizeMode = PictureBoxSizeMode.Zoom;
				}
				else
				{
					pbSHBD.SizeMode = PictureBoxSizeMode.CenterImage;
				}
			}
		}

		private void miMenuFileExportBMP_Click(object sender, EventArgs e)
		{
			SaveFileDialog saveFileDialog = new SaveFileDialog();

			saveFileDialog.Title = "Save BMP File";
			saveFileDialog.Filter = "BMP Files|*.bmp";

			saveFileDialog.InitialDirectory = @"D:\Games\Fiesta\CN_Mix\resmap\field\Eld";

			DialogResult dialogResult = saveFileDialog.ShowDialog();

			if (dialogResult == DialogResult.OK)
			{
				shbd.Export(saveFileDialog.FileName, ImageFormat.Bmp);
			}
		}

		private void tbBackground_Enter(object sender, EventArgs e)
		{
			try
			{
				Color newColor = ColorTranslator.FromHtml(tttbViewBackground.Text);

				pbSHBD.BackColor = newColor;
			}
			catch
			{
				MessageBox.Show("Please enter a valid Color", "Invalid Color", MessageBoxButtons.OK, MessageBoxIcon.Warning);
			}
		}

		private void miMenuViewBackgroundColorPalette_Click(object sender, EventArgs e)
		{
			ColorDialog colorDialog = new ColorDialog();

			if (colorDialog.ShowDialog() == DialogResult.OK)
			{
				pbSHBD.BackColor = colorDialog.Color;
			}
		}
	}
}