/*
Navicat SQL Server Data Transfer

Source Server         : 88.198.10.166
Source Server Version : 105000
Source Host           : 88.198.10.166:1433
Source Database       : AccountLog
Source Schema         : dbo

Target Server Type    : SQL Server
Target Server Version : 105000
File Encoding         : 65001

Date: 2012-01-28 20:03:25
*/


-- ----------------------------
-- Table structure for [dbo].[tAccountLog]
-- ----------------------------

DROP TABLE [dbo].[tAccountLog]
GO
CREATE TABLE [dbo].[tAccountLog] (
[nLogNo] bigint NOT NULL IDENTITY(1,1) ,
[sUserID] nvarchar(16) NULL ,
[nType] tinyint NOT NULL ,
[nUserNo] int NULL ,
[nPlayMin] smallint NULL ,
[sUserPassword] nvarchar(16) NULL ,
[nWorldNo] tinyint NULL ,
[nErrorCode] smallint NULL ,
[sIP] varchar(16) NULL ,
[dDate] datetime NOT NULL DEFAULT (getdate()) 
)


GO
DBCC CHECKIDENT(N'[dbo].[tAccountLog]', RESEED, 110576)
GO

-- ----------------------------
-- Records of tAccountLog
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tEvent_Friend]
-- ----------------------------
DROP TABLE [dbo].[tEvent_Friend]
GO
CREATE TABLE [dbo].[tEvent_Friend] (
[nEventUserNo] int NOT NULL ,
[nEventCharNo] int NOT NULL ,
[nFriendUserNo] int NOT NULL ,
[nFriendCharNo] int NOT NULL ,
[nWorldNo] tinyint NOT NULL ,
[bEventComplete] tinyint NOT NULL DEFAULT ((0)) ,
[dDate] datetime NOT NULL DEFAULT (getdate()) 
)


GO

-- ----------------------------
-- Records of tEvent_Friend
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tEvent_Friend_HideMsg]
-- ----------------------------
DROP TABLE [dbo].[tEvent_Friend_HideMsg]
GO
CREATE TABLE [dbo].[tEvent_Friend_HideMsg] (
[nUserNo] int NOT NULL 
)


GO

-- ----------------------------
-- Records of tEvent_Friend_HideMsg
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tEventiPad]
-- ----------------------------
DROP TABLE [dbo].[tEventiPad]
GO
CREATE TABLE [dbo].[tEventiPad] (
[nUserNo] int NOT NULL ,
[nTicket] int NOT NULL ,
[sys_create_date] datetime NOT NULL DEFAULT (getdate()) ,
[sys_update_date] datetime NOT NULL DEFAULT (getdate()) 
)


GO

-- ----------------------------
-- Records of tEventiPad
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tEventWorldCup]
-- ----------------------------
DROP TABLE [dbo].[tEventWorldCup]
GO
CREATE TABLE [dbo].[tEventWorldCup] (
[nEventCharNo] int NOT NULL ,
[nEventUserNo] int NOT NULL ,
[nLevel] tinyint NOT NULL ,
[nWorldNo] tinyint NOT NULL 
)


GO

-- ----------------------------
-- Records of tEventWorldCup
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tIPBlock]
-- ----------------------------
DROP TABLE [dbo].[tIPBlock]
GO
CREATE TABLE [dbo].[tIPBlock] (
[sIPStart] nvarchar(20) NOT NULL ,
[sIPEnd] nvarchar(20) NOT NULL ,
[sDesc] nvarchar(30) NULL ,
[dDate] datetime NOT NULL DEFAULT (getdate()) 
)


GO

-- ----------------------------
-- Records of tIPBlock
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tLogout]
-- ----------------------------
DROP TABLE [dbo].[tLogout]
GO
CREATE TABLE [dbo].[tLogout] (
[rowNo] int NOT NULL IDENTITY(1,1) ,
[logDate] datetime NOT NULL DEFAULT (getdate()) ,
[worldNo] tinyint NULL ,
[userNo] int NOT NULL ,
[charNo] int NOT NULL ,
[class] tinyint NOT NULL ,
[level] tinyint NOT NULL ,
[experience] bigint NOT NULL ,
[playTime] smallint NOT NULL DEFAULT ((0)) 
)


GO
DBCC CHECKIDENT(N'[dbo].[tLogout]', RESEED, 73187)
GO

-- ----------------------------
-- Records of tLogout
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tReport]
-- ----------------------------
DROP TABLE [dbo].[tReport]
GO
CREATE TABLE [dbo].[tReport] (
[nRegNumber] int NOT NULL IDENTITY(1,1) ,
[nReporter] int NOT NULL ,
[sReporterCharID] nvarchar(16) NOT NULL ,
[nWorldNo] tinyint NOT NULL ,
[dReportDate] datetime NULL DEFAULT (getdate()) ,
[sHarmer] nvarchar(16) NULL ,
[sReportType] nvarchar(16) NULL ,
[sReason] nvarchar(512) NULL ,
[sChatLog] ntext NULL ,
[nResult] tinyint NULL DEFAULT ((0)) ,
[sRemark] nvarchar(128) NULL 
)


GO

-- ----------------------------
-- Records of tReport
-- ----------------------------
SET IDENTITY_INSERT [dbo].[tReport] ON
GO
SET IDENTITY_INSERT [dbo].[tReport] OFF
GO

-- ----------------------------
-- Table structure for [dbo].[tUser]
-- ----------------------------
DROP TABLE [dbo].[tUser]
GO
CREATE TABLE [dbo].[tUser] (
[userNo] int NULL ,
[gender] int NULL ,
[age] int NULL ,
[registerDate] datetime NULL 
)


GO

-- ----------------------------
-- Records of tUser
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tUserLog]
-- ----------------------------
DROP TABLE [dbo].[tUserLog]
GO
CREATE TABLE [dbo].[tUserLog] (
[rowNo] int NOT NULL IDENTITY(1,1) ,
[joinDate] nvarchar(10) NOT NULL ,
[userNo] int NOT NULL 
)


GO
DBCC CHECKIDENT(N'[dbo].[tUserLog]', RESEED, 2)
GO

-- ----------------------------
-- Records of tUserLog
-- ----------------------------
SET IDENTITY_INSERT [dbo].[tUserLog] ON
GO
SET IDENTITY_INSERT [dbo].[tUserLog] OFF
GO

-- ----------------------------
-- Procedure structure for [dbo].[p_AccountLog_Add]
-- ----------------------------
DROP PROCEDURE [dbo].[p_AccountLog_Add]
GO

CREATE PROCEDURE [dbo].[p_AccountLog_Add] 
/*
 Account log add
 input:
  로그에 기록될 정보들(See SQL)
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nType		tinyint,
@nUserNo	int,
@nWorldNo	tinyint,
@nPlayMin	smallint,
@nErrorCode smallint,
@sIP		varchar(16),
@sUserID	nvarchar(16),
@sUserPassword	nvarchar(16),
@nLogNo bigint OUTPUT
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tAccountLog  WITH (ROWLOCK) (  nType,  nUserNo,  nWorldNo,  nPlayMin,  nErrorCode,  sIP,  sUserID,  sUserPassword )
VALUES             ( @nType, @nUserNo, @nWorldNo, @nPlayMin, @nErrorCode, @sIP, @sUserID, @sUserPassword )
SET @nLogNo = @@IDENTITY
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_AccountLog_Get]
-- ----------------------------
DROP PROCEDURE [dbo].[p_AccountLog_Get]
GO

CREATE PROCEDURE [dbo].[p_AccountLog_Get] 
/*
  AccountLog Get - 주어진 조건에 맞는 로그를 모두검색해서 얻는다.
  input:
   - 주어진 조건절
  output:
   - Select된 데이타
*/
@WhereExpr nvarchar(256)
AS
SET NOCOUNT ON
DECLARE @SQLCMD nchar(512)
SET  @SQLCMD = N'SELECT nLogNo, dDate, nType, nUserNo, nWorldNo, nPlayMin, nErrorCode, sIP, sUserID, sUserPassword FROM tAccountLog WITH(NOLOCK) WHERE ' + @WhereExpr
EXEC sp_executesql @SQLCMD
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_AccountLog_GetCount]
-- ----------------------------
DROP PROCEDURE [dbo].[p_AccountLog_GetCount]
GO

CREATE PROCEDURE [dbo].[p_AccountLog_GetCount]
/*
  AccountLog Get Count - 주어진 조건에 맞는 로그를 모두검색해서 얻는다.
  input:
   - 주어진 조건절
  output:
   - @Count = 해당 조건에 만족하는 레코드수
*/
@WhereExpr nvarchar(256),
@Count int OUTPUT
AS
SET NOCOUNT ON
DECLARE @SQLCMD nvarchar(512)
SET @SQLCMD = N'SELECT @RowCount = COUNT(*) FROM tAccountLog  WITH(NOLOCK)  WHERE ' + @WhereExpr
EXEC sp_executesql @SQLCMD, N'@RowCount AS int OUTPUT', @RowCount = @Count OUTPUT
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_AccountLog_GetLog]
-- ----------------------------
DROP PROCEDURE [dbo].[p_AccountLog_GetLog]
GO

/*
'--------------------------------------------------------------------------------------
' 함수명 : p_AccountLog_GetLog
' 내  용 : OPTool 에서 사용. OPTool에서 입력한 쿼리문에 맞는 데이터 서치.
' 작성자 : 이병기
' 작성일 : 2005년 11월 7일
' 버  젼 : 1.0
' 인  자 :
'			input Parameter
'				@QueryExpr		: OPTool 에서 입력한 쿼리문
'			Output Parameter
'				
'			RETURN_VALUE
'
'--------------------------------------------------------------------------------------
*/
CREATE PROCEDURE [dbo].[p_AccountLog_GetLog]
	@QueryExpr nvarchar(256)
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @SQLCMD nvarchar(512)
	SET @SQLCMD = N'SELECT a.nLogNo, a.dDate, a.nUserNo, b.sUserID, a.nType, a.sIP, a.nPlayMin, a.sUserPassword, a.nErrorCode, a.nWorldNo
			  FROM tAccountLog  a INNER JOIN AccountDB.Account.dbo.tUser b ON a.nUserNo = b.nUserNo ' + @QueryExpr
	EXEC sp_executesql @SQLCMD
	SET NOCOUNT OFF
END


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_AccountLog_GetLogCount]
-- ----------------------------
DROP PROCEDURE [dbo].[p_AccountLog_GetLogCount]
GO

/*
'--------------------------------------------------------------------------------------
' 함수명 : p_AccountLog_GetLogCount
' 내  용 : OPTool 에서 사용. OPTool에서 입력한 쿼리문에 맞는 데이터의 개수를 얻어옴.
' 작성자 : 이병기
' 작성일 : 2005년 11월 7일
' 버  젼 : 1.0
' 인  자 :
'			input Parameter
'				@QueryExpr		: OPTool 에서 입력한 쿼리문
'			Output Parameter
				@Count			: 서치된 데이터의 개수
'				
'			RETURN_VALUE
'
'--------------------------------------------------------------------------------------
*/
CREATE PROCEDURE [dbo].[p_AccountLog_GetLogCount]
	@QueryExpr nvarchar(256),
	@Count int OUTPUT
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @SQLCMD nvarchar(512)
	SET @SQLCMD = N'SELECT @RowCount = COUNT(*)
			  FROM tAccountLog  a INNER JOIN AccountDB.Account.dbo.tUser b ON a.nUserNo = b.nUserNo ' + @QueryExpr
	EXEC sp_executesql @SQLCMD, N'@RowCount AS int OUTPUT', @RowCount = @Count OUTPUT
	SET NOCOUNT OFF
END


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Event_Friend_DelRequest]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Event_Friend_DelRequest]
GO





/*==================================================
@author	lenasoft
@date	2006-05-17
@return	0		<성공>
	others		<실패>
@brief	친구 케릭명 등록 삭제
==================================================*/

CREATE PROCEDURE [dbo].[p_Event_Friend_DelRequest]
@nEventUserNo 	int,
@err 		smallint OUTPUT

AS
SET NOCOUNT ON

DELETE FROM tEvent_Friend WHERE nEventUserNo= @nEventUserNo
IF @@ROWCOUNT = 0
	SET @err = 1
ELSE
	SET @err = 0	

RETURN @@ERROR





GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Event_Friend_EventComplete]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Event_Friend_EventComplete]
GO





/*==================================================
@author	lenasoft
@date	2006-05-17
@return	0		<성공>
	others		<실패>
@brief	이벤트 퀘스트 완료
==================================================*/

CREATE PROCEDURE [dbo].[p_Event_Friend_EventComplete]
@nEventUserNo 	int,
@nFriendCharNo	int OUTPUT,
@err 		smallint OUTPUT

AS
SET NOCOUNT ON

SET @nFriendCharNo = 0

SELECT @nFriendCharNo = nFriendCharNo FROM tEvent_Friend WITH(READUNCOMMITTED) WHERE nEventUserNo = @nEventUserNo
IF @@ROWCOUNT = 0
BEGIN
	SET @err = 1
	RETURN @@ERROR
END

UPDATE tEvent_Friend SET  bEventComplete = 1 WHERE nEventUserNo = @nEventUserNo
IF @@ERROR <> 0
	SET @err = @@ERROR
ELSE
	SET @err = 0

RETURN @@ERROR





GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Event_Friend_Get]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Event_Friend_Get]
GO

/*
-----------------------------------
SadPig : 2006.08.08 (OPTool)
	Input Parameter
		@nFriendUserNo 

	Output Parameter
		@@ERROR		
-----------------------------------
*/

CREATE PROCEDURE [dbo].[p_Event_Friend_Get]
	@nFriendUserNo	int

AS
BEGIN

	SET NOCOUNT ON
	 
	SELECT 
		t.nEventUserNo,
		t.nEventCharNo,
		t.nFriendCharNo,
		t.nWorldNo,
		t.bEventComplete,
		t.dDate
	FROM tEvent_Friend t
	WHERE t.nFriendUserNo = @nFriendUserNo

	SET NOCOUNT OFF

	RETURN @@ERROR
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Event_Friend_GetCount]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Event_Friend_GetCount]
GO




/*==================================================
@author	lenasoft
@date	2006-05-16
@return	0		<성공>
	others		<실패>
@brief	자신를 추천한 신규가입자 숫자 요청
==================================================*/

CREATE PROCEDURE [dbo].[p_Event_Friend_GetCount]
@nUserNo int,
@nCount int OUTPUT 

AS
SET NOCOUNT ON


SELECT @nCount = COUNT(*) FROM tEvent_Friend WITH(READUNCOMMITTED)
WHERE nFriendUserNo = @nUserNo

RETURN @@error




GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Event_Friend_Giveup]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Event_Friend_Giveup]
GO



/*==================================================
@author	lenasoft
@date	2006-05-19
@return	0		<성공>
	others		<실패>
@brief	이벤트 포기.
==================================================*/

CREATE PROCEDURE [dbo].[p_Event_Friend_Giveup]
@nEventUserNo 	int,
@nFriendCharNo 	int OUTPUT,
@err 		smallint OUTPUT

AS
SET NOCOUNT ON

SET @nFriendCharNo = 0

SELECT @nFriendCharNo = nFriendCharNo FROM tEvent_Friend WHERE nEventUserNo= @nEventUserNo
IF @@ROWCOUNT = 0
	BEGIN
		SET @err = 1
	END

ELSE

	BEGIN
		DELETE FROM tEvent_Friend WHERE nEventUserNo= @nEventUserNo
		SET @err = 0
	END

RETURN @@ERROR






GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Event_Friend_SetHideMsg]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Event_Friend_SetHideMsg]
GO





/*==================================================
@author	lenasoft
@date	2006-05-17
@return	0		<성공>
	others		<실패>
@brief	더이상 안보여주기 체크박스 설정
==================================================*/

CREATE PROCEDURE [dbo].[p_Event_Friend_SetHideMsg]
@nUserNo 	int,
@err 		smallint OUTPUT

AS
SET NOCOUNT ON

IF EXISTS (SELECT nUserNo FROM tEvent_Friend_HideMsg WITH(READUNCOMMITTED)
		WHERE nUserNo= @nUserNo )
	BEGIN
		SET @err = 1
	END
ELSE
	BEGIN
		INSERT INTO tEvent_Friend_HideMsg(nUserNo) VALUES(@nUserNo)
		IF @@ERROR <> 0
			SET @err = @@ERROR
		ELSE
			SET @err = 0
	END


RETURN





GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Event_WorldCup_Enter]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Event_WorldCup_Enter]
GO




/*==================================================
@author	lenasoft
@date	2006-05-26
@return	0		<성공>
	others		<실패>
@brief	월드컵 이벤트에 응모된다.
==================================================*/

CREATE PROCEDURE [dbo].[p_Event_WorldCup_Enter]
@nCharNo	int,
@nUserNo	int,
@nLevel		tinyint,
@nWorldNo	tinyint,
@err 		smallint OUTPUT

AS
SET NOCOUNT ON

IF GETDATE() > '2006-06-07'
BEGIN
	SET @err = 3
	RETURN @@ERROR
END

IF EXISTS ( SELECT nEventCharNo FROM tEventWorldCup WHERE nEventCharNo=@nCharNo AND nLevel=@nLevel AND nWorldNo=@nWorldNo )
	BEGIN
		SET @err = 1
	END 
ELSE
	BEGIN
		INSERT INTO tEventWorldCup(nEventCharNo, nEventUserNo, nLevel, nWorldNo)
			VALUES(@nCharNo, @nUserNo, @nLevel, @nWorldNo )
		IF @@ERROR <> 0 --Error
			SET @err = 2
		ELSE
			SET @err = 0
	END

RETURN @@ERROR




GO

-- ----------------------------
-- Procedure structure for [dbo].[p_IPBlock_Add]
-- ----------------------------
DROP PROCEDURE [dbo].[p_IPBlock_Add]
GO

CREATE PROCEDURE [dbo].[p_IPBlock_Add] 
/*
 IP Block Add
 input:
  추가할 블럭IP 대역
 output: 
  nRet,  0 = OK, ?=Error code
*/
@sIPStart	nvarchar(20),
@sIPEnd	nvarchar(20),
@sDesc	nvarchar(30),
@nRet		int OUTPUT
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = -1
	INSERT tIPBlock( sIPStart, sIPEnd, sDesc )
	VALUES             ( @sIPStart, @sIPEnd, @sDesc )
	SET @nRet = @@ERROR

	SET NOCOUNT OFF
END
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_IPBlock_Delete]
-- ----------------------------
DROP PROCEDURE [dbo].[p_IPBlock_Delete]
GO

CREATE PROCEDURE [dbo].[p_IPBlock_Delete]
/*
 IP Block Delete
 input:
  블럭이 되어있는 정보 제거
 output: 
  Selected records
*/
@sIP 		nvarchar(20),
@nRet		int OUTPUT
AS
BEGIN
	SET NOCOUNT ON
	DELETE FROM tIPBlock WHERE @sIP >= sIPStart AND @sIP <= sIPEnd
	SET @nRet = @@ERROR
	SET NOCOUNT OFF
END
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_IPBlock_Get]
-- ----------------------------
DROP PROCEDURE [dbo].[p_IPBlock_Get]
GO

CREATE PROCEDURE [dbo].[p_IPBlock_Get]
/*
 IP Block Get
 input:
  블럭이 되어있는 정보 얻기
 output: 
  Selected records
*/
@sIP 		nvarchar(20)
AS
BEGIN
	SET NOCOUNT ON
	SELECT sIPStart, sIPEnd, sDesc, dDate FROM tIPBlock WHERE @sIP >= sIPStart AND @sIP <= sIPEnd
	SET NOCOUNT OFF
END
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_IPBlock_GetList]
-- ----------------------------
DROP PROCEDURE [dbo].[p_IPBlock_GetList]
GO

CREATE PROCEDURE [dbo].[p_IPBlock_GetList]
/*
 IP Block Get
 input:
  블럭이 되어있는 목록
 output: 
  Selected records
*/
AS
BEGIN
	SET NOCOUNT ON
	SELECT sIPStart, sIPEnd, sDesc, dDate FROM tIPBlock
	SET NOCOUNT OFF
END
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_IPBlock_IsBlock]
-- ----------------------------
DROP PROCEDURE [dbo].[p_IPBlock_IsBlock]
GO

CREATE  PROCEDURE [dbo].[p_IPBlock_IsBlock]
/*
 Is IP block ?
 input:
  IP
 output: 
  bIsBlock, 0=No block, 1=Block
*/
	@nUserNo    int
,	@sIP 		nvarchar(20)
,	@bIsBlock	tinyint OUTPUT
AS
BEGIN
	SET NOCOUNT ON

	SET @bIsBlock = 0

	IF EXISTS(SELECT sIPStart FROM tIPBlock WHERE @sIP >= sIPStart AND @sIP <= sIPEnd) BEGIN
		IF NOT EXISTS(SELECT TOP 1 nLogNo FROM tAccountLog WHERE nUserNo = @nUserNo AND nType = 1) BEGIN
			SET @bIsBlock = 1
		END
	END

	SET NOCOUNT OFF
END
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Report_Add]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Report_Add]
GO

/*==================================================
@author	lenasoft
@date	2006-03-06
@return	0		<성공>
	others		<실패>
@brief	신고사항을 추가한다.
==================================================*/
CREATE PROCEDURE [dbo].[p_Report_Add] 
@nReporter int,
@sReporterCharID nvarchar(16),
@sHarmer nvarchar(16),
@nWorldNo tinyint,
@sReportType nvarchar(16),
@sReason nvarchar(512),
@sChatLog text,
@nReportRegNo int OUTPUT 
AS
SET NOCOUNT ON
DECLARE	@ret	int
SET 		@ret = 0
--1시간에 1회만 가능합니다.
IF EXISTS (SELECT nReporter FROM tReport(NOLOCK) 
		WHERE 	nReporter = @nReporter AND 
			nWorldNo=@nWorldNo AND
			dReportDate > dateadd(hour, -1, getdate()) )
BEGIN
	SET @nReportRegNo = -1
	RETURN @ret
END
--동일 캐릭터에 대해서는 1일 1회만 가능합니다.
IF EXISTS (SELECT nReporter FROM tReport(NOLOCK) 
		WHERE 	nReporter = @nReporter AND 
			nWorldNo=@nWorldNo AND
			dReportDate > dateadd(day, -1, getdate()) AND
			sHarmer = @sHarmer)
BEGIN
	SET @nReportRegNo = -2
	RETURN @ret
END
INSERT tReport (sReportType,nReporter,sReporterCharID,sHarmer,nWorldNo,sReason,sChatLog)
VALUES (@sReportType,@nReporter, @sReporterCharID, @sHarmer, @nWorldNo,@sReason,@sChatLog )
SET @ret = @@error
IF @ret <> 0 
	SET @nReportRegNo = 0
ELSE
	SET @nReportRegNo = @@IDENTITY
RETURN @ret


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Report_Deal_OPT]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Report_Deal_OPT]
GO

/*
'--------------------------------------------------------------------------------------
' 함수명 : p_Report_Deal_OPT
' 내  용 : OPTool 에서 사용. 신고한 내용을 OPTool로 처리함.
' 작성자 : 이병기
' 작성일 : 2006년 04월 25일
' 버  젼 : 1.0
' 인  자 :
'			input Parameter
'				@nRegNumer  : 처리될 리포트 넘버
'				@nResult	: 처리결과
'				@sRemark	: 운영자 의견
'
'			Output Parameter
'				@nRet		: 0 = Error, 1 = Success
'		
'			RETURN_VALUE
'
'--------------------------------------------------------------------------------------
*/
CREATE PROCEDURE [dbo].[p_Report_Deal_OPT]
	@nRegNumber	int,
	@nResult	tinyint,
	@sRemark	nvarchar(128),
	
	@nRet		int OUTPUT
	
AS
SET NOCOUNT ON
UPDATE tReport SET 
	nResult			= @nResult,
	sRemark			= @sRemark
WHERE nRegNumber = @nRegNumber
IF @@ERROR <> 0 OR @@ROWCOUNT = 0
BEGIN
	SET @nRet = 0
	RETURN
END
SET @nRet = 1


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Report_Del]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Report_Del]
GO

/*==================================================
@author	lenasoft
@date	2006-03-07
@return	0		<성공>
	others		<실패>
@brief	1시간 이내에 신고된 사항을 취소한다.
==================================================*/
CREATE PROCEDURE [dbo].[p_Report_Del]
@nRegNumber int,
@nRet smallint OUTPUT
AS
SET NOCOUNT ON
DECLARE	
@dReportDate	datetime,
@nResult	tinyint
--NoError(ErrorCode.h와 연동됨)
SET @nRet = 0
SELECT @dReportDate=dReportDate, @nResult=nResult FROM tReport WHERE nRegNumber=@nRegNumber 
--잘못된 등록번호
IF @@ROWCOUNT = 0
BEGIN
	SET @nRet = 1
	RETURN @@error
END
--1시간 지난 신고는 취소할수 없음.
IF @dReportDate < DATEADD(hour, -1, GETDATE())
BEGIN
	SET @nRet = 2
	RETURN @@error
END
--처리된 결과는 취소할 수 없음
IF @nResult <> 0
BEGIN
	SET @nRet = 3
	RETURN @@error
END
DELETE FROM tReport WHERE nRegNumber=@nRegNumber
RETURN @@error


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Report_Get]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Report_Get]
GO

/*==================================================
@author	lenasoft
@date	2006-03-07
@return	0		<성공>
	others		<실패>
@brief	1시간 이내에 신고된 목록을 얻어온다
==================================================*/
CREATE PROCEDURE [dbo].[p_Report_Get] 
@nReporter int,
@nWorldNo tinyint
AS
SET NOCOUNT ON
SELECT 	nRegNumber,nResult,sRemark  FROM tReport
WHERE 	nReporter = @nReporter AND nWorldNo=@nWorldNo AND
	dReportDate > dateadd(hour, -1, getdate()) 
RETURN @@error


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Report_Get_Count_OPT]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Report_Get_Count_OPT]
GO

/*
'--------------------------------------------------------------------------------------
' 함수명 : p_Report_Get_Count_OPT
' 내  용 : OPTool 에서 사용. OPTool에서 입력한 쿼리문에 맞는 리포트의 개수를 얻어옴.
' 작성자 : 이병기
' 작성일 : 2006년 04월 13일
' 버  젼 : 1.0
' 인  자 :
'			input Parameter
'				@QueryExpr		: OPTool 에서 입력한 쿼리문
'			Output Parameter
				@Count			: 서치된 데이터의 개수
'				
'			RETURN_VALUE
'
'--------------------------------------------------------------------------------------
*/
CREATE PROCEDURE [dbo].[p_Report_Get_Count_OPT]
	@QueryExpr nvarchar(256),
	@Count int OUTPUT
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @SQLCMD nvarchar(512)
	SET @SQLCMD = N'SELECT @RowCount = COUNT(*) 
		FROM tReport ' + @QueryExpr
	EXEC sp_executesql @SQLCMD, N'@RowCount AS int OUTPUT', @RowCount = @Count OUTPUT
	SET NOCOUNT OFF
END 


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Report_Get_OPT]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Report_Get_OPT]
GO

/*
'--------------------------------------------------------------------------------------
' 함수명 : p_Report_Get_OPT
' 내  용 : OPTool 에서 사용. OPTool에서 입력한 쿼리문에 맞는 리포트를 얻어옴.
' 작성자 : 이병기
' 작성일 : 2006년 04월 13일
' 버  젼 : 1.0
' 인  자 :
'			input Parameter
'				@QueryExpr		: OPTool 에서 입력한 쿼리문
'			Output Parameter
'		
'			RETURN_VALUE
'
'--------------------------------------------------------------------------------------
*/
CREATE PROCEDURE [dbo].[p_Report_Get_OPT]
	@QueryExpr nvarchar(256)
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @SQLCMD nvarchar(512)
	SET @SQLCMD = N'SELECT nRegNumber, sReportType, nReporter, sReporterCharID, sHarmer, nWorldNo, sReason, sChatLog, dReportDate, nResult, sRemark 
		FROM tReport ' + @QueryExpr
	EXEC sp_executesql @SQLCMD
	SET NOCOUNT OFF
END 


GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_EventiPad_getList]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_EventiPad_getList]
GO

/*--------------------------------------------------------------------------------------
' 이  름 : usp_EventiPad_getList
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2010.04.26
' Description :
'   티켓순으로 정렬된 리스트
' Parameter : NOT
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_EventiPad_getList]
AS
BEGIN
	SET NOCOUNT ON

	SELECT nUserNo, nTicket, sys_create_date AS [dCreateDate], sys_update_date AS [dLastUpdate]
	  FROM tEventiPad
	 ORDER BY nTicket DESC
	
	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_EventiPad_getTicket]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_EventiPad_getTicket]
GO

/*--------------------------------------------------------------------------------------
' 이  름 : usp_EventiPad_getTicket
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2010.04.26
' Description :
'   입력된 유저번호의 데이터를 가져옴.
' Parameter :
'	input Parameter
'		@nUserNo	: 유저번호
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1 : invaild nUserNo
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_EventiPad_getTicket]
	@nUserNo int,
	@nRet    int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	IF ISNULL(@nUserNo, 0) <= 0 BEGIN
		SET @nRet = -1
		RETURN
	END
		
	SELECT nUserNo, nTicket, sys_create_date AS [dCreateDate], sys_update_date AS [dLastUpdate]
	  FROM tEventiPad
	 WHERE nUserNo = @nUserNo
	
	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_EventiPad_setTicket]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_EventiPad_setTicket]
GO


/*--------------------------------------------------------------------------------------
' 이  름 : usp_EventiPad_setTicket
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2010.04.26
' Description :
'   접속시간이 60분이 넘는 데이터만 받아 티켓수를 계산하여 update or insert
' Parameter :
'	input Parameter
'		@nUserNo	: 유저번호
'		@nPlayTime	: 접속시간
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1 : 60분보다 작은 접속시간이 입력됨
'				-7 : error insert
'				-8 : error update
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_EventiPad_setTicket]
	@nUserNo   int,
	@nPlayTime int,
	@nRet      int = 0 output
AS
BEGIN
	SET NOCOUNT ON
	
	DECLARE @nTicket AS int SET @nTicket = 0
	SET @nRet = 0
	
	IF ISNULL(@nPlayTime, 0) < 60 BEGIN
		SET @nRet = -1
		RETURN
	END
	ELSE BEGIN
		SET @nTicket = @nPlayTime / 60
	END
	
	IF EXISTS(SELECT nUserNo FROM tEventiPad WHERE nUserNo = @nUserNo) BEGIN
		UPDATE tEventiPad SET
			nTicket = nTicket + @nTicket,
			sys_update_date = GETDATE()
		 WHERE nUserNo = @nUserNo
		IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
			SET @nRet = -8
			RETURN
		END
	END
	ELSE BEGIN
		INSERT INTO tEventiPad (nUserNo, nTicket)
		VALUES (@nUserNo, @nTicket)
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -7
			RETURN
		END
	END
	
	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Log_setLogout]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Log_setLogout]
GO


-- 2. 저장프로시저 생성(기록)
CREATE PROCEDURE [dbo].[usp_Log_setLogout]
	@WORLD_NO TINYINT		-- 서버
,	@USER_NO INT			-- 유저 번호
,	@CHAR_NO INT			-- 캐릭터 번호
,	@CLASS TINYINT			-- 캐릭터 클래스
,	@LEVEL SMALLINT			-- 캐릭터 현재레벨
,	@EXPERIENCE BIGINT		-- 획득 경험치
,	@PLAYTIME SMALLINT		-- 플레이시간
,	@RET INT = 0 OUTPUT		-- 리턴값(0:실패/1:성공)
AS

BEGIN

	SET NOCOUNT ON
	SET LOCK_TIMEOUT 5000

	INSERT INTO tLogout (worldNo, userNo, charNo, class, level, experience, playTime)
	VALUES (@WORLD_NO, @USER_NO, @CHAR_NO, @CLASS, @LEVEL, @EXPERIENCE, @PLAYTIME)
	IF @@ERROR <> 0 OR @@IDENTITY = 0
		SET @RET = 0
	ELSE
		SET @RET = 1

	SET NOCOUNT OFF
	SET LOCK_TIMEOUT -1

END


GO

-- ----------------------------
-- Indexes structure for table tAccountLog
-- ----------------------------
CREATE INDEX [XIE1tAccountLog_Date] ON [dbo].[tAccountLog]
([dDate] ASC) 
GO
CREATE INDEX [XIE2tAccountLog_UserNo] ON [dbo].[tAccountLog]
([sUserID] ASC) 
GO
CREATE INDEX [XIE3tAccountLog_Type] ON [dbo].[tAccountLog]
([nType] ASC) 
GO

-- ----------------------------
-- Primary Key structure for table [dbo].[tAccountLog]
-- ----------------------------
ALTER TABLE [dbo].[tAccountLog] ADD PRIMARY KEY ([nLogNo])
GO

-- ----------------------------
-- Indexes structure for table tEvent_Friend
-- ----------------------------
CREATE INDEX [IX_tEvent_Friend] ON [dbo].[tEvent_Friend]
([nFriendUserNo] ASC) 
GO

-- ----------------------------
-- Primary Key structure for table [dbo].[tEvent_Friend]
-- ----------------------------
ALTER TABLE [dbo].[tEvent_Friend] ADD PRIMARY KEY NONCLUSTERED ([nEventUserNo])
GO

-- ----------------------------
-- Indexes structure for table tEvent_Friend_HideMsg
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tEvent_Friend_HideMsg]
-- ----------------------------
ALTER TABLE [dbo].[tEvent_Friend_HideMsg] ADD PRIMARY KEY ([nUserNo])
GO

-- ----------------------------
-- Indexes structure for table tEventiPad
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tEventiPad]
-- ----------------------------
ALTER TABLE [dbo].[tEventiPad] ADD PRIMARY KEY ([nUserNo])
GO

-- ----------------------------
-- Indexes structure for table tEventWorldCup
-- ----------------------------

-- ----------------------------
-- Uniques structure for table [dbo].[tEventWorldCup]
-- ----------------------------
ALTER TABLE [dbo].[tEventWorldCup] ADD UNIQUE ([nEventCharNo] ASC, [nLevel] ASC, [nWorldNo] ASC)
GO

-- ----------------------------
-- Indexes structure for table tIPBlock
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tIPBlock]
-- ----------------------------
ALTER TABLE [dbo].[tIPBlock] ADD PRIMARY KEY ([sIPStart], [sIPEnd])
GO

-- ----------------------------
-- Indexes structure for table tLogout
-- ----------------------------
CREATE INDEX [IX_tLogout] ON [dbo].[tLogout]
([userNo] ASC) 
GO

-- ----------------------------
-- Indexes structure for table tReport
-- ----------------------------
CREATE INDEX [IX_ReportNo_WorldNo_dDate] ON [dbo].[tReport]
([nReporter] ASC, [nWorldNo] ASC, [dReportDate] ASC) 
GO

-- ----------------------------
-- Primary Key structure for table [dbo].[tReport]
-- ----------------------------
ALTER TABLE [dbo].[tReport] ADD PRIMARY KEY ([nRegNumber])
GO

-- ----------------------------
-- Indexes structure for table tUserLog
-- ----------------------------
CREATE CLUSTERED INDEX [IDX_tUserLog_CL] ON [dbo].[tUserLog]
([joinDate] ASC) 
GO

-- ----------------------------
-- Primary Key structure for table [dbo].[tUserLog]
-- ----------------------------
ALTER TABLE [dbo].[tUserLog] ADD PRIMARY KEY NONCLUSTERED ([rowNo])
GO
