/*
Navicat SQL Server Data Transfer

Source Server         : 88.198.10.166
Source Server Version : 105000
Source Host           : 88.198.10.166:1433
Source Database       : OperatorTool
Source Schema         : dbo

Target Server Type    : SQL Server
Target Server Version : 105000
File Encoding         : 65001

Date: 2012-01-28 20:07:17
*/


-- ----------------------------
-- Table structure for [dbo].[tMenuAuth]
-- ----------------------------
DROP TABLE [dbo].[tMenuAuth]
GO
CREATE TABLE [dbo].[tMenuAuth] (
[no] tinyint NOT NULL ,
[menu] char(20) NOT NULL ,
[auth] tinyint NOT NULL 
)


GO

-- ----------------------------
-- Records of tMenuAuth
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tOperator]
-- ----------------------------
DROP TABLE [dbo].[tOperator]
GO
CREATE TABLE [dbo].[tOperator] (
[nOperNo] int NOT NULL IDENTITY(1,1) ,
[sOperID] nvarchar(20) NOT NULL ,
[sOperPW] nvarchar(20) NOT NULL ,
[nOperLevel] tinyint NOT NULL DEFAULT ((0)) ,
[dRegDate] datetime NOT NULL DEFAULT (getdate()) 
)


GO
DBCC CHECKIDENT(N'[dbo].[tOperator]', RESEED, 39)
GO

-- ----------------------------
-- Records of tOperator
-- ----------------------------


-- ----------------------------
-- Table structure for [dbo].[tOpLog]
-- ----------------------------
DROP TABLE [dbo].[tOpLog]
GO
CREATE TABLE [dbo].[tOpLog] (
[nNo] int NOT NULL IDENTITY(1,1) ,
[dDate] datetime NOT NULL DEFAULT (getdate()) ,
[nOperNo] smallint NOT NULL ,
[sIP] nvarchar(20) NOT NULL ,
[nType] smallint NOT NULL ,
[nUserNo] int NULL ,
[sServer] nvarchar(50) NULL ,
[nCharNo] int NULL ,
[sDesc] nvarchar(256) NULL 
)


GO
DBCC CHECKIDENT(N'[dbo].[tOpLog]', RESEED, 160822)
GO

-- ----------------------------
-- Records of tOpLog
-- ----------------------------

-- ----------------------------
-- Procedure structure for [dbo].[p_Operator_Add]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Operator_Add]
GO

CREATE PROCEDURE [dbo].[p_Operator_Add]
/*
Operator add
input:
  See SQL
output: 
  nOperNo = 추가된 Operator의 번호(에러시 = 0 )
*/
@nOperNo	int OUTPUT,
@sOperID	nvarchar(20),
@sOperPW	nvarchar(20),
@nOperLevel	tinyint
AS
SET NOCOUNT ON
SET @nOperNo = 0
INSERT tOperator (  sOperID,  sOperPW,  nOperLevel )
VALUES           ( @sOperID, @sOperPW, @nOperLevel )
IF @@ERROR = 0
	SET @nOperNo = @@IDENTITY
	
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Operator_Del]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Operator_Del]
GO

CREATE PROCEDURE [dbo].[p_Operator_Del]
/*
Operator delete
input:
  See SQL
output: 
  @nOperLevel = 0, Delete failed
                1, Delete successed
*/
@nOperNo	int,
@nOperLevel tinyint OUTPUT
AS
SET NOCOUNT ON
SET @nOperLevel = 0
DELETE FROM tOperator WHERE nOperNo = @nOperNo
IF @@ROWCOUNT > 0
	SET @nOperLevel = 1
	
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Operator_GetAll]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Operator_GetAll]
GO

CREATE PROCEDURE [dbo].[p_Operator_GetAll]
/*
  Operator Get All
  output:
   - Select된 데이타
*/
AS
SET NOCOUNT ON
SELECT nOperNo, sOperID, nOperLevel, dRegDate FROM tOperator
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Operator_Logon]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Operator_Logon]
GO

CREATE PROCEDURE [dbo].[p_Operator_Logon]
/*
Operator logon
2004.12 By CJC
- Check ID.Password
Output:
	@nOperNo = 0 Failed logon (ID,Password missmatch) 
			 = ? Successed logon ( @nOperLevel = Operator level )
*/
@sOperID	nvarchar(20),
@sOperPW	nvarchar(20),
@nOperNo	int OUTPUT,
@nOperLevel	int OUTPUT
AS
SET NOCOUNT ON
SET @nOperNo = 0
IF EXISTS(SELECT * FROM tOperator WHERE (sOperID = @sOperID) AND (sOperPW = @sOperPW) )
BEGIN
	SELECT @nOperNo = nOperNo, @nOperLevel = nOperLevel 
	FROM tOperator WHERE (sOperID = @sOperID) AND (sOperPW = @sOperPW)
END
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Operator_SetLevel]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Operator_SetLevel]
GO

CREATE PROCEDURE [dbo].[p_Operator_SetLevel]
/*
Operator set level
input:
  See SQL
output: 
  nRet = 1 TRUE
	   = 0 FALSE
*/
@nOperNo	int,
@nOperLevel	tinyint,
@nRet		int OUTPUT
AS
SET NOCOUNT ON
UPDATE tOperator SET nOperLevel = @nOperLevel WHERE nOperNo = @nOperNo
IF (@@ERROR = 0) AND (@@ROWCOUNT = 1)
	SET @nRet = 1
ELSE
	SET @nRet = 0
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Operator_SetPW]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Operator_SetPW]
GO

CREATE PROCEDURE [dbo].[p_Operator_SetPW]
/*
Operator set password
input:
  See SQL
output: 
  nRet = 1 TRUE
	   = 0 FALSE
*/
@nOperNo	int,
@sOperPW	nvarchar(20),
@nRet		int OUTPUT
AS
SET NOCOUNT ON
UPDATE tOperator SET sOperPW = @sOperPW WHERE nOperNo = @nOperNo
IF (@@ERROR = 0) AND (@@ROWCOUNT = 1)
	SET @nRet = 1
ELSE
	SET @nRet = 0
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_OPLog_Add]
-- ----------------------------
DROP PROCEDURE [dbo].[p_OPLog_Add]
GO

CREATE PROCEDURE [dbo].[p_OPLog_Add]
/*
 Operator log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nLogType	tinyint,
@nOperNo	smallint,
@sIP		nvarchar(20),
@nType		smallint,
@nUserNo	int,
@sServer	nvarchar(50),
@nCharNo	int,
@sDesc		nvarchar(200),
@nLogNo		int OUTPUT
AS
BEGIN
SET NOCOUNT ON
SET @nLogNo = 0
DECLARE @STMT	AS NVARCHAR(200)
SET @STMT = 'INSERT tOpLog ' + 
	CASE @nLogType
		WHEN 0 THEN		'( nOperNo,		sIP,	nType,	nUserNo,	sServer,	nCharNo,	sDesc )
				VALUES	 ( @nOperNo,	@sIP,	@nType, @nUserNo,	@sServer,	@nCharNo,	@sDesc )'
		WHEN 1 THEN		'( nOperNo,		sIP,	nType,	sDesc )
				VALUES	 ( @nOperNo,	@sIP,	@nType, @sDesc )'
		WHEN 2 THEN		'( nOperNo,		sIP,	nType,	nUserNo,	sServer,	sDesc )
				VALUES	 ( @nOperNo,	@sIP,	@nType, @nUserNo,	@sServer,	@sDesc )'
		WHEN 3 THEN		'( nOperNo,		sIP,	nType,	sServer,	sDesc )
				VALUES	 ( @nOperNo,	@sIP,	@nType, @sServer,	@sDesc )'
	END
PRINT @STMT
EXEC sp_executesql @STMT
SET @nLogNo = @@IDENTITY
END
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_OPLog_Add_All]
-- ----------------------------
DROP PROCEDURE [dbo].[p_OPLog_Add_All]
GO

CREATE PROCEDURE [dbo].[p_OPLog_Add_All]
/*
 Operator log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nOperNo	smallint,
@sIP		nvarchar(20),
@nType		smallint,
@nUserNo	int,
@sServer	nvarchar(50),
@nCharNo	int,
@sDesc		nvarchar(200),
@nLogNo		int OUTPUT
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tOpLog ( nOperNo,	sIP,	nType,	nUserNo,	sServer,	nCharNo,	sDesc )
VALUES        ( @nOperNo,	@sIP,	@nType, @nUserNo,	@sServer,	@nCharNo,	@sDesc )
SET @nLogNo = @@IDENTITY
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_OPLog_Add_ToIP]
-- ----------------------------
DROP PROCEDURE [dbo].[p_OPLog_Add_ToIP]
GO

CREATE PROCEDURE [dbo].[p_OPLog_Add_ToIP]
/*
 Operator log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nOperNo	smallint,
@sIP		nvarchar(20),
@nType		smallint,
@sServer	nvarchar(50),
@sDesc		nvarchar(200),
@nLogNo		int OUTPUT
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tOpLog ( nOperNo,	sIP,	nType,	sServer,	sDesc )
VALUES        ( @nOperNo,	@sIP,	@nType, @sServer,	@sDesc )
SET @nLogNo = @@IDENTITY
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_OPLog_Add_ToUserNo]
-- ----------------------------
DROP PROCEDURE [dbo].[p_OPLog_Add_ToUserNo]
GO

CREATE PROCEDURE [dbo].[p_OPLog_Add_ToUserNo]
/*
 Operator log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nOperNo	smallint,
@sIP		nvarchar(20),
@nType		smallint,
@nUserNo	int,
@sServer	nvarchar(50),
@sDesc		nvarchar(200),
@nLogNo		int OUTPUT
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tOpLog ( nOperNo,	sIP,	nType,	nUserNo,	sServer,	sDesc )
VALUES        ( @nOperNo,	@sIP,	@nType, @nUserNo,	@sServer,	@sDesc )
SET @nLogNo = @@IDENTITY
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_OPLog_Add_ToWorldNo]
-- ----------------------------
DROP PROCEDURE [dbo].[p_OPLog_Add_ToWorldNo]
GO

CREATE PROCEDURE [dbo].[p_OPLog_Add_ToWorldNo]
/*
 Operator log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nOperNo	smallint,
@sIP		nvarchar(20),
@nType		smallint,
@sServer	nvarchar(50),
@sDesc		nvarchar(200),
@nLogNo		int OUTPUT
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tOpLog ( nOperNo,	sIP,	nType,	sServer,	sDesc )
VALUES        ( @nOperNo,	@sIP,	@nType, @sServer,	@sDesc )
SET @nLogNo = @@IDENTITY
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_OPLog_Get]
-- ----------------------------
DROP PROCEDURE [dbo].[p_OPLog_Get]
GO

CREATE PROCEDURE [dbo].[p_OPLog_Get]
/*
  OPLog Get - 주어진 조건에 맞는 로그를 모두검색해서 얻는다.
  input:
   - 주어진 조건절
  output:
   - Select된 데이타
*/
@WhereExpr nvarchar(256)
AS
SET NOCOUNT ON
DECLARE @SQLCMD nvarchar(512)
SET @SQLCMD = N'SELECT nNo, dDate, nOperNo, sIP, nType, nUserNo, sServer, nCharNo, sDesc FROM tOpLog ' + @WhereExpr
EXEC sp_executesql @SQLCMD
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_OPLog_GetCount]
-- ----------------------------
DROP PROCEDURE [dbo].[p_OPLog_GetCount]
GO

CREATE PROCEDURE [dbo].[p_OPLog_GetCount]
/*
  OPLog Get Count - 주어진 조건에 맞는 로그를 모두검색해서 얻는다.
  input:
   - 주어진 조건절
  output:
   - @Count = 해당 조건에 만족하는 레코드수
*/
@WhereExpr nvarchar(256),
@Count int OUTPUT
AS
SET NOCOUNT ON
DECLARE @SQLCMD nvarchar(512)
SET @SQLCMD = N'SELECT @RowCount = COUNT(*) FROM tOpLog ' + @WhereExpr
EXEC sp_executesql @SQLCMD, N'@RowCount AS int OUTPUT', @RowCount = @Count OUTPUT
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_OPTMenu_GetAuth]
-- ----------------------------
DROP PROCEDURE [dbo].[p_OPTMenu_GetAuth]
GO

/*
'--------------------------------------------------------------------------------------
' 함수명 : p_OPTMenu_GetAuth
' 내  용 : OP Tool Menu 에 대한 접근 권한을 얻어옴
' 작성자 : 이병기
' 작성일 : 2005년 12월 20일
' 버  젼 : 1.0
' 인  자 :
'			input Parameter
'				@sMenuName	: 메뉴이름
'			RETURN_VALUE
'--------------------------------------------------------------------------------------
*/
CREATE PROCEDURE [dbo].[p_OPTMenu_GetAuth]
@sMenuName	NVARCHAR(20)
AS
SET NOCOUNT ON
SELECT auth FROM tMenuAuth WHERE menu = @sMenuName


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_OPTMenu_GetAuthAll]
-- ----------------------------
DROP PROCEDURE [dbo].[p_OPTMenu_GetAuthAll]
GO

/*
'--------------------------------------------------------------------------------------
' 함수명 : p_OPTMenu_GetAuthAll
' 내  용 : OP Tool Menu 에 대한 접근 권한을 얻어옴
' 작성자 : 이병기
' 작성일 : 2005년 12월 20일
' 버  젼 : 1.0
' 인  자 :
'			input Parameter
'				
'			RETURN_VALUE
'
'--------------------------------------------------------------------------------------
*/
CREATE PROCEDURE [dbo].[p_OPTMenu_GetAuthAll]
AS
SET NOCOUNT ON
SELECT no, menu, auth FROM tMenuAuth


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_OPTMenu_GetCount]
-- ----------------------------
DROP PROCEDURE [dbo].[p_OPTMenu_GetCount]
GO

/*
'--------------------------------------------------------------------------------------
' 함수명 : p_OPTMenu_GetCount
' 내  용 : 접근 권한을 정해 놓기 위해 디비에 등록한 메뉴의 갯수를 얻어옴
' 작성자 : 이병기
' 작성일 : 2005년 12월 20일
' 버  젼 : 1.0
' 인  자 :
'			input Parameter
'			
'			output Parameter
'				@nCount int OUTPUT
'			RETURN_VALUE
'
'--------------------------------------------------------------------------------------
*/
CREATE PROCEDURE [dbo].[p_OPTMenu_GetCount]
@nCount tinyint OUTPUT
AS
SET NOCOUNT ON
SELECT @nCount = COUNT(*) FROM tMenuAuth


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_OPTMenu_SetAuth]
-- ----------------------------
DROP PROCEDURE [dbo].[p_OPTMenu_SetAuth]
GO

/*
'--------------------------------------------------------------------------------------
' 함수명 : p_OPTMenu_SetAuth
' 내  용 : OP Tool Menu 에 대한 접근 권한을 세팅
' 작성자 : 이병기
' 작성일 : 2005년 12월 20일
' 버  젼 : 1.0
' 인  자 :
'			input Parameter
'				@sMenuName	: 메뉴이름
'				@nAuth		: 접근 권한 하위 한계
'			RETURN_VALUE
'				 1 : 등록
'				 0 : DB ERROR (INSERT)
'--------------------------------------------------------------------------------------
*/
CREATE PROCEDURE [dbo].[p_OPTMenu_SetAuth]
@sMenuName	NVARCHAR(20),
@nAuth		tinyint,
@nRet		int OUTPUT
AS
SET NOCOUNT ON
UPDATE tMenuAuth SET auth = @nAuth WHERE menu = @sMenuName
IF (@@ERROR = 0) AND (@@ROWCOUNT = 1)
	SET @nRet = 1
ELSE
	SET @nRet = 0


GO

-- ----------------------------
-- Indexes structure for table tOperator
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tOperator]
-- ----------------------------
ALTER TABLE [dbo].[tOperator] ADD PRIMARY KEY ([nOperNo])
GO

-- ----------------------------
-- Uniques structure for table [dbo].[tOperator]
-- ----------------------------
ALTER TABLE [dbo].[tOperator] ADD UNIQUE ([sOperID] ASC)
GO

-- ----------------------------
-- Indexes structure for table tOpLog
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tOpLog]
-- ----------------------------
ALTER TABLE [dbo].[tOpLog] ADD PRIMARY KEY ([nNo])
GO
