/*
Navicat SQL Server Data Transfer

Source Server         : 88.198.10.166
Source Server Version : 105000
Source Host           : 88.198.10.166:1433
Source Database       : StatisticsData
Source Schema         : dbo

Target Server Type    : SQL Server
Target Server Version : 105000
File Encoding         : 65001

Date: 2012-01-28 20:08:11
*/


-- ----------------------------
-- Table structure for [dbo].[tAge]
-- ----------------------------
DROP TABLE [dbo].[tAge]
GO
CREATE TABLE [dbo].[tAge] (
[nLogNo] int NOT NULL IDENTITY(1,1) ,
[sLogDate] nvarchar(10) NOT NULL ,
[nAge] tinyint NOT NULL ,
[nCount] int NOT NULL ,
[nYear] smallint NOT NULL ,
[nMonth] tinyint NOT NULL ,
[nDay] tinyint NOT NULL ,
[nWeek] tinyint NOT NULL ,
[nWeekDay] tinyint NOT NULL 
)


GO

-- ----------------------------
-- Records of tAge
-- ----------------------------
SET IDENTITY_INSERT [dbo].[tAge] ON
GO
SET IDENTITY_INSERT [dbo].[tAge] OFF
GO

-- ----------------------------
-- Table structure for [dbo].[tDayActiveUser]
-- ----------------------------
DROP TABLE [dbo].[tDayActiveUser]
GO
CREATE TABLE [dbo].[tDayActiveUser] (
[nIndex] int NOT NULL IDENTITY(1,1) ,
[dDate] datetime NOT NULL DEFAULT (getdate()) ,
[nActiveCount] int NOT NULL ,
[nNetmarbleCount] int NOT NULL ,
[nTotalUserCount] int NOT NULL 
)


GO

-- ----------------------------
-- Records of tDayActiveUser
-- ----------------------------
SET IDENTITY_INSERT [dbo].[tDayActiveUser] ON
GO
SET IDENTITY_INSERT [dbo].[tDayActiveUser] OFF
GO

-- ----------------------------
-- Table structure for [dbo].[tDayClassLevel]
-- ----------------------------
DROP TABLE [dbo].[tDayClassLevel]
GO
CREATE TABLE [dbo].[tDayClassLevel] (
[nIndex] int NOT NULL IDENTITY(1,1) ,
[dDate] datetime NOT NULL DEFAULT (getdate()) ,
[nWorld] tinyint NOT NULL ,
[nClass] tinyint NOT NULL ,
[nLevel] smallint NOT NULL ,
[nCount] int NOT NULL 
)


GO

-- ----------------------------
-- Records of tDayClassLevel
-- ----------------------------
SET IDENTITY_INSERT [dbo].[tDayClassLevel] ON
GO
SET IDENTITY_INSERT [dbo].[tDayClassLevel] OFF
GO

-- ----------------------------
-- Table structure for [dbo].[tDayClassLevelPlay]
-- ----------------------------
DROP TABLE [dbo].[tDayClassLevelPlay]
GO
CREATE TABLE [dbo].[tDayClassLevelPlay] (
[nIndex] int NOT NULL IDENTITY(1,1) ,
[dDate] datetime NOT NULL DEFAULT (getdate()) ,
[nWorld] tinyint NOT NULL ,
[nClass] tinyint NOT NULL ,
[nLevel] smallint NOT NULL ,
[nPlayMin] int NOT NULL ,
[nConnectCount] int NOT NULL 
)


GO

-- ----------------------------
-- Records of tDayClassLevelPlay
-- ----------------------------
SET IDENTITY_INSERT [dbo].[tDayClassLevelPlay] ON
GO
SET IDENTITY_INSERT [dbo].[tDayClassLevelPlay] OFF
GO

-- ----------------------------
-- Table structure for [dbo].[tDayUser]
-- ----------------------------
DROP TABLE [dbo].[tDayUser]
GO
CREATE TABLE [dbo].[tDayUser] (
[nIndex] int NOT NULL IDENTITY(1,1) ,
[dDate] datetime NOT NULL DEFAULT (getdate()) ,
[nUserCount] int NOT NULL ,
[nConnectCount] int NOT NULL 
)


GO

-- ----------------------------
-- Records of tDayUser
-- ----------------------------
SET IDENTITY_INSERT [dbo].[tDayUser] ON
GO
SET IDENTITY_INSERT [dbo].[tDayUser] OFF
GO

-- ----------------------------
-- Table structure for [dbo].[tGender]
-- ----------------------------
DROP TABLE [dbo].[tGender]
GO
CREATE TABLE [dbo].[tGender] (
[nLogNo] int NOT NULL IDENTITY(1,1) ,
[sLogDate] nvarchar(10) NOT NULL ,
[nGender] tinyint NOT NULL ,
[nCount] int NOT NULL ,
[nYear] smallint NOT NULL ,
[nMonth] tinyint NOT NULL ,
[nDay] tinyint NOT NULL ,
[nWeek] tinyint NOT NULL ,
[nWeekDay] tinyint NOT NULL 
)


GO

-- ----------------------------
-- Records of tGender
-- ----------------------------
SET IDENTITY_INSERT [dbo].[tGender] ON
GO
SET IDENTITY_INSERT [dbo].[tGender] OFF
GO

-- ----------------------------
-- Table structure for [dbo].[tLocation]
-- ----------------------------
DROP TABLE [dbo].[tLocation]
GO
CREATE TABLE [dbo].[tLocation] (
[nLogNo] int NOT NULL IDENTITY(1,1) ,
[sLogDate] nvarchar(10) NOT NULL ,
[sLocation] nvarchar(2) NOT NULL ,
[nCount] int NOT NULL ,
[nYear] smallint NOT NULL ,
[nMonth] tinyint NOT NULL ,
[nDay] tinyint NOT NULL ,
[nWeek] tinyint NOT NULL ,
[nWeekDay] tinyint NOT NULL 
)


GO

-- ----------------------------
-- Records of tLocation
-- ----------------------------
SET IDENTITY_INSERT [dbo].[tLocation] ON
GO
SET IDENTITY_INSERT [dbo].[tLocation] OFF
GO

-- ----------------------------
-- Table structure for [dbo].[TopCharacter]
-- ----------------------------
DROP TABLE [dbo].[TopCharacter]
GO
CREATE TABLE [dbo].[TopCharacter] (
[nUserNo] int NULL ,
[nLevel] int NULL 
)


GO

-- ----------------------------
-- Records of TopCharacter
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[TopCharacter_MAY]
-- ----------------------------
DROP TABLE [dbo].[TopCharacter_MAY]
GO
CREATE TABLE [dbo].[TopCharacter_MAY] (
[nUserNo] int NULL ,
[nLevel] int NULL 
)


GO

-- ----------------------------
-- Records of TopCharacter_MAY
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tQuestTimesQ20016]
-- ----------------------------
DROP TABLE [dbo].[tQuestTimesQ20016]
GO
CREATE TABLE [dbo].[tQuestTimesQ20016] (
[ServerNo] int NOT NULL ,
[sID] nvarchar(40) NOT NULL ,
[nTimes] int NOT NULL ,
[dLastComplete] char(17) NULL 
)


GO

-- ----------------------------
-- Records of tQuestTimesQ20016
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tQuestTimesQ2079]
-- ----------------------------
DROP TABLE [dbo].[tQuestTimesQ2079]
GO
CREATE TABLE [dbo].[tQuestTimesQ2079] (
[ServerNo] int NOT NULL ,
[sID] nvarchar(40) NOT NULL ,
[nTimes] int NOT NULL ,
[dLastComplete] char(17) NULL 
)


GO

-- ----------------------------
-- Records of tQuestTimesQ2079
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tQuestTimesQ63011]
-- ----------------------------
DROP TABLE [dbo].[tQuestTimesQ63011]
GO
CREATE TABLE [dbo].[tQuestTimesQ63011] (
[ServerNo] int NOT NULL ,
[sID] nvarchar(40) NOT NULL ,
[nTimes] int NOT NULL ,
[dLastComplete] char(17) NULL 
)


GO

-- ----------------------------
-- Records of tQuestTimesQ63011
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tSameTimeChar]
-- ----------------------------
DROP TABLE [dbo].[tSameTimeChar]
GO
CREATE TABLE [dbo].[tSameTimeChar] (
[nIndex] int NOT NULL IDENTITY(1,1) ,
[dDate] datetime NOT NULL DEFAULT (getdate()) ,
[nWorld] tinyint NOT NULL ,
[nCount] int NOT NULL 
)


GO
DBCC CHECKIDENT(N'[dbo].[tSameTimeChar]', RESEED, 3296104)
GO

-- ----------------------------
-- Records of tSameTimeChar
-- ----------------------------

-- ----------------------------
-- View structure for [dbo].[v_maxCCU]
-- ----------------------------
DROP VIEW [dbo].[v_maxCCU]
GO
CREATE VIEW [dbo].[v_maxCCU] AS 
select dDate,w0,w1,w0+w1 total from (
select convert(char(16),dDate,120) dDate ,max(case nWorld when 0 then nCount else 0 end) w0, max(case nWorld when 1 then nCount else 0 end) w1
from tSameTimeChar 
group by convert(char(16),dDate,120)
) as t1
GO

-- ----------------------------
-- Procedure structure for [dbo].[p_DayClassLevel_Add]
-- ----------------------------
DROP PROCEDURE [dbo].[p_DayClassLevel_Add]
GO

/****** ??: ?? ???? dbo.p_DayClassLevel_Add    ???? ??: 2005-06-13 ?? 8:20:09 ******/
CREATE PROCEDURE [dbo].[p_DayClassLevel_Add] 
/*
 DayClassLevel add record
 input:
  See SQL
 output: 
  nIndex = ??? ??(??? = 0 )
*/
@nWorld	tinyint,
@nClass	tinyint,
@nLevel smallint,
@nCount	int,
@nIndex		int OUTPUT
AS
SET NOCOUNT ON
SET @nIndex = 0
INSERT tDayClassLevel (  nWorld,  nClass,  nLevel,  nCount )
VALUES                ( @nWorld, @nClass, @nLevel, @nCount )
SET @nIndex = @@IDENTITY
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_DayClassLevel_Query]
-- ----------------------------
DROP PROCEDURE [dbo].[p_DayClassLevel_Query]
GO

/****** ??: ?? ???? dbo.p_DayClassLevel_Query    ???? ??: 2005-06-13 ?? 8:20:09 ******/
CREATE PROCEDURE [dbo].[p_DayClassLevel_Query] 
/*
  DayClassLevel Query - ??? ??? ?? ???? ?????? ???.
  input:
   - ??? ???
  output:
   - Select? ???
*/
@WhereExpr nvarchar(256)
AS
SET NOCOUNT ON
DECLARE @SQLCMD nvarchar(512)
SET  @SQLCMD = N'SELECT nIndex, dDate, nWorld, nClass, nLevel, nCount FROM tDayClassLevel WHERE ' + @WhereExpr
EXEC sp_executesql @SQLCMD
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_DayClassLevelPlay_Add]
-- ----------------------------
DROP PROCEDURE [dbo].[p_DayClassLevelPlay_Add]
GO

/****** ??: ?? ???? dbo.p_DayClassLevelPlay_Add    ???? ??: 2005-06-13 ?? 8:20:09 ******/
CREATE PROCEDURE [dbo].[p_DayClassLevelPlay_Add] 
/*
 DayClassLevelPlay add record
 input:
  See SQL
 output: 
  nIndex = ??? ??(??? = 0 )
*/
@nWorld	tinyint,
@nClass	tinyint,
@nLevel smallint,
@nPlayMin		int,
@nConnectCount	int,
@nIndex		int OUTPUT
AS
SET NOCOUNT ON
SET @nIndex = 0
INSERT tDayClassLevelPlay (  nWorld,  nClass,  nLevel,  nPlayMin,  nConnectCount )
VALUES                    ( @nWorld, @nClass, @nLevel, @nPlayMin, @nConnectCount)
SET @nIndex = @@IDENTITY
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_DayClassLevelPlay_Query]
-- ----------------------------
DROP PROCEDURE [dbo].[p_DayClassLevelPlay_Query]
GO

/****** ??: ?? ???? dbo.p_DayClassLevelPlay_Query    ???? ??: 2005-06-13 ?? 8:20:09 ******/
CREATE PROCEDURE [dbo].[p_DayClassLevelPlay_Query] 
/*
  DayClassLevelPlay Query - ??? ??? ?? ???? ?????? ???.
  input:
   - ??? ???
  output:
   - Select? ???
*/
@WhereExpr nvarchar(256)
AS
SET NOCOUNT ON
DECLARE @SQLCMD nvarchar(512)
SET  @SQLCMD = N'SELECT nIndex, dDate, nWorld, nClass, nLevel, nPlayMin, nConnectCount FROM tDayClassLevelPlay WHERE ' + @WhereExpr
EXEC sp_executesql @SQLCMD
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_DayConnectionTime]
-- ----------------------------
DROP PROCEDURE [dbo].[p_DayConnectionTime]
GO

CREATE PROCEDURE [dbo].[p_DayConnectionTime] 
AS
SET NOCOUNT ON
declare @nMon int
IF DAY(GETDATE()) = 1
set @nMon =MONTH(GETDATE())-1 
ELSE 
set @nMon = MONTH(GETDATE()) 
select min(nPlayMin) nMin, max(nPlayMin) nMax, avg(nPlayMin) nAvg, nWorldNo, DAY(dDate) nDay 
from [AccountLog].[dbo].[tAccountLog]			
where MONTH(dDate) = @nMon and nType = 2 
group by nWorldNo, DAY(dDate) 
order by nWorldNo, DAY(dDate) 
return 


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_DayUser]
-- ----------------------------
DROP PROCEDURE [dbo].[p_DayUser]
GO

CREATE PROCEDURE [dbo].[p_DayUser]
/*
 Day User - ?? ?? ???, ????
 Desc:
	Update tDayUser Statstics table
	AccountLog.dbo.tAccountLog?? ????? ??? ??? ??? 
	???, ????? ??? ??? ??? ???? ?????.
*/
AS
SET NOCOUNT ON
-- GameLog's nType for LOGOUT 
DECLARE @LoginID int	
SET		@LoginID = 1
-- ?? ??? ???.(??? ?? ??)
DECLARE @Date		datetime
DECLARE @StartDate	datetime 
DECLARE @EndDate	datetime 
SET @Date = GETDATE()
SET @EndDate = STR( YEAR(@Date) ) + STR( MONTH(@Date) ) + STR( DAY(@Date) )
SET @StartDate = @EndDate - 1
-- ???? ??? ?? ??? ?? ?? ??(????)
DELETE tDayUser WHERE dDate = @StartDate
-- ????, ???? ??
DECLARE @nUserCount    int
DECLARE @nConnectCount int
SELECT @nUserCount = COUNT(DISTINCT(nUserNo)), @nConnectCount = COUNT(*) 
--FROM [ACCOUNT-LOG].AccountLog.dbo.tAccountLog 
FROM AccountLog.dbo.tAccountLog 
WHERE (nType = @LoginID) AND (dDate >= @StartDate) AND (dDate < @EndDate)
-- Table? ????
DECLARE @Index int
exec p_DayUser_Add @nUserCount, @nConnectCount, @Index OUTPUT
IF @Index <> 0 UPDATE tDayUser SET dDate = @StartDate WHERE nIndex = @Index -- ??? ??
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_DayUser_Add]
-- ----------------------------
DROP PROCEDURE [dbo].[p_DayUser_Add]
GO

/****** ??: ?? ???? dbo.p_DayUser_Add    ???? ??: 2005-06-13 ?? 8:20:09 ******/
CREATE PROCEDURE [dbo].[p_DayUser_Add] 
/*
 DayUser add
 input:
  See SQL
 output: 
  nIndex = ??? ??(??? = 0 )
*/
@nUserCount		int,
@nConnectCount	int,
@nIndex		int OUTPUT
AS
SET NOCOUNT ON
SET @nIndex = 0
INSERT tDayUser (  nUserCount,  nConnectCount )
VALUES          ( @nUserCount, @nConnectCount )
SET @nIndex = @@IDENTITY
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_DayUser_Query]
-- ----------------------------
DROP PROCEDURE [dbo].[p_DayUser_Query]
GO

/****** ??: ?? ???? dbo.p_DayUser_Query    ???? ??: 2005-06-13 ?? 8:20:09 ******/
CREATE PROCEDURE [dbo].[p_DayUser_Query] 
/*
  DayUser Query - ??? ??? ?? ???? ?????? ???.
  input:
   - ??? ???
  output:
   - Select? ???
*/
@WhereExpr nvarchar(256)
AS
SET NOCOUNT ON
DECLARE @SQLCMD nvarchar(512)
SET  @SQLCMD = N'SELECT nIndex, dDate, nUserCount, nConnectCount FROM tDayUser WHERE ' + @WhereExpr
EXEC sp_executesql @SQLCMD
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_getQuestTimes]
-- ----------------------------
DROP PROCEDURE [dbo].[p_getQuestTimes]
GO
CREATE procedure [dbo].[p_getQuestTimes]
@nQuestNo int,
@top smallint
as
	set nocount on;
	select * from (
		select top (@top) 0 ServerNo, c.sID,nTimes, convert(char(17),dLastComplete,113) dLastComplete from w00_Character.dbo.tQuestTimes q, w00_Character.dbo.tCharacter c
		where nQuestNo=@nQuestNo and q.nCharNo=c.nCharNo and c.bDeleted=0 
		order by nTimes desc, q.dLastComplete  
	) as t0
	union all
	select * from (	
		select top (@top) 1 ServerNo, c.sID,nTimes, convert(char(17),dLastComplete,113) dLastComplete from w01_Character.dbo.tQuestTimes q, w01_Character.dbo.tCharacter c
		where nQuestNo=@nQuestNo and q.nCharNo=c.nCharNo and c.bDeleted=0 
		order by nTimes desc, q.dLastComplete  
	) as t1

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_SameTimeChar_Add]
-- ----------------------------
DROP PROCEDURE [dbo].[p_SameTimeChar_Add]
GO

/****** ??: ?? ???? dbo.p_SameTimeChar_Add    ???? ??: 2005-06-13 ?? 8:20:09 ******/
CREATE PROCEDURE [dbo].[p_SameTimeChar_Add] 
/*
 SameTimeChar add
 input:
  See SQL
 output: 
  nIndex = ??? ??(??? = 0 )
*/
@nWorld	tinyint,
@nCount		int,
@nIndex		int OUTPUT
AS
SET NOCOUNT ON
---
SET @nIndex = 0
 
INSERT tSameTimeChar (  nWorld,  nCount )
VALUES               ( @nWorld, @nCount )
SET @nIndex = @@IDENTITY
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_SameTimeChar_Query]
-- ----------------------------
DROP PROCEDURE [dbo].[p_SameTimeChar_Query]
GO

/****** ??: ?? ???? dbo.p_SameTimeChar_Query    ???? ??: 2005-06-13 ?? 8:20:09 ******/
CREATE PROCEDURE [dbo].[p_SameTimeChar_Query] 
/*
  SameTimeChar Query - ??? ??? ?? ???? ?????? ???.
  input:
   - ??? ???
  output:
   - Select? ???
*/
@WhereExpr nvarchar(256)
AS
SET NOCOUNT ON
DECLARE @SQLCMD nvarchar(512)
SET  @SQLCMD = N'SELECT nIndex, dDate, nWorld, nCount FROM tSameTimeChar WHERE ' + @WhereExpr
EXEC sp_executesql @SQLCMD
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_SameTimeWorld]
-- ----------------------------
DROP PROCEDURE [dbo].[p_SameTimeWorld]
GO

--lenasoft:??? ??? ??(2006-04-24)
CREATE  PROCEDURE [dbo].[p_SameTimeWorld]
AS
BEGIN
	SET NOCOUNT ON
	SET LOCK_TIMEOUT 5000
declare 
@CurrentTime datetime,
@TimeText nvarchar(24)
SELECT TOP 1 @TimeText= convert(nvarchar(24),dDate,0), @CurrentTime=dDate  FROM tSameTimeChar WITH(READUNCOMMITTED)
WHERE dDate >= DATEADD(minute, -5, GETDATE() )
order by dDate desc
IF @@ROWCOUNT = 0 
	BEGIN
		SELECT GETDATE() AS CurTime, 0 AS CurCount
	END
ELSE
	BEGIN
		SELECT @CurrentTime AS CurTime , SUM(nCount) AS CurCount  FROM tSameTimeChar WITH(READUNCOMMITTED)
		WHERE convert(nvarchar(24),dDate,0) = @TimeText
	END
END


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_UserAge_Query]
-- ----------------------------
DROP PROCEDURE [dbo].[p_UserAge_Query]
GO

/****** ??: ?? ???? dbo.p_UserAge_Query    ???? ??: 2005-06-13 ?? 8:20:09 ******/
CREATE PROCEDURE [dbo].[p_UserAge_Query] 
/*
  UserAge Query - ??? ??? ?? ???? ?????? ???.
  input:
   - ??? ???
  output:
   - Select? ???
*/
@WhereExpr nvarchar(256)
AS
SET NOCOUNT ON
DECLARE @SQLCMD nvarchar(512)
SET  @SQLCMD = N'SELECT nLogNo, nYear, nMonth, nDay, nWeek, nWeekDay, nAge, nCount FROM tAge WHERE ' + @WhereExpr
EXEC sp_executesql @SQLCMD
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_UserAgeReport]
-- ----------------------------
DROP PROCEDURE [dbo].[p_UserAgeReport]
GO

/****** ??: ?? ???? dbo.p_UserAgeReport    ???? ??: 2005-06-13 ?? 8:20:09 ******/
CREATE PROCEDURE [dbo].[p_UserAgeReport]
	@S_DATE NVARCHAR(10) = '',
	@E_DATE NVARCHAR(10) = ''
AS
BEGIN
	SET NOCOUNT ON
	SET LOCK_TIMEOUT 5000
	DECLARE @S_YEAR AS INT
	DECLARE @S_MONTH AS INT
	DECLARE @S_DAY AS INT
	DECLARE @E_YEAR AS INT
	DECLARE @E_MONTH AS INT
	DECLARE @E_DAY AS INT
	IF @S_DATE = ''
		SET @S_DATE = DATEADD(dd, -1, GETDATE())
	IF @E_DATE = ''
		SET @E_DATE = DATEADD(dd, -1, GETDATE())
	SET @S_YEAR  = DATENAME(yyyy, @S_DATE)
	SET @S_MONTH = DATENAME(mm, @S_DATE)
	SET @S_DAY   = DATENAME(dd, @S_DATE)
	SET @E_YEAR  = DATENAME(yyyy, @E_DATE)
	SET @E_MONTH = DATENAME(mm, @E_DATE)
	SET @E_DAY   = DATENAME(dd, @E_DATE)
	PRINT '??? : ' + @S_DATE
	PRINT '??? : ' + @E_DATE
	PRINT @S_MONTH
	PRINT @E_MONTH
	SELECT CASE(nGender)
				WHEN 0 THEN '??'
				WHEN 1 THEN '??'
		   END AS [??], nCount AS [??]
	  FROM tGender(NOLOCK)
	 WHERE nYear >= @S_YEAR AND nMonth >= @S_MONTH AND nDay >= @S_DAY
	   AND nYear <= @E_YEAR AND nMonth <= @E_MONTH AND nDay <= @E_DAY
	SET LOCK_TIMEOUT -1
	SET NOCOUNT OFF
END
	


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_UserGender_Query]
-- ----------------------------
DROP PROCEDURE [dbo].[p_UserGender_Query]
GO

/****** ??: ?? ???? dbo.p_UserGender_Query    ???? ??: 2005-06-13 ?? 8:20:09 ******/
CREATE PROCEDURE [dbo].[p_UserGender_Query] 
/*
  UserGender Query - ??? ??? ?? ???? ?????? ???.
  input:
   - ??? ???
  output:
   - Select? ???
*/
@WhereExpr nvarchar(256)
AS
SET NOCOUNT ON
DECLARE @SQLCMD nvarchar(512)
SET  @SQLCMD = N'SELECT nLogNo, nYear, nMonth, nDay, nWeek, nWeekDay, nGender, nCount FROM tGender WHERE ' + @WhereExpr
EXEC sp_executesql @SQLCMD
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_UserGenderTest]
-- ----------------------------
DROP PROCEDURE [dbo].[p_UserGenderTest]
GO

/****** ??: ?? ???? dbo.p_UserGenderTest    ???? ??: 2005-06-13 ?? 8:20:09 ******/
--SELECT * FROM tGender 
--SELECT DATEADD(dd, -1, GETDATE())
CREATE  PROCEDURE [dbo].[p_UserGenderTest]
	@DATE	NVARCHAR(10) = ''
AS
BEGIN 
	DECLARE @YEAR AS INT
	DECLARE @MONTH AS INT
	DECLARE @DAY AS INT
	DECLARE @LOG_DATE AS NVARCHAR(10)
	DECLARE @BASE_DATE AS NVARCHAR(10)
	IF @DATE = ''
		SET @LOG_DATE = CONVERT(NVARCHAR(10), DATEADD(dd, -1, GETDATE()), 120)
	ELSE
		SET @LOG_DATE = @DATE
	PRINT @LOG_DATE
	PRINT '--------------'
	SET @YEAR  = DATENAME(yyyy, @LOG_DATE)
	SET @MONTH = DATENAME(mm, @LOG_DATE)
	SET @DAY   = DATENAME(dd, @LOG_DATE)
	SET @BASE_DATE = CONVERT(NVARCHAR(10), DATEADD(dd, 1, @LOG_DATE), 120)
	PRINT @BASE_DATE
	PRINT '--------------'
	PRINT @YEAR
	PRINT '--------------'
END
EXEC p_UserGender


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_UserLocation_Query]
-- ----------------------------
DROP PROCEDURE [dbo].[p_UserLocation_Query]
GO

/****** ??: ?? ???? dbo.p_UserLocation_Query    ???? ??: 2005-06-13 ?? 8:20:09 ******/
CREATE PROCEDURE [dbo].[p_UserLocation_Query] 
/*
  UserLocation Query - ??? ??? ?? ???? ?????? ???.
  input:
   - ??? ???
  output:
   - Select? ???
*/
@WhereExpr nvarchar(256)
AS
SET NOCOUNT ON
DECLARE @SQLCMD nvarchar(512)
SET  @SQLCMD = N'SELECT nLogNo, nYear, nMonth, nDay, nWeek, nWeekDay, sLocation, nCount FROM tLocation WHERE ' + @WhereExpr
EXEC sp_executesql @SQLCMD
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[pFindCCU]
-- ----------------------------
DROP PROCEDURE [dbo].[pFindCCU]
GO

create procedure [dbo].[pFindCCU]
/*written by amadeus
*/
@start datetime,
@end	datetime
as
select dDate,w0,w1,w0+w1 total from (
select convert(char(16),dDate,120) dDate ,max(case nWorld when 0 then nCount else 0 end) w0, max(case nWorld when 1 then nCount else 0 end) w1
from tSameTimeChar where dDate between @start and @end
group by convert(char(16),dDate,120)
) as t1

GO

-- ----------------------------
-- Indexes structure for table tAge
-- ----------------------------
CREATE CLUSTERED INDEX [IDX_tAge_sLogDate_nAge_CL] ON [dbo].[tAge]
([sLogDate] ASC, [nAge] ASC) 
WITH (FILLFACTOR = 100)
GO

-- ----------------------------
-- Primary Key structure for table [dbo].[tAge]
-- ----------------------------
ALTER TABLE [dbo].[tAge] ADD PRIMARY KEY NONCLUSTERED ([nLogNo])
GO

-- ----------------------------
-- Indexes structure for table tDayActiveUser
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tDayActiveUser]
-- ----------------------------
ALTER TABLE [dbo].[tDayActiveUser] ADD PRIMARY KEY ([nIndex])
GO

-- ----------------------------
-- Indexes structure for table tDayClassLevel
-- ----------------------------
CREATE INDEX [XIE1tDayClassLevel_Date] ON [dbo].[tDayClassLevel]
([dDate] ASC) 
GO

-- ----------------------------
-- Primary Key structure for table [dbo].[tDayClassLevel]
-- ----------------------------
ALTER TABLE [dbo].[tDayClassLevel] ADD PRIMARY KEY ([nIndex])
GO

-- ----------------------------
-- Indexes structure for table tDayClassLevelPlay
-- ----------------------------
CREATE INDEX [XIE1tDayClassLevelPlay_Date] ON [dbo].[tDayClassLevelPlay]
([dDate] ASC) 
GO

-- ----------------------------
-- Primary Key structure for table [dbo].[tDayClassLevelPlay]
-- ----------------------------
ALTER TABLE [dbo].[tDayClassLevelPlay] ADD PRIMARY KEY ([nIndex])
GO

-- ----------------------------
-- Indexes structure for table tDayUser
-- ----------------------------
CREATE INDEX [XIE1tDayUser_Date] ON [dbo].[tDayUser]
([dDate] ASC) 
GO

-- ----------------------------
-- Primary Key structure for table [dbo].[tDayUser]
-- ----------------------------
ALTER TABLE [dbo].[tDayUser] ADD PRIMARY KEY ([nIndex])
GO

-- ----------------------------
-- Indexes structure for table tGender
-- ----------------------------
CREATE CLUSTERED INDEX [IDX_tGender_sLogDate_nGender_CL] ON [dbo].[tGender]
([sLogDate] ASC, [nGender] ASC) 
WITH (FILLFACTOR = 100)
GO

-- ----------------------------
-- Primary Key structure for table [dbo].[tGender]
-- ----------------------------
ALTER TABLE [dbo].[tGender] ADD PRIMARY KEY NONCLUSTERED ([nLogNo])
GO

-- ----------------------------
-- Indexes structure for table tLocation
-- ----------------------------
CREATE CLUSTERED INDEX [IDX_tLocation_sLogDate_sLocation_CL] ON [dbo].[tLocation]
([sLogDate] ASC, [sLocation] ASC) 
WITH (FILLFACTOR = 100)
GO

-- ----------------------------
-- Primary Key structure for table [dbo].[tLocation]
-- ----------------------------
ALTER TABLE [dbo].[tLocation] ADD PRIMARY KEY NONCLUSTERED ([nLogNo])
GO

-- ----------------------------
-- Indexes structure for table tQuestTimesQ20016
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tQuestTimesQ20016]
-- ----------------------------
ALTER TABLE [dbo].[tQuestTimesQ20016] ADD PRIMARY KEY ([ServerNo], [sID])
GO

-- ----------------------------
-- Indexes structure for table tQuestTimesQ2079
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tQuestTimesQ2079]
-- ----------------------------
ALTER TABLE [dbo].[tQuestTimesQ2079] ADD PRIMARY KEY ([ServerNo], [sID])
GO

-- ----------------------------
-- Indexes structure for table tQuestTimesQ63011
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tQuestTimesQ63011]
-- ----------------------------
ALTER TABLE [dbo].[tQuestTimesQ63011] ADD PRIMARY KEY ([ServerNo], [sID])
GO

-- ----------------------------
-- Indexes structure for table tSameTimeChar
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tSameTimeChar]
-- ----------------------------
ALTER TABLE [dbo].[tSameTimeChar] ADD PRIMARY KEY ([nIndex])
GO
