/*
Navicat SQL Server Data Transfer

Source Server         : 88.198.10.166
Source Server Version : 105000
Source Host           : 88.198.10.166:1433
Source Database       : w00_Character
Source Schema         : dbo

Target Server Type    : SQL Server
Target Server Version : 105000
File Encoding         : 65001

Date: 2012-01-28 20:10:51
*/


-- ----------------------------
-- Table structure for [dbo].[auditCharacterData]
-- ----------------------------
DROP TABLE [dbo].[auditCharacterData]
GO
CREATE TABLE [dbo].[auditCharacterData] (
[audit_log_id] uniqueidentifier NULL DEFAULT (newid()) ,
[audit_log_type] char(3) NOT NULL ,
[audit_user] sysname NOT NULL DEFAULT (suser_sname()) ,
[audit_host] char(50) NULL DEFAULT (host_name()) ,
[audit_application] char(50) NULL DEFAULT (app_name()) ,
[audit_char_no] int NULL ,
[audit_char_money] int NULL ,
[audit_changed] datetime NULL DEFAULT (getdate()) 
)


GO

-- ----------------------------
-- Records of auditCharacterData
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tArenaChallenge]
-- ----------------------------
DROP TABLE [dbo].[tArenaChallenge]
GO
CREATE TABLE [dbo].[tArenaChallenge] (
[nCharNo] int NOT NULL ,
[nMonsterLevel] smallint NOT NULL DEFAULT ((0)) ,
[nMonsterMKC] smallint NOT NULL DEFAULT ((0)) ,
[nMonsterKPS] smallint NOT NULL DEFAULT ((0)) ,
[nMonsterKills] int NOT NULL DEFAULT ((0)) 
)


GO

-- ----------------------------
-- Records of tArenaChallenge
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tArenaFBZ]
-- ----------------------------
DROP TABLE [dbo].[tArenaFBZ]
GO
CREATE TABLE [dbo].[tArenaFBZ] (
[nFBZWin] int NOT NULL DEFAULT ((0)) ,
[nFBZLose] int NOT NULL DEFAULT ((0)) ,
[nFBZLadder] int NOT NULL DEFAULT ((1000)) ,
[nCharNo] int NOT NULL 
)


GO

-- ----------------------------
-- Records of tArenaFBZ
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tArenaGuild]
-- ----------------------------
DROP TABLE [dbo].[tArenaGuild]
GO
CREATE TABLE [dbo].[tArenaGuild] (
[nGuildLose] int NOT NULL DEFAULT ((0)) ,
[nGuildDraw] int NOT NULL DEFAULT ((0)) ,
[nGuildNo] int NOT NULL ,
[nGuildWin] int NOT NULL DEFAULT ((0)) ,
[nGuildLadder] int NOT NULL DEFAULT ((1000)) 
)


GO

-- ----------------------------
-- Records of tArenaGuild
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tArenaPvP]
-- ----------------------------
DROP TABLE [dbo].[tArenaPvP]
GO
CREATE TABLE [dbo].[tArenaPvP] (
[nPvPLadder] int NOT NULL DEFAULT ((1000)) ,
[nPvPWin] int NOT NULL DEFAULT ((0)) ,
[nPvPLose] int NOT NULL DEFAULT ((0)) ,
[nCharNo] int NOT NULL ,
[nPvPDraw] int NOT NULL DEFAULT ((0)) 
)


GO

-- ----------------------------
-- Records of tArenaPvP
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tAutoPick]
-- ----------------------------
DROP TABLE [dbo].[tAutoPick]
GO
CREATE TABLE [dbo].[tAutoPick] (
[nCharNo] int NOT NULL ,
[IsAutoPick] tinyint NOT NULL 
)


GO

-- ----------------------------
-- Records of tAutoPick
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tCharacter]
-- ----------------------------
DROP TABLE [dbo].[tCharacter]
GO
CREATE TABLE [dbo].[tCharacter] (
[nCharNo] int NOT NULL IDENTITY(1,1) ,
[sID] nvarchar(40) NOT NULL ,
[nUserNo] int NOT NULL ,
[nAdminLevel] tinyint NOT NULL DEFAULT ((0)) ,
[nPS] int NOT NULL DEFAULT ((0)) ,
[nGS] int NOT NULL DEFAULT ((0)) ,
[dCreateDate] datetime NOT NULL DEFAULT (getdate()) ,
[bDeleted] tinyint NOT NULL DEFAULT ((0)) ,
[nLoginZoneX] int NOT NULL DEFAULT ((5963)) ,
[nLoginZoneY] int NOT NULL DEFAULT ((9793)) ,
[nLoginZoneD] tinyint NOT NULL DEFAULT ((90)) ,
[nPKYellowTime] tinyint NOT NULL DEFAULT ((0)) ,
[dDeletedDate] datetime NOT NULL DEFAULT (getdate()) ,
[nAP] smallint NOT NULL DEFAULT ((0)) ,
[sLoginZone] varchar(16) NOT NULL DEFAULT ('Rou') ,
[nPKCount] int NOT NULL DEFAULT ((0)) ,
[nLevel] smallint NOT NULL DEFAULT ((1)) ,
[nExp] bigint NOT NULL DEFAULT ((0)) ,
[nSlotNo] tinyint NOT NULL DEFAULT ((0)) ,
[nHP] smallint NOT NULL DEFAULT ((100)) ,
[nSP] smallint NOT NULL DEFAULT ((100)) ,
[nHPS] smallint NOT NULL DEFAULT ((100)) ,
[nSPS] smallint NOT NULL DEFAULT ((100)) ,
[dLastLoginDate] datetime NOT NULL DEFAULT (getdate()) ,
[nLoginCount] int NOT NULL DEFAULT ((0)) ,
[nCreateWorld] tinyint NOT NULL DEFAULT ((0)) ,
[nFame] int NOT NULL DEFAULT ((0)) ,
[nPrisonMin] smallint NOT NULL DEFAULT ((0)) ,
[nPlayMin] int NOT NULL DEFAULT ((0)) ,
[nFlags] int NOT NULL DEFAULT ((0)) ,
[nMoney] bigint NOT NULL DEFAULT ((0)) ,
[nStrength] tinyint NOT NULL DEFAULT ((0)) ,
[nConstitute] tinyint NOT NULL DEFAULT ((0)) ,
[nDexterity] tinyint NOT NULL DEFAULT ((0)) ,
[nIntelligence] tinyint NOT NULL DEFAULT ((0)) ,
[nMentalPower] tinyint NOT NULL DEFAULT ((0)) ,
[nRedistributePoint] tinyint NOT NULL DEFAULT ((0)) ,
[nKQHandle] int NOT NULL DEFAULT ((-1)) ,
[sKQMap] varchar(16) NOT NULL DEFAULT '' ,
[nKQX] int NOT NULL DEFAULT ((0)) ,
[nKQY] int NOT NULL DEFAULT ((0)) ,
[nKQD] tinyint NOT NULL DEFAULT ((90)) ,
[dKQDate] datetime NOT NULL DEFAULT (getdate()) 
)


GO
DBCC CHECKIDENT(N'[dbo].[tCharacter]', RESEED, 5476)
GO

-- ----------------------------
-- Records of tCharacter
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tCharacterChangeID]
-- ----------------------------
DROP TABLE [dbo].[tCharacterChangeID]
GO
CREATE TABLE [dbo].[tCharacterChangeID] (
[nRowNo] int NOT NULL IDENTITY(1,1) ,
[sys_create_date] datetime NOT NULL DEFAULT (getdate()) ,
[sys_update_date] datetime NULL ,
[nUserNo] int NOT NULL ,
[nCharNo] int NOT NULL ,
[bFlag] bit NOT NULL DEFAULT ((0)) ,
[bInit] bit NOT NULL DEFAULT ((0)) ,
[sOldID] nvarchar(50) NULL ,
[sNewID] nvarchar(50) NULL 
)


GO
DBCC CHECKIDENT(N'[dbo].[tCharacterChangeID]', RESEED, 68)
GO

-- ----------------------------
-- Records of tCharacterChangeID
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tCharacterChargedBuffer]
-- ----------------------------
DROP TABLE [dbo].[tCharacterChargedBuffer]
GO
CREATE TABLE [dbo].[tCharacterChargedBuffer] (
[nNo] int NOT NULL IDENTITY(1,1) ,
[nCharNo] int NOT NULL ,
[nKey] int NOT NULL ,
[nID] smallint NOT NULL DEFAULT ((0)) ,
[dUseDate] datetime NOT NULL ,
[dEndDate] datetime NOT NULL 
)


GO
DBCC CHECKIDENT(N'[dbo].[tCharacterChargedBuffer]', RESEED, 21045)
GO

-- ----------------------------
-- Records of tCharacterChargedBuffer
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tCharacterLoading]
-- ----------------------------
DROP TABLE [dbo].[tCharacterLoading]
GO
CREATE TABLE [dbo].[tCharacterLoading] (
[nCharNo] int NOT NULL ,
[nSeqNo] int NOT NULL ,
[dWorldTime] datetime NOT NULL ,
[dDBTime] datetime NOT NULL DEFAULT (getdate()) ,
[sLoadingMapName] varchar(16) NOT NULL ,
[nFailType] smallint NOT NULL ,
[nLoadingFailCnt] smallint NOT NULL 
)


GO

-- ----------------------------
-- Records of tCharacterLoading
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tCharacterOptions]
-- ----------------------------
DROP TABLE [dbo].[tCharacterOptions]
GO
CREATE TABLE [dbo].[tCharacterOptions] (
[nCharNo] int NOT NULL ,
[sShortCutData] varbinary(1024) NULL ,
[sShortCutSize] varbinary(24) NULL ,
[sVideo] varbinary(60) NULL ,
[sSound] varbinary(1) NULL ,
[sGame] varbinary(64) NULL ,
[sWindowsPos] varbinary(392) NULL ,
[sKeyMapping] varbinary(308) NULL 
)


GO

-- ----------------------------
-- Records of tCharacterOptions
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tCharacterShape]
-- ----------------------------
DROP TABLE [dbo].[tCharacterShape]
GO
CREATE TABLE [dbo].[tCharacterShape] (
[nCharNo] int NOT NULL ,
[nClass] tinyint NOT NULL DEFAULT ((0)) ,
[nRace] tinyint NOT NULL DEFAULT ((0)) ,
[nGender] tinyint NOT NULL DEFAULT ((0)) ,
[nHairType] tinyint NOT NULL DEFAULT ((0)) ,
[nHairColor] tinyint NOT NULL DEFAULT ((0)) ,
[nFaceShape] tinyint NOT NULL DEFAULT ((0)) 
)


GO

-- ----------------------------
-- Records of tCharacterShape
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tCharacterSingleOption]
-- ----------------------------
DROP TABLE [dbo].[tCharacterSingleOption]
GO
CREATE TABLE [dbo].[tCharacterSingleOption] (
[nCharNo] int NOT NULL ,
[sys_create_date] datetime NOT NULL DEFAULT (getdate()) ,
[sys_update_date] datetime NULL ,
[bMysteryBolt] bit NOT NULL DEFAULT ((1)) ,
[bAutoPick] bit NOT NULL DEFAULT ((0)) ,
[dRestExpLastExecuteTime] datetime NOT NULL DEFAULT (getdate()) 
)


GO

-- ----------------------------
-- Records of tCharacterSingleOption
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tCharacterState]
-- ----------------------------
DROP TABLE [dbo].[tCharacterState]
GO
CREATE TABLE [dbo].[tCharacterState] (
[nCharNo] int NOT NULL ,
[nStateNo] smallint NOT NULL ,
[nStateLevel] smallint NOT NULL ,
[nStateTime] int NOT NULL ,
[nStateCount] smallint NOT NULL DEFAULT ((0)) ,
[nStatePowerDemage] tinyint NOT NULL DEFAULT ((0)) ,
[nStatePowerSP] tinyint NOT NULL DEFAULT ((0)) ,
[nStatePowerKeepTime] tinyint NOT NULL DEFAULT ((0)) ,
[nStatePowerCoolTime] tinyint NOT NULL DEFAULT ((0)) ,
[nSetItemIndexA] smallint NOT NULL DEFAULT ((0)) ,
[nSetItemValueA] smallint NOT NULL DEFAULT ((0)) ,
[nSetItemIndexB] smallint NOT NULL DEFAULT ((0)) ,
[nSetItemValueB] smallint NOT NULL DEFAULT ((0)) ,
[nSetItemIndexC] smallint NOT NULL DEFAULT ((0)) ,
[nSetItemValueC] smallint NOT NULL DEFAULT ((0)) ,
[nSetItemIndexD] smallint NOT NULL DEFAULT ((0)) ,
[nSetItemValueD] smallint NOT NULL DEFAULT ((0)) ,
[nRestTime] int NOT NULL DEFAULT ((0)) 
)


GO

-- ----------------------------
-- Records of tCharacterState
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tCharacterState_Backup]
-- ----------------------------
DROP TABLE [dbo].[tCharacterState_Backup]
GO
CREATE TABLE [dbo].[tCharacterState_Backup] (
[nCharNo] int NOT NULL ,
[nStateNo] smallint NOT NULL ,
[nStateLevel] smallint NOT NULL ,
[nStateTime] int NOT NULL ,
[nStateCount] smallint NOT NULL ,
[nStatePowerDemage] tinyint NOT NULL ,
[nStatePowerSP] tinyint NOT NULL ,
[nStatePowerKeepTime] tinyint NOT NULL ,
[nStatePowerCoolTime] tinyint NOT NULL 
)


GO

-- ----------------------------
-- Records of tCharacterState_Backup
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tCharacterTitle]
-- ----------------------------
DROP TABLE [dbo].[tCharacterTitle]
GO
CREATE TABLE [dbo].[tCharacterTitle] (
[nNo] bigint NOT NULL IDENTITY(1,1) ,
[dDate] datetime NOT NULL DEFAULT (getdate()) ,
[nCharNo] int NOT NULL ,
[nType] tinyint NOT NULL ,
[nElementNo] tinyint NOT NULL ,
[nElementValue] bigint NOT NULL DEFAULT ((0)) 
)


GO
DBCC CHECKIDENT(N'[dbo].[tCharacterTitle]', RESEED, 285320)
GO

-- ----------------------------
-- Records of tCharacterTitle
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tChatBlock]
-- ----------------------------
DROP TABLE [dbo].[tChatBlock]
GO
CREATE TABLE [dbo].[tChatBlock] (
[nUserNo] int NOT NULL ,
[nCharNo] int NOT NULL ,
[dDate] datetime NOT NULL DEFAULT (getdate()) 
)


GO

-- ----------------------------
-- Records of tChatBlock
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tDice]
-- ----------------------------
DROP TABLE [dbo].[tDice]
GO
CREATE TABLE [dbo].[tDice] (
[nGameNo] int NOT NULL IDENTITY(1,1) ,
[nCharNo] int NOT NULL ,
[nItemKey] bigint NOT NULL ,
[sDice] nvarchar(3) NOT NULL ,
[dDate] datetime NOT NULL DEFAULT (getdate()) 
)


GO
DBCC CHECKIDENT(N'[dbo].[tDice]', RESEED, 54)
GO

-- ----------------------------
-- Records of tDice
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tDiceLog]
-- ----------------------------
DROP TABLE [dbo].[tDiceLog]
GO
CREATE TABLE [dbo].[tDiceLog] (
[nGameNo] int NOT NULL ,
[nCustomCharNo] int NOT NULL ,
[nSlotNo] tinyint NOT NULL ,
[nBattingMoney] bigint NOT NULL ,
[nBattingRate] int NOT NULL ,
[bStatus] bit NOT NULL ,
[nTaxRate] int NOT NULL ,
[nDividend] bigint NOT NULL 
)


GO

-- ----------------------------
-- Records of tDiceLog
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tDicePayLog]
-- ----------------------------
DROP TABLE [dbo].[tDicePayLog]
GO
CREATE TABLE [dbo].[tDicePayLog] (
[nCharNo] int NOT NULL ,
[nItemKey] bigint NOT NULL ,
[nTotalDividend] bigint NOT NULL ,
[dDate] datetime NOT NULL DEFAULT (getdate()) 
)


GO

-- ----------------------------
-- Records of tDicePayLog
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tDiceResult]
-- ----------------------------
DROP TABLE [dbo].[tDiceResult]
GO
CREATE TABLE [dbo].[tDiceResult] (
[nGameNo] int NOT NULL ,
[nCustomCharNo] int NOT NULL ,
[nBeforeMoney] bigint NOT NULL ,
[nTotalDividend] bigint NOT NULL ,
[nAfterMoney] bigint NOT NULL 
)


GO

-- ----------------------------
-- Records of tDiceResult
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tFriend]
-- ----------------------------
DROP TABLE [dbo].[tFriend]
GO
CREATE TABLE [dbo].[tFriend] (
[nCharNo] int NOT NULL ,
[nFriendCharNo] int NOT NULL ,
[nFlags] tinyint NOT NULL DEFAULT ((0)) ,
[dDate] datetime NOT NULL DEFAULT (getdate()) 
)


GO

-- ----------------------------
-- Records of tFriend
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tGuild]
-- ----------------------------
DROP TABLE [dbo].[tGuild]
GO
CREATE TABLE [dbo].[tGuild] (
[nNo] int NOT NULL IDENTITY(1,1) ,
[sName] nvarchar(18) NOT NULL ,
[sPassword] nvarchar(10) NOT NULL ,
[nMaxMembers] smallint NOT NULL DEFAULT ((15)) ,
[nMoney] bigint NOT NULL DEFAULT ((0)) ,
[nType] tinyint NOT NULL DEFAULT ((0)) ,
[nGrade] tinyint NOT NULL DEFAULT ((1)) ,
[nFame] int NOT NULL DEFAULT ((0)) ,
[nStoneLevel] smallint NOT NULL DEFAULT ((1)) ,
[nExp] bigint NOT NULL DEFAULT ((0)) ,
[dCreateDate] datetime NOT NULL DEFAULT (getdate()) ,
[dWarRequestDate] datetime NOT NULL DEFAULT (getdate()) ,
[dWarStartDate] datetime NOT NULL DEFAULT (getdate()) ,
[dWarEndDate] datetime NOT NULL DEFAULT (getdate()) ,
[nWarEnemy] int NOT NULL DEFAULT ((0)) ,
[nWarWinCount] int NOT NULL DEFAULT ((0)) ,
[nWarLoseCount] int NOT NULL DEFAULT ((0)) ,
[nWarDrawCount] int NOT NULL DEFAULT ((0)) ,
[nDismissStatus] tinyint NOT NULL DEFAULT ((0)) ,
[dDismissDate] datetime NOT NULL DEFAULT (getdate()) ,
[sIntro] nvarchar(128) NOT NULL DEFAULT '' ,
[dNotifyDate] datetime NOT NULL DEFAULT (getdate()) ,
[sNotifyCharID] nvarchar(17) NOT NULL DEFAULT '' ,
[sNotify] nvarchar(512) NOT NULL DEFAULT '' 
)


GO
DBCC CHECKIDENT(N'[dbo].[tGuild]', RESEED, 179)
GO

-- ----------------------------
-- Records of tGuild
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tGuildAcademy]
-- ----------------------------
DROP TABLE [dbo].[tGuildAcademy]
GO
CREATE TABLE [dbo].[tGuildAcademy] (
[nNo] int NOT NULL ,
[nMasterCharNo] int NOT NULL ,
[nMaxMember] smallint NOT NULL ,
[nMoney] bigint NOT NULL DEFAULT ((0)) ,
[nPoint] int NOT NULL DEFAULT ((0)) ,
[dBuffEndTime] datetime NULL ,
[dNotifyDate] datetime NULL ,
[sNotify] nvarchar(512) NULL ,
[sIntro] nvarchar(128) NULL 
)


GO

-- ----------------------------
-- Records of tGuildAcademy
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tGuildAcademyGraduate]
-- ----------------------------
DROP TABLE [dbo].[tGuildAcademyGraduate]
GO
CREATE TABLE [dbo].[tGuildAcademyGraduate] (
[nNo] int NOT NULL ,
[nCharNo] int NOT NULL ,
[sID] nvarchar(40) NOT NULL ,
[nClass] tinyint NOT NULL ,
[nJoinLevel] smallint NOT NULL ,
[dJoinDate] datetime NOT NULL DEFAULT (getdate()) ,
[nGraduateLevel] smallint NOT NULL ,
[dGraduateDate] datetime NOT NULL DEFAULT (getdate()) 
)


GO

-- ----------------------------
-- Records of tGuildAcademyGraduate
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tGuildAcademyMember]
-- ----------------------------
DROP TABLE [dbo].[tGuildAcademyMember]
GO
CREATE TABLE [dbo].[tGuildAcademyMember] (
[nNo] int NOT NULL ,
[nCharNo] int NOT NULL ,
[nJoinLevel] smallint NOT NULL ,
[dJoinDate] datetime NOT NULL DEFAULT (getdate()) ,
[nGrade] tinyint NULL DEFAULT ((255)) ,
[sIntro] nvarchar(128) NULL 
)


GO

-- ----------------------------
-- Records of tGuildAcademyMember
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tGuildAcademyRanking]
-- ----------------------------
DROP TABLE [dbo].[tGuildAcademyRanking]
GO
CREATE TABLE [dbo].[tGuildAcademyRanking] (
[nRowNo] int NOT NULL IDENTITY(1,1) ,
[dDate] datetime NOT NULL DEFAULT (getdate()) ,
[nRanking] int NOT NULL ,
[nGuildNo] int NOT NULL ,
[sGuildName] nvarchar(18) NOT NULL ,
[nMasterNo] int NOT NULL ,
[sMasterID] nvarchar(40) NOT NULL ,
[nPoint] int NOT NULL ,
[nCount] int NOT NULL 
)


GO
DBCC CHECKIDENT(N'[dbo].[tGuildAcademyRanking]', RESEED, 3138)
GO

-- ----------------------------
-- Records of tGuildAcademyRanking
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tGuildAcademyReward]
-- ----------------------------
DROP TABLE [dbo].[tGuildAcademyReward]
GO
CREATE TABLE [dbo].[tGuildAcademyReward] (
[nNo] int NOT NULL ,
[nLevel] smallint NOT NULL ,
[nTypeID] tinyint NOT NULL ,
[nValue] bigint NULL ,
[nItemID] int NULL 
)


GO

-- ----------------------------
-- Records of tGuildAcademyReward
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tGuildAcademyRewardType]
-- ----------------------------
DROP TABLE [dbo].[tGuildAcademyRewardType]
GO
CREATE TABLE [dbo].[tGuildAcademyRewardType] (
[nTypeID] tinyint NOT NULL ,
[sTypeName] nvarchar(20) NOT NULL 
)


GO

-- ----------------------------
-- Records of tGuildAcademyRewardType
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tGuildMember]
-- ----------------------------
DROP TABLE [dbo].[tGuildMember]
GO
CREATE TABLE [dbo].[tGuildMember] (
[nNo] int NOT NULL ,
[nCharNo] int NOT NULL ,
[dJoinDate] datetime NOT NULL DEFAULT (getdate()) ,
[nGrade] tinyint NOT NULL DEFAULT ((0)) ,
[nFlags] int NOT NULL DEFAULT ((0)) ,
[nExpRatio] smallint NOT NULL DEFAULT ((0)) ,
[sIntro] nvarchar(64) NOT NULL DEFAULT '' 
)


GO

-- ----------------------------
-- Records of tGuildMember
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tGuildToken]
-- ----------------------------
DROP TABLE [dbo].[tGuildToken]
GO
CREATE TABLE [dbo].[tGuildToken] (
[nNo] int NOT NULL ,
[nToken] bigint NOT NULL 
)


GO

-- ----------------------------
-- Records of tGuildToken
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tGuildTournament]
-- ----------------------------
DROP TABLE [dbo].[tGuildTournament]
GO
CREATE TABLE [dbo].[tGuildTournament] (
[nGTNo] int NOT NULL ,
[nType] smallint NOT NULL ,
[nData] int NOT NULL 
)


GO

-- ----------------------------
-- Records of tGuildTournament
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tGuildTournamentRegist]
-- ----------------------------
DROP TABLE [dbo].[tGuildTournamentRegist]
GO
CREATE TABLE [dbo].[tGuildTournamentRegist] (
[nGTNo] int NOT NULL ,
[nNo] int NOT NULL ,
[nMoney] bigint NOT NULL ,
[dDate] datetime NOT NULL DEFAULT (getdate()) ,
[nSeed] int NOT NULL DEFAULT ((0)) ,
[bChoice] bit NOT NULL DEFAULT ((0)) 
)


GO

-- ----------------------------
-- Records of tGuildTournamentRegist
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tHolyPromise]
-- ----------------------------
DROP TABLE [dbo].[tHolyPromise]
GO
CREATE TABLE [dbo].[tHolyPromise] (
[nCharNo] int NOT NULL ,
[nUpCharNo] int NOT NULL ,
[nFlags] tinyint NOT NULL ,
[dRegDate] datetime NOT NULL DEFAULT (getdate()) ,
[dRejoinableDate] datetime NOT NULL DEFAULT (getdate()) ,
[dMemberAcceptableDate] datetime NOT NULL DEFAULT (getdate()) 
)


GO

-- ----------------------------
-- Records of tHolyPromise
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tHolyPromiseReward]
-- ----------------------------
DROP TABLE [dbo].[tHolyPromiseReward]
GO
CREATE TABLE [dbo].[tHolyPromiseReward] (
[nCharNo] int NOT NULL ,
[nSeqNo] int NOT NULL ,
[nType] tinyint NOT NULL ,
[nMoney] bigint NOT NULL ,
[nRemainMoney] bigint NOT NULL ,
[nReceiptCharNo] int NOT NULL ,
[dDate] datetime NOT NULL DEFAULT (getdate()) 
)


GO

-- ----------------------------
-- Records of tHolyPromiseReward
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tItem]
-- ----------------------------
DROP TABLE [dbo].[tItem]
GO
CREATE TABLE [dbo].[tItem] (
[nItemKey] bigint NOT NULL ,
[nStorageType] tinyint NOT NULL ,
[nOwner] bigint NOT NULL ,
[nStorage] smallint NOT NULL ,
[nItemID] int NOT NULL ,
[nFlags] int NOT NULL DEFAULT ((0)) ,
[dDate] datetime NOT NULL DEFAULT (getdate()) 
)


GO

-- ----------------------------
-- Records of tItem
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tItemMobList]
-- ----------------------------
DROP TABLE [dbo].[tItemMobList]
GO
CREATE TABLE [dbo].[tItemMobList] (
[nItemKey] bigint NOT NULL ,
[nMobID] smallint NOT NULL ,
[nGrade] tinyint NOT NULL DEFAULT ((1)) ,
[nKillCount] int NOT NULL DEFAULT ((0)) 
)


GO

-- ----------------------------
-- Records of tItemMobList
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tItemOptions]
-- ----------------------------
DROP TABLE [dbo].[tItemOptions]
GO
CREATE TABLE [dbo].[tItemOptions] (
[nItemKey] bigint NOT NULL ,
[nOptionType] smallint NOT NULL ,
[nOptionData] bigint NOT NULL 
)


GO

-- ----------------------------
-- Records of tItemOptions
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tItemTitle]
-- ----------------------------
DROP TABLE [dbo].[tItemTitle]
GO
CREATE TABLE [dbo].[tItemTitle] (
[nItemKey] bigint NOT NULL ,
[nTitleType] smallint NOT NULL DEFAULT ((0)) ,
[sTitle] nvarchar(24) NOT NULL ,
[nTitleCharNo] int NOT NULL DEFAULT ((0)) 
)


GO

-- ----------------------------
-- Records of tItemTitle
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tKingdomQuest]
-- ----------------------------
DROP TABLE [dbo].[tKingdomQuest]
GO
CREATE TABLE [dbo].[tKingdomQuest] (
[nQuestNo] smallint NOT NULL ,
[sData] varchar(256) NOT NULL 
)


GO

-- ----------------------------
-- Records of tKingdomQuest
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tLevelCatchUpRank]
-- ----------------------------
DROP TABLE [dbo].[tLevelCatchUpRank]
GO
CREATE TABLE [dbo].[tLevelCatchUpRank] (
[sID] nvarchar(40) NOT NULL ,
[GuildName] nvarchar(18) NULL ,
[nClass] tinyint NOT NULL ,
[nLevel] smallint NOT NULL ,
[dLastUpdated] datetime NOT NULL 
)


GO

-- ----------------------------
-- Records of tLevelCatchUpRank
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tMarriage]
-- ----------------------------
DROP TABLE [dbo].[tMarriage]
GO
CREATE TABLE [dbo].[tMarriage] (
[nCharNo] int NOT NULL ,
[nPartnerCharNo] int NOT NULL ,
[nStatus] tinyint NOT NULL DEFAULT ((0)) ,
[nSubStatus] tinyint NOT NULL DEFAULT ((0)) ,
[dWhen] datetime NOT NULL ,
[dSubWhen] datetime NOT NULL ,
[nMarriageCount] tinyint NOT NULL DEFAULT ((0)) ,
[nDivorceCancel] tinyint NOT NULL DEFAULT ((0)) 
)


GO

-- ----------------------------
-- Records of tMarriage
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tMasterPupils]
-- ----------------------------
DROP TABLE [dbo].[tMasterPupils]
GO
CREATE TABLE [dbo].[tMasterPupils] (
[nPupils] int NOT NULL ,
[nMaster] int NOT NULL ,
[nFlags] int NOT NULL DEFAULT ((0)) ,
[dRegDate] datetime NOT NULL DEFAULT (getdate()) 
)


GO

-- ----------------------------
-- Records of tMasterPupils
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tMinihouse]
-- ----------------------------
DROP TABLE [dbo].[tMinihouse]
GO
CREATE TABLE [dbo].[tMinihouse] (
[nCharNo] int NOT NULL ,
[nVisitor] int NOT NULL DEFAULT ((0)) ,
[dDate] datetime NOT NULL DEFAULT (getdate()) 
)


GO

-- ----------------------------
-- Records of tMinihouse
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tMinihouseGate]
-- ----------------------------
DROP TABLE [dbo].[tMinihouseGate]
GO
CREATE TABLE [dbo].[tMinihouseGate] (
[nCharNo] int NOT NULL ,
[nItemID] int NOT NULL ,
[bType] tinyint NOT NULL DEFAULT ((1)) ,
[dDate] datetime NOT NULL DEFAULT (getdate()) ,
[dEndDate] datetime NULL 
)


GO

-- ----------------------------
-- Records of tMinihouseGate
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tMinihouseGuest]
-- ----------------------------
DROP TABLE [dbo].[tMinihouseGuest]
GO
CREATE TABLE [dbo].[tMinihouseGuest] (
[nArticleNo] int NOT NULL IDENTITY(1,1) ,
[nCharNo] int NOT NULL ,
[nWriterNo] int NOT NULL ,
[sWriterID] nvarchar(40) NOT NULL ,
[sContent] nvarchar(1000) NOT NULL ,
[dDate] datetime NOT NULL DEFAULT (getdate()) 
)


GO

-- ----------------------------
-- Records of tMinihouseGuest
-- ----------------------------
SET IDENTITY_INSERT [dbo].[tMinihouseGuest] ON
GO
SET IDENTITY_INSERT [dbo].[tMinihouseGuest] OFF
GO

-- ----------------------------
-- Table structure for [dbo].[tParty]
-- ----------------------------
DROP TABLE [dbo].[tParty]
GO
CREATE TABLE [dbo].[tParty] (
[nFlags] int NOT NULL DEFAULT ((0)) ,
[nMasterCharNo] int NOT NULL ,
[nPartyNo] int NOT NULL IDENTITY(1,1) 
)


GO

-- ----------------------------
-- Records of tParty
-- ----------------------------
SET IDENTITY_INSERT [dbo].[tParty] ON
GO
SET IDENTITY_INSERT [dbo].[tParty] OFF
GO

-- ----------------------------
-- Table structure for [dbo].[tPartyMember]
-- ----------------------------
DROP TABLE [dbo].[tPartyMember]
GO
CREATE TABLE [dbo].[tPartyMember] (
[nCharNo] int NOT NULL ,
[nFlag] tinyint NOT NULL DEFAULT ((0)) ,
[nPartyNo] int NOT NULL 
)


GO

-- ----------------------------
-- Records of tPartyMember
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tPet]
-- ----------------------------
DROP TABLE [dbo].[tPet]
GO
CREATE TABLE [dbo].[tPet] (
[nStorage] smallint NOT NULL ,
[nPetNumber] tinyint NOT NULL DEFAULT ((0)) ,
[nOwner] bigint NOT NULL ,
[nPetKey] bigint NOT NULL ,
[nPetID] int NOT NULL ,
[sInfo] varchar(32) NOT NULL DEFAULT '' ,
[nFlags] int NOT NULL DEFAULT ((0)) ,
[nAssignName] nvarchar(24) NOT NULL DEFAULT '' ,
[nLevel] smallint NOT NULL DEFAULT ((1)) ,
[nExp] bigint NOT NULL DEFAULT ((0)) ,
[nSatiety] tinyint NOT NULL DEFAULT ((0)) ,
[nSpeed] tinyint NOT NULL DEFAULT ((1)) ,
[nAbilityType] tinyint NOT NULL DEFAULT ((0)) ,
[nAbilityValue] tinyint NOT NULL DEFAULT ((0)) ,
[nSkinColor] tinyint NOT NULL DEFAULT ((0)) ,
[dDate] datetime NOT NULL DEFAULT (getdate()) 
)


GO

-- ----------------------------
-- Records of tPet
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tPetSkill]
-- ----------------------------
DROP TABLE [dbo].[tPetSkill]
GO
CREATE TABLE [dbo].[tPetSkill] (
[nSkillLevel] tinyint NOT NULL DEFAULT ((0)) ,
[nSkillNo] int NOT NULL ,
[nSkillExp] int NOT NULL DEFAULT ((0)) ,
[nPetKey] bigint NOT NULL 
)


GO

-- ----------------------------
-- Records of tPetSkill
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tPrison]
-- ----------------------------
DROP TABLE [dbo].[tPrison]
GO
CREATE TABLE [dbo].[tPrison] (
[nPrisonNum] bigint NOT NULL IDENTITY(1,1) ,
[nCharID] int NOT NULL ,
[dPrisonDate] datetime NOT NULL DEFAULT (getdate()) ,
[nMinute] smallint NOT NULL ,
[sReason] nvarchar(16) NULL ,
[nRegNumber] bigint NULL DEFAULT ((0)) ,
[sGmID] nvarchar(16) NULL ,
[sRemark] nvarchar(64) NULL 
)


GO
DBCC CHECKIDENT(N'[dbo].[tPrison]', RESEED, 18)
GO

-- ----------------------------
-- Records of tPrison
-- ----------------------------
SET IDENTITY_INSERT [dbo].[tPrison] ON
GO
SET IDENTITY_INSERT [dbo].[tPrison] OFF
GO

-- ----------------------------
-- Table structure for [dbo].[tQuest]
-- ----------------------------
DROP TABLE [dbo].[tQuest]
GO
CREATE TABLE [dbo].[tQuest] (
[nCharNo] int NOT NULL ,
[nQuestNo] int NOT NULL ,
[nStatus] tinyint NOT NULL ,
[sData] varbinary(100) NOT NULL 
)


GO

-- ----------------------------
-- Records of tQuest
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tQuest_63009]
-- ----------------------------
DROP TABLE [dbo].[tQuest_63009]
GO
CREATE TABLE [dbo].[tQuest_63009] (
[nCharNo] int NOT NULL ,
[nQuestNo] int NOT NULL ,
[nStatus] tinyint NOT NULL ,
[sData] varbinary(100) NOT NULL 
)


GO

-- ----------------------------
-- Records of tQuest_63009
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tQuestTimes]
-- ----------------------------
DROP TABLE [dbo].[tQuestTimes]
GO
CREATE TABLE [dbo].[tQuestTimes] (
[nCharNo] int NOT NULL ,
[nQuestNo] int NOT NULL ,
[nTimes] int NOT NULL DEFAULT ((0)) ,
[dLastComplete] datetime NOT NULL DEFAULT (getdate()) 
)


GO

-- ----------------------------
-- Records of tQuestTimes
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tRestExp]
-- ----------------------------
DROP TABLE [dbo].[tRestExp]
GO
CREATE TABLE [dbo].[tRestExp] (
[nCharNo] int NOT NULL ,
[dRestExpLastExcuteTime] datetime NOT NULL 
)


GO

-- ----------------------------
-- Records of tRestExp
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tSkill]
-- ----------------------------
DROP TABLE [dbo].[tSkill]
GO
CREATE TABLE [dbo].[tSkill] (
[nCharNo] int NOT NULL ,
[nSkillNo] smallint NOT NULL ,
[nSkillLevel] tinyint NOT NULL DEFAULT ((1)) ,
[nSkillExp] int NOT NULL DEFAULT ((0)) ,
[nSkillWriteTime] bigint NOT NULL DEFAULT ((0)) ,
[nSkillCoolTime] int NOT NULL DEFAULT ((0)) ,
[nSkillPowerDemage] tinyint NOT NULL DEFAULT ((0)) ,
[nSkillPowerSP] tinyint NOT NULL DEFAULT ((0)) ,
[nSkillPowerKeepTime] tinyint NOT NULL DEFAULT ((0)) ,
[nSkillPowerCoolTime] tinyint NOT NULL DEFAULT ((0)) 
)


GO

-- ----------------------------
-- Records of tSkill
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tSpamBlockTime]
-- ----------------------------
DROP TABLE [dbo].[tSpamBlockTime]
GO
CREATE TABLE [dbo].[tSpamBlockTime] (
[nCharNo] int NOT NULL ,
[sys_create_date] datetime NOT NULL DEFAULT (getdate()) ,
[sys_update_date] datetime NULL ,
[nBlockTime] int NOT NULL DEFAULT ((0)) ,
[nStandbyTime] int NOT NULL DEFAULT ((0)) 
)


GO

-- ----------------------------
-- Records of tSpamBlockTime
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tSpamFilter]
-- ----------------------------
DROP TABLE [dbo].[tSpamFilter]
GO
CREATE TABLE [dbo].[tSpamFilter] (
[nUserNo] int NOT NULL ,
[sys_create_date] datetime NOT NULL DEFAULT (getdate()) ,
[sys_update_date] datetime NULL ,
[bIsSpamSpread] bit NOT NULL DEFAULT ((0)) ,
[bIsSpamBlock] bit NOT NULL DEFAULT ((0)) ,
[nSpamFilterRate] tinyint NOT NULL DEFAULT ((100)) 
)


GO

-- ----------------------------
-- Records of tSpamFilter
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tUserMoney]
-- ----------------------------
DROP TABLE [dbo].[tUserMoney]
GO
CREATE TABLE [dbo].[tUserMoney] (
[nUserNo] int NOT NULL ,
[nUserMoney] bigint NOT NULL DEFAULT ((0)) 
)


GO

-- ----------------------------
-- Records of tUserMoney
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[Waits_Sysprocesses]
-- ----------------------------
DROP TABLE [dbo].[Waits_Sysprocesses]
GO
CREATE TABLE [dbo].[Waits_Sysprocesses] (
[logdate] datetime NOT NULL ,
[spid] smallint NOT NULL ,
[Wait Time (s)] numeric(17,6) NULL ,
[lastwaittype] nchar(32) NOT NULL ,
[waitresource] nchar(256) NOT NULL ,
[dbid] smallint NOT NULL ,
[uid] smallint NOT NULL ,
[cpu] int NOT NULL ,
[physical_io] bigint NOT NULL ,
[memusage] int NOT NULL ,
[last_batch] datetime NOT NULL ,
[open_tran] smallint NOT NULL ,
[sid] binary(86) NOT NULL ,
[hostname] nchar(128) NOT NULL ,
[program_name] nchar(128) NOT NULL ,
[nt_username] nchar(128) NOT NULL ,
[loginame] nchar(128) NOT NULL ,
[sql_text] varchar(8000) NULL 
)


GO

-- ----------------------------
-- Records of Waits_Sysprocesses
-- ----------------------------

-- ----------------------------
-- View structure for [dbo].[VT_CHAR]
-- ----------------------------
DROP VIEW [dbo].[VT_CHAR]
GO
CREATE VIEW [dbo].[VT_CHAR] AS 
SELECT   dbo.tCharacter.nCharNo AS CharNo, dbo.tCharacter.sID AS CharID, 
                dbo.tCharacter.nUserNo AS UserNo, dbo.tCharacter.nAdminLevel AS AdminLevel, 
                dbo.tCharacter.nPS AS PS, dbo.tCharacter.nGS AS GS, 
                dbo.tCharacter.dCreateDate AS CreateDate, dbo.tCharacter.bDeleted AS IsDel, 
                dbo.tCharacter.nLoginZoneX AS X, dbo.tCharacter.nLoginZoneY AS Y, 
                dbo.tCharacter.dDeletedDate AS DeletedDate, dbo.tCharacter.nAP AS AP, 
                dbo.tCharacter.sLoginZone AS Zone, dbo.tCharacter.nLevel AS Lvl, 
                dbo.tCharacter.nExp AS Experience, dbo.tCharacter.nSlotNo AS SlotNo, 
                dbo.tCharacter.nHP AS HP, dbo.tCharacter.nSP AS SP, 
                dbo.tCharacter.nHPS AS HPS, dbo.tCharacter.nSPS AS SPS, 
                dbo.tCharacter.dLastLoginDate AS LogDate, 
                dbo.tCharacter.nLoginCount AS LogCount, dbo.tCharacter.nCreateWorld AS World, 
                dbo.tCharacter.nPlayMin AS PlayTime, dbo.tCharacter.nFlags AS Flags, 
                dbo.tCharacter.nMoney AS Money, dbo.tCharacterShape.nClass AS Class, 
                dbo.tCharacterShape.nRace AS Race, dbo.tCharacterShape.nGender AS Sex, 
                dbo.tCharacterShape.nHairType AS HairType, 
                dbo.tCharacterShape.nHairColor AS HairColor, 
                dbo.tCharacterShape.nFaceShape AS Face
FROM      dbo.tCharacter INNER JOIN
                dbo.tCharacterShape ON dbo.tCharacter.nCharNo = dbo.tCharacterShape.nCharNo
GO

-- ----------------------------
-- View structure for [dbo].[VT_ITEM]
-- ----------------------------
DROP VIEW [dbo].[VT_ITEM]
GO
CREATE VIEW [dbo].[VT_ITEM] AS 
SELECT   TOP 100 PERCENT dbo.tItem.nOwner AS Owner, 
                dbo.tItem.nStorageType AS StorageType, dbo.tItem.nStorage AS Storage, 
                dbo.tItem.nItemKey AS Itemkey, dbo.tItem.nItemID AS ItemID, 
                dbo.tItemOptions.nOptionType AS OptionType, 
                dbo.tItemOptions.nOptionData AS OptionData, dbo.tItemMobList.nMobID AS MobID, 
                dbo.tItemMobList.nGrade AS MobGrade, dbo.tItemMobList.nKillCount AS MobKillCount, 
                dbo.tItemTitle.nTitleType AS TitleType, dbo.tItemTitle.sTitle AS TitleName, 
                dbo.tItemTitle.nTitleCharNo AS TitleCreator, dbo.tItem.dDate AS CreateDate, 
                dbo.tItem.nFlags AS Flags
FROM      dbo.tItem LEFT OUTER JOIN
                dbo.tItemMobList ON 
                dbo.tItem.nItemKey = dbo.tItemMobList.nItemKey LEFT OUTER JOIN
                dbo.tItemTitle ON dbo.tItem.nItemKey = dbo.tItemTitle.nItemKey LEFT OUTER JOIN
                dbo.tItemOptions ON dbo.tItem.nItemKey = dbo.tItemOptions.nItemKey
GROUP BY dbo.tItem.nOwner, dbo.tItem.nStorageType, dbo.tItem.nStorage, 
                dbo.tItem.nItemKey, dbo.tItem.nItemID, dbo.tItemOptions.nOptionType, 
                dbo.tItemOptions.nOptionData, dbo.tItemMobList.nMobID, 
                dbo.tItemMobList.nGrade, dbo.tItemMobList.nKillCount, dbo.tItemTitle.nTitleType, 
                dbo.tItemTitle.sTitle, dbo.tItemTitle.nTitleCharNo, dbo.tItem.dDate, 
                dbo.tItem.nFlags
ORDER BY dbo.tItem.nOwner, dbo.tItem.nStorageType, dbo.tItem.nStorage, 
                dbo.tItem.nItemKey, dbo.tItem.nItemID, dbo.tItemOptions.nOptionType, 
                dbo.tItemOptions.nOptionData, dbo.tItemMobList.nMobID, 
                dbo.tItemMobList.nGrade, dbo.tItemMobList.nKillCount, dbo.tItemTitle.nTitleType, 
                dbo.tItemTitle.sTitle, dbo.tItemTitle.nTitleCharNo, dbo.tItem.dDate, 
                dbo.tItem.nFlags
GO

-- ----------------------------
-- View structure for [dbo].[VT_ITEM_BRIF]
-- ----------------------------
DROP VIEW [dbo].[VT_ITEM_BRIF]
GO
CREATE VIEW [dbo].[VT_ITEM_BRIF] AS 
SELECT   TOP 100 PERCENT dbo.tItem.nOwner AS 소유자, 
                dbo.tItem.nStorageType AS 인벤종류, dbo.tItem.nStorage AS 인벤위치, 
                dbo.tItem.nItemKey AS 아템키, dbo.tItem.nItemID AS 아템아뒤, 
                dbo.tItemTitle.nTitleType AS 타이틀타입, dbo.tItemTitle.sTitle AS 타이틀, 
                dbo.tItemTitle.nTitleCharNo AS 타이틀부여자, dbo.tItem.dDate AS 만든날, 
                dbo.tItem.nFlags AS 예비정보
FROM      dbo.tItem LEFT OUTER JOIN
                dbo.tItemTitle ON dbo.tItem.nItemKey = dbo.tItemTitle.nItemKey
ORDER BY dbo.tItem.nOwner, dbo.tItem.nStorageType, dbo.tItem.nStorage, 
                dbo.tItem.nItemKey, dbo.tItem.nItemID, dbo.tItemTitle.nTitleType, 
                dbo.tItemTitle.sTitle, dbo.tItemTitle.nTitleCharNo, dbo.tItem.dDate, 
                dbo.tItem.nFlags
GO

-- ----------------------------
-- Procedure structure for [dbo].[Adam_ListProc]
-- ----------------------------
DROP PROCEDURE [dbo].[Adam_ListProc]
GO
create procedure [dbo].[Adam_ListProc] as  select o.name, m.definition   from sys.sql_modules m join sys.objects o  On m.object_id=o.object_id and o.type='P'

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_AddExp]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_AddExp]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_AddExp    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/

/*==================================================
@author	lenasoft
@date	2006-04-07
@return	0		<성공>
	others		<실패>
@brief	케릭서 저장 프로시져화.
==================================================*/


CREATE PROCEDURE [dbo].[p_Char_AddExp]
@nCharNo int,
@nExp bigint

AS
SET NOCOUNT ON

UPDATE tCharacter 
	SET 
		nExp=nExp+@nExp
	WHERE nCharNo=@nCharNo

return @@error

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_ChangeClass]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_ChangeClass]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_ChangeClass    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/

/*==================================================
@author	lenasoft
@date	2006-04-07
@return	0		<성공>
	others		<실패>
@brief	케릭서 저장 프로시져화.
==================================================*/


CREATE PROCEDURE [dbo].[p_Char_ChangeClass]
@nCharNo int,
@nClass tinyint

AS
SET NOCOUNT ON

UPDATE tCharacterShape 
	SET 
		nClass=@nClass
	WHERE nCharNo=@nCharNo

return @@error

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_ChangeID]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_ChangeID]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_ChangeID    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Char_ChangeID]
/*
Character change ID 
2004.9 By CJC
 input:
   See code
 output: 
   1 = ok
   0 = error
*/
@nCharNo int,
@sID nvarchar(40), 
@nRet int OUTPUT
AS
SET NOCOUNT ON
-- Change Char ID
UPDATE tCharacter SET sID = @sID WHERE nCharNo = @nCharNo
IF @@ERROR <> 0 OR @@ROWCOUNT = 0
BEGIN
	SET @nRet = 0
	RETURN
END
-- success
SET @nRet = 1
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_CheckOptionsExistance]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_CheckOptionsExistance]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_CheckOptionsExistance    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/
 /*
-----------------------------------
SadPig : 2006.7.6 (OPTool)
	Input Parameter
		@nCharNo : Character No		

	Output Parameter
		@nRet		
		0 : Not Exist
		1 : Exist
-----------------------------------
*/

CREATE PROCEDURE [dbo].[p_Char_CheckOptionsExistance]
	@nCharNo		int,
	@nRet			int OUTPUT
AS

BEGIN
	SET NOCOUNT ON
	SET LOCK_TIMEOUT 5000
	
	IF EXISTS(SELECT * FROM  tCharacterOptions WHERE nCharNo = @nCharNo )
		SET @nRet = 1
	ELSE
		SET @nRet = 0
	
	SET LOCK_TIMEOUT -1
	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_Create]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_Create]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_Create    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Char_Create] 
/*
Character Create 
2004.6 By CJC
 input:
   All Args
 output: 
   nCharNo = 1~? 생성된 캐릭의 번호(에러시 = 0 )
           =  0 캐릭 생성 에러
           = -1 해당 유저의 슬롯에 캐릭이 있음.
           = -2 캐릭 외모 기록 에러
           = -3 캐릭 옵션 기록 에러
*/
@nUserNo int,			-- 1	1 ~ ?
@nCreateWorld tinyint,	-- 2	0 ~ ?
@nAdminLevel tinyint,	-- 3	0=USER, 1~?=GM Level 1~?
@nSlotNo tinyint,		-- 4	0 ~ 5
@sID nvarchar(40),		-- 5  
@nRace tinyint,			-- 6	0 = Human, 1 = Elf, 2 = Dark elf
@nClass tinyint,		-- 7	1 = Fighter,4 = Cleric, 7 = Archer, 10 = Mage
@nGender tinyint,		-- 8	0 = Male, 1 = Female
@nHairType tinyint,		-- 9	0 ~ ?
@nHairColor tinyint,	-- 10	0 ~ ?
@nFaceShape tinyint,	-- 11	0 ~ ?
@nCharNo int OUTPUT     -- 12
AS
SET NOCOUNT ON
-- 에러코드 일단 세팅
SET @nCharNo = 0
-- 해당유저의 해당슬롯에 캐릭이 있는지 확인
IF EXISTS (SELECT nUserNo FROM tCharacter(NOLOCK) WHERE nUserNo = @nUserNo AND nSlotNo = @nSlotNo AND bDeleted = 0)
BEGIN
	SET @nCharNo = -1
	RETURN
END
IF EXISTS (SELECT sID FROM tCharacter(NOLOCK) WHERE sID = @sID)
    BEGIN
    RETURN
    END
    ELSE
-- 캐릭 생성
BEGIN TRAN
IF EXISTS (SELECT sID FROM tCharacter(NOLOCK) WHERE sID = @sID)
    BEGIN
    RETURN
    END
    ELSE
INSERT tCharacter (  nUserNo,  nSlotNo,  sID,  nCreateWorld,  nAdminLevel )
VALUES            ( @nUserNo, @nSlotNo, @sID, @nCreateWorld, @nAdminLevel )
IF @@ERROR <> 0
BEGIN
	ROLLBACK TRAN
	RETURN
END
SET @nCharNo = @@IDENTITY
-- 캐릭 외모 세팅
INSERT tCharacterShape (  nCharNo,  nRace,  nClass,  nGender,  nHairType,  nHairColor,  nFaceShape )
VALUES                 ( @nCharNo, @nRace, @nClass, @nGender, @nHairType, @nHairColor, @nFaceShape ) 
IF @@ERROR <> 0
BEGIN
	ROLLBACK TRAN
	SET @nCharNo = -2
	RETURN
END
-- 캐릭 옵션 세팅
INSERT tCharacterOptions (  nCharNo )
VALUES                   ( @nCharNo )
IF @@ERROR <> 0
BEGIN
	ROLLBACK TRAN
	SET @nCharNo = -3
	RETURN
END
-- 캐릭 생성 성공
COMMIT TRAN
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_CreateSetDefaultData]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_CreateSetDefaultData]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_CreateSetDefaultData    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Char_CreateSetDefaultData]
/*
Character Create set default data
2005.6 By CJC

 input:
   All args
   
 output: 
   0 = error
   1 = ok
*/
-- Character columns
@nCharNo int,
@sLoginZone varchar(16),
@nLoginZoneX int,
@nLoginZoneY int,
@nHP smallint, 
@nSP smallint, 
@nHPS smallint,
@nSPS smallint,
@nMoney bigint,
-- Output var
@nRet int OUTPUT

AS

SET NOCOUNT ON

UPDATE tCharacter SET
	sLoginZone	= @sLoginZone,
	nLoginZoneX	= @nLoginZoneX,
	nLoginZoneY	= @nLoginZoneY,
	nHP			= @nHP,
	nSP			= @nSP,
	nHPS		= @nHPS,
	nSPS		= @nSPS,
	nMoney		= @nMoney
WHERE nCharNo = @nCharNo

IF @@ERROR <> 0 OR @@ROWCOUNT = 0
BEGIN
	SET @nRet = 0
	RETURN
END

SET @nRet = 1
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_DelChargedBuff]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_DelChargedBuff]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_DelChargedBuff    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/

CREATE PROCEDURE [dbo].[p_Char_DelChargedBuff]
/*
Char Delete charged buff
2006.6 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/

@nCharNo int,
@nKey int,
@nRet int OUTPUT

AS

SET NOCOUNT ON

DELETE FROM tCharacterChargedBuffer WHERE nCharNo = @nCharNo AND nKey = @nKey
SET @nRet = @@ERROR

RETURN

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_DelCharTitle]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_DelCharTitle]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_DelCharTitle    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


/*
'--------------------------------------------------------------------------------------
' 함수명 : p_Char_DelCharTitle
' 내  용 : OPTool 에서 사용. 지정된 캐릭터의 지정된 타이틀 삭제.
' 작성자 : 이병기
' 작성일 : 2005년 11월 25일
' 버  젼 : 1.0
' 인  자 :
'			input Parameter
'				@nCharNo		캐릭넘버
'				@nType			타이틀 타입, 
'				@nElementNo		타이틀 단계, 
'
'			Output Parameter
'				@nRet			tinyint OUTPUT
'				
'			RETURN_VALUE
'
'--------------------------------------------------------------------------------------
*/

CREATE PROCEDURE [dbo].[p_Char_DelCharTitle]

@nCharNo		int,
@nType			tinyint, 
@nElementNo		tinyint, 
@nRet			tinyint OUTPUT
AS
SET NOCOUNT ON
-- 해당 상태 삭제
DELETE FROM tCharacterTitle WHERE nCharNo = @nCharNo AND nType = @nType AND nElementNo = @nElementNo
SET @nRet = @@ERROR
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_Delete]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_Delete]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_Delete    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Char_Delete]
/*
Character Delete
2004.6 By CJC
  Input:
    nCharNo = Character number to be delete.
  Output:
    0 = Delete OK
    1 = 해당 캐릭이 이미 지워진 캐릭임
    2 = 해당 캐릭을 찾을수 없음
    3 = 해당 캐릭을 지울수 없음
  Desc:
    - 지워진 캐릭의 ID는 '아뒤~날짜#시도횟수' 형태로 바뀐다.
    - 버그 방지로 아뒤에는 '~'는 사용되면 안된다.
*/
@nCharNo int,
@nRet int OUTPUT
AS
SET NOCOUNT ON
-- 이미 지워진 캐릭인지 조사
IF EXISTS(SELECT nCharNo FROM tCharacter(NOLOCK) WHERE nCharNo = @nCharNo AND bDeleted > 0)
BEGIN
	SET @nRet = 1
	RETURN
END
-- 지워질 캐릭의 이름 얻기
DECLARE @sID nvarchar(40)
SET @sID = ''
SELECT @sID = sID FROM tCharacter(NOLOCK) WHERE nCharNo = @nCharNo
IF LEN(@sID) = 0
BEGIN
	SET @nRet = 2 -- 해당 캐릭이 없음
	RETURN
END
-- 아뒤내에 최초 삭제마크 이후의 문자는 모두 지운다.(지운거 또 지울수 있음으로 오류방지용)
DECLARE @DeleteMark nvarchar(2)
SET @DeleteMark = N'~'                       -- 삭제 마크 세팅
DECLARE @StartDeleteMark int
SET @StartDeleteMark = CHARINDEX( @DeleteMark, @sID )
IF @StartDeleteMark > 0
	SET @sID = LEFT( @sID, @StartDeleteMark-1 )
-- 지워질 캐릭의 ID를 변경
DECLARE @CurrentDate datetime
SET @CurrentDate = GETDATE()
DECLARE @nDeleteCount int
SET @nDeleteCount = 0
DECLARE @sChangedID nvarchar(40)
NAME_CHANGE: -- 이름 만들기 '아뒤' + 삭제마크 + '날짜' + '#시도횟수'
SET @sChangedID = 
	RTRIM(@sID) + 
	@DeleteMark + DATENAME(year, @CurrentDate) + DATENAME(month, @CurrentDate) + DATENAME(day, @CurrentDate) +
	N'#' + CAST( @nDeleteCount AS nvarchar(2) )
-- 캐릭 지우기
UPDATE tCharacter SET 
bDeleted = 1,
dDeletedDate = GETDATE(),
sID = @sChangedID
WHERE nCharNo = @nCharNo
-- 실패시 50번 이름을 바꾸면서 시도한다.
IF @@ERROR = 2601 -- 인덱스키 중복인 경우 
BEGIN
	SET @nDeleteCount = @nDeleteCount + 1
	IF @nDeleteCount < 50
		GOTO NAME_CHANGE
		
	-- 실패	
	SET @nRet = 3 
	RETURN
END	
-- 성공
SET @nRet = 0 
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_DelOptions]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_DelOptions]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_DelOptions    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/
/*
-----------------------------------
SadPig : 2006.7.6 (OPTool)
	Input Parameter
		@nCharNo : Character No		

	Output Parameter
		@nRet		
		0 : OK
		1-? : error code
-----------------------------------
*/

CREATE PROCEDURE [dbo].[p_Char_DelOptions]
	@nCharNo		int,
	@nRet			int OUTPUT
AS

BEGIN
	SET NOCOUNT ON
	SET LOCK_TIMEOUT 5000
	
	DELETE FROM tCharacterOptions WHERE nCharNo = @nCharNo 
	SET @nRet = @@ERROR
	
	SET LOCK_TIMEOUT -1
	SET NOCOUNT OFF	
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_DelState]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_DelState]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_DelState    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/
 

CREATE PROCEDURE [dbo].[p_Char_DelState]
/*
Char Delete state
2004.10 By CJC
 input:
	nCharNo, nStateNo = To be delete info.
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/
@nCharNo int,
@nStateNo smallint,
@nRet int OUTPUT
AS
SET NOCOUNT ON
-- 해당 상태 삭제
DELETE FROM tCharacterState WHERE nCharNo = @nCharNo AND nStateNo = @nStateNo
SET @nRet = @@ERROR
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_DelStateAll]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_DelStateAll]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_DelStateAll    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Char_DelStateAll]
/*
Char Delete state all
2004.10 By CJC
 input:
	nCharNo, nStateNo = To be delete info.
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/
@nCharNo int,
@nRet int OUTPUT
AS
SET NOCOUNT ON
-- 해당 상태 삭제
DELETE FROM tCharacterState WHERE nCharNo = @nCharNo
SET @nRet = @@ERROR
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_FameAdd]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_FameAdd]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_FameAdd    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/
CREATE PROCEDURE [dbo].[p_Char_FameAdd]
/*
Add fame
2004.9 By CJC
 input:
	see SQL
 output:
	@nRet	1 = OK
	        0 = Error
*/
@nCharNo int,
@nAddFame int,
@nRet tinyint OUTPUT
AS
SET NOCOUNT ON
DECLARE @nCharFame int
EXEC p_Char_FameGet @nCharNo, @nCharFame OUTPUT, @nRet OUTPUT
IF @nRet = 0
	RETURN
-- Add fame
SET @nCharFame = @nCharFame + @nAddFame
EXEC p_Char_FameSet @nCharNo, @nCharFame, @nRet OUTPUT
-- End

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_FameGet]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_FameGet]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_FameGet    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/
CREATE PROCEDURE [dbo].[p_Char_FameGet]
/*
Get fame
2004.9 By CJC
 input:
	see SQL
 output:
	@nRet	1 = OK, Fame return
	        0 = Error
*/
@nCharNo int,
@nCharFame int OUTPUT,
@nRet tinyint OUTPUT
AS
SET NOCOUNT ON
SET @nRet = 0
-- Get fame
SELECT @nCharFame = nFame FROM tCharacter WHERE nCharNo = @nCharNo
IF @@ROWCOUNT = 1
	SET @nRet = 1
	
-- End
RETURN

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_FameSet]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_FameSet]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_FameSet    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/
CREATE PROCEDURE [dbo].[p_Char_FameSet]
/*
Set fame
2004.9 By CJC
 input:
	see SQL
 output:
	@nRet	1 = OK
	        0 = Error
*/
@nCharNo int,
@nSetFame int,
@nRet tinyint OUTPUT
AS
SET NOCOUNT ON
SET @nRet = 0
UPDATE tCharacter SET nFame = @nSetFame WHERE nCharNo = @nCharNo
IF @@ERROR = 0 AND @@ROWCOUNT = 1
	SET @nRet = 1
-- end
RETURN

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_FameSub]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_FameSub]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_FameSub    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/
CREATE PROCEDURE [dbo].[p_Char_FameSub]
/*
Sub fame
2004.9 By CJC
 input:
	see SQL
 output:
	@nRet	1 = OK
	        0 = Error, or Minus value
*/
@nCharNo int,
@nSubFame int,
@nRet tinyint OUTPUT
AS
SET NOCOUNT ON
DECLARE @nCharFame int
EXEC p_Char_FameGet @nCharNo, @nCharFame OUTPUT, @nRet OUTPUT
IF @nRet = 0
	RETURN
-- Sub fame
SET @nCharFame = @nCharFame - @nSubFame
-- Check minus
IF @nCharFame < 0
BEGIN
	SET @nRet = 0
	RETURN	
END
EXEC p_Char_FameSet @nCharNo, @nCharFame, @nRet OUTPUT
-- End

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_Find]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_Find]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_Find    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Char_Find]
/*
Character Find
2004.6 By CJC
  input:
    sID = 찾을 ID
  output:
    0 = 없음
    1~? = 찾은 캐릭번호
*/
@sID nvarchar(40),
@nCharNo int OUTPUT
AS
SET NOCOUNT ON
SET @nCharNo = 0
SELECT @nCharNo = nCharNo FROM tCharacter(NOLOCK) WHERE sID = @sID
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetAllData]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetAllData]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetAllData    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Char_GetAllData]
/*
Character Get all data
2004.6 By CJC
 input:
   nCharNo = To be get login data
 output:
	none
 desc:
	fetch success, get data
	fetch fail, not data
*/
@nCharNo int
AS
SET NOCOUNT ON
SELECT
nUserNo,
nSlotNo,
sID,
nLevel,
nExp,
nHP,
nSP,
nAP,
nHPS,
nSPS,
nPS,
nGS,
nMoney,
nFame,
nFlags,
nAdminLevel,
sLoginZone,
nLoginZoneX,
nLoginZoneY,
nLoginZoneD,
nPrisonMin,
nPKCount,
nPKYellowTime,
nStrength,
nConstitute,
nDexterity,
nIntelligence,
nMentalPower,
nRedistributePoint,
nPlayMin,
nLoginCount,
dLastLoginDate,
dCreateDate,
nCreateWorld,
bDeleted,
dDeletedDate
FROM tCharacter
WHERE nCharNo = @nCharNo
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetChargedBufferAll]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetChargedBufferAll]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetChargedBufferAll    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/

CREATE PROCEDURE [dbo].[p_Char_GetChargedBufferAll]
/*
Char Get charaged buffer all
2006.6 By CJC
 input:
	see SQL
 output:
	fetch to take data
*/

@nCharNo int

AS

SET NOCOUNT ON

SELECT nKey, nID, dUseDate, dEndDate
FROM tCharacterChargedBuffer WHERE nCharNo = @nCharNo

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetChargedBufferCount]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetChargedBufferCount]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetChargedBufferCount    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/

CREATE PROCEDURE [dbo].[p_Char_GetChargedBufferCount]
/*
Char Get charaged buffer all count
2006.6 By CJC
 input:
	see SQL
 output:
	fetch to take data
*/

@nCharNo int,
@nCount int OUTPUT

AS

SET NOCOUNT ON

SELECT @nCount = COUNT(*) FROM tCharacterChargedBuffer WHERE nCharNo = @nCharNo

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetCharID]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetCharID]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetCharID    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Char_GetCharID]
/*
Get Char ID by Char No
input: CharNo
Output:
    @nRet, 0 = Not found char
           1 = @sID, Found char ID
*/
@nCharNo int,
@sID nvarchar(40) OUTPUT,
@nRet int OUTPUT
AS
SET NOCOUNT ON
SELECT @sID = sID FROM tCharacter WHERE nCharNo = @nCharNo
SET @nRet = @@ROWCOUNT
-- END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetCharNo]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetCharNo]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetCharNo    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Char_GetCharNo]
/*
Get Char No by Char ID
Input: sID
Output:
    @nCharNo, 0 = Not found user
              ? = Found user No
*/
@sID nvarchar(40),
@nCharNo int OUTPUT
AS
SET NOCOUNT ON
SET @nCharNo = 0
SELECT @nCharNo = nCharNo FROM tCharacter WHERE sID = @sID
-- END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetIsDeleted]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetIsDeleted]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetIsDeleted    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


/*
'--------------------------------------------------------------------------------------
' 함수명 : p_Char_GetIsDeleted
' 내  용 : 삭제된 캐릭인지 확인.
' 작성자 : 이병기
' 작성일 : 2005년 10월 25일
' 버  젼 : 1.0
' 인  자 :
'			input Parameter
'				@nCharNo	: 캐릭번호
'           output 
'				@nRet		: 0 = 삭제되지 않음
'                             1 = 삭제됨
'--------------------------------------------------------------------------------------
*/
CREATE PROCEDURE [dbo].[p_Char_GetIsDeleted]
@nCharNo int,
@nRet int OUTPUT

AS
SET NOCOUNT ON

IF EXISTS(SELECT nCharNo FROM tCharacter(NOLOCK) WHERE nCharNo = @nCharNo AND bDeleted > 0)

BEGIN
	SET @nRet = 1
		RETURN
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetKQMap]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetKQMap]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetKQMap    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/
CREATE PROCEDURE [dbo].[p_Char_GetKQMap]
/*
Character Get Kingdom quest map
2006.4 By CJC
 input:
   nCharNo = To be get KQ Map data
 output:
	none
 desc:
	fetch success, get data
	fetch fail, not data
*/

@nCharNo int

AS
SET NOCOUNT ON

SELECT

nKQHandle,
sKQMap,
nKQX,
nKQY,
nKQD,
dKQDate

FROM tCharacter

WHERE nCharNo = @nCharNo

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetListOfUserChar]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetListOfUserChar]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetListOfUserChar    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Char_GetListOfUserChar]
/*
Character Get list of user character
2004.6 By CJC
  Input:
    nUserNo = Search user's character
  output: 
	none
 desc:
	fetch success, get data
	fetch fail, not data
*/
@nUserNo int
AS
SET NOCOUNT ON
SELECT nCharNo FROM tCharacter(NOLOCK) WHERE nUserNo = @nUserNo AND bDeleted = 0
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetListOfUserCharAll]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetListOfUserCharAll]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetListOfUserCharAll    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Char_GetListOfUserCharAll]
/*
Character Get list of user character(include deleted character)
2004.6 By CJC
  Input:
    nUserNo = Search user's character
  output: 
	none
 desc:
	fetch success, get data
	fetch fail, not data
*/
@nUserNo int
AS
SET NOCOUNT ON
SELECT nCharNo FROM tCharacter(NOLOCK) WHERE nUserNo = @nUserNo
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetLoginData]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetLoginData]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetLoginData    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Char_GetLoginData]
/*
Character Get login data
2004.6 By CJC
 input:
	nCharNo = To be get login data
 output:
	none
 desc:
	fetch success, get data
	fetch fail, not data
*/
@nCharNo int
AS
SET NOCOUNT ON
SELECT 
	C.sID, 
	C.nLevel, 
	C.nSlotNo, 
	C.sLoginZone, 
	C.bDeleted, 
	C.dDeletedDate,
	
	S.nRace, 
	S.nClass, 
	S.nGender, 
	S.nHairType, 
	S.nHairColor, 
	S.nFaceShape,
	
	C.nKQHandle,
	C.sKQMap,
	C.nKQX,
	C.nKQY,
	C.nKQD,
	C.dKQDate
FROM tCharacter AS C
INNER JOIN tCharacterShape AS S ON S.nCharNo = @nCharNo
WHERE C.nCharNo = @nCharNo
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetNumOfUserChar]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetNumOfUserChar]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetNumOfUserChar    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Char_GetNumOfUserChar]
/*
Character number of user character
2004.6 By CJC
  Input:
    nUserNo = Search user's character
  output: 
    0 = none
    ? = number of user's character, execpt deleted.
*/
@nUserNo int,
@nNumOfUserChar int OUTPUT
AS
SET NOCOUNT ON
SET @nNumOfUserChar = 0
SELECT @nNumOfUserChar = COUNT(nCharNo) FROM tCharacter(NOLOCK) WHERE nUserNo = @nUserNo AND bDeleted = 0
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetNumOfUserCharAll]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetNumOfUserCharAll]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetNumOfUserCharAll    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Char_GetNumOfUserCharAll]
/*
Character number of user character(include deleted character)
2004.6 By CJC
  Input:
    nUserNo = Search user's character
  output: 
    0 = none
    ? = number of user's character
*/
@nUserNo int,
@nNumOfUserChar int OUTPUT
AS
SET NOCOUNT ON
SET @nNumOfUserChar = 0
SELECT @nNumOfUserChar = COUNT(nCharNo) FROM tCharacter(NOLOCK) WHERE nUserNo = @nUserNo
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetOptGame]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetOptGame]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetOptGame    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Char_GetOptGame]

/*
Character Get options
2005.8 By CJC

 input:
   nCharNo = To be get option data
 output:
	@sData = Option binary data
*/

@nCharNo int,
@nRet tinyint output,
@sData varbinary(64) output

AS

SET NOCOUNT ON

SET @nRet = 0
SELECT @sData = sGame, @nRet = 1 FROM tCharacterOptions WHERE nCharNo = @nCharNo AND sGame IS NOT NULL

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetOptKeyMapping]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetOptKeyMapping]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetOptKeyMapping    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Char_GetOptKeyMapping]

/*
Character Get options
2005.8 By CJC

 input:
   nCharNo = To be get option data
 output:
	@sData = Option binary data
*/

@nCharNo int,
@nRet tinyint output,
@sData varbinary(308) output

AS

SET NOCOUNT ON

SET @nRet = 0
SELECT @sData = sKeyMapping, @nRet = 1 FROM tCharacterOptions WHERE nCharNo = @nCharNo AND sKeyMapping IS NOT NULL

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetOptShortCutData]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetOptShortCutData]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetOptShortCutData    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Char_GetOptShortCutData]

/*
Character Get options
2005.8 By CJC

 input:
   nCharNo = To be get option data
 output:
	@sData = Option binary data
*/

@nCharNo int,
@nRet tinyint output,
@sData varbinary(1024) output

AS

SET NOCOUNT ON

SET @nRet = 0
SELECT @sData = sShortCutData, @nRet = 1 FROM tCharacterOptions WHERE nCharNo = @nCharNo AND sShortCutData IS NOT NULL

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetOptShortCutSize]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetOptShortCutSize]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetOptShortCutSize    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Char_GetOptShortCutSize]

/*
Character Get options
2005.8 By CJC

 input:
   nCharNo = To be get option data
 output:
	@sData = Option binary data
*/

@nCharNo int,
@nRet tinyint output,
@sData varbinary(24) output

AS

SET NOCOUNT ON

SET @nRet = 0
SELECT @sData = sShortCutSize, @nRet = 1 FROM tCharacterOptions WHERE nCharNo = @nCharNo AND sShortCutSize IS NOT NULL

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetOptSound]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetOptSound]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetOptSound    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Char_GetOptSound]

/*
Character Get options
2005.8 By CJC

 input:
   nCharNo = To be get option data
 output:
	@sData = Option binary data
*/

@nCharNo int,
@nRet tinyint output,
@sData varbinary(1) output

AS

SET NOCOUNT ON

SET @nRet = 0
SELECT @sData = sSound, @nRet = 1 FROM tCharacterOptions WHERE nCharNo = @nCharNo AND sSound IS NOT NULL

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetOptVideo]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetOptVideo]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetOptVideo    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Char_GetOptVideo]

/*
Character Get options
2005.8 By CJC

 input:
   nCharNo = To be get option data
 output:
	@sData = Option binary data
*/

@nCharNo int,
@nRet tinyint output,
@sData varbinary(60) output

AS

SET NOCOUNT ON

SET @nRet = 0
SELECT @sData = sVideo, @nRet = 1 FROM tCharacterOptions WHERE nCharNo = @nCharNo AND sVideo IS NOT NULL

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetOptWindowsPos]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetOptWindowsPos]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetOptWindowsPos    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Char_GetOptWindowsPos]

/*
Character Get options
2005.8 By CJC

 input:
   nCharNo = To be get option data
 output:
	@sData = Option binary data
*/

@nCharNo int,
@nRet tinyint output,
@sData varbinary(392) output

AS

SET NOCOUNT ON

SET @nRet = 0
SELECT @sData = sWindowsPos, @nRet = 1 FROM tCharacterOptions WHERE nCharNo = @nCharNo AND sWindowsPos IS NOT NULL

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetShape]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetShape]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetShape    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Char_GetShape]
/*
Character Get shape
2004.6 By CJC
 input:
   nCharNo = To be get shape
 output:
	none
 desc:
	fetch success, get data
	fetch fail, not data
*/
@nCharNo int
AS
SET NOCOUNT ON
SELECT 
	nRace, 
	nClass, 
	nGender, 
	nHairType, 
	nHairColor, 
	nFaceShape 
FROM tCharacterShape WHERE nCharNo = @nCharNo
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetState]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetState]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetState    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Char_GetState]
/*
Char Get state 
2004.10 By CJC
 input:
	see SQL
 output:
	@nRet	0 = No data found
	        ? = Number data here(must to be 1)
*/
@nCharNo int,
@nStateNo smallint,
@nStateLevel smallint OUTPUT,
@nStateTime int OUTPUT,
@nStateCount smallint OUTPUT,
@nStatePowerDemage tinyint OUTPUT,
@nStatePowerSP tinyint OUTPUT,
@nStatePowerKeepTime tinyint OUTPUT,
@nStatePowerCoolTime tinyint OUTPUT,

@nRet int OUTPUT
AS
SET NOCOUNT ON
SELECT 
	@nStateLevel			= nStateLevel, 
	@nStateTime				= nStateTime,
	@nStateCount			= nStateCount,	
	@nStatePowerDemage		= nStatePowerDemage,
	@nStatePowerSP			= nStatePowerSP,
	@nStatePowerKeepTime	= nStatePowerKeepTime,
	@nStatePowerCoolTime	= nStatePowerCoolTime
	
FROM tCharacterState WHERE nCharNo = @nCharNo AND nStateNo = @nStateNo

SET @nRet = @@ROWCOUNT
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetStateAll]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetStateAll]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetStateAll    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Char_GetStateAll]
/*
Char Get state all
2004.10 By CJC
 input:
	see SQL
 output:
	fetch to take data
*/

@nCharNo int

AS

SET NOCOUNT ON

SELECT 
	nStateNo, 
	nStateLevel, 
	nStateTime,
	nStateCount,
	nStatePowerDemage,
	nStatePowerSP,
	nStatePowerKeepTime,
	nStatePowerCoolTime
FROM tCharacterState WHERE nCharNo = @nCharNo

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetStateAllWithRestTime]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetStateAllWithRestTime]
GO

CREATE PROCEDURE [dbo].[p_Char_GetStateAllWithRestTime]
/*
Char Get state all
2009.05.15 By temlost
 input:
	see SQL
 output:
	fetch to take data
*/
@nCharNo int
AS
SET NOCOUNT ON
SELECT 
	nStateNo, 
	nStateLevel, 
	nStateTime,
	nRestTime,
	nStateCount,
	nStatePowerDemage,
	nStatePowerSP,
	nStatePowerKeepTime,
	nStatePowerCoolTime
FROM tCharacterState WHERE nCharNo = @nCharNo
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetStateAllWithSetItem]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetStateAllWithSetItem]
GO

CREATE PROCEDURE [dbo].[p_Char_GetStateAllWithSetItem]
/*
Char Get state all With SetItem
2008.06 By Lunar
 input:
	see SQL
 output:
	fetch to take data
*/
@nCharNo int
AS
SET NOCOUNT ON
SELECT 
	nStateNo, 
	nStateLevel, 
	nStateTime,
	nStateCount,
	nStatePowerDemage,
	nStatePowerSP,
	nStatePowerKeepTime,
	nStatePowerCoolTime,
	nSetItemIndexA,
	nSetItemValueA,
	nSetItemIndexB,
	nSetItemValueB,
	nSetItemIndexC,
	nSetItemValueC,
	nSetItemIndexD,
	nSetItemValueD
FROM tCharacterState WHERE nCharNo = @nCharNo
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetStateAllWithSetItemAndRestTime]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetStateAllWithSetItemAndRestTime]
GO

CREATE PROCEDURE [dbo].[p_Char_GetStateAllWithSetItemAndRestTime]
/*
Char Get state all With SetItem
2009.05.15 By temlost
 input:
	see SQL
 output:
	fetch to take data
*/
@nCharNo int
AS
SET NOCOUNT ON
SELECT 
	nStateNo, 
	nStateLevel, 
	nStateTime,
	nRestTime,
	nStateCount,
	nStatePowerDemage,
	nStatePowerSP,
	nStatePowerKeepTime,
	nStatePowerCoolTime,
	nSetItemIndexA,
	nSetItemValueA,
	nSetItemIndexB,
	nSetItemValueB,
	nSetItemIndexC,
	nSetItemValueC,
	nSetItemIndexD,
	nSetItemValueD
FROM tCharacterState WHERE nCharNo = @nCharNo
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetStateWithRestTime]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetStateWithRestTime]
GO

CREATE PROCEDURE [dbo].[p_Char_GetStateWithRestTime]
/*
Char Get state all With SetItem
2009.05.15 By temlost
 input:
	see SQL
 output:
	fetch to take data
*/
@nCharNo int,
@nStateNo smallint,
@nStateLevel smallint OUTPUT,
@nStateTime int OUTPUT,
@nRestTime int OUTPUT,
@nStateCount smallint OUTPUT,
@nStatePowerDemage tinyint OUTPUT,
@nStatePowerSP tinyint OUTPUT,
@nStatePowerKeepTime tinyint OUTPUT,
@nStatePowerCoolTime tinyint OUTPUT,
@nRet int OUTPUT
AS
SET NOCOUNT ON
SELECT 
	@nStateLevel			= nStateLevel, 
	@nStateTime			= nStateTime,
	@nRestTime			= nRestTime,
	@nStateCount			= nStateCount,	
	@nStatePowerDemage		= nStatePowerDemage,
	@nStatePowerSP			= nStatePowerSP,
	@nStatePowerKeepTime	= nStatePowerKeepTime,
	@nStatePowerCoolTime	= nStatePowerCoolTime
	
FROM tCharacterState WHERE nCharNo = @nCharNo AND nStateNo = @nStateNo
SET @nRet = @@ROWCOUNT
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetStateWithSetItem]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetStateWithSetItem]
GO

CREATE PROCEDURE [dbo].[p_Char_GetStateWithSetItem]
/*
Char Get state 
2004.10 By CJC
 input:
	see SQL
 output:
	@nRet	0 = No data found
	        ? = Number data here(must to be 1)
*/
@nCharNo int,
@nStateNo smallint,
@nStateLevel smallint OUTPUT,
@nStateTime int OUTPUT,
@nStateCount smallint OUTPUT,
@nStatePowerDemage tinyint OUTPUT,
@nStatePowerSP tinyint OUTPUT,
@nStatePowerKeepTime tinyint OUTPUT,
@nStatePowerCoolTime tinyint OUTPUT,
@nSetItemIndexA smallint OUTPUT,
@nSetItemValueA smallint OUTPUT,
@nSetItemIndexB smallint OUTPUT,
@nSetItemValueB smallint OUTPUT,
@nSetItemIndexC smallint OUTPUT,
@nSetItemValueC smallint OUTPUT,
@nSetItemIndexD smallint OUTPUT,
@nSetItemValueD smallint OUTPUT,
@nRet int OUTPUT
AS
SET NOCOUNT ON
SELECT 
	@nStateLevel			= nStateLevel, 
	@nStateTime			= nStateTime,
	@nStateCount			= nStateCount,	
	@nStatePowerDemage		= nStatePowerDemage,
	@nStatePowerSP		= nStatePowerSP,
	@nStatePowerKeepTime	= nStatePowerKeepTime,
	@nStatePowerCoolTime		= nStatePowerCoolTime,
	@nSetItemIndexA		= nSetItemIndexA,
	@nSetItemValueA		= nSetItemValueA,
	@nSetItemIndexB		= nSetItemIndexB,
	@nSetItemValueB		= nSetItemValueB,
	@nSetItemIndexC		= nSetItemIndexC,
	@nSetItemValueC		= nSetItemValueC,
	@nSetItemIndexD		= nSetItemIndexD,
	@nSetItemValueD		= nSetItemValueD
FROM tCharacterState WHERE nCharNo = @nCharNo AND nStateNo = @nStateNo
SET @nRet = @@ROWCOUNT
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetStateWithSetItemAndRestTime]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetStateWithSetItemAndRestTime]
GO

CREATE PROCEDURE [dbo].[p_Char_GetStateWithSetItemAndRestTime]
/*
Char Get state With Settime And RestTime
2009.05 By temlost
 input:
	see SQL
 output:
	@nRet	0 = No data found
	        ? = Number data here(must to be 1)
*/
@nCharNo int,
@nStateNo smallint,
@nStateLevel smallint OUTPUT,
@nStateTime int OUTPUT,
@nRestTime int OUTPUT,
@nStateCount smallint OUTPUT,
@nStatePowerDemage tinyint OUTPUT,
@nStatePowerSP tinyint OUTPUT,
@nStatePowerKeepTime tinyint OUTPUT,
@nStatePowerCoolTime tinyint OUTPUT,
@nSetItemIndexA smallint OUTPUT,
@nSetItemValueA smallint OUTPUT,
@nSetItemIndexB smallint OUTPUT,
@nSetItemValueB smallint OUTPUT,
@nSetItemIndexC smallint OUTPUT,
@nSetItemValueC smallint OUTPUT,
@nSetItemIndexD smallint OUTPUT,
@nSetItemValueD smallint OUTPUT,
@nRet int OUTPUT
AS
SET NOCOUNT ON
SELECT 
	@nStateLevel			= nStateLevel, 
	@nStateTime			= nStateTime,
	@nRestTime			= nRestTime,
	@nStateCount			= nStateCount,	
	@nStatePowerDemage		= nStatePowerDemage,
	@nStatePowerSP		= nStatePowerSP,
	@nStatePowerKeepTime	= nStatePowerKeepTime,
	@nStatePowerCoolTime		= nStatePowerCoolTime,
	@nSetItemIndexA		= nSetItemIndexA,
	@nSetItemValueA		= nSetItemValueA,
	@nSetItemIndexB		= nSetItemIndexB,
	@nSetItemValueB		= nSetItemValueB,
	@nSetItemIndexC		= nSetItemIndexC,
	@nSetItemValueC		= nSetItemValueC,
	@nSetItemIndexD		= nSetItemIndexD,
	@nSetItemValueD		= nSetItemValueD
FROM tCharacterState WHERE nCharNo = @nCharNo AND nStateNo = @nStateNo
SET @nRet = @@ROWCOUNT
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetTitleAll]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetTitleAll]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetTitleAll    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/




CREATE PROCEDURE [dbo].[p_Char_GetTitleAll]

/*
Character title set
2005.10 By CJC
  Input:
    nCharNo = character number
  output: 
    featch to get data
*/

@nCharNo int

AS

SET NOCOUNT ON

SELECT nType, nElementNo, nElementValue 
  FROM tCharacterTitle WITH(READUNCOMMITTED)
 WHERE nCharNo = @nCharNo ORDER BY nNo  

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetTitleCount]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetTitleCount]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetTitleCount    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Char_GetTitleCount]

/*
Character number of title
2005.10 By CJC
  Input:
    nCharNo = character number
  output: 
    0 = none
    ? = number of title on this character
*/

@nCharNo int,
@nCount int OUTPUT

AS

SET NOCOUNT ON

SET @nCount = 0

SELECT @nCount = COUNT(*) FROM tCharacterTitle(NOLOCK) WHERE nCharNo = @nCharNo

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_GetUserNo]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_GetUserNo]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_GetUserNo    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Char_GetUserNo]
/*
Get User No by Char ID
Input: nCharNo
Output:
    @nUserNo, 0 = Not found user
              ? = Found user No
*/
@nCharNo int,
@nUserNo int OUTPUT
AS
SET NOCOUNT ON
SET @nUserNo = 0
SELECT @nUserNo = nUserNo FROM tCharacter WHERE nCharNo = @nCharNo
-- END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_Login]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_Login]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_Login    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Char_Login]
/*
Character login
2004.6 By CJC
  Input:
    nCharNo = To be login
  output: 
    0 = error
    1 = work ok
*/
@nCharNo int,
@nRet int OUTPUT
AS
SET NOCOUNT ON
UPDATE tCharacter
    SET nLoginCount = nLoginCount + 1, 
        dLastLoginDate = GETDATE()
    WHERE nCharNo = @nCharNo
SET @nRet = @@ROWCOUNT
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_Logout]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_Logout]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_Logout    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Char_Logout]
/*
Character logout
2004.6 By CJC
  Input:
    nCharNo = To be logout
    nPlayMin = Play minute at this time
  output: 
    0 = error
    1 = work ok
*/
@nCharNo int,
@nPlayMin int,
@nRet int OUTPUT
AS
SET NOCOUNT ON
UPDATE tCharacter
    SET nPlayMin = nPlayMin + @nPlayMin 
    WHERE nCharNo = @nCharNo
SET @nRet = @@ROWCOUNT
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_MoneyAdd]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_MoneyAdd]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_MoneyAdd    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Char_MoneyAdd]
/*
Add money
2004.8 By CJC
 input:
	see SQL
 output:
	@nRet	1 = OK
	        0 = Error
*/
@nCharNo int,
@nAddMoney bigint,
@nRet tinyint OUTPUT
AS
SET NOCOUNT ON
DECLARE @nCharMoney bigint
EXEC p_Char_MoneyGet @nCharNo, @nCharMoney OUTPUT, @nRet OUTPUT
IF @nRet = 0
	RETURN
-- Add money
SET @nCharMoney = @nCharMoney + @nAddMoney
EXEC p_Char_MoneySet @nCharNo, @nCharMoney, @nRet OUTPUT
-- End

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_MoneyGet]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_MoneyGet]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_MoneyGet    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/




CREATE PROCEDURE [dbo].[p_Char_MoneyGet]
/*
Get money
2004.8 By CJC
 input:
	see SQL
 output:
	@nRet	1 = OK, Money return
	        0 = Error
*/
@nCharNo int,
@nCharMoney bigint OUTPUT,
@nRet tinyint OUTPUT
AS
SET NOCOUNT ON
SET @nRet = 0
-- 돈 얻기
SELECT @nCharMoney = nMoney FROM tCharacter WHERE nCharNo = @nCharNo
IF @@ROWCOUNT = 1
	SET @nRet = 1
	
-- End
RETURN

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_MoneyGetCharsByUserNo]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_MoneyGetCharsByUserNo]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_MoneyGetCharsByUserNo    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/
  /*
-----------------------------------
SadPig : 2006.9.5 (OPTool)
	Input Parameter
		@nMoney : Money

	Output Parameter
		int nCharNo;
		char sCharID[40];
		__int64 nMoney;
		WORD nLevel;
		BYTE nSlotNo;
		BYTE bDeleted;
		BYTE nAdminLevel;
-----------------------------------
*/
CREATE PROCEDURE [dbo].[p_Char_MoneyGetCharsByUserNo]
	@nUserNo		int
AS

BEGIN
	SET NOCOUNT ON
	SET LOCK_TIMEOUT 5000

	SELECT nCharNo, sID, nMoney, nLevel, nSlotNo, bDeleted, nAdminLevel 
	FROM tCharacter WHERE nUserNo =  @nUserNo
	
	SET LOCK_TIMEOUT -1
	SET NOCOUNT OFF	
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_MoneyGetGreaterThen]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_MoneyGetGreaterThen]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_MoneyGetGreaterThen    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/
  /*
-----------------------------------
SadPig : 2006.9.5 (OPTool)
	Input Parameter
		@nMoney : Money

	Output Parameter
		int nUserNo;
		int nCharNo;
		char sCharID[40];
		__int64 nMoney;
		WORD nLevel;
		BYTE nSlotNo;
		BYTE bDeleted;
		BYTE nAdminLevel;
-----------------------------------
*/
CREATE PROCEDURE [dbo].[p_Char_MoneyGetGreaterThen]
	@nMoney		bigint
AS

BEGIN
	SET NOCOUNT ON
	SET LOCK_TIMEOUT 5000

	SELECT nUserNo, nCharNo, sID, nMoney, nLevel, nSlotNo, bDeleted, nAdminLevel 
	FROM tCharacter WHERE nMoney >=  @nMoney
	
	SET LOCK_TIMEOUT -1
	SET NOCOUNT OFF	
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_MoneyMove]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_MoneyMove]
GO
CREATE PROCEDURE [dbo].[p_Char_MoneyMove]
/*
Move money
2008.2 By CJC
 input:
	see SQL
 output:
	@nRet	1 = OK
	        0 = Error
*/
	@nCharNoFrom int,
	@nCharNoTo   int,
	@nMoveMoney  bigint,
	@nRet        tinyint OUTPUT
AS
BEGIN
	SET NOCOUNT ON

	IF @nMoveMoney < 0
		BEGIN
			SET @nRet = 0
			RETURN
		END

	IF @nMoveMoney = 0
		BEGIN
			SET @nRet = 1
			RETURN
		END
		
	DECLARE @money as bigint

	BEGIN TRAN

	IF NOT EXISTS(SELECT nCharNo FROM tCharacter WHERE nCharNo = @nCharNoFrom AND bDeleted = 0)
	BEGIN
		SET @nRet = 0
		ROLLBACK TRAN
		RETURN
	END

	IF NOT EXISTS(SELECT nCharNo FROM tCharacter WHERE nCharNo = @nCharNoTo AND bDeleted = 0)
	BEGIN
		SET @nRet = 0
		ROLLBACK TRAN
		RETURN
	END

	SELECT @money = nMoney FROM tCharacter WHERE nCharNo = @nCharNoFrom AND bDeleted = 0
	IF @money >= @nMoveMoney
		BEGIN
			-- SUB MONEY
			UPDATE tCharacter SET nMoney = @money - @nMoveMoney WHERE nCharNo = @nCharNoFrom AND bDeleted = 0
			IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
			BEGIN
				SET @nRet =0
				ROLLBACK TRAN
				RETURN
			END
			
			-- ADD MONEY
			UPDATE tCharacter SET nMoney = nMoney + @nMoveMoney WHERE nCharNo = @nCharNoTo AND bDeleted = 0
			IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
			BEGIN
				SET @nRet = 0
				ROLLBACK TRAN
				RETURN
			END
	
			SET @nRet = 1
			COMMIT TRAN
		END
	ELSE
		BEGIN
			SET @nRet = 0
			ROLLBACK TRAN
			RETURN
		END

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_MoneySet]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_MoneySet]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_MoneySet    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/



CREATE PROCEDURE [dbo].[p_Char_MoneySet]
/*
Set money
2004.8 By CJC
 input:
	see SQL
 output:
	@nRet	1 = OK
	        0 = Error
*/
@nCharNo int,
@nSetMoney bigint,
@nRet tinyint OUTPUT
AS
SET NOCOUNT ON
SET @nRet = 0
UPDATE tCharacter SET nMoney = @nSetMoney WHERE nCharNo = @nCharNo
IF @@ERROR = 0 AND @@ROWCOUNT = 1
	SET @nRet = 1
-- end
RETURN

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_MoneySub]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_MoneySub]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_MoneySub    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/


CREATE PROCEDURE [dbo].[p_Char_MoneySub]
/*
Sub money
2004.8 By CJC
 input:
	see SQL
 output:
	@nRet	1 = OK
	        0 = Error, or Minus value
*/
@nCharNo int,
@nSubMoney bigint,
@nRet tinyint OUTPUT
AS
SET NOCOUNT ON
DECLARE @nCharMoney bigint
EXEC p_Char_MoneyGet @nCharNo, @nCharMoney OUTPUT, @nRet OUTPUT
IF @nRet = 0
	RETURN
-- Sub money
SET @nCharMoney = @nCharMoney - @nSubMoney
-- Check minus
IF @nCharMoney < 0
BEGIN
	SET @nRet = 0
	RETURN	
END
EXEC p_Char_MoneySet @nCharNo, @nCharMoney, @nRet OUTPUT
-- End

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_Rename]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_Rename]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_Rename    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/
CREATE PROCEDURE [dbo].[p_Char_Rename]
/*
Char Rename
2006.9 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/
@nCharNo int,
@sID nvarchar(40),
-- Output var
@nRet int OUTPUT

AS

SET NOCOUNT ON

UPDATE tCharacter SET sID = @sID WHERE nCharNo = @nCharNo
SET @nRet = @@ERROR

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_SaveLevelExpFrame]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_SaveLevelExpFrame]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_SaveLevelExpFrame    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/

/*==================================================
@author	lenasoft
@date	2006-04-07
@return	0		<성공>
	others		<실패>
@brief	케릭서 저장 프로시져화.
==================================================*/


CREATE PROCEDURE [dbo].[p_Char_SaveLevelExpFrame] 
@nCharNo int,
@nLevel smallint,
@nExp bigint,
@nFame int

AS
SET NOCOUNT ON

UPDATE tCharacter 
	SET 
		nLevel=@nLevel,
		nExp=@nExp,
		nFame=@nFame
	WHERE nCharNo=@nCharNo

return @@error

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_SaveLocation]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_SaveLocation]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_SaveLocation    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/

/*==================================================
@author	lenasoft
@date	2006-04-07
@return	0		<성공>
	others		<실패>
@brief	케릭서 저장 프로시져화.
==================================================*/

CREATE PROCEDURE [dbo].[p_Char_SaveLocation] 
@nCharNo		int,
@sLoginZone		nvarchar(16),
@nLoginZoneX	int,
@nLoginZoneY	int,
@nKQHandle		int,
@sKQMap			nvarchar(16),
@nKQX			int,
@nKQY			int

AS
SET NOCOUNT ON

UPDATE tCharacter SET 
	sLoginZone=@sLoginZone,
	nLoginZoneX=@nLoginZoneX,
	nLoginZoneY=@nLoginZoneY,
	
	nKQHandle=@nKQHandle,
	sKQMap=@sKQMap,
	nKQX=@nKQX,
	nKQY=@nKQY,
	dKQDate=GetDate()
	WHERE nCharNo=@nCharNo

return @@error

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_SavePKCount]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_SavePKCount]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_SavePKCount    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/
CREATE PROCEDURE [dbo].[p_Char_SavePKCount] 
/*
Character Set nPKCount
2007.2 By CJC
 input:
   All args
 output: 
   @@error
*/
@nCharNo int,
@nPKCount int

AS
SET NOCOUNT ON

UPDATE tCharacter SET nPKCount=@nPKCount WHERE nCharNo=@nCharNo

return @@error

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_SaveStat]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_SaveStat]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_SaveStat    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/

/*==================================================
@author	lenasoft
@date	2006-04-07
@return	0		<성공>
	others		<실패>
@brief	케릭서 저장 프로시져화.
==================================================*/


CREATE PROCEDURE [dbo].[p_Char_SaveStat] 
@nCharNo int,
@nPS int,
@nGS int,
@nHPS smallint,
@nSPS smallint,
@nHP smallint,
@nSP smallint

AS
SET NOCOUNT ON

UPDATE tCharacter 
	SET 
		nPS=@nPS,
		nGS=@nGS,
		nHPS=@nHPS,
		nSPS=@nSPS,
		nHP=@nHP,
		nSP=@nSP 
	WHERE nCharNo=@nCharNo


return @@error

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_SetAdminLevel]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_SetAdminLevel]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_SetAdminLevel    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/


/*
'--------------------------------------------------------------------------------------
' 함수명 : p_Char_SetAdminLevel
' 내  용 : 레벨과 경험치를 수정하는 프로시쥬어
' 작성자 : 이병기
' 작성일 : 2006년 02월 28일
' 버  젼 : 1.0
' 인  자 :
'			input Parameter
'				@nCharNo	: 캐릭터 넘버
'				@nAdmin		: 운영자 캐릭 세팅 여부
'			Output Parameter
'				@RET 	: 결과
					= 1		: 성공
'					= 0 	: 실패
'--------------------------------------------------------------------------------------
*/
CREATE PROCEDURE [dbo].[p_Char_SetAdminLevel]
@nCharNo	int,
@nAdmin		Tinyint,

@nRet		int OUTPUT

AS

SET NOCOUNT ON

UPDATE tCharacter SET 
	nAdminLevel			= @nAdmin
WHERE nCharNo = @nCharNo

IF @@ERROR <> 0 OR @@ROWCOUNT = 0
BEGIN
	SET @nRet = 0
	RETURN
END
SET @nRet = 1

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_SetAllData]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_SetAllData]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_SetAllData    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/


CREATE PROCEDURE [dbo].[p_Char_SetAllData]
/*
Character Set all data
2004.6 By CJC
 input:
   All args
 output: 
   1 = update ok
   0 = error at update chatacter data
*/
-- Character columns
@nCharNo int,
@nUserNo int, 
@nSlotNo tinyint,
@sID nvarchar(40), 
@nLevel smallint, 
@nExp bigint, 
@nHP smallint, 
@nSP smallint, 
@nAP smallint, 
@nHPS smallint,
@nSPS smallint,
@nPS int,
@nGS int,
@nMoney bigint,
@nFame int, 
@nFlags int, 
@nAdminLevel tinyint, 
@sLoginZone varchar(16),
@nLoginZoneX int,
@nLoginZoneY int,
@nLoginZoneD tinyint,
@nPrisonMin smallint, 
@nPKCount int, 
@nPKYellowTime tinyint,
@nStrength tinyint,
@nConstitute tinyint,
@nDexterity tinyint,
@nIntelligence tinyint,
@nMentalPower tinyint,
@nRedistributePoint tinyint,
@nPlayMin int, 
@nLoginCount int, 
@dLastLoginDate datetime, 
@dCreateDate datetime, 
@nCreateWorld tinyint, 
@bDeleted tinyint, 
@dDeletedDate datetime,
-- Output var
@nRet int OUTPUT
AS
SET NOCOUNT ON
-- Update character
UPDATE tCharacter SET
	nUserNo		=	@nUserNo , 
	nSlotNo			=	@nSlotNo , 
	sID			=	@sID , 
	nLevel			=	@nLevel , 
	nExp			=	@nExp , 
	nHP			=	@nHP , 
	nSP			=	@nSP , 
	nAP			=	@nAP , 
	nHPS			=	@nHPS , 
	nSPS			=	@nSPS , 
	nPS 			=	@nPS,
	nGS			=	@nGS,
	
	nMoney			= 	@nMoney , 
	nFame			= 	@nFame , 
	nFlags			= 	@nFlags , 
	nAdminLevel		=	@nAdminLevel ,
	
	sLoginZone		=	@sLoginZone , 
	nLoginZoneX		=	@nLoginZoneX , 
	nLoginZoneY		=	@nLoginZoneY , 
	nLoginZoneD		=	@nLoginZoneD ,
	
	nPrisonMin		=	@nPrisonMin , 
	nPKCount		=	@nPKCount , 
	nPKYellowTime		=	@nPKYellowTime ,
	
	nStrength		= 	@nStrength,
	nConstitute		= 	@nConstitute,
	nDexterity		= 	@nDexterity,
	nIntelligence		= 	@nIntelligence,
	nMentalPower		= 	@nMentalPower,
	nRedistributePoint	= 	@nRedistributePoint,
	
	nPlayMin		=	@nPlayMin , 
	nLoginCount		=	@nLoginCount , 
	dLastLoginDate		=	@dLastLoginDate ,
	
	dCreateDate		=	@dCreateDate , 
	nCreateWorld		=	@nCreateWorld ,
	bDeleted		=	@bDeleted, 
	dDeletedDate		=	@dDeletedDate 
WHERE nCharNo = @nCharNo
IF @@ERROR <> 0 OR @@ROWCOUNT = 0
BEGIN
	SET @nRet = 0
	RETURN
END
-- Update success
SET @nRet = 1
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_SetChargedBuffer]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_SetChargedBuffer]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_SetChargedBuffer    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/

CREATE PROCEDURE [dbo].[p_Char_SetChargedBuffer]
/*
Char Set charged buffer
2006.6 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/

@nCharNo int,
@nKey int,
@nID smallint,
@dUseDate datetime,
@dEndDate datetime,

@nRet int OUTPUT

AS

SET NOCOUNT ON

IF EXISTS(SELECT nCharNo FROM tCharacterChargedBuffer WHERE nCharNo = @nCharNo AND nKey = @nKey )
BEGIN
	UPDATE tCharacterChargedBuffer SET 
		nID = @nID,
		dUseDate = @dUseDate,
		dEndDate = @dEndDate
	WHERE nCharNo = @nCharNo AND nKey = @nKey
END
ELSE
BEGIN
	INSERT tCharacterChargedBuffer (  nCharNo,  nKey,  nID,  dUseDate,  dEndDate )
	VALUES                         ( @nCharNo, @nKey, @nID, @dUseDate, @dEndDate )
END

SET @nRet = @@ERROR
RETURN

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_SetLevelExp]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_SetLevelExp]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_SetLevelExp    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/


/*
'--------------------------------------------------------------------------------------
' 함수명 : p_Char_SetLevelExp
' 내  용 : 레벨과 경험치를 수정하는 프로시쥬어
' 작성자 : 이병기
' 작성일 : 2005년 10월 08일
' 버  젼 : 1.0
' 인  자 :
'			input Parameter
'				@nCharNo	: 캐릭터 넘버
'				@nLevel		: 레벨
'				@nExp		: 경험치
'			Output Parameter
'				@RET 	: 결과
					= 1		: 성공
'					= 0 	: 실패
'--------------------------------------------------------------------------------------
*/
CREATE PROCEDURE [dbo].[p_Char_SetLevelExp]
@nCharNo	int,
@nLevel		smallint,
@nExp		bigint,

@nRet		int OUTPUT

AS

SET NOCOUNT ON

UPDATE tCharacter SET 
	nLevel			= @nLevel,
	nExp			= @nExp
WHERE nCharNo = @nCharNo

IF @@ERROR <> 0 OR @@ROWCOUNT = 0
BEGIN
	SET @nRet = 0
	RETURN
END
SET @nRet = 1

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_SetOptGame]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_SetOptGame]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_SetOptGame    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/


CREATE PROCEDURE [dbo].[p_Char_SetOptGame]
/*
Character Set options
2004.6 By CJC
 input:
   All args
 output: 
   0 = error
   1 = update ok
*/

@nCharNo int,
@sData varbinary(64),
@nRet int OUTPUT
AS

SET NOCOUNT ON

UPDATE tCharacterOptions SET sGame = @sData WHERE nCharNo = @nCharNo

IF @@ERROR <> 0 OR @@ROWCOUNT = 0
BEGIN
	INSERT tCharacterOptions ( nCharNo, sGame ) VALUES ( @nCharNo, @sData )
	SET @nRet = @@ROWCOUNT
	RETURN
END

SET @nRet = 1

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_SetOptKeyMapping]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_SetOptKeyMapping]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_SetOptKeyMapping    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Char_SetOptKeyMapping]
/*
Character Set options
2004.6 By CJC
 input:
   All args
 output: 
   0 = error
   1 = update ok
*/

@nCharNo int,
@sData varbinary(308),
@nRet int OUTPUT
AS

SET NOCOUNT ON

UPDATE tCharacterOptions SET sKeyMapping = @sData WHERE nCharNo = @nCharNo

IF @@ERROR <> 0 OR @@ROWCOUNT = 0
BEGIN
	INSERT tCharacterOptions (nCharNo, sKeyMapping) VALUES (@nCharNo, @sData)
	SET @nRet = @@ROWCOUNT
	RETURN
END

SET @nRet = 1

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_SetOptShortCutData]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_SetOptShortCutData]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_SetOptShortCutData    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Char_SetOptShortCutData]
/*
Character Set options
2004.6 By CJC
 input:
   All args
 output: 
   0 = error
   1 = update ok
*/

@nCharNo int,
@sData varbinary(1024),
@nRet int OUTPUT
AS

SET NOCOUNT ON

UPDATE tCharacterOptions SET sShortCutData = @sData WHERE nCharNo = @nCharNo

IF @@ERROR <> 0 OR @@ROWCOUNT = 0
BEGIN
	INSERT tCharacterOptions (nCharNo, sShortCutData) VALUES (@nCharNo, @sData)
	SET @nRet = @@ROWCOUNT
	RETURN
END

SET @nRet = 1

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_SetOptShortCutSize]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_SetOptShortCutSize]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_SetOptShortCutSize    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Char_SetOptShortCutSize]
/*
Character Set options
2004.6 By CJC
 input:
   All args
 output: 
   0 = error
   1 = update ok
*/

@nCharNo int,
@sData varbinary(24),
@nRet int OUTPUT
AS

SET NOCOUNT ON

UPDATE tCharacterOptions SET sShortCutSize = @sData WHERE nCharNo = @nCharNo

IF @@ERROR <> 0 OR @@ROWCOUNT = 0
BEGIN
	INSERT tCharacterOptions (nCharNo, sShortCutSize) VALUES (@nCharNo, @sData)
	SET @nRet = @@ROWCOUNT
	RETURN
END

SET @nRet = 1

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_SetOptSound]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_SetOptSound]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_SetOptSound    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Char_SetOptSound]
/*
Character Set options
2004.6 By CJC
 input:
   All args
 output: 
   0 = error
   1 = update ok
*/

@nCharNo int,
@sData varbinary(1),
@nRet int OUTPUT
AS

SET NOCOUNT ON

UPDATE tCharacterOptions SET sSound = @sData WHERE nCharNo = @nCharNo

IF @@ERROR <> 0 OR @@ROWCOUNT = 0
BEGIN
	INSERT tCharacterOptions (nCharNo, sSound) VALUES (@nCharNo, @sData)
	SET @nRet = @@ROWCOUNT
	RETURN
END

SET @nRet = 1

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_SetOptVideo]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_SetOptVideo]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_SetOptVideo    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Char_SetOptVideo]
/*
Character Set options
2004.6 By CJC
 input:
   All args
 output: 
   0 = error
   1 = update ok
*/

@nCharNo int,
@sData varbinary(60),
@nRet int OUTPUT
AS

SET NOCOUNT ON

UPDATE tCharacterOptions SET sVideo = @sData WHERE nCharNo = @nCharNo

IF @@ERROR <> 0 OR @@ROWCOUNT = 0
BEGIN
	INSERT tCharacterOptions (nCharNo, sVideo) VALUES (@nCharNo, @sData)
	SET @nRet = @@ROWCOUNT
	RETURN
END

SET @nRet = 1

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_SetOptWindowsPos]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_SetOptWindowsPos]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_SetOptWindowsPos    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Char_SetOptWindowsPos]
/*
Character Set options
2004.6 By CJC
 input:
   All args
 output: 
   0 = error
   1 = update ok
*/

@nCharNo int,
@sData varbinary(392),
@nRet int OUTPUT
AS

SET NOCOUNT ON

UPDATE tCharacterOptions SET sWindowsPos = @sData WHERE nCharNo = @nCharNo

IF @@ERROR <> 0 OR @@ROWCOUNT = 0
BEGIN
	INSERT tCharacterOptions (nCharNo, sWindowsPos) VALUES (@nCharNo, @sData)
	SET @nRet = @@ROWCOUNT
	RETURN
END

SET @nRet = 1

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_SetShape]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_SetShape]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_SetShape    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/


CREATE PROCEDURE [dbo].[p_Char_SetShape]
/*
Character Set shape
2004.6 By CJC
 input:
   All args
 output: 
   0 = error
   1 = update ok
*/
@nCharNo int,
@nRace tinyint, 
@nClass tinyint, 
@nGender tinyint, 
@nHairType tinyint, 
@nHairColor tinyint, 
@nFaceShape tinyint, 
-- Output var
@nRet tinyint OUTPUT
AS
SET NOCOUNT ON
UPDATE tCharacterShape SET
	nRace		= @nRace,
	nClass		= @nClass,
	nGender		= @nGender,
	nHairType	= @nHairType,
	nHairColor	= @nHairColor,
	nFaceShape	= @nFaceShape
WHERE nCharNo = @nCharNo
IF @@ERROR <> 0 OR @@ROWCOUNT = 0
BEGIN
	SET @nRet = 0
	RETURN
END
SET @nRet = 1
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_SetState]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_SetState]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_SetState    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/
CREATE PROCEDURE [dbo].[p_Char_SetState]
/*
Char Set state
2004.10 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/

@nCharNo int,
@nStateNo smallint,
@nStateLevel smallint,
@nStateTime int,
@nStateCount smallint,
@nStatePowerDemage tinyint,
@nStatePowerSP tinyint,
@nStatePowerKeepTime tinyint,
@nStatePowerCoolTime tinyint,

@nRet int OUTPUT

AS

SET NOCOUNT ON

UPDATE tCharacterState SET 
		nStateLevel			= @nStateLevel,
		nStateTime			= @nStateTime,
		nStateCount			= @nStateCount,	
		nStatePowerDemage	= @nStatePowerDemage,
		nStatePowerSP		= @nStatePowerSP,
		nStatePowerKeepTime	= @nStatePowerKeepTime,
		nStatePowerCoolTime	= @nStatePowerCoolTime
WHERE nCharNo = @nCharNo AND nStateNo = @nStateNo
IF @@ERROR <> 0 OR @@ROWCOUNT = 0
BEGIN
	INSERT tCharacterState (  nCharNo,  nStateNo,  nStateLevel,  nStateTime,  nStateCount,  nStatePowerDemage,  nStatePowerSP,  nStatePowerKeepTime,  nStatePowerCoolTime )
	VALUES                 ( @nCharNo, @nStateNo, @nStateLevel, @nStateTime, @nStateCount, @nStatePowerDemage, @nStatePowerSP, @nStatePowerKeepTime, @nStatePowerCoolTime )
END
SET @nRet = @@ERROR
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_SetStateWithRestTime]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_SetStateWithRestTime]
GO

CREATE PROCEDURE [dbo].[p_Char_SetStateWithRestTime]
/*

*/
@nCharNo int,
@nStateNo smallint,
@nStateLevel smallint,
@nStateTime int,
@nRestTime int,
@nStateCount smallint,
@nStatePowerDemage tinyint,
@nStatePowerSP tinyint,
@nStatePowerKeepTime tinyint,
@nStatePowerCoolTime tinyint,
@nRet int OUTPUT
AS
SET NOCOUNT ON
IF EXISTS(SELECT nCharNo FROM tCharacterState WHERE nCharNo = @nCharNo AND nStateNo = @nStateNo )
BEGIN
	UPDATE tCharacterState SET 
		nStateLevel			= @nStateLevel,
		nStateTime			= @nStateTime,
		nRestTime			= @nRestTime,
		nStateCount			= @nStateCount,	
		nStatePowerDemage	= @nStatePowerDemage,
		nStatePowerSP		= @nStatePowerSP,
		nStatePowerKeepTime	= @nStatePowerKeepTime,
		nStatePowerCoolTime	= @nStatePowerCoolTime
	WHERE nCharNo = @nCharNo AND nStateNo = @nStateNo
	
	SET @nRet = @@ERROR
	RETURN
END
INSERT tCharacterState (  nCharNo,  nStateNo,  nStateLevel,  nStateTime, nRestTime,  nStateCount,  nStatePowerDemage,  nStatePowerSP,  nStatePowerKeepTime,  nStatePowerCoolTime )
VALUES                 ( @nCharNo, @nStateNo, @nStateLevel, @nStateTime, @nRestTime, @nStateCount, @nStatePowerDemage, @nStatePowerSP, @nStatePowerKeepTime, @nStatePowerCoolTime )
SET @nRet = @@ERROR
RETURN
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_SetStateWithSetItem]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_SetStateWithSetItem]
GO

CREATE PROCEDURE [dbo].[p_Char_SetStateWithSetItem]
/*
Char Set state With SetItem
2008.06 By Lunar
 input:
	see SQL
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/
@nCharNo int,
@nStateNo smallint,
@nStateLevel smallint,
@nStateTime int,
@nStateCount smallint,
@nStatePowerDemage tinyint,
@nStatePowerSP tinyint,
@nStatePowerKeepTime tinyint,
@nStatePowerCoolTime tinyint,
@nSetItemIndexA smallint,
@nSetItemValueA smallint,
@nSetItemIndexB smallint,
@nSetItemValueB smallint,
@nSetItemIndexC smallint,
@nSetItemValueC smallint,
@nSetItemIndexd smallint,
@nSetItemValueD smallint,
@nRet int OUTPUT
AS
SET NOCOUNT ON
IF EXISTS(SELECT nCharNo FROM tCharacterState WHERE nCharNo = @nCharNo AND nStateNo = @nStateNo )
BEGIN
	UPDATE tCharacterState SET 
		nStateLevel			= @nStateLevel,
		nStateTime			= @nStateTime,
		nStateCount			= @nStateCount,	
		nStatePowerDemage	= @nStatePowerDemage,
		nStatePowerSP		= @nStatePowerSP,
		nStatePowerKeepTime	= @nStatePowerKeepTime,
		nStatePowerCoolTime	= @nStatePowerCoolTime,
		nSetItemIndexA		= @nSetItemIndexA,
		nSetItemValueA		= @nSetItemValueA,
		nSetItemIndexB		= @nSetItemIndexB,
		nSetItemValueB		= @nSetItemValueB,
		nSetItemIndexC		= @nSetItemIndexC,
		nSetItemValueC		= @nSetItemValueC,
		nSetItemIndexD		= @nSetItemIndexD,
		nSetItemValueD		= @nSetItemValueD
	WHERE nCharNo = @nCharNo AND nStateNo = @nStateNo
	
	SET @nRet = @@ERROR
	RETURN
END
INSERT tCharacterState (  nCharNo,  nStateNo,  nStateLevel,  nStateTime,  nStateCount,  nStatePowerDemage,  nStatePowerSP,  nStatePowerKeepTime,  nStatePowerCoolTime, nSetItemIndexA, nSetItemValueA, nSetItemIndexB, nSetItemValueB, nSetItemIndexC, nSetItemValueC, nSetItemIndexD, nSetItemValueD )
VALUES                 ( @nCharNo, @nStateNo, @nStateLevel, @nStateTime, @nStateCount, @nStatePowerDemage, @nStatePowerSP, @nStatePowerKeepTime, @nStatePowerCoolTime, @nSetItemIndexA, @nSetItemValueA, @nSetItemIndexB, @nSetItemValueB, @nSetItemIndexC, @nSetItemValueC, @nSetItemIndexD, @nSetItemValueD )
SET @nRet = @@ERROR
RETURN
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_SetStateWithSetItemAndRestTime]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_SetStateWithSetItemAndRestTime]
GO

CREATE PROCEDURE [dbo].[p_Char_SetStateWithSetItemAndRestTime]
/*
Char Set state With SetItem
2008.06 By Lunar
 input:
	see SQL
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/
@nCharNo int,
@nStateNo smallint,
@nStateLevel smallint,
@nStateTime int,
@nRestTime int,
@nStateCount smallint,
@nStatePowerDemage tinyint,
@nStatePowerSP tinyint,
@nStatePowerKeepTime tinyint,
@nStatePowerCoolTime tinyint,
@nSetItemIndexA smallint,
@nSetItemValueA smallint,
@nSetItemIndexB smallint,
@nSetItemValueB smallint,
@nSetItemIndexC smallint,
@nSetItemValueC smallint,
@nSetItemIndexd smallint,
@nSetItemValueD smallint,
@nRet int OUTPUT
AS
SET NOCOUNT ON
IF EXISTS(SELECT nCharNo FROM tCharacterState WHERE nCharNo = @nCharNo AND nStateNo = @nStateNo )
BEGIN
	UPDATE tCharacterState SET 
		nStateLevel			= @nStateLevel,
		nStateTime			= @nStateTime,
		nRestTime			= @nRestTime,
		nStateCount			= @nStateCount,	
		nStatePowerDemage	= @nStatePowerDemage,
		nStatePowerSP		= @nStatePowerSP,
		nStatePowerKeepTime	= @nStatePowerKeepTime,
		nStatePowerCoolTime	= @nStatePowerCoolTime,
		nSetItemIndexA		= @nSetItemIndexA,
		nSetItemValueA		= @nSetItemValueA,
		nSetItemIndexB		= @nSetItemIndexB,
		nSetItemValueB		= @nSetItemValueB,
		nSetItemIndexC		= @nSetItemIndexC,
		nSetItemValueC		= @nSetItemValueC,
		nSetItemIndexD		= @nSetItemIndexD,
		nSetItemValueD		= @nSetItemValueD
	WHERE nCharNo = @nCharNo AND nStateNo = @nStateNo
	
	SET @nRet = @@ERROR
	RETURN
END
INSERT tCharacterState (  nCharNo,  nStateNo,  nStateLevel,  nStateTime, nRestTime,  nStateCount,  nStatePowerDemage,  nStatePowerSP,  nStatePowerKeepTime,  nStatePowerCoolTime, nSetItemIndexA, nSetItemValueA, nSetItemIndexB, nSetItemValueB, nSetItemIndexC, nSetItemValueC, nSetItemIndexD, nSetItemValueD )
VALUES                 ( @nCharNo, @nStateNo, @nStateLevel, @nStateTime, @nRestTime, @nStateCount, @nStatePowerDemage, @nStatePowerSP, @nStatePowerKeepTime, @nStatePowerCoolTime, @nSetItemIndexA, @nSetItemValueA, @nSetItemIndexB, @nSetItemValueB, @nSetItemIndexC, @nSetItemValueC, @nSetItemIndexD, @nSetItemValueD )
SET @nRet = @@ERROR
RETURN
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_SetTitle]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_SetTitle]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_SetTitle    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/

CREATE PROCEDURE [dbo].[p_Char_SetTitle]
/*
Character Set shape
2004.6 By CJC
 input:
   All args
 output: 
   0 = error
   1 = update/insert ok
*/
@nCharNo		int,
@nType			tinyint, 
@nElementNo		tinyint, 
@nElementValue	bigint,
@nRet			tinyint OUTPUT

AS

SET NOCOUNT ON

-- SET ERROR FIRST
SET @nRet = 0

IF EXISTS( SELECT nCharNo FROM tCharacterTitle WHERE nCharNo = @nCharNo AND nType = @nType AND nElementNo = @nElementNo )
BEGIN
	UPDATE tCharacterTitle SET nElementValue = @nElementValue
	WHERE nCharNo = @nCharNo AND nType = @nType AND nElementNo = @nElementNo

	IF @@ERROR = 0 AND @@ROWCOUNT = 1
	BEGIN
		SET @nRet = 1
		RETURN
	END
END
ELSE
BEGIN
	INSERT tCharacterTitle (  nCharNo,  nType,  nElementNo,  nElementValue )
	VALUES                 ( @nCharNo, @nType, @nElementNo, @nElementValue )

	IF @@ERROR = 0
	BEGIN
		SET @nRet = 1
		RETURN
	END
END

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_StatPoint_Dec]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_StatPoint_Dec]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_StatPoint_Dec    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/



CREATE PROCEDURE [dbo].[p_Char_StatPoint_Dec]
/*
Character decrement statpoint
2005.11 By CJC

 input:
   See SQL
   
 output: 
   0 = error
   1 = update ok
   
*/

@nCharNo int,
@nStatPointType tinyint,

-- Output var
@nRet int OUTPUT

AS

SET NOCOUNT ON

-- CHECK nRedistributePoint

/* DO NOT USE nRedistributePoint

DECLARE @nRedistributePoint tinyint
SET @nRedistributePoint = 0
SELECT @nRedistributePoint = nRedistributePoint FROM tCharacter WHERE nCharNo = @nCharNo
IF @nRedistributePoint < 1
BEGIN
	SET @nRet = 0
	RETURN
END
*/
-- CHECK Type and Decrement stat-point
DECLARE @nStatPoint tinyint

IF @nStatPointType = 0
BEGIN
	SELECT @nStatPoint = nStrength FROM tCharacter WHERE nCharNo = @nCharNo
	IF @nStatPoint < 1
	BEGIN
		SET @nRet = 0
		RETURN
	END
	
	UPDATE tCharacter	SET nStrength	= nStrength - 1					WHERE nCharNo = @nCharNo AND nStrength > 0
--	UPDATE tCharacter	SET nRedistributePoint = nRedistributePoint - 1 WHERE nCharNo = @nCharNo AND nRedistributePoint > 0
END

IF @nStatPointType = 1
BEGIN
	SELECT @nStatPoint = nConstitute FROM tCharacter WHERE nCharNo = @nCharNo
	IF @nStatPoint < 1
	BEGIN
		SET @nRet = 0
		RETURN
	END
	
	UPDATE tCharacter	SET nConstitute = nConstitute - 1				WHERE nCharNo = @nCharNo AND nConstitute > 0
--	UPDATE tCharacter	SET nRedistributePoint = nRedistributePoint - 1	WHERE nCharNo = @nCharNo AND nRedistributePoint > 0
END
	
IF @nStatPointType = 2
BEGIN
	SELECT @nStatPoint = nDexterity FROM tCharacter WHERE nCharNo = @nCharNo
	IF @nStatPoint < 1
	BEGIN
		SET @nRet = 0
		RETURN
	END
	
	UPDATE tCharacter	SET nDexterity = nDexterity - 1					WHERE nCharNo = @nCharNo AND nDexterity > 0
--	UPDATE tCharacter	SET nRedistributePoint = nRedistributePoint - 1	WHERE nCharNo = @nCharNo AND nRedistributePoint > 0
END

IF @nStatPointType = 3
BEGIN
	SELECT @nStatPoint = nIntelligence FROM tCharacter WHERE nCharNo = @nCharNo
	IF @nStatPoint < 1
	BEGIN
		SET @nRet = 0
		RETURN
	END
	
	UPDATE tCharacter	SET nIntelligence = nIntelligence - 1			WHERE nCharNo = @nCharNo AND nIntelligence > 0
--	UPDATE tCharacter	SET nRedistributePoint = nRedistributePoint - 1 WHERE nCharNo = @nCharNo AND nRedistributePoint > 0
END

IF @nStatPointType = 4 
BEGIN
	SELECT @nStatPoint = nMentalPower FROM tCharacter WHERE nCharNo = @nCharNo
	IF @nStatPoint < 1
	BEGIN
		SET @nRet = 0
		RETURN
	END
	
	UPDATE tCharacter	SET nMentalPower = nMentalPower - 1				WHERE nCharNo = @nCharNo AND nMentalPower > 0
--	UPDATE tCharacter	SET nRedistributePoint = nRedistributePoint - 1 WHERE nCharNo = @nCharNo AND nRedistributePoint > 0
END

-- Check Error
IF @@ERROR <> 0 OR @nStatPointType > 4
BEGIN
	SET @nRet = 0
	RETURN
END
SET @nRet = 1

-- end of file

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_StatPoint_Inc]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_StatPoint_Inc]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_StatPoint_Inc    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/


CREATE PROCEDURE [dbo].[p_Char_StatPoint_Inc]
/*
Character increment statpoint
2005.11 By CJC

 input:
   See SQL
   
 output: 
   0 = error
   1 = update ok
   
*/

@nCharNo int,
@nStatPointType tinyint,

-- Output var
@nRet int OUTPUT

AS

SET NOCOUNT ON

IF @nStatPointType = 0 UPDATE tCharacter SET nStrength		= nStrength + 1		WHERE nCharNo = @nCharNo
IF @nStatPointType = 1 UPDATE tCharacter SET nConstitute	= nConstitute + 1	WHERE nCharNo = @nCharNo
IF @nStatPointType = 2 UPDATE tCharacter SET nDexterity		= nDexterity + 1	WHERE nCharNo = @nCharNo
IF @nStatPointType = 3 UPDATE tCharacter SET nIntelligence	= nIntelligence + 1 WHERE nCharNo = @nCharNo
IF @nStatPointType = 4 UPDATE tCharacter SET nMentalPower	= nMentalPower + 1	WHERE nCharNo = @nCharNo

-- check error
IF @@ERROR <> 0 OR @nStatPointType > 4
BEGIN
	SET @nRet = 0
	RETURN
END

SET @nRet = 1

-- end of file

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_SubExp]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_SubExp]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_SubExp    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/

/*==================================================
@author	lenasoft
@date	2006-04-07
@return	0		<성공>
	others		<실패>
@brief	케릭서 저장 프로시져화.
==================================================*/


CREATE PROCEDURE [dbo].[p_Char_SubExp]
@nCharNo int,
@nExp bigint

AS
SET NOCOUNT ON

UPDATE tCharacter 
	SET 
		nExp=nExp-@nExp
	WHERE nCharNo=@nCharNo

return @@error

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_Wedding_Cancel_Propose]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_Wedding_Cancel_Propose]
GO






CREATE PROCEDURE [dbo].[p_Char_Wedding_Cancel_Propose]
	@CharANo INT,
	@CharBNo INT,
	@nRet INT OUTPUT
AS

BEGIN

	SET NOCOUNT ON

	SELECT @nRet = 0

-- to Character A

	BEGIN TRAN

	IF EXISTS(SELECT nCharNo FROM tMarriage WHERE nCharNo = @CharANo AND nPartnerCharNo = @CharBNo)
	BEGIN
		UPDATE tMarriage
		SET
			nStatus = 0,
			nSubStatus = 0
		WHERE
			nCharNo = @CharANo

		 IF @@ERROR <> 0 GOTO ERROR_
	END
	ELSE GOTO ERROR_

-- to Character B

	IF EXISTS(SELECT nCharNo FROM tMarriage WHERE nCharNo = @CharBNo AND nPartnerCharNo = @CharANo)
	BEGIN
		UPDATE tMarriage
		SET
			nStatus = 0,
			nSubStatus = 0
		WHERE
			nCharNo = @CharBNo

		 IF @@ERROR <> 0 GOTO ERROR_
	END
	ELSE GOTO ERROR_

	COMMIT TRAN
	GOTO END_

ERROR_:
	ROLLBACK TRAN
	SELECT @nRet = 1

END_:
	SET NOCOUNT OFF

END




GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_Wedding_Divorce_by_Agree]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_Wedding_Divorce_by_Agree]
GO






CREATE PROCEDURE [dbo].[p_Char_Wedding_Divorce_by_Agree]
	@CharANo INT,
	@CharBNo INT,
	@nRet INT OUTPUT
AS

BEGIN

	SET NOCOUNT ON

	SELECT @nRet = 0

-- to Character A : applicant

	BEGIN TRAN

	IF EXISTS(SELECT nCharNo FROM tMarriage WHERE nCharNo = @CharANo AND nPartnerCharNo = @CharBNo)
	BEGIN
		UPDATE tMarriage
		SET
			nSubStatus = 1,
--			dSubWhen = DATEADD(minute, 10, GETDATE())
			dSubWhen = DATEADD(minute, 5, GETDATE())
		WHERE
			nCharNo = @CharANo

		 IF @@ERROR <> 0 GOTO ERROR_
	END
	ELSE GOTO ERROR_

-- to Character B

	IF EXISTS(SELECT nCharNo FROM tMarriage WHERE nCharNo = @CharBNo AND nPartnerCharNo = @CharANo)
	BEGIN
		UPDATE tMarriage
		SET
			nSubStatus = 2 + 4,
			dSubWhen = DATEADD(minute, 5, GETDATE())
		WHERE
			nCharNo = @CharBNo

		 IF @@ERROR <> 0 GOTO ERROR_
	END
	ELSE GOTO ERROR_

	COMMIT TRAN
	GOTO END_

ERROR_:
	ROLLBACK TRAN
	SELECT @nRet = 1

END_:
	SET NOCOUNT OFF

END



GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_Wedding_Divorce_by_Force]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_Wedding_Divorce_by_Force]
GO






CREATE PROCEDURE [dbo].[p_Char_Wedding_Divorce_by_Force]
	@CharANo INT,
	@CharBNo INT,
	@nRet INT OUTPUT
AS

BEGIN

	SET NOCOUNT ON

	SELECT @nRet = 0

-- to Character A : applicant

	BEGIN TRAN

	IF EXISTS(SELECT nCharNo FROM tMarriage WHERE nCharNo = @CharANo AND nPartnerCharNo = @CharBNo)
	BEGIN
		UPDATE tMarriage
		SET
			nSubStatus = 3,
--			dSubWhen = DATEADD(Day, 3, GETDATE())
		dSubWhen = DATEADD(minute, 5, GETDATE())
		WHERE
			nCharNo = @CharANo

		 IF @@ERROR <> 0 GOTO ERROR_
	END
	ELSE GOTO ERROR_

-- to Character B

	IF EXISTS(SELECT nCharNo FROM tMarriage WHERE nCharNo = @CharBNo AND nPartnerCharNo = @CharANo)
	BEGIN
		UPDATE tMarriage
		SET
			nSubStatus = 4,
--			dSubWhen = DATEADD(Day, 3, GETDATE())
			dSubWhen = DATEADD(minute, 5, GETDATE())
		WHERE
			nCharNo = @CharBNo

		 IF @@ERROR <> 0 GOTO ERROR_
	END
	ELSE GOTO ERROR_

	COMMIT TRAN
	GOTO END_

ERROR_:
	ROLLBACK TRAN
	SELECT @nRet = 1

END_:
	SET NOCOUNT OFF

END




GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_Wedding_Divorce_Cancel]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_Wedding_Divorce_Cancel]
GO

CREATE PROCEDURE [dbo].[p_Char_Wedding_Divorce_Cancel]
	@CharANo INT,
	@CharBNo INT,
	@IncreseCount TINYINT,
	@SubStatusA TINYINT OUTPUT,
	@SubStatusB TINYINT OUTPUT,
	@nRet INT OUTPUT
AS

BEGIN

	SET NOCOUNT ON

	SELECT @nRet = 0

-- to Character A : applicant

	BEGIN TRAN

	IF EXISTS(SELECT nCharNo FROM tMarriage WHERE nCharNo = @CharANo AND nPartnerCharNo = @CharBNo)
	BEGIN
		SELECT @SubStatusA = nSubStatus FROM tMarriage WHERE nCharNo = @CharANo
		UPDATE tMarriage
		SET
			nSubStatus =
			CASE nSubStatus
				WHEN 1 THEN 1 + 4
				WHEN 3 THEN 3 + 4
				ELSE nSubStatus
			END,
			nDivorceCancel = nDivorceCancel + @IncreseCount,
			dSubWhen = dWhen
		WHERE
			nCharNo = @CharANo

		 IF @@ERROR <> 0 GOTO ERROR_
	END
	ELSE GOTO ERROR_

-- to Character B

	IF EXISTS(SELECT nCharNo FROM tMarriage WHERE nCharNo = @CharBNo AND nPartnerCharNo = @CharANo)
	BEGIN
		SELECT @SubStatusB = nSubStatus FROM tMarriage WHERE nCharNo = @CharBNo
		UPDATE tMarriage
		SET
			nSubStatus = 0,
			dSubWhen = dWhen
		WHERE
			nCharNo = @CharBNo

		 IF @@ERROR <> 0 GOTO ERROR_
	END
	ELSE GOTO ERROR_

	COMMIT TRAN
	GOTO END_

ERROR_:
	ROLLBACK TRAN
	SELECT @nRet = 1

END_:
	SET NOCOUNT OFF

END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_Wedding_Divorce_Do]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_Wedding_Divorce_Do]
GO






CREATE PROCEDURE [dbo].[p_Char_Wedding_Divorce_Do]
	@CharANo INT,
	@CharBNo INT,
	@nRet INT OUTPUT
AS

BEGIN

	SET NOCOUNT ON

	SELECT @nRet = 0

-- to Character A : applicant

	BEGIN TRAN

	IF EXISTS(SELECT nCharNo FROM tMarriage WHERE nCharNo = @CharANo AND nPartnerCharNo = @CharBNo)
	BEGIN
		UPDATE tMarriage
		SET
			nStatus = 3,
			nSubStatus = 1,
			--dSubWhen = DATEADD(day, 7, GETDATE())
			dSubWhen = DATEADD(minute, 3, GETDATE())
		WHERE
			nCharNo = @CharANo

		 IF @@ERROR <> 0 GOTO ERROR_
	END
	ELSE GOTO ERROR_

-- to Character B

	IF EXISTS(SELECT nCharNo FROM tMarriage WHERE nCharNo = @CharBNo AND nPartnerCharNo = @CharANo)
	BEGIN
		UPDATE tMarriage
		SET
			nStatus = 3,
			nSubStatus = 1,
			--dSubWhen = DATEADD(day, 7, GETDATE())
			dSubWhen = DATEADD(minute, 3, GETDATE())
		WHERE
			nCharNo = @CharBNo

		 IF @@ERROR <> 0 GOTO ERROR_
	END
	ELSE GOTO ERROR_

	COMMIT TRAN
	GOTO END_

ERROR_:
	ROLLBACK TRAN
	SELECT @nRet = 1

END_:
	SET NOCOUNT OFF

END




GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_Wedding_Divorce_Do_by_Item]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_Wedding_Divorce_Do_by_Item]
GO
CREATE PROCEDURE [dbo].[p_Char_Wedding_Divorce_Do_by_Item]
	@CharANo INT,
	@CharBNo INT,
	@nRet INT OUTPUT
AS
BEGIN
	SET NOCOUNT ON
	SELECT @nRet = 0
-- to Character A : applicant
	BEGIN TRAN
	IF EXISTS(SELECT nCharNo FROM tMarriage WHERE nCharNo = @CharANo AND nPartnerCharNo = @CharBNo)
	BEGIN
		UPDATE tMarriage
		SET
			nStatus = 3,
			nSubStatus = 1,
			-- 즉시 결혼도 가능하달라고 해서 수정함
			dSubWhen = DATEADD(second, 5, GETDATE())
		WHERE
			nCharNo = @CharANo
		 IF @@ERROR <> 0 GOTO ERROR_
	END
	ELSE GOTO ERROR_
-- to Character B
	IF EXISTS(SELECT nCharNo FROM tMarriage WHERE nCharNo = @CharBNo AND nPartnerCharNo = @CharANo)
	BEGIN
		UPDATE tMarriage
		SET
			nStatus = 3,
			nSubStatus = 2,
			-- 즉시 결혼도 가능하달라고 해서 수정함
			dSubWhen = DATEADD(second, 5, GETDATE())
		WHERE
			nCharNo = @CharBNo
		 IF @@ERROR <> 0 GOTO ERROR_
	END
	ELSE GOTO ERROR_
	COMMIT TRAN
	GOTO END_
ERROR_:
	ROLLBACK TRAN
	SELECT @nRet = 1
END_:
	SET NOCOUNT OFF
END
GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_Wedding_Do]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_Wedding_Do]
GO






CREATE PROCEDURE [dbo].[p_Char_Wedding_Do] 
	@CharANo INT,
	@CharBNo INT,
	@nRet INT OUTPUT
AS

BEGIN

	SET NOCOUNT ON

	SELECT @nRet = 0

-- to Character A

	BEGIN TRAN

	IF EXISTS(SELECT nCharNo FROM tMarriage WHERE nCharNo = @CharANo AND nPartnerCharNo = @CharBNo)
	BEGIN
		UPDATE tMarriage
		SET
			nStatus = 2,
			nSubStatus = 0,
			dWhen = GETDATE(),
--			dSubWhen = DATEADD(day, 7, GETDATE()),
			dSubWhen = DATEADD(minute, 3, GETDATE()),
			nMarriageCount = nMarriageCount + 1,
			nDivorceCancel = 0
		WHERE
			nCharNo = @CharANo

		 IF @@ERROR <> 0 GOTO ERROR_
	END
	ELSE GOTO ERROR_

-- to Character B

	IF EXISTS(SELECT nCharNo FROM tMarriage WHERE nCharNo = @CharBNo AND nPartnerCharNo = @CharANo)
	BEGIN
		UPDATE tMarriage
		SET
			nStatus = 2,
			nSubStatus = 0,
			dWhen = GETDATE(),
--			dSubWhen = DATEADD(day, 7, GETDATE()),
			dSubWhen = DATEADD(minute, 3, GETDATE()),
			nMarriageCount = nMarriageCount + 1,
			nDivorceCancel = 0
		WHERE
			nCharNo = @CharBNo

		 IF @@ERROR <> 0 GOTO ERROR_
	END
	ELSE GOTO ERROR_

	COMMIT TRAN
	GOTO END_

ERROR_:
	ROLLBACK TRAN
	SELECT @nRet = 1

END_:
	SET NOCOUNT OFF

END



GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_Wedding_Escape_Divorce_State]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_Wedding_Escape_Divorce_State]
GO






CREATE PROCEDURE [dbo].[p_Char_Wedding_Escape_Divorce_State]
	@CharNo INT,
	@nRet INT OUTPUT
AS

BEGIN

	SET NOCOUNT ON

	IF EXISTS(SELECT nCharNo FROM tMarriage WHERE nCharNo = @CharNo)
	BEGIN
		SELECT @nRet = 0
		UPDATE tMarriage
		SET
			nStatus = 0,
			nSubStatus = 0,
			nDivorceCancel = 0
		WHERE
			nCharNo = @CharNo
	END
	ELSE
	BEGIN
		SELECT @nRet = 1
	END

	SET NOCOUNT OFF

END




GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_Wedding_Get_Partner_Info]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_Wedding_Get_Partner_Info]
GO






CREATE PROCEDURE [dbo].[p_Char_Wedding_Get_Partner_Info]
	@CharNo INT
AS

BEGIN

	SET NOCOUNT ON

	SELECT nLevel, dLastLoginDate FROM tCharacter WHERE nCharNo = @CharNo

	SET NOCOUNT OFF

END




GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_Wedding_Propose]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_Wedding_Propose]
GO






CREATE PROCEDURE [dbo].[p_Char_Wedding_Propose]
	@CharANo INT,
	@CharBNo INT,
	@nRet INT OUTPUT
AS

BEGIN

	SET NOCOUNT ON

	SELECT @nRet = 0

-- to Character A

	BEGIN TRAN

	IF EXISTS(SELECT nCharNo FROM tMarriage WHERE nCharNo = @CharANo)
	BEGIN
		UPDATE tMarriage
		SET
			nPartnerCharNo = @CharBNo,
			nStatus = 1,
			nSubStatus = 0,
			dWhen = GETDATE(),
			dSubWhen = DATEADD(day, 3, GETDATE())

		WHERE
			nCharNo = @CharANo

		 IF @@ERROR <> 0 GOTO ERROR_
	END
	ELSE
	BEGIN
		INSERT tMarriage(nCharNo, nPartnerCharNo, nStatus, nSubStatus, dWhen, dSubWhen)
		VALUES(@CharANo, @CharBNo, 1,  0, GETDATE(), DATEADD(day, 3, GETDATE()))		

		 IF @@ERROR <> 0 GOTO ERROR_
	END

-- to Character B

	IF EXISTS(SELECT nCharNo FROM tMarriage WHERE nCharNo = @CharBNo)
	BEGIN
		UPDATE tMarriage
		SET
			nPartnerCharNo = @CharANo,
			nStatus = 1,
			nSubStatus = 0,
			dWhen = GETDATE(),
			dSubWhen = DATEADD(day, 3, GETDATE())
		WHERE
			nCharNo = @CharBNo

		 IF @@ERROR <> 0 GOTO ERROR_
	END
	ELSE
	BEGIN
		INSERT tMarriage(nCharNo, nPartnerCharNo, nStatus, nSubStatus, dWhen, dSubWhen)
		VALUES(@CharBNo, @CharANo, 1,  0, GETDATE(), DATEADD(day, 3, GETDATE()))		

		 IF @@ERROR <> 0 GOTO ERROR_
	END

	COMMIT TRAN
	GOTO END_

ERROR_:
	ROLLBACK TRAN
	SELECT @nRet = 1

END_:
	SET NOCOUNT OFF

END




GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_WeddingStatus_Get]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_WeddingStatus_Get]
GO

CREATE PROCEDURE [dbo].[p_Char_WeddingStatus_Get]
	@CharNo INT
AS
BEGIN
	SET NOCOUNT ON

	IF NOT EXISTS(SELECT * FROM tMarriage WHERE nCharNo = @CharNo)
	BEGIN
		INSERT tMarriage(nCharNo, nPartnerCharNo, dWhen, dSubWhen) VALUES(@CharNo, 0, GETDATE(), GETDATE())
	END

	SELECT nPartnerCharNo, nStatus, nSubStatus, dWhen, dSubWhen, nMarriageCount, nDivorceCancel FROM tMarriage WHERE nCharNo = @CharNo

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_WeddingStatus_Set]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_WeddingStatus_Set]
GO






CREATE PROCEDURE [dbo].[p_Char_WeddingStatus_Set]
	@CharNo INT,
	@PartnerCharNo INT,
	@Status SMALLINT,
	@SubStatus SMALLINT,
	@When DATETIME,
	@SubWhen DATETIME,
	@MarriageCount TINYINT,
	@DivorceCancel TINYINT
AS

BEGIN

	SET NOCOUNT ON

	IF EXISTS(SELECT nCharNo FROM tMarriage WHERE nCharNo = @CharNo)
	BEGIN
		UPDATE tMarriage
		SET
			nPartnerCharNo = @PartnerCharNo,
			nStatus = @Status,
			nSubStatus = @SubStatus,
			dWhen = @When,
			dSubWhen = @SubWhen,
			nMarriageCount = @MarriageCount,
			nDivorceCancel = @DivorceCancel
		WHERE
			nCharNo = @CharNo
	END
	ELSE
	BEGIN
		INSERT tMarriage(nCharNo, nPartnerCharNo, nStatus, nSubStatus, dWhen, dSubWhen)
		VALUES(@CharNo, @PartnerCharNo, @Status, @SubStatus, @When, @SubWhen)
		
	END

	SET NOCOUNT OFF

END




GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Char_Wipe]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Char_Wipe]
GO
/****** 개체: 저장 프로시저 dbo.p_Char_Wipe    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/


CREATE PROCEDURE [dbo].[p_Char_Wipe]
/*

Character Wipe(Erase)
2006.5 By CJC

 input:
	nCharNo

 output:
	@nRet	0 = OK, 
	        ? = Error code
*/

@nCharNo int,

@nRet int OUTPUT

AS

SET NOCOUNT ON

DELETE FROM tFriend WHERE nCharNo = @nCharNo			-- 관계에 의해 삭제됨
DELETE FROM tFriend WHERE nFriendCharNo = @nCharNo	-- 친구 테이블 순환 참고 없앰용

DELETE FROM tCharacter WHERE nCharNo = @nCharNo

SET @nRet = @@ERROR

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Event_Friend_Reward]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Event_Friend_Reward]
GO
/****** 개체: 저장 프로시저 dbo.p_Event_Friend_Reward    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/



/*==================================================
@author	lenasoft
@date	2006-05-22
@return	0		<성공>
	others		<실패>
@brief	이벤트 친구에게 보상한다.
	개정창고 4 맨끝 위치부터 차곡차곡 쌓아간다.
	개정창고 2 맨첨까지 다 쌓았을경우. 혹시 빈 슬롯을 찾는다(GOTO CRITICAL)
	정말로 넣을자리가 없는경우 FULL 리턴값을 리턴한다.
==================================================*/

CREATE PROCEDURE [dbo].[p_Event_Friend_Reward]
@nFriendCharNo	int,
@nItemKey	bigint,
@err 		smallint OUTPUT

AS
SET NOCOUNT ON

DECLARE
@nFriendUserNo		int,
@nLevel 			smallint,
@nRewardItemID		int,
@nLevelReward_1_23	int,
@nLevelReward_24_47	int,
@nLevelReward_48_100	int,
@nStorage_Min		smallint,
@nStorage_Max		smallint,
@nStorageType		tinyint,
@nItemID		int,
@nOptionType		smallint,
@nOptionData		bigint,
@nOldItemKey		bigint



-- Hard Fixed...

SET @nStorage_Max 		= 143 	--개정창고 4 맨끝 위치.

SET @nStorageType 		= 6 	--개정창고

SET @nLevelReward_1_23 		= 8004 	-- 축복의 릭스(강도1)
SET @nLevelReward_24_47 	= 8013 	-- 축복의 릭스(강도2)
SET @nLevelReward_48_100 	= 8022 	-- 축복의 릭스(강도3)

SET @nOptionType 		= 1	-- Max = 255


SELECT @nLevel = nLevel, @nFriendUserNo=nUserNo  FROM tCharacter WITH(READUNCOMMITTED) 
	WHERE nCharNo = @nFriendCharNo
IF @@ROWCOUNT = 0
BEGIN
	SET @err = 1
	PRINT('Not Exitist Friend')
	RETURN @@ERROR
END
PRINT('@nLeve=')
PRINT(@nLevel)

IF @nLevel > 0 AND @nLevel < 24
	SET @nRewardItemID = @nLevelReward_1_23
ELSE IF @nLevel > 23 AND @nLevel < 48
	SET @nRewardItemID = @nLevelReward_24_47
ELSE
	SET @nRewardItemID = @nLevelReward_48_100

PRINT('@nRewardItemID=')
PRINT(@nRewardItemID)

SELECT @nStorage_Min = ISNULL(MIN( nStorage ), 0) FROM tItem WHERE nOwner=@nFriendUserNo AND nStorageType =@nStorageType 
	AND ( nItemID= @nLevelReward_1_23 OR nItemID= @nLevelReward_24_47 OR nItemID= @nLevelReward_48_100 )

PRINT('@nStorage_Min=')
PRINT(@nStorage_Min)

-- 개정창고 2 3 4 번 다 썼다.(@nStorage_Min=36)
IF @nStorage_Min > 0 AND @nStorage_Min < 37 
	BEGIN
		PRINT('IF @nStorage_Min > 0 AND @nStorage_Min < 36 ')
		GOTO CRITICAL
	END

IF @nStorage_Min = 0
	BEGIN
		SET	@nStorage_Min = @nStorage_Max
		SET	@nOptionData = 5


	END
ELSE
	BEGIN
		SELECT @nItemID = I.nItemID, @nOptionData=O.nOptionData, @nOldItemKey=I.nItemKey FROM tItem I
			INNER JOIN tItemOptions O ON I.nItemKey = O.nItemKey AND O.nOptionType = @nOptionType
			WHERE I.nOwner=@nFriendUserNo AND I.nStorageType =@nStorageType 
			AND I.nStorage = @nStorage_Min 

		PRINT('@@ROWCOUNT=')
		PRINT(@@ROWCOUNT)

		PRINT('@nItemID=')
		PRINT(@nItemID)

		PRINT('@nOptionData=')
		PRINT(@nOptionData)

		IF @nRewardItemID = @nItemID
			BEGIN
				-- 기존값에 추가한다.
				IF @nOptionData > 0 AND @nOptionData < 6 
				BEGIN
					SET	@nOptionData = @nOptionData+5
					--SET	@nStorage_Min = @nStorage_Min
				END
				ELSE
				BEGIN
					SET 	@nOptionData = 5
					SET	@nStorage_Min = @nStorage_Min-1
					PRINT('SET	@nStorage_Min = @nStorage_Min-1')
					PRINT(@nStorage_Min)

				END

			END
		ELSE
			BEGIN
				SET	@nStorage_Min = @nStorage_Min-1
				SET	@nOptionData = 5
			END
		
	END

-- 넣으려는 자리에 다른 아이템이 있는지 체크.(이벤트 전에 들어가 있던 아이템)
IF @nOptionData = 5
BEGIN
	IF EXISTS (SELECT nItemID  FROM tItem WHERE nOwner=@nFriendUserNo AND nStorageType =@nStorageType 
		AND nStorage=@nStorage_Min )
	BEGIN
		GOTO CRITICAL
	END

END

-- 아템 넣기.
BEGIN TRANSACTION

-- 새롭게 아템을 넣는다.
IF @nOptionData = 5
	BEGIN
		PRINT('INSERT tItem nItemKey')
		PRINT(@nItemKey)

		INSERT INTO tItem(nItemKey, nStorageType, nOwner, nStorage, nItemID, nFlags)
			VALUES(@nItemKey, @nStorageType, @nFriendUserNo, @nStorage_Min, @nRewardItemID, 0 )
		IF @@ERROR <> 0
		BEGIN
			GOTO ERR
		END
		PRINT('INSERT tItemOptions nItemKey')
		PRINT(@nItemKey)
		INSERT INTO tItemOptions(nItemKey, nOptionType, nOptionData)
			VALUES(@nItemKey, @nOptionType, @nOptionData )
		IF @@ERROR <> 0
		BEGIN
			GOTO ERR
		END
	END
-- 기존에 개수를 늘린다.
ELSE

	BEGIN
		PRINT('UPDATE tItemOptions nItemKey')
		PRINT(@nOldItemKey)
		UPDATE tItemOptions
		SET nOptionData=@nOptionData
		WHERE nItemKey = @nOldItemKey
		IF @@ERROR <> 0
		BEGIN
			GOTO ERR
		END

	END


COMMIT TRANSACTION
PRINT('COMMIT')
SET @err = 0
RETURN @@ERROR

ERR:

ROLLBACK TRANSACTION
PRINT('ROLLBACK')
SET @err = 2
RETURN @@ERROR


CRITICAL:
--  빈슬롯을 찾는다.
PRINT('CRITICAL')

declare
@nStrorageCurser int

SET @nStrorageCurser = @nStorage_Max

WHILE @nStrorageCurser > 35
BEGIN

	SELECT @nItemID = I.nItemID, @nOptionData=O.nOptionData, @nOldItemKey=I.nItemKey FROM tItem I
		INNER JOIN tItemOptions O ON I.nItemKey = O.nItemKey AND O.nOptionType = @nOptionType
		WHERE I.nOwner=@nFriendUserNo AND I.nStorageType =@nStorageType 
		AND I.nStorage =@nStrorageCurser
	IF @@ROWCOUNT = 0 
		BEGIN
			BREAK
		END
	ELSE
		BEGIN
			SET @nStrorageCurser = @nStrorageCurser-1
			CONTINUE
		END
END

IF @nStrorageCurser = 35
	BEGIN
		PRINT('FULL STORAGE')
		SET @err = 3
	END
ELSE
	BEGIN
		BEGIN TRANSACTION
		PRINT('@nStrorageCurser')
		PRINT(@nStrorageCurser)

		INSERT INTO tItem(nItemKey, nStorageType, nOwner, nStorage, nItemID, nFlags)
			VALUES(@nItemKey, @nStorageType, @nFriendUserNo, @nStrorageCurser, @nRewardItemID, 0 )
		IF @@ERROR <> 0
		BEGIN
			ROLLBACK TRANSACTION
			PRINT('ROLLBACK')
			SET @err = 2
			RETURN @@ERROR
		END

		PRINT('INSERT 2 tItemOptions nItemKey')
		PRINT(@nItemKey)

		INSERT INTO tItemOptions(nItemKey, nOptionType, nOptionData)
			VALUES(@nItemKey, @nOptionType, @nOptionData )
		IF @@ERROR <> 0
		BEGIN
			ROLLBACK TRANSACTION
			PRINT('ROLLBACK')
			SET @err = 2
			RETURN @@ERROR
		END

		COMMIT TRANSACTION
		SET @err = 0
	END

RETURN @@ERROR

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Event_WorldCup_Init]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Event_WorldCup_Init]
GO
/****** 개체: 저장 프로시저 dbo.p_Event_WorldCup_Init    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/



/*==================================================
@author	lenasoft
@date	2006-05-29
@return	0		<성공>
	others		<실패>
@brief	월드컵이벤트 
==================================================*/

CREATE PROCEDURE [dbo].[p_Event_WorldCup_Init]
@nCharNo int,
@bNewJoiner tinyint OUTPUT

AS
SET NOCOUNT ON

DECLARE
@dRegisterDate	datetime,
@dEventStartDate	datetime,
@dEventEndDate	datetime


SET @dEventStartDate = '2006-05-30' --테스트
SET @dEventEndDate =  '2006-06-07' --6월 06일까지.

IF GETDATE() > @dEventEndDate
BEGIN
	SET	@bNewJoiner = 0
	RETURN @@error
END

SELECT @dRegisterDate=dCreateDate   
	FROM tCharacter
	WHERE nCharNo = @nCharNo --AND 

IF @@ROWCOUNT = 0
BEGIN
	SET	@bNewJoiner = 0
	RETURN @@error
END

IF @dRegisterDate > @dEventStartDate AND @dRegisterDate < @dEventEndDate
	BEGIN
		SET	@bNewJoiner = 1
	END
ELSE
	BEGIN
		SET	@bNewJoiner = 0
	END

RETURN @@error

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Friend_Del]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Friend_Del]
GO
/****** 개체: 저장 프로시저 dbo.p_Friend_Del    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/


CREATE PROCEDURE [dbo].[p_Friend_Del]
/*
Friend Delete
2004.12 By CJC
 input:
	nCharNo, nFriendCharNo = To be delete info.
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/

@nCharNo int,
@nFriendCharNo int,
@nRet int OUTPUT

AS

SET NOCOUNT ON

-- cross delete
DELETE FROM tFriend WHERE nCharNo = @nCharNo AND nFriendCharNo = @nFriendCharNo
SET @nRet = @@ERROR

DELETE FROM tFriend WHERE nCharNo = @nFriendCharNo AND nFriendCharNo = @nCharNo 
SET @nRet = @nRet + @@ERROR

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Friend_Del_All]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Friend_Del_All]
GO
CREATE PROCEDURE [dbo].[p_Friend_Del_All]
/*
Friend Delete
2007.12 By CJC
 input:
	nCharNo = To be delete info.
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/

@nCharNo int,
@nRet int OUTPUT

AS

SET NOCOUNT ON

-- cross delete
DELETE FROM tFriend WHERE nCharNo = @nCharNo OR nFriendCharNo = @nCharNo
SET @nRet = @@ERROR

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Friend_Get]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Friend_Get]
GO
/****** 개체: 저장 프로시저 dbo.p_Friend_Get    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/


CREATE PROCEDURE [dbo].[p_Friend_Get]

/*
Char Get friend
2004.12 By CJC
 input:
	see SQL
 output:
	fetch to take data
*/

@nCharNo int,
@nFriendNo int

AS

SET NOCOUNT ON SELECT 
F.nFriendCharNo,
F.nFlags, 

C.sID,
S.nClass,
C.nLevel,
C.sLoginZone,
C.dLastLoginDate

FROM tFriend AS F
INNER JOIN tCharacterShape AS S ON S.nCharNo =  @nFriendNo
INNER JOIN tCharacter AS C ON C.nCharNo = @nFriendNo AND C.bDeleted = 0
WHERE F.nCharNo = @nCharNo AND F.nFriendCharNo = @nFriendNo

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Friend_GetAll]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Friend_GetAll]
GO
/****** 개체: 저장 프로시저 dbo.p_Friend_GetAll    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/
CREATE PROCEDURE [dbo].[p_Friend_GetAll]

/*
Char Get friend all
2004.12 By CJC
 input:
	see SQL
 output:
	fetch to take data
*/

@nCharNo int

AS

SET NOCOUNT ON

SELECT F.nFriendCharNo, F.nFlags, C.sID
FROM tFriend AS F
INNER JOIN tCharacter AS C ON C.nCharNo =  F.nFriendCharNo AND C.bDeleted = 0
WHERE F.nCharNo = @nCharNo

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Friend_GetAll2]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Friend_GetAll2]
GO
/****** 개체: 저장 프로시저 dbo.p_Friend_GetAll2    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/
CREATE PROCEDURE [dbo].[p_Friend_GetAll2]

/*
Char Get friend all
2007.2.14 By CJC
 input:
	see SQL
 output:
	fetch to take data
*/

@nCharNo int

AS

SET NOCOUNT ON

SELECT 
F.nFriendCharNo,
F.nFlags, 

C.sID,
S.nClass,
C.nLevel,
C.sLoginZone,
C.dLastLoginDate

FROM tFriend AS F
INNER JOIN tCharacterShape AS S ON S.nCharNo = F.nFriendCharNo
INNER JOIN tCharacter AS C ON C.nCharNo = F.nFriendCharNo AND C.bDeleted = 0
WHERE F.nCharNo = @nCharNo

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Friend_GetNumOfFriend]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Friend_GetNumOfFriend]
GO
/****** 개체: 저장 프로시저 dbo.p_Friend_GetNumOfFriend    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/
CREATE PROCEDURE [dbo].[p_Friend_GetNumOfFriend]

/*
Char Get friend all
2004.12 By CJC
 input:
	see SQL
 output:
	fetch to take data
*/

@nCharNo int,
@nNumOfFriend int OUTPUT

AS

SET NOCOUNT ON

SET @nNumOfFriend = 0

SELECT @nNumOfFriend = COUNT(*) FROM tFriend AS F WITH(READUNCOMMITTED) 
INNER JOIN tCharacter AS C WITH(READUNCOMMITTED) ON C.nCharNo = F.nFriendCharNo AND C.bDeleted = 0
WHERE F.nCharNo = @nCharNo

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Friend_Set]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Friend_Set]
GO
/****** 개체: 저장 프로시저 dbo.p_Friend_Set    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/
CREATE PROCEDURE [dbo].[p_Friend_Set]
/*
Char Set friend
2004.12 By CJC

 input:
	see SQL
	
 output:
	@nRet	0 = OK, 
			1 = friend and me are same char
			2 = i'm over max friend count
			3 = friend is over max friend count
			547 = DB error, nCharNo or nFriendCharNo is not existed Character(Foreign Key checked)
			2627 = DB error, already friend marked
	        ? = Other DB error code
	        
*/
@nMAXFRIEND smallint,
@nCharNo int,
@nFriendCharNo int,
@nFlags tinyint,
@nRet int OUTPUT

AS

SET NOCOUNT ON

-- check firend and me are same char.
IF @nCharNo = @nFriendCharNo
BEGIN
	SET @nRet = 1
	RETURN
END

-- check over max firend
DECLARE @nFriendCount int
EXEC p_Friend_GetNumOfFriend @nCharNo, @nFriendCount OUTPUT
IF @nFriendCount >= @nMAXFRIEND
BEGIN
	SET @nRet = 2
	RETURN
END

EXEC p_Friend_GetNumOfFriend @nFriendCharNo, @nFriendCount OUTPUT
IF @nFriendCount >= @nMAXFRIEND
BEGIN
	SET @nRet = 3
	RETURN
END

-- add friend
BEGIN TRAN

INSERT tFriend (  nCharNo,  nFriendCharNo,  nFlags )
VALUES         ( @nCharNo, @nFriendCharNo, @nFlags )
SET @nRet = @@ERROR
if( @nRet <> 0 )
BEGIN
	ROLLBACK TRAN
	RETURN
END

-- add friend cross
INSERT tFriend (  nCharNo,  nFriendCharNo,  nFlags )
VALUES         ( @nFriendCharNo, @nCharNo, @nFlags )
SET @nRet = @@ERROR
if( @nRet <> 0 )
BEGIN
	ROLLBACK TRAN
	RETURN
END

COMMIT TRAN
RETURN

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_Delete]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_Delete]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_Delete    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/



CREATE PROCEDURE [dbo].[p_Guild_Delete]

/*
Char Delete Guild
2006.2 By CJC

Input:
	See SQL
	
Output:
	nRet = 0,  Error(Not found guild)
	nRet = 1,  OK
*/

@nNo int,
@nRet tinyint output

AS

SET NOCOUNT ON

SET @nRet = 0

DELETE FROM tGuild WHERE nNo = @nNo
SET @nRet = @@ROWCOUNT

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_Get]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_Get]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_Get    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/



CREATE PROCEDURE [dbo].[p_Guild_Get]

/*
Get Guild
2006.2 By CJC
*/

@nNo int

AS

SET NOCOUNT ON

SELECT 

	sName,
	sPassword,
	nMaxMembers,
	nMoney,
	nType,
	nGrade,
	nFame,
	nStoneLevel,
	nExp,
	dCreateDate,

	dWarRequestDate,
	dWarStartDate,
	dWarEndDate,
	nWarEnemy,
	nWarWinCount,
	nWarLoseCount,
	nWarDrawCount,
	
	nDismissStatus,
	dDismissDate,

	dNotifyDate,
	sNotifyCharID,
	sNotify,
	
	sIntro
	
FROM tGuild WHERE @nNo = nNo

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_GetAll]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_GetAll]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_GetAll    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/



CREATE PROCEDURE [dbo].[p_Guild_GetAll]

/*
Char Get All Guild
2006.2 By CJC
*/

AS

SET NOCOUNT ON

SELECT

	nNo,
	sName,
	sPassword,
	nMaxMembers,
	nMoney,
	nType,
	nGrade,
	nFame,
	nStoneLevel,
	nExp,
	dCreateDate,

	dWarRequestDate,
	dWarStartDate,
	dWarEndDate,
	nWarEnemy,
	nWarWinCount,
	nWarLoseCount,
	nWarDrawCount,

	nDismissStatus,
	dDismissDate,

	dNotifyDate,
	sNotifyCharID,
	sNotify,
	
	sIntro
	
FROM tGuild

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_GetCount]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_GetCount]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_GetCount    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/



CREATE PROCEDURE [dbo].[p_Guild_GetCount]

/*
Char Get Guild Count
2006.2 By CJC
*/

@nCount int output

AS

SET NOCOUNT ON

SELECT @nCount = COUNT(*) FROM tGuild

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_GetIntro]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_GetIntro]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_GetIntro    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/



CREATE PROCEDURE [dbo].[p_Guild_GetIntro]

/*
Get Guild Intro
2006.2 By CJC
*/

@nNo int

AS

SET NOCOUNT ON

SELECT sIntro FROM tGuild WHERE @nNo = nNo

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_GetList]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_GetList]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_GetList    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/


CREATE PROCEDURE [dbo].[p_Guild_GetList]

/*
Char Get All Guild lIst
2006.3 By blacksky
*/

AS

SET NOCOUNT ON

SELECT

	nNo,
	sName
	
FROM tGuild

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_GetListDetail]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_GetListDetail]
GO
CREATE PROCEDURE [dbo].[p_Guild_GetListDetail]

/*
Char Get All Guild lIst detail
2007.11 By khris
*/

AS

SET NOCOUNT ON

SELECT

	nNo,
	sName,
	nMaxMembers,
	nType,
	nGrade,
	nFame,
	nExp
	
FROM tGuild

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_GetMyNo]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_GetMyNo]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_GetMyNo    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/



CREATE PROCEDURE [dbo].[p_Guild_GetMyNo]

/*
Get My Guild Number
2006.2 By CJC

Input:
	See SQL
	
Output:
	@nNo = 0, I'm not join guild
	@nNo = ?, My guild No.
*/

@nCharNo int,
@nNo     int output

AS

SET NOCOUNT ON

SET @nNo = 0
SELECT @nNo = nNo FROM tGuildMember WHERE nCharNo = @nCharNo

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_GetName]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_GetName]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_GetName    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/



CREATE PROCEDURE [dbo].[p_Guild_GetName]

/*
Get Guild Intro
2006.2 By Blacksky
*/

@nNo int

AS

SET NOCOUNT ON

SELECT sName FROM tGuild WHERE @nNo = nNo

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_GetNotify]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_GetNotify]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_GetNotify    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/



CREATE PROCEDURE [dbo].[p_Guild_GetNotify]

/*
Get Guild Notify
2006.2 By CJC
*/

@nNo int

AS

SET NOCOUNT ON

SELECT dNotifyDate, sNotifyCharID, sNotify FROM tGuild WHERE @nNo = nNo

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_Make]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_Make]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_Make    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/



CREATE PROCEDURE [dbo].[p_Guild_Make]

/*
Make Guild
2006.2 By CJC

Input:
	See SQL
	
Output:
	nNo = 0,   Error
	nNo = -1,  Error( Same guild name exist )
	nNo = -2,  Error( Not exists need item )
	nNo = -3,  Error( Other guild member )
	nNo = -4,  Error( Not enough maker money )
	nNo = -5,  Error( Make Guild error )
	nNo = -6,  Error( Maker to Join Guild master )
	nNo = 1~?, OK( Maked guild No )
*/

@sName nvarchar(18),
@sPassword nvarchar(9),
@nMaxMembers smallint,
@nType tinyint,

@nMakerCharNo int,
@nMakerPay bigint,
@nMakerNeedItemID int,

@nNo int output

AS

SET NOCOUNT ON

-- 에러코드 일단 세팅
SET @nNo = 0

-- 해당 길드가 있는지 확인
IF EXISTS (SELECT sName FROM tGuild(NOLOCK) WHERE sName = @sName)
BEGIN
	SET @nNo = -1
	RETURN
END

-- 필요아이템을 사용하는경우, 해당 아이템이 있는지 확인
IF @nMakerNeedItemID <> 65535
BEGIN
	IF NOT EXISTS (SELECT nItemID FROM tItem(NOLOCK) WHERE nOwner = @nMakerCharNo AND nItemID = @nMakerNeedItemID)
	BEGIN
		SET @nNo = -2
		RETURN
	END
END

-- 이미 다른 길드 가입했는지 확인
IF EXISTS (SELECT nCharNo FROM tGuildMember(NOLOCK) WHERE nCharNo = @nMakerCharNo)
BEGIN
	SET @nNo = -3
	RETURN
END

-- 길드 창설비용 적용
DECLARE @nRet tinyint

BEGIN TRAN
EXEC p_Char_MoneySub @nMakerCharNo, @nMakerPay, @nRet OUTPUT
IF @nRet = 0 -- 에러 확인
BEGIN
	ROLLBACK TRAN
	SET @nNo = -4
	RETURN
END

-- 길드 만들기
INSERT tGuild (  sName,  sPassword,  nMaxMembers,  nType )
VALUES        ( @sName, @sPassword, @nMaxMembers, @nType )
SET @nNo = @@IDENTITY

-- 길드 만들기 오류 확인
IF @@ERROR <> 0 
BEGIN
	ROLLBACK TRAN
	SET @nNo = -5
	RETURN
END

-- 만든 캐릭을 길마으로 추가
EXEC p_Guild_Member_Join @nNo, @nMakerCharNo, 0, @nRet OUTPUT
IF @nRet = 0
BEGIN 
	ROLLBACK TRAN
	SET @nNo = -6
	RETURN
END

-- 만들기 성공
COMMIT TRAN

RETURN

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_Make2]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_Make2]
GO

-- ÀÛ¾÷ÀÚ : °íµ¿±Õ
-- ÀÛ¾÷ÀÏ : 2008.7.3
-- ¹Ý¿µÀÏ : ±æµå¾ÆÄ«µ¥¹Ì°¡ ½Ã½ºÅÛ¿¡ Ãß°¡µÉ¶§...
-- ±æµå »ý¼º½Ã ¾ÆÄ«µ¥¹Ì°¡ ÀÚµ¿À¸·Î »ý¼ºµÇ±â À§ÇØ ¹Ýµå½Ã ¼öÁ¤µÇ¾î¾ßÇÏ´Â ÀúÀåÇÁ·Î½ÃÀú
CREATE    PROCEDURE [dbo].[p_Guild_Make2]
/*
Make Guild
2006.12.15 By CJC
Input:
	See SQL
	
Output:
	nNo = 0,   Error, Remain char money
	nNo = -1,  Error( Same guild name exist )
	nNo = -2,  Error( Not exists need item )
	nNo = -3,  Error( Other guild member )
	nNo = -4,  Error( Not enough maker money )
	nNo = -5,  Error( Make Guild error )
	nNo = -6,  Error( Maker to Join Guild master )
	nNo = 1~?, OK( Maked guild No )
*/
@sName nvarchar(18),
@sPassword nvarchar(9),
@nMaxMembers smallint,
@nType tinyint,
@nMakerCharNo int,
@nMakerPay bigint,
@nMakerNeedItemID int,
@nNo int output,
@nRemainCharMoney bigint output
AS
SET NOCOUNT ON
-- ¿¡·¯ÄÚµå ÀÏ´Ü ¼¼ÆÃ
SET @nNo = 0
-- ÇØ´ç ±æµå°¡ ÀÖ´ÂÁö È®ÀÎ
IF EXISTS (SELECT sName FROM tGuild(NOLOCK) WHERE sName = @sName)
BEGIN
	SET @nNo = -1
	RETURN
END
-- ÇÊ¿ä¾ÆÀÌÅÛÀ» »ç¿ëÇÏ´Â°æ¿ì, ÇØ´ç ¾ÆÀÌÅÛÀÌ ÀÖ´ÂÁö È®ÀÎ
IF @nMakerNeedItemID <> 65535
BEGIN
	IF NOT EXISTS (SELECT nItemID FROM tItem(NOLOCK) WHERE nOwner = @nMakerCharNo AND nItemID = @nMakerNeedItemID)
	BEGIN
		SET @nNo = -2
		RETURN
	END
END
-- ÀÌ¹Ì ´Ù¸¥ ±æµå °¡ÀÔÇß´ÂÁö È®ÀÎ
IF EXISTS (SELECT nCharNo FROM tGuildMember(NOLOCK) WHERE nCharNo = @nMakerCharNo)
BEGIN
	SET @nNo = -3
	RETURN
END
-- ±æµå Ã¢¼³ºñ¿ë Àû¿ë
DECLARE @nRet tinyint
BEGIN TRAN
EXEC p_Char_MoneySub @nMakerCharNo, @nMakerPay, @nRet OUTPUT
IF @nRet = 0 -- ¿¡·¯ È®ÀÎ
BEGIN
	ROLLBACK TRAN
	SET @nNo = -4
	RETURN
END
-- ±æµå Ã¢¼³ºñ¿ëÀ» ¾²°í ³²Àºµ· ¾ò±â
EXEC p_Char_MoneyGet @nMakerCharNo, @nRemainCharMoney OUTPUT, @nRet OUTPUT
IF @nRet = 0 -- ¿¡·¯ È®ÀÎ
BEGIN
	ROLLBACK TRAN
	SET @nNo = -4
	RETURN
END
-- ±æµå ¸¸µé±â
INSERT tGuild (  sName,  sPassword,  nMaxMembers,  nType )
VALUES        ( @sName, @sPassword, @nMaxMembers, @nType )
SET @nNo = @@IDENTITY
-- ±æµå ¸¸µé±â ¿À·ù È®ÀÎ
IF @@ERROR <> 0 
BEGIN
	ROLLBACK TRAN
	SET @nNo = -5
	RETURN
END
-- ¸¸µç Ä³¸¯À» ±æ¸¶À¸·Î Ãß°¡
EXEC p_Guild_Member_Join @nNo, @nMakerCharNo, 0, @nRet OUTPUT
IF @nRet = 0
BEGIN 
	ROLLBACK TRAN
	SET @nNo = -6
	RETURN
END
-- ±æµå¾ÆÄ«µ¥¹Ì »ý¼º
EXEC usp_GuildAcademy_setAcademy @nNo, @nMakerCharNo, 50, @nRet OUTPUT
IF @nRet <> 0 -- ±æµå¾ÆÄ«µ¥¹Ì »ý¼º¿¡¼­´Â Á¤»óÃ³¸®½Ã 0À» return value·Î °¡Áü
BEGIN 
	ROLLBACK TRAN
	SET @nNo = @nRet
	RETURN
END
-- ¸¸µé±â ¼º°ø
COMMIT TRAN
RETURN
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_Member_Get]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_Member_Get]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_Member_Get    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/



CREATE PROCEDURE [dbo].[p_Guild_Member_Get]

/*
Get Guild Member
2006.2 By CJC

Input:
	See SQL
	
Output:
	fetch to take data
*/

@nNo int,
@nCharNo int

AS

SET NOCOUNT ON

SELECT G.dJoinDate, G.nGrade, G.nFlags, G.nExpRatio, G.sIntro, C.sID, S.nClass, C.nLevel, C.sLoginZone, C.dLastLoginDate
FROM tGuildMember    AS G INNER JOIN 
     tCharacter      AS C ON C.nCharNo =  G.nCharNo AND C.bDeleted = 0 INNER JOIN 
     tCharacterShape AS S ON S.nCharNo =  G.nCharNo
WHERE G.nCharNo = @nCharNo AND G.nNo = @nNo

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_Member_GetAll]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_Member_GetAll]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_Member_GetAll    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/



CREATE PROCEDURE [dbo].[p_Guild_Member_GetAll]

/*
Get Guild Member All
2006.2 By CJC

Input:
	See SQL
	
Output:
	nRet = 0,  Error(Not found guild)
	nRet = 1,  OK
*/

@nNo int

AS

SET NOCOUNT ON

SELECT G.nCharNo, G.dJoinDate, G.nGrade, G.nFlags, G.nExpRatio, G.sIntro, C.sID, S.nClass, C.nLevel, C.sLoginZone, C.dLastLoginDate
FROM tGuildMember    AS G INNER JOIN 
     tCharacter      AS C ON C.nCharNo =  G.nCharNo AND C.bDeleted = 0 INNER JOIN 
     tCharacterShape AS S ON S.nCharNo =  G.nCharNo
WHERE G.nNo = @nNo

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_Member_GetCount]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_Member_GetCount]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_Member_GetCount    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/
CREATE PROCEDURE [dbo].[p_Guild_Member_GetCount]

/*
Get Guild Member Count
2006.2 By CJC

Input:
	See SQL
	
Output:
	nCount = Number of member
*/

@nNo int,
@nCount int output
AS

SET NOCOUNT ON

SELECT @nCount = COUNT(*) FROM tGuildMember AS G WITH(READUNCOMMITTED) 
INNER JOIN tCharacter AS C WITH(READUNCOMMITTED) ON C.nCharNo = G.nCharNo AND C.bDeleted = 0
WHERE G.nNo = @nNo 

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_Member_Join]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_Member_Join]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_Member_Join    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/




CREATE PROCEDURE [dbo].[p_Guild_Member_Join]

/*
Get Guild Member Join
2006.2 By CJC

Input:
	See SQL
	
Output:
	nRet = 0, Error
	nRet = 1, OK
*/

@nNo int,
@nCharNo int,
@nGrade tinyint,

@nRet tinyint output
AS

SET NOCOUNT ON

SET @nRet = 0

-- 만들기
INSERT tGuildMember (  nNo,  nCharNo,  nGrade )
VALUES              ( @nNo, @nCharNo, @nGrade )

-- 오류 확인
IF @@ERROR <> 0 
BEGIN
	RETURN
END

SET @nRet = 1

-- end

RETURN

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_Member_Leave]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_Member_Leave]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_Member_Leave    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/



CREATE PROCEDURE [dbo].[p_Guild_Member_Leave]

/*
Get Guild Member Leave
2006.2 By CJC

Input:
	See SQL
	
Output:
	nRet = 0, Error
	nRet = 1, OK
*/

@nNo int,
@nCharNo int,

@nRet tinyint output
AS

SET NOCOUNT ON

SET @nRet = 0

-- 삭제
DELETE FROM tGuildMember WHERE nNo = @nNo AND nCharNo = @nCharNo
SET @nRet = @@ROWCOUNT

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_Member_SetExpRatio]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_Member_SetExpRatio]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_Member_SetExpRatio    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/



CREATE PROCEDURE [dbo].[p_Guild_Member_SetExpRatio]

/*
Set Guild Member Exp Ratio
2006.2 By CJC

Input:
	See SQL
	
Output:
	nRet = 0,  Error
	nRet = 1,  OK
*/

@nNo int,
@nCharNo int,
@nExpRatio smallint,

@nRet tinyint output

AS

SET NOCOUNT ON
SET @nRet = 0

UPDATE tGuildMember SET nExpRatio = @nExpRatio WHERE nNo = @nNo AND nCharNo = @nCharNo
SET @nRet = @@ROWCOUNT

IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
BEGIN
	SET @nRet = 0
	RETURN
END

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_Member_SetFlags]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_Member_SetFlags]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_Member_SetFlags    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/



CREATE PROCEDURE [dbo].[p_Guild_Member_SetFlags]

/*
Set Guild Member Flags
2006.2 By CJC

Input:
	See SQL
	
Output:
	nRet = 0,  Error
	nRet = 1,  OK
*/

@nNo int,
@nCharNo int,
@nFlags int,

@nRet tinyint output

AS

SET NOCOUNT ON
SET @nRet = 0

UPDATE tGuildMember SET nFlags = @nFlags WHERE nNo = @nNo AND nCharNo = @nCharNo
SET @nRet = @@ROWCOUNT

IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
BEGIN
	SET @nRet = 0
	RETURN
END

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_Member_SetGrade]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_Member_SetGrade]
GO

/*
Set Guild Member Grade
2006.2 By CJC
Input:
	See SQL
2010.8.27. by kodong
	캐릭터명 변경 서비스를 통해 인간관계 초기화 아이템을 사용한 캐릭터에게는
	길드마스터 변경이 불가능하게 함.
	
	주의 : 반드시 캐릭터명 변경 서비스(인간관계 초기화) 시스템 이후 변경되어야 함.
Output:
	nRet = 0,  Error
	nRet = 1,  OK
*/
CREATE PROCEDURE [dbo].[p_Guild_Member_SetGrade]
	@nNo int,
	@nCharNo int,
	@nGrade tinyint,
	@nRet tinyint = 0 output
AS
BEGIN
	SET NOCOUNT ON

	DECLARE @cnt INT

	SET @nRet = 0

	-- 캐릭터명 변경 서비스(인간관계 초기화) 아이템 추가로 인한 수정 by kodong
	SELECT @cnt = ISNULL(COUNT(nCharNo), 0) 
	  FROM tCharacterChangeID 
	 WHERE nCharNo = @nCharNo 
	   AND bFlag = 0 -- 반영 안된 기록이 있는 경우
	   AND bInit = 1 -- 인간관계 초기화를 설정한 경우
	IF @nGrade = 0 AND @cnt = 1 BEGIN
		SET @nRet = 0
		RETURN
	END
	ELSE BEGIN
		UPDATE tGuildMember SET nGrade = @nGrade WHERE nNo = @nNo AND nCharNo = @nCharNo
		SET @nRet = @@ROWCOUNT
		IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
		BEGIN
			SET @nRet = 0
			RETURN
		END
	END
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_Member_SetIntro]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_Member_SetIntro]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_Member_SetIntro    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/



CREATE PROCEDURE [dbo].[p_Guild_Member_SetIntro]

/*
Set Guild Member Intro
2006.2 By CJC

Input:
	See SQL
	
Output:
	nRet = 0,  Error
	nRet = 1,  OK
*/

@nNo int,
@nCharNo int,
@sIntro nvarchar(64),

@nRet tinyint output

AS

SET NOCOUNT ON
SET @nRet = 0

UPDATE tGuildMember SET sIntro = @sIntro WHERE nNo = @nNo AND nCharNo = @nCharNo
SET @nRet = @@ROWCOUNT

IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
BEGIN
	SET @nRet = 0
	RETURN
END

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_MoneyAdd]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_MoneyAdd]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_MoneyAdd    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/



CREATE PROCEDURE [dbo].[p_Guild_MoneyAdd]

/*
Add Guild Money
2006.2 By CJC

Input:
	See SQL
	
Output:
	nRet = 0,  Error(Not found guild/member, not enough member's money)
	nRet = 1,  OK
*/

@nNo int,
@nMemberCharNo int,
@nMoneyAdd bigint,

@nMemberMoney bigint output,
@nTotalMoney bigint output,
@nRet tinyint output

AS

SET NOCOUNT ON

SET @nRet = 0

-- 길원의 금액을 얻는다
EXEC p_Char_MoneyGet @nMemberCharNo, @nMemberMoney OUTPUT, @nRet OUTPUT
IF @nRet <> 1 
	RETURN

-- 길원의 보유 금액이 요청한 금액보다 적으면 실패처리 한다.
IF @nMoneyAdd > @nMemberMoney
	RETURN


-- 길드 금액처리
BEGIN TRAN

-- 1. 길원 금액 빼기
EXEC p_Char_MoneySub @nMemberCharNo, @nMoneyAdd, @nRet OUTPUT
IF @nRet <> 1
BEGIN
	ROLLBACK TRAN
	SET @nRet = 0
	RETURN
END

-- 2. 길원의 남은 금액 얻기
EXEC p_Char_MoneyGet @nMemberCharNo, @nMemberMoney OUTPUT, @nRet OUTPUT
IF @nRet <> 1
BEGIN
	ROLLBACK TRAN
	SET @nRet = 0
	RETURN
END

-- 3. 길드 금액 증가
UPDATE tGuild SET nMoney = nMoney + @nMoneyAdd WHERE nNo = @nNo
SET @nRet = @@ROWCOUNT

IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
BEGIN
	ROLLBACK TRAN
	SET @nRet = 0
	RETURN
END

-- 4. 길드 최종급액 얻기
SELECT @nTotalMoney = nMoney FROM tGuild WHERE nNo = @nNo
IF @@ROWCOUNT <> 1
BEGIN
	ROLLBACK TRAN
	SET @nRet = 0
	RETURN
END

-- 완료
SET @nRet = 1
COMMIT TRAN

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_MoneySub]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_MoneySub]
GO
CREATE PROCEDURE [dbo].[p_Guild_MoneySub]

/*
Sub Guild Money
2007.11 By Lunar

Input:
	See SQL
	
Output:
	nRet =   0, OK

		1, Fail get Guild Money
		2, Guild Money Sub Failed(Not enough money)
		3, Guild Money Update Failed
		4, Member Money Update Failed
		5, Fail get Member Money
		6, Fail get Final Guild Money
*/

@nNo int,
@nMemberCharNo int,
@nMoneySub bigint,

@nMemberMoney bigint output,
@nTotalMoney bigint output,
@nRet tinyint output

AS

SET NOCOUNT ON

SET @nRet = 0
SET @nMemberMoney = 0
SET @nTotalMoney = 0

-- 길드의 금액을 얻는다
SELECT @nTotalMoney = nMoney FROM tGuild WHERE nNo = @nNo
IF @@ERROR <> 0
BEGIN
	SET @nRet = 1
	RETURN
END

-- 길드의 보유 금액이 요청한 금액보다 적으면 실패처리 한다.
IF @nMoneySub > @nTotalMoney
BEGIN
	SET @nRet = 2
	RETURN
END

-- 길드 금액처리
BEGIN TRAN

-- 1. 길드 금액 빼기
UPDATE tGuild SET nMoney = nMoney - @nMoneySub WHERE nNo = @nNo
SET @nRet = @@ROWCOUNT

IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
BEGIN
	ROLLBACK TRAN
	SET @nRet = 3
	RETURN
END

-- 2. 길원 금액 증가
EXEC p_Char_MoneyAdd @nMemberCharNo, @nMoneySub, @nRet OUTPUT
IF @nRet <> 1
BEGIN
	ROLLBACK TRAN
	SET @nRet = 4
	RETURN
END

-- 3. 길원 금액 얻기
EXEC p_Char_MoneyGet @nMemberCharNo, @nMemberMoney OUTPUT, @nRet OUTPUT
IF @nRet <> 1
BEGIN
	ROLLBACK TRAN
	SET @nRet = 5
	RETURN
END

-- 4. 길드 최종급액 얻기
SELECT @nTotalMoney = nMoney FROM tGuild WHERE nNo = @nNo
IF @@ROWCOUNT <> 1
BEGIN
	ROLLBACK TRAN
	SET @nRet = 6
	RETURN
END

-- 완료
SET @nRet = 0
COMMIT TRAN

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_Set]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_Set]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_Set    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/



CREATE PROCEDURE [dbo].[p_Guild_Set]

/*
Update Guild Data
2006.3 By blacksky
*/

@nNo				int,

@sName				nvarchar(18),
@sPassword			nvarchar(9),
@nMaxMembers		smallint,
@nMoney				bigint,
@nType				tinyint,
@nGrade				tinyint,	
@nFame				int,
@nStoneLevel		smallint,
@nExp				bigint,
@dCreateDate		datetime,

@dWarRequestDate	datetime,
@dWarStartDate		datetime,
@dWarEndDate		datetime,
@nWarEnemy			int,
@nWarWinCount		int,
@nWarLoseCount		int,
@nWarDrawCount		int,

@nDismissStatus		tinyint,
@dDismissDate		datetime,

@dNotifyDate		datetime,
@sNotifyCharID		nvarchar(16),
@sNotify			nvarchar(512),

@sIntro				nvarchar(128),

@nRet				tinyint output

AS

SET NOCOUNT ON
SET @nRet = 0

UPDATE
	tGuild

SET
	sName			= @sName,
	sPassword		= @sPassword,
	nMaxMembers		= @nMaxMembers,
	nMoney			= @nMoney,
	nType			= @nType,
	nGrade			= @nGrade,
	nFame			= @nFame,
	nStoneLevel		= @nStoneLevel,
	nExp			= @nExp,
	dCreateDate		= @dCreateDate,

	dWarRequestDate	= @dWarRequestDate,
	dWarStartDate	= @dWarStartDate,
	dWarEndDate		= @dWarEndDate,
	nWarEnemy		= @nWarEnemy,
	nWarWinCount	= @nWarWinCount,
	nWarLoseCount	= @nWarLoseCount,
	nWarDrawCount	= @nWarDrawCount,
	
	nDismissStatus	= @nDismissStatus,
	dDismissDate	= @dDismissDate,

	dNotifyDate		= @dNotifyDate,
	sNotifyCharID	= @sNotifyCharID,
	sNotify			= @sNotify,
	
	sIntro			= @sIntro
	
WHERE
	@nNo = nNo

SET @nRet = @@ROWCOUNT

IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
BEGIN
	SET @nRet = 0
	RETURN
END
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_SetDismiss]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_SetDismiss]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_SetDismiss    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/


CREATE PROCEDURE [dbo].[p_Guild_SetDismiss]

/*
Set Guild Type
2006.2 By CJC

Input:
	See SQL
	
Output:
	nRet = 0,  Error(Not found guild)
	nRet = 1,  OK
*/

@nNo int,
@nDismissStatus tinyint,
@dDismissDate datetime,

@nRet tinyint output

AS

SET NOCOUNT ON
SET @nRet = 0

UPDATE tGuild SET nDismissStatus = @nDismissStatus, dDismissDate = @dDismissDate WHERE nNo = @nNo
SET @nRet = @@ROWCOUNT

IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
BEGIN
	SET @nRet = 0
	RETURN
END

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_SetExp]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_SetExp]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_SetExp    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/



CREATE PROCEDURE [dbo].[p_Guild_SetExp]

/*
Set Guild Exp
2006.2 By CJC

Input:
	See SQL
	
Output:
	nRet = 0,  Error(Not found guild)
	nRet = 1,  OK
*/

@nNo int,
@nExp bigint,

@nRet tinyint output

AS

SET NOCOUNT ON
SET @nRet = 0

UPDATE tGuild SET nExp = @nExp WHERE nNo = @nNo
SET @nRet = @@ROWCOUNT

IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
BEGIN
	SET @nRet = 0
	RETURN
END

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_SetFame]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_SetFame]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_SetFame    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/



CREATE PROCEDURE [dbo].[p_Guild_SetFame]

/*
Set Guild Fame
2006.2 By CJC

Input:
	See SQL
	
Output:
	nRet = 0,  Error(Not found guild)
	nRet = 1,  OK
*/

@nNo int,
@nFame int,

@nRet tinyint output

AS

SET NOCOUNT ON
SET @nRet = 0

UPDATE tGuild SET nFame = @nFame WHERE nNo = @nNo
SET @nRet = @@ROWCOUNT

IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
BEGIN
	SET @nRet = 0
	RETURN
END

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_SetGrade]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_SetGrade]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_SetGrade    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/



CREATE PROCEDURE [dbo].[p_Guild_SetGrade]

/*
Set Guild Grade
2006.2 By CJC

Input:
	See SQL
	
Output:
	nRet = 0,  Error(Not found guild)
	nRet = 1,  OK
*/

@nNo int,
@nGrade tinyint,

@nRet tinyint output

AS

SET NOCOUNT ON
SET @nRet = 0

UPDATE tGuild SET nGrade = @nGrade WHERE nNo = @nNo
SET @nRet = @@ROWCOUNT

IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
BEGIN
	SET @nRet = 0
	RETURN
END

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_SetIntro]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_SetIntro]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_SetIntro    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/



CREATE PROCEDURE [dbo].[p_Guild_SetIntro]

/*
Set Guild Intro
2006.2 By CJC

Input:
	See SQL
	
Output:
	nRet = 0,  Error(Not found guild)
	nRet = 1,  OK
*/

@nNo int,
@sIntro nvarchar(128),

@nRet tinyint output

AS

SET NOCOUNT ON
SET @nRet = 0

UPDATE tGuild SET sIntro = @sIntro WHERE nNo = @nNo
SET @nRet = @@ROWCOUNT

IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
BEGIN
	SET @nRet = 0
	RETURN
END

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_setName]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_setName]
GO

/*--------------------------------------------------------------------------------------
' 이  름 : p_Guild_setName
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2008.9.24.
' Description :
'   길드명을 변경한다.
'	2008.9월 유료아이템 기획중 길드명을 변경하는 아이템이 추가됨에 따라 저장프로시저를
'	추가하게 되었음
' Parameter :
'	input Parameter
'		@nNo 	        : 길드번호
'		@sName          : 길드명
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1311 : 길드번호가 입력되지 않았습니다.
'				-1312 : 길드명이 입력되지 않았습니다.
'				-1321 : 입력받은 길드번호의 길드가 존재하지 않습니다.
'				-1322 : 입력받은 길드명이 중복되는 길드명입니다.
'				-1393 : db error(update)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[p_Guild_setName]
	@nNo   int
,	@sName nvarchar(18)
,	@nRet  int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	IF @nNo <= 0 BEGIN
		SET @nRet = -1311
		RETURN
	END

	IF LEN(ISNULL(@sName, '')) = 0 BEGIN
		SET @nRet = -1312
		RETURN
	END

	IF EXISTS(SELECT nNo FROM tGuild WHERE nNo = @nNo) BEGIN
		IF EXISTS(SELECT sName FROM tGuild WHERE sName = @sName) BEGIN
			SET @nRet = -1322
		END
		ELSE BEGIN

			BEGIN TRAN

			UPDATE tGuild SET sName = @sName WHERE nNo = @nNo
			IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
				ROLLBACK TRAN
				SET @nRet = -1393
			END
			ELSE BEGIN
				COMMIT TRAN
				SET @nRet = 0
			END
		END
	END
	ELSE BEGIN
		SET @nRet = -1321
	END

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_SetNotify]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_SetNotify]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_SetNotify    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/


CREATE PROCEDURE [dbo].[p_Guild_SetNotify]

/*
Set Guild Notify
2006.2 By CJC

Input:
	See SQL
	
Output:
	nRet = 0,  Error(Not found guild)
	nRet = 1,  OK
*/

@nNo int,
@sNotifyCharID nvarchar(16),
@sNotify nvarchar(512),

@nRet tinyint output

AS

SET NOCOUNT ON
SET @nRet = 0

UPDATE tGuild SET dNotifyDate = getdate(), sNotifyCharID = @sNotifyCharID, sNotify = @sNotify WHERE nNo = @nNo
SET @nRet = @@ROWCOUNT

IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
BEGIN
	SET @nRet = 0
	RETURN
END

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_SetStoneLevel]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_SetStoneLevel]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_SetStoneLevel    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/



CREATE PROCEDURE [dbo].[p_Guild_SetStoneLevel]

/*
Set Guild StoneLevel
2006.2 By CJC

Input:
	See SQL
	
Output:
	nRet = 0,  Error(Not found guild)
	nRet = 1,  OK
*/

@nNo int,
@nStoneLevel smallint,

@nRet tinyint output

AS

SET NOCOUNT ON
SET @nRet = 0

UPDATE tGuild SET nStoneLevel = @nStoneLevel WHERE nNo = @nNo
SET @nRet = @@ROWCOUNT

IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
BEGIN
	SET @nRet = 0
	RETURN
END

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_SetType]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_SetType]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_SetType    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/



CREATE PROCEDURE [dbo].[p_Guild_SetType]

/*
Set Guild Type
2006.2 By CJC

Input:
	See SQL
	
Output:
	nRet = 0,  Error(Not found guild)
	nRet = 1,  OK
*/

@nNo int,
@nType tinyint,

@nRet tinyint output

AS

SET NOCOUNT ON
SET @nRet = 0

UPDATE tGuild SET nType = @nType WHERE nNo = @nNo
SET @nRet = @@ROWCOUNT

IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
BEGIN
	SET @nRet = 0
	RETURN
END

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_SetWar]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_SetWar]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_SetWar    스크립트 날짜: 2007-03-13 오후 6:25:11 ******/



CREATE PROCEDURE [dbo].[p_Guild_SetWar]

/*
Set Guild War
2006.2 By CJC

Input:
	See SQL
	
Output:
	nRet = 0,  Error(Not found guild)
	nRet = 1,  OK
*/

@nNo int,
@dWarRequestDate datetime,
@dWarStartDate datetime,
@dWarEndDate datetime,
@nWarEnemy int,

@nRet tinyint output

AS

SET NOCOUNT ON
SET @nRet = 0

UPDATE tGuild SET 
	dWarRequestDate = @dWarRequestDate,
	dWarStartDate = @dWarStartDate,
	dWarEndDate = @dWarEndDate,
	nWarEnemy = @nWarEnemy
WHERE nNo = @nNo
SET @nRet = @@ROWCOUNT

IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
BEGIN
	SET @nRet = 0
	RETURN
END

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Guild_SetWarResult]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Guild_SetWarResult]
GO
/****** 개체: 저장 프로시저 dbo.p_Guild_SetWarResult    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/



CREATE PROCEDURE [dbo].[p_Guild_SetWarResult]

/*
Set Guild War Result
2006.2 By CJC

Input:
	See SQL
	
Output:
	nRet = 0,  Error(Not found guild)
	nRet = 1,  OK
*/

@nNo int,
@nWarWinCount int,
@nWarLoseCount int,
@nWarDrawCount int,

@nRet tinyint output

AS

SET NOCOUNT ON
SET @nRet = 0

UPDATE tGuild SET 
	nWarWinCount = @nWarWinCount,
	nWarLoseCount = @nWarLoseCount,
	nWarDrawCount = @nWarDrawCount
WHERE nNo = @nNo
SET @nRet = @@ROWCOUNT

IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
BEGIN
	SET @nRet = 0
	RETURN
END

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GuildTournament_Get]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GuildTournament_Get]
GO


CREATE PROCEDURE [dbo].[p_GuildTournament_Get]
/*
Get Tournament Guild Data
2007.5 By CJC
*/
@nGTNo int
AS
SET NOCOUNT ON
SELECT nType, nData FROM tGuildTournament WHERE @nGTNo = nGTNo
-- end



GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GuildTournament_GetAllTournamentList]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GuildTournament_GetAllTournamentList]
GO


CREATE PROCEDURE [dbo].[p_GuildTournament_GetAllTournamentList]
AS
BEGIN
	SELECT nGTNo
	FROM   tGuildTournament
	GROUP BY nGTNo
END



GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GuildTournament_GetLastMatch]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GuildTournament_GetLastMatch]
GO


CREATE PROCEDURE [dbo].[p_GuildTournament_GetLastMatch]
AS
BEGIN
	SELECT   nGTNo, nType, nData
	FROM      tGuildTournament
	WHERE   (nGTNo IN
                    (SELECT   MAX(nGTNo)
                     FROM      tGuildTournament))
             ORDER BY nType
END



GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GuildTournament_Set]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GuildTournament_Set]
GO


CREATE PROCEDURE [dbo].[p_GuildTournament_Set]
/*
Set/Update Guild Tournament Data
2007.5 By CJC
*/
@nGTNo				int,
@nType				smallint,
@nData				int,
@nRet				int OUTPUT
AS
SET NOCOUNT ON
UPDATE tGuildTournament SET	nData = @nData WHERE nGTNo = @nGTNo AND nType = @nType
IF @@ERROR <> 0 OR @@ROWCOUNT = 0
BEGIN
	INSERT tGuildTournament (  nGTNo,  nType,  nData )
	VALUES					( @nGTNo, @nType, @nData )
END
SET @nRet = @@ERROR
-- end



GO

-- ----------------------------
-- Procedure structure for [dbo].[p_HolyPromise_CheckRing]
-- ----------------------------
DROP PROCEDURE [dbo].[p_HolyPromise_CheckRing]
GO

CREATE PROCEDURE [dbo].[p_HolyPromise_CheckRing]
/*
Holy promise check ring
2008.4 By CJC

 input:
	see SQL
	
 output:
	@nRet
	0 = No ring 
	1 = Yes ring
	-1 = DB error
*/
@nCharNo int,		-- 현재 캐릭
@nUpCharNo int,	-- 상위로 등록될 캐릭
@nRet int OUTPUT	-- 아미 상위로 등록되어 링구조가 되는지 결과확인값 리턴

AS

BEGIN
	SET NOCOUNT ON

	-- check are same char.
	IF @nCharNo = @nUpCharNo
	BEGIN
		SET @nRet = 1
		RETURN
	END

	DECLARE @nTempCharNo int
	DECLARE @nTempUpCharNo int

	SET @nTempCharNo = @nCharNo

	LOOP_UP:
	SET @nTempUpCharNo = 0
	SELECT @nTempUpCharNo = P.nUpCharNo FROM tHolyPromise AS P 
	INNER JOIN tCharacter AS C ON C.nCharNo =  P.nCharNo AND C.bDeleted = 0
	WHERE P.nCharNo = @nTempCharNo

	IF @nTempUpCharNo > 0
	BEGIN
		-- 링구조가 형성되는지 검사
		IF @nUpCharNo = @nTempUpCharNo
		BEGIN
			SET @nRet = 1
			RETURN
		END

		-- 다음 상위로 이동
		SET @nTempCharNo = @nTempUpCharNo
		GOTO LOOP_UP
	END

	-- 링구조 없음.
	SET @nRet = 0
	RETURN

END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_HolyPromise_Del]
-- ----------------------------
DROP PROCEDURE [dbo].[p_HolyPromise_Del]
GO

CREATE PROCEDURE [dbo].[p_HolyPromise_Del]
/*
Delete holy promise
2008.4 By CJC

 input:
	see SQL
	
 output:
	@nRet
	0 = OK, 
	? = Other DB error code
	        
*/
@nCharNo int,
@nRet int OUTPUT

AS

BEGIN
	SET NOCOUNT ON

	-- Update/Inset data
	IF EXISTS( SELECT nCharNo FROM  tHolyPromise WHERE nCharNo=@nCharNo)
	BEGIN
		UPDATE tHolyPromise SET nUpCharNo=0, nFlags=0, dRegDate=GetDate() WHERE nCharNo=@nCharNo
		SET @nRet = @@ERROR
	END
	ELSE
		SET @nRet = 0

	RETURN
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_HolyPromise_DelChar]
-- ----------------------------
DROP PROCEDURE [dbo].[p_HolyPromise_DelChar]
GO

CREATE PROCEDURE [dbo].[p_HolyPromise_DelChar]
/*
Delete char holy promise
2008.4 By CJC

 input:
	see SQL
	
 output:
	@nRet
	0 = OK, 
	? = Other DB error code
	        
*/
@nDelCharNo int,
@nRet int OUTPUT

AS

BEGIN
	SET NOCOUNT ON

	DELETE FROM tHolyPromise WHERE nUpCharNo = @nDelCharNo
	SET @nRet = @@ERROR

	RETURN
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_HolyPromise_Get]
-- ----------------------------
DROP PROCEDURE [dbo].[p_HolyPromise_Get]
GO

CREATE PROCEDURE [dbo].[p_HolyPromise_Get]
/*
Get holy primise
2008.3 By CJC
 input:
	see SQL
 output:
	nRet > 0 fetch to take data
	= 0 No data
*/

@nCharNo int,
@nRet int OUTPUT

AS
BEGIN
	SET NOCOUNT ON
	SELECT @nRet=COUNT(nUpCharNo) FROM tHolyPromise WHERE nCharNo = @nCharNo
	IF @nRet > 0
	BEGIN
		IF EXISTS(
			SELECT P.nUpCharNo, P.nFlags, P.dRegDate, P.dRejoinableDate, P.dMemberAcceptableDate, C.sID, C.nLevel,C.dLastLoginDate FROM tHolyPromise AS P
			INNER JOIN tCharacter AS C ON C.nCharNo =  P.nUpCharNo AND C.bDeleted = 0
			WHERE P.nCharNo = @nCharNo)

			SELECT P.nUpCharNo, P.nFlags, P.dRegDate, P.dRejoinableDate, P.dMemberAcceptableDate, C.sID, C.nLevel,C.dLastLoginDate FROM tHolyPromise AS P
			INNER JOIN tCharacter AS C ON C.nCharNo =  P.nUpCharNo AND C.bDeleted = 0
			WHERE P.nCharNo = @nCharNo

		ELSE
			SELECT P.nUpCharNo, P.nFlags, P.dRegDate, P.dRejoinableDate, P.dMemberAcceptableDate, '', 1, GetDate() FROM tHolyPromise AS P WHERE P.nCharNo = @nCharNo

	END
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_HolyPromise_GetMember]
-- ----------------------------
DROP PROCEDURE [dbo].[p_HolyPromise_GetMember]
GO

CREATE PROCEDURE [dbo].[p_HolyPromise_GetMember]
/*
Get primise member count
2008.3 By CJC
 input:
	see SQL
 output:
	fetch to take data
*/

@nCharNo int,
@nNumOfMember int OUTPUT

AS
BEGIN
	SET NOCOUNT ON

	SELECT @nNumOfMember=COUNT( P.nCharNo) FROM tHolyPromise AS P
	INNER JOIN tCharacter AS C ON C.nCharNo =  P.nCharNo AND C.bDeleted = 0
	WHERE P.nUpCharNo = @nCharNo

	IF @nNumOfMember > 0 
	BEGIN
		SELECT P.nCharNo, P.nFlags, P.dRegDate, P.dRejoinableDate, P.dMemberAcceptableDate, C.sID, C.nLevel,C.dLastLoginDate FROM tHolyPromise AS P
		INNER JOIN tCharacter AS C ON C.nCharNo =  P.nCharNo AND C.bDeleted = 0
		WHERE P.nUpCharNo = @nCharNo
	END
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_HolyPromise_GetMemberCount]
-- ----------------------------
DROP PROCEDURE [dbo].[p_HolyPromise_GetMemberCount]
GO

CREATE PROCEDURE [dbo].[p_HolyPromise_GetMemberCount]
/*
Get primise member count
2008.3 By CJC
 input:
	see SQL
 output:
	fetch to take data
*/

@nCharNo int,
@nNumOfMember int OUTPUT

AS
BEGIN
	SET NOCOUNT ON
	SET @nNumOfMember = 0
	SELECT @nNumOfMember = COUNT(P.nUpCharNo) FROM tHolyPromise AS P 
	INNER JOIN tCharacter AS C ON C.nCharNo =  P.nCharNo AND C.bDeleted = 0
	WHERE P.nUpCharNo = @nCharNo
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_HolyPromise_Set]
-- ----------------------------
DROP PROCEDURE [dbo].[p_HolyPromise_Set]
GO

CREATE PROCEDURE [dbo].[p_HolyPromise_Set]
/*
Holy promise set
2008.4 By CJC

 input:
	see SQL
	
 output:
	@nRet
	0 = OK,  Fiest join
	1 = Ring / same char
	2 = i'm over max member count
	3 = OK, ReJoin
	4 = Failed, Already upper exists
	? = Other DB error code
*/
@nMAXPROMISEMEMBER smallint,
@nCharNo int,
@nUpCharNo int,
@nFlags tinyint,
@nRet int OUTPUT

AS

BEGIN
	SET NOCOUNT ON
	
	-- check ring, same char.
	EXEC p_HolyPromise_CheckRing @nCharNo, @nUpCharNo, @nRet OUTPUT
	IF @nRet = 1
		RETURN
	
	-- check over max promise and add
	BEGIN TRAN

	DECLARE @nPromiseCount int
	EXEC p_HolyPromise_GetMemberCount @nUpCharNo, @nPromiseCount OUTPUT
	IF @nPromiseCount >= @nMAXPROMISEMEMBER
	BEGIN
		SET @nRet = 2
		ROLLBACK TRAN
		RETURN
	END

	-- Update/Inset data
	IF EXISTS( SELECT nCharNo FROM  tHolyPromise WHERE nCharNo=@nCharNo)
	BEGIN
		-- Check already upper here
		DECLARE @TempUpCharNo int
		SELECT @TempUpCharNo=nUpCharNo FROM  tHolyPromise WHERE nCharNo=@nCharNo
		IF @TempUpCharNo <> 0
		BEGIN
			SET @nRet = 4
			ROLLBACK TRAN
			RETURN
		END

		UPDATE tHolyPromise SET nUpCharNo=@nUpCharNo, nFlags=@nFlags, dRegDate=GetDate() WHERE nCharNo=@nCharNo
		SET @nRet = @@ERROR
		IF @nRet <> 0
		BEGIN
			ROLLBACK TRAN
			RETURN
		END
		SET @nRet = 3 -- OK. Rejoin		
	END

	ELSE

	BEGIN
		INSERT tHolyPromise (  nCharNo,  nUpCharNo,  nFlags )
		VALUES ( @nCharNo, @nUpCharNo, @nFlags )
		SET @nRet = @@ERROR
		IF @nRet <> 0
		BEGIN
			ROLLBACK TRAN
			RETURN
		END
	END
	
	COMMIT TRAN
	RETURN
	-- end
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_HolyPromise_SetDate]
-- ----------------------------
DROP PROCEDURE [dbo].[p_HolyPromise_SetDate]
GO

CREATE PROCEDURE [dbo].[p_HolyPromise_SetDate]
/*
Holy promise set date
2008.4 By CJC

 input:
	see SQL
	
 output:
	@nRet
	0 = OK, 
	? = Other DB error code
*/
@nCharNo int,
@dRejoinableDate datetime,
@dMemberAcceptableDate datetime,
@nRet int OUTPUT

AS

BEGIN
	SET NOCOUNT ON

	-- Update data
	IF EXISTS( SELECT nCharNo FROM  tHolyPromise WHERE nCharNo=@nCharNo)
	BEGIN
		UPDATE tHolyPromise SET dRejoinableDate=@dRejoinableDate, dMemberAcceptableDate=@dMemberAcceptableDate WHERE nCharNo=@nCharNo
		SET @nRet = @@ERROR
	END
	ELSE	
	BEGIN
		INSERT tHolyPromise (  nCharNo,  nUpCharNo,  nFlags, dRejoinableDate, dMemberAcceptableDate )
		VALUES ( @nCharNo, 0, 0, @dRejoinableDate, @dMemberAcceptableDate )
		SET @nRet = @@ERROR
	END
	
	RETURN
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_BuyAll]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_BuyAll]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_BuyAll    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/
CREATE PROCEDURE [dbo].[p_Item_BuyAll]
/*
Item buy all
2004.8 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Not found item owner or Need more owner's money/fame
	        ? = Error code
	        
 operation:
	1. money/fame check and sub
	2. make buy item
	
*/
@nItemKey bigint,
@nOwner int,
@nStorageType tinyint,
@nStorage smallint,
@nItemID int,
@nFlags int,
@nPrice bigint,
@nFame int,
@nRet int OUTPUT
AS
SET NOCOUNT ON
DECLARE @CreateItemRet int
BEGIN TRAN
-- 아이템 소유자가 충분한 돈을 가지고 있는지 확인 후 돈 감소
EXEC p_Char_MoneySub @nOwner, @nPrice, @nRet OUTPUT
IF @nRet <> 1
BEGIN
	ROLLBACK TRAN
	SET @nRet = 1
	RETURN
END
-- 아이템 소유자가 충분한 명성을 가지고 있는지 확인 후 명성 감소
EXEC p_Char_FameSub @nOwner, @nFame, @nRet OUTPUT
IF @nRet <> 1
BEGIN
	ROLLBACK TRAN
	SET @nRet = 1
	RETURN
END
-- 아이템 생성 저장프로시져 호출
EXEC p_Item_Create @nItemKey, @nOwner, @nStorageType, @nStorage, @nItemID, @nFlags, @CreateItemRet OUTPUT
IF @CreateItemRet <> 0 OR @@ERROR <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = @CreateItemRet
	RETURN
END
-- 완료
COMMIT TRAN
SET @nRet = 0
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_BuyLot]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_BuyLot]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_BuyLot    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/
CREATE PROCEDURE [dbo].[p_Item_BuyLot]
/*
Item buy - change lot and money/fame
2004.8 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Not found item owner or Need more owner's money
	        ? = Error code
	        
 operation:
	1. money/fame check and sub
	2. make buy item
	
*/
@nItemKey bigint,
@nOwner int,
@nOptionType smallint,
@nOptionData bigint,
@nPrice bigint,
@nFame int,
@nRet int OUTPUT
AS
SET NOCOUNT ON
BEGIN TRAN
-- 아이템 소유자가 충분한 돈을 가지고 있는지 확인 후 돈 감소
EXEC p_Char_MoneySub @nOwner, @nPrice, @nRet OUTPUT
IF @nRet <> 1
BEGIN
	ROLLBACK TRAN
	SET @nRet = 1
	RETURN
END
-- 아이템 소유자가 충분한 명성을 가지고 있는지 확인 후 명성 감소
EXEC p_Char_FameSub @nOwner, @nFame, @nRet OUTPUT
IF @nRet <> 1
BEGIN
	ROLLBACK TRAN
	SET @nRet = 1
	RETURN
END
-- 아이템 옵션 저장프로시져 호출(랏 수정)
EXEC p_Item_SetOption @nItemKey, @nOptionType, @nOptionData, @nRet OUTPUT
IF @nRet <> 0
BEGIN
	ROLLBACK TRAN
	RETURN
END
-- 완료
COMMIT TRAN
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_ClrWeaponTitle]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_ClrWeaponTitle]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_ClrWeaponTitle    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/
CREATE PROCEDURE [dbo].[p_Item_ClrWeaponTitle]
/*

Item Clear Weapon Title
2006.6 By CJC

 input:
	see SQL

 output:
	@nRet	0 = OK, 
	        1 = Error Not found Weapon mob 
	        2 = Error Clear Weapon mob 
	        3 = Error Delete license item
	        4 = Error Change license item lot
*/

@nWeaponItemKey bigint,

@nMobID smallint,
@nLicenseClearItemKey bigint,
@bLicenseClearItemDelete tinyint,
@nLicenseClearItemOptionType smallint,
@nLicenseClearItemOptionData bigint,

-- Output var
@nRet int OUTPUT

AS

SET NOCOUNT ON

-- 아이템에 몹 라이센스 붙어 있는지 확인 
IF NOT EXISTS(SELECT nMobID FROM tItemMobList WHERE nItemKey=@nWeaponItemKey AND nMobID=@nMobID)
BEGIN
	SET @nRet = 1
	RETURN
END

-- 아이템에 몹 라이센스 지우기
BEGIN TRAN
DELETE FROM tItemMobList WHERE nItemKey=@nWeaponItemKey AND nMobID=@nMobID
IF @@ERROR <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = 2
	RETURN
END

-- 라이센스 지우는 아이템 지우기/랏조정
DECLARE @nRetTemp int
IF @bLicenseClearItemDelete = 1
BEGIN
	EXEC p_Item_Delete @nLicenseClearItemKey, @nRetTemp OUTPUT
	IF @nRetTemp <> 0
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 3
		RETURN
	END
END
ELSE
BEGIN
	EXEC p_Item_SetOption @nLicenseClearItemKey, @nLicenseClearItemOptionType, @nLicenseClearItemOptionData, @nRetTemp OUTPUT
	IF @nRetTemp <> 0
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 4
		RETURN
	END
END

-- 성공
COMMIT TRAN
SET @nRet = 0

RETURN

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_CostumWeapon_Endure_Set]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_CostumWeapon_Endure_Set]
GO

CREATE PROCEDURE [dbo].[p_Item_CostumWeapon_Endure_Set]
/*
Item Costum Weapon Endure Set
2008.10 By Lunar
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Not found item
	        2 = Missmatch item owner
	        3 = Not enough money to sub
	        4 = Upgrade value setting, upgrade fail count error(option set error)
	        5 = Raw delete fail
	        6 = RawLeft delete fail, if valid item
	        7 = RawRight delete fail, if valid item
	        8 = RawMiddle delete fail, if valid item
	        
 operation:
	1. money sub
	2. upgrade item level
	3. delete raws
*/
@nCostumWeaponKey bigint,
@nCostumWeaponEndureOptionType smallint,
@nCostumWeaponEndureOptionData bigint,
@nRet int OUTPUT
AS
BEGIN
	SET NOCOUNT ON
	
	DECLARE @nTinyintRet tinyint
	DECLARE @nRetTemp int

	BEGIN TRAN

	-- 1 가구 아이템 내구도 상승
	SET @nRetTemp = 1
	EXEC p_Item_SetOption @nCostumWeaponKey, @nCostumWeaponEndureOptionType, @nCostumWeaponEndureOptionData, @nRetTemp OUTPUT
	IF @nRetTemp <> 0 BEGIN
		ROLLBACK TRAN
		SET @nRet = 5
		RETURN
	END
	
	-- 업글 성공
	COMMIT TRAN
	SET @nRet = 0

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_CostumWeapon_Endure_Update]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_CostumWeapon_Endure_Update]
GO

CREATE PROCEDURE [dbo].[p_Item_CostumWeapon_Endure_Update]
/*
Item Costum Weapon Endure Update
2008.10 By Lunar
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Not found item
	        2 = Missmatch item owner
	        3 = Not enough money to sub
	        4 = Upgrade value setting, upgrade fail count error(option set error)
	        5 = Raw delete fail
	        6 = RawLeft delete fail, if valid item
	        7 = RawRight delete fail, if valid item
	        8 = RawMiddle delete fail, if valid item
	        
 operation:
	1. money sub
	2. upgrade item level
	3. delete raws
*/
@nOwner int,
@nEndureKitKey bigint,
@nEndureKitOptionType smallint,
@nEndureKitLot smallint,
@nCostumWeaponKey bigint,
@nCostumWeaponEndureOptionType smallint,
@nCostumWeaponEndureOptionData bigint,
@nRet int OUTPUT
AS
BEGIN
	SET NOCOUNT ON
	
	DECLARE @nTinyintRet tinyint
	DECLARE @nRetTemp int

	-- 1.1 내구도 키트 아이템 소유자 확인
	EXEC p_Item_IsValidOwner @nEndureKitKey, @nOwner, @nTinyintRet OUTPUT
	IF @nTinyintRet <> 0 BEGIN
		SET @nRet = @nTinyintRet
		RETURN
	END
	
	-- 1.2 무기 코스튬 아이템 소유자 확인
	EXEC p_Item_IsValidOwner @nCostumWeaponKey, @nOwner, @nTinyintRet OUTPUT
	IF @nTinyintRet <> 0 BEGIN
		SET @nRet = @nTinyintRet
		RETURN
	END

	BEGIN TRAN
	
	-- 2.1 사용된 내구도 키트 아이템 지우기 (사용후 Lot == 0 인 경우)
	IF @nEndureKitLot = 0 BEGIN
		SET @nRetTemp = 1
		EXEC p_Item_Delete @nEndureKitKey, @nRetTemp OUTPUT
		IF @nRetTemp <> 0 BEGIN
			ROLLBACK TRAN
			SET @nRet = 5
			RETURN
		END
	END
	-- 2.2 사용된 내구도 키트 아이템 차감하기 (사용후 Lot > 0 인 경우)
	ELSE BEGIN
		SET @nRetTemp = 1
		EXEC p_Item_SetOption @nEndureKitKey, @nEndureKitOptionType, @nEndureKitLot, @nRetTemp OUTPUT
		IF @nRetTemp <> 0 BEGIN
			ROLLBACK TRAN
			SET @nRet = 5
			RETURN
		END
	END
	
	-- 3 가구 아이템 내구도 상승
	SET @nRetTemp = 1
	EXEC p_Item_SetOption @nCostumWeaponKey, @nCostumWeaponEndureOptionType, @nCostumWeaponEndureOptionData, @nRetTemp OUTPUT
	IF @nRetTemp <> 0 BEGIN
		ROLLBACK TRAN
		SET @nRet = 5
		RETURN
	END
	
	-- 업글 성공
	COMMIT TRAN
	SET @nRet = 0

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_Create]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_Create]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_Create    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/



CREATE PROCEDURE [dbo].[p_Item_Create]
/*
Item Create
2004.8 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/
@nItemKey bigint,
@nOwner int,
@nStorageType tinyint,
@nStorage smallint,
@nItemID int,
@nFlags int,
@nRet int OUTPUT
AS
SET NOCOUNT ON
-- 아이템 생성
INSERT tItem (  nItemKey,  nOwner,  nStorageType,  nStorage,  nItemID,  nFlags )
VALUES       ( @nItemKey, @nOwner, @nStorageType, @nStorage, @nItemID, @nFlags )
SET @nRet = @@ERROR
-- end
RETURN

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_Create_UseEmptyStorage]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_Create_UseEmptyStorage]
GO

CREATE PROCEDURE [dbo].[p_Item_Create_UseEmptyStorage]
/*
Item Create
2008.4 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/
@nItemKey bigint,
@nOwner int,
@nStorageType tinyint,
@nStorage smallint OUTPUT,
@nItemID int,
@nFlags int,
@nRet int OUTPUT
AS
BEGIN
	SET NOCOUNT ON

	BEGIN TRAN

	-- 빈인벤 위치찾기
	EXEC  p_Item_GetStorageEmpty @nOwner, @nStorageType, @nStorage OUTPUT
	IF @nStorage < 0
	BEGIN
		SET @nRet = -1
		ROLLBACK TRAN
		RETURN
	END

	-- 아이템 생성
	INSERT tItem (  nItemKey,  nOwner,  nStorageType,  nStorage,  nItemID,  nFlags )
	VALUES       ( @nItemKey, @nOwner, @nStorageType, @nStorage, @nItemID, @nFlags )
	SET @nRet = @@ERROR
	IF @nRet = 0
		COMMIT TRAN
	ELSE
		ROLLBACK TRAN
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_Create_UseEmptyStorage_tmp]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_Create_UseEmptyStorage_tmp]
GO
CREATE PROCEDURE [dbo].[p_Item_Create_UseEmptyStorage_tmp]
/*
Item Create
2008.4 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK, 
	        ? = Error code
modified by Adam.
when @nStorage <0,  print the charno + itemkey.
*/
@nItemKey bigint,
@nOwner int,
@nStorageType tinyint,
@nStorage smallint OUTPUT,
@nItemID int,
@nFlags int,
@nRet int OUTPUT
AS
BEGIN
	SET NOCOUNT ON

	BEGIN TRAN

	-- 빈인벤 위치찾기
	EXEC  p_Item_GetStorageEmpty @nOwner, @nStorageType, @nStorage OUTPUT
	IF @nStorage < 0
	BEGIN
		PRINT cast(@nOwner as varchar(20)) + ':' + cast(@nItemKey as varchar(20))
		ROLLBACK TRAN
		RETURN
	END

	-- 아이템 생성
	INSERT tItem (  nItemKey,  nOwner,  nStorageType,  nStorage,  nItemID,  nFlags )
	VALUES       ( @nItemKey, @nOwner, @nStorageType, @nStorage, @nItemID, @nFlags )
	SET @nRet = @@ERROR
	IF @nRet = 0
		BEGIN			
		EXEC p_Item_SetOption @nItemKey, 300,1,0
		COMMIT TRAN
		END
	ELSE
		BEGIN
		PRINT cast(@nOwner as varchar(20)) + ':' + cast(@nItemKey as varchar(20))
		ROLLBACK TRAN
		RETURN
		END
END
GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_Delete]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_Delete]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_Delete    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/



CREATE PROCEDURE [dbo].[p_Item_Delete]
/*
Item Delete
2004.8 By CJC
 input:
	nItemKey = To be delete.
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/
@nItemKey bigint,
@nRet int OUTPUT
AS
SET NOCOUNT ON
-- 아이템 삭제 옵션
DELETE FROM tItem WHERE nItemKey = @nItemKey
SET @nRet = @@ERROR
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_ExchangeStorage]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_ExchangeStorage]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_ExchangeStorage    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/


CREATE PROCEDURE [dbo].[p_Item_ExchangeStorage]
/*
Exchange item storage
2004.8 By CJC
 input:
	nItemKey1,nStorageType1,nStoage1 = #1 Item
	nItemKey2,nStorageType2,nStoage2 = #2 Item
 output:
	0 = Ok
	1~3 = Error step No.
 operation:
	Set nItemKey1 To nStorageType1,nStoage1
	Set nItemKey2 To nStorageType2,nStoage2
	
	1. #1 item move to temp storage   * #1,#2 is already input that exchanged data.
	2. set #2's storage to #2
	3. set #1's storage to #1
*/
@nItemKey1 bigint,
@nStorageType1 tinyint,
@nStorage1 smallint,
@nItemKey2 bigint,
@nStorageType2 tinyint,
@nStorage2 smallint,
@nRet tinyint OUTPUT
AS
SET NOCOUNT ON
SET @nRet = 0
BEGIN TRAN
-- Step 1
UPDATE tItem SET nStorageType = 11
WHERE nItemKey = @nItemKey1
IF @@ROWCOUNT = 0
BEGIN
	SET @nRet = 1
	ROLLBACK TRAN
	RETURN
END
	
-- Step 2
UPDATE tItem SET nStorageType = @nStorageType2, nStorage = @nStorage2
WHERE nItemKey = @nItemKey2
IF @@ROWCOUNT = 0
BEGIN
	SET @nRet = 2
	ROLLBACK TRAN
	RETURN
END
	
-- Step 3
UPDATE tItem SET nStorageType = @nStorageType1, nStorage = @nStorage1
WHERE nItemKey = @nItemKey1
IF @@ROWCOUNT = 0
BEGIN
	SET @nRet = 3
	ROLLBACK TRAN
	RETURN
END
COMMIT TRAN
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_ExchangeStorageAndOwner]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_ExchangeStorageAndOwner]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_ExchangeStorageAndOwner    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/


CREATE PROCEDURE [dbo].[p_Item_ExchangeStorageAndOwner]
/*
Exchange item storage
2004.8 By CJC
 input:
	nOwner1,nItemKey1,nStorageType1,nStoage1 = #1 Item
	nOwner2,nItemKey2,nStorageType2,nStoage2 = #2 Item
 output:
	0 = Ok
	1~3 = Error step No.
 operation:
	Set nItemKey1 To nOwner1,nStorageType1,nStoage1
	Set nItemKey2 To nOwner2,nStorageType2,nStoage2
	
	1. #1 item move to temp storage   * #1,#2 is already input that exchanged data.
	2. set #2's storage to #2
	3. set #1's storage to #1
*/
@nItemKey1 bigint,
@nOwner1 int,
@nStorageType1 tinyint,
@nStorage1 smallint,
@nItemKey2 bigint,
@nOwner2 int,
@nStorageType2 tinyint,
@nStorage2 smallint,
@nRet tinyint OUTPUT
AS
SET NOCOUNT ON
SET @nRet = 0
BEGIN TRAN
-- Step 1
UPDATE tItem SET nStorageType = 11
WHERE nItemKey = @nItemKey1
IF @@ROWCOUNT = 0
BEGIN
	SET @nRet = 1
	ROLLBACK TRAN
	RETURN
END
	
-- Step 2
UPDATE tItem SET nStorageType = @nStorageType2, nStorage = @nStorage2, nOwner = @nOwner2
WHERE nItemKey = @nItemKey2
IF @@ROWCOUNT = 0
BEGIN
	SET @nRet = 2
	ROLLBACK TRAN
	RETURN
END
	
-- Step 3
UPDATE tItem SET nStorageType = @nStorageType1, nStorage = @nStorage1, nOwner = @nOwner1
WHERE nItemKey = @nItemKey1
IF @@ROWCOUNT = 0
BEGIN
	SET @nRet = 3
	ROLLBACK TRAN
	RETURN
END
COMMIT TRAN
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_Furniture_Endure_Update]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_Furniture_Endure_Update]
GO
CREATE PROCEDURE [dbo].[p_Item_Furniture_Endure_Update]
/*
Item Furniture Endure Update
2008.10 By Lunar
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Not found item
	        2 = Missmatch item owner
	        3 = Not enough money to sub
	        4 = Upgrade value setting, upgrade fail count error(option set error)
	        5 = Raw delete fail
	        6 = RawLeft delete fail, if valid item
	        7 = RawRight delete fail, if valid item
	        8 = RawMiddle delete fail, if valid item
	        
 operation:
	1. money sub
	2. upgrade item level
	3. delete raws
*/
@nOwner int,
@nEndureKitKey bigint,
@nEndureKitOptionType smallint,
@nEndureKitLot smallint,
@nFurnitureKey bigint,
@nFurnitureEndureOptionType smallint,
@nFurnitureEndureOptionData bigint,
@nRet int OUTPUT
AS
BEGIN
	SET NOCOUNT ON
	
	DECLARE @nTinyintRet tinyint
	DECLARE @nRetTemp int

	-- 1.1 내구도 키트 아이템 소유자 확인
	EXEC p_Item_IsValidOwner @nEndureKitKey, @nOwner, @nTinyintRet OUTPUT
	IF @nTinyintRet <> 0 BEGIN
		SET @nRet = @nTinyintRet
		RETURN
	END
	
	-- 1.2 가구 아이템 소유자 확인
	EXEC p_Item_IsValidOwner @nFurnitureKey, @nOwner, @nTinyintRet OUTPUT
	IF @nTinyintRet <> 0 BEGIN
		SET @nRet = @nTinyintRet
		RETURN
	END

	BEGIN TRAN
	
	-- 2.1 사용된 내구도 키트 아이템 지우기 (사용후 Lot == 0 인 경우)
	IF @nEndureKitLot = 0 BEGIN
		SET @nRetTemp = 1
		EXEC p_Item_Delete @nEndureKitKey, @nRetTemp OUTPUT
		IF @nRetTemp <> 0 BEGIN
			ROLLBACK TRAN
			SET @nRet = 5
			RETURN
		END
	END
	-- 2.2 사용된 내구도 키트 아이템 차감하기 (사용후 Lot > 0 인 경우)
	ELSE BEGIN
		SET @nRetTemp = 1
		EXEC p_Item_SetOption @nEndureKitKey, @nEndureKitOptionType, @nEndureKitLot, @nRetTemp OUTPUT
		IF @nRetTemp <> 0 BEGIN
			ROLLBACK TRAN
			SET @nRet = 5
			RETURN
		END
	END
	
	-- 3 가구 아이템 내구도 상승
	SET @nRetTemp = 1
	EXEC p_Item_SetOption @nFurnitureKey, @nFurnitureEndureOptionType, @nFurnitureEndureOptionData, @nRetTemp OUTPUT
	IF @nRetTemp <> 0 BEGIN
		ROLLBACK TRAN
		SET @nRet = 5
		RETURN
	END
	
	-- 업글 성공
	COMMIT TRAN
	SET @nRet = 0

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_GetData]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_GetData]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_GetData    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Item_GetData]
/*
Item Get Data
2004.10 By CJC
 input:
	nItemKey = Item Key
 output:
	@nRet	1 = OK, 
	        0 = Error
*/
@nItemKey bigint,
@nOwner int OUTPUT,
@nStorageType tinyint OUTPUT,
@nStorage smallint OUTPUT,
@nItemID int OUTPUT,
@nFlags int OUTPUT,
@dDate datetime OUTPUT,
@nRet int OUTPUT
AS
SET NOCOUNT ON
SET @nRet = 0
SELECT 
	@nOwner = nOwner,
	@nStorageType = nStorageType,
	@nStorage = nStorage,
	@nItemID = nItemID,
	@nFlags = nFlags,
	@dDate = dDate
FROM tItem
WHERE nItemKey = @nItemKey
SET @nRet = @@ROWCOUNT
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_GetList]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_GetList]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_GetList    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Item_GetList]
/*
Item Get list
2004.8 By CJC
 input:
	nCharNo	     = Item Owner
 output:
	none
 desc:
	fetch success, get data
	fetch fail, not data
*/
@nCharNo int
AS
SET NOCOUNT ON
SELECT nItemKey, nStorageType, nStorage, nItemID, nFlags, dDate
FROM tItem
WHERE nOwner = @nCharNo
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_GetListType]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_GetListType]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_GetListType    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/


CREATE PROCEDURE [dbo].[p_Item_GetListType]
/*
Item Get list from StorageType
2004.8 By CJC
 input:
	nCharNo	     = Item Owner
	nStorageType = Item Storage Type
 output:
	none
 desc:
	fetch success, get data
	fetch fail, not data
*/
@nCharNo int,
@nStorageType tinyint
AS
SET NOCOUNT ON
SELECT nItemKey, nStorage, nItemID, nFlags, dDate
FROM tItem WITH(READUNCOMMITTED) 
WHERE nOwner = @nCharNo	AND nStorageType = @nStorageType
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_GetMobList]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_GetMobList]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_GetMobList    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Item_GetMobList]
/*
Item Get Mob List
2004.8 By CJC
 input:
	see SQL
 output:
	@nRet	0 = No data fount
	        ? = Number data here(must to be 1)
	        
	@nGrade = grade
	@nKillCount = kill count(progress)
		        
*/
@nItemKey bigint,
@nMobID smallint,
-- Output var
@nGrade tinyint OUTPUT,
@nKillCount int OUTPUT,
@nRet int OUTPUT
AS
SET NOCOUNT ON
SELECT @nGrade = nGrade, @nKillCount = nKillCount 
FROM tItemMobList
WHERE nItemKey = @nItemKey AND nMobID = @nMobID
SET @nRet = @@ROWCOUNT
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_GetMobListAll]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_GetMobListAll]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_GetMobListAll    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Item_GetMobListAll]
/*
Item Get Mob List All
2004.8 By CJC
 input:
	see SQL
 output:
	fetch to take data
*/
@nItemKey bigint
AS
SET NOCOUNT ON
SELECT nMobID, nGrade, nKillCount FROM tItemMobList WHERE nItemKey = @nItemKey
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_GetNumOfItem]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_GetNumOfItem]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_GetNumOfItem    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Item_GetNumOfItem]
/*
Get number of item
2004.8 By CJC
 input:
	nCharNo	    = Item Owner
 output:
	nItemCount,	-1 = error
	             ? = Count of item;
*/
@nCharNo int,
@nNumOfItem int OUTPUT
AS
SET NOCOUNT ON
SET @nNumOfItem = -1
SELECT @nNumOfItem = COUNT(*) FROM tItem WHERE nOwner = @nCharNo
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_GetOption]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_GetOption]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_GetOption    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Item_GetOption]
/*
Item Get Option
2004.8 By CJC
 input:
	see SQL
 output:
	@nRet	0 = No data found
	        ? = Number data here(must to be 1)
	        
	@nOptionData = option data
		        
*/
@nItemKey bigint,
@nOptionType smallint,
-- Output var
@nOptionData bigint OUTPUT,
@nRet int OUTPUT
AS
SET NOCOUNT ON
SELECT @nOptionData = nOptionData FROM tItemOptions WHERE nItemKey = @nItemKey AND nOptionType = @nOptionType
SET @nRet = @@ROWCOUNT
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_GetOptionAll]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_GetOptionAll]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_GetOptionAll    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Item_GetOptionAll]
/*
Item Get Option All
2004.8 By CJC
 input:
	see SQL
 output:
	fetch to take data
*/
@nItemKey bigint
AS
SET NOCOUNT ON
SELECT nOptionType, nOptionData FROM tItemOptions WHERE nItemKey = @nItemKey
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_GetOptionCount]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_GetOptionCount]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_GetOptionCount    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Item_GetOptionCount]
/*
Item Get Option Count
2004.8 By CJC
 input:
	see SQL
 output:
	@nOptionCount = Item option count
*/
@nItemKey bigint,
@nOptionCount int OUTPUT
AS
SET NOCOUNT ON
SELECT @nOptionCount = COUNT(nItemKey) FROM tItemOptions WHERE nItemKey = @nItemKey
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_GetStorage]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_GetStorage]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_GetStorage    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Item_GetStorage]
/*
Get item storage
2004.8 By CJC
 input:
	nItemKey	 = Item Key
 output:
	1, ok nStorageType, nStorage = valid value
	0, Not found item
*/
@nItemKey bigint,
@nStorageType tinyint OUTPUT,
@nStorage smallint OUTPUT,
@nRet tinyint = 1 OUTPUT 
AS
SET NOCOUNT ON
SELECT @nStorageType = nStorageType, @nStorage = nStorage FROM tItem WHERE nItemKey = @nItemKey
-- Check not found item
IF @@ROWCOUNT <> 1
	SET @nRet = 0
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_GetStorageAndOwner]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_GetStorageAndOwner]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_GetStorageAndOwner    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Item_GetStorageAndOwner]
/*
Get item storage
2004.8 By CJC
 input:
	nItemKey	 = Item Key
 output:
	1, ok nOwner, nStorageType, nStorage = valid value
	0, Not found item
*/
@nItemKey bigint,
@nOwner int OUTPUT,
@nStorageType tinyint OUTPUT,
@nStorage smallint OUTPUT,
@nRet tinyint OUTPUT 
AS
SET NOCOUNT ON
SELECT @nOwner = nOwner, @nStorageType = nStorageType, @nStorage = nStorage FROM tItem WHERE nItemKey = @nItemKey
-- Check not found item
IF @@ROWCOUNT <> 1
	SET @nRet = 0
ELSE
	SET @nRet = 1

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_GetStorageEmpty]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_GetStorageEmpty]
GO

/*--------------------------------------------------------------------------------------
' 이  름 : usp_Item_getEmptyStorage
' 작성자 : 고동균(kodong@gmail.com)
' 작성일 : 2008.4.1
' Description 
'   owner와 storageType을 받아 빈공간의 storage번호를 리턴하는 프로시저
' Parameter 
'	input Parameter
'		@owner       : 캐릭터번호
'		@storageType : 저장소
'	output Parameter
'		@ret         : result
'			<  0 : fail
'			>= 0 : empty storage number
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[p_Item_GetStorageEmpty]
	@owner       int = 0
,	@storageType tinyint = 0
,	@ret         int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	DECLARE @err AS bit
	DECLARE @emptyStorage AS smallint
	SET @err = 0

	IF @owner = 0
		SET @err = 1
	IF @storageType = 0
		SET @err = 1

	IF @err <> 1
		BEGIN	
			IF EXISTS(SELECT nItemKey FROM tItem WHERE nOwner = @owner AND nStorageType = @storageType AND nStorage = 0)
				BEGIN
					SELECT @emptyStorage = ISNULL(MIN(nStorage + 1), 0)
					  FROM tItem 
					 WHERE nOwner = @owner 
					   AND nStorageType = @storageType 
					   AND nStorage + 1 NOT IN (
							SELECT nStorage
							  FROM tItem 
							 WHERE nOwner = @owner AND nStorageType = @storageType)
				END
			ELSE
				BEGIN
					SET @emptyStorage = 0
				END

			SET @ret = @emptyStorage
			PRINT @ret
		END
	ELSE
		SET @ret = -1

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_GetStorageListType]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_GetStorageListType]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_GetStorageListType    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Item_GetStorageListType]

/*
Item Get storage list from StorageType
2004.8 By CJC
 input:
	nCharNo	     = Item Owner
	nStorageType = Item Storage Type
 output:
	none
 desc:
	fetch success, get data
	fetch fail, not data
*/

@nCharNo int,
@nStorageType tinyint

AS

SET NOCOUNT ON

SELECT nStorage FROM tItem WHERE nOwner = @nCharNo AND nStorageType = @nStorageType

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_GetStorageTypeCount]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_GetStorageTypeCount]
GO

CREATE PROCEDURE [dbo].[p_Item_GetStorageTypeCount]
/*
Item Get number of item count from StorageType
2008.4 By CJC
 input:
	Item Owner
	Item StorageType
 output:
	Number of item count from StorageType
 */

@nOwner int,
@nStorageType tinyint,
@nItemCount int OUTPUT
AS
BEGIN
	SET NOCOUNT ON
	SELECT @nItemCount=COUNT(nOwner) FROM tItem WHERE nOwner = @nOwner AND nStorageType = @nStorageType
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_GetTitle]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_GetTitle]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_GetTitle    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/


CREATE PROCEDURE [dbo].[p_Item_GetTitle]
/*
Item Get Title
2004.9 By CJC
 input:
	see SQL
 output:
	@nRet	0 = No data fount
	        ? = Number data here(must to be 1)
	        
	@nTitleType,@nTitleCharNo,@sTitle = title data
		        
*/
@nItemKey bigint,
-- Output var
@nTitleType smallint OUTPUT,
@nTitleCharNo int OUTPUT,
@sTitle nvarchar(24) OUTPUT,
@nRet int OUTPUT
AS
SET NOCOUNT ON
SELECT 
@nTitleType = nTitleType,
@nTitleCharNo = nTitleCharNo,
@sTitle = sTitle
FROM tItemTitle WHERE nItemKey = @nItemKey
SET @nRet = @@ROWCOUNT
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_IsValidOwner]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_IsValidOwner]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_IsValidOwner    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/


CREATE PROCEDURE [dbo].[p_Item_IsValidOwner]
/*
Is valid item owner ?
2004.8 By CJC
 input:
	nItemKey	 = Item Key
	nOwner	     = Item Owner
 output:
	0 = OK
	1 = Not found item
	2 = Missmatch item owner
*/
@nItemKey bigint,
@nOwner int,
@nRet tinyint OUTPUT 
AS
SET NOCOUNT ON
DECLARE @nDBOwner int 
SET @nDBOwner = 0
SET @nRet = 0
SELECT @nDBOwner = nOwner FROM tItem WITH (READUNCOMMITTED) WHERE nItemKey = @nItemKey
-- Check not found item
IF @@ROWCOUNT <> 1
BEGIN
	SET @nRet = 1
	RETURN
END
-- Check missmatch item owner
IF @nDBOwner <> @nOwner
BEGIN
	SET @nRet = 2
	RETURN
END
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_Merge]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_Merge]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_Merge    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Item_Merge]
/*
Item Merge - change lot and delete item
2004.9 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Not found from item
	        2 = Missmatch from item owner
	        3 = Not found to item
	        4 = Missmatch to item owner
	        ? = Error code(Lot change/Delete item error)
*/
@nOwnerFrom int,
@nOwnerTo int,
@nItemKeyFrom bigint,
@nItemKeyTo bigint,
@nOptionType smallint,
@nOptionData bigint,
@nRet int OUTPUT
AS
SET NOCOUNT ON
-- 삭제될 아이템(From) 소유자 확인
DECLARE @nTinyintRet tinyint
EXEC p_Item_IsValidOwner @nItemKeyFrom, @nOwnerFrom, @nTinyintRet OUTPUT
IF @nTinyintRet <> 0
BEGIN
	SET @nRet = @nTinyintRet
	RETURN
END
-- 랏 변경될 아이템(To) 소유자 확인
EXEC p_Item_IsValidOwner @nItemKeyTo, @nOwnerTo, @nTinyintRet OUTPUT
IF @nTinyintRet <> 0
BEGIN
	SET @nRet = @nTinyintRet + 2
	RETURN
END
BEGIN TRAN
-- 아이템 랏 변경저장프로시져 호출
EXEC p_Item_SetOption @nItemKeyTo, @nOptionType, @nOptionData, @nRet OUTPUT
IF @nRet <> 0
BEGIN
	ROLLBACK TRAN
	RETURN
END
-- 아이템 삭제
EXEC p_Item_Delete @nItemKeyFrom, @nRet OUTPUT
IF @@ERROR <> 0
BEGIN
	ROLLBACK TRAN
	RETURN
END
-- 완료
COMMIT TRAN
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_Merge_New]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_Merge_New]
GO

CREATE PROCEDURE [dbo].[p_Item_Merge_New]
/*
Item Merge - change lot and delete item
2007.11 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Not found from item
	        2 = Missmatch from item owner
	        3 = Not found to item
	        4 = Missmatch to item owner
                     5 = Get Sub Lot Failed
                     6 = Get Existed Lot Failed
                     7 = Set new lot failed
                     8 = Delete item failed
*/
@nOwnerFrom int,
@nOwnerTo int,
@nItemKeyFrom bigint,
@nItemKeyTo bigint,
@nOptionType smallint,
@nOptionDataLotSub bigint OUTPUT,
@nOptionDataLotResult bigint OUTPUT,
@nRet int OUTPUT
AS
SET NOCOUNT ON

-- 삭제될 아이템(From) 소유자 확인
DECLARE @nTinyintRet tinyint
EXEC p_Item_IsValidOwner @nItemKeyFrom, @nOwnerFrom, @nTinyintRet OUTPUT
IF @nTinyintRet <> 0
BEGIN
	SET @nRet = @nTinyintRet
	RETURN
END

-- 랏 변경될 아이템(To) 소유자 확인
EXEC p_Item_IsValidOwner @nItemKeyTo, @nOwnerTo, @nTinyintRet OUTPUT
IF @nTinyintRet <> 0
BEGIN
	SET @nRet = @nTinyintRet + 2
	RETURN
END

-- 빼질 아이템 랏 얻기
EXEC p_Item_GetOption @nItemKeyFrom, @nOptionType, @nOptionDataLotSub OUTPUT, @nRet OUTPUT
IF @nRet <> 1
BEGIN
	SET @nRet = 5
	RETURN
END

-- 더해질 아이템 랏 얻기
DECLARE @nOptionDataLotAdd bigint
EXEC p_Item_GetOption @nItemKeyTo, @nOptionType, @nOptionDataLotAdd OUTPUT, @nRet OUTPUT
IF @nRet <> 1
BEGIN
	SET @nRet = 6
	RETURN
END

-- 아이템 랏 변경저장프로시져 호출
BEGIN TRAN
SET @nOptionDataLotResult = @nOptionDataLotSub + @nOptionDataLotAdd
EXEC p_Item_SetOption @nItemKeyTo, @nOptionType, @nOptionDataLotResult, @nRet OUTPUT
IF @nRet <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = 7
	RETURN
END

-- 아이템 삭제
EXEC p_Item_Delete @nItemKeyFrom, @nRet OUTPUT
IF @@ERROR <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = 8
	RETURN
END

-- 완료
COMMIT TRAN

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_SellAll]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_SellAll]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_SellAll    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/


CREATE PROCEDURE [dbo].[p_Item_SellAll]
/*
Item sell all
2004.9 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Not found item
	        2 = Missmatch item owner
	        3 = Money add error
	        ? = Error code
	        
 operation:
	1. money add
	2. delete sell item
	
*/
@nItemKey bigint,
@nOwner int,
@nPrice bigint,
@nRet int OUTPUT
AS
SET NOCOUNT ON
-- 아이템 소유자 확인
DECLARE @nTinyintRet tinyint
EXEC p_Item_IsValidOwner @nItemKey, @nOwner, @nTinyintRet OUTPUT
IF @nTinyintRet <> 0
BEGIN
	SET @nRet = @nTinyintRet
	RETURN
END
-- 아이템 소유자의 돈 증가
BEGIN TRAN
EXEC p_Char_MoneyAdd @nOwner, @nPrice, @nTinyintRet OUTPUT
IF @nTinyintRet <> 1
BEGIN
	ROLLBACK TRAN
	SET @nRet = 3
	RETURN
END
-- 아이템 삭제 저장프로시져 호출
EXEC p_Item_Delete @nItemKey, @nRet OUTPUT
IF @@ERROR <> 0
BEGIN
	ROLLBACK TRAN
	RETURN
END
-- 완료
COMMIT TRAN
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_SellAll_LotCheck]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_SellAll_LotCheck]
GO
CREATE PROCEDURE [dbo].[p_Item_SellAll_LotCheck]
/*
Item sell all
2004.9 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Not found item
	        2 = Missmatch item owner
	        3 = Money add error
	        ? = Error code
	        
 operation:
	1. money add
	2. delete sell item
	
*/
@nItemKey bigint,
@nOwner int,
@nOptionType smallint,
@nLot bigint,
@nPrice bigint,
@nRet int OUTPUT
AS
SET NOCOUNT ON
-- 아이템 소유자 확인
DECLARE @nTinyintRet tinyint
EXEC p_Item_IsValidOwner @nItemKey, @nOwner, @nTinyintRet OUTPUT
IF @nTinyintRet <> 0
BEGIN
	SET @nRet = @nTinyintRet
	RETURN
END

-- 1보다 큰 경우에만 Lot 을 체크해 본다.
-- 1일 경우는 어차피 tItem 테이블에 존재하는 것만으로도 옳은 것으로 취급한다.
IF @nLot > 1
BEGIN
	DECLARE @nGetOptionDataLot bigint
	DECLARE @nGetOptionRet int
	EXEC p_Item_GetOption @nItemKey, @nOptionType, @nGetOptionDataLot OUTPUT, @nGetOptionRet OUTPUT
	IF @nGetOptionRet <> 1
	BEGIN
		SET @nRet = 4
		RETURN
	END

	IF @nGetOptionDataLot < @nLot
	BEGIN
		SET @nRet = 5
		RETURN
	END
END

-- 아이템 소유자의 돈 증가
BEGIN TRAN
EXEC p_Char_MoneyAdd @nOwner, @nPrice, @nTinyintRet OUTPUT
IF @nTinyintRet <> 1
BEGIN
	ROLLBACK TRAN
	SET @nRet = 3
	RETURN
END
-- 아이템 삭제 저장프로시져 호출
EXEC p_Item_Delete @nItemKey, @nRet OUTPUT
IF @@ERROR <> 0
BEGIN
	ROLLBACK TRAN
	RETURN
END
-- 완료
COMMIT TRAN
-- end




GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_SellLot]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_SellLot]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_SellLot    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/


CREATE PROCEDURE [dbo].[p_Item_SellLot]
/*
Item sell - change lot and add money
2004.9 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Not found item
	        2 = Missmatch item owner
	        3 = Money add error
	        ? = Error code(Lot change error)
*/
@nItemKey bigint,
@nOwner int,
@nOptionType smallint,
@nOptionData bigint,
@nPrice bigint,
@nRet int OUTPUT
AS
SET NOCOUNT ON
-- 아이템 소유자 확인
DECLARE @nTinyintRet tinyint
EXEC p_Item_IsValidOwner @nItemKey, @nOwner, @nTinyintRet OUTPUT
IF @nTinyintRet <> 0
BEGIN
	SET @nRet = @nTinyintRet
	RETURN
END
BEGIN TRAN
-- 아이템 소유자가 돈 증가
EXEC p_Char_MoneyAdd @nOwner, @nPrice, @nRet OUTPUT
IF @nRet <> 1
BEGIN
	ROLLBACK TRAN
	SET @nRet = 3
	RETURN
END
-- 아이템 랏 저장프로시져 호출
EXEC p_Item_SetOption @nItemKey, @nOptionType, @nOptionData, @nRet OUTPUT
IF @nRet <> 0
BEGIN
	ROLLBACK TRAN
	RETURN
END
-- 완료
COMMIT TRAN
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_SellLot_LotCheck]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_SellLot_LotCheck]
GO




















CREATE PROCEDURE [dbo].[p_Item_SellLot_LotCheck]
/*
Item sell - change lot and add money
2004.9 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Not found item
	        2 = Missmatch item owner
	        3 = Money add error
	        ? = Error code(Lot change error)
*/
@nItemKey bigint,
@nOwner int,
@nOptionType smallint,
@nOptionData bigint,
@nPrice bigint,
@nRet int OUTPUT
AS
SET NOCOUNT ON
-- 아이템 소유자 확인
DECLARE @nTinyintRet tinyint
EXEC p_Item_IsValidOwner @nItemKey, @nOwner, @nTinyintRet OUTPUT
IF @nTinyintRet <> 0
BEGIN
	SET @nRet = @nTinyintRet
	RETURN
END

DECLARE @nGetOptionDataLot bigint
DECLARE @nGetOptionRet int
EXEC p_Item_GetOption @nItemKey, @nOptionType, @nGetOptionDataLot OUTPUT, @nGetOptionRet OUTPUT
IF @nGetOptionRet <> 1
BEGIN
	SET @nRet = 4
	RETURN
END

IF @nGetOptionDataLot < @nOptionData
BEGIN
	SET @nRet = 5
	RETURN
END

BEGIN TRAN
-- 아이템 소유자가 돈 증가
EXEC p_Char_MoneyAdd @nOwner, @nPrice, @nRet OUTPUT
IF @nRet <> 1
BEGIN
	ROLLBACK TRAN
	SET @nRet = 3
	RETURN
END
-- 아이템 랏 저장프로시져 호출
EXEC p_Item_SetOption @nItemKey, @nOptionType, @nOptionData, @nRet OUTPUT
IF @nRet <> 0
BEGIN
	ROLLBACK TRAN
	RETURN
END
-- 완료
COMMIT TRAN
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_SetData]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_SetData]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_SetData    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Item_SetData]
/*
Item Set data
2004.10 By CJC
 input:
	see SQL
 output:
	@nRet	1 = OK, 
	        0 = Error
*/
@nItemKey bigint,
@nOwner int,
@nStorageType tinyint,
@nStorage smallint,
@nItemID int,
@nFlags int,
@dDate datetime,
@nRet int OUTPUT
AS
SET NOCOUNT ON
SET @nRet = 0
UPDATE tItem SET 
nOwner = @nOwner,
nStorageType = @nStorageType,
nStorage = @nStorage,
nItemID = @nItemID,
nFlags = @nFlags,
dDate = @dDate
WHERE nItemKey = @nItemKey
IF @@ERROR = 0 AND @@ROWCOUNT = 1
	SET @nRet = 1
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_SetMobList]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_SetMobList]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_SetMobList    스크립트 날짜: 2007-03-13 오후 6:25:09 ******/


CREATE PROCEDURE [dbo].[p_Item_SetMobList]
/*
Item Set Mob List
2004.8 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/
@nItemKey bigint,
@nMobID smallint,
@nGrade tinyint,
@nKillCount int,
-- Output var
@nRet int OUTPUT
AS
SET NOCOUNT ON
UPDATE tItemMobList SET	nGrade = @nGrade, nKillCount = @nKillCount
WHERE nItemKey = @nItemKey AND nMobID = @nMobID
IF @@ERROR <> 0 OR @@ROWCOUNT = 0
BEGIN
	INSERT tItemMobList (  nItemKey,  nMobID,  nGrade,  nKillCount )
	VALUES				( @nItemKey, @nMobID, @nGrade, @nKillCount )
END
SET @nRet = @@ERROR
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_SetOption]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_SetOption]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_SetOption    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/
CREATE PROCEDURE [dbo].[p_Item_SetOption]
/*
Item Set Option
2004.8 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/
@nItemKey bigint,
@nOptionType smallint,
@nOptionData bigint,
-- Output var
@nRet int OUTPUT
AS
SET NOCOUNT ON
UPDATE tItemOptions SET	nOptionData = @nOptionData
WHERE nItemKey = @nItemKey AND nOptionType = @nOptionType
IF @@ERROR <> 0 OR @@ROWCOUNT = 0
BEGIN
	INSERT tItemOptions (  nItemKey,  nOptionType,   nOptionData )
	VALUES				( @nItemKey, @nOptionType,  @nOptionData )
END
SET @nRet = @@ERROR
-- end

RETURN

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_SetStorage]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_SetStorage]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_SetStorage    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Item_SetStorage]
/*
Get item storage
2004.8 By CJC
 input:
	nItemKey	 = Item Key
	nStorageType, nStorage = Storage new value
 output:
	1 = OK
	0 = Not found or error
*/
@nItemKey bigint,
@nStorageType tinyint,
@nStorage smallint,
@nRet tinyint OUTPUT
AS
SET NOCOUNT ON
UPDATE tItem 
SET	nStorageType = @nStorageType, nStorage = @nStorage
WHERE nItemKey = @nItemKey
SET @nRet = @@ROWCOUNT
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_SetStorageAndOwner]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_SetStorageAndOwner]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_SetStorageAndOwner    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Item_SetStorageAndOwner]
/*
Get item storage
2004.8 By CJC
 input:
	nItemKey	 = Item Key
	nOwner, nStorageType, nStorage = Storage new value
 output:
	1 = OK
	0 = Not found or error
*/
@nItemKey bigint,
@nOwner int,
@nStorageType tinyint,
@nStorage smallint,
@nRet tinyint OUTPUT
AS
SET NOCOUNT ON
UPDATE tItem 
SET	nOwner = @nOwner, nStorageType = @nStorageType, nStorage = @nStorage
WHERE nItemKey = @nItemKey
SET @nRet = @@ROWCOUNT
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_SetStorageAndOwner_UseEmptyStorage]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_SetStorageAndOwner_UseEmptyStorage]
GO
CREATE PROCEDURE [dbo].[p_Item_SetStorageAndOwner_UseEmptyStorage]
/*
Get item storage
2004.8 By CJC
 input:
	nItemKey	 = Item Key
	nOwner, nStorageType, nStorage = Storage new value
 output:
	1 = OK
	0 = Not found or error
*/
@nItemKey bigint,
@nOwner int,
@nStorageType tinyint,
@nStorage smallint OUTPUT,
@nRet tinyint OUTPUT
AS
SET NOCOUNT ON


	-- ºóÀÎº¥ À§Ä¡Ã£±â
	EXEC  p_Item_GetStorageEmpty @nOwner, @nStorageType, @nStorage OUTPUT
	IF @nStorage < 0
	BEGIN
		SET @nRet = -1
		ROLLBACK TRAN
		RETURN
	END

	UPDATE tItem 
	SET	nOwner = @nOwner, nStorageType = @nStorageType, nStorage = @nStorage
	WHERE nItemKey = @nItemKey

	SET @nRet = @@ROWCOUNT
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_SetTitle]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_SetTitle]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_SetTitle    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/


CREATE PROCEDURE [dbo].[p_Item_SetTitle]
/*
Item Set Title
2004.8 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/
@nItemKey bigint,
@nTitleType smallint,
@nTitleCharNo int,
@sTitle nvarchar(24),
-- Output var
@nRet int OUTPUT
AS
SET NOCOUNT ON
UPDATE tItemTitle SET 
nTitleType = @nTitleType,
nTitleCharNo = @nTitleCharNo,
sTitle = @sTitle
WHERE nItemKey = @nItemKey
IF @@ERROR <> 0 OR @@ROWCOUNT = 0
BEGIN
	INSERT tItemTitle (  nItemKey,  nTitleType,  nTitleCharNo,  sTitle )
	VALUES			  ( @nItemKey, @nTitleType, @nTitleCharNo, @sTitle )
END
SET @nRet = @@ERROR
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_SetWeaponTitle]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_SetWeaponTitle]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_SetWeaponTitle    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/
CREATE PROCEDURE [dbo].[p_Item_SetWeaponTitle]
/*

Item Set Weapon Title
2005.8 By CJC

 input:
	see SQL

 output:
	@nRet	0 = OK, 
	        1 = Error Set Weapon mob 
	        2 = Error Set Weapon user
	        3 = Error Delete license item
	        ? = Error DB
*/

@nWeaponItemKey bigint,
@nLicenseItemKey bigint,
@nMobID smallint,

@nTitleCharNo int,
@sTitle nvarchar(24),

-- Output var
@nRet int OUTPUT

AS

SET NOCOUNT ON

BEGIN TRAN
-- 아이템에 몹 라이센스 붙이기
EXEC p_Item_SetMobList @nWeaponItemKey, @nMobID, 0, 0, @nRet OUTPUT
IF @nRet <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = 1
	RETURN
END

-- 처음 붙은 아이템의 경우 최초 제작자 정보를 세팅한다.
DECLARE @nRetTemp int
SELECT @nRetTemp = COUNT(*) FROM tItemMobList WHERE nItemKey = @nWeaponItemKey
IF @nRetTemp = 1
BEGIN
	EXEC p_Item_SetTitle @nWeaponItemKey, 0, @nTitleCharNo, @sTitle, @nRet OUTPUT
	IF @nRet <> 0
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 2
		RETURN
	END
END

-- 사용된 라이센스 아이템은 지운다.
SET @nRetTemp = 1
EXEC p_Item_Delete @nLicenseItemKey, @nRetTemp OUTPUT
IF @nRetTemp <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = 3
	RETURN
END

-- 성공
COMMIT TRAN
SET @nRet = 0

RETURN

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_Split_N_Merge]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_Split_N_Merge]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_Split_N_Merge    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Item_Split_N_Merge]
/*
Item Split and Merge - change lot
2004.9 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Not found from item
	        2 = Missmatch from item owner
	        3 = Not found to item
	        4 = Missmatch to item owner
	        ? = Error code(Lot change/Delete item error)
*/
@nItemKeyFrom bigint,
@nOwnerFrom int,
@nOptionTypeFrom smallint,
@nOptionDataFrom bigint,
@nItemKeyTo bigint,
@nOwnerTo int,
@nOptionTypeTo smallint,
@nOptionDataTo bigint,
@nRet int OUTPUT
AS
SET NOCOUNT ON
-- 수량 줄어들 아이템(From) 소유자 확인
DECLARE @nTinyintRet tinyint
EXEC p_Item_IsValidOwner @nItemKeyFrom, @nOwnerFrom, @nTinyintRet OUTPUT
IF @nTinyintRet <> 0
BEGIN
	SET @nRet = @nTinyintRet
	RETURN
END
-- 수량 늘어날 아이템(To) 소유자 확인
EXEC p_Item_IsValidOwner @nItemKeyTo, @nOwnerTo, @nTinyintRet OUTPUT
IF @nTinyintRet <> 0
BEGIN
	SET @nRet = @nTinyintRet + 2
	RETURN
END
BEGIN TRAN
-- 수량 줄어들 아이템 랏 변경저장프로시져 호출
EXEC p_Item_SetOption @nItemKeyFrom, @nOptionTypeFrom, @nOptionDataFrom, @nRet OUTPUT
IF @nRet <> 0
BEGIN
	ROLLBACK TRAN
	RETURN
END
-- 수량 늘어날 아이템 랏 변경저장프로시져 호출
EXEC p_Item_SetOption @nItemKeyTo, @nOptionTypeTo, @nOptionDataTo, @nRet OUTPUT
IF @nRet <> 0
BEGIN
	ROLLBACK TRAN
	RETURN
END
-- 완료
COMMIT TRAN
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_Split_N_Merge_New]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_Split_N_Merge_New]
GO

CREATE PROCEDURE [dbo].[p_Item_Split_N_Merge_New]
/*
Item Split and Merge - change lot
2004.9 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Not found from item
	        2 = Missmatch from item owner
	        3 = Not found to item
	        4 = Missmatch to item owner
                     5 = From lot read failed
                     6 = From lot less more nSplitLot
                     7 = To lot read failed
                     8 = From lot set failed
                     9 = To lot set failed
*/

@nItemKeyFrom bigint,
@nOwnerFrom int,
@nOptionTypeFrom smallint,
@nOptionDataFrom bigint OUTPUT,

@nItemKeyTo bigint,
@nOwnerTo int,
@nOptionTypeTo smallint,
@nOptionDataTo bigint OUTPUT,

@nSplitLot bigint,
@nRet int OUTPUT

AS

SET NOCOUNT ON

-- 수량 줄어들 아이템(From) 소유자 확인
DECLARE @nTinyintRet tinyint
EXEC p_Item_IsValidOwner @nItemKeyFrom, @nOwnerFrom, @nTinyintRet OUTPUT
IF @nTinyintRet <> 0
BEGIN
	SET @nRet = @nTinyintRet
	RETURN
END

-- 수량 늘어날 아이템(To) 소유자 확인
EXEC p_Item_IsValidOwner @nItemKeyTo, @nOwnerTo, @nTinyintRet OUTPUT
IF @nTinyintRet <> 0
BEGIN
	SET @nRet = @nTinyintRet + 2
	RETURN
END

-- 빼질 아이템 랏 얻기
EXEC p_Item_GetOption @nItemKeyFrom, @nOptionTypeFrom, @nOptionDataFrom OUTPUT, @nRet OUTPUT
IF @nRet <> 1
BEGIN
	SET @nRet = 5
	RETURN
END

-- 빼질 아이템 랏이 충분한지 확인
IF @nOptionDataFrom < @nSplitLot
BEGIN
	SET @nRet = 6
	RETURN
END

-- 더해질 아이템 랏 얻기
DECLARE @nOptionDataLotAdd bigint
EXEC p_Item_GetOption @nItemKeyTo, @nOptionTypeTo, @nOptionDataTo OUTPUT, @nRet OUTPUT
IF @nRet <> 1
BEGIN
	SET @nRet = 7
	RETURN
END

-- 결과 랏 계산
SET @nOptionDataFrom = @nOptionDataFrom - @nSplitLot
SET @nOptionDataTo = @nOptionDataTo + @nSplitLot

BEGIN TRAN
-- 수량 줄어들 아이템 랏 변경저장프로시져 호출
EXEC p_Item_SetOption @nItemKeyFrom, @nOptionTypeFrom, @nOptionDataFrom, @nRet OUTPUT
IF @nRet <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = 8
	RETURN
END

-- 수량 늘어날 아이템 랏 변경저장프로시져 호출
EXEC p_Item_SetOption @nItemKeyTo, @nOptionTypeTo, @nOptionDataTo, @nRet OUTPUT
IF @nRet <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = 9
	RETURN
END

-- 완료
COMMIT TRAN
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_Upgrade]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_Upgrade]
GO

CREATE PROCEDURE [dbo].[p_Item_Upgrade]
/*
Item upgrade
2005.6 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Not found item
	        2 = Missmatch item owner
	        3 = Not enough money to sub
	        4 = Upgrade value setting, upgrade fail count error(option set error)
	        5 = Raw delete fail
	        6 = RawLeft delete fail, if valid item
	        7 = RawRight delete fail, if valid item
	        8 = RawMiddle delete fail, if valid item
	        
 operation:
	1. money sub
	2. upgrade item level
	3. delete raws
*/
@nOwner int,
@nItemKey bigint,
@nItemDestroy int,
@nUpgradeOptionType smallint,
@nUpgradeOptionValue bigint,
@nUpgradeFailCountType smallint,
@nUpgradeFailCountValue bigint,
@nRawKey bigint,
@nRawLeftKey bigint,
@nRawRightKey bigint,
@nRawMiddleKey bigint,
@nGiftMoney bigint,
@nRet int OUTPUT
AS
SET NOCOUNT ON
-- 아이템 소유자 확인
DECLARE @nTinyintRet tinyint
EXEC p_Item_IsValidOwner @nItemKey, @nOwner, @nTinyintRet OUTPUT
IF @nTinyintRet <> 0
BEGIN
	SET @nRet = @nTinyintRet
	RETURN
END
-- 아이템 소유자의 돈 감소
BEGIN TRAN
IF @nGiftMoney > 0 -- 수고비가 있는 경우, 금액을 빼준다.
BEGIN
	EXEC p_Char_MoneySub @nOwner, @nGiftMoney, @nTinyintRet OUTPUT
	IF @nTinyintRet <> 1
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 3
		RETURN
	END
END	
-- 아이템 업그레이드 값 조정
DECLARE @nRetTemp int
IF @nItemDestroy = 1 -- 업글 실패로 아이템 파괴해야 되는경우
BEGIN
	SET @nRetTemp = 1
	EXEC p_Item_Delete @nItemKey, @nRetTemp OUTPUT
	IF @nRetTemp <> 0
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 4
		RETURN
	END
END
ELSE
BEGIN
	-- 업글 실패로 파괴가 아닌 경우, 새로운 업글값, 실패 카운트 기록	
	SET @nRetTemp = 1
	EXEC p_Item_SetOption @nItemKey, @nUpgradeOptionType, @nUpgradeOptionValue, @nRetTemp OUTPUT
	IF @nRetTemp <> 0
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 4
		RETURN
	END
	
	SET @nRetTemp = 1
	EXEC p_Item_SetOption @nItemKey, @nUpgradeFailCountType, @nUpgradeFailCountValue, @nRetTemp OUTPUT
	IF @nRetTemp <> 0
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 4
		RETURN
	END
END
-- 사용된 자원 지우기
SET @nRetTemp = 1
EXEC p_Item_Delete @nRawKey, @nRetTemp OUTPUT
IF @nRetTemp <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = 5
	RETURN
END
-- 사용된 자원왼족 지우기(입력된 값이 있으면)
IF @nRawLeftKey <> 0
BEGIN
	SET @nRetTemp = 1
	EXEC p_Item_Delete @nRawLeftKey, @nRetTemp OUTPUT
	IF @nRetTemp <> 0
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 6
		RETURN
	END
END
-- 사용된 자원오른쪽 지우기(입력된 값이 있으면)
IF @nRawRightKey <> 0
BEGIN
	SET @nRetTemp = 1
	EXEC p_Item_Delete @nRawRightKey, @nRetTemp OUTPUT
	IF @nRetTemp <> 0
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 7
		RETURN
	END
END
-- 사용된 자원가운데 지우기(입력된 값이 있으면)
IF @nRawMiddleKey <> 0
BEGIN
	SET @nRetTemp = 1
	EXEC p_Item_Delete @nRawMiddleKey, @nRetTemp OUTPUT
	IF @nRetTemp <> 0
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 8
		RETURN
	END
END

-- 업글 성공
COMMIT TRAN
SET @nRet = 0
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_Upgrade_CelllInAll]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_Upgrade_CelllInAll]
GO



CREATE PROCEDURE [dbo].[p_Item_Upgrade_CelllInAll]
/*
Item upgrade
2008.2 By Lunar
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Not found item
	        2 = Missmatch item owner
	        3 = Not enough money to sub
	        4 = Upgrade value setting, upgrade fail count error(option set error)
	        5 = Raw delete fail
	        6 = RawLeft delete fail, if valid item
	        7 = RawRight delete fail, if valid item
	        8 = RawMiddle delete fail, if valid item
	        
 operation:
	1. money sub
	2. upgrade item level
	3. delete raws
*/
@nOwner int,
@nItemKey bigint,
@nItemDestroy int,
@nUpgradeOptionType smallint,
@nUpgradeOptionValue bigint,
@nUpgradeFailCountType smallint,
@nUpgradeFailCountValue bigint,
@nRawKey bigint,
@nRawLeftKey bigint,
@nRawRightKey bigint,
@nRawMiddleKey bigint,
@nGiftMoney bigint,
@nRawOptionType smallint,
@nRawLot smallint,
@nRawLeftOptionType smallint,
@nRawLeftLot smallint,
@nRawRightOptionType smallint,
@nRawRightLot smallint,
@nRawMiddleOptionType smallint,
@nRawMiddleLot smallint,
@nRet int OUTPUT
AS
SET NOCOUNT ON
-- 아이템 소유자 확인
DECLARE @nTinyintRet tinyint
EXEC p_Item_IsValidOwner @nItemKey, @nOwner, @nTinyintRet OUTPUT
IF @nTinyintRet <> 0
BEGIN
	SET @nRet = @nTinyintRet
	RETURN
END
-- 아이템 소유자의 돈 감소
BEGIN TRAN
IF @nGiftMoney > 0 -- 수고비가 있는 경우, 금액을 빼준다.
BEGIN
	EXEC p_Char_MoneySub @nOwner, @nGiftMoney, @nTinyintRet OUTPUT
	IF @nTinyintRet <> 1
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 3
		RETURN
	END
END	
-- 아이템 업그레이드 값 조정
DECLARE @nRetTemp int
IF @nItemDestroy = 1 -- 업글 실패로 아이템 파괴해야 되는경우
BEGIN
	SET @nRetTemp = 1
	EXEC p_Item_Delete @nItemKey, @nRetTemp OUTPUT
	IF @nRetTemp <> 0
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 4
		RETURN
	END
END
ELSE
BEGIN
	-- 업글 실패로 파괴가 아닌 경우, 새로운 업글값, 실패 카운트 기록	
	SET @nRetTemp = 1
	EXEC p_Item_SetOption @nItemKey, @nUpgradeOptionType, @nUpgradeOptionValue, @nRetTemp OUTPUT
	IF @nRetTemp <> 0
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 4
		RETURN
	END
	
	SET @nRetTemp = 1
	EXEC p_Item_SetOption @nItemKey, @nUpgradeFailCountType, @nUpgradeFailCountValue, @nRetTemp OUTPUT
	IF @nRetTemp <> 0
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 4
		RETURN
	END
END

-- 사용된 자원 지우기
IF @nRawKey <> 0
BEGIN
	IF @nRawLot = 1
	BEGIN
		SET @nRetTemp = 1
		EXEC p_Item_Delete @nRawKey, @nRetTemp OUTPUT
		IF @nRetTemp <> 0
		BEGIN
			ROLLBACK TRAN
			SET @nRet = 5
			RETURN
		END
	END
	IF @nRawLot > 1
	BEGIN
		SET @nRetTemp = 1
		SET @nRawLot = @nRawLot - 1
		EXEC p_Item_SetOption @nRawKey, @nRawOptionType, @nRawLot, @nRetTemp OUTPUT
		IF @nRetTemp <> 0
		BEGIN
			ROLLBACK TRAN
			SET @nRet = 5
			RETURN
		END
	END
END

-- 사용된 자원왼족 지우기(입력된 값이 있으면)
IF @nRawLeftKey <> 0
BEGIN
	IF @nRawLeftLot = 1
	BEGIN
		SET @nRetTemp = 1
		EXEC p_Item_Delete @nRawLeftKey, @nRetTemp OUTPUT
		IF @nRetTemp <> 0
		BEGIN
			ROLLBACK TRAN
			SET @nRet = 6
			RETURN
		END
	END
	IF @nRawLeftLot > 1
	BEGIN
		SET @nRetTemp = 1
		SET @nRawLeftLot = @nRawLeftLot - 1
		EXEC p_Item_SetOption @nRawLeftKey, @nRawLeftOptionType, @nRawLeftLot, @nRetTemp OUTPUT
		IF @nRetTemp <> 0
		BEGIN
			ROLLBACK TRAN
			SET @nRet = 6
			RETURN
		END
	END
END


-- 사용된 자원오른쪽 지우기(입력된 값이 있으면)
IF @nRawRightKey <> 0
BEGIN
	IF @nRawRightLot = 1
	BEGIN
		SET @nRetTemp = 1
		EXEC p_Item_Delete @nRawRightKey, @nRetTemp OUTPUT
		IF @nRetTemp <> 0
		BEGIN
			ROLLBACK TRAN
			SET @nRet = 7
			RETURN
		END
	END
	IF @nRawRightLot > 1
	BEGIN
		SET @nRetTemp = 1
		SET @nRawRightLot = @nRawRightLot - 1
		EXEC p_Item_SetOption @nRawRightKey, @nRawRightOptionType, @nRawRightLot, @nRetTemp OUTPUT
		IF @nRetTemp <> 0
		BEGIN
			ROLLBACK TRAN
			SET @nRet = 7
			RETURN
		END
	END
END

-- 사용된 자원가운데 지우기(입력된 값이 있으면)
IF @nRawMiddleKey <> 0
BEGIN
	IF @nRawMiddleLot = 1
	BEGIN
		SET @nRetTemp = 1
		EXEC p_Item_Delete @nRawMiddleKey, @nRetTemp OUTPUT
		IF @nRetTemp <> 0
		BEGIN
			ROLLBACK TRAN
			SET @nRet = 8
			RETURN
		END
	END
	IF @nRawMiddleLot > 1
	BEGIN
		SET @nRetTemp = 1
		SET @nRawMiddleLot = @nRawMiddleLot - 1
		EXEC p_Item_SetOption @nRawMiddleKey, @nRawMiddleOptionType, @nRawMiddleLot, @nRetTemp OUTPUT
		IF @nRetTemp <> 0
		BEGIN
			ROLLBACK TRAN
			SET @nRet = 8
			RETURN
		END
	END
END

-- 업글 성공
COMMIT TRAN
SET @nRet = 0
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_Upgrade_GOLD_NINE]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_Upgrade_GOLD_NINE]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_Upgrade_GOLD_NINE    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/
CREATE PROCEDURE [dbo].[p_Item_Upgrade_GOLD_NINE]
/*
Item upgrade
2005.6 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Not found item
	        2 = Missmatch item owner
	        3 = Not enough money to sub
	        4 = Upgrade value setting, upgrade fail count error(option set error)
	        5 = Raw delete fail
	        6 = RawLeft delete fail, if valid item
	        7 = RawRight delete fail, if valid item
	        8 = RawMiddle delete fail, if valid item
	        
 operation:
	1. money sub
	2. upgrade item level
	3. delete raws
*/
@nOwner int,
@nItemKey bigint,
@nItemDestroy int,
@nUpgradeOptionType smallint,
@nUpgradeOptionValue bigint,
@nUpgradeFailCountType smallint,
@nUpgradeFailCountValue bigint,
@nRawKey bigint,
@nRawLeftKey bigint,
@nRawRightKey bigint,
@nRawMiddleKey bigint,
@nGiftMoney bigint,
@nRet int OUTPUT
AS
SET NOCOUNT ON
-- 아이템 소유자 확인
DECLARE @nTinyintRet tinyint
EXEC p_Item_IsValidOwner @nItemKey, @nOwner, @nTinyintRet OUTPUT
IF @nTinyintRet <> 0
BEGIN
	SET @nRet = @nTinyintRet
	RETURN
END
-- 아이템 소유자의 돈 감소
BEGIN TRAN
IF @nGiftMoney > 0 -- 수고비가 있는 경우, 금액을 빼준다.
BEGIN
	EXEC p_Char_MoneySub @nOwner, @nGiftMoney, @nTinyintRet OUTPUT
	IF @nTinyintRet <> 1
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 3
		RETURN
	END
END	
-- 아이템 업그레이드 값 조정
DECLARE @nRetTemp int
IF @nItemDestroy = 1 -- 업글 실패로 아이템 파괴해야 되는경우
BEGIN
	SET @nRetTemp = 1
	EXEC p_Item_Delete @nItemKey, @nRetTemp OUTPUT
	IF @nRetTemp <> 0
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 4
		RETURN
	END
END
ELSE
BEGIN
	-- 업글 실패로 파괴가 아닌 경우, 새로운 업글값, 실패 카운트 기록	
	SET @nRetTemp = 1
	EXEC p_Item_SetOption @nItemKey, @nUpgradeOptionType, @nUpgradeOptionValue, @nRetTemp OUTPUT
	IF @nRetTemp <> 0
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 4
		RETURN
	END
	
	SET @nRetTemp = 1
	EXEC p_Item_SetOption @nItemKey, @nUpgradeFailCountType, @nUpgradeFailCountValue, @nRetTemp OUTPUT
	IF @nRetTemp <> 0
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 4
		RETURN
	END
END
-- 사용된 자원 지우기
SET @nRetTemp = 1
EXEC p_Item_Delete @nRawKey, @nRetTemp OUTPUT
IF @nRetTemp <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = 5
	RETURN
END
-- 사용된 자원왼족 지우기(입력된 값이 있으면)
IF @nRawLeftKey <> 0
BEGIN
	SET @nRetTemp = 1
	EXEC p_Item_Delete @nRawLeftKey, @nRetTemp OUTPUT
	IF @nRetTemp <> 0
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 6
		RETURN
	END
END
-- 사용된 자원오른쪽 지우기(입력된 값이 있으면)
IF @nRawRightKey <> 0
BEGIN
	SET @nRetTemp = 1
	EXEC p_Item_Delete @nRawRightKey, @nRetTemp OUTPUT
	IF @nRetTemp <> 0
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 7
		RETURN
	END
END
-- 사용된 자원가운데 지우기(입력된 값이 있으면)
IF @nRawMiddleKey <> 0
BEGIN
	SET @nRetTemp = 1
	EXEC p_Item_Delete @nRawMiddleKey, @nRetTemp OUTPUT
	IF @nRetTemp <> 0
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 8
		RETURN
	END
END

-- 업글 성공
COMMIT TRAN
SET @nRet = 0
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Item_Upgrade_OLD]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Item_Upgrade_OLD]
GO
/****** 개체: 저장 프로시저 dbo.p_Item_Upgrade_OLD    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/


CREATE PROCEDURE [dbo].[p_Item_Upgrade_OLD]
/*
Item upgrade
2005.6 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Not found item
	        2 = Missmatch item owner
	        3 = Not enough money to sub
	        4 = Upgrade value setting, upgrade fail count error(option set error)
	        5 = Raw delete fail
	        6 = RawLeft delete fail, if valid item
	        7 = RawRight delete fail, if valid item
	        
 operation:
	1. money sub
	2. upgrade item level
	3. delete raws
*/
@nOwner int,
@nItemKey bigint,
@nItemDestroy int,
@nUpgradeOptionType smallint,
@nUpgradeOptionValue bigint,
@nUpgradeFailCountType smallint,
@nUpgradeFailCountValue bigint,
@nRawKey bigint,
@nRawLeftKey bigint,
@nRawRightKey bigint,
@nGiftMoney bigint,
@nRet int OUTPUT
AS
SET NOCOUNT ON
-- 아이템 소유자 확인
DECLARE @nTinyintRet tinyint
EXEC p_Item_IsValidOwner @nItemKey, @nOwner, @nTinyintRet OUTPUT
IF @nTinyintRet <> 0
BEGIN
	SET @nRet = @nTinyintRet
	RETURN
END
-- 아이템 소유자의 돈 감소
BEGIN TRAN
IF @nGiftMoney > 0 -- 수고비가 있는 경우, 금액을 빼준다.
BEGIN
	EXEC p_Char_MoneySub @nOwner, @nGiftMoney, @nTinyintRet OUTPUT
	IF @nTinyintRet <> 1
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 3
		RETURN
	END
END	
-- 아이템 업그레이드 값 조정
DECLARE @nRetTemp int
IF @nItemDestroy = 1 -- 업글 실패로 아이템 파괴해야 되는경우
BEGIN
	SET @nRetTemp = 1
	EXEC p_Item_Delete @nItemKey, @nRetTemp OUTPUT
	IF @nRetTemp <> 0
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 4
		RETURN
	END
END
ELSE
BEGIN
	-- 업글 실패로 파괴가 아닌 경우, 새로운 업글값, 실패 카운트 기록	
	SET @nRetTemp = 1
	EXEC p_Item_SetOption @nItemKey, @nUpgradeOptionType, @nUpgradeOptionValue, @nRetTemp OUTPUT
	IF @nRetTemp <> 0
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 4
		RETURN
	END
	
	SET @nRetTemp = 1
	EXEC p_Item_SetOption @nItemKey, @nUpgradeFailCountType, @nUpgradeFailCountValue, @nRetTemp OUTPUT
	IF @nRetTemp <> 0
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 4
		RETURN
	END
END
-- 사용된 자원 지우기
SET @nRetTemp = 1
EXEC p_Item_Delete @nRawKey, @nRetTemp OUTPUT
IF @nRetTemp <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = 5
	RETURN
END
-- 사용된 자원왼족 지우기(입력된 값이 있으면)
IF @nRawLeftKey <> 0
BEGIN
	SET @nRetTemp = 1
	EXEC p_Item_Delete @nRawLeftKey, @nRetTemp OUTPUT
	IF @nRetTemp <> 0
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 6
		RETURN
	END
END
-- 사용된 자원오른쪽 지우기(입력된 값이 있으면)
IF @nRawRightKey <> 0
BEGIN
	SET @nRetTemp = 1
	EXEC p_Item_Delete @nRawRightKey, @nRetTemp OUTPUT
	IF @nRetTemp <> 0
	BEGIN
		ROLLBACK TRAN
		SET @nRet = 7
		RETURN
	END
END
-- 업글 성공
COMMIT TRAN
SET @nRet = 0
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_KingdomQuest_Del]
-- ----------------------------
DROP PROCEDURE [dbo].[p_KingdomQuest_Del]
GO
/****** 개체: 저장 프로시저 dbo.p_KingdomQuest_Del    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/


CREATE PROCEDURE [dbo].[p_KingdomQuest_Del]
/*
Kingdom Quest Delete
2005.8 By CJC
 input:
	nQuestNo = To be delete info.
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/
@nQuestNo int,
@nRet int OUTPUT

AS

SET NOCOUNT ON

DELETE FROM tKingdomQuest WHERE nQuestNo = @nQuestNo

IF (@@ERROR=0) AND (@@ROWCOUNT=1)
	SET @nRet = 0
ELSE
	SET @nRet = 1
	
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_KingdomQuest_Get]
-- ----------------------------
DROP PROCEDURE [dbo].[p_KingdomQuest_Get]
GO
/****** 개체: 저장 프로시저 dbo.p_KingdomQuest_Get    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/


CREATE PROCEDURE [dbo].[p_KingdomQuest_Get]
/*
Kingdom Quest Get
2005.8 By CJC
 input:
	see SQL
 output:
	@nRet	0 = No data found
	        ? = Number data here(must to be 1)
*/

@nQuestNo int,
@sData varchar(256) OUTPUT,
@nRet int OUTPUT

AS

SET NOCOUNT ON

SELECT @sData = sData FROM tKingdomQuest WHERE nQuestNo = @nQuestNo

SET @nRet = @@ROWCOUNT

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_KingdomQuest_GetAll]
-- ----------------------------
DROP PROCEDURE [dbo].[p_KingdomQuest_GetAll]
GO
/****** 개체: 저장 프로시저 dbo.p_KingdomQuest_GetAll    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/


CREATE PROCEDURE [dbo].[p_KingdomQuest_GetAll]
/*
Kingdom Quest Get All
2005.8 By CJC
 input:
	see SQL
 output:
	@nRet	0 = No data found
	        ? = Number data here(must to be 1)
*/

AS

SET NOCOUNT ON

SELECT nQuestNo, sData FROM tKingdomQuest

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_KingdomQuest_GetNumOfKQ]
-- ----------------------------
DROP PROCEDURE [dbo].[p_KingdomQuest_GetNumOfKQ]
GO
/****** 개체: 저장 프로시저 dbo.p_KingdomQuest_GetNumOfKQ    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/


CREATE PROCEDURE [dbo].[p_KingdomQuest_GetNumOfKQ]
/*
Kingdom Quest Get number of KQ
2005.8 By CJC
 input:
	see SQL
 output:
	@nRet	0 = No data found
	        ? = Number data here(must to be 1)
*/

@nNumOfKQ int OUTPUT

AS

SET NOCOUNT ON

SELECT @nNumOfKQ = COUNT(*) FROM tKingdomQuest

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_KingdomQuest_Set]
-- ----------------------------
DROP PROCEDURE [dbo].[p_KingdomQuest_Set]
GO
/****** 개체: 저장 프로시저 dbo.p_KingdomQuest_Set    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/


CREATE PROCEDURE [dbo].[p_KingdomQuest_Set]
/*
Kingdom Quest Set
2005.8 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/
@nQuestNo smallint,
@sData varchar(256),
@nRet int OUTPUT

AS

SET NOCOUNT ON

UPDATE tKingdomQuest SET sData = @sData WHERE nQuestNo = @nQuestNo

IF @@ERROR <> 0 OR @@ROWCOUNT = 0
BEGIN
	INSERT tKingdomQuest ( nQuestNo, sData ) VALUES ( @nQuestNo, @sData )
END

SET @nRet = @@ERROR

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_LevelCatchUp]
-- ----------------------------
DROP PROCEDURE [dbo].[p_LevelCatchUp]
GO
CREATE PROCEDURE [dbo].[p_LevelCatchUp] 
--Procedure to get Leveling information from GameLog DB.
--truncate table
@srctop int,
@rstop int
as
DECLARE @RCNT int
truncate table tLevelCatchUpRank;

with LevelCatch_CTE
as (
select  top (@srctop) nCharNo,nLevel, dLastUpdated from w00_GameLog.dbo.tLevelUpInfo order by nLevel desc, dLastUpdated asc
)
insert into tLevelCatchUpRank
select top (@rstop) c.sID, g.sName, cs.nClass, l.nLevel, l.dLastUpdated
from LevelCatch_CTE l,tCharacterShape cs, tCharacter c left outer join tGuildMember gm
on c.nCharNo=gm.nCharNo left outer join tGuild g on gm.nNo=g.nNo 
where c.nCharNo=l.nCharNo and cs.nCharNo=c.nCharNo
and c.bDeleted=0 and nAdminlevel=0
order by l.nLevel desc, l.dLastUpdated asc

SET @RCNT = @@ROWCOUNT
IF @RCNT < 20
BEGIN
	PRINT @RCNT
	PRINT 'corrent=' + cast(@srctop as char(5))
	SET @srctop = @srctop + 10	
	PRINT 'modified=' + cast(@srctop as char(5))
	EXEC dbo.p_LevelCatchUp @srctop, @rstop
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_MasPup_DelAll]
-- ----------------------------
DROP PROCEDURE [dbo].[p_MasPup_DelAll]
GO
/****** 개체: 저장 프로시저 dbo.p_MasPup_DelAll    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/


CREATE PROCEDURE [dbo].[p_MasPup_DelAll]
/*
Delete My Master and Pupils
2004.12 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/
@nCharNo int,
@nRet int OUTPUT
AS
SET NOCOUNT ON
-- 아이템 삭제 옵션
DELETE FROM tMasterPupils WHERE (nMaster = @nCharNo) OR (nPupils = @nCharNo)  
SET @nRet = @@ERROR
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_MasPup_DelMaster]
-- ----------------------------
DROP PROCEDURE [dbo].[p_MasPup_DelMaster]
GO
/****** 개체: 저장 프로시저 dbo.p_MasPup_DelMaster    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/


CREATE PROCEDURE [dbo].[p_MasPup_DelMaster]
/*
Delete My Master
2004.12 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/
@nCharNo int,   -- As Pupils
@nRet int OUTPUT
AS
SET NOCOUNT ON
DELETE FROM tMasterPupils WHERE nPupils = @nCharNo
SET @nRet = @@ERROR
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_MasPup_DelPupils]
-- ----------------------------
DROP PROCEDURE [dbo].[p_MasPup_DelPupils]
GO
/****** 개체: 저장 프로시저 dbo.p_MasPup_DelPupils    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/


CREATE PROCEDURE [dbo].[p_MasPup_DelPupils]
/*
Delete My Pupils
2004.12 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK, 
			? = Error code
*/
@nCharNo int,   -- As Master
@nPupils int,
@nRet int OUTPUT
AS
SET NOCOUNT ON
DELETE FROM tMasterPupils WHERE (nPupils = @nPupils) AND (nMaster = @nCharNo)
SET @nRet = @@ERROR
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_MasPup_GetAll]
-- ----------------------------
DROP PROCEDURE [dbo].[p_MasPup_GetAll]
GO
/****** 개체: 저장 프로시저 dbo.p_MasPup_GetAll    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/


CREATE PROCEDURE [dbo].[p_MasPup_GetAll]
/*
Get My Master and Pupils
2004.12 By CJC
 input:
	see SQL
 output:
	fetch to take data
*/
@nCharNo int
AS
SET NOCOUNT ON
SELECT nMaster, nPupils, nFlags FROM tMasterPupils WHERE (nMaster = @nCharNo) OR (nPupils = @nCharNo)  
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_MasPup_SetMaster]
-- ----------------------------
DROP PROCEDURE [dbo].[p_MasPup_SetMaster]
GO
/****** 개체: 저장 프로시저 dbo.p_MasPup_SetMaster    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/


CREATE PROCEDURE [dbo].[p_MasPup_SetMaster]
/*
Set My Master
2004.12 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK, 
			1 = 자신과는 스승관계를 맺을수 없다.
			2 = 제자가 4명이상 기록이 안된다.
			? = Error code(또는 스승이 2명이상 기록안된다)
*/
@nCharNo int,	-- As Pupils
@nMaster int,
@nFlags  int,
@nRet int OUTPUT
AS
SET NOCOUNT ON
-- 자신과 사제를 맺는지 확인한다.
IF @nMaster = @nCharNo
BEGIN
	SET @nRet = 1
	RETURN
END
-- 제자가 4명이상 기록이 안되게 확인
DECLARE @PupilsCount int
SELECT @PupilsCount = COUNT(*) FROM tMasterPupils WHERE nMaster = @nMaster
IF @PupilsCount >= 3
BEGIN
	SET @nRet = 2
	RETURN
END
-- 기록된 사항에 수정인 경우 수정처리 한다.
UPDATE tMasterPupils SET 
	nMaster = @nMaster,
	nFlags  = @nFlags
WHERE nPupils = @nCharNo
-- 처음 기록의 경우 처리한다.
IF @@ERROR <> 0 OR @@ROWCOUNT = 0
BEGIN
	INSERT tMasterPupils (  nMaster,  nPupils,  nFlags )
	VALUES				 ( @nMaster, @nCharNo, @nFlags )
END
SET @nRet = @@ERROR
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_MasPup_SetPupils]
-- ----------------------------
DROP PROCEDURE [dbo].[p_MasPup_SetPupils]
GO
/****** 개체: 저장 프로시저 dbo.p_MasPup_SetPupils    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/


CREATE PROCEDURE [dbo].[p_MasPup_SetPupils]
/*
Set My Pupils
2004.12 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK,또는 이미 기록 되어 있음 
			1 = 자신과 사제를 맺을수 없다.
			2 = 제자가 4명이상 기록이 안된다.
			? = Error code(또는 스승이 2명이상 기록안된다)
*/
@nCharNo int, -- As Master
@nPupils int,
@nFlags  int,
@nRet int OUTPUT
AS
SET NOCOUNT ON
-- 자신과 사제를 맺는지 확인한다.
IF @nPupils = @nCharNo
BEGIN
	SET @nRet = 1
	RETURN
END
-- 이미 기록이 된경우 확인, Flag만 바꾼다.
IF EXISTS( SELECT * FROM tMasterPupils WHERE (nMaster = @nCharNo) AND ( nPupils = @nPupils ) )
BEGIN
	UPDATE tMasterPupils SET nFlags = @nFlags WHERE (nMaster = @nCharNo) AND (nPupils = @nPupils)
	SET @nRet = @@ERROR
	RETURN
END
-- 제자가 4명이상 기록이 안되게 확인
DECLARE @PupilsCount int
SELECT @PupilsCount = COUNT(*) FROM tMasterPupils WHERE nMaster = @nCharNo
IF @PupilsCount >= 3
BEGIN
	SET @nRet = 2
	RETURN
END
-- 새로 추가된 제자 기록(스승이 2명이상 기록안되게 체크는 nPupils가 Alternative key로 확인된다)
INSERT tMasterPupils (  nMaster,  nPupils,  nFlags )
VALUES				 ( @nCharNo, @nPupils, @nFlags )
SET @nRet = @@ERROR
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Prison_Add]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Prison_Add]
GO
/****** 개체: 저장 프로시저 dbo.p_Prison_Add    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/



/*==================================================
@author	lenasoft
@date	2006-03-14
@return	0		<성공>
	others		<실패>
@brief	강금한다.
==================================================*/


CREATE PROCEDURE [dbo].[p_Prison_Add] 
@sGmUserID nvarchar(16),
@sImprison nvarchar(16),
@nMinute smallint,
@sReason nvarchar(16), 
@sRemark nvarchar(64),
@nImprisonRegNum int,
@err smallint OUTPUT


AS
SET NOCOUNT ON

DECLARE	
@nRet		int,
@nPrisonMin 	int

SET 		@err = 0

BEGIN TRAN


UPDATE tCharacter SET 
	nPrisonMin=@nMinute ,
	nLoginZoneX=896,
	nLoginZoneY=1122,
	sLoginZone='EldPri' 	
	WHERE nCharNo=@nImprisonRegNum


IF @@error <> 0 GOTO ERR

INSERT tPrison (nCharID,nMinute,sReason,sGmID,sRemark)
VALUES (@nImprisonRegNum,@nMinute,@sReason,@sGmUserID,@sRemark )
IF @@error <> 0 GOTO ERR

COMMIT TRAN
RETURN @@error

ERR:
ROLLBACK TRAN
return @@error

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Prison_Add2]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Prison_Add2]
GO
/****** 개체: 저장 프로시저 dbo.p_Prison_Add2    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/



/*==================================================
@author	lenasoft
@date	2006-03-14
@return	0		<성공>
	others		<실패>
@brief	강금한다.
	케릭터이름으로 강금한다.(오프라인인 사람 강금)
	MapInfo 파일에서 EldPri 부분 수정시 반드시 프로시져 수정해야함.
	nLoginZoneX=896,
	nLoginZoneY=1122,
	sLoginZone='EldPri' 
==================================================*/


CREATE PROCEDURE [dbo].[p_Prison_Add2]
@sGmUserID nvarchar(16),
@sImprison nvarchar(16),
@nMinute smallint,
@sReason nvarchar(16), 
@sRemark nvarchar(64),
@err smallint OUTPUT


AS
SET NOCOUNT ON

DECLARE	
@nRet		int,
@nPrisonMin 	int,
@nImprisonRegNum int 

SET 		@err = 0

	--케릭터ID가 존재하지 않습니다.
SELECT @nImprisonRegNum=nCharNo, @nPrisonMin=nPrisonMin FROM tCharacter(NOLOCK) WHERE sID=@sImprison 
IF @@ROWCOUNT = 0
BEGIN
	SET @err = 1
	RETURN @@error
END
	--이미 수감중입니다
IF @nPrisonMin <> 0
BEGIN

	SET @err = 2
	RETURN @@error
END

BEGIN TRAN

UPDATE tCharacter SET
 	nPrisonMin=@nMinute, 
	nLoginZoneX=896,
	nLoginZoneY=1122,
	sLoginZone='EldPri' 		
	WHERE nCharNo=@nImprisonRegNum
IF @@error <> 0 GOTO ERR

INSERT tPrison (nCharID,nMinute,sReason,sGmID,sRemark)
VALUES (@nImprisonRegNum,@nMinute,@sReason,@sGmUserID,@sRemark )
IF @@error <> 0 GOTO ERR

COMMIT TRAN
RETURN @@error

ERR:
ROLLBACK TRAN
return @@error

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Prison_Alter]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Prison_Alter]
GO
/****** 개체: 저장 프로시저 dbo.p_Prison_Alter    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/



/*==================================================
@author	lenasoft
@date	2006-03-14
@return	0		<성공>
	others		<실패>
@brief	강금변경한다.
==================================================*/


CREATE PROCEDURE [dbo].[p_Prison_Alter] 
@sGmUserID nvarchar(16),
@sImprison nvarchar(16),
@nMinute smallint,
@sReason nvarchar(16), 
@sRemark nvarchar(64),
@nImprisonRegNum int,
@err smallint OUTPUT


AS
SET NOCOUNT ON

DECLARE	
@nRet		int,
@nPrisonMin 	int

SET 		@err = 0

BEGIN TRAN

IF @nMinute = 0
	BEGIN
		UPDATE tCharacter SET
 		nPrisonMin=@nMinute, 
		nLoginZoneX=5963,
		nLoginZoneY=9793,
		sLoginZone='Rou' 		
		WHERE nCharNo=@nImprisonRegNum
	END
ELSE
	BEGIN
		UPDATE tCharacter SET
 		nPrisonMin=@nMinute, 
		nLoginZoneX=896,
		nLoginZoneY=1122,
		sLoginZone='EldPri' 		
		WHERE nCharNo=@nImprisonRegNum

	END

IF @@error <> 0 GOTO ERR

INSERT tPrison (nCharID,nMinute,sReason,sGmID,sRemark)
VALUES (@nImprisonRegNum,@nMinute,@sReason,@sGmUserID,@sRemark )
IF @@error <> 0 GOTO ERR

COMMIT TRAN
RETURN @@error

ERR:
ROLLBACK TRAN
return @@error

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Prison_Alter2]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Prison_Alter2]
GO
/****** 개체: 저장 프로시저 dbo.p_Prison_Alter2    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/



/*==================================================
@author	lenasoft
@date	2006-03-14
@return	0		<성공>
	others		<실패>
@brief	강금변경한다.
	케릭터이름으로 강금변경한다.(오프라인인 사람 강금변경)
	MapInfo 파일에서 EldPri 부분 수정시 반드시 프로시져 수정해야함.
	nLoginZoneX=896,
	nLoginZoneY=1122,
	sLoginZone='EldPri' 
==================================================*/


CREATE PROCEDURE [dbo].[p_Prison_Alter2]
@sGmUserID nvarchar(16),
@sImprison nvarchar(16),
@nMinute smallint,
@sReason nvarchar(16), 
@sRemark nvarchar(64),
@err smallint OUTPUT


AS
SET NOCOUNT ON

DECLARE	
@nRet		int,
@nPrisonMin 	int,
@nImprisonRegNum int 

SET 		@err = 0

	--케릭터ID가 존재하지 않습니다.
SELECT @nImprisonRegNum=nCharNo, @nPrisonMin=nPrisonMin FROM tCharacter(NOLOCK) WHERE sID=@sImprison 
IF @@ROWCOUNT = 0
BEGIN
	SET @err = 1
	RETURN @@error
END

--수감중이 아닐때...
IF @nPrisonMin = 0
BEGIN

	SET @err = 2
	RETURN @@error
END

BEGIN TRAN
IF @nMinute = 0
	BEGIN
		UPDATE tCharacter SET
 		nPrisonMin=@nMinute, 
		nLoginZoneX=5963,
		nLoginZoneY=9793,
		sLoginZone='Rou' 		
		WHERE nCharNo=@nImprisonRegNum
	END
ELSE
	BEGIN
		UPDATE tCharacter SET
 		nPrisonMin=@nMinute, 
		nLoginZoneX=896,
		nLoginZoneY=1122,
		sLoginZone='EldPri' 		
		WHERE nCharNo=@nImprisonRegNum

	END

IF @@error <> 0 GOTO ERR

INSERT tPrison (nCharID,nMinute,sReason,sGmID,sRemark)
VALUES (@nImprisonRegNum,@nMinute,@sReason,@sGmUserID,@sRemark )
IF @@error <> 0 GOTO ERR

COMMIT TRAN
RETURN @@error

ERR:
ROLLBACK TRAN
return @@error

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Prison_End]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Prison_End]
GO
/****** 개체: 저장 프로시저 dbo.p_Prison_End    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/



/*==================================================
@author	lenasoft
@date	2006-03-18
@return	0		<성공>
	others		<실패>
@brief	출소한다.
==================================================*/


CREATE PROCEDURE [dbo].[p_Prison_End] 
@nImprisonRegNum	int

AS
SET NOCOUNT ON

UPDATE tCharacter SET 	nLoginZoneX=5963, 
			nLoginZoneY=9793, 
			nLoginZoneD=90,
			sLoginZone='Rou', 
			nPrisonMin=0 
	WHERE nCharNo=@nImprisonRegNum

RETURN @@error

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Prison_Get]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Prison_Get]
GO
/****** 개체: 저장 프로시저 dbo.p_Prison_Get    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/



/*==================================================
@author	lenasoft
@date	2006-03-22
@return	0		<성공>
	others		<실패>
@brief	감금정보를 얻는다.
	tCharacter 테이블에 nPrisonNum필드를 넣어줘야 정확하지만
	최소한의 수정을 위해서 일단 Top을 사용함.
==================================================*/


CREATE PROCEDURE [dbo].[p_Prison_Get] 
@nCharID	int


AS
SET NOCOUNT ON

SELECT TOP 1 sReason, sRemark FROM tPrison
WHERE nCharID = @nCharID 
ORDER BY dPrisonDate DESC

RETURN @@error

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Prison_UpdateCharPrisonMin]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Prison_UpdateCharPrisonMin]
GO
/****** 개체: 저장 프로시저 dbo.p_Prison_UpdateCharPrisonMin    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/



/*==================================================
@author	lenasoft
@date	2006-03-14
@return	0		<성공>
	others		<실패>
@brief	강금시간 업데이트한다.
==================================================*/


CREATE PROCEDURE [dbo].[p_Prison_UpdateCharPrisonMin] 
@nImprisonRegNum	int, 
@nMinute		smallint

AS
SET NOCOUNT ON

--감옥시간과 로긴존과의 동기화를 위해서 꼭!!! 같이 업데이트 해줘야함.
IF @nMinute = 0
	BEGIN
		UPDATE tCharacter SET
 		nPrisonMin=@nMinute, 
		nLoginZoneX=5963,
		nLoginZoneY=9793,
		sLoginZone='Rou' 		
		WHERE nCharNo=@nImprisonRegNum
	END
ELSE
	BEGIN
		UPDATE tCharacter SET
 		nPrisonMin=@nMinute, 
		sLoginZone='EldPri' 		
		WHERE nCharNo=@nImprisonRegNum

	END

RETURN @@error

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Quest_Add]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Quest_Add]
GO
/****** 개체: 저장 프로시저 dbo.p_Quest_Add    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/


CREATE PROCEDURE [dbo].[p_Quest_Add]
/*
Quest Set
2004.10 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/
@nCharNo int,
@nQuestNo int,
@nStatus tinyint,
@sData varbinary(100),
@nRet int OUTPUT

AS

SET NOCOUNT ON

INSERT tQuest (  nCharNo,  nQuestNo,  nStatus,  sData )
VALUES        ( @nCharNo, @nQuestNo, @nStatus, @sData )

SET @nRet = @@ERROR

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Quest_Del]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Quest_Del]
GO
/****** 개체: 저장 프로시저 dbo.p_Quest_Del    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/


CREATE PROCEDURE [dbo].[p_Quest_Del]
/*
Quest Delete
2004.10 By CJC
 input:
	nCharNo, nQuestNo = To be delete info.
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/
@nCharNo int,
@nQuestNo int,
@nRet int OUTPUT

AS

SET NOCOUNT ON

DELETE FROM tQuest WHERE nCharNo = @nCharNo AND nQuestNo = @nQuestNo
IF (@@ERROR=0) AND (@@ROWCOUNT=1)
	SET @nRet = 0
ELSE
	SET @nRet = 1
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Quest_Get]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Quest_Get]
GO
/****** 개체: 저장 프로시저 dbo.p_Quest_Get    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/


CREATE PROCEDURE [dbo].[p_Quest_Get]
/*
Quest Get
2004.10 By CJC
 input:
	see SQL
 output:
	@nRet	0 = No data found
	        ? = Number data here(must to be 1)
*/
@nCharNo int,
@nQuestNo int,
@nStatus tinyint OUTPUT,
@sData varbinary(100) OUTPUT,
@nRet int OUTPUT

AS

SET NOCOUNT ON

SELECT 
	@nStatus = nStatus, 
	@sData = sData
FROM tQuest WHERE nCharNo = @nCharNo AND nQuestNo = @nQuestNo

SET @nRet = @@ROWCOUNT

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Quest_GetAll]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Quest_GetAll]
GO
/****** 개체: 저장 프로시저 dbo.p_Quest_GetAll    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/


CREATE PROCEDURE [dbo].[p_Quest_GetAll]
/*
Quest Get All
2004.10 By CJC
 input:
	see SQL
 output:
	fetch to take data
*/

@nCharNo int

AS

SET NOCOUNT ON

SELECT nQuestNo, nStatus, sData FROM tQuest WHERE nCharNo = @nCharNo

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Quest_GetAllDoing]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Quest_GetAllDoing]
GO
/****** 개체: 저장 프로시저 dbo.p_Quest_GetAllDoing    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/


CREATE PROCEDURE [dbo].[p_Quest_GetAllDoing]
/*
Quest Get All
2004.10 By CJC
 input:
	see SQL
 output:
	fetch to take data
*/

@nCharNo int,
@nStatusDone tinyint

AS

SET NOCOUNT ON

SELECT nQuestNo, nStatus, sData FROM tQuest WHERE nCharNo = @nCharNo AND nStatus <> @nStatusDone

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Quest_GetAllDone]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Quest_GetAllDone]
GO
/****** 개체: 저장 프로시저 dbo.p_Quest_GetAllDone    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/


CREATE PROCEDURE [dbo].[p_Quest_GetAllDone]
/*
Quest Get All
2004.10 By CJC
 input:
	see SQL
 output:
	fetch to take data
*/

@nCharNo int,
@nStatusDone tinyint

AS

SET NOCOUNT ON

SELECT nQuestNo FROM tQuest WHERE nCharNo = @nCharNo AND nStatus = @nStatusDone

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Quest_Set]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Quest_Set]
GO

CREATE PROCEDURE [dbo].[p_Quest_Set]
/*
Quest Set
2004.10 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/
@nCharNo int,
@nQuestNo int,
@nStatus tinyint,
@sData varbinary(100),
@nRet int OUTPUT
AS

SET NOCOUNT ON

--------------------------------------------------------- add start
-- added by CJC for for wedding quest 2008-06-03
DECLARE @nOldStatus tinyint
IF EXISTS(SELECT nStatus FROM tQuest WHERE nCharNo=@nCharNo and nQuestNo=@nQuestNo)
	SELECT @nOldStatus = nStatus FROM tQuest WHERE nCharNo = @nCharNo AND nQuestNo = @nQuestNo
ELSE
	SET @nOldStatus = 0
--------------------------------------------------------- add end

UPDATE tQuest SET 
    nStatus = @nStatus,
	sData = @sData
WHERE nCharNo = @nCharNo AND nQuestNo = @nQuestNo

IF @@ERROR <> 0 OR @@ROWCOUNT = 0
BEGIN
	INSERT tQuest (  nCharNo,  nQuestNo,  nStatus,  sData )
	VALUES        ( @nCharNo, @nQuestNo, @nStatus, @sData )
END

--------------------------------------------------------- add start
--added by Amadeus for wedding quest 2008-05-29, modify by CJC 2008-06-03
-- nStatus 4 = PQS_REPEAT, Repeat quest done, now re-acceptable.
-- nStatus 6 = PQS_REWARD, in progress
--63011, wedding planner2.
IF @nStatus = 4 and @nQuestNo=20016 and @nOldStatus = 6
BEGIN
	IF EXISTS(SELECT nCharNo FROM tQuestTimes WHERE nCharNo=@nCharNo and nQuestNo=@nQuestNo)
		BEGIN
			UPDATE tQuestTimes SET nTimes=nTimes+1, dLastComplete=getdate()
			WHERE nCharNo=@nCharNo and nQuestNo=@nQuestNo
		END
	ELSE
		BEGIN
			INSERT tQuestTimes 
			VALUES(@nCharNo, @nQuestNo, 1, getdate())
		END
END
--------------------------------------------------------- end of edit by Amadeus

SET @nRet = @@ERROR
--end




GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Set_Guild_Academy_Reward_Record]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Set_Guild_Academy_Reward_Record]
GO

/****** 개체: 저장 프로시저 dbo.p_Char_Delete    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Set_Guild_Academy_Reward_Record]


/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_GuildAcademy_setReward
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.5.8.
' Description :
'   ±æµå¾ÆÄ«µ¥¹Ì º¸»ó ¼³Á¤
' Parameter :
'	input Parameter
'		@nNo 	 : ±æµå¹øÈ£
'		@nLevel  : ·¹º§
'		@nTypeID : º¸»óÅ¸ÀÔ
'		@nValue  : º¸»ó°ª
'		@nItemID : ¾ÆÀÌÅÛ
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1513 : invaild nLevel
'				-1595 : db error(select)
'-------------------------------------------------------------------------------------*/
	@nNo     int
,	@nLevel  smallint
,	@nTypeID tinyint
,	@nValue  bigint
,	@nItemID int = NULL
,	@nRet    int = 0 output

AS
BEGIN
SET NOCOUNT ON

	SET @nRet = 0

	IF @nLevel <= 0 BEGIN
		SET @nRet = -1513
		RETURN
	END
	
	INSERT INTO tGuildAcademyReward (nNo, nLevel, nTypeID, nValue, nItemID)
	VALUES (@nNo, @nLevel, @nTypeID, @nValue, @nItemID)
	IF @@ERROR <> 0 BEGIN
		SET @nRet = -1595
		RETURN
	END
	SET NOCOUNT OFF
END



GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Skill_Del]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Skill_Del]
GO
/****** 개체: 저장 프로시저 dbo.p_Skill_Del    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Skill_Del]
/*
Skill Delete
2004.10 By CJC
 input:
	nCharNo, nSkillNo = To be delete info.
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/
@nCharNo int,
@nSkillNo smallint,
@nRet int OUTPUT
AS
SET NOCOUNT ON
-- 아이템 삭제 옵션
DELETE FROM tSkill WHERE nCharNo = @nCharNo AND nSkillNo = @nSkillNo
SET @nRet = @@ERROR
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Skill_Get]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Skill_Get]
GO
/****** 개체: 저장 프로시저 dbo.p_Skill_Get    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Skill_Get]
/*
Skill Get
2004.10 By CJC
 input:
	see SQL
 output:
	@nRet	0 = No data found
	        ? = Number data here(must to be 1)
*/
@nCharNo int,
@nSkillNo smallint,
@nSkillLevel tinyint OUTPUT,
@nSkillExp int OUTPUT,
@nSkillWriteTime bigint OUTPUT,
@nSkillCoolTime int OUTPUT,
@nSkillPowerDemage tinyint OUTPUT,
@nSkillPowerSP tinyint OUTPUT,
@nSkillPowerKeepTime tinyint OUTPUT,
@nSkillPowerCoolTime tinyint OUTPUT,
@nRet int OUTPUT
AS
SET NOCOUNT ON
SELECT 
	@nSkillLevel		= nSkillLevel,
	@nSkillExp			= nSkillExp,
	@nSkillWriteTime	= nSkillWriteTime,
	@nSkillCoolTime		= nSkillCoolTime,
	@nSkillPowerDemage	= nSkillPowerDemage,
	@nSkillPowerSP		= nSkillPowerSP,
	@nSkillPowerKeepTime = nSkillPowerKeepTime,
	@nSkillPowerCoolTime = nSkillPowerCoolTime
FROM tSkill WHERE nCharNo = @nCharNo AND nSkillNo = @nSkillNo
SET @nRet = @@ROWCOUNT
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Skill_GetAll]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Skill_GetAll]
GO
/****** 개체: 저장 프로시저 dbo.p_Skill_GetAll    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/



CREATE PROCEDURE [dbo].[p_Skill_GetAll]
/*
Skill Get All
2004.10 By CJC
 input:
	see SQL
 output:
	fetch to take data
*/
@nCharNo int
AS
SET NOCOUNT ON
SELECT	nSkillNo, nSkillLevel, nSkillExp, nSkillWriteTime, nSkillCoolTime, 
		nSkillPowerDemage, nSkillPowerSP, nSkillPowerKeepTime, nSkillPowerCoolTime
FROM tSkill WHERE nCharNo = @nCharNo
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Skill_GetNumOfSkill]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Skill_GetNumOfSkill]
GO
/****** 개체: 저장 프로시저 dbo.p_Skill_GetNumOfSkill    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Skill_GetNumOfSkill]
/*
Skill Get Num of skill
2005.5 By CJC
 input:
	see SQL
 output:
	fetch to take data
*/
@nCharNo int,
@nNumOfSkill int OUTPUT
AS
SET NOCOUNT ON
SET @nNumOfSkill = 0
SELECT @nNumOfSkill = COUNT(*) FROM tSkill WHERE nCharNo = @nCharNo
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Skill_ResetPower]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Skill_ResetPower]
GO
/****** 개체: 저장 프로시저 dbo.p_Skill_ResetPower    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/


CREATE PROCEDURE [dbo].[p_Skill_ResetPower]
/*
Skill Reset Power
2005.6 By CJC
 input:
	see SQL
 output:
	@nRet	1 = OK, 
	        0 = Error
*/
@nCharNo int,
@nRet int OUTPUT
AS
SET NOCOUNT ON
DECLARE @nFlagsTemp AS int
SET @nRet = 0 -- set error first
SELECT @nFlagsTemp = nFlags FROM tCharacter WHERE nCharNo = @nCharNo
IF @@ROWCOUNT = 0
	RETURN
BEGIN TRAN
SET @nFlagsTemp = @nFlagsTemp & 0x7fffffff -- Clear skillempower_can_reset's Bit
UPDATE tCharacter SET nFlags = @nFlagsTemp WHERE nCharNo = @nCharNo
UPDATE tSkill SET 
	nSkillPowerDemage	= 0,
	nSkillPowerSP		= 0,
	nSkillPowerKeepTime = 0,
	nSkillPowerCoolTime = 0
WHERE nCharNo = @nCharNo
IF @@ERROR <> 0
BEGIN
	ROLLBACK TRAN
	RETURN
END
COMMIT TRAN
SET @nRet = 1 -- no error return
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Skill_Set]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Skill_Set]
GO
/****** 개체: 저장 프로시저 dbo.p_Skill_Set    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/
 

CREATE PROCEDURE [dbo].[p_Skill_Set]
/*
Skill Set
2004.10 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/
@nCharNo int,
@nSkillNo smallint,
@nSkillLevel tinyint,
@nSkillExp int,
@nSkillWriteTime bigint,
@nSkillCoolTime int,
@nSkillPowerDemage tinyint,
@nSkillPowerSP tinyint,
@nSkillPowerKeepTime tinyint,
@nSkillPowerCoolTime tinyint,
@nRet int OUTPUT
AS
SET NOCOUNT ON
UPDATE tSkill SET
	nSkillLevel			= @nSkillLevel,
	nSkillExp			= @nSkillExp,
	nSkillWriteTime		= @nSkillWriteTime,
	nSkillCoolTime		= @nSkillCoolTime,
	nSkillPowerDemage	= @nSkillPowerDemage,
	nSkillPowerSP		= @nSkillPowerSP,
	nSkillPowerKeepTime = @nSkillPowerKeepTime,
	nSkillPowerCoolTime = @nSkillPowerCoolTime
WHERE nCharNo = @nCharNo AND nSkillNo = @nSkillNo
IF @@ERROR <> 0 OR @@ROWCOUNT = 0
BEGIN
	INSERT tSkill (  nCharNo,  nSkillNo,  nSkillLevel,  nSkillExp,  nSkillWriteTime,  nSkillCoolTime,  nSkillPowerDemage,  nSkillPowerSP,  nSkillPowerKeepTime,  nSkillPowerCoolTime )
	VALUES        ( @nCharNo, @nSkillNo, @nSkillLevel, @nSkillExp, @nSkillWriteTime, @nSkillCoolTime, @nSkillPowerDemage, @nSkillPowerSP, @nSkillPowerKeepTime, @nSkillPowerCoolTime )
END
SET @nRet = @@ERROR
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Skill_SetCoolTime]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Skill_SetCoolTime]
GO
/****** 개체: 저장 프로시저 dbo.p_Skill_SetCoolTime    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Skill_SetCoolTime]
/*
Skill Set Cool Time
2004.10 By CJC
 input:
	see SQL
 output:
	@nRet	1 = OK, 
	        0 = Error
*/
@nCharNo int,
@nSkillNo smallint,
@nSkillWriteTime bigint,
@nSkillCoolTime int,
@nRet int OUTPUT
AS
SET NOCOUNT ON
UPDATE tSkill SET
	nSkillWriteTime = @nSkillWriteTime,
	nSkillCoolTime	= @nSkillCoolTime
WHERE nCharNo = @nCharNo AND nSkillNo = @nSkillNo
IF @@ERROR <> 0 OR @@ROWCOUNT = 0
	SET @nRet = 0
ELSE
	SET @nRet = 1
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Skill_SetPassive]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Skill_SetPassive]
GO
/****** 개체: 저장 프로시저 dbo.p_Skill_SetPassive    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


CREATE PROCEDURE [dbo].[p_Skill_SetPassive]
/*
Skill Set Passive
2005.6 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK, 
	        ? = Error code
*/

@nCharNo int,
@nSkillNewNo smallint,
@bSkillOld tinyint,
@nSkillOldNo smallint,
@nRet int OUTPUT

AS

SET NOCOUNT ON

IF @bSkillOld = 1
BEGIN
	UPDATE tSkill 
	SET nSkillNo = @nSkillNewNo
	WHERE nCharNo = @nCharNo AND nSkillNo = @nSkillOldNo
	
	IF @@ERROR <> 0 OR @@ROWCOUNT = 0
		SET @nRet = 1 -- ERROR, No existed old skill
	ELSE
		SET @nRet = 0
		
	RETURN
END

INSERT tSkill (  nCharNo,     nSkillNo )
VALUES        ( @nCharNo, @nSkillNewNo )

SET @nRet = @@ERROR

-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Skill_SetPower]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Skill_SetPower]
GO
CREATE PROCEDURE [dbo].[p_Skill_SetPower]
/*
Skill Set Power
2005.6 By CJC
 input:
	see SQL
 output:
	@nRet	1 = OK, 
	        0 = Error
*/
@nCharNo int,
@nSkillNo smallint,
@nSkillPowerSlot tinyint,
@nSkillPowerValue tinyint,
@nRet int OUTPUT
AS
BEGIN
	SET NOCOUNT ON

	IF @nSkillPowerValue > 5 BEGIN
		SET @nRet = 0
		RETURN
	END
	
	-- nSkillPowerDemage
	IF @nSkillPowerSlot = 0
	BEGIN
		UPDATE tSkill SET nSkillPowerDemage = @nSkillPowerValue WHERE nCharNo = @nCharNo AND nSkillNo = @nSkillNo
		IF @@ERROR <> 0 OR @@ROWCOUNT = 0
			SET @nRet = 0
		ELSE
			SET @nRet = 1
		RETURN
	END
	-- nSkillPowerSP
	IF @nSkillPowerSlot = 1
	BEGIN
		UPDATE tSkill SET nSkillPowerSP = @nSkillPowerValue WHERE nCharNo = @nCharNo AND nSkillNo = @nSkillNo
		IF @@ERROR <> 0 OR @@ROWCOUNT = 0
			SET @nRet = 0
		ELSE
			SET @nRet = 1
		RETURN
	END
	-- nSkillPowerKeepTime
	IF @nSkillPowerSlot = 2
	BEGIN
		UPDATE tSkill SET nSkillPowerKeepTime = @nSkillPowerValue WHERE nCharNo = @nCharNo AND nSkillNo = @nSkillNo
		IF @@ERROR <> 0 OR @@ROWCOUNT = 0
			SET @nRet = 0
		ELSE
			SET @nRet = 1
		RETURN
	END
	-- nSkillPowerCoolTime
	IF @nSkillPowerSlot = 3
	BEGIN
		UPDATE tSkill SET nSkillPowerCoolTime = @nSkillPowerValue WHERE nCharNo = @nCharNo AND nSkillNo = @nSkillNo
		IF @@ERROR <> 0 OR @@ROWCOUNT = 0
			SET @nRet = 0
		ELSE
			SET @nRet = 1
		RETURN
	END
	-- ERROR
	SET @nRet = 0;
	-- end
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_Skill_SetPowerAll]
-- ----------------------------
DROP PROCEDURE [dbo].[p_Skill_SetPowerAll]
GO
CREATE PROCEDURE [dbo].[p_Skill_SetPowerAll]
/*
Skill Set Power All
2005.6 By CJC
 input:
	see SQL
 output:
	@nRet	1 = OK, 
	        0 = Error
*/
@nCharNo int,
@nSkillNo smallint,
@nSkillPowerDemage tinyint,
@nSkillPowerSP tinyint,
@nSkillPowerKeepTime tinyint,
@nSkillPowerCoolTime tinyint,
@nRet int OUTPUT
AS
BEGIN
	SET NOCOUNT ON
	
	IF @nSkillPowerDemage > 5 OR @nSkillPowerSP > 5 OR @nSkillPowerKeepTime > 5 OR @nSkillPowerCoolTime > 5 BEGIN
		SET @nRet = 0
		RETURN
	END
	
	UPDATE tSkill SET 
		nSkillPowerDemage	= @nSkillPowerDemage,
		nSkillPowerSP		= @nSkillPowerSP,
		nSkillPowerKeepTime	= @nSkillPowerKeepTime,
		nSkillPowerCoolTime	= @nSkillPowerCoolTime
	WHERE nCharNo = @nCharNo AND nSkillNo = @nSkillNo
	IF @@ERROR <> 0 OR @@ROWCOUNT = 0
		SET @nRet = 0
	ELSE
		SET @nRet = 1
	-- end
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_User_Deposit]
-- ----------------------------
DROP PROCEDURE [dbo].[p_User_Deposit]
GO
/****** 개체: 저장 프로시저 dbo.p_User_Deposit    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/
CREATE PROCEDURE [dbo].[p_User_Deposit]
/*
Set User deposit money
2006.5 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Miss match UserNo and User's CharNo
	        2 = Char Money Sub Failed(Not enough money)
	        3 = Add deposit money faield
	        4 = Get result money faield
*/
@nUserNo int,
@nCharNo int,
@nMoney bigint,
@nResultUserMoney bigint OUTPUT,
@nRet tinyint OUTPUT
AS

SET NOCOUNT ON

SET @nRet = 0

-- Check UserNo and User's CharNo
DECLARE @nDBUserNo int
SET @nDBUserNo = 0

SELECT @nDBUserNo = nUserNo FROM tCharacter WHERE nCharNo = @nCharNo
IF @nDBUserNo <> @nUserNo
BEGIN
	SET @nRet = 1
	RETURN
END

-- Deposit money
BEGIN TRAN

EXEC p_Char_MoneySub @nCharNo, @nMoney, @nRet OUTPUT
IF @nRet <> 1
BEGIN
	SET @nRet = 2
	ROLLBACK TRAN
	RETURN
END

EXEC p_User_MoneyAdd @nUserNo, @nMoney, @nRet OUTPUT
IF @nRet <> 1
BEGIN
	SET @nRet = 3
	ROLLBACK TRAN
	RETURN
END

EXEC p_User_MoneyGet @nUserNo, @nResultUserMoney OUTPUT, @nRet OUTPUT
IF @nRet <> 1
BEGIN
	SET @nRet = 4
	ROLLBACK TRAN
	RETURN
END

-- Done
COMMIT TRAN

SET @nRet = 0
RETURN

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_User_MoneyAdd]
-- ----------------------------
DROP PROCEDURE [dbo].[p_User_MoneyAdd]
GO
/****** 개체: 저장 프로시저 dbo.p_User_MoneyAdd    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/
CREATE PROCEDURE [dbo].[p_User_MoneyAdd]
/*
Add user money
2005.5 By CJC
 input:
	see SQL
 output:
	@nRet	1 = OK
	        0 = Error
*/
@nUserNo int,
@nAddMoney bigint,
@nRet tinyint OUTPUT

AS

SET NOCOUNT ON

IF @nAddMoney < 0
BEGIN
	SET @nRet = 0
	RETURN
END

DECLARE @nUserMoney bigint
EXEC p_User_MoneyGet @nUserNo, @nUserMoney OUTPUT, @nRet OUTPUT
IF @nRet = 0
	RETURN
-- Add money
SET @nUserMoney = @nUserMoney + @nAddMoney
EXEC p_User_MoneySet @nUserNo, @nUserMoney, @nRet OUTPUT
-- End

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_User_MoneyGet]
-- ----------------------------
DROP PROCEDURE [dbo].[p_User_MoneyGet]
GO
/****** 개체: 저장 프로시저 dbo.p_User_MoneyGet    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/
CREATE PROCEDURE [dbo].[p_User_MoneyGet]
/*
Get user money
2005.5 By CJC
 input:
	see SQL
 output:
	@nRet	1 = OK, Money return
	        0 = Error
*/
@nUserNo int,
@nUserMoney bigint OUTPUT,
@nRet tinyint OUTPUT

AS

SET NOCOUNT ON

SET @nRet = 0

-- 돈 얻기
IF EXISTS(SELECT nUserMoney FROM tUserMoney WHERE nUserNo = @nUserNo )
BEGIN
	SELECT @nUserMoney = nUserMoney FROM tUserMoney WHERE nUserNo = @nUserNo
	IF @@ROWCOUNT = 1
		SET @nRet = 1
	RETURN 
END

-- First access
SET @nUserMoney = 0
INSERT INTO tUserMoney VALUES (@nUserNo, @nUserMoney)
IF @@ROWCOUNT = 1 AND @@ERROR = 0
	SET @nRet = 1
	
RETURN 

-- End

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_User_MoneyGetGreaterThen]
-- ----------------------------
DROP PROCEDURE [dbo].[p_User_MoneyGetGreaterThen]
GO
/****** 개체: 저장 프로시저 dbo.p_User_MoneyGetGreaterThen    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/
/*
-----------------------------------
SadPig : 2006.9.5 (OPTool)
	Input Parameter
		@nMoney : Money

	Output Parameter
		int nUserNo;
		__int64 nUserMoney;
-----------------------------------
*/
CREATE PROCEDURE [dbo].[p_User_MoneyGetGreaterThen]
	@nMoney		bigint
AS

BEGIN
	SET NOCOUNT ON
	SET LOCK_TIMEOUT 5000

	SELECT nUserNo, nUserMoney FROM tUserMoney WHERE nUserMoney >=  @nMoney
	
	SET LOCK_TIMEOUT -1
	SET NOCOUNT OFF	
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_User_MoneySet]
-- ----------------------------
DROP PROCEDURE [dbo].[p_User_MoneySet]
GO
/****** 개체: 저장 프로시저 dbo.p_User_MoneySet    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/
 CREATE PROCEDURE [dbo].[p_User_MoneySet]
/*
Set user money
2006.5 By CJC
 input:
	see SQL
 output:
	@nRet	1 = OK
	        0 = Error
*/
@nUserNo int,
@nSetMoney bigint,
@nRet tinyint OUTPUT
AS
SET NOCOUNT ON
SET @nRet = 0

IF EXISTS( SELECT nUserMoney FROM tUserMoney WHERE nUserNo = @nUserNo )
BEGIN
	UPDATE tUserMoney SET nUserMoney = @nSetMoney WHERE nUserNo = @nUserNo
	IF @@ERROR <> 0
		RETURN
END
ELSE
BEGIN
	INSERT INTO tUserMoney VALUES (@nUserNo, @nSetMoney)
	IF @@ERROR <> 0
		RETURN
END

-- DONE
SET @nRet = 1
RETURN

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_User_MoneySub]
-- ----------------------------
DROP PROCEDURE [dbo].[p_User_MoneySub]
GO
/****** 개체: 저장 프로시저 dbo.p_User_MoneySub    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/
CREATE PROCEDURE [dbo].[p_User_MoneySub]
/*
Sub user money
2005.5 By CJC
 input:
	see SQL
 output:
	@nRet	1 = OK
	        0 = Error, or Minus value
*/
@nUserNo int,
@nSubMoney bigint,
@nRet tinyint OUTPUT

AS

SET NOCOUNT ON

IF @nSubMoney < 0
BEGIN
	SET @nRet = 0
	RETURN
END

DECLARE @nUserMoney bigint
EXEC p_User_MoneyGet @nUserNo, @nUserMoney OUTPUT, @nRet OUTPUT
IF @nRet = 0
	RETURN
-- Sub money
SET @nUserMoney = @nUserMoney - @nSubMoney
-- Check minus
IF @nUserMoney < 0
BEGIN
	SET @nRet = 0
	RETURN	
END
EXEC p_User_MoneySet @nUserNo, @nUserMoney, @nRet OUTPUT
-- End

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_User_Withdraw]
-- ----------------------------
DROP PROCEDURE [dbo].[p_User_Withdraw]
GO
/****** 개체: 저장 프로시저 dbo.p_User_Withdraw    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/
CREATE PROCEDURE [dbo].[p_User_Withdraw]
/*
Set User withdraw money
2006.5 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Miss match UserNo and User's CharNo
	        2 = User Money Sub Failed(Not enough money)
	        3 = Withdraw money faield
	        4 = Get result money faield
*/
@nUserNo int,
@nCharNo int,
@nMoney bigint,
@nResultUserMoney bigint OUTPUT,
@nRet tinyint OUTPUT
AS

SET NOCOUNT ON

SET @nRet = 0

-- Check UserNo and User's CharNo
DECLARE @nDBUserNo int
SET @nDBUserNo = 0

SELECT @nDBUserNo = nUserNo FROM tCharacter WHERE nCharNo = @nCharNo
IF @nDBUserNo <> @nUserNo
BEGIN
	SET @nRet = 1
	RETURN
END

-- Deposit money
BEGIN TRAN

EXEC p_User_MoneySub @nUserNo, @nMoney, @nRet OUTPUT
IF @nRet <> 1
BEGIN
	SET @nRet = 2
	ROLLBACK TRAN
	RETURN
END

EXEC p_Char_MoneyAdd @nCharNo, @nMoney, @nRet OUTPUT
IF @nRet <> 1
BEGIN
	SET @nRet = 3
	ROLLBACK TRAN
	RETURN
END

EXEC p_User_MoneyGet @nUserNo, @nResultUserMoney OUTPUT, @nRet OUTPUT
IF @nRet <> 1
BEGIN
	SET @nRet = 4
	ROLLBACK TRAN
	RETURN
END

-- Done
COMMIT TRAN

SET @nRet = 0
RETURN

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_View_GetData]
-- ----------------------------
DROP PROCEDURE [dbo].[p_View_GetData]
GO
/****** 개체: 저장 프로시저 dbo.p_View_GetData    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/


/*
'--------------------------------------------------------------------------------------
' 함수명 : p_View_GetData
' 내  용 : OPTool Char& Item View에서 사용. OPTool에서 입력한 쿼리문에 맞는 데이터 서치.
' 작성자 : 이병기
' 작성일 : 2005년 10월 25일
' 버  젼 : 1.0
' 인  자 :
'			input Parameter
'				@QueryExpr		: OPTool 에서 입력한 쿼리문
'			Output Parameter
'				
'			RETURN_VALUE
'
'--------------------------------------------------------------------------------------
*/


CREATE PROCEDURE [dbo].[p_View_GetData]
	@QueryExpr nvarchar(512)

AS
BEGIN
	SET NOCOUNT ON
	DECLARE @SQLCMD nvarchar(512)
	SET @SQLCMD = @QueryExpr
	EXEC sp_executesql @SQLCMD
	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Char_GetAutoPick]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Char_GetAutoPick]
GO



CREATE PROCEDURE [dbo].[usp_Char_GetAutoPick]
/*
2009.6 By temlost
 input:
	see SQL
 output:
	= 0 No Error
	< 0 Error
*/

@nCharNo		int,
@nRet			int OUTPUT

AS
BEGIN

	SET NOCOUNT ON

	-- 삭제되지 않은 실존하는 케릭터인지 검색
	IF NOT EXISTS(SELECT nCharNo FROM tCharacter WHERE nCharNo = @nCharNo and bDeleted = 0)
	BEGIN
		SET @nRet = -4444
		RETURN
	END

	IF EXISTS(SELECT nCharNo, IsAutoPick FROM tAutoPick WHERE nCharNo = @nCharNo)
	BEGIN
		SELECT IsAutoPick FROM tAutoPick WHERE nCharNo = @nCharNo
		SET @nRet = 0
		RETURN
	END
	ELSE
	BEGIN
--		SELECT nCharNo, getdate() FROM tAutoPick WHERE nCharNo = @nCharNo
		SET @nRet = 0
		RETURN
	END
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Char_GetRestExpExecTime]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Char_GetRestExpExecTime]
GO



CREATE PROCEDURE [dbo].[usp_Char_GetRestExpExecTime]
/*
get cen reward
2009.4 By Luunar
 input:
	see SQL
 output:
	= 0 No Error
	< 0 Error
*/

@nCharNo		int,
@nRet			int OUTPUT

AS
BEGIN

	SET NOCOUNT ON

	IF EXISTS(SELECT nCharNo, dRestExpLastExcuteTime FROM tRestExp WHERE nCharNo = @nCharNo)
	BEGIN
		SELECT dRestExpLastExcuteTime FROM tRestExp WHERE nCharNo = @nCharNo
		SET @nRet = 0
		RETURN
	END
	ELSE
	BEGIN
--		SELECT nCharNo, getdate() FROM tRestExp WHERE nCharNo = @nCharNo
		SELECT getdate()
		SET @nRet = 0
		RETURN
	END
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Char_SetAutoPick]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Char_SetAutoPick]
GO



CREATE PROCEDURE [dbo].[usp_Char_SetAutoPick]
/*
get cen reward
2009.4 By Luunar
 input:
	see SQL
 output:
	= 0 No Error
	< 0 Error
*/

@nCharNo		int,
@nIsAutoPick		tinyint,
@nRet			int OUTPUT

AS
BEGIN

	SET NOCOUNT ON

	-- 삭제되지 않은 실존하는 케릭터인지 검색
	IF NOT EXISTS(SELECT nCharNo FROM tCharacter WHERE nCharNo = @nCharNo and bDeleted = 0)
	BEGIN
		SET @nRet = -5654;
		RETURN
	END

	IF EXISTS(SELECT nCharNo, IsAutoPick FROM tAutoPick WHERE nCharNo = @nCharNo)
	BEGIN
		UPDATE tAutoPick
		SET IsAutoPick = @nIsAutoPick
		WHERE nCharNo = @nCharNo

		SET @nRet = 0
		RETURN
	END
	ELSE
	BEGIN
		INSERT INTO tAutoPick (nCharNo, IsAutoPick)
		VALUES (@nCharNo, @nIsAutoPick)

		SET @nRet = 0
		RETURN
	END
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Char_SetRestExpExecTime]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Char_SetRestExpExecTime]
GO



CREATE PROCEDURE [dbo].[usp_Char_SetRestExpExecTime]
/*
get cen reward
2009.4 By Luunar
 input:
	see SQL
 output:
	= 0 No Error
	< 0 Error
*/

@nCharNo		int,
@nRet			int OUTPUT

AS
BEGIN

	SET NOCOUNT ON

	-- 존재하지 않는 케릭터가 요청으로 들어오면 에러
	IF NOT EXISTS(SELECT nCharNo FROM tCharacter WHERE nCharNo = @nCharNo)
	BEGIN
		SET @nRet = -5654;
		RETURN
	END

	IF EXISTS(SELECT nCharNo, dRestExpLastExcuteTime FROM tRestExp WHERE nCharNo = @nCharNo)
	BEGIN
		UPDATE tRestExp
		SET dRestExpLastExcuteTime = getdate()
		WHERE nCharNo = @nCharNo

		SET @nRet = 0
		RETURN
	END
	ELSE
	BEGIN
		INSERT INTO tRestExp (nCharNo, dRestExpLastExcuteTime)
		VALUES (@nCharNo, getdate())

		SET @nRet = 0
		RETURN
	END
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Character_getChangeIDList]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Character_getChangeIDList]
GO
/*--------------------------------------------------------------------------------------
' 이  름 : usp_Character_getChangeIDList
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2010.7.28.
' Description :
'   서버메모리에 미반영된 캐릭터정보를 가져옴
' Parameter :
'	input Parameter
'		@nUserNo : 유저번호
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Character_getChangeIDList]
	@nUserNo int
,	@nRet    int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0
	
	SELECT nRowNo, nUserNo, nCharNo, bInit
	  FROM tCharacterChangeID
	 WHERE nUserNo = @nUserNo AND bFlag = 0
	   
	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Character_getSingleOption]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Character_getSingleOption]
GO
/*--------------------------------------------------------------------------------------
' 이  름 : usp_Character_getSingleOption
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2010.10.18.
'   캐릭터의 단일컬럼 옵션값들을 가져옴
'	새로운 컨덴츠 추가시 단일컬럼으로 된 옵션값을 가질 경우 tCharacterSingleOption
'	테이블에 추가후 값을 가져오는 프로시저는 이 프로시저로 통일함.
' Parameter :
'	input Parameter
'		@nCharNo      : 캐릭터번호
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-3092 : db error (insert)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Character_getSingleOption]
	@nCharNo      int
,	@nRet         int = 0 output
AS
BEGIN
	SET NOCOUNT ON
	SET LOCK_TIMEOUT 5000 
	
	SET @nRet = 0

	IF NOT EXISTS(SELECT nCharNo FROM tCharacterSingleOption WHERE nCharNo = @nCharNo) BEGIN
		INSERT INTO tCharacterSingleOption (nCharNo)
		VALUES (@nCharNo)
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -3192
			RETURN
		END
	END

	SELECT bMysteryBolt
		,  bAutoPick 
		,  dRestExpLastExecuteTime 
	  FROM tCharacterSingleOption 
	 WHERE nCharNo = @nCharNo 		
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Character_setAutoPick]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Character_setAutoPick]
GO
/*--------------------------------------------------------------------------------------
' 이  름 : usp_Character_setAutoPick
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2010.10.18.
' Description :
'   자동줍기 옵션 설정값 저장
'	GET의 경우 전체를 억세스하지만 개별 옵션들은 별도로 각각 저장한다.
'	각각의 저장시점이 다르므로 통합하여 한번에 저장하지 않는다.
'	저장 실패시 게임상 로그만 남기고 프로그램은 종료하지 않는다.
' Parameter :
'	input Parameter
'		@nCharNo   : 캐릭터번호
'		@bAutoPick : 자동줍기 설정값(0:false/1:true)
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-3092 : db error (insert)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Character_setAutoPick]
	@nCharNo   int
,	@bAutoPick bit
,	@nRet      int = 0 output
AS
BEGIN
	SET NOCOUNT ON
	SET LOCK_TIMEOUT 5000 
	
	SET @nRet = 0

	IF NOT EXISTS(SELECT nCharNo FROM tCharacterSingleOption WHERE nCharNo = @nCharNo) BEGIN
		INSERT INTO tCharacterSingleOption (nCharNo, bAutoPick)
		VALUES (@nCharNo, @bAutoPick)
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -3192
			RETURN
		END		
	END
	ELSE BEGIN
		UPDATE tCharacterSingleOption 
		   SET bAutoPick = @bAutoPick 
		 WHERE nCharNo = @nCharNo
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -3193
			RETURN
		END		
	END
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Character_setChangeID]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Character_setChangeID]
GO
/*--------------------------------------------------------------------------------------
' 이  름 : usp_Character_setChangeID
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2010.7.7.
' Description :
'   캐릭터명을 변경하는 프로시저
'	인간관계 초기화 설정시 친구, 결혼, 길드, 홀리프라미스, 채팅블럭, 길드아카데미
'	정보를 초기화 한다.
' Parameter :
'	input Parameter
'		@nRowNo  : 일련번호
'		@nCharNo : 캐릭터번호
'		@sID     : 변경된 캐릭터명
'		@bInit   : 인간관계 초기화여부
'		@nUserNo : 유저번호
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-3023 : 선택한 캐릭터는 삭제된 캐릭터이거나 존재하지 않는 캐릭터입니다.
'				-3024 : 입력된 유저번호와 실제 유저번호가 일치하지 않습니다.
'				-3025 : 길드마스터는 인간관계 초기화를 할 수 없습니다.
'				-3026 : 캐릭터명 변경 오류입니다. db error (update)
'				-3027 : 친구 정보 삭제 오류입니다.
'				-3028 : 결혼 정보 삭제 오류입니다.
'				-3029 : 홀리프라미스 정보 삭제 오류입니다. 하위관계
'				-3030 : 홀리프라미스 정보 삭제 오류입니다. 상위관계
'				-3031 : 채팅 블록 정보 삭제 오류입니다.
'				-3032 : 길드아카데미 정보의 길드아카데미 마스터 정보 갱신 오류입니다.
'				-3033 : 길드 정보 삭제 오류입니다.
'				-3034 : 길드아카데미 정보 삭제 오류입니다.
'				-3035 : 캐릭터명 변경 서비스 반영여부 갱신 오류입니다.
'				-3039 : 이미 사용중인 캐릭터명입니다.
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Character_setChangeID]
	@nRowNo  int
,	@nCharNo int
,	@sID     nvarchar(16)
,	@bInit   bit
,	@nUserNo int
,	@nRet    int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0
	
	DECLARE @sOldID AS nvarchar(50)
	DECLARE @nDBUserNo AS int
	DECLARE @nGrade AS tinyint
	DECLARE @nMyGuildNo AS int
	
	SELECT @sOldID = T1.sID, @nDBUserNo = T1.nUserNo, @nGrade = nGrade
	  FROM tCharacter T1 LEFT OUTER JOIN tGuildMember T2 ON T1.nCharNo = T2.nCharNo
	 WHERE T1.nCharNo = @nCharNo AND T1.bDeleted = 0
	   AND bDeleted = 0
	IF @sOldID = @sID BEGIN
		SET @nRet = -3039
		RETURN
	END	
	IF @nDBUserNo IS NULL BEGIN
		SET @nRet = -3023
		RETURN
	END
	ELSE BEGIN
		-- mismatch userNo
		IF @nDBUserNo <> @nUserNo BEGIN
			SET @nRet = -3024
			RETURN
		END
		
		-- impossible guildmaster
		IF @nGrade IS NOT NULL AND @nGrade = 0 AND @bInit = 1 BEGIN
			SET @nRet = -3025
			RETURN
		END

		BEGIN TRAN
		
		-- change ID
		IF EXISTS(SELECT nCharNo FROM tCharacter WHERE sID = @sID) BEGIN		
			SET @nRet = -3039
			ROLLBACK TRAN
			RETURN
		END
		ELSE BEGIN
			UPDATE tCharacter
			   SET sID = @sID
			 WHERE nCharNo = @nCharNo
			IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
				SET @nRet = -3026
				ROLLBACK TRAN
				RETURN
			END		
		END
		
		-- init Community
		IF @bInit = 1 BEGIN
			-- delete Friend
			IF EXISTS(SELECT nCharNo FROM tFriend WHERE nCharNo = @nCharNo) BEGIN
				DELETE FROM tFriend WHERE nCharNo = @nCharNo
				IF @@ERROR <> 0 OR @@ROWCOUNT < 1 BEGIN
					SET @nRet = -3027
					ROLLBACK TRAN
					RETURN
				END
			END
			IF EXISTS(SELECT nCharNo FROM tFriend WHERE nFriendCharNo = @nCharNo) BEGIN
				DELETE FROM tFriend WHERE nFriendCharNo = @nCharNo
				IF @@ERROR <> 0 OR @@ROWCOUNT < 1 BEGIN
					SET @nRet = -3027
					ROLLBACK TRAN
					RETURN
				END				
			END
			
			-- delete Marriage
			IF EXISTS(SELECT nCharNo FROM tMarriage WHERE nCharNo = @nCharNo) BEGIN
				DELETE FROM tMarriage WHERE nCharNo = @nCharNo
				IF @@ERROR <> 0 OR @@ROWCOUNT < 1 BEGIN
					SET @nRet = -3028
					ROLLBACK TRAN
					RETURN
				END
			END
			IF EXISTS(SELECT nCharNo FROM tMarriage WHERE nPartnerCharNo = @nCharNo) BEGIN				
				DELETE FROM tMarriage WHERE nPartnerCharNo = @nCharNo
				IF @@ERROR <> 0 OR @@ROWCOUNT < 1 BEGIN
					SET @nRet = -3028
					ROLLBACK TRAN
					RETURN
				END				
			END			

			-- delete HolyPromise me
			IF EXISTS(SELECT nCharNo FROM tHolyPromise WHERE nCharNo = @nCharNo) BEGIN
				DELETE FROM tHolyPromise WHERE nCharNo = @nCharNo
				IF @@ERROR <> 0 OR @@ROWCOUNT < 1 BEGIN
					SET @nRet = -3029
					ROLLBACK TRAN
					RETURN
				END
			END
			
			-- delete HolyPromise up
			IF EXISTS(SELECT nCharNo FROM tHolyPromise WHERE nUpCharNo = @nCharNo) BEGIN
				DELETE FROM tHolyPromise WHERE nUpCharNo = @nCharNo
				IF @@ERROR <> 0 OR @@ROWCOUNT < 1 BEGIN
					SET @nRet = -3030
					ROLLBACK TRAN
					RETURN
				END
			END			
			
			-- delete ChatBlock
			IF EXISTS(SELECT nCharNo FROM tChatBlock WHERE nCharNo = @nCharNo) BEGIN
				DELETE FROM tChatBlock WHERE nCharNo = @nCharNo
				IF @@ERROR <> 0 OR @@ROWCOUNT < 1 BEGIN
					SET @nRet = -3031
					ROLLBACK TRAN
					RETURN
				END
			END			
						
			-- delete GuildAcademyMaster & GuildMember		
			SELECT @nMyGuildNo = nNo FROM tGuildMember WHERE nCharNo = @nCharNo
			IF @nMyGuildNo IS NOT NULL BEGIN
				IF EXISTS(SELECT nNo FROM tGuildAcademy WHERE nNo = @nMyGuildNo AND nMasterCharNo = @nCharNo) BEGIN
					-- reset GuildAcademy Master
					UPDATE tGuildAcademy
					   SET nMasterCharNo = (SELECT TOP 1 nCharNo FROM tGuildMember WHERE nNo = @nMyGuildNo AND nGrade = 0)
					 WHERE nNo = @nMyGuildNo
					IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
						SET @nRet = -3032
						ROLLBACK TRAN
						RETURN
					END						 
				END
				-- delete GuildMember
				DELETE FROM tGuildMember WHERE nCharNo = @nCharNo
				IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
					SET @nRet = -3033
					ROLLBACK TRAN
					RETURN
				END
			END
			
			-- delete GuildAcademyMember
			IF EXISTS(SELECT nCharNo FROM tGuildAcademyMember WHERE nCharNo = @nCharNo) BEGIN
				DELETE FROM tGuildAcademyMember WHERE nCharNo = @nCharNo
				IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
					SET @nRet = -3034
					ROLLBACK TRAN
					RETURN
				END	
			END				
		END

		UPDATE tCharacterChangeID 
		   SET sys_update_date = GETDATE(), bFlag = 1, sOldID = @sOldID, sNewID = @sID
		 WHERE nRowNo = @nRowNo 
		IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
			SET @nRet = -3035
			ROLLBACK TRAN
			RETURN
		END
				
		COMMIT TRAN
	END

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Character_setChangeIDItemUsed]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Character_setChangeIDItemUsed]
GO
/*--------------------------------------------------------------------------------------
' 이  름 : usp_Character_setChangeIDItemUsed
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2010.7.7.
' Description :
'   웹페이지에서 캐릭터명 변경 아이템을 사용하면 호출되는 프로시저
' Parameter :
'	input Parameter
'		@nCharNo : 캐릭터번호
'		@bInit   : 인간관계 초기화여부
'		@nUserNo : 유저번호
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-3022 : 캐릭터명 변경 서비스가 이미 진행중인 캐릭터
'				-3023 : 삭제되거나 존재하지 않는 캐릭터
'				-3025 : 길드마스터는 인간관계 초기화를 할 수 없습니다.
'				-3036 : 아이템 소유자가 아닙니다.
'				-3037 : 아이템 삭제 오류
'				-3038 : 아이템 차감 오류
'				-3092 : db error (insert)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Character_setChangeIDItemUsed]
	@nCharNo int
,	@bInit   bit
,	@nUserNo int
,	@nItemKey bigint
,	@nItemOption smallint
,	@nItemLot smallint
,	@nRet    int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	DECLARE @nGrade AS tinyint
	SET @nRet = 0

	-- 아이템 소유자 확인
	EXEC p_Item_IsValidOwner @nItemKey, @nCharNo, @nRet OUTPUT
	IF @nRet <> 0 BEGIN
		SET @nRet = -3036
		RETURN
	END

	-- impossible guildmaster
	SELECT @nGrade = nGrade
	  FROM tCharacter T1 LEFT OUTER JOIN tGuildMember T2 ON T1.nCharNo = T2.nCharNo
	 WHERE T1.nCharNo = @nCharNo AND T1.bDeleted = 0
	   AND bDeleted = 0
	IF @nGrade IS NOT NULL AND @nGrade = 0 AND @bInit = 1 BEGIN
		SET @nRet = -3025
		RETURN
	END	   
	   
	IF EXISTS(SELECT nRowNo FROM tCharacterChangeID WHERE nCharNo = @nCharNo AND bFlag = 0) BEGIN
		SET @nRet = -3022
		RETURN
	END
	ELSE IF EXISTS(SELECT nCharNo FROM tCharacter WHERE nUserNo = @nUserNo AND bDeleted = 0) BEGIN
		BEGIN TRAN
		
		-- 아이템 사용 기록
		INSERT INTO tCharacterChangeID (nUserNo, nCharNo, bInit)
		VALUES (@nUserNo, @nCharNo, @bInit)
		IF @@ERROR <> 0 OR @@IDENTITY = 0 BEGIN
			SET @nRet = -3092
			ROLLBACK TRAN
			RETURN
		END	
		
		-- 아이템 삭제 (사용후 Lot = 0 인 경우)
		IF @nItemLot = 0 BEGIN
			EXEC p_Item_Delete @nItemKey, @nRet OUTPUT
			IF @nRet <> 0 BEGIN
				ROLLBACK TRAN
				SET @nRet = -3037
				RETURN
			END
		END
		-- 아이템 차감하기 (사용후 Lot > 0 인 경우)
		ELSE BEGIN
			EXEC p_Item_SetOption @nItemKey, @nItemOption, @nItemLot, @nRet OUTPUT
			IF @nRet <> 0 BEGIN
				ROLLBACK TRAN
				SET @nRet = -3038
				RETURN
			END
		END
		
		COMMIT TRAN		
	END
	ELSE BEGIN
		SET @nRet = -3023
		RETURN	
	END
	
	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Character_setMysteryBolt]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Character_setMysteryBolt]
GO
/*--------------------------------------------------------------------------------------
' 이  름 : usp_Character_setMysteryBolt
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2010.10.18.
' Description :
'   미스테리 볼트 UI설정 옵션값을 저장함.
'	GET의 경우 전체를 억세스하지만 개별 옵션들은 별도로 각각 저장한다.
'	각각의 저장시점이 다르므로 통합하여 한번에 저장하지 않는다.
'	저장 실패시 게임상 로그만 남기고 프로그램은 종료하지 않는다.
' Parameter :
'	input Parameter
'		@nCharNo      : 캐릭터번호
'		@bMysteryBolt : 미스테리 볼트 UI 설정값(0:false/1:true)
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-3092 : db error (insert)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Character_setMysteryBolt]
	@nCharNo      int
,	@bMysteryBolt bit
,	@nRet         int = 0 output
AS
BEGIN
	SET NOCOUNT ON
	SET LOCK_TIMEOUT 5000 
	
	SET @nRet = 0

	IF NOT EXISTS(SELECT nCharNo FROM tCharacterSingleOption WHERE nCharNo = @nCharNo) BEGIN
		INSERT INTO tCharacterSingleOption (nCharNo, bMysteryBolt)
		VALUES (@nCharNo, @bMysteryBolt)
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -3192
			RETURN
		END		
	END
	ELSE BEGIN
		UPDATE tCharacterSingleOption 
		   SET bMysteryBolt = @bMysteryBolt 
		 WHERE nCharNo = @nCharNo
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -3193
			RETURN
		END		
	END
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Character_setRestExpExecTime]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Character_setRestExpExecTime]
GO
/*--------------------------------------------------------------------------------------
' 이  름 : usp_Character_setRestExpExecTime
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2010.10.18.
' Description :
'   휴식경험치 계산을 위한 마지막 시간 저장
'	GET의 경우 전체를 억세스하지만 개별 옵션들은 별도로 각각 저장한다.
'	각각의 저장시점이 다르므로 통합하여 한번에 저장하지 않는다.
'	저장 실패시 게임상 로그만 남기고 프로그램은 종료하지 않는다.
' Parameter :
'	input Parameter
'		@nCharNo : 캐릭터번호
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-3092 : db error (insert)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Character_setRestExpExecTime]
	@nCharNo   int
,	@nRet      int = 0 output
AS
BEGIN
	SET NOCOUNT ON
	SET LOCK_TIMEOUT 5000 
	
	SET @nRet = 0

	IF NOT EXISTS(SELECT nCharNo FROM tCharacterSingleOption WHERE nCharNo = @nCharNo) BEGIN
		INSERT INTO tCharacterSingleOption (nCharNo)
		VALUES (@nCharNo)
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -3192
			RETURN
		END		
	END
	ELSE BEGIN
		UPDATE tCharacterSingleOption 
		   SET dRestExpLastExecuteTime = GETDATE() 
		 WHERE nCharNo = @nCharNo
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -3193
			RETURN
		END		
	END
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Character_setStatPoint]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Character_setStatPoint]
GO
/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_Character_setStatPoint
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2010.10.21.
' Description :
'   Ä³¸¯ÅÍÀÇ ½ºÅÈÀ» ÀúÀåÇÑ´Ù.
'	À¯·á¾ÆÀÌÅÛÀ» »ç¿ëÇÏ¿© ±âÁ¸ ½ºÅÈº¸´Ù Àû¾îÁú ¶§ ÇØ´ç À¯·á¾ÆÀÌÅÛÀ» »èÁ¦ÇÑ´Ù.
'	
'	1°³ÀÇ ¾ÆÀÌÅÛÀ» »èÁ¦ÇÒ ¶§¿Í ¿©·¯°³ÀÇ ¾ÆÀÌÅÛÀ» »èÁ¦ÇØ¾ß ÇÒ ¶§¸¦ ±¸ºÐÇÏ¿©
'	Ã³¸®ÇÔÀ¸·Î¼­ ¾à°£ÀÇ ¼º´É Çâ»óÀ» ±â´ëÇÒ ¼ö ÀÖ´Ù.
'	¿µ¿õ±â¿Í ¿À¸®Áö³ÎÀÇ ¼­¹ö¿¡¼­ Ã³¸®ÇÏ´Â ¹æ½ÄÀÌ ´Ù¸£±â ¶§¹®
'	¿µ¿õ±â´Â ÇÑ¹ø¿¡ Àû¿ëµÇÁö¸¸ ¿À¸®Áö³ÎÀº ¸Å¹ø °Ç°ÇÈ÷ Ã³¸®ÇÑ´Ù.
'
'	¼º´É»ó ÀÌ½´°¡ ÀÖ´Â Ä¿¼­¸¦ »ç¿ëÇÒ ¼ö ¹Û¿¡ ¾ø´Â ÀÌÀ¯´Â
'	ÇöÀç ½Ã½ºÅÛ¿¡¼­ ¾ÆÀÌÅÛÀ» ¼øÂ÷ÀûÀ¸·Î Áö¿ì´Â ½Ã½ºÅÛÀÌ Á¸ÀçÇÏÁö ¾Ê¾Æ
'	ÀÌ½´°¡ ÀÖ´Â Ä¿¼­¸¦ »ç¿ëÇÏ¿© Áö¿ì´Â ÇüÅÂ¸¦ ¼±ÅÃÇß´Ù.
' Parameter :
'	input Parameter
'		@nCharNo       : Ä³¸¯ÅÍ¹øÈ£
'		@nMaxStatPoint : ÃÖ´ë½ºÅÈ
'		@nStrength     : Èû
'		@nConstitute   : Ã¼·Â
'		@nDexterity    : ¹ÎÃ¸
'		@nIntelligence : Áö´É
'		@nMentalPower  : Á¤½Å
'		@nItemID       : ¾ÆÀÌÅÛ¾ÆÀÌµð
'		@nOptionType   : ¾ÆÀÌÅÛ¿É¼Ç
'		@nDeleteCount  : »èÁ¦µÉ ¾ÆÀÌÅÛ ¼ö
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-3092 : db error (insert)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Character_setStatPoint]
	@nCharNo       int
,	@nMaxStatPoint int
,	@nStrength     tinyint
,	@nConstitute   tinyint
,	@nDexterity    tinyint
,	@nIntelligence tinyint
,	@nMentalPower  tinyint
,	@nItemID       int
,	@nOptionType   smallint
,	@nDeleteCount  int
,	@nRet          int = 0 output
AS
BEGIN
	SET NOCOUNT ON
	SET LOCK_TIMEOUT 5000
	
	DECLARE @nTotalStat   int
	DECLARE @nDeleteCheck int
	DECLARE @nStr int, @nCon int, @nDex int, @nInt int, @nMen int
	DECLARE @nTotalItemCount int, @nItemKey bigint, @nOptionData bigint, @nItemDeleteRemain int, @nRemainCount int
	
	SET @nRet = 0
	SET @nTotalStat = 0
	SET @nDeleteCheck = 0

	-- invalid nCharNo	
	IF @nCharNo <= 0 BEGIN
		SET @nRet = -1011
		RETURN
	END
	
	-- invalid StatPoint
	IF @nStrength < 0 OR @nConstitute < 0 OR @nDexterity < 0 OR @nIntelligence < 0 OR @nMentalPower < 0 BEGIN
		SET @nRet = -1012
		RETURN
	END
	
	-- have many StatPoint
	SET @nTotalStat = @nStrength + @nConstitute + @nDexterity + @nIntelligence + @nMentalPower
	IF @nMaxStatPoint < @nTotalStat BEGIN
		SET @nRet = -1013
		RETURN
	END
	
	IF EXISTS(SELECT nCharNo FROM tCharacter WHERE nCharNo = @nCharNo AND bDeleted = 0) BEGIN
		SELECT @nStr = nStrength
			,  @nCon = nConstitute 
			,  @nDex = nDexterity 
			,  @nInt = nIntelligence 
			,  @nMen = nMentalPower 
		  FROM tCharacter
		 WHERE nCharNo = @nCharNo
		IF @nStr > @nStrength SET @nDeleteCheck = @nDeleteCheck + (@nStr - @nStrength)
		IF @nCon > @nConstitute SET @nDeleteCheck = @nDeleteCheck + (@nCon - @nConstitute)
		IF @nDex > @nDexterity SET @nDeleteCheck = @nDeleteCheck + (@nDex - @nDexterity)
		IF @nInt > @nIntelligence SET @nDeleteCheck = @nDeleteCheck + (@nInt - @nIntelligence)
		IF @nMen > @nMentalPower SET @nDeleteCheck = @nDeleteCheck + (@nMen - @nMentalPower)
		IF @nDeleteCount <> @nDeleteCheck BEGIN
			SET @nRet = -1021
			RETURN
		END
		
		BEGIN TRAN
		
		UPDATE tCharacter
		   SET nStrength = @nStrength 
		   ,   nConstitute = @nConstitute 
		   ,   nDexterity = @nDexterity 
		   ,   nIntelligence = @nIntelligence 
		   ,   nMentalPower = @nMentalPower 
		 WHERE nCharNo = @nCharNo 
		IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
			SET @nRet = -1093
			ROLLBACK TRAN
			RETURN
		END		 

		IF @nDeleteCount > 0  BEGIN
			IF @nDeleteCount = 1 BEGIN
				SELECT TOP 1 @nItemKey = T1.nItemKey, @nOptionData = T2.nOptionData
				  FROM tItem T1, tItemOptions T2
				 WHERE T1.nItemKey = T2.nItemKey 
				   AND T1.nOwner = @nCharNo
				   AND T1.nStorageType = 9
				   AND T1.nItemID = @nItemID 
				 ORDER BY nStorage ASC
				IF @nOptionData > 1 BEGIN
					SET @nOptionData = @nOptionData - 1
					EXEC p_Item_SetOption @nItemKey, @nOptionType, @nOptionData, @nRet output
					IF @nRet <> 0 BEGIN
						SET @nRet = -1022
						ROLLBACK TRAN
						RETURN						
					END					
				END
				ELSE BEGIN
					EXEC p_Item_Delete @nItemKey, @nRet output
					IF @nRet <> 0 BEGIN
						SET @nRet = -1023
						ROLLBACK TRAN
						RETURN						
					END					
				END
			END
			ELSE BEGIN
				SELECT T1.nItemKey, T1.nStorage, T2.nOptionData
				  INTO #tDeleteItem
				  FROM tItem T1, tItemOptions T2
				 WHERE T1.nItemKey = T2.nItemKey 
				   AND T1.nOwner = @nCharNo
				   AND T1.nStorageType = 9
				   AND T1.nItemID = @nItemID 
				 ORDER BY nStorage ASC 
				
				SELECT @nTotalItemCount = SUM(nOptionData) FROM #tDeleteItem
				IF @nTotalItemCount < @nDeleteCount BEGIN
					SET @nRet = -1024
					ROLLBACK TRAN
					RETURN
				END
				ELSE IF @nTotalItemCount = @nDeleteCount BEGIN
					DELETE FROM tItem WHERE nItemKey IN (SELECT nItemKey FROM #tDeleteItem)
					IF @@ERROR <> 0 BEGIN
						SET @nRet = -1023
						ROLLBACK TRAN
						RETURN
					END				
				END
				ELSE BEGIN
					DECLARE CUR_DELETE CURSOR FORWARD_ONLY
					FOR
						SELECT nItemKey, nOptionData
						  FROM #tDeleteItem
						 ORDER BY nStorage ASC
					OPEN CUR_DELETE
					
					SET @nItemDeleteRemain = @nDeleteCount
					FETCH FROM CUR_DELETE INTO @nItemKey, @nOptionData
					WHILE @@FETCH_STATUS = 0 BEGIN
						IF @nItemDeleteRemain >= @nOptionData BEGIN
							EXEC p_Item_Delete @nItemKey, @nRet output
							IF @nRet <> 0 BEGIN
								SET @nRet = -1023
								ROLLBACK TRAN
								RETURN						
							END
							
							SET @nItemDeleteRemain = @nItemDeleteRemain - @nOptionData
						END
						ELSE BEGIN
							SET @nRemainCount = @nOptionData - @nItemDeleteRemain
							EXEC p_Item_SetOption @nItemKey, @nOptionType, @nRemainCount, @nRet output
							IF @nRet <> 0 BEGIN
								SET @nRet = -1022
								ROLLBACK TRAN
								RETURN						
							END	
												
							SET @nItemDeleteRemain = 0
						END		
						
						IF @nItemDeleteRemain = 0 BEGIN
							BREAK
						END
						
						FETCH FROM CUR_DELETE INTO @nItemKey, @nOptionData			
					END
					
					CLOSE CUR_DELETE
					DEALLOCATE CUR_DELETE
				END
			END
		END
		
		COMMIT TRAN				 		
	END
	ELSE BEGIN
		-- not found nCharNo	
		SET @nRet = -1014
		RETURN
	END
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_CharacterLoading]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_CharacterLoading]
GO



-- ÀúÀå ÇÁ·Î½ÃÁ®

CREATE  PROCEDURE [dbo].[usp_CharacterLoading]
/*
char loading save
2009.6 By Luunar
 input:
	see SQL
 output:
	= 0 No Error
	< 0 Error
*/

@nCharNo		int,
@dWorldTime		datetime,
@sLoadingMapName	nvarchar(16),
@nFailType		smallint,
@nLoadingFailCnt	smallint,
@nRet			int OUTPUT

AS
BEGIN

	SET NOCOUNT ON

	DECLARE @nSeqNo int
	SET @nSeqNo       = 0

	BEGIN TRAN

	SELECT TOP 1 @nSeqNo = nSeqNo
	  FROM tCharacterLoading
	 WHERE nCharNo = @nCharNo 
	 ORDER BY nSeqNo DESC

	SET @nSeqNo       = @nSeqNo + 1

	INSERT INTO tCharacterLoading( nCharNo, nSeqNo, dWorldTime, sLoadingMapName, nFailType, nLoadingFailCnt )
	VALUES (@nCharNo, @nSeqNo, @dWorldTime, @sLoadingMapName, @nFailType, @nLoadingFailCnt)
	IF @@ERROR <> 0 BEGIN
		-- ÆÄÀÏ ¿¡·¯Ã³¸®
		SET @nRet = -1001
		ROLLBACK TRAN
		RETURN
	END

	SET @nRet = 0
	COMMIT TRAN
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_ChargeItem_Draw]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_ChargeItem_Draw]
GO
/****** 개체: 저장 프로시저 dbo.usp_ChargeItem_Draw    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/
 

/*---------------------------------------------------------------------------------------
' Name : usp_ChargeItem_Draw
' Description : 인출된 아이템 인출완료 체크
'   - 이 저장프로시저에서 Error 가 발생하면 캐릭터 DB 에서 생성된 아이템을 취소하여야 함
' Creator : Ko Dong Gyun(kodong@empal.com)
' Creat Date : 2006-06-17
' Parameter :
'			input Parameter
'				@ROW_NO	: 창고번호
'				@USER_NO	: 유저번호
'			output Parameter
'				@RET
'					-2 : 창고번에 있는 유저번호와 불일치 하는경우
'					-1 : 이미 인출이 완료된 아이템
'					0 : DB Error
'					1 : Success
---------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_ChargeItem_Draw]
	@ROW_NO INT,
	@USER_NO INT,
	@RET	INT = 0 OUTPUT
AS

BEGIN

	SET NOCOUNT ON
	SET LOCK_TIMEOUT 5000

	EXEC Account.dbo.usp_Charge_ItemDraw @ROW_NO, @USER_NO, @RET OUTPUT
	
	SET NOCOUNT OFF
	SET LOCK_TIMEOUT -1

END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_ChargeItem_GetList]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_ChargeItem_GetList]
GO
/****** 개체: 저장 프로시저 dbo.usp_ChargeItem_GetList    스크립트 날짜: 2007-03-13 오후 6:25:10 ******/

/*---------------------------------------------------------------------------------------
' Name : usp_ChargeItem_GetList
' Description : 유저번호에 따른 유저창고 리스트를 가져옴
' Creator : Ko Dong Gyun(kodong@empal.com)
' Creat Date : 2006-06-17
' Parameter :
'			input Parameter
'				@USER_NO	: 유저번호
'			output Parameter
'				recordSet : rowNo, goodsNo, amount, registerDate
---------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_ChargeItem_GetList]
	@USER_NO INT
AS

BEGIN

	SET NOCOUNT ON
	SET LOCK_TIMEOUT 5000

	EXEC Account.dbo.usp_Charge_ItemSelectList @USER_NO

	SET NOCOUNT OFF
	SET LOCK_TIMEOUT -1

END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_ChargeItem_UseSkillPowerInitDel]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_ChargeItem_UseSkillPowerInitDel]
GO
/****** 개체: 저장 프로시저 dbo.usp_ChargeItem_UseSkillPowerInitDel    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/

CREATE PROCEDURE [dbo].[usp_ChargeItem_UseSkillPowerInitDel]
/*
Charge item use - clear character all skill power and delete used item
2006.6 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Error clear character all skill power
	        2 = Error delete used charge item
*/

@nCharNo int,
@nDeleteItemKey bigint,
@nRet tinyint OUTPUT

AS

SET NOCOUNT ON

BEGIN TRAN

-- Clear character all skill power
UPDATE tSkill SET 
	nSkillPowerDemage	= 0,
	nSkillPowerSP		= 0,
	nSkillPowerKeepTime = 0,
	nSkillPowerCoolTime = 0
WHERE nCharNo = @nCharNo

IF @@ERROR <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = 1
	RETURN
END

-- Delete used charge item
DECLARE @TempRet int
EXEC p_Item_Delete @nDeleteItemKey, @TempRet OUTPUT
IF @TempRet <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = 2
	RETURN
END

-- Done
COMMIT TRAN

SET @nRet = 0
RETURN

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_ChargeItem_UseSkillPowerInitLotChange]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_ChargeItem_UseSkillPowerInitLotChange]
GO
/****** 개체: 저장 프로시저 dbo.usp_ChargeItem_UseSkillPowerInitLotChange    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/

CREATE PROCEDURE [dbo].[usp_ChargeItem_UseSkillPowerInitLotChange]
/*
Charge item use - clear character all skill power and use item lot change
2006.6 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Error clear character all skill power
	        2 = Error used charge item change lot
*/

@nCharNo int,
@nChangeItemKey bigint,
@nChangeItemOptionType smallint,
@nChangeItemOptionData bigint,		
@nRet tinyint OUTPUT

AS

SET NOCOUNT ON

BEGIN TRAN

-- Clear character all skill power
UPDATE tSkill SET 
	nSkillPowerDemage	= 0,
	nSkillPowerSP		= 0,
	nSkillPowerKeepTime = 0,
	nSkillPowerCoolTime = 0
WHERE nCharNo = @nCharNo

IF @@ERROR <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = 1
	RETURN
END

-- Used charge item change lot
DECLARE @TempRet int
EXEC p_Item_SetOption @nChangeItemKey, @nChangeItemOptionType, @nChangeItemOptionData, @TempRet OUTPUT
IF @TempRet <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = 2
	RETURN
END

-- Done
COMMIT TRAN

SET @nRet = 0
RETURN

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_ChargeItem_UseStatPointDecDel]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_ChargeItem_UseStatPointDecDel]
GO
/****** 개체: 저장 프로시저 dbo.usp_ChargeItem_UseStatPointDecDel    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/

CREATE PROCEDURE [dbo].[usp_ChargeItem_UseStatPointDecDel]
/*
Charge item use - Stat point decrement and use item delete
2006.6 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Error decrement character stat point.
	        2 = Error delete used charge item
*/

@nCharNo int,
@nStatPointType tinyint,
@nDeleteItemKey bigint,
@nRet tinyint OUTPUT

AS

SET NOCOUNT ON

BEGIN TRAN

-- CHECK Type and Decrement stat-point
DECLARE @nStatPoint tinyint

IF @nStatPointType = 0
BEGIN
	SELECT @nStatPoint = nStrength FROM tCharacter WHERE nCharNo = @nCharNo
	IF @nStatPoint < 1
	BEGIN
		SET @nRet = 1
		RETURN
	END
	
	UPDATE tCharacter	SET nStrength	= nStrength - 1					WHERE nCharNo = @nCharNo AND nStrength > 0
END

IF @nStatPointType = 1
BEGIN
	SELECT @nStatPoint = nConstitute FROM tCharacter WHERE nCharNo = @nCharNo
	IF @nStatPoint < 1
	BEGIN
		SET @nRet = 1
		RETURN
	END
	
	UPDATE tCharacter	SET nConstitute = nConstitute - 1				WHERE nCharNo = @nCharNo AND nConstitute > 0
END
	
IF @nStatPointType = 2
BEGIN
	SELECT @nStatPoint = nDexterity FROM tCharacter WHERE nCharNo = @nCharNo
	IF @nStatPoint < 1
	BEGIN
		SET @nRet = 1
		RETURN
	END
	
	UPDATE tCharacter	SET nDexterity = nDexterity - 1					WHERE nCharNo = @nCharNo AND nDexterity > 0
END

IF @nStatPointType = 3
BEGIN
	SELECT @nStatPoint = nIntelligence FROM tCharacter WHERE nCharNo = @nCharNo
	IF @nStatPoint < 1
	BEGIN
		SET @nRet = 1
		RETURN
	END
	
	UPDATE tCharacter	SET nIntelligence = nIntelligence - 1			WHERE nCharNo = @nCharNo AND nIntelligence > 0
END

IF @nStatPointType = 4 
BEGIN
	SELECT @nStatPoint = nMentalPower FROM tCharacter WHERE nCharNo = @nCharNo
	IF @nStatPoint < 1
	BEGIN
		SET @nRet = 1
		RETURN
	END
	
	UPDATE tCharacter	SET nMentalPower = nMentalPower - 1				WHERE nCharNo = @nCharNo AND nMentalPower > 0
END

IF @@ERROR <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = 1
	RETURN
END

-- Delete used charge item
DECLARE @TempRet int
EXEC p_Item_Delete @nDeleteItemKey, @TempRet OUTPUT
IF @TempRet <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = 2
	RETURN
END

-- Done
COMMIT TRAN

SET @nRet = 0
RETURN

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_ChargeItem_UseStatPointDecLotChange]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_ChargeItem_UseStatPointDecLotChange]
GO
/****** 개체: 저장 프로시저 dbo.usp_ChargeItem_UseStatPointDecLotChange    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/

CREATE PROCEDURE [dbo].[usp_ChargeItem_UseStatPointDecLotChange]
/*
Charge item use - Stat point decrement and use item lot change
2006.6 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Error decrement character stat point.
	        2 = Error used charge item change lot
*/

@nCharNo int,
@nStatPointType tinyint,
@nChangeItemKey bigint,
@nChangeItemOptionType smallint,
@nChangeItemOptionData bigint,		
@nRet tinyint OUTPUT

AS

SET NOCOUNT ON

BEGIN TRAN

-- CHECK Type and Decrement stat-point
DECLARE @nStatPoint tinyint

IF @nStatPointType = 0
BEGIN
	SELECT @nStatPoint = nStrength FROM tCharacter WHERE nCharNo = @nCharNo
	IF @nStatPoint < 1
	BEGIN
		SET @nRet = 1
		RETURN
	END
	
	UPDATE tCharacter	SET nStrength	= nStrength - 1					WHERE nCharNo = @nCharNo AND nStrength > 0
END

IF @nStatPointType = 1
BEGIN
	SELECT @nStatPoint = nConstitute FROM tCharacter WHERE nCharNo = @nCharNo
	IF @nStatPoint < 1
	BEGIN
		SET @nRet = 1
		RETURN
	END
	
	UPDATE tCharacter	SET nConstitute = nConstitute - 1				WHERE nCharNo = @nCharNo AND nConstitute > 0
END
	
IF @nStatPointType = 2
BEGIN
	SELECT @nStatPoint = nDexterity FROM tCharacter WHERE nCharNo = @nCharNo
	IF @nStatPoint < 1
	BEGIN
		SET @nRet = 1
		RETURN
	END
	
	UPDATE tCharacter	SET nDexterity = nDexterity - 1					WHERE nCharNo = @nCharNo AND nDexterity > 0
END

IF @nStatPointType = 3
BEGIN
	SELECT @nStatPoint = nIntelligence FROM tCharacter WHERE nCharNo = @nCharNo
	IF @nStatPoint < 1
	BEGIN
		SET @nRet = 1
		RETURN
	END
	
	UPDATE tCharacter	SET nIntelligence = nIntelligence - 1			WHERE nCharNo = @nCharNo AND nIntelligence > 0
END

IF @nStatPointType = 4 
BEGIN
	SELECT @nStatPoint = nMentalPower FROM tCharacter WHERE nCharNo = @nCharNo
	IF @nStatPoint < 1
	BEGIN
		SET @nRet = 1
		RETURN
	END
	
	UPDATE tCharacter	SET nMentalPower = nMentalPower - 1				WHERE nCharNo = @nCharNo AND nMentalPower > 0
END

IF @@ERROR <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = 1
	RETURN
END

-- Used charge item change lot
DECLARE @TempRet int
EXEC p_Item_SetOption @nChangeItemKey, @nChangeItemOptionType, @nChangeItemOptionData, @TempRet OUTPUT
IF @TempRet <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = 2
	RETURN
END

-- Done
COMMIT TRAN

SET @nRet = 0
RETURN

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_ChargeItem_UseStatPointInitDel]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_ChargeItem_UseStatPointInitDel]
GO
/****** 개체: 저장 프로시저 dbo.usp_ChargeItem_UseStatPointInitDel    스크립트 날짜: 2007-03-13 오후 6:25:13 ******/

CREATE PROCEDURE [dbo].[usp_ChargeItem_UseStatPointInitDel]
/*
Charge item use - Stat point init and use item delete
2006.6 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Error clear character stat point.
	        2 = Error delete used charge item
*/

@nCharNo int,
@nDeleteItemKey bigint,
@nRet tinyint OUTPUT

AS

SET NOCOUNT ON

BEGIN TRAN

-- Clear character stat point.
UPDATE tCharacter SET 
	nStrength = 0, 
	nConstitute = 0, 
	nDexterity = 0, 
	nIntelligence = 0, 
	nMentalPower = 0
WHERE nCharNo = @nCharNo

IF @@ERROR <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = 1
	RETURN
END

-- Delete used charge item
DECLARE @TempRet int
EXEC p_Item_Delete @nDeleteItemKey, @TempRet OUTPUT
IF @TempRet <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = 2
	RETURN
END

-- Done
COMMIT TRAN

SET @nRet = 0
RETURN

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_ChargeItem_UseStatPointInitLotChange]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_ChargeItem_UseStatPointInitLotChange]
GO
/****** 개체: 저장 프로시저 dbo.usp_ChargeItem_UseStatPointInitLotChange    스크립트 날짜: 2007-03-13 오후 6:25:12 ******/

CREATE PROCEDURE [dbo].[usp_ChargeItem_UseStatPointInitLotChange]
/*
Charge item use - Stat point init and use item lot change
2006.6 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Error clear character stat point.
	        2 = Error used charge item change lot
*/

@nCharNo int,
@nChangeItemKey bigint,
@nChangeItemOptionType smallint,
@nChangeItemOptionData bigint,		
@nRet tinyint OUTPUT

AS

SET NOCOUNT ON

BEGIN TRAN

-- Clear character stat point.
UPDATE tCharacter SET 
	nStrength = 0, 
	nConstitute = 0, 
	nDexterity = 0, 
	nIntelligence = 0, 
	nMentalPower = 0
WHERE nCharNo = @nCharNo

IF @@ERROR <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = 1
	RETURN
END

-- Used charge item change lot
DECLARE @TempRet int
EXEC p_Item_SetOption @nChangeItemKey, @nChangeItemOptionType, @nChangeItemOptionData, @TempRet OUTPUT
IF @TempRet <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = 2
	RETURN
END

-- Done
COMMIT TRAN

SET @nRet = 0
RETURN

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_ChatBlock_delBlock]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_ChatBlock_delBlock]
GO

/*--------------------------------------------------------------------------------------
' 이  름 : usp_ChatBlock_delBlock
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2009.2.12
' Description :
'   채팅 블럭 삭제
' Parameter :
'	input Parameter
'		@nUserNo : 유저번호(차단하는 유저)
'		@nCharNo : 캐릭터번호(차단당하는 캐릭터)
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-2311 : invaild nUserNo
'				-2312 : invaild nCharNo
'				-2321 : not found data
'				-2392 : db error(delete)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_ChatBlock_delBlock]
	@nUserNo int
,	@nCharNo int
,	@nRet    int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	IF ISNULL(@nUserNo, 0) <= 0 BEGIN
		SET @nRet = -2311
		RETURN
	END

	IF ISNULL(@nCharNo, 0) <= 0 BEGIN
		SET @nRet = -2312
		RETURN
	END

	IF NOT EXISTS(SELECT nUserNo FROM tChatBlock WHERE nUserNo = @nUserNo AND nCharNo = @nCharNo) BEGIN
		SET @nRet = -2323
		RETURN
	END
	ELSE BEGIN
		DELETE FROM tChatBlock WHERE nUserNo = @nUserNo AND nCharNo = @nCharNo
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -2394
		END
	END
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_ChatBlock_delBlockALL]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_ChatBlock_delBlockALL]
GO

/*--------------------------------------------------------------------------------------
' 이  름 : usp_ChatBlock_delBlockALL
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2009.2.12
' Description :
'   채팅 블럭 삭제(해당 유저가 가지고 있는것 모두 삭제)
' Parameter :
'	input Parameter
'		@nUserNo : 유저번호(차단하는 유저)
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-2311 : invaild nUserNo
'				-2321 : not found data
'				-2392 : db error(delete)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_ChatBlock_delBlockALL]
	@nUserNo int
,	@nRet    int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	IF ISNULL(@nUserNo, 0) <= 0 BEGIN
		SET @nRet = -2311
		RETURN
	END

	IF NOT EXISTS(SELECT nUserNo FROM tChatBlock WHERE nUserNo = @nUserNo) BEGIN
		SET @nRet = -2321
		RETURN
	END
	ELSE BEGIN
		DELETE FROM tChatBlock WHERE nUserNo = @nUserNo
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -2394
		END
	END
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_ChatBlock_getBlockList]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_ChatBlock_getBlockList]
GO

/*--------------------------------------------------------------------------------------
' 이  름 : usp_ChatBlock_getBlockList
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2009.2.12
' Description :
'   채팅 블럭 리스트
' Parameter :
'	input Parameter
'		@nUserNo : 유저번호
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-2311 : invaild nUserNo
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_ChatBlock_getBlockList]
	@nUserNo int
,	@nRet    int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	IF ISNULL(@nUserNo, 0) <= 0 BEGIN
		SET @nRet = -2311
		RETURN
	END

	SELECT T1.nCharNo, T2.sID, T2.nAdminLevel, T2.bDeleted
	  FROM tChatBlock T1, tCharacter T2
	 WHERE T1.nUserNo = @nUserNo AND T1.nCharNo = T2.nCharNo
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_ChatBlock_setBlock]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_ChatBlock_setBlock]
GO
/*-------------------------------------------------------------------------------------
' 파일명 : KR_procedureChatBlock.sql
' 내  용 : 채팅 블럭 관련 저장프로시저
' 작성자 : 고동균(kodong@gmail.com)
' 작성일 : 2009.2.12
' Description :
'------------------------------------------------------------------------------------*/

-- usp_ChatBlock_setBlock
-- usp_ChatBlock_delBlock
-- usp_ChatBlock_getBlockList

/*--------------------------------------------------------------------------------------
' 이  름 : usp_ChatBlock_setBlock
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2009.2.12
' Description :
'   채팅 블럭 등록
' Parameter :
'	input Parameter
'		@nUserNo : 유저번호(차단하는 유저)
'		@sID     : 캐릭터명(차단당하는 캐릭터)
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-2311 : invaild nUserNo
'				-2312 : invaild sID
'				-2321 : already join nNo
'				-2322 : limit max count
'				-2323 : not found sID
'				-2392 : db error(insert)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_ChatBlock_setBlock]
	@nUserNo int
,	@sID     nvarchar(40) = ''
,	@nRet    int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	DECLARE @cnt AS int
	DECLARE @maxCnt AS int
	DECLARE @nCharNo AS int

	SET @nRet = 0
	SET @nCharNo = 0
	SET @maxCnt = 100 -- 최대등록 차단수(차후 변경시 DB 저장프로시저만 수정하면 반영됨)

	IF ISNULL(@nUserNo, 0) <= 0 BEGIN
		SET @nRet = -2311
		RETURN
	END

	IF LEN(ISNULL(@sID, '')) = 0 BEGIN
		SET @nRet = -2312
		RETURN
	END

	SELECT @nCharNo = nCharNo FROM tCharacter WHERE sID = @sID AND bDeleted = 0
	IF @nCharNo <= 0 BEGIN
		SET @nRet = -2323
		RETURN
	END

	IF EXISTS(SELECT nUserNo FROM tChatBlock WHERE nUserNo = @nUserNo AND nCharNo = @nCharNo) BEGIN
		SET @nRet = -2321
		RETURN
	END

	SELECT @cnt = ISNULL(COUNT(*), 0) FROM tChatBlock WHERE nUserNo = @nUserNo
	IF @cnt > @maxCnt BEGIN
		SET @nRet = -2322
		RETURN
	END		
	ELSE BEGIN
		INSERT INTO tChatBlock (nUserNo, nCharNo)
		VALUES (@nUserNo, @nCharNo)
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -2392
			RETURN
		END

		SELECT T1.nCharNo, T2.sID, T2.nAdminLevel, T2.bDeleted
		  FROM tChatBlock T1, tCharacter T2
		 WHERE T1.nUserNo = @nUserNo 
		   AND T1.nCharNo = @nCharNo
		   AND T1.nCharNo = T2.nCharNo
	END
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Dice_chgMachineToMoneycard]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Dice_chgMachineToMoneycard]
GO


/*--------------------------------------------------------------------------------------
' 이  름 : usp_Dice_chgMachineToMoneycard
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2009.7.23
' Description :
'   주사위 게임기를 머니카드로 교체함.
'	중요.!!! 교체시 머니카드의 금액을 확정함.
'	중요.!!! 거치된 게임기의 경우 인벤토리로 회수하는 작업을 병행함.
' Parameter :
'	input Parameter
'		@nItemKey       : 게임기 아이템키
'		@nItemIDOld     : 게임기 아이템아이디
'		@nItemIDNew     : 머니카드 아이템아이디
'		@nOptionType    : 배당금 옵션타입
'		@nTotalDividend : 배당금(수익 금액)
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-2412 : invaild @nItemKey
'				-2416 : invaild @nTotalDividend
'				-2417 : invaild @nItemIDOld
'				-2418 : invaild @nItemIDNew
'				-2419 : invaild @nOptionType
'				-2493 : db error(update)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Dice_chgMachineToMoneycard]
	@nItemKey       bigint
,	@nItemIDOld     int
,	@nItemIDNew     int
,	@nOptionType    smallint
,	@nTotalDividend bigint
,	@nRet              int = 0 output
AS
BEGIN
	SET NOCOUNT ON
	SET LOCK_TIMEOUT 5000

	DECLARE @nIsPlace AS smallint 
	DECLARE @nIsPlaceValue AS bigint

	SET @nRet          = 0
	SET @nIsPlace      = 904 -- 가구아이템이 거치된 아이템인지 판단하는 OptionType
	SET @nIsPlaceValue = 0   -- 거치된 아이템을 회수하기 위함 Value

	IF ISNULL(@nItemKey, 0) <= 0 BEGIN
		SET @nRet = -2412
		RETURN
	END

	IF ISNULL(@nItemIDOLD, 0) <= 0 BEGIN
		SET @nRet = -2417
		RETURN
	END

	IF ISNULL(@nItemIDNEW, 0) <= 0 BEGIN
		SET @nRet = -2418
		RETURN
	END

	IF ISNULL(@nOptionType, 0) <= 0 BEGIN
		SET @nRet = -2419
		RETURN
	END

	IF ISNULL(@nTotalDividend, 0) <= 0 BEGIN
		SET @nRet = -2416
		RETURN
	END

	IF EXISTS(SELECT nItemKey FROM tItem WHERE nItemKey = @nItemKey AND nItemID = @nItemIDOLD) BEGIN
		BEGIN TRAN

		-- 게임기의 아이템아이디를 머니카드의 아이템아이디로 교체
		UPDATE tItem SET nItemID = @nItemIDNEW
		 WHERE nItemKey = @nItemKey
		IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
			SET @nRet = -2493
			ROLLBACK TRAN
			RETURN
		END

		-- 거치된 게임기의 경우 인벤토리로 회수하는 작업을 함.
		UPDATE tItemOptions SET nOptionData = @nIsPlaceValue
		 WHERE nItemKey = @nItemKey AND nOptionType = @nIsPlace
		IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
			SET @nRet = -2493
			ROLLBACK TRAN
		END

		-- 머니카드에 배당금을 확정함
		UPDATE tItemOptions SET nOptionData = @nTotalDividend
		 WHERE nItemKey = @nItemKey AND nOptionType = @nOptionType
		IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
			SET @nRet = -2493
			ROLLBACK TRAN
		END
		ELSE BEGIN
			SET @nRet = 0
			COMMIT TRAN
		END
	END
	ELSE BEGIN
		SET @nRet = -2422
	END

	SET LOCK_TIMEOUT -1
	SET NOCOUNT OFF
END


GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Dice_getDiceExpect]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Dice_getDiceExpect]
GO


/*--------------------------------------------------------------------------------------
' 이  름 : usp_Dice_getDiceExpect
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2009.6.30
' Description :
'   주사위 게임에서 방장의 수익 금액을 계산함
' Parameter :
'	input Parameter
'		@nCharNo  : 방장 캐릭터번호
'		@nItemKey : 아이템키
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-2411 : invaild @nCharNo
'				-2412 : invaild @nItemKey
'	return Record
'		nCount
'		nTotalDividend
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Dice_getDiceExpect]
	@nCharNo  int
,	@nItemKey bigint
,	@nRet     int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	IF ISNULL(@nCharNo, 0) <= 0 BEGIN
		SET @nRet = -2411
		RETURN
	END

	IF ISNULL(@nItemKey, 0) <= 0 BEGIN
		SET @nRet = -2412
		RETURN
	END

	SELECT ISNULL(COUNT(DISTINCT(A.nGameNo)), 0) AS nCount, ISNULL(SUM(nTotalDividend), 0) AS nTotalDividend
	  FROM tDice AS A, tDiceResult AS B
	 WHERE A.nGameNo = B.nGameNo
	   AND A.nCharNo = @nCharNo
	   AND A.nItemKey = @nItemKey

	SET NOCOUNT OFF
END


GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Dice_getDiceRank]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Dice_getDiceRank]
GO


/*--------------------------------------------------------------------------------------
' 이  름 : usp_Dice_getDiceRank
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2009.6.30
' Description :
'   주사위 게임에서 아이템당 순위를 가져옴.
'	상위 20 캐릭터
' Parameter :
'	input Parameter
'		@nCharNo  : 방장 캐릭터번호
'		@nItemKey : 아이템키
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-2411 : invaild @nCharNo
'				-2412 : invaild @nItemKey
'	return Record
'		nCustomCharNo, nWinCount
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Dice_getDiceRank]
	@nCharNo  int
,	@nItemKey bigint
,	@nRet     int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	IF ISNULL(@nCharNo, 0) <= 0 BEGIN
		SET @nRet = -2411
		RETURN
	END

	IF ISNULL(@nItemKey, 0) <= 0 BEGIN
		SET @nRet = -2412
		RETURN
	END

	SELECT TOP 20 C.sID, COUNT(B.nGameNo) AS nWinCount
	  FROM tDice AS A, tDiceLog AS B, tCharacter AS C
	 WHERE A.nGameNo = B.nGameNo
	   AND B.nCustomCharNo = C.nCharNo
	   AND A.nCharNo = @nCharNo
	   AND A.nItemKey = @nItemKey
	   AND B.bStatus = 1
	   AND C.bDeleted = 0
	 GROUP BY C.sID
	 ORDER BY nWinCount DESC

	SET NOCOUNT OFF
END


GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Dice_setDice]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Dice_setDice]
GO

/*-------------------------------------------------------------------------------------
' 파일명 : KR_procedureDice.sql
' 내  용 : 주사위 게임 관련 저장프로시저
' 작성자 : 고동균(kodong@gmail.com)
' 작성일 : 2009.6.30
' Description :
'	주사위 게임 관련 저장프로시저
'------------------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------------------
' 이  름 : usp_Dice_setDice
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2009.6.30
' Description :
'   주사위 게임에서 한판이 끝났을때 결과를 저장함.
' Parameter :
'	input Parameter
'		@nCharNo  : 방장 캐릭터번호
'		@nItemKey : 아이템키
'		@sDice    : 주사위 결과
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-2411 : invaild @nCharNo
'				-2412 : invaild @nItemKey
'				-2413 : invaild @sDice
'				-2492 : db error(insert)
'	return Record
'		nGameNo
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Dice_setDice] 
	@nCharNo  int
,	@nItemKey bigint
,	@sDice    nvarchar(3)
,	@nRet     int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	DECLARE @nGameNo AS int

	SET @nRet    = 0
	SET @nGameNo = 0

	IF ISNULL(@nCharNo, 0) <= 0 BEGIN
		SET @nRet = -2411
		RETURN
	END

	IF ISNULL(@nItemKey, 0) <= 0 BEGIN
		SET @nRet = -2412
		RETURN
	END

	IF LEN(ISNULL(@sDice, '')) <= 0 BEGIN
		SET @nRet = -2413
		RETURN
	END

	INSERT INTO tDice (nCharNo, nItemKey, sDice)
	VALUES (@nCharNo, @nItemKey, @sDice)
	IF @@ERROR <> 0 OR @@IDENTITY = 0 BEGIN
		SET @nRet = -2492
		RETURN
	END
	ELSE BEGIN
		SET @nGameNo = @@IDENTITY
		SELECT @nGameNo
	END

	SET NOCOUNT OFF
END


GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Dice_setDiceLog]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Dice_setDiceLog]
GO


/*--------------------------------------------------------------------------------------
' 이  름 : usp_Dice_setDiceLog
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2009.6.30
' Description :
'   주사위 게임에서 한판이 끝났을때 각 유저의 로그를 기록함
' Parameter :
'	input Parameter
'		@nGameNo       : 게임번호
'		@nCustomCharNo : 고객 캐릭터번호
'		@nSlotNo       : 슬롯번호
'		@nBattingMoney : 배팅금액
'		@nBattingRate  : 배당율
'		@bStatus       : 승/패(0:패/1:승)
'		@nTaxRate      : 세금비율
'		@nDividend     : 배당금
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-2492 : db error(insert)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Dice_setDiceLog]
	@nGameNo       int 
,	@nCustomCharNo int
,	@nSlotNo       int
,	@nBattingMoney bigint
,	@nBattingRate  int
,	@bStatus       bit
,	@nTaxRate      int
,	@nDividend     bigint
,	@nRet          int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	INSERT INTO tDiceLog (nGameNo, nCustomCharNo, nSlotNo, nBattingMoney, nBattingRate, bStatus, nTaxRate, nDividend)
	VALUES (@nGameNo, @nCustomCharNo, @nSlotNo, @nBattingMoney, @nBattingRate, @bStatus, @nTaxRate, @nDividend)
	IF @@ERROR <> 0 BEGIN
		SET @nRet = -2492
		RETURN
	END

	SET NOCOUNT OFF
END


GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Dice_setDicePay]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Dice_setDicePay]
GO



/*--------------------------------------------------------------------------------------
' 이  름 : usp_Dice_setDicePay
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2009.7.22
' Description :
'   주사위 게임에서 방장에게 수익 금액을 지급함.
' Parameter :
'	input Parameter
'		@nCharNo        : 방장 캐릭터번호
'		@nItemKey       : 머니카드(게임기) 아이템키
'		@nTotalDividend : 배당금(수익 금액)
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-2411 : invaild @nCharNo
'				-2412 : invaild @nItemKey
'				-2416 : invaild @nTotalDividend
'				-2492 : db error(insert) : 로그기록 실패
'				-2493 : db error(update) : 배당금 지급 실패
'				-2494 : db error(delete) : 머니카드 아이템키 삭제 실패
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Dice_setDicePay]
	@nCharNo        int
,	@nItemKey       bigint
,	@nTotalDividend bigint
,	@nRet           int = 0 output
AS
BEGIN
	SET NOCOUNT ON
	SET LOCK_TIMEOUT 5000

	SET @nRet = 0

	IF ISNULL(@nCharNo, 0) <= 0 BEGIN
		SET @nRet = -2411
		RETURN
	END

	IF ISNULL(@nItemKey, 0) <= 0 BEGIN
		SET @nRet = -2412
		RETURN
	END

	IF ISNULL(@nTotalDividend, 0) <= 0 BEGIN
		SET @nRet = -2416
		RETURN
	END

	BEGIN TRAN

	-- 머니카드 아이템 삭제
	DELETE FROM tItem WHERE nItemKey = @nItemKey
	IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
		SET @nRet = -2494
		ROLLBACK TRAN
		RETURN
	END

	-- 돈 지급
	UPDATE tCharacter SET nMoney = nMoney + @nTotalDividend WHERE nCharNo = @nCharNo
	IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
		SET @nRet = -2493
		ROLLBACK TRAN
		RETURN
	END

	-- 돈 지급 로그
	INSERT INTO tDicePayLog (nCharNo, nItemKey, nTotalDividend)
	VALUES (@nCharNo, @nItemKey, @nTotalDividend)
	IF @@ERROR <> 0 BEGIN
		SET @nRet = -2492
		ROLLBACK TRAN
		RETURN
	END
	ELSE BEGIN
		SET @nRet = 0
		COMMIT TRAN
		RETURN
	END

	SET LOCK_TIMEOUT -1
	SET NOCOUNT OFF
END


GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Dice_setDiceResult]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Dice_setDiceResult]
GO


/*--------------------------------------------------------------------------------------
' 이  름 : usp_Dice_setDiceResult
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2009.6.30
' Description :
'   주사위 게임에서 한판이 끝났을때 각 유저의 총 배당금을 지급함.
' Parameter :
'	input Parameter
'		@nGameNo        : 게임번호
'		@nCustomCharNo  : 고객 캐릭터번호
'		@nTotalDividend : 배당금 총 합계
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-2414 : invaild @nGameNo
'				-2415 : invaild @nCustomCharNo
'				-2421 : not enough Money
'				-2492 : db error(insert)
'				-2493 : db error(update)
'	return Record
'		nCustomCharNo, nMoney
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Dice_setDiceResult] 
	@nGameNo        int
,	@nCustomCharNo  int
,	@nTotalDividend bigint
,	@nRet           int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	DECLARE @money AS bigint

	SET @nRet  = 0
	SET @money = 0

	IF ISNULL(@nGameNo, 0) <= 0 BEGIN
		SET @nRet = -2414
		RETURN
	END

	IF ISNULL(@nCustomCharNo, 0) <= 0 BEGIN
		SET @nRet = -2415
		RETURN
	END

	BEGIN TRAN

	SELECT @money = nMoney FROM tCharacter WHERE nCharNo = @nCustomCharNo
	IF ( @money + @nTotalDividend ) >= 0 BEGIN
		UPDATE tCharacter SET nMoney = nMoney + @nTotalDividend
		WHERE nCharNo = @nCustomCharNo
		IF @@ERROR <> 0 OR @@ROWCOUNT > 1 BEGIN
			SET @nRet = - 2493
			ROLLBACK TRAN
			RETURN
		END

		INSERT INTO tDiceResult (nGameNo, nCustomCharNo, nBeforeMoney, nTotalDividend, nAfterMoney)
		VALUES (@nGameNo, @nCustomCharNo, @money, @nTotalDividend, @money + @nTotalDividend)
		IF @@ERROR <> 0 BEGIN
			SET @nRet = - 2492
			ROLLBACK TRAN
			RETURN
		END
		ELSE BEGIN
			SET @nRet = 0
			COMMIT TRAN
		END
	END
	ELSE BEGIN
		SET @nRet = -2421
		ROLLBACK TRAN
		RETURN
	END

	SELECT nCharNo AS nCustomCharNo, nMoney FROM tCharacter WHERE nCharNo = @nCustomCharNo

	SET NOCOUNT OFF
END


GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Guild_GetToken]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Guild_GetToken]
GO





CREATE  PROCEDURE [dbo].[usp_Guild_GetToken]
/*
Get Guild Token
2008.12 By Lunar
Input:
	See SQL
	
Output:
	nRet = 0,  Error(Not found guild)
	nRet = 1,  OK
*/
@nNo int,
@nToken bigint output,
@nRet int output
AS
SET NOCOUNT ON
SET @nRet = 0
SELECT @nToken = ISNULL(MAX(nToken), 0) FROM tGuildToken WHERE nNo = @nNo
IF @@ERROR <> 0 --OR @@ROWCOUNT <> 1
BEGIN
	SET @nRet = -1
	RETURN
END
-- end




GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Guild_GetTokenAll]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Guild_GetTokenAll]
GO





/*--------------------------------------------------------------------------------------
' 이  름 : usp_Guild_GetTokenAll
' 작성자 : 
' 작성일 : 
' Description :
'  길드  토너먼트 보상 토큰 데이터
' Parameter :
'	input Parameter
'		
'		
'	output Parameter
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Guild_GetTokenAll]
AS
BEGIN
	SET NOCOUNT ON
	SELECT nNo, nToken FROM tGuildToken
	SET NOCOUNT OFF
END




GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Guild_SetToken]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Guild_SetToken]
GO





CREATE  PROCEDURE [dbo].[usp_Guild_SetToken]
/*
Set Guild Token
2008.12 By Lunar
Input:
	See SQL
	
Output:
	nRet = -1,  Error(Not found guild)
	nRet = -2,  Error(Not found guild)
	nRet = 1,  OK
*/
@nNo int,
@nToken bigint,
@nRet int output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	IF EXISTS(SELECT nNo FROM tGuildToken WHERE nNo = @nNo) BEGIN
		UPDATE tGuildToken SET nToken = @nToken WHERE nNo = @nNo
		IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
			SET @nRet = -1
			RETURN
		END
	END
	ELSE BEGIN
		INSERT INTO tGuildToken (nNo, nToken)
		VALUES (@nNo, @nToken)
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -2
			RETURN
		END
	END			
	
	SET NOCOUNT OFF
END
-- end





GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Guild_TokenSub]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Guild_TokenSub]
GO




CREATE PROCEDURE [dbo].[usp_Guild_TokenSub]
/*
Sub money
2008.12 By Lunar
 input:
	see SQL
 output:
	@nRet	1 = OK
	        0 = Error, or Minus value
*/
@nGuildNo int,
@nSubToken bigint,
@nRet int OUTPUT
AS
SET NOCOUNT ON
DECLARE @nGuildToken bigint
EXEC usp_Guild_GetToken @nGuildNo, @nGuildToken OUTPUT, @nRet OUTPUT
IF @nRet <> 0
	RETURN
-- Sub money
SET @nGuildToken = @nGuildToken - @nSubToken
-- Check minus
IF @nGuildToken < 0
BEGIN
	SET @nRet = -1
	RETURN	
END
EXEC usp_Guild_SetToken @nGuildNo, @nGuildToken, @nRet OUTPUT
-- End




GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildAcademy_delMember]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildAcademy_delMember]
GO

/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_GuildAcademy_delMember
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.4.28
' Description :
'   ±æµå¾ÆÄ«µ¥¹Ì Å»Åð
' Parameter :
'	input Parameter
'		@nNo 	 : ±æµå¹øÈ£
'		@nCharNo : Ä³¸¯ÅÍ¹øÈ£
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1511 : invalid nNo
'				-1512 : invalid nCharNo
'				-1592 : db error(delete)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildAcademy_delMember]
	@nNo     int
,	@nCharNo int
,	@nRet    int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	IF @nNo <= 0 BEGIN
		SET @nRet = -1511
		RETURN
	END

	IF @nCharNo <= 0 BEGIN
		SET @nRet = -1512
		RETURN
	END

	DELETE FROM tGuildAcademyMember WHERE nNo = @nNo AND nCharNo = @nCharNo
	IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
		SET @nRet = -1592
	END

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildAcademy_delReward]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildAcademy_delReward]
GO

/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_GuildAcademy_delReward
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.5.8.
' Description :
'   ±æµå¾ÆÄ«µ¥¹Ì º¸»ó ÃÊ±âÈ­(·¹ÄÚµå ´ÜÀ§)
' Parameter :
'	input Parameter
'		@nNo 	 : ±æµå¹øÈ£
'		@nLevel  : ·¹º§
'		@nTypeID : º¸»óÅ¸ÀÔ
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1511 : invaild nNo
'				-1596 : db error(delete)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildAcademy_delReward]
	@nNo     int
,	@nLevel  smallint
,	@nTypeID tinyint
,	@nRet    int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	IF @nNo <= 0 BEGIN
		SET @nRet = -1511
		RETURN
	END

	IF @nTypeID = 1 BEGIN
		DELETE FROM tGuildAcademyReward WHERE nNo = @nNo AND nLevel = @nLevel AND nTypeID = @nTypeID
		IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
			SET @nRet = -1596
			RETURN
		END
	END
	ELSE BEGIN
		DELETE FROM tGuildAcademyReward WHERE nNo = @nNo AND nLevel = @nLevel AND nTypeID > 1
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -1596
			RETURN
		END
	END

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildAcademy_delRewardAll]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildAcademy_delRewardAll]
GO

/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_GuildAcademy_delRewardAll
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.5.8.
' Description :
'   ±æµå¾ÆÄ«µ¥¹Ì º¸»ó ÃÊ±âÈ­(ÀüÃ¼)
' Parameter :
'	input Parameter
'		@nNo 	 : ±æµå¹øÈ£
'		@nTypeID : º¸»óÅ¸ÀÔ
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1511 : invaild nNo
'				-1595 : db error(delete)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildAcademy_delRewardAll]
	@nNo     int
,	@nTypeID tinyint
,	@nRet    int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	IF @nNo <= 0 BEGIN
		SET @nRet = -1511
		RETURN
	END

	IF @nTypeID = 1 BEGIN
		DELETE FROM tGuildAcademyReward WHERE nNo = @nNo AND nTypeID = @nTypeID
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -1596
			RETURN
		END
	END
	ELSE BEGIN
		DELETE FROM tGuildAcademyReward WHERE nNo = @nNo AND nTypeID > 1
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -1596
			RETURN
		END
	END

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildAcademy_depositMoney]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildAcademy_depositMoney]
GO

/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_GuildAcademy_depositMoney
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.5.14.
' Description :
'   ±æµå¾ÆÄ«µ¥¹Ì¿¡ ÀÔ±ÝÇÏ±â
' Parameter :
'	input Parameter
'		@nNo 	 : ±æµå¹øÈ£
'		@nCharNo : Ä³¸¯ÅÍ¹øÈ£
'		@nMoney  : ±Ý¾×
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1511 : invaild nNo
'				-1512 : invaild nCharNo
'				-1514 : invaild nMoney
'				-1524 : not enough money
'				-1525 : invaild nNo
'				-1526 : invaild nCharNo
'				-1593 : db error
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildAcademy_depositMoney]
	@nNo     int
,	@nCharNo int
,	@nMoney  bigint
,	@nRet    int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	DECLARE @money AS bigint
	SET @nRet = 0
	SET @money = 0

	IF @nNo <= 0 BEGIN
		SET @nRet = -1511
		RETURN
	END

	IF @nCharNo <= 0 BEGIN
		SET @nRet = -1512
		RETURN
	END

	IF @nMoney <= 0 BEGIN
		SET @nRet = -1514
		RETURN
	END

	BEGIN TRAN
	
	IF NOT EXISTS(SELECT nCharNo FROM tCharacter WHERE nCharNo = @nCharNo AND bDeleted = 0) BEGIN
		SET @nRet = -1524
		ROLLBACK TRAN
		RETURN
	END

	IF NOT EXISTS(SELECT nNo FROM tGuildAcademy WHERE nNo = @nNo) BEGIN
		SET @nRet = -1525
		ROLLBACK TRAN
		RETURN
	END

	SELECT @money = nMoney FROM tCharacter WHERE nCharNo = @nCharNo
	IF @money < @nMoney BEGIN		
		SET @nRet = -1526
		ROLLBACK TRAN
		RETURN
	END
	ELSE BEGIN
		UPDATE tCharacter SET nMoney = nMoney - @nMoney WHERE nCharNo = @nCharNo
		IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
			SET @nRet = -1593
			ROLLBACK TRAN
			RETURN
		END

		UPDATE tGuildAcademy SET nMoney = nMoney + @nMoney WHERE nNo = @nNo
		IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
			SET @nRet = -1593
			ROLLBACK TRAN
			RETURN
		END
		ELSE BEGIN
			SET @nRet = 0
			COMMIT TRAN
		END
	END
			
	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildAcademy_getGraduateCount]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildAcademy_getGraduateCount]
GO

/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_GuildAcademy_getGraduateCount
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.5.16.
' Description :
'   ±æµå¾ÆÄ«µ¥¹Ì Á¹¾÷»ý ÃÑ¼ö
' Parameter :
'	input Parameter
'		@nNo 	        : ±æµå¹øÈ£
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1511 : invaild nNo
'				-1591 : db error(select)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildAcademy_getGraduateCount]
	@nNo int
,	@nRet int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	IF @nNo <= 0 BEGIN
		SET @nRet = -1511
		RETURN
	END

	SELECT ISNULL(COUNT(nCharNo), 0) AS cnt
	  FROM tGuildAcademyGraduate
	 WHERE nNo = @nNo
	IF @@ERROR <> 0 BEGIN
		SET @nRet = -1591
	END

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildAcademy_getGraduateList]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildAcademy_getGraduateList]
GO

/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_GuildAcademy_getGraduateList
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.5.16.
' Description :
'   ±æµå¾ÆÄ«µ¥¹Ì Á¹¾÷»ý ¸®½ºÆ®
' Parameter :
'	input Parameter
'		@nNo 	        : ±æµå¹øÈ£
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1511 : invaild nNo
'				-1591 : db error(select)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildAcademy_getGraduateList]
	@nNo int
,	@nRet int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	IF @nNo <= 0 BEGIN
		SET @nRet = -1511
		RETURN
	END

	SELECT sID, nClass, nJoinLevel, dJoinDate, nGraduateLevel, dGraduateDate
	  FROM tGuildAcademyGraduate
	 WHERE nNo = @nNo
	IF @@ERROR <> 0 BEGIN
		SET @nRet = -1591
	END

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildAcademy_getGuildAcademyList]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildAcademy_getGuildAcademyList]
GO

/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_GuildAcademy_getGuildAcademyList
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.4.29
' Description :
'   ±æµå¾ÆÄ«µ¥¹Ì ¸®½ºÆ®
' Parameter :
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1594 : db error(select)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildAcademy_getGuildAcademyList]
	@nRet int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	SELECT GA.nNo, nMasterCharNo, C1.sID, nMaxMember, GA.nMoney, nPoint
		 , T2.nRanking, ISNULL(dBuffEndTime, GETDATE()), ISNULL(dNotifyDate, GETDATE()), ISNULL(sNotify, ''), ISNULL(sIntro, '')
		 , T1.nCharNo, T1.sID, ISNULL(T3.nGraduateCount, 0) AS nGraduateCount
	  FROM tGuildAcademy AS GA INNER JOIN 
		   tCharacter AS C1 ON GA.nMasterCharNo = C1.nCharNo INNER JOIN (
				SELECT G.nNo, GM.nCharNo, C.sID
				  FROM tGuild AS G, tGuildMember AS GM, tCharacter AS C
				 WHERE G.nNo = GM.nNo AND GM.nCharNo = C.nCharNo
				   AND GM.nGrade = 0 AND C.bDeleted = 0
				) AS T1 ON GA.nNo = T1.nNo INNER JOIN (
				-- ranking check
				SELECT T1.nNo, COUNT(T2.nPoint) + 1 AS nRanking
				  FROM tGuildAcademy T1 LEFT OUTER JOIN tGuildAcademy T2 ON T1.nPoint < T2.nPoint
				 GROUP BY T1.nNo, T1.nPoint
				) AS T2 ON GA.nNo = T2.nNo LEFT OUTER JOIN (
				-- graduate counting
				SELECT nNo, ISNULL(COUNT(nCharNo), 0) AS nGraduateCount
				  FROM tGuildAcademyGraduate
				 GROUP BY nNo
				) AS T3 ON GA.nNo = T3.nNo
	 ORDER BY T2.nRanking
	IF @@ERROR <> 0
		BEGIN
			SET @nRet = -1594
		END

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildAcademy_getGuildNo]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildAcademy_getGuildNo]
GO
	
/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_GuildAcademy_getGuildNo
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.4.28
' Description :
'   ÀÔ·Â¹ÞÀº charNo°¡ ¼Ò¼ÓµÈ ±æµå¹øÈ£
' Parameter :
'	input Parameter
'		@nCharNo : Ä³¸¯ÅÍ¹øÈ£
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1512 : invalid nCharNo
'				-1521 : not found nNo
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildAcademy_getGuildNo]
	@nCharNo int
,	@nRet    int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	IF @nCharNo <= 0 BEGIN
		SET @nRet = -1512
		RETURN
	END

	IF EXISTS(SELECT nNo FROM tGuildAcademyMember WHERE nCharNo = @nCharNo) BEGIN
		SELECT nNo FROM tGuildAcademyMember WHERE nCharNo = @nCharNo
	END
	ELSE BEGIN
		-- 2008.8.28 ÀÏ ¾÷µ¥ÀÌÆ®½Ã ¼­¹öÇÁ·Î±×·¥ÀÇ ¼öÁ¤ ½Ç¼ö·Î ÀÎÇØ
		-- Á¤»óÀûÀÎ Ã³¸®°¡ µÇÁö ¾Ê´Â Çö»óÀÌ ¹ß»ýÇÔ.
		-- 2008.9.4 ÀÏ ¾÷µ¥ÀÌÆ®½Ã Á¤»óÀûÀ¸·Î ÁøÇàÇÒ ¿¹Á¤ÀÓ.
		-- SET @nRet = -1521
		SET @nRet = 0
	END

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildAcademy_getMemberList]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildAcademy_getMemberList]
GO

/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_GuildAcademy_getMemberList
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.4.28
' Description :
'   ±æµå¾ÆÄ«µ¥¹Ì¿¡ ¼Ò¼ÓµÈ ¸É¹ö¸®½ºÆ®
' Parameter :
'	input Parameter
'		@nNo 	: ±æµå¹øÈ£
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1511 : invalid nNo
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildAcademy_getMemberList]
	@nNo  int
,	@nRet int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	IF @nNo <= 0 BEGIN
		SET @nRet = -1511
		RETURN
	END

	SELECT G.nCharNo, G.nJoinLevel, G.dJoinDate, G.nGrade, G.sIntro
		 , C.sID, C.nLevel, C.sLoginZone, C.dLastLoginDate
		 , S.nClass
	  FROM tGuildAcademyMember AS G INNER JOIN 
		   tCharacter          AS C ON C.nCharNo =  G.nCharNo INNER JOIN 
		   tCharacterShape     AS S ON S.nCharNo =  G.nCharNo
	 WHERE G.nNo = @nNo AND C.bDeleted = 0

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildAcademy_getMoney]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildAcademy_getMoney]
GO

/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_GuildAcademy_getMoney
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.5.27
' Description :
'   ÀÔ·Â¹ÞÀº ¾ÆÄ«µ¥¹ÌÀÇ Money¸¦ °¡Á®¿È.
' Parameter :
'	input Parameter
'		@nNo     : ±æµå¾ÆÄ«µ¥¹Ì¹øÈ£
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1521 : not found nNo
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildAcademy_getMoney]
	@nNo  int
,	@nRet int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	IF EXISTS(SELECT nNo FROM tGuildAcademy WHERE nNo = @nNo) BEGIN
		SELECT nMoney FROM tGuildAcademy WHERE nNo = @nNo
	END
	ELSE BEGIN
		SET @nRet = -1521
	END

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildAcademy_getRanking]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildAcademy_getRanking]
GO


/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_GuildAcademy_getRanking
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.5.26.
' Description :
'   ±æµå¾ÆÄ«µ¥¹Ì ·©Å·À» °¡Á®¿À´Â ÀúÀåÇÁ·Î½ÃÀú
' Parameter :
'	input Parameter
'		@nCount   : »êÁ¤±âÁØÀÏ
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1511 : invaild nNo
'				-1591 : db error(select)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildAcademy_getRanking]
	@nCount int = 1
,	@nRet   int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	DECLARE @MAX_COUNT AS INT

	SELECT @MAX_COUNT = ISNULL(MAX(nCount), 0)
	  FROM tGuildAcademyRanking
	
	SELECT dDate, nRanking, nGuildNo, sGuildName, nMasterNo, sMasterID, nPoint
	  FROM tGuildAcademyRanking
	 WHERE nCount = @MAX_COUNT - (@nCount - 1)

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildAcademy_getReward]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildAcademy_getReward]
GO

/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_GuildAcademy_getReward
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.5.8.
' Description :
'   ±æµå¾ÆÄ«µ¥¹Ì º¸»ó ¸®½ºÆ®(·¹º§º°)
' Parameter :
'	input Parameter
'		@nNo 	 : ±æµå¹øÈ£
'		@nLevel  : ·¹º§
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1511 : invaild nNo
'				-1513 : invaild nLevel
'				-1591 : db error
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildAcademy_getReward]
	@nNo    int
,	@nLevel tinyint
,	@nRet   int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	IF @nNo <= 0 BEGIN
		SET @nRet = -1511
		RETURN
	END

	IF @nLevel <= 0 BEGIN
		SET @nRet = -1513
		RETURN
	END

	SELECT nTypeID, nValue, nItemID FROM tGuildAcademyReward WHERE nNo = @nNo AND nLevel = @nLevel
	IF @@ERROR <> 0 BEGIN
		SET @nRet = -1591
	END	

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildAcademy_getRewardAll]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildAcademy_getRewardAll]
GO

/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_GuildAcademy_getRewardAll
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.5.8.
' Description :
'   ±æµå¾ÆÄ«µ¥¹Ì º¸»ó ¸®½ºÆ®(ÀüÃ¼)
' Parameter :
'	input Parameter
'		@nNo 	 : ±æµå¹øÈ£
'		@nTypeID : º¸»óÅ¸ÀÔ
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1511 : invaild nNo
'				-1591 : db error
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildAcademy_getRewardAll]
	@nNo     int
,	@nTypeID int
,	@nRet    int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	IF @nNo <= 0 BEGIN
		SET @nRet = -1511
		RETURN
	END

	IF @nTypeID = 1 BEGIN
		SELECT nLevel, nTypeID, nValue, nItemID FROM tGuildAcademyReward WHERE nNo = @nNo AND nTypeID = 1
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -1591
		END	
	END 
	ELSE BEGIN
		SELECT nLevel, nTypeID, nValue, nItemID FROM tGuildAcademyReward WHERE nNo = @nNo AND nTypeID > 1
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -1591
		END	
	END

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildAcademy_raiseMember]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildAcademy_raiseMember]
GO

/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_GuildAcademy_raiseMember
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.7.7
' Description :
'   ±æµå¾ÆÄ«µ¥¹Ì ÀÎ¿øÀÌ ±æµå ÀÎ¿øÀ¸·Î ½Â°ÝÇÒ¶§ »ç¿ë.
' Parameter :
'	input Parameter
'		@nNo     : ±æµå¹øÈ£
'		@nCharNo : Ä³¸¯ÅÍ¹øÈ£
'		@nGrade  : µî±Þ
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1528 : ±æµå¾ÆÄ«µ¥¹Ì ¸â¹ö°¡ ¾Æ´Ô
'				-1530 : ±æµå °¡ÀÔÀÎ¿øÀ» ÃÊ°úÇÔ.
'				-1531 : db error(±æµå °¡ÀÔ)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildAcademy_raiseMember]
	@nNo     int
,	@nCharNo int
,	@nGrade  tinyint
,	@nRet    int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	DECLARE @nMax AS INT
	DECLARE @nCnt AS INT

	SET @nRet = 0

	IF EXISTS(SELECT nNo FROM tGuildAcademyMember WHERE nNo = @nNo AND nCharNo = @nCharNo) BEGIN
		SELECT @nMax = nMaxMembers, @nCnt = nCnt
		  FROM tGuild AS T1 INNER JOIN (
				SELECT nNo, ISNULL(COUNT(*), 0) AS nCnt
				  FROM tCharacter AS C, tGuildMember AS G
				 WHERE C.nCharNo = G.nCharNo 
				   AND G.nNo = @nNo
				   AND C.bDeleted = 0
				 GROUP BY nNo) AS T2 ON (T1.nNo = T2.nNo)
		IF @nCnt < @nMax BEGIN
			BEGIN TRAN
	
			-- ±æµå¾ÆÄ«µ¥¹Ì Å»Åð(0:ok)
			EXEC usp_GuildAcademy_delMember @nNo, @nCharNo, @nRet output
			IF @nRet <> 0 BEGIN
				ROLLBACK TRAN
				RETURN
			END
	
			-- ±æµå °¡ÀÔ(1:ok)
			EXEC p_Guild_Member_Join @nNo, @nCharNo, @nGrade, @nRet output
			IF @nRet <> 1 BEGIN
				SET @nRet = -1531
				ROLLBACK TRAN
				RETURN
			END
			ELSE BEGIN
				SET @nRet = 0
				COMMIT TRAN
			END
		END
		ELSE BEGIN
			SET @nRet = -1530
		END
	END
	ELSE BEGIN
		SET @nRet = -1528
	END
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildAcademy_setAcademy]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildAcademy_setAcademy]
GO


/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_GuildAcademy_setAcademy
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.5.30
' Description :
'   ±æµå¾ÆÄ«µ¥¹Ì »ý¼º
'	±æµå¸¦ »ý¼ºÇÏ´Â ÀúÀåÇÁ·Î½ÃÀú¿¡¼­ È£ÃâµÇ´Â ÀúÀåÇÁ·Î½ÃÀúÀÓ.
' Parameter :
'	input Parameter
'		@nNo           : ±æµå¹øÈ£
'		@nMasterCharNo : ±æµå¾ÆÄ«µ¥¹Ì ¸¶½ºÅÍ¹øÈ£
'		@nMaxMember    : °¡ÀÔÁ¦ÇÑÀÎ¿ø
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1521 : already join nNo
'				-1592 : db error(insert)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildAcademy_setAcademy]
	@nNo           int
,	@nMasterCharNo int
,	@nMaxMember    smallint
,	@nRet          int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	IF EXISTS(SELECT nNo FROM tGuildAcademy WHERE nNo = @nNo) BEGIN
		SET @nRet = -1521
		RETURN
	END
	ELSE BEGIN
		INSERT INTO tGuildAcademy (nNo, nMasterCharNo, nMaxMember)
		VALUES (@nNo, @nMasterCharNo, @nMaxMember)
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -1592
			RETURN
		END
	END
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildAcademy_setGraduate]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildAcademy_setGraduate]
GO

/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_GuildAcademy_setGraduate
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.5.16.
' Description :
'   ±æµå¾ÆÄ«µ¥¹Ì Á¹¾÷»ý µî·Ï
' Parameter :
'	input Parameter
'		@nNo 	        : ±æµå¹øÈ£
'		@nCharNo        : Ä³¸¯ÅÍ¹øÈ£
'		@sID            : Ä³¸¯ÅÍ¸í
'		@nClass         : Å¬·¡½º¹øÈ£(DEFINE µÇ¾îÀÖÀ½)
'		@nGraduateLevel : Á¹¾÷·¹º§
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1511 : invaild nNo
'				-1512 : invaild nCharNo
'				-1515 : invaild sID
'				-1516 : invaild nClass
'				-1517 : invaild nGraduateLevel
'				-1528 : ±æµå¾ÆÄ«µ¥¹Ì °¡ÀÔÁ¤º¸°¡ ¾ø½À´Ï´Ù.
'				-1592 : db error(insert)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildAcademy_setGraduate]
	@nNo            int
,	@nCharNo        int
,	@sID            nvarchar(40)
,	@nClass         tinyint
,	@nGraduateLevel smallint
,	@nRet           int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	DECLARE @nJoinLevel smallint
	DECLARE @dJoinDate  datetime

	SET @nRet = 0
	SET @nJoinLevel = 0

	IF @nNo <= 0 BEGIN
		SET @nRet = -1511
		RETURN
	END

	IF @nCharNo <= 0 BEGIN
		SET @nRet = -1512
		RETURN
	END

	IF LEN(ISNULL(@sID, '')) = 0 BEGIN
		SET @nRet = -1515
		RETURN
	END

	IF @nClass <= 0 BEGIN
		SET @nRet = -1516
		RETURN
	END

	IF @nGraduateLevel <= 0 BEGIN
		SET @nRet = -1517
		RETURN
	END

	SELECT @nJoinLevel = nJoinLevel, @dJoinDate = dJoinDate
	  FROM tGuildAcademyMember
	 WHERE nNo = @nNo AND nCharNo = @nCharNo
	IF @nJoinLevel <= 0 BEGIN
		SET @nRet = -1528
		RETURN
	END
	ELSE BEGIN
		INSERT INTO tGuildAcademyGraduate (nNo, nCharNo, sID, nClass, nJoinLevel, dJoinDate, nGraduateLevel)
		VALUES (@nNo, @nCharNo, @sID, @nClass, @nJoinLevel, @dJoinDate, @nGraduateLevel)
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -1592
			RETURN
		END
	END

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildAcademy_setMaster]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildAcademy_setMaster]
GO

/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_GuildAcademy_setMaster
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.6.5
' Description :
'   ±æµå¾ÆÄ«µ¥¹Ì °¡ÀÔ
' Parameter :
'	input Parameter
'		@nNo 	 : ±æµå¹øÈ£
'		@nCharNo : Ä³¸¯ÅÍ¹øÈ£
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1511 : invalid nNo or invalid nCharNo
'				-1593 : db error(update)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildAcademy_setMaster]
	@nNo       int
,	@nCharNo   int
,	@nRet      int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0
	
	IF EXISTS(SELECT nNo FROM tGuildMember WHERE nNo = @nNo AND nCharNo = @nCharNo) BEGIN
		UPDATE tGuildAcademy SET nMasterCharNo = @nCharNo
		 WHERE nNo = @nNo
		IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
			SET @nRet = -1593
			RETURN
		END
	END 
	ELSE BEGIN
		SET @nRet = -1511
		RETURN
	END

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildAcademy_setMember]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildAcademy_setMember]
GO

/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_GuildAcademy_setMember
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.4.28
' Description :
'   ±æµå¾ÆÄ«µ¥¹Ì °¡ÀÔ
' Parameter :
'	input Parameter
'		@nNo 	 : ±æµå¹øÈ£
'		@nCharNo : Ä³¸¯ÅÍ¹øÈ£
'		@nGrade	 : µî±Þ
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1511 : invalid nNo
'				-1512 : invalid nCharNo
'				-1522 : ±æµå¿¡ ¼Ò¼ÓµÈ Ä³¸¯ÅÍ
'				-1523 : Ä³¸¯ÅÍ ·¹º§ ¿À·ù
'				-1524 : Ä³¸¯ÅÍ°¡ Á¸ÀçÇÏÁö ¾Ê°Å³ª »èÁ¦µÈ Ä³¸¯ÅÍ
'				-1591 : db error(insert)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildAcademy_setMember]
	@nNo       int
,	@nCharNo   int
,	@dJoinDate datetime
,	@nGrade    tinyint = 0
,	@nRet      int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	DECLARE @nLevel AS int

	IF @nNo <= 0 BEGIN
		SET @nRet = -1511
		RETURN
	END

	IF @nCharNo <= 0 BEGIN
		SET @nRet = -1512
		RETURN
	END

	IF EXISTS(SELECT nNo FROM tGuildMember WHERE nNo = @nNo AND nCharNo = @nCharNo) BEGIN
		SET @nRet = -1522
		RETURN
	END

	IF EXISTS(SELECT nCharNo FROM tCharacter WHERE nCharNo = @nCharNo AND bDeleted = 0) BEGIN
		SELECT @nLevel = nLevel FROM tCharacter WHERE nCharNo = @nCharNo
		IF @nLevel <= 0 BEGIN
			SET @nRet = -1523
			RETURN
		END
	END
	ELSE BEGIN
		SET @nRet = -1524
		RETURN
	END
	
	INSERT tGuildAcademyMember (nNo, nCharNo, nJoinLevel, dJoinDate, nGrade)
	VALUES ( @nNo, @nCharNo, @nLevel, @dJoinDate, @nGrade )
	IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
		SET @nRet = -1591
	END

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildAcademy_setMemberLevelup]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildAcademy_setMemberLevelup]
GO

/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_GuildAcademy_setMemberLevelup
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.5.27
' Description :
'   ÀÔ·Â¹ÞÀº charNo°¡ ¼Ò¼ÓµÈ ±æµå¹øÈ£
' Parameter :
'	input Parameter
'		@nNo       : ¾ÆÄ«µ¥¹Ì¹øÈ£
'		@nPoint    : Áõ°¡µÉ Æ÷ÀÎÆ®
'		@nBuffTime : Áõ°¡µÉ ¹öÇÁ½Ã°£(ºÐ´ÜÀ§)
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1521 : not found nNo
'				-1593 : db_error (update)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildAcademy_setMemberLevelup]
	@nNo       int
,	@nPoint    int
,	@nBuffTime int
,	@nRet      int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	DECLARE @BUFF_END_TIME AS DATETIME

	IF EXISTS(SELECT nNo FROM tGuildAcademy WHERE nNo = @nNo) BEGIN
		BEGIN TRAN

		SELECT @BUFF_END_TIME = ISNULL(dBuffEndTime, GETDATE()) FROM tGuildAcademy WHERE nNo = @nNo
		IF @BUFF_END_TIME > GETDATE() BEGIN
			SET @BUFF_END_TIME = DATEADD ( minute, @nBuffTime, @BUFF_END_TIME ) 
		END
		ELSE BEGIN
			SET @BUFF_END_TIME = DATEADD ( minute, @nBuffTime, GETDATE() ) 
		END

		UPDATE tGuildAcademy SET nPoint = nPoint + @nPoint, dBuffEndTime = @BUFF_END_TIME
		 WHERE nNo = @nNo
		IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
			SET @nRet = -1593
			ROLLBACK TRAN
			RETURN
		END
		ELSE BEGIN			
			COMMIT TRAN
		END
	END
	ELSE BEGIN
		SET @nRet = -1521
	END	

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildAcademy_setNotify]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildAcademy_setNotify]
GO

/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_GuildAcademy_setNotify
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.4.28
' Description :
'   ±æµå¾ÆÄ«µ¥¹Ì °øÁö»çÇ× ÀÛ¼º
' Parameter :
'	input Parameter
'		@nNo 	 : ±æµå¹øÈ£
'		@sNotify : °øÁö»çÇ×
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1511 : invalid nNo
'				-1593 : db error(update)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildAcademy_setNotify]
	@nNo     int
,	@sNotify nvarchar(1024)
,	@nRet    int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	IF @nNo <= 0 BEGIN
		SET @nRet = -1511
		RETURN
	END

	UPDATE tGuildAcademy 
	   SET dNotifyDate = getdate(), sNotify = @sNotify 
	 WHERE nNo = @nNo
	IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
		SET @nRet = -1593
	END
	ELSE BEGIN
		SET @nRet = 0
	END

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildAcademy_setRanking]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildAcademy_setRanking]
GO

-- 2008.5.26 ÀÛ¾÷
/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_GuildAcademy_setRanking
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.5.26.
' Description :
'   ±æµå¾ÆÄ«µ¥¹Ì ·©Å·À» »êÁ¤ÇÏ´Â ÀúÀåÇÁ·Î½ÃÀú
'	¼­¹ö(World_ManagerÀÇ È£Ãâ¿¡ ÀÇÇØ µ¿ÀÛÇÑ´Ù.)
' Parameter :
'	input Parameter
'		@nDays   : »êÁ¤±âÁØÀÏ
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1511 : invaild nNo
'				-1591 : db error(select)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildAcademy_setRanking]
	@nRet  int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	DECLARE @MAX_COUNT AS INT

	BEGIN TRAN

	SELECT @MAX_COUNT = ISNULL(MAX(nCount), 0) + 1
	  FROM tGuildAcademyRanking

	INSERT INTO tGuildAcademyRanking (dDate, nRanking, nGuildNo, sGuildName, nMasterNo, sMasterID, nPoint, nCount)
		SELECT GETDATE() AS dDate, R.nRanking, R.nNo, G.sName, GA.nMasterCharNo, C.sID, R.nPoint, @MAX_COUNT
		  FROM tGuild AS G, tGuildAcademy AS GA, tCharacter AS C, (
				SELECT COUNT(T2.nPoint) + 1 AS nRanking, T1.nNo, T1.nPoint
				  FROM tGuildAcademy T1 LEFT OUTER JOIN tGuildAcademy T2 ON T1.nPoint < T2.nPoint
				 GROUP BY T1.nNo, T1.nPoint) AS R
		 WHERE G.nNo = R.nNo AND C.nCharNo = GA.nMasterCharNo AND GA.nNo = R.nNo
	IF @@ERROR <> 0 BEGIN
		SET @nRet = -1592
		ROLLBACK TRAN
		RETURN
	END

	UPDATE tGuildAcademy SET nPoint = 0
	IF @@ERROR <> 0 OR @@ROWCOUNT = 0 BEGIN
		SET @nRet = -1593
		ROLLBACK TRAN
		RETURN
	END
	ELSE BEGIN
		SET @nRet = 0
		COMMIT TRAN
	END

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildAcademy_setReward]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildAcademy_setReward]
GO

/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_GuildAcademy_setReward
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.5.8.
' Description :
'   ±æµå¾ÆÄ«µ¥¹Ì º¸»ó ¼³Á¤
' Parameter :
'	input Parameter
'		@nNo 	 : ±æµå¹øÈ£
'		@nLevel  : ·¹º§
'		@nTypeID : º¸»óÅ¸ÀÔ
'		@nValue  : º¸»ó°ª
'		@nItemID : ¾ÆÀÌÅÛ
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1513 : invaild nLevel
'				-1595 : db error(select)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildAcademy_setReward]
	@nNo     int
,	@nLevel  smallint
,	@nTypeID tinyint
,	@nValue  bigint
,	@nItemID int = NULL
,	@nRet    int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	IF @nLevel <= 0 BEGIN
		SET @nRet = -1513
		RETURN
	END

	INSERT INTO tGuildAcademyReward (nNo, nLevel, nTypeID, nValue, nItemID)
	VALUES (@nNo, @nLevel, @nTypeID, @nValue, @nItemID)
	IF @@ERROR <> 0 BEGIN
		SET @nRet = -1595
		RETURN
	END

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildAcademy_withdrawMoney]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildAcademy_withdrawMoney]
GO

/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_GuildAcademy_withdrawMoney
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.5.14.
' Description :
'   ±æµå¾ÆÄ«µ¥¹Ì¿¡ ÀÔ±ÝÇÏ±â
' Parameter :
'	input Parameter
'		@nNo 	 : ±æµå¹øÈ£
'		@nCharNo : Ä³¸¯ÅÍ¹øÈ£
'		@nMoney  : ±Ý¾×
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1511 : invaild nNo
'				-1512 : invaild nCharNo
'				-1514 : invaild nMoney
'				-1524 : not enough money
'				-1525 : invaild nNo
'				-1526 : invaild nCharNo
'				-1593 : db error
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildAcademy_withdrawMoney]
	@nNo     int
,	@nCharNo int
,	@nMoney  bigint
,	@nRet    int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	DECLARE @money AS bigint
	SET @nRet = 0
	SET @money = 0

	IF @nNo <= 0 BEGIN
		SET @nRet = -1511
		RETURN
	END

	IF @nCharNo <= 0 BEGIN
		SET @nRet = -1512
		RETURN
	END

	IF @nMoney <= 0 BEGIN
		SET @nRet = -1514
		RETURN
	END

	BEGIN TRAN
	
	IF NOT EXISTS(SELECT nCharNo FROM tCharacter WHERE nCharNo = @nCharNo AND bDeleted = 0) BEGIN
		SET @nRet = -1524
		ROLLBACK TRAN
		RETURN
	END

	IF NOT EXISTS(SELECT nNo FROM tGuildAcademy WHERE nNo = @nNo) BEGIN
		SET @nRet = -1525
		ROLLBACK TRAN
		RETURN
	END

	SELECT @money = nMoney FROM tGuildAcademy WHERE nNo = @nNo
	IF @money < @nMoney BEGIN		
		SET @nRet = -1527
		ROLLBACK TRAN
		RETURN
	END
	ELSE BEGIN
		UPDATE tGuildAcademy SET nMoney = nMoney - @nMoney WHERE nNo = @nNo
		IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
			SET @nRet = -1593
			ROLLBACK TRAN
			RETURN
		END

		UPDATE tCharacter SET nMoney = nMoney + @nMoney WHERE nCharNo = @nCharNo
		IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
			SET @nRet = -1593
			ROLLBACK TRAN
			RETURN
		END
		ELSE BEGIN
			SET @nRet = 0
			COMMIT TRAN
		END
	END
			
	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildTournament_getChoiceList]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildTournament_getChoiceList]
GO


/*--------------------------------------------------------------------------------------
' 이  름 : usp_GuildTournament_getChoiceList
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2009.4.6
' Description :
'   길드토너먼트에 선정된 길드리스트
' Parameter :
'	input Parameter
'		@nGTNo : 길드토너먼트번호
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1411 : invaild nGTNo
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildTournament_getChoiceList]
	@nGTNo int
,	@nRet  int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0
	IF ISNULL(@nGTNo, 0) <= 0 BEGIN
		SET @nRet = -1411
		RETURN
	END

	SELECT nNo FROM tGuildTournamentRegist WITH(NOLOCK) WHERE nGTNo = @nGTNo AND bChoice = 1

	SET NOCOUNT OFF
END


GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildTournament_getMoney]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildTournament_getMoney]
GO


/*--------------------------------------------------------------------------------------
' 이  름 : usp_GuildTournament_getMoney
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2009.4.7
' Description :
'   길드토너먼트를 신청비용 총합계
' Parameter :
'	input Parameter
'		@nGTNo : 길드토너먼트번호
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1411 : invaild nGTNo
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildTournament_getMoney]
	@nGTNo int
,	@nRet  int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0
	IF ISNULL(@nGTNo, 0) <= 0 BEGIN
		SET @nRet = -1411
		RETURN
	END

	SELECT ISNULL(SUM(nMoney), 0) AS nTotalMoney 
	  FROM tGuildTournamentRegist WITH(NOLOCK) 
	 WHERE nGTNo = @nGTNo

	SET NOCOUNT OFF
END


GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildTournament_getRegistList]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildTournament_getRegistList]
GO


/*--------------------------------------------------------------------------------------
' 이  름 : usp_GuildTournament_getRegistList
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2009.4.6
' Description :
'   길드토너먼트를 신청한 길드리스트
' Parameter :
'	input Parameter
'		@nGTNo : 길드토너먼트번호
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1411 : invaild nGTNo
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildTournament_getRegistList]
	@nGTNo int
,	@nRet  int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0
	IF ISNULL(@nGTNo, 0) <= 0 BEGIN
		SET @nRet = -1411
		RETURN
	END

	SELECT nNo FROM tGuildTournamentRegist WITH(NOLOCK) WHERE nGTNo = @nGTNo

	SET NOCOUNT OFF
END


GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildTournament_setChoice]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildTournament_setChoice]
GO


/*--------------------------------------------------------------------------------------
' 이  름 : usp_GuildTournament_setChoice
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2009.4.7
' Description :
'   길드토너먼트를 신청리스트중 조건에 맞는 길드를 선정하는 작업을 함.
' Parameter :
'	input Parameter
'		@nGTNo        : 길드토너먼트번호
'		@nLimitLevel  : 제한 레벨
'		@nLimitMember : 제한 인원
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1411 : invaild nGTNo
'				-1493 : db error(update)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildTournament_setChoice]
	@nGTNo        int
,	@nLimitLevel  int = 1
,	@nLimitMember int = 1
,	@nRet         int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0
	IF ISNULL(@nGTNo, 0) <= 0 BEGIN
		SET @nRet = -1411
		RETURN
	END

	BEGIN TRAN

	UPDATE tGuildTournamentRegist
	   SET bChoice = 1
	 WHERE nGTNo = @nGTNo AND nNo IN (
			SELECT TOP 16 T4.nNo
			  FROM tGuildTournamentRegist AS T4 INNER JOIN (
					SELECT T1.nNo, ISNULL(COUNT(T2.nCharNo), 0) AS nMember
					  FROM tGuildMember AS T1, tCharacter AS T2 
					 WHERE T1.nCharNo = T2.nCharNo
					   AND T2.nLevel >= @nLimitLevel
					 GROUP BY T1.nNo
					HAVING COUNT(T2.nCharNo) >= @nLimitMember) AS T3 ON T4.nNo = T3.nNo
			 WHERE nGTNo = @nGTNo
			 ORDER BY nSeed DESC)
	IF @@ERROR <> 0 BEGIN
		SET @nRet = -1493
		ROLLBACK TRAN
	END
	ELSE BEGIN
		SET @nRet = 0
		COMMIT TRAN
	END

	SET NOCOUNT OFF
END


GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_GuildTournament_setRegist]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_GuildTournament_setRegist]
GO

/*-------------------------------------------------------------------------------------
' 파일명 : KR_procedureGuildTournament.sql
' 내  용 : 길드토너먼트 관련 저장프로시저
' 작성자 : 고동균(kodong@gmail.com)
' 작성일 : 2009.4.6
' Description :
'	길드토너먼트 신청과 관련하여 추가 개발에 대한 프로시저임.
'	원래의 프로시저는 별도로 요청하여야 함.
'------------------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------------------
' 이  름 : usp_GuildTournament_setRegist
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2009.4.6
' Description :
'   길드토너먼트를 신청하는 저장프로시저
'	각종 제한사항이 체크되어야 함.
' Parameter :
'	input Parameter
'		@nGTNo        : 길드토너먼트번호
'		@nNo          : 길드번호
'		@nCharNo      : 캐릭터번호
'		@nMoney       : 신청비
'		@nLimitLevel  : 제한 레벨
'		@nLimitMember : 제한 인원
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1411 : invaild nGTNo
'				-1412 : invaild nNo
'				-1413 : invaild nCharNo
'				-1421 : already regist nNo
'				-1422 : check level, member
'				-1423 : not enough money
'				-1492 : db error(insert)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_GuildTournament_setRegist]
	@nGTNo        int
,	@nNo          int
,	@nCharNo      int
,	@nMoney       bigint = 0
,	@nLimitLevel  int = 1
,	@nLimitMember int = 1
,	@nRet         int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	DECLARE @cnt AS int

	SET @nRet = 0
	SET @cnt  = 0

	IF ISNULL(@nGTNo, 0) <= 0 BEGIN
		SET @nRet = -1411
		RETURN
	END

	IF ISNULL(@nNo, 0) <= 0 BEGIN
		SET @nRet = -1412
		RETURN
	END

	IF ISNULL(@nCharNo, 0) <= 0 BEGIN
		SET @nRet = -1413
		RETURN
	END

	IF EXISTS(SELECT nGTNo FROM tGuildTournamentRegist WHERE nGTNo = @nGTNo AND nNo = @nNo) BEGIN
		SET @nRet = -1421
		RETURN
	END

	-- 길드토너먼트 신청제한 체크(레벨, 인원)
	SELECT @cnt = ISNULL(COUNT(T1.nCharNo), 0)
	  FROM tGuildMember AS T1, tCharacter AS T2 
	 WHERE T1.nCharNo = T2.nCharNo
	   AND T1.nNo = @nNo
	   AND T2.nLevel >= @nLimitLevel
	IF @cnt < @nLimitMember BEGIN
		SET @nRet = -1422
		RETURN
	END

	BEGIN TRAN

	-- 길드토너먼트 신청비 차감
	EXEC p_Char_MoneySub @nCharNo, @nMoney, @nRet OUTPUT
	IF @nRet <> 1 BEGIN
		SET @nRet = -1423
		ROLLBACK TRAN
		RETURN
	END

	INSERT INTO tGuildTournamentRegist (nGTNo, nNo, nMoney, nSeed)
	VALUES (@nGTNo, @nNo, @nMoney, CAST(RAND() * 100000 AS INT))
	IF @@ERROR <> 0 BEGIN
		SET @nRet = -1492
		ROLLBACK TRAN
	END
	ELSE BEGIN
		SET @nRet = 0
		COMMIT TRAN
	END

	SET NOCOUNT OFF
END


GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_HolyPromise_getRemainMoney]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_HolyPromise_getRemainMoney]
GO




CREATE  PROCEDURE [dbo].[usp_HolyPromise_getRemainMoney]
/*
get cen reward
2009.4 By Luunar
 input:
	see SQL
 output:
	= 0 No Error
	< 0 Error
*/

@nCharNo		int,
@nRet			int OUTPUT

AS
BEGIN

	SET NOCOUNT ON

	DECLARE @nRemainMoney bigint
	SET @nRemainMoney = 0

	IF ISNULL(@nCharNo, 0) <= 0 BEGIN
		SET @nRet = -2211
		RETURN
	END

	-- ÀÜ¾×ÀÌ ¾ó¸¶³ª ÀÖ´ÂÁö °¡Á®¿Â´Ù.
	SELECT TOP 1 @nRemainMoney = nRemainMoney 
	  FROM tHolyPromiseReward 
	 WHERE nCharNo = @nCharNo 
	 ORDER BY nSeqNo DESC

	-- ¸¸¾à ÀÜ¾×ÀÌ 0¿ø º¸´Ù ¸¹´Ù¸é
	IF @nRemainMoney > 0
	BEGIN
		-- ÀÜ¾×À» ¹Ù·Î Ãâ·ÂÇØÁÖ°í ³¡
		SELECT @nRemainMoney
		SET @nRet = 0
		RETURN
	END
	ELSE
	-- ÀÜ¾×ÀÌ 0¿øÀÏ °æ¿ì¿£ »óÀ§·Î½á µî·ÏµÇ¾î ÀÖ´ÂÁö ¿©ºÎ¸¦ Ã¼Å©ÇØ¾ß ÇÔ
	BEGIN
		-- ÇöÀç »óÀ§·Î½á µî·ÏµÇ¾î ÀÖ´Ù¸é
		IF EXISTS(SELECT TOP 1 nUpCharNo FROM tHolyPromise WHERE nUpCharNo = @nCharNo)
		BEGIN
			-- ÀÜ¾×À» Ãâ·ÂÇØÁÖ°í ³¡(´Ù¸¸ ÀÜ¾×Àº ¾ðÁ¦³ª 0¿øÀÏ °ÍÀÌ´Ù.)
			SELECT 0
			SET @nRet = 0
			RETURN
		END
		ELSE
		-- »óÀ§·Î½á µî·ÏµÇ¾î ÀÖÁö ¾Ê´Â °æ¿ì
		BEGIN
			-- È¦¸® ÇÁ¶ó¹Ì½º ¼³¸íÃ¢ ¶ç¿ì¶ó°í ¸í·É
			SET @nRet = -2224
			RETURN
		END	
	END
END





GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_HolyPromise_setMoney]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_HolyPromise_setMoney]
GO





CREATE   PROCEDURE [dbo].[usp_HolyPromise_setMoney]
/*
cen use reward
2009.4 By Luunar
 input:
	see SQL
 output:
	= 0 No Error
	< 0 Error
ÇÏÀ§¸â¹ö°¡ µ·À» »ç¿ëÇÏ¸é »óÀ§¸â¹ö¿¡°Ô µ·À» Áö±Þ
*/

@nCharNo		int,
@nRewardMoney	bigint,
@nLevelGap		int,
@nRet			int OUTPUT

AS
BEGIN
	SET NOCOUNT ON

	DECLARE @nUpMemberCharNo	int
	DECLARE @nUpMemberLevel	int
	DECLARE @nMyLevel		int
	DECLARE @nType          tinyint

	SET @nUpMemberCharNo	= 0
	SET @nUpMemberLevel		= 0
	SET @nMyLevel		= 0
	SET @nType = 1 -- (1:ÀÔ±Ý/2:Ãâ±Ý)

	IF ISNULL(@nCharNo, 0) <= 0 BEGIN
		SET @nRet = -2211
		RETURN
	END

	IF ISNULL(@nRewardMoney, 0) <= 0 BEGIN
		SET @nRet = -2212
		RETURN
	END


	IF EXISTS(SELECT nUpCharNo FROM tHolyPromise WHERE nCharNo = @nCharNo)
	BEGIN
		-- »óÀ§ ÄÉ¸¯ÅÍ ¹øÈ£ ¹× ·¹º§À» °¡Á®¿Í º»´Ù.
		SELECT @nUpMemberCharNo = P.nUpCharNo, @nUpMemberLevel = C.nLevel FROM
			tHolyPromise AS P INNER JOIN tCharacter AS C
			ON C.nCharNo =  P.nUpCharNo
		WHERE P.nCharNo = @nCharNo AND C.bDeleted = 0

		-- »óÀ§°¡ ½ÇÁ¸ÇÏ¸é
		IF @nUpMemberCharNo > 0 and @nUpMemberLevel > 0
		BEGIN
			-- ³ªÀÇ ÇÏÀ§ ¸É¹ö(³ª)ÀÇ Level À» °¡Á®¿Â´Ù.
			SELECT @nMyLevel = nLevel FROM tCharacter WHERE nCharNo = @nCharNo
			-- ÇÏÀ§¿Í »óÀ§ ¸É¹ö°£ Level Â÷ÀÌ°¡ ÀÏÁ¤·® ÀÌ»óÀ» ¹þ¾î³ª¸é º¸»óÇØ ÁÖÁö ¾Ê´Â´Ù.
			IF @nUpMemberLevel - @nMyLevel < @nLevelGap
			BEGIN
				SET @nRet = -2223
				RETURN
			END

			-- »óÀ§ ¸É¹ö¿¡°Ô µ· º¸»ó Áö±Þ
			DECLARE @nSeqNo		int
			DECLARE @nRemainMoney	bigint

			SET @nSeqNo       = 0
			SET @nRemainMoney = 0

			BEGIN TRAN

			SELECT TOP 1 @nSeqNo = nSeqNo, @nRemainMoney = nRemainMoney 
			  FROM tHolyPromiseReward 
			 WHERE nCharNo = @nUpMemberCharNo 
			 ORDER BY nSeqNo DESC

			SET @nSeqNo       = @nSeqNo + 1
			SET @nRemainMoney = @nRemainMoney + @nRewardMoney

			INSERT INTO tHolyPromiseReward( nCharNo, nSeqNo, nType, nMoney, nRemainMoney, nReceiptCharNo )
			VALUES (@nUpMemberCharNo, @nSeqNo, @nType, @nRewardMoney, @nRemainMoney, @nCharNo)
			IF @@ERROR <> 0 BEGIN
				-- ÆÄÀÏ ¿¡·¯Ã³¸®
				SET @nRet = -2292
				ROLLBACK TRAN
				RETURN
			END
			ELSE BEGIN
				SET @nRet = 0
				COMMIT TRAN
				RETURN			
			END
		END
		ELSE
		BEGIN
			-- »óÀ§ ¸É¹ö°¡ Á¸ÀçÇÏÁö ¾Ê´Â´Ù.
			SET @nRet = -2222
			RETURN
		END
	END
	ELSE
	BEGIN
		-- È¦¸®ÇÁ¶ó¹Ì½º¿¡ °¡ÀÔÇÑ ÀûÀÌ ¾ø´Ù. (Å« ÀÇ¹Ì´Â ¾øÀ½. ¾îÂ÷ÇÇ ´ÙÀ½ ´Ü°è¿¡¼­ °É·¯Áü)
		SET @nRet = -2221
		RETURN
	END
END




GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_HolyPromise_withDrawRemainMoney]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_HolyPromise_withDrawRemainMoney]
GO




CREATE   PROCEDURE [dbo].[usp_HolyPromise_withDrawRemainMoney]
/*
withdraw cen reward
2009.4 By Luunar
 input:
	see SQL
 output:
	= 0 No Error
	< 0 Error
*/

@nCharNo		int,
@nRet			int OUTPUT

AS
BEGIN
	SET NOCOUNT ON

	DECLARE @nType tinyint
	SET @nType = 2 -- (1:ÀÔ±Ý/2:Ãâ±Ý)

	IF ISNULL(@nCharNo, 0) <= 0 BEGIN
		SET @nRet = -2211
		RETURN
	END

	IF EXISTS(SELECT nMoney FROM tHolyPromiseReward WHERE nCharNo = @nCharNo)
	BEGIN
		-- Æ®·£Àè¼Ç ½ÃÀÛ
		BEGIN TRAN
			DECLARE @nRewardMoney	bigint
			DECLARE @nSeqNo		int

			-- º¸»ó ±Ý¾× °¡Á®¿À±â
			SELECT TOP 1 @nSeqNo = nSeqNo, @nRewardMoney = nRemainMoney FROM tHolyPromiseReward WHERE nCharNo = @nCharNo ORDER BY nSeqNo DESC

			-- Áö±Þ ±Ý¾×ÀÌ 0¿øº¸´Ù ÀÛ°Å³ª °°Àº °æ¿ì¿£ Áö±ÞÇØ ÁÖÁö ¾Ê´Â´Ù.
			IF @nRewardMoney <= 0
			BEGIN
				SET @nRet = -2226
				ROLLBACK TRAN
				RETURN
			END

			-- º¸»ó ±Ý¾× Áö±Þ
			EXEC p_Char_MoneyAdd @nCharNo, @nRewardMoney, @nRet OUTPUT
			IF @nRet <> 1
			BEGIN
				SET @nRet = -2227
				ROLLBACK TRAN
				RETURN
			END

			-- º¸»ó ±â·Ï ±âÀç
			SET @nSeqNo = @nSeqNo + 1

			INSERT INTO tHolyPromiseReward( nCharNo, nSeqNo, nType, nMoney, nRemainMoney, nReceiptCharNo )
			VALUES (@nCharNo, @nSeqNo, @nType, @nRewardMoney, 0, 0)
			IF @@ERROR <> 0
			BEGIN
				SET @nRet = -2292
				ROLLBACK TRAN
				RETURN
			END

			-- °á°ú
			SET @nRet = 0
			SELECT @nRewardMoney
		COMMIT TRAN
	END
	ELSE
	BEGIN
		-- ÅëÀåÀÌ °³¼³µÈ ÀûÀÌ ¾ø´Ù.
		SET @nRet = -2225
		RETURN
	END
END




GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Item_GuildToken_BuyAll]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Item_GuildToken_BuyAll]
GO




CREATE PROCEDURE [dbo].[usp_Item_GuildToken_BuyAll]
/*
Item buy all
2004.8 By CJC
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Not found item owner or Need more owner's money/fame
	        ? = Error code
	        
 operation:
	1. money/fame check and sub
	2. make buy item
	
*/
@nItemKey bigint,
@nOwner int,
@nStorageType tinyint,
@nStorage smallint,
@nItemID int,
@nFlags int,
@nPriceGuildToken bigint,
@nRet int OUTPUT
AS
SET NOCOUNT ON
DECLARE @CreateItemRet int
BEGIN TRAN

-- 아이템 소유자가 충분한 돈을 가지고 있는지 확인 후 돈 감소

EXEC usp_Guild_TokenSub @nOwner, @nPriceGuildToken, @nRet OUTPUT
IF @nRet <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = 1
	RETURN
END


-- 아이템 생성 저장프로시져 호출
EXEC p_Item_Create @nItemKey, @nOwner, @nStorageType, @nStorage, @nItemID, @nFlags, @CreateItemRet OUTPUT
IF @CreateItemRet <> 0 OR @@ERROR <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = @CreateItemRet
	RETURN
END
-- 완료
COMMIT TRAN
SET @nRet = 0
-- end




GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Item_GuildToken_BuyLot]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Item_GuildToken_BuyLot]
GO




CREATE PROCEDURE [dbo].[usp_Item_GuildToken_BuyLot]
/*
Item buy - change lot and money/fame
2008.12 By Lunar
 input:
	see SQL
 output:
	@nRet	0 = OK
	        1 = Not found item owner or Need more owner's money
	        ? = Error code
	        
 operation:
	1. money/fame check and sub
	2. make buy item
	
*/
@nItemKey bigint,
@nOwner int,
@nOptionType smallint,
@nOptionData bigint,
@nPriceGuildToken bigint,
@nRet int OUTPUT
AS
SET NOCOUNT ON
BEGIN TRAN


EXEC usp_Guild_TokenSub @nOwner, @nPriceGuildToken, @nRet OUTPUT
IF @nRet <> 0
BEGIN
	ROLLBACK TRAN
	SET @nRet = 1
	RETURN
END

-- 아이템 옵션 저장프로시져 호출(랏 수정)
EXEC p_Item_SetOption @nItemKey, @nOptionType, @nOptionData, @nRet OUTPUT
IF @nRet <> 0
BEGIN
	ROLLBACK TRAN
	RETURN
END
-- 완료
COMMIT TRAN
-- end




GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Minihouse_delGate]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Minihouse_delGate]
GO

/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_Minihouse_delGate
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.6.17
' Description :
'   ¹Ì´ÏÇÏ¿ì½ºÀÇ °ÔÀÌÆ®¸¦ »èÁ¦ÇÔ.
' Parameter :
'	input Parameter
'		@nCharNo  : Ä³¸¯ÅÍ¹øÈ£
'		@nItemID  : ¾ÆÀÌÅÛ¾ÆÀÌµð(°ÔÀÌÆ® °ü·Ã ½ºÅ©·Ñ ¾ÆÀÌÅÛ ¾ÆÀÌµð)
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1622 : not found Gate
'				-1694 : db error(delete)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Minihouse_delGate]
	@nCharNo  int
,	@nItemID  int
,	@nRet     int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	IF EXISTS(SELECT nCharNo FROM tMinihouseGate WHERE nCharNo = @nCharNo AND nItemID = @nItemID) BEGIN
		DELETE FROM tMinihouseGate WHERE nCharNo = @nCharNo AND nItemID = @nItemID
		IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
			SET @nRet = -1694
		END
	END
	ELSE BEGIN
		SET @nRet = -1622
	END

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Minihouse_getGateList]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Minihouse_getGateList]
GO

/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_Minihouse_getGateList
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.6.17
' Description :
'   ¹Ì´ÏÇÏ¿ì½ºÀÇ °ÔÀÌÆ® ¸®½ºÆ®¸¦ °¡Á®¿È.
' Parameter :
'	input Parameter
'		@nCharNo  : Ä³¸¯ÅÍ¹øÈ£
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1611 : invaild nCharNo
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Minihouse_getGateList]
	@nCharNo  int
,	@nRet     int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	IF @nCharNo <= 0 BEGIN
		SET @nRet = -1611
		RETURN
	END

	IF NOT EXISTS(SELECT nCharNo FROM tMinihouse WHERE nCharNo = @nCharNo) BEGIN
		INSERT INTO tMinihouse (nCharNo) VALUES (@nCharNo)
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -1692
			RETURN
		END
	END

	SELECT nCharNo, nItemID, bType, ISNULL(dEndDate, 0) AS dEndDate
	  FROM tMinihouseGate
	 WHERE nCharNo = @nCharNo AND (dEndDate > GETDATE() OR dEndDate IS NULL)

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Minihouse_getVisitorCount]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Minihouse_getVisitorCount]
GO

/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_Minihouse_getVisitorCount
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.6.17
' Description :
'   ¹Ì´ÏÇÏ¿ì½ºÀÇ ¹æ¹®ÀÚ¼ö¸¦ °¡Á®¿È
'	¸¸¾à, ´ë»óÀÚ(nCharNo)ÀÇ ¹Ì´ÏÇÏ¿ì½º°¡ ¾øÀ» °æ¿ì ¹Ì´ÏÇÏ¿ì½º¸¦ »ý¼º½ÃÅ°°í ±âº»°ªÀ»
'	°¡Á®¿È.
' Parameter :
'	input Parameter
'		@nCharNo : Ä³¸¯ÅÍ¹øÈ£
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1692 : db error(insert)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Minihouse_getVisitorCount]
	@nCharNo int
,	@nRet    int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	IF EXISTS(SELECT nCharNo FROM tMinihouse WHERE nCharNo = @nCharNo) BEGIN
		SELECT nVisitor FROM tMinihouse WHERE nCharNo = @nCharNo
	END
	ELSE BEGIN
		INSERT INTO tMinihouse (nCharNo) VALUES (@nCharNo)
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -1692
			RETURN
		END

		SELECT nVisitor FROM tMinihouse WHERE nCharNo = @nCharNo
	END

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Minihouse_setGate]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Minihouse_setGate]
GO

/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_Minihouse_setGate
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.6.17
' Description :
'   ¹Ì´ÏÇÏ¿ì½ºÀÇ °ÔÀÌÆ®¸¦ µî·ÏÇÔ.
'	Áßº¹µÇ´Â °ÔÀÌÆ®´Â °¡Áú ¼ö ¾øÀ¸¹Ç·Î ¿À·ù·Î Ã³¸®ÇÔ.
'	2008.6.18 Ãß°¡ - °íµ¿±Õ
'	°ÔÀÌÆ®¸¦ ¹è¿ì¸é ÇØ´ç ½ºÅ©·Ñ ¾ÆÀÌÅÛÀ» »èÁ¦Ã³¸® ÇØ¾ßÇØ¼­ °ÔÀÌÆ® Ãß°¡Àü¿¡
'	ÇØ´ç¾ÆÀÌÅÛÀ» Á¤»óÀûÀ¸·Î »èÁ¦ÇßÀ»¶§¸¸ °ÔÀÌÆ® Ãß°¡Ã³¸®¸¦ ¿Ï·áÇÔ.
' Parameter :
'	input Parameter
'		@nCharNo  : Ä³¸¯ÅÍ¹øÈ£
'		@nItemID  : ¾ÆÀÌÅÛ¾ÆÀÌµð(°ÔÀÌÆ® °ü·Ã ½ºÅ©·Ñ ¾ÆÀÌÅÛ ¾ÆÀÌµð)
'		@bType    : ±â°£Á¦ ¿©ºÎ(0:¿µ±¸/1:±â°£Á¦)
'		@dEndDate : Á¾·áÀÏ
'		@nItemKey : »èÁ¦ÇÏ·Á´Â ¾ÆÀÌÅÛÅ°
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1621 : already register Gate
'				-1692 : db error(insert)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Minihouse_setGate]
	@nCharNo  int
,	@nItemID  int
,	@bType    tinyint
,	@dEndDate datetime = NULL
,	@nItemKey bigint
,	@nRet     int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0
	
	IF EXISTS(SELECT nCharNo FROM tMinihouseGate WHERE nCharNo = @nCharNo AND nItemID = @nItemID) BEGIN
		-- ±âÁ¸¿¡ µî·ÏµÈ °ÔÀÌÆ®°¡ ÀÖÀ» °æ¿ì »ç¿ë±â°£ÀÌ ÀÌ¹Ì Áö³µÀ¸¸é »èÁ¦Ã³¸®¸¦ ¸ÕÀúÇÑ´Ù.
		DELETE FROM tMinihouseGate 
		 WHERE nCharNo = @nCharNo 
		   AND nItemID = @nItemID 
		   AND dEndDate < GETDATE()
		   AND dEndDate IS NOT NULL
	END

	IF EXISTS(SELECT nCharNo FROM tMinihouseGate WHERE nCharNo = @nCharNo AND nItemID = @nItemID) BEGIN
		-- »óÀ§¿¡¼­ »èÁ¦Çß´Âµ¥µµ ÀÖ´Â °æ¿ì´Â ±â°£ÀÌ ³²¾Ò°Å³ª ¿µ±¸¾ÆÀÌÅÛÀÏ °æ¿ìÀÓ.
		SET @nRet = -1621
	END
	ELSE BEGIN
		IF @bType = 0 BEGIN
			SET @dEndDate = NULL
		END

		BEGIN TRAN
		-- °ÔÀÌÆ® ½ºÅ©·Ñ ¾ÆÀÌÅÛÀ» »èÁ¦ÇÔ.
		EXEC p_Item_Delete @nItemKey, @nRet output
		IF @nRet = 0 BEGIN
			INSERT INTO tMinihouseGate (nCharNo, nItemID, bType, dEndDate) 
			VALUES (@nCharNo, @nItemID, @bType, @dEndDate)
			IF @@ERROR <> 0 BEGIN
				SET @nRet = -1692
				ROLLBACK TRAN
			END
			ELSE BEGIN
				COMMIT TRAN
			END
		END
		ELSE BEGIN
			SET @nRet = -1622
			ROLLBACK TRAN
		END		
	END

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Minihouse_setVisitorCount]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Minihouse_setVisitorCount]
GO

/*-------------------------------------------------------------------------------------
' ÆÄÀÏ¸í : US_procedureMinihouse.sql
' ³»  ¿ë : Minihouse °ü·Ã ÀúÀåÇÁ·Î½ÃÀú
' ÀÛ¼ºÀÚ : °íµ¿±Õ(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.6.17
' Description :
'------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------
' ÀúÀåÇÁ·Î½ÃÀú ¸®½ºÆ®
'	1. usp_Minihouse_setVisitorCount
'	2. usp_Minihouse_getVisitorCount
'------------------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------------------
' ÀÌ  ¸§ : usp_Minihouse_setVisitorCount
' ÀÛ¼ºÀÚ : Ko Dong Gyun(kodong@gmail.com)
' ÀÛ¼ºÀÏ : 2008.6.17
' Description :
'   ¹Ì´ÏÇÏ¿ì½ºÀÇ ¹æ¹®ÀÚ¼ö¸¦ Áõ°¡½ÃÅ´
'	¸¸¾à, ´ë»óÀÚ(nCharNo)ÀÇ ¹Ì´ÏÇÏ¿ì½º°¡ ¾øÀ» °æ¿ì ¹Ì´ÏÇÏ¿ì½º¸¦ »ý¼º½ÃÅ°°í Áõ°¡½ÃÅ´
' Parameter :
'	input Parameter
'		@nCharNo : Ä³¸¯ÅÍ¹øÈ£
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-1692 : db error(insert)
'				-1693 : db error(update)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Minihouse_setVisitorCount]
	@nCharNo int
,	@nRet    int = 0 output
AS
BEGIN
	SET NOCOUNT ON

	SET @nRet = 0

	IF EXISTS(SELECT nCharNo FROM tMinihouse WHERE nCharNo = @nCharNo) BEGIN
		UPDATE tMinihouse SET nVisitor = nVisitor + 1 WHERE nCharNo = @nCharNo
		IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
			SET @nRet = -1693
		END
	END
	ELSE BEGIN
		INSERT INTO tMinihouse (nCharNo) VALUES (@nCharNo)
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -1692
			RETURN
		END

		UPDATE tMinihouse SET nVisitor = nVisitor + 1 WHERE nCharNo = @nCharNo
		IF @@ERROR <> 0 OR @@ROWCOUNT <> 1 BEGIN
			SET @nRet = -1693
		END
	END

	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_SpamBlock_getTime]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_SpamBlock_getTime]
GO

/*--------------------------------------------------------------------------------------
' 이  름 : usp_SpamBlock_getTime
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2010.7.8.
' Description :
'   캐릭터의 블럭시간과 대기시간을 가져옴
' Parameter :
'	input Parameter
'		@nCharNo : 캐릭터번호
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-2822 : not found nCharNo
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_SpamBlock_getTime]
	@nCharNo int
,	@nRet int = 0 output
AS
BEGIN
	SET NOCOUNT ON
	
	SET @nRet = 0
	
	IF EXISTS(SELECT nCharNo FROM tSpamBlockTime WHERE nCharNo = @nCharNo)
	BEGIN
		SELECT nCharNo, nBlockTime, nStandbyTime
		  FROM tSpamBlockTime
		 WHERE nCharNo = @nCharNo
	END
	ELSE BEGIN
		SET @nRet = -2822
	END

	SET NOCOUNT ON
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_SpamBlock_setTime]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_SpamBlock_setTime]
GO


/*--------------------------------------------------------------------------------------
' 이  름 : usp_SpamBlock_setTime
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2010.7.8.
' Description :
'   캐릭터의 블럭시간과 대기시간을 설정
' Parameter :
'	input Parameter
'		@nCharNo      : 캐릭터번호
'		@nBlockTime   : 블럭시간(단위:초)
'		@nStandbyTime : 대기시간(단위:초)
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-2892 : db error(update)
'				-2393 : db error(insert)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_SpamBlock_setTime]
	@nCharNo int
,	@nBlockTime int
,	@nStandbyTime int
,	@nRet int = 0 output
AS
BEGIN
	SET NOCOUNT ON
	
	SET @nRet = 0
	
	IF EXISTS(SELECT nCharNo FROM tSpamBlockTime WHERE nCharNo = @nCharNo)
	BEGIN
		UPDATE tSpamBlockTime
		   SET sys_update_date = GETDATE()
		     , nBlockTime = @nBlockTime
		     , nStandbyTime = @nStandbyTime
		 WHERE nCharNo = @nCharNo
		IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
		BEGIN
			SET @nRet = -2893
		END
	END
	ELSE BEGIN
		INSERT INTO tSpamBlockTime (nCharNo, nBlockTime, nStandbyTime)
		VALUES (@nCharNo, @nBlockTime, @nStandbyTime)
		IF @@ERROR <> 0
		BEGIN
			SET @nRet = -2892
		END
	END

	SET NOCOUNT ON
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_SpamFilter_get]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_SpamFilter_get]
GO

/*--------------------------------------------------------------------------------------
' 이  름 : usp_SpamFilter_get
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2010.6.21.
' Description :
'   유저의 스패머 필터링 값을 가져옴
' Parameter :
'	input Parameter
'		@nUserNo         : 유저번호
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-2821 : not found UserNo
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_SpamFilter_get]
	@nUserNo int
,	@nRet int = 0 output
AS
BEGIN
	SET NOCOUNT ON
	
	SET @nRet = 0
	
	IF EXISTS(SELECT nUserNo FROM tSpamFilter WHERE nUserNo = @nUserNo)
	BEGIN
		SELECT nUserNo, bIsSpamSpread, bIsSpamBlock, nSpamFilterRate
		  FROM tSpamFilter
		 WHERE nUserNo = @nUserNo
	END
	ELSE BEGIN
		SET @nRet = -2821
	END

	SET NOCOUNT ON
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_SpamFilter_set]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_SpamFilter_set]
GO

/*--------------------------------------------------------------------------------------
' 이  름 : usp_SpamFilter_set
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2010.6.21.
' Description :
'   유저의 스패머 필터링 값을 설정
' Parameter :
'	input Parameter
'		@nUserNo         : 유저번호
'		@bIsSpamSpread   : 스팸 펼치기 여부(0:No/1:Yes)
'		@bIsSpamBlock    : 스팸 차단 여부(0:No/1:Yes)
'		@nSpamFilterRate : 스팸 차단 비율(%)
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-2892 : db error(update)
'				-2393 : db error(insert)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_SpamFilter_set]
	@nUserNo int
,	@bIsSpamSpread bit
,	@bIsSpamBlock  bit
,	@nSpamFilterRate tinyint
,	@nRet int = 0 output
AS
BEGIN
	SET NOCOUNT ON
	
	SET @nRet = 0
	
	IF EXISTS(SELECT nUserNo FROM tSpamFilter WHERE nUserNo = @nUserNo)
	BEGIN
		UPDATE tSpamFilter
		   SET sys_update_date = GETDATE()
		     , bIsSpamSpread = @bIsSpamSpread
		     , bIsSpamBlock = @bIsSpamBlock
		     , nSpamFilterRate = @nSpamFilterRate
		 WHERE nUserNo = @nUserNo
		IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
		BEGIN
			SET @nRet = -2893
		END
	END
	ELSE BEGIN
		INSERT INTO tSpamFilter (nUserNo, bIsSpamSpread, bIsSpamBlock, nSpamFilterRate)
		VALUES (@nUserNo, @bIsSpamSpread, @bIsSpamBlock, @nSpamFilterRate)
		IF @@ERROR <> 0
		BEGIN
			SET @nRet = -2892
		END
	END

	SET NOCOUNT ON
END

GO

-- ----------------------------
-- Indexes structure for table tArenaChallenge
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tArenaChallenge]
-- ----------------------------
ALTER TABLE [dbo].[tArenaChallenge] ADD PRIMARY KEY ([nCharNo], [nMonsterLevel])
GO

-- ----------------------------
-- Indexes structure for table tArenaFBZ
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tArenaFBZ]
-- ----------------------------
ALTER TABLE [dbo].[tArenaFBZ] ADD PRIMARY KEY ([nCharNo])
GO

-- ----------------------------
-- Indexes structure for table tArenaGuild
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tArenaGuild]
-- ----------------------------
ALTER TABLE [dbo].[tArenaGuild] ADD PRIMARY KEY ([nGuildNo])
GO

-- ----------------------------
-- Indexes structure for table tArenaPvP
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tArenaPvP]
-- ----------------------------
ALTER TABLE [dbo].[tArenaPvP] ADD PRIMARY KEY ([nCharNo])
GO

-- ----------------------------
-- Indexes structure for table tAutoPick
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tAutoPick]
-- ----------------------------
ALTER TABLE [dbo].[tAutoPick] ADD PRIMARY KEY ([nCharNo])
GO

-- ----------------------------
-- Indexes structure for table tCharacter
-- ----------------------------
CREATE UNIQUE INDEX [XAK1tCharacter_ID] ON [dbo].[tCharacter]
([sID] ASC) 
WITH (FILLFACTOR = 90)
GO
CREATE INDEX [XIE1tCharacter_UserNo] ON [dbo].[tCharacter]
([nUserNo] ASC) 
WITH (FILLFACTOR = 90)
GO

-- ----------------------------
-- Primary Key structure for table [dbo].[tCharacter]
-- ----------------------------
ALTER TABLE [dbo].[tCharacter] ADD PRIMARY KEY ([nCharNo]) WITH (FILLFACTOR=90)
GO

-- ----------------------------
-- Triggers structure for table [dbo].[tCharacter]
-- ----------------------------
DROP TRIGGER [dbo].[trg_Character_setMoney]
GO
CREATE TRIGGER [dbo].[trg_Character_setMoney]
ON [dbo].[tCharacter]
AFTER UPDATE
AS
	DECLARE @before_money int
	DECLARE @after_money int
	DECLARE @procName nvarchar(128)
	DECLARE @moneysub int
	IF UPDATE(nMoney)
		BEGIN
			SELECT @before_money = del.nMoney FROM deleted del
			SELECT @after_money = ins.nMoney FROM inserted ins
			SET @moneysub = @after_money - @before_money	
			IF @moneysub >= 100000000
				BEGIN
					-- Audit OLD record.
					INSERT INTO auditCharacterData (audit_log_type, audit_char_no, audit_char_money)
					SELECT 'OLD', del.nCharNo, del.nMoney 
					  FROM deleted del
					
					-- Audit NEW record.
					INSERT INTO auditCharacterData (audit_log_type, audit_char_no, audit_char_money)
					SELECT 'NEW', ins.nCharNo, ins.nMoney
					  FROM inserted ins
				END
		END

GO

-- ----------------------------
-- Indexes structure for table tCharacterChangeID
-- ----------------------------
CREATE CLUSTERED INDEX [IX_tCharacterChangeID_CL] ON [dbo].[tCharacterChangeID]
([nCharNo] ASC) 
GO

-- ----------------------------
-- Primary Key structure for table [dbo].[tCharacterChangeID]
-- ----------------------------
ALTER TABLE [dbo].[tCharacterChangeID] ADD PRIMARY KEY NONCLUSTERED ([nRowNo])
GO

-- ----------------------------
-- Indexes structure for table tCharacterChargedBuffer
-- ----------------------------
CREATE CLUSTERED INDEX [IX_tCharacterChargedBuffer] ON [dbo].[tCharacterChargedBuffer]
([nCharNo] ASC, [nKey] ASC) 
GO

-- ----------------------------
-- Primary Key structure for table [dbo].[tCharacterChargedBuffer]
-- ----------------------------
ALTER TABLE [dbo].[tCharacterChargedBuffer] ADD PRIMARY KEY NONCLUSTERED ([nNo])
GO

-- ----------------------------
-- Indexes structure for table tCharacterLoading
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tCharacterLoading]
-- ----------------------------
ALTER TABLE [dbo].[tCharacterLoading] ADD PRIMARY KEY ([nCharNo], [nSeqNo])
GO

-- ----------------------------
-- Indexes structure for table tCharacterOptions
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tCharacterOptions]
-- ----------------------------
ALTER TABLE [dbo].[tCharacterOptions] ADD PRIMARY KEY ([nCharNo]) WITH (FILLFACTOR=70)
GO

-- ----------------------------
-- Indexes structure for table tCharacterShape
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tCharacterShape]
-- ----------------------------
ALTER TABLE [dbo].[tCharacterShape] ADD PRIMARY KEY ([nCharNo]) WITH (FILLFACTOR=70)
GO

-- ----------------------------
-- Indexes structure for table tCharacterSingleOption
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tCharacterSingleOption]
-- ----------------------------
ALTER TABLE [dbo].[tCharacterSingleOption] ADD PRIMARY KEY ([nCharNo])
GO

-- ----------------------------
-- Indexes structure for table tCharacterState
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tCharacterState]
-- ----------------------------
ALTER TABLE [dbo].[tCharacterState] ADD PRIMARY KEY ([nCharNo], [nStateNo]) WITH (FILLFACTOR=70)
GO

-- ----------------------------
-- Indexes structure for table tCharacterTitle
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tCharacterTitle]
-- ----------------------------
ALTER TABLE [dbo].[tCharacterTitle] ADD PRIMARY KEY NONCLUSTERED ([nNo]) WITH (FILLFACTOR=70)
GO

-- ----------------------------
-- Uniques structure for table [dbo].[tCharacterTitle]
-- ----------------------------
ALTER TABLE [dbo].[tCharacterTitle] ADD UNIQUE CLUSTERED ([nCharNo] ASC, [nType] ASC, [nElementNo] ASC) WITH (FILLFACTOR=70)
GO

-- ----------------------------
-- Indexes structure for table tChatBlock
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tChatBlock]
-- ----------------------------
ALTER TABLE [dbo].[tChatBlock] ADD PRIMARY KEY ([nUserNo], [nCharNo])
GO

-- ----------------------------
-- Indexes structure for table tDice
-- ----------------------------
CREATE CLUSTERED INDEX [IX_tDice_CL] ON [dbo].[tDice]
([nCharNo] ASC, [nItemKey] ASC) 
GO

-- ----------------------------
-- Primary Key structure for table [dbo].[tDice]
-- ----------------------------
ALTER TABLE [dbo].[tDice] ADD PRIMARY KEY NONCLUSTERED ([nGameNo])
GO

-- ----------------------------
-- Indexes structure for table tDiceLog
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tDiceLog]
-- ----------------------------
ALTER TABLE [dbo].[tDiceLog] ADD PRIMARY KEY ([nGameNo], [nCustomCharNo], [nSlotNo])
GO

-- ----------------------------
-- Indexes structure for table tDicePayLog
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tDicePayLog]
-- ----------------------------
ALTER TABLE [dbo].[tDicePayLog] ADD PRIMARY KEY ([nCharNo], [nItemKey])
GO

-- ----------------------------
-- Indexes structure for table tDiceResult
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tDiceResult]
-- ----------------------------
ALTER TABLE [dbo].[tDiceResult] ADD PRIMARY KEY ([nGameNo], [nCustomCharNo])
GO

-- ----------------------------
-- Indexes structure for table tFriend
-- ----------------------------
CREATE INDEX [IX_nFriendCharNo] ON [dbo].[tFriend]
([nFriendCharNo] ASC) 
GO
CREATE INDEX [IX_tFriend] ON [dbo].[tFriend]
([nFlags] ASC) 
GO

-- ----------------------------
-- Primary Key structure for table [dbo].[tFriend]
-- ----------------------------
ALTER TABLE [dbo].[tFriend] ADD PRIMARY KEY ([nCharNo], [nFriendCharNo])
GO

-- ----------------------------
-- Indexes structure for table tGuild
-- ----------------------------
CREATE UNIQUE INDEX [IX_tGuild] ON [dbo].[tGuild]
([sName] ASC) 
GO

-- ----------------------------
-- Primary Key structure for table [dbo].[tGuild]
-- ----------------------------
ALTER TABLE [dbo].[tGuild] ADD PRIMARY KEY ([nNo])
GO

-- ----------------------------
-- Indexes structure for table tGuildAcademy
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tGuildAcademy]
-- ----------------------------
ALTER TABLE [dbo].[tGuildAcademy] ADD PRIMARY KEY ([nNo])
GO

-- ----------------------------
-- Indexes structure for table tGuildAcademyGraduate
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tGuildAcademyGraduate]
-- ----------------------------
ALTER TABLE [dbo].[tGuildAcademyGraduate] ADD PRIMARY KEY ([nNo], [nCharNo])
GO

-- ----------------------------
-- Indexes structure for table tGuildAcademyMember
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tGuildAcademyMember]
-- ----------------------------
ALTER TABLE [dbo].[tGuildAcademyMember] ADD PRIMARY KEY ([nNo], [nCharNo])
GO

-- ----------------------------
-- Indexes structure for table tGuildAcademyRanking
-- ----------------------------
CREATE CLUSTERED INDEX [IX_tGuildAcademyRanking_CL] ON [dbo].[tGuildAcademyRanking]
([dDate] ASC, [nRanking] ASC, [nGuildNo] ASC) 
GO

-- ----------------------------
-- Primary Key structure for table [dbo].[tGuildAcademyRanking]
-- ----------------------------
ALTER TABLE [dbo].[tGuildAcademyRanking] ADD PRIMARY KEY NONCLUSTERED ([nRowNo])
GO

-- ----------------------------
-- Indexes structure for table tGuildAcademyReward
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tGuildAcademyReward]
-- ----------------------------
ALTER TABLE [dbo].[tGuildAcademyReward] ADD PRIMARY KEY ([nNo], [nLevel], [nTypeID])
GO

-- ----------------------------
-- Indexes structure for table tGuildAcademyRewardType
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tGuildAcademyRewardType]
-- ----------------------------
ALTER TABLE [dbo].[tGuildAcademyRewardType] ADD PRIMARY KEY ([nTypeID])
GO

-- ----------------------------
-- Indexes structure for table tGuildMember
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tGuildMember]
-- ----------------------------
ALTER TABLE [dbo].[tGuildMember] ADD PRIMARY KEY ([nNo], [nCharNo])
GO

-- ----------------------------
-- Uniques structure for table [dbo].[tGuildMember]
-- ----------------------------
ALTER TABLE [dbo].[tGuildMember] ADD UNIQUE ([nCharNo] ASC)
GO

-- ----------------------------
-- Indexes structure for table tGuildTournament
-- ----------------------------
CREATE INDEX [IX_tGuildTournament] ON [dbo].[tGuildTournament]
([nGTNo] ASC) 
GO

-- ----------------------------
-- Primary Key structure for table [dbo].[tGuildTournament]
-- ----------------------------
ALTER TABLE [dbo].[tGuildTournament] ADD PRIMARY KEY ([nGTNo], [nType])
GO

-- ----------------------------
-- Indexes structure for table tGuildTournamentRegist
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tGuildTournamentRegist]
-- ----------------------------
ALTER TABLE [dbo].[tGuildTournamentRegist] ADD PRIMARY KEY ([nGTNo], [nNo])
GO

-- ----------------------------
-- Indexes structure for table tHolyPromise
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tHolyPromise]
-- ----------------------------
ALTER TABLE [dbo].[tHolyPromise] ADD PRIMARY KEY ([nCharNo], [nUpCharNo])
GO

-- ----------------------------
-- Indexes structure for table tHolyPromiseReward
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tHolyPromiseReward]
-- ----------------------------
ALTER TABLE [dbo].[tHolyPromiseReward] ADD PRIMARY KEY ([nCharNo], [nSeqNo])
GO

-- ----------------------------
-- Indexes structure for table tItem
-- ----------------------------
CREATE UNIQUE INDEX [XAK1tItem_Owner_StorageType_Pos] ON [dbo].[tItem]
([nOwner] ASC, [nStorageType] ASC, [nStorage] ASC) 
WITH (FILLFACTOR = 70)
GO

-- ----------------------------
-- Primary Key structure for table [dbo].[tItem]
-- ----------------------------
ALTER TABLE [dbo].[tItem] ADD PRIMARY KEY ([nItemKey]) WITH (FILLFACTOR=70)
GO

-- ----------------------------
-- Indexes structure for table tItemMobList
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tItemMobList]
-- ----------------------------
ALTER TABLE [dbo].[tItemMobList] ADD PRIMARY KEY ([nItemKey], [nMobID]) WITH (FILLFACTOR=70)
GO

-- ----------------------------
-- Indexes structure for table tItemOptions
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tItemOptions]
-- ----------------------------
ALTER TABLE [dbo].[tItemOptions] ADD PRIMARY KEY ([nItemKey], [nOptionType]) WITH (FILLFACTOR=70)
GO

-- ----------------------------
-- Indexes structure for table tItemTitle
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tItemTitle]
-- ----------------------------
ALTER TABLE [dbo].[tItemTitle] ADD PRIMARY KEY ([nItemKey]) WITH (FILLFACTOR=70)
GO

-- ----------------------------
-- Indexes structure for table tKingdomQuest
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tKingdomQuest]
-- ----------------------------
ALTER TABLE [dbo].[tKingdomQuest] ADD PRIMARY KEY ([nQuestNo])
GO

-- ----------------------------
-- Indexes structure for table tLevelCatchUpRank
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tLevelCatchUpRank]
-- ----------------------------
ALTER TABLE [dbo].[tLevelCatchUpRank] ADD PRIMARY KEY ([sID])
GO

-- ----------------------------
-- Indexes structure for table tMarriage
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tMarriage]
-- ----------------------------
ALTER TABLE [dbo].[tMarriage] ADD PRIMARY KEY ([nCharNo], [nPartnerCharNo])
GO

-- ----------------------------
-- Indexes structure for table tMasterPupils
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tMasterPupils]
-- ----------------------------
ALTER TABLE [dbo].[tMasterPupils] ADD PRIMARY KEY ([nMaster], [nPupils])
GO

-- ----------------------------
-- Uniques structure for table [dbo].[tMasterPupils]
-- ----------------------------
ALTER TABLE [dbo].[tMasterPupils] ADD UNIQUE ([nPupils] ASC)
GO

-- ----------------------------
-- Indexes structure for table tMinihouse
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tMinihouse]
-- ----------------------------
ALTER TABLE [dbo].[tMinihouse] ADD PRIMARY KEY ([nCharNo])
GO

-- ----------------------------
-- Indexes structure for table tMinihouseGate
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tMinihouseGate]
-- ----------------------------
ALTER TABLE [dbo].[tMinihouseGate] ADD PRIMARY KEY ([nCharNo], [nItemID])
GO

-- ----------------------------
-- Indexes structure for table tMinihouseGuest
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tMinihouseGuest]
-- ----------------------------
ALTER TABLE [dbo].[tMinihouseGuest] ADD PRIMARY KEY NONCLUSTERED ([nArticleNo])
GO

-- ----------------------------
-- Indexes structure for table tParty
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tParty]
-- ----------------------------
ALTER TABLE [dbo].[tParty] ADD PRIMARY KEY ([nPartyNo])
GO

-- ----------------------------
-- Indexes structure for table tPartyMember
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tPartyMember]
-- ----------------------------
ALTER TABLE [dbo].[tPartyMember] ADD PRIMARY KEY ([nPartyNo], [nCharNo])
GO

-- ----------------------------
-- Indexes structure for table tPet
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tPet]
-- ----------------------------
ALTER TABLE [dbo].[tPet] ADD PRIMARY KEY ([nPetKey])
GO

-- ----------------------------
-- Indexes structure for table tPetSkill
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tPetSkill]
-- ----------------------------
ALTER TABLE [dbo].[tPetSkill] ADD PRIMARY KEY ([nPetKey], [nSkillNo])
GO

-- ----------------------------
-- Indexes structure for table tPrison
-- ----------------------------
CREATE CLUSTERED INDEX [IDX_nCharID_dPrsonDateDesc] ON [dbo].[tPrison]
([nCharID] ASC, [dPrisonDate] DESC) 
GO

-- ----------------------------
-- Primary Key structure for table [dbo].[tPrison]
-- ----------------------------
ALTER TABLE [dbo].[tPrison] ADD PRIMARY KEY NONCLUSTERED ([nPrisonNum])
GO

-- ----------------------------
-- Indexes structure for table tQuest
-- ----------------------------
CREATE INDEX [IX_tQuest] ON [dbo].[tQuest]
([nCharNo] ASC, [nStatus] ASC) 
GO

-- ----------------------------
-- Primary Key structure for table [dbo].[tQuest]
-- ----------------------------
ALTER TABLE [dbo].[tQuest] ADD PRIMARY KEY ([nCharNo], [nQuestNo])
GO

-- ----------------------------
-- Indexes structure for table tQuestTimes
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tQuestTimes]
-- ----------------------------
ALTER TABLE [dbo].[tQuestTimes] ADD PRIMARY KEY NONCLUSTERED ([nCharNo], [nQuestNo])
GO

-- ----------------------------
-- Indexes structure for table tSkill
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tSkill]
-- ----------------------------
ALTER TABLE [dbo].[tSkill] ADD PRIMARY KEY ([nCharNo], [nSkillNo])
GO

-- ----------------------------
-- Indexes structure for table tSpamBlockTime
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tSpamBlockTime]
-- ----------------------------
ALTER TABLE [dbo].[tSpamBlockTime] ADD PRIMARY KEY ([nCharNo])
GO

-- ----------------------------
-- Indexes structure for table tSpamFilter
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tSpamFilter]
-- ----------------------------
ALTER TABLE [dbo].[tSpamFilter] ADD PRIMARY KEY ([nUserNo])
GO

-- ----------------------------
-- Indexes structure for table tUserMoney
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tUserMoney]
-- ----------------------------
ALTER TABLE [dbo].[tUserMoney] ADD PRIMARY KEY ([nUserNo])
GO

-- ----------------------------
-- Foreign Key structure for table [dbo].[tCharacterChangeID]
-- ----------------------------
ALTER TABLE [dbo].[tCharacterChangeID] ADD FOREIGN KEY ([nCharNo]) REFERENCES [dbo].[tCharacter] ([nCharNo]) ON DELETE NO ACTION ON UPDATE NO ACTION
GO

-- ----------------------------
-- Foreign Key structure for table [dbo].[tCharacterChargedBuffer]
-- ----------------------------
ALTER TABLE [dbo].[tCharacterChargedBuffer] ADD FOREIGN KEY ([nCharNo]) REFERENCES [dbo].[tCharacter] ([nCharNo]) ON DELETE NO ACTION ON UPDATE CASCADE
GO

-- ----------------------------
-- Foreign Key structure for table [dbo].[tCharacterSingleOption]
-- ----------------------------
ALTER TABLE [dbo].[tCharacterSingleOption] ADD FOREIGN KEY ([nCharNo]) REFERENCES [dbo].[tCharacter] ([nCharNo]) ON DELETE NO ACTION ON UPDATE NO ACTION
GO

-- ----------------------------
-- Foreign Key structure for table [dbo].[tCharacterTitle]
-- ----------------------------
ALTER TABLE [dbo].[tCharacterTitle] ADD FOREIGN KEY ([nCharNo]) REFERENCES [dbo].[tCharacter] ([nCharNo]) ON DELETE CASCADE ON UPDATE CASCADE
GO

-- ----------------------------
-- Foreign Key structure for table [dbo].[tDiceLog]
-- ----------------------------
ALTER TABLE [dbo].[tDiceLog] ADD FOREIGN KEY ([nGameNo], [nCustomCharNo]) REFERENCES [dbo].[tDiceResult] ([nGameNo], [nCustomCharNo]) ON DELETE NO ACTION ON UPDATE NO ACTION
GO

-- ----------------------------
-- Foreign Key structure for table [dbo].[tDiceResult]
-- ----------------------------
ALTER TABLE [dbo].[tDiceResult] ADD FOREIGN KEY ([nGameNo]) REFERENCES [dbo].[tDice] ([nGameNo]) ON DELETE NO ACTION ON UPDATE NO ACTION
GO

-- ----------------------------
-- Foreign Key structure for table [dbo].[tGuildAcademy]
-- ----------------------------
ALTER TABLE [dbo].[tGuildAcademy] ADD FOREIGN KEY ([nMasterCharNo]) REFERENCES [dbo].[tCharacter] ([nCharNo]) ON DELETE NO ACTION ON UPDATE NO ACTION
GO
ALTER TABLE [dbo].[tGuildAcademy] ADD FOREIGN KEY ([nMasterCharNo]) REFERENCES [dbo].[tCharacter] ([nCharNo]) ON DELETE NO ACTION ON UPDATE NO ACTION
GO
ALTER TABLE [dbo].[tGuildAcademy] ADD FOREIGN KEY ([nNo]) REFERENCES [dbo].[tGuild] ([nNo]) ON DELETE CASCADE ON UPDATE CASCADE
GO

-- ----------------------------
-- Foreign Key structure for table [dbo].[tGuildAcademyMember]
-- ----------------------------
ALTER TABLE [dbo].[tGuildAcademyMember] ADD FOREIGN KEY ([nCharNo]) REFERENCES [dbo].[tCharacter] ([nCharNo]) ON DELETE NO ACTION ON UPDATE NO ACTION
GO
ALTER TABLE [dbo].[tGuildAcademyMember] ADD FOREIGN KEY ([nCharNo]) REFERENCES [dbo].[tCharacter] ([nCharNo]) ON DELETE NO ACTION ON UPDATE NO ACTION
GO
ALTER TABLE [dbo].[tGuildAcademyMember] ADD FOREIGN KEY ([nNo]) REFERENCES [dbo].[tGuildAcademy] ([nNo]) ON DELETE CASCADE ON UPDATE CASCADE
GO

-- ----------------------------
-- Foreign Key structure for table [dbo].[tGuildAcademyReward]
-- ----------------------------
ALTER TABLE [dbo].[tGuildAcademyReward] ADD FOREIGN KEY ([nTypeID]) REFERENCES [dbo].[tGuildAcademyRewardType] ([nTypeID]) ON DELETE NO ACTION ON UPDATE NO ACTION
GO
ALTER TABLE [dbo].[tGuildAcademyReward] ADD FOREIGN KEY ([nTypeID]) REFERENCES [dbo].[tGuildAcademyRewardType] ([nTypeID]) ON DELETE NO ACTION ON UPDATE NO ACTION
GO
ALTER TABLE [dbo].[tGuildAcademyReward] ADD FOREIGN KEY ([nNo]) REFERENCES [dbo].[tGuildAcademy] ([nNo]) ON DELETE CASCADE ON UPDATE CASCADE
GO

-- ----------------------------
-- Foreign Key structure for table [dbo].[tGuildMember]
-- ----------------------------
ALTER TABLE [dbo].[tGuildMember] ADD FOREIGN KEY ([nNo]) REFERENCES [dbo].[tGuild] ([nNo]) ON DELETE CASCADE ON UPDATE CASCADE
GO

-- ----------------------------
-- Foreign Key structure for table [dbo].[tHolyPromise]
-- ----------------------------
ALTER TABLE [dbo].[tHolyPromise] ADD FOREIGN KEY ([nCharNo]) REFERENCES [dbo].[tCharacter] ([nCharNo]) ON DELETE CASCADE ON UPDATE CASCADE
GO

-- ----------------------------
-- Foreign Key structure for table [dbo].[tItemMobList]
-- ----------------------------
ALTER TABLE [dbo].[tItemMobList] ADD FOREIGN KEY ([nItemKey]) REFERENCES [dbo].[tItem] ([nItemKey]) ON DELETE CASCADE ON UPDATE CASCADE
GO

-- ----------------------------
-- Foreign Key structure for table [dbo].[tItemOptions]
-- ----------------------------
ALTER TABLE [dbo].[tItemOptions] ADD FOREIGN KEY ([nItemKey]) REFERENCES [dbo].[tItem] ([nItemKey]) ON DELETE CASCADE ON UPDATE CASCADE
GO

-- ----------------------------
-- Foreign Key structure for table [dbo].[tItemTitle]
-- ----------------------------
ALTER TABLE [dbo].[tItemTitle] ADD FOREIGN KEY ([nItemKey]) REFERENCES [dbo].[tItem] ([nItemKey]) ON DELETE CASCADE ON UPDATE CASCADE
GO

-- ----------------------------
-- Foreign Key structure for table [dbo].[tMinihouse]
-- ----------------------------
ALTER TABLE [dbo].[tMinihouse] ADD FOREIGN KEY ([nCharNo]) REFERENCES [dbo].[tCharacter] ([nCharNo]) ON DELETE NO ACTION ON UPDATE NO ACTION
GO

-- ----------------------------
-- Foreign Key structure for table [dbo].[tMinihouseGate]
-- ----------------------------
ALTER TABLE [dbo].[tMinihouseGate] ADD FOREIGN KEY ([nCharNo]) REFERENCES [dbo].[tMinihouse] ([nCharNo]) ON DELETE NO ACTION ON UPDATE NO ACTION
GO

-- ----------------------------
-- Foreign Key structure for table [dbo].[tMinihouseGuest]
-- ----------------------------
ALTER TABLE [dbo].[tMinihouseGuest] ADD FOREIGN KEY ([nCharNo]) REFERENCES [dbo].[tMinihouse] ([nCharNo]) ON DELETE NO ACTION ON UPDATE NO ACTION
GO

-- ----------------------------
-- Foreign Key structure for table [dbo].[tPartyMember]
-- ----------------------------
ALTER TABLE [dbo].[tPartyMember] ADD FOREIGN KEY ([nPartyNo]) REFERENCES [dbo].[tParty] ([nPartyNo]) ON DELETE NO ACTION ON UPDATE NO ACTION
GO
ALTER TABLE [dbo].[tPartyMember] ADD FOREIGN KEY ([nPartyNo]) REFERENCES [dbo].[tParty] ([nPartyNo]) ON DELETE NO ACTION ON UPDATE NO ACTION
GO
ALTER TABLE [dbo].[tPartyMember] ADD FOREIGN KEY ([nPartyNo]) REFERENCES [dbo].[tParty] ([nPartyNo]) ON DELETE NO ACTION ON UPDATE NO ACTION
GO

-- ----------------------------
-- Foreign Key structure for table [dbo].[tPetSkill]
-- ----------------------------
ALTER TABLE [dbo].[tPetSkill] ADD FOREIGN KEY ([nPetKey]) REFERENCES [dbo].[tPet] ([nPetKey]) ON DELETE NO ACTION ON UPDATE NO ACTION
GO
