/*
Navicat SQL Server Data Transfer

Source Server         : 88.198.10.166
Source Server Version : 105000
Source Host           : 88.198.10.166:1433
Source Database       : w00_GameLog
Source Schema         : dbo

Target Server Type    : SQL Server
Target Server Version : 105000
File Encoding         : 65001

Date: 2012-01-28 20:14:53
*/


-- ----------------------------
-- Table structure for [dbo].[tCharacterSingleOption]
-- ----------------------------
DROP TABLE [dbo].[tCharacterSingleOption]
GO
CREATE TABLE [dbo].[tCharacterSingleOption] (
[nCharNo] int NOT NULL ,
[sys_create_date] datetime NOT NULL DEFAULT (getdate()) ,
[sys_update_date] datetime NULL ,
[bMysteryBolt] bit NOT NULL DEFAULT ((1)) ,
[bAutoPick] bit NOT NULL DEFAULT ((0)) ,
[dRestExpLastExecuteTime] datetime NOT NULL DEFAULT (getdate()) 
)


GO

-- ----------------------------
-- Records of tCharacterSingleOption
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tGameLog]
-- ----------------------------
DROP TABLE [dbo].[tGameLog]
GO
CREATE TABLE [dbo].[tGameLog] (
[nLogNo] bigint NOT NULL IDENTITY(1,1) ,
[dDate] datetime NOT NULL DEFAULT (getdate()) ,
[nType] int NOT NULL ,
[nCharNo] int NULL ,
[sMap] varchar(16) NULL ,
[nMapX] int NULL ,
[nMapY] int NULL ,
[nMapZ] int NULL ,
[nTargetCharNo] int NULL ,
[nTargetID] int NULL ,
[nItemKey] bigint NULL ,
[nInt1] int NULL ,
[nInt2] int NULL ,
[nInt3] int NULL ,
[nBigint1] bigint NULL 
)


GO
DBCC CHECKIDENT(N'[dbo].[tGameLog]', RESEED, 4380561)
GO

-- ----------------------------
-- Records of tGameLog
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tLevelUpInfo]
-- ----------------------------
DROP TABLE [dbo].[tLevelUpInfo]
GO
CREATE TABLE [dbo].[tLevelUpInfo] (
[nCharNo] int NOT NULL ,
[nLevel] int NOT NULL ,
[dLastUpdated] datetime NOT NULL 
)


GO

-- ----------------------------
-- Records of tLevelUpInfo
-- ----------------------------

-- ----------------------------
-- Table structure for [dbo].[tQuestRank]
-- ----------------------------
DROP TABLE [dbo].[tQuestRank]
GO
CREATE TABLE [dbo].[tQuestRank] (
[nCharNo] int NULL ,
[cnt] int NULL 
)


GO

-- ----------------------------
-- Records of tQuestRank
-- ----------------------------

-- ----------------------------
-- Procedure structure for [dbo].[Adam_ListProc]
-- ----------------------------
DROP PROCEDURE [dbo].[Adam_ListProc]
GO
create procedure [dbo].[Adam_ListProc] as  select o.name, m.definition   from sys.sql_modules m join sys.objects o  On m.object_id=o.object_id and o.type='P'

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_Add]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_Add]
GO
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add    스크립트 날짜: 2007-03-13 오후 6:26:53 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add    스크립트 날짜: 2005-05-30 오후 4:04:11 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add    스크립트 날짜: 2005-01-28 오후 7:39:26 ******/
CREATE PROCEDURE [dbo].[p_GameLog_Add]
/*
 Game log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nLogNo bigint OUTPUT,
@nType int,
@nCharNo int,
@sMap varchar(16),
@nMapX int,
@nMapY int,
@nMapZ int,
@nTargetCharNo int,
@nTargetID int,
@nItemKey bigint,
@nInt1 int,
@nInt2 int,
@nInt3 int,
@nBigint1 bigint
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tGameLog (  nType,  nCharNo,  sMap,  nMapX,  nMapY,  nMapZ,  nTargetCharNo,  nTargetID,  nItemKey,  nInt1,  nInt2,  nInt3,  nBigint1 )
VALUES          ( @nType, @nCharNo, @sMap, @nMapX, @nMapY, @nMapZ, @nTargetCharNo, @nTargetID, @nItemKey, @nInt1, @nInt2, @nInt3, @nBigint1 )
SET @nLogNo = @@IDENTITY
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_Add_Type1]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_Add_Type1]
GO
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type1    스크립트 날짜: 2007-03-13 오후 6:26:53 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type1    스크립트 날짜: 2005-05-30 오후 4:04:12 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type1    스크립트 날짜: 2005-01-28 오후 7:39:26 ******/
CREATE PROCEDURE [dbo].[p_GameLog_Add_Type1]
/*
 Game log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nLogNo bigint OUTPUT,
@nType int,
@nCharNo int,
@sMap varchar(16),
@nMapX int,
@nMapY int,
@nMapZ int
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tGameLog (  nType,  nCharNo,  sMap,  nMapX,  nMapY,  nMapZ )
VALUES          ( @nType, @nCharNo, @sMap, @nMapX, @nMapY, @nMapZ )
SET @nLogNo = @@IDENTITY
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_Add_Type2]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_Add_Type2]
GO
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type2    스크립트 날짜: 2007-03-13 오후 6:26:53 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type2    스크립트 날짜: 2005-05-30 오후 4:04:12 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type2    스크립트 날짜: 2005-01-28 오후 7:39:26 ******/
CREATE PROCEDURE [dbo].[p_GameLog_Add_Type2]
/*
 Game log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nLogNo bigint OUTPUT,
@nType int,
@nCharNo int,
@sMap varchar(16),
@nMapX int,
@nMapY int,
@nMapZ int,
@nInt1 int,
@nInt2 int
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tGameLog (  nType,  nCharNo,  sMap,  nMapX,  nMapY,  nMapZ,  nInt1,  nInt2 )
VALUES          ( @nType, @nCharNo, @sMap, @nMapX, @nMapY, @nMapZ, @nInt1, @nInt2 )
SET @nLogNo = @@IDENTITY
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_Add_Type3]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_Add_Type3]
GO
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type3    스크립트 날짜: 2007-03-13 오후 6:26:54 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type3    스크립트 날짜: 2005-05-30 오후 4:04:12 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type3    스크립트 날짜: 2005-01-28 오후 7:39:26 ******/
CREATE PROCEDURE [dbo].[p_GameLog_Add_Type3]
/*
 Game log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nLogNo bigint OUTPUT,
@nType int,
@nCharNo int,
@sMap varchar(16),
@nMapX int,
@nMapY int,
@nMapZ int,
@nTargetCharNo int,
@nTargetID int,
@nInt1 int
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tGameLog (  nType,  nCharNo,  sMap,  nMapX,  nMapY,  nMapZ,  nTargetCharNo,  nTargetID,  nInt1 )
VALUES          ( @nType, @nCharNo, @sMap, @nMapX, @nMapY, @nMapZ, @nTargetCharNo, @nTargetID, @nInt1 )
SET @nLogNo = @@IDENTITY
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_Add_Type4]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_Add_Type4]
GO
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type4    스크립트 날짜: 2007-03-13 오후 6:26:54 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type4    스크립트 날짜: 2005-05-30 오후 4:04:12 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type4    스크립트 날짜: 2005-01-28 오후 7:39:26 ******/
CREATE PROCEDURE [dbo].[p_GameLog_Add_Type4]
/*
 Game log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nLogNo bigint OUTPUT,
@nType int,
@nCharNo int,
@sMap varchar(16),
@nMapX int,
@nMapY int,
@nMapZ int,
@nInt1 int,
@nInt2 int,
@nInt3 int
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tGameLog (  nType,  nCharNo,  sMap,  nMapX,  nMapY,  nMapZ,  nInt1,  nInt2,  nInt3 )
VALUES          ( @nType, @nCharNo, @sMap, @nMapX, @nMapY, @nMapZ, @nInt1, @nInt2, @nInt3 )
SET @nLogNo = @@IDENTITY
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_Add_Type5]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_Add_Type5]
GO
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type5    스크립트 날짜: 2007-03-13 오후 6:26:54 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type5    스크립트 날짜: 2005-05-30 오후 4:04:12 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type5    스크립트 날짜: 2005-01-28 오후 7:39:26 ******/
CREATE PROCEDURE [dbo].[p_GameLog_Add_Type5]
/*
 Game log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nLogNo bigint OUTPUT,
@nType int,
@nCharNo int,
@nInt1 int,
@nInt2 int
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tGameLog (  nType,  nCharNo,  nInt1,  nInt2 )
VALUES          ( @nType, @nCharNo, @nInt1, @nInt2 )
SET @nLogNo = @@IDENTITY
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_Add_Type6]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_Add_Type6]
GO
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type6    스크립트 날짜: 2007-03-13 오후 6:26:54 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type6    스크립트 날짜: 2005-05-30 오후 4:04:12 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type6    스크립트 날짜: 2005-01-28 오후 7:39:26 ******/
CREATE PROCEDURE [dbo].[p_GameLog_Add_Type6]
/*
 Game log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nLogNo bigint OUTPUT,
@nType int,
@nCharNo int,
@sMap varchar(16),
@nMapX int,
@nMapY int,
@nMapZ int,
@nInt1 int,
@nBigint1 bigint
AS
SET NOCOUNT ON
-- 이벤트 랭킹용으로 별도 테이블기록 by amadeus.
IF @nType = 30 
BEGIN
	IF EXISTS(SELECT  * FROM tLevelUpInfo where nCharNo=@nCharNo)
		UPDATE tLevelUpInfo set nLevel = @nInt1, dLastUpdated = getdate() WHERE nCharNo=@nCharNo
	ELSE
		INSERT INTO tLevelUpInfo VALUES(@nCharNo, @nInt1, getdate())
END

SET @nLogNo = 0
INSERT tGameLog (  nType,  nCharNo,  sMap,  nMapX,  nMapY,  nMapZ,  nInt1,  nBigint1 )
VALUES          ( @nType, @nCharNo, @sMap, @nMapX, @nMapY, @nMapZ, @nInt1, @nBigint1 )
SET @nLogNo = @@IDENTITY
-- end


GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_Add_Type7]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_Add_Type7]
GO
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type7    스크립트 날짜: 2007-03-13 오후 6:26:54 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type7    스크립트 날짜: 2005-05-30 오후 4:04:12 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type7    스크립트 날짜: 2005-01-28 오후 7:39:26 ******/
CREATE PROCEDURE [dbo].[p_GameLog_Add_Type7]
/*
 Game log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nLogNo bigint OUTPUT,
@nType int,
@nCharNo int,
@sMap varchar(16),
@nMapX int,
@nMapY int,
@nMapZ int,
@nTargetCharNo int,
@nInt1 int,
@nInt2 int
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tGameLog (  nType,  nCharNo,  sMap,  nMapX,  nMapY,  nMapZ,  nTargetCharNo,  nInt1,  nInt2 )
VALUES          ( @nType, @nCharNo, @sMap, @nMapX, @nMapY, @nMapZ, @nTargetCharNo, @nInt1, @nInt2 )
SET @nLogNo = @@IDENTITY
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_Add_Type8]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_Add_Type8]
GO
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type8    스크립트 날짜: 2007-03-13 오후 6:26:54 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type8    스크립트 날짜: 2005-05-30 오후 4:04:12 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type8    스크립트 날짜: 2005-01-28 오후 7:39:26 ******/
CREATE PROCEDURE [dbo].[p_GameLog_Add_Type8]
/*
 Game log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nLogNo bigint OUTPUT,
@nType int,
@nCharNo int,
@sMap varchar(16),
@nMapX int,
@nMapY int,
@nMapZ int,
@nInt1 int
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tGameLog (  nType,  nCharNo,  sMap,  nMapX,  nMapY,  nMapZ,  nInt1 )
VALUES          ( @nType, @nCharNo, @sMap, @nMapX, @nMapY, @nMapZ, @nInt1 )
SET @nLogNo = @@IDENTITY
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_Add_Type9]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_Add_Type9]
GO
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type9    스크립트 날짜: 2007-03-13 오후 6:26:54 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type9    스크립트 날짜: 2005-05-30 오후 4:04:12 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_Type9    스크립트 날짜: 2005-01-28 오후 7:39:26 ******/
CREATE PROCEDURE [dbo].[p_GameLog_Add_Type9]
/*
 Game log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nLogNo bigint OUTPUT,
@nType int,
@nCharNo int,
@sMap varchar(16),
@nMapX int,
@nMapY int,
@nMapZ int,
@nItemKey bigint,
@nInt1 int,
@nInt2 int
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tGameLog (  nType,  nCharNo,  sMap,  nMapX,  nMapY,  nMapZ,  nItemKey,  nInt1,  nInt2 )
VALUES          ( @nType, @nCharNo, @sMap, @nMapX, @nMapY, @nMapZ, @nItemKey, @nInt1, @nInt2 )
SET @nLogNo = @@IDENTITY
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_Add_TypeA]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_Add_TypeA]
GO
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeA    스크립트 날짜: 2007-03-13 오후 6:26:54 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeA    스크립트 날짜: 2005-05-30 오후 4:04:12 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeA    스크립트 날짜: 2005-01-28 오후 7:39:26 ******/
CREATE PROCEDURE [dbo].[p_GameLog_Add_TypeA]
/*
 Game log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nLogNo bigint OUTPUT,
@nType int,
@nCharNo int,
@nTargetCharNo int,
@nTargetID int,
@nItemKey bigint,
@nInt1 int,
@nInt2 int,
@nInt3 int
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tGameLog (  nType,  nCharNo,  nTargetCharNo,  nTargetID,  nItemKey,  nInt1,  nInt2,  nInt3 )
VALUES          ( @nType, @nCharNo, @nTargetCharNo, @nTargetID, @nItemKey, @nInt1, @nInt2, @nInt3 )
SET @nLogNo = @@IDENTITY
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_Add_TypeB]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_Add_TypeB]
GO
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeB    스크립트 날짜: 2007-03-13 오후 6:26:54 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeB    스크립트 날짜: 2005-05-30 오후 4:04:12 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeB    스크립트 날짜: 2005-01-28 오후 7:39:26 ******/
CREATE PROCEDURE [dbo].[p_GameLog_Add_TypeB]
/*
 Game log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nLogNo bigint OUTPUT,
@nType int,
@nCharNo int,
@sMap varchar(16),
@nMapX int,
@nMapY int,
@nMapZ int,
@nTargetCharNo int,
@nTargetID int,
@nItemKey bigint,
@nInt1 int,
@nInt2 int,
@nInt3 int
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tGameLog (  nType,  nCharNo,  sMap,  nMapX,  nMapY,  nMapZ,  nTargetCharNo,  nTargetID,  nItemKey,  nInt1,  nInt2,  nInt3 )
VALUES          ( @nType, @nCharNo, @sMap, @nMapX, @nMapY, @nMapZ, @nTargetCharNo, @nTargetID, @nItemKey, @nInt1, @nInt2, @nInt3 )
SET @nLogNo = @@IDENTITY
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_Add_TypeC]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_Add_TypeC]
GO
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeC    스크립트 날짜: 2007-03-13 오후 6:26:54 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeC    스크립트 날짜: 2005-05-30 오후 4:04:12 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeC    스크립트 날짜: 2005-01-28 오후 7:39:26 ******/
CREATE PROCEDURE [dbo].[p_GameLog_Add_TypeC]
/*
 Game log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nLogNo bigint OUTPUT,
@nType int,
@nCharNo int,
@sMap varchar(16),
@nMapX int,
@nMapY int,
@nMapZ int,
@nTargetID int,
@nItemKey bigint,
@nInt1 int,
@nInt2 int,
@nInt3 int
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tGameLog (  nType,  nCharNo,  sMap,  nMapX,  nMapY,  nMapZ,  nTargetID,  nItemKey,  nInt1,  nInt2,  nInt3 )
VALUES          ( @nType, @nCharNo, @sMap, @nMapX, @nMapY, @nMapZ, @nTargetID, @nItemKey, @nInt1, @nInt2, @nInt3 )
SET @nLogNo = @@IDENTITY
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_Add_TypeD]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_Add_TypeD]
GO
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeD    스크립트 날짜: 2007-03-13 오후 6:26:54 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeD    스크립트 날짜: 2005-05-30 오후 4:04:12 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeD    스크립트 날짜: 2005-01-28 오후 7:39:26 ******/
CREATE PROCEDURE [dbo].[p_GameLog_Add_TypeD]
/*
 Game log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nLogNo bigint OUTPUT,
@nType int,
@nCharNo int,
@nItemKey bigint,
@nInt1 int,
@nInt2 int
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tGameLog (  nType,  nCharNo,  nItemKey,  nInt1,  nInt2 )
VALUES          ( @nType, @nCharNo, @nItemKey, @nInt1, @nInt2 )
SET @nLogNo = @@IDENTITY
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_Add_TypeE]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_Add_TypeE]
GO
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeE    스크립트 날짜: 2007-03-13 오후 6:26:54 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeE    스크립트 날짜: 2005-05-30 오후 4:04:12 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeE    스크립트 날짜: 2005-01-28 오후 7:39:26 ******/
CREATE PROCEDURE [dbo].[p_GameLog_Add_TypeE]
/*
 Game log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nLogNo bigint OUTPUT,
@nType int,
@sMap varchar(16),
@nMapX int,
@nMapY int,
@nMapZ int,
@nTargetID int,
@nItemKey bigint,
@nInt1 int,
@nInt2 int
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tGameLog (  nType,  sMap,  nMapX,  nMapY,  nMapZ,  nTargetID,  nItemKey,  nInt1,  nInt2 )
VALUES          ( @nType, @sMap, @nMapX, @nMapY, @nMapZ, @nTargetID, @nItemKey, @nInt1, @nInt2 )
SET @nLogNo = @@IDENTITY
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_Add_TypeF]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_Add_TypeF]
GO
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeF    스크립트 날짜: 2007-03-13 오후 6:26:54 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeF    스크립트 날짜: 2005-05-30 오후 4:04:12 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeF    스크립트 날짜: 2005-01-28 오후 7:39:26 ******/
CREATE PROCEDURE [dbo].[p_GameLog_Add_TypeF]
/*
 Game log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nLogNo bigint OUTPUT,
@nType int,
@nCharNo int,
@sMap varchar(16),
@nMapX int,
@nMapY int,
@nMapZ int,
@nTargetID int,
@nItemKey bigint,
@nInt1 int,
@nInt2 int,
@nInt3 int,
@nBigint1 bigint
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tGameLog (  nType,  nCharNo,  sMap,  nMapX,  nMapY,  nMapZ,  nTargetID,  nItemKey,  nInt1,  nInt2,  nInt3,  nBigint1 )
VALUES          ( @nType, @nCharNo, @sMap, @nMapX, @nMapY, @nMapZ, @nTargetID, @nItemKey, @nInt1, @nInt2, @nInt3, @nBigint1 )
SET @nLogNo = @@IDENTITY
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_Add_TypeG]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_Add_TypeG]
GO
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeG    스크립트 날짜: 2007-03-13 오후 6:26:54 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeG    스크립트 날짜: 2005-05-30 오후 4:04:12 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeG    스크립트 날짜: 2005-01-28 오후 7:39:26 ******/
CREATE PROCEDURE [dbo].[p_GameLog_Add_TypeG]
/*
 Game log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nLogNo bigint OUTPUT,
@nType int,
@nCharNo int,
@sMap varchar(16),
@nMapX int,
@nMapY int,
@nMapZ int,
@nTargetID int,
@nItemKey bigint,
@nInt1 int,
@nInt2 int,
@nBigint1 bigint
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tGameLog (  nType,  nCharNo,  sMap,  nMapX,  nMapY,  nMapZ,  nTargetID,  nItemKey,  nInt1,  nInt2,  nBigint1 )
VALUES          ( @nType, @nCharNo, @sMap, @nMapX, @nMapY, @nMapZ, @nTargetID, @nItemKey, @nInt1, @nInt2, @nBigint1 )
SET @nLogNo = @@IDENTITY
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_Add_TypeH]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_Add_TypeH]
GO
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeH    스크립트 날짜: 2007-03-13 오후 6:26:54 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeH    스크립트 날짜: 2005-05-30 오후 4:04:12 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeH    스크립트 날짜: 2005-01-28 오후 7:39:26 ******/
CREATE PROCEDURE [dbo].[p_GameLog_Add_TypeH]
/*
 Game log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nLogNo bigint OUTPUT,
@nType int,
@nCharNo int,
@sMap varchar(16),
@nMapX int,
@nMapY int,
@nMapZ int,
@nTargetCharNo int
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tGameLog (  nType,  nCharNo,  sMap,  nMapX,  nMapY,  nMapZ,  nTargetCharNo )
VALUES          ( @nType, @nCharNo, @sMap, @nMapX, @nMapY, @nMapZ, @nTargetCharNo )
SET @nLogNo = @@IDENTITY
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_Add_TypeI]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_Add_TypeI]
GO
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeI    스크립트 날짜: 2007-03-13 오후 6:26:54 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeI    스크립트 날짜: 2005-05-30 오후 4:04:12 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeI    스크립트 날짜: 2005-01-28 오후 7:39:26 ******/
CREATE PROCEDURE [dbo].[p_GameLog_Add_TypeI]
/*
 Game log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nLogNo bigint OUTPUT,
@nType int,
@nCharNo int,
@sMap varchar(16),
@nMapX int,
@nMapY int,
@nMapZ int,
@nTargetCharNo int,
@nTargetID int
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tGameLog (  nType,  nCharNo,  sMap,  nMapX,  nMapY,  nMapZ,  nTargetCharNo,  nTargetID )
VALUES          ( @nType, @nCharNo, @sMap, @nMapX, @nMapY, @nMapZ, @nTargetCharNo, @nTargetID )
SET @nLogNo = @@IDENTITY
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_Add_TypeJ]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_Add_TypeJ]
GO
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeJ    스크립트 날짜: 2007-03-13 오후 6:26:54 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeJ    스크립트 날짜: 2005-05-30 오후 4:04:12 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Add_TypeJ    스크립트 날짜: 2005-01-28 오후 7:39:26 ******/
CREATE PROCEDURE [dbo].[p_GameLog_Add_TypeJ]
/*
 Game log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nLogNo bigint OUTPUT,
@nType int,
@nCharNo int,
@sMap varchar(16),
@nMapX int,
@nMapY int,
@nMapZ int,
@nTargetID int,
@nItemKey bigint,
@nInt1 int,
@nInt2 int
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tGameLog (  nType,  nCharNo,  sMap,  nMapX,  nMapY,  nMapZ,  nTargetID,  nItemKey,  nInt1,  nInt2 )
VALUES          ( @nType, @nCharNo, @sMap, @nMapX, @nMapY, @nMapZ, @nTargetID, @nItemKey, @nInt1, @nInt2 )
SET @nLogNo = @@IDENTITY
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_Add_TypeK]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_Add_TypeK]
GO

CREATE PROCEDURE [dbo].[p_GameLog_Add_TypeK]
/*
 Game log add
 input:
  All Args = 로그에 기록될 정보
 output: 
  nLogNo = 추가된 로그의 번호(에러시 LogNo = 0 )
*/
@nLogNo bigint OUTPUT,
@nType int,
@nCharNo int,
@sMap varchar(16),
@nMapX int,
@nMapY int,
@nMapZ int,
@nInt1 int,
@nInt2 int,
@nBigint1 bigint
AS
SET NOCOUNT ON
SET @nLogNo = 0
INSERT tGameLog (  nType,  nCharNo,  sMap,  nMapX,  nMapY,  nMapZ,  nInt1,  nInt2,  nBigint1 )
VALUES          ( @nType, @nCharNo, @sMap, @nMapX, @nMapY, @nMapZ, @nInt1, @nInt2, @nBigint1 )
SET @nLogNo = @@IDENTITY
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_Get]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_Get]
GO
/****** 개체: 저장 프로시저 dbo.p_GameLog_Get    스크립트 날짜: 2007-03-13 오후 6:26:53 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Get    스크립트 날짜: 2005-05-30 오후 4:04:11 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_Get    스크립트 날짜: 2005-01-28 오후 7:39:26 ******/
CREATE PROCEDURE [dbo].[p_GameLog_Get]
/*
  GameLog Get - 주어진 조건에 맞는 로그를 모두검색해서 얻는다.
  input:
   - 주어진 조건절
  output:
   - Select된 데이타
*/
@WhereExpr nvarchar(256)
AS
SET NOCOUNT ON
DECLARE @SQLCMD nvarchar(512)
SET @SQLCMD = N'SELECT nLogNo, dDate, nCharNo, nType, sMap, nMapX, nMapY, nMapZ, nTargetCharNo, nTargetID, nItemKey, nInt1, nInt2, nInt3, nBigint1 FROM tGameLog WHERE ' + @WhereExpr
EXEC sp_executesql @SQLCMD
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_GetCount]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_GetCount]
GO
/****** 개체: 저장 프로시저 dbo.p_GameLog_GetCount    스크립트 날짜: 2007-03-13 오후 6:26:53 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_GetCount    스크립트 날짜: 2005-05-30 오후 4:04:11 ******/
/****** 개체: 저장 프로시저 dbo.p_GameLog_GetCount    스크립트 날짜: 2005-01-28 오후 7:39:26 ******/
CREATE PROCEDURE [dbo].[p_GameLog_GetCount]
/*
  GameLog Get Count - 주어진 조건에 맞는 로그를 모두검색해서 얻는다.
  input:
   - 주어진 조건절
  output:
   - @Count = 해당 조건에 만족하는 레코드수
*/
@WhereExpr nvarchar(256),
@Count int OUTPUT
AS
SET NOCOUNT ON
DECLARE @SQLCMD nvarchar(512)
SET @SQLCMD = N'SELECT @RowCount = COUNT(*) FROM tGameLog WHERE ' + @WhereExpr
EXEC sp_executesql @SQLCMD, N'@RowCount AS int OUTPUT', @RowCount = @Count OUTPUT
-- end

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_GetLog]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_GetLog]
GO
/****** 개체: 저장 프로시저 dbo.p_GameLog_GetLog    스크립트 날짜: 2007-03-13 오후 6:26:53 ******/
/*
'--------------------------------------------------------------------------------------
' 함수명 : p_GameLog_GetLog
' 내  용 : OPTool 에서 사용. OPTool에서 입력한 쿼리문에 맞는 데이터 서치.
' 작성자 : 이병기
' 작성일 : 2005년 11월 15일
' 버  젼 : 1.0
' 인  자 :
'			input Parameter
'				@QueryExpr		: OPTool 에서 입력한 쿼리문
'			Output Parameter
'				
'			RETURN_VALUE
'
'--------------------------------------------------------------------------------------
*/
CREATE PROCEDURE [dbo].[p_GameLog_GetLog]
	@QueryExpr nvarchar(256)
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @SQLCMD nvarchar(512)
	SET @SQLCMD = N'SELECT a.nLogNo, a.dDate, a.nCharNo, a.nType, a.sMap, a.nMapX, a.nMapY, a.nTargetCharNo, a.nTargetID, a.nItemKey, a.nInt1, a.nInt2, a.nInt3, a.nBigint1, b.sID
			  FROM tGameLog a INNER JOIN [W00CHAR].World00_Character.dbo.tCharacter b ON a.nCharNo = b.nCharNo ' + @QueryExpr
	EXEC sp_executesql @SQLCMD
	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[p_GameLog_GetLogCount]
-- ----------------------------
DROP PROCEDURE [dbo].[p_GameLog_GetLogCount]
GO
/****** 개체: 저장 프로시저 dbo.p_GameLog_GetLogCount    스크립트 날짜: 2007-03-13 오후 6:26:53 ******/
/*
'--------------------------------------------------------------------------------------
' 함수명 : p_GameLog_GetLogCount
' 내  용 : OPTool 에서 사용. OPTool에서 입력한 쿼리문에 맞는 데이터 서치.
' 작성자 : 이병기
' 작성일 : 2005년 11월 15일
' 버  젼 : 1.0
' 인  자 :
'			input Parameter
'				@QueryExpr		: OPTool 에서 입력한 쿼리문
'			Output Parameter
'				@Count			: 서치된 데이터의 개수
'			RETURN_VALUE
'
'--------------------------------------------------------------------------------------
*/
CREATE PROCEDURE [dbo].[p_GameLog_GetLogCount]
	@QueryExpr nvarchar(256),
	@Count int OUTPUT
	
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @SQLCMD nvarchar(512)
	SET @SQLCMD = N'SELECT @RowCount = COUNT(*)
			  FROM tGameLog a INNER JOIN [W00CHAR].World00_Character.dbo.tCharacter b ON a.nCharNo = b.nCharNo ' + @QueryExpr
	EXEC sp_executesql @SQLCMD, N'@RowCount AS int OUTPUT', @RowCount = @Count OUTPUT
	SET NOCOUNT OFF
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Character_getSingleOption]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Character_getSingleOption]
GO
/*--------------------------------------------------------------------------------------
' 이  름 : usp_Character_getSingleOption
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2010.10.18.
'   캐릭터의 단일컬럼 옵션값들을 가져옴
'	새로운 컨덴츠 추가시 단일컬럼으로 된 옵션값을 가질 경우 tCharacterSingleOption
'	테이블에 추가후 값을 가져오는 프로시저는 이 프로시저로 통일함.
' Parameter :
'	input Parameter
'		@nCharNo      : 캐릭터번호
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-3092 : db error (insert)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Character_getSingleOption]
	@nCharNo      int
,	@nRet         int = 0 output
AS
BEGIN
	SET NOCOUNT ON
	SET LOCK_TIMEOUT 5000 
	
	SET @nRet = 0

	IF NOT EXISTS(SELECT nCharNo FROM tCharacterSingleOption WHERE nCharNo = @nCharNo) BEGIN
		INSERT INTO tCharacterSingleOption (nCharNo)
		VALUES (@nCharNo)
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -3192
			RETURN
		END
	END

	SELECT bMysteryBolt
		,  bAutoPick 
		,  dRestExpLastExecuteTime 
	  FROM tCharacterSingleOption 
	 WHERE nCharNo = @nCharNo 		
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Character_setAutoPick]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Character_setAutoPick]
GO
/*--------------------------------------------------------------------------------------
' 이  름 : usp_Character_setAutoPick
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2010.10.18.
' Description :
'   자동줍기 옵션 설정값 저장
'	GET의 경우 전체를 억세스하지만 개별 옵션들은 별도로 각각 저장한다.
'	각각의 저장시점이 다르므로 통합하여 한번에 저장하지 않는다.
'	저장 실패시 게임상 로그만 남기고 프로그램은 종료하지 않는다.
' Parameter :
'	input Parameter
'		@nCharNo   : 캐릭터번호
'		@bAutoPick : 자동줍기 설정값(0:false/1:true)
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-3092 : db error (insert)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Character_setAutoPick]
	@nCharNo   int
,	@bAutoPick bit
,	@nRet      int = 0 output
AS
BEGIN
	SET NOCOUNT ON
	SET LOCK_TIMEOUT 5000 
	
	SET @nRet = 0

	IF NOT EXISTS(SELECT nCharNo FROM tCharacterSingleOption WHERE nCharNo = @nCharNo) BEGIN
		INSERT INTO tCharacterSingleOption (nCharNo, bAutoPick)
		VALUES (@nCharNo, @bAutoPick)
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -3192
			RETURN
		END		
	END
	ELSE BEGIN
		UPDATE tCharacterSingleOption 
		   SET bAutoPick = @bAutoPick 
		 WHERE nCharNo = @nCharNo
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -3193
			RETURN
		END		
	END
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Character_setMysteryBolt]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Character_setMysteryBolt]
GO
/*--------------------------------------------------------------------------------------
' 이  름 : usp_Character_setMysteryBolt
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2010.10.18.
' Description :
'   미스테리 볼트 UI설정 옵션값을 저장함.
'	GET의 경우 전체를 억세스하지만 개별 옵션들은 별도로 각각 저장한다.
'	각각의 저장시점이 다르므로 통합하여 한번에 저장하지 않는다.
'	저장 실패시 게임상 로그만 남기고 프로그램은 종료하지 않는다.
' Parameter :
'	input Parameter
'		@nCharNo      : 캐릭터번호
'		@bMysteryBolt : 미스테리 볼트 UI 설정값(0:false/1:true)
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-3092 : db error (insert)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Character_setMysteryBolt]
	@nCharNo      int
,	@bMysteryBolt bit
,	@nRet         int = 0 output
AS
BEGIN
	SET NOCOUNT ON
	SET LOCK_TIMEOUT 5000 
	
	SET @nRet = 0

	IF NOT EXISTS(SELECT nCharNo FROM tCharacterSingleOption WHERE nCharNo = @nCharNo) BEGIN
		INSERT INTO tCharacterSingleOption (nCharNo, bMysteryBolt)
		VALUES (@nCharNo, @bMysteryBolt)
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -3192
			RETURN
		END		
	END
	ELSE BEGIN
		UPDATE tCharacterSingleOption 
		   SET bMysteryBolt = @bMysteryBolt 
		 WHERE nCharNo = @nCharNo
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -3193
			RETURN
		END		
	END
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Character_setRestExpExecTime]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Character_setRestExpExecTime]
GO
/*--------------------------------------------------------------------------------------
' 이  름 : usp_Character_setRestExpExecTime
' 작성자 : Ko Dong Gyun(kodong@gmail.com)
' 작성일 : 2010.10.18.
' Description :
'   휴식경험치 계산을 위한 마지막 시간 저장
'	GET의 경우 전체를 억세스하지만 개별 옵션들은 별도로 각각 저장한다.
'	각각의 저장시점이 다르므로 통합하여 한번에 저장하지 않는다.
'	저장 실패시 게임상 로그만 남기고 프로그램은 종료하지 않는다.
' Parameter :
'	input Parameter
'		@nCharNo : 캐릭터번호
'	output Parameter
'		@nRet	 : check SQL execute(valid/invalid)
'			= 0	 : works ok
'			< 0	 : error
'				-3092 : db error (insert)
'-------------------------------------------------------------------------------------*/
CREATE PROCEDURE [dbo].[usp_Character_setRestExpExecTime]
	@nCharNo   int
,	@nRet      int = 0 output
AS
BEGIN
	SET NOCOUNT ON
	SET LOCK_TIMEOUT 5000 
	
	SET @nRet = 0

	IF NOT EXISTS(SELECT nCharNo FROM tCharacterSingleOption WHERE nCharNo = @nCharNo) BEGIN
		INSERT INTO tCharacterSingleOption (nCharNo)
		VALUES (@nCharNo)
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -3192
			RETURN
		END		
	END
	ELSE BEGIN
		UPDATE tCharacterSingleOption 
		   SET dRestExpLastExecuteTime = GETDATE() 
		 WHERE nCharNo = @nCharNo
		IF @@ERROR <> 0 BEGIN
			SET @nRet = -3193
			RETURN
		END		
	END
END

GO

-- ----------------------------
-- Procedure structure for [dbo].[usp_Rank_setQuest]
-- ----------------------------
DROP PROCEDURE [dbo].[usp_Rank_setQuest]
GO
CREATE PROCEDURE [dbo].[usp_Rank_setQuest]
AS
BEGIN
	IF OBJECT_ID (N'tQuestRank',N'U') IS NOT NULL
		DROP TABLE tQuestRank;

	SELECT nCharNo, count(nType)as cnt
	  INTO tQuestRank
	  FROM tGameLog
	 WHERE nType = 281 -- reward_money
	   AND nInt1 = 20016
	   AND dDate >= '2010-04-12'
	 GROUP BY nCharNo
END

GO

-- ----------------------------
-- Indexes structure for table tCharacterSingleOption
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table [dbo].[tCharacterSingleOption]
-- ----------------------------
ALTER TABLE [dbo].[tCharacterSingleOption] ADD PRIMARY KEY ([nCharNo])
GO

-- ----------------------------
-- Indexes structure for table tGameLog
-- ----------------------------
CREATE INDEX [XIE1tGameLog_CharRegNum] ON [dbo].[tGameLog]
([nCharNo] ASC) 
GO
CREATE INDEX [XIE2tGameLog_DataType] ON [dbo].[tGameLog]
([nType] ASC) 
GO
CREATE INDEX [XIE3tGameLog_Date] ON [dbo].[tGameLog]
([dDate] ASC) 
GO
CREATE INDEX [XIE4tGameLog_ItemKey] ON [dbo].[tGameLog]
([nItemKey] ASC) 
GO
CREATE INDEX [XIE5tGameLog_TargetCharNo] ON [dbo].[tGameLog]
([nTargetCharNo] ASC) 
GO

-- ----------------------------
-- Primary Key structure for table [dbo].[tGameLog]
-- ----------------------------
ALTER TABLE [dbo].[tGameLog] ADD PRIMARY KEY ([nLogNo])
GO

-- ----------------------------
-- Indexes structure for table tLevelUpInfo
-- ----------------------------
CREATE CLUSTERED INDEX [cidx_nLevel_date] ON [dbo].[tLevelUpInfo]
([nLevel] DESC, [dLastUpdated] ASC) 
GO

-- ----------------------------
-- Primary Key structure for table [dbo].[tLevelUpInfo]
-- ----------------------------
ALTER TABLE [dbo].[tLevelUpInfo] ADD PRIMARY KEY NONCLUSTERED ([nCharNo])
GO
