﻿/// <summary>************************************************************************
/// Copyright (C) 2001, Patrick Charles and Jonas Lehmann                   *
/// Distributed under the Mozilla Public License                            *
/// http://www.mozilla.org/NPL/MPL-1.1.txt                                *
/// *************************************************************************
/// </summary>
namespace SharpPcap.Packets
{
    /// <summary> IP port utility class.
    /// 
    /// </summary>
    public class IPPort : IPPorts
    {
        /// <summary> Fetch a well-known IP port description.</summary>
        /// <param name="port">the port associated with the description.
        /// </param>
        /// <returns> a description of the ip port.
        /// </returns>
        public static System.String getDescription(int port)
        {
            System.Int32 c = (System.Int32) port;
            if (descriptions.ContainsKey(c))
            {
                //UPGRADE_TODO: Method 'java.util.HashMap.get' was converted to 'System.Collections.Hashtable.Item' which has a different behavior. "ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?index='!DefaultContextWindowIndex'&keyword='jlca1073_javautilHashMapget_javalangObject'"
                return (System.String) descriptions[c];
            }
            else if (port >= IPPorts.X11_BEGIN && port <= IPPorts.X11_END)
            {
                //UPGRADE_TODO: Method 'java.util.HashMap.get' was converted to 'System.Collections.Hashtable.Item' which has a different behavior. "ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?index='!DefaultContextWindowIndex'&keyword='jlca1073_javautilHashMapget_javalangObject'"
                return (System.String) descriptions[(System.Int32) IPPorts.X11];
            }
            else
                return UNKNOWN;
        }
        
        /// <summary> Fetch a well-known IP port name.</summary>
        /// <param name="port">the port associated with the name.
        /// </param>
        /// <returns> the name of the ip port.
        /// </returns>
        public static System.String getName(int port)
        {
            System.Int32 c = (System.Int32) port;
            if (names.ContainsKey(c))
            {
                //UPGRADE_TODO: Method 'java.util.HashMap.get' was converted to 'System.Collections.Hashtable.Item' which has a different behavior. "ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?index='!DefaultContextWindowIndex'&keyword='jlca1073_javautilHashMapget_javalangObject'"
                return (System.String) names[c];
            }
            else if (port >= IPPorts.X11_BEGIN && port <= IPPorts.X11_END)
            {
                //UPGRADE_TODO: Method 'java.util.HashMap.get' was converted to 'System.Collections.Hashtable.Item' which has a different behavior. "ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?index='!DefaultContextWindowIndex'&keyword='jlca1073_javautilHashMapget_javalangObject'"
                return (System.String) names[(System.Int32) IPPorts.X11];
            }
            else
                return c.ToString();
        }
        
        /// <summary> 'Human-readable' IP port descriptions.</summary>
        //UPGRADE_TODO: Class 'java.util.HashMap' was converted to 'System.Collections.Hashtable' which has a different behavior. "ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?index='!DefaultContextWindowIndex'&keyword='jlca1073_javautilHashMap'"
        private static System.Collections.Hashtable descriptions = new System.Collections.Hashtable();
        
        /// <summary> 'Human-readable' TCP port names.</summary>
        //UPGRADE_TODO: Class 'java.util.HashMap' was converted to 'System.Collections.Hashtable' which has a different behavior. "ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?index='!DefaultContextWindowIndex'&keyword='jlca1073_javautilHashMap'"
        private static System.Collections.Hashtable names = new System.Collections.Hashtable();
        
        
        public static System.String UNKNOWN = "unknown";
        
        static IPPort()
        {
            {
                // todo: descriptions aren't descriptions
                descriptions[(System.Int32) IPPorts.NONE] = "no port specified";
                descriptions[(System.Int32) IPPorts.RESERVED_0] = "port 0 is reserved!";
                descriptions[(System.Int32) IPPorts.TCPMUX] = "tcpmux";
                descriptions[(System.Int32) IPPorts.COMPRESSNET2] = "compressnet2";
                descriptions[(System.Int32) IPPorts.COMPRESSNET] = "compressnet";
                descriptions[(System.Int32) IPPorts.RJE] = "rje";
                descriptions[(System.Int32) IPPorts.ECHO] = "echo";
                descriptions[(System.Int32) IPPorts.DISCARD] = "discard";
                descriptions[(System.Int32) IPPorts.SYSTAT] = "systat";
                descriptions[(System.Int32) IPPorts.DAYTIME] = "daytime";
                descriptions[(System.Int32) IPPorts.QOTD] = "qotd";
                descriptions[(System.Int32) IPPorts.MSP] = "msp";
                descriptions[(System.Int32) IPPorts.CHARGEN] = "chargen";
                descriptions[(System.Int32) IPPorts.FTP_DATA] = "ftp_data";
                descriptions[(System.Int32) IPPorts.FTP] = "file transfer protocol";
                descriptions[(System.Int32) IPPorts.SSH] = "secure shell protocol";
                descriptions[(System.Int32) IPPorts.TELNET] = "remote terminal protocol";
                descriptions[(System.Int32) IPPorts.PRIV_MAIL] = "priv_mail";
                descriptions[(System.Int32) IPPorts.SMTP] = "simple mail xfer protocol";
                descriptions[(System.Int32) IPPorts.NSW_FE] = "nsw_fe";
                descriptions[(System.Int32) IPPorts.MSG_ICP] = "msg_icp";
                descriptions[(System.Int32) IPPorts.MSG_AUTH] = "msg_auth";
                descriptions[(System.Int32) IPPorts.DSP] = "dsp";
                descriptions[(System.Int32) IPPorts.PRIV_PRINT] = "priv_print";
                descriptions[(System.Int32) IPPorts.TIME] = "time";
                descriptions[(System.Int32) IPPorts.RAP] = "rap";
                descriptions[(System.Int32) IPPorts.RLP] = "rlp";
                descriptions[(System.Int32) IPPorts.GRAPHICS] = "graphics";
                descriptions[(System.Int32) IPPorts.NAME] = "name";
                descriptions[(System.Int32) IPPorts.NAMESERVER] = "nameserver";
                descriptions[(System.Int32) IPPorts.NICNAME] = "nicname";
                descriptions[(System.Int32) IPPorts.MPM_FLAGS] = "mpm_flags";
                descriptions[(System.Int32) IPPorts.MPM] = "mpm";
                descriptions[(System.Int32) IPPorts.MPM_SND] = "mpm_snd";
                descriptions[(System.Int32) IPPorts.NI_FTP] = "ni_ftp";
                descriptions[(System.Int32) IPPorts.AUDITD] = "auditd";
                descriptions[(System.Int32) IPPorts.TACACS] = "tacacs";
                descriptions[(System.Int32) IPPorts.RE_MAIL_CK] = "re_mail_ck";
                descriptions[(System.Int32) IPPorts.LA_MAINT] = "la_maint";
                descriptions[(System.Int32) IPPorts.XNS_TIME] = "xns_time";
                descriptions[(System.Int32) IPPorts.DOMAIN] = "domain";
                descriptions[(System.Int32) IPPorts.XNS_CH] = "xns_ch";
                descriptions[(System.Int32) IPPorts.ISI_GL] = "isi_gl";
                descriptions[(System.Int32) IPPorts.XNS_AUTH] = "xns_auth";
                descriptions[(System.Int32) IPPorts.PRIV_TERMINAL] = "priv_terminal";
                descriptions[(System.Int32) IPPorts.XNS_MAIL] = "xns_mail";
                descriptions[(System.Int32) IPPorts.PRIV_FILE] = "priv_file";
                descriptions[(System.Int32) IPPorts.NI_MAIL] = "ni_mail";
                descriptions[(System.Int32) IPPorts.ACAS] = "acas";
                descriptions[(System.Int32) IPPorts.WHOIS] = "whois++";
                descriptions[(System.Int32) IPPorts.COVIA] = "covia";
                descriptions[(System.Int32) IPPorts.TACACS_DS] = "tacacs_ds";
                descriptions[(System.Int32) IPPorts.SQLSNET] = "sql*net";
                descriptions[(System.Int32) IPPorts.BOOTPS] = "bootps";
                descriptions[(System.Int32) IPPorts.BOOTPC] = "bootpc";
                descriptions[(System.Int32) IPPorts.TFTP] = "tftp";
                descriptions[(System.Int32) IPPorts.GOPHER] = "gopher";
                descriptions[(System.Int32) IPPorts.NETRJS_1] = "netrjs_1";
                descriptions[(System.Int32) IPPorts.NETRJS_2] = "netrjs_2";
                descriptions[(System.Int32) IPPorts.NETRJS_3] = "netrjs_3";
                descriptions[(System.Int32) IPPorts.NETRJS_4] = "netrjs_4";
                descriptions[(System.Int32) IPPorts.PRIV_DIALOUT] = "priv_dialout";
                descriptions[(System.Int32) IPPorts.DEOS] = "deos";
                descriptions[(System.Int32) IPPorts.PRIV_RJE] = "priv_rje";
                descriptions[(System.Int32) IPPorts.VETTCP] = "vettcp";
                descriptions[(System.Int32) IPPorts.FINGER] = "finger";
                descriptions[(System.Int32) IPPorts.HTTP] = "http";
                descriptions[(System.Int32) IPPorts.WWW] = "www";
                descriptions[(System.Int32) IPPorts.HOSTS2_NS] = "hosts2_ns";
                descriptions[(System.Int32) IPPorts.XFER] = "xfer";
                descriptions[(System.Int32) IPPorts.MIT_ML_DEV] = "mit_ml_dev";
                descriptions[(System.Int32) IPPorts.CTF] = "ctf";
                descriptions[(System.Int32) IPPorts.MIT_ML_DEV2] = "mit_ml_dev";
                descriptions[(System.Int32) IPPorts.MFCOBOL] = "mfcobol";
                descriptions[(System.Int32) IPPorts.PRIV_TERMLINK] = "priv_termlink";
                descriptions[(System.Int32) IPPorts.KERBEROS] = "kerberos";
                descriptions[(System.Int32) IPPorts.SU_MIT_TG] = "su_mit_tg";
                descriptions[(System.Int32) IPPorts.DNSIX] = "dnsix";
                descriptions[(System.Int32) IPPorts.MIT_DOV] = "mit_dov";
                descriptions[(System.Int32) IPPorts.NPP] = "npp";
                descriptions[(System.Int32) IPPorts.DCP] = "dcp";
                descriptions[(System.Int32) IPPorts.OBJCALL] = "objcall";
                descriptions[(System.Int32) IPPorts.SUPDUP] = "supdup";
                descriptions[(System.Int32) IPPorts.DIXIE] = "dixie";
                descriptions[(System.Int32) IPPorts.SWIFT_RVF] = "swift_rvf";
                descriptions[(System.Int32) IPPorts.TACNEWS] = "tacnews";
                descriptions[(System.Int32) IPPorts.METAGRAM] = "metagram";
                descriptions[(System.Int32) IPPorts.NEWACCT] = "newacct";
                descriptions[(System.Int32) IPPorts.HOSTNAME] = "hostname";
                descriptions[(System.Int32) IPPorts.ISO_TSAP] = "iso_tsap";
                descriptions[(System.Int32) IPPorts.GPPITNP] = "gppitnp";
                descriptions[(System.Int32) IPPorts.ACR_NEMA] = "acr_nema";
                descriptions[(System.Int32) IPPorts.CSO] = "cso";
                descriptions[(System.Int32) IPPorts.CSNET_NS] = "csnet_ns";
                descriptions[(System.Int32) IPPorts.TSMUX_3COM] = "3com_tsmux";
                descriptions[(System.Int32) IPPorts.RTELNET] = "rtelnet";
                descriptions[(System.Int32) IPPorts.SNAGAS] = "snagas";
                descriptions[(System.Int32) IPPorts.POP2] = "pop2";
                descriptions[(System.Int32) IPPorts.POP3] = "pop3";
                descriptions[(System.Int32) IPPorts.SUNRPC] = "sunrpc";
                descriptions[(System.Int32) IPPorts.MCIDAS] = "mcidas";
                descriptions[(System.Int32) IPPorts.IDENT] = "ident";
                descriptions[(System.Int32) IPPorts.AUTH] = "auth";
                descriptions[(System.Int32) IPPorts.AUDIONEWS] = "audionews";
                descriptions[(System.Int32) IPPorts.SFTP] = "sftp";
                descriptions[(System.Int32) IPPorts.ANSANOTIFY] = "ansanotify";
                descriptions[(System.Int32) IPPorts.UUCP_PATH] = "uucp_path";
                descriptions[(System.Int32) IPPorts.SQLSERV] = "sqlserv";
                descriptions[(System.Int32) IPPorts.NNTP] = "nntp";
                descriptions[(System.Int32) IPPorts.CFDPTKT] = "cfdptkt";
                descriptions[(System.Int32) IPPorts.ERPC] = "erpc";
                descriptions[(System.Int32) IPPorts.SMAKYNET] = "smakynet";
                descriptions[(System.Int32) IPPorts.NTP] = "ntp";
                descriptions[(System.Int32) IPPorts.ANSATRADER] = "ansatrader";
                descriptions[(System.Int32) IPPorts.LOCUS_MAP] = "locus_map";
                descriptions[(System.Int32) IPPorts.NXEDIT] = "nxedit";
                descriptions[(System.Int32) IPPorts.LOCUS_CON] = "locus_con";
                descriptions[(System.Int32) IPPorts.GSS_XLICEN] = "gss_xlicen";
                descriptions[(System.Int32) IPPorts.PWDGEN] = "pwdgen";
                descriptions[(System.Int32) IPPorts.CISCO_FNA] = "cisco_fna";
                descriptions[(System.Int32) IPPorts.CISCO_TNA] = "cisco_tna";
                descriptions[(System.Int32) IPPorts.CISCO_SYS] = "cisco_sys";
                descriptions[(System.Int32) IPPorts.STATSRV] = "statsrv";
                descriptions[(System.Int32) IPPorts.INGRES_NET] = "ingres_net";
                descriptions[(System.Int32) IPPorts.EPMAP] = "epmap";
                descriptions[(System.Int32) IPPorts.PROFILE] = "profile";
                descriptions[(System.Int32) IPPorts.NETBIOS_NS] = "netbios_ns";
                descriptions[(System.Int32) IPPorts.NETBIOS_DGM] = "netbios_dgm";
                descriptions[(System.Int32) IPPorts.NETBIOS_SSN] = "netbios_ssn";
                descriptions[(System.Int32) IPPorts.EMFIS_DATA] = "emfis_data";
                descriptions[(System.Int32) IPPorts.EMFIS_CNTL] = "emfis_cntl";
                descriptions[(System.Int32) IPPorts.BL_IDM] = "bl_idm";
                descriptions[(System.Int32) IPPorts.IMAP] = "imap";
                descriptions[(System.Int32) IPPorts.UMA] = "uma";
                descriptions[(System.Int32) IPPorts.UAAC] = "uaac";
                descriptions[(System.Int32) IPPorts.ISO_TP0] = "iso_tp0";
                descriptions[(System.Int32) IPPorts.ISO_IP] = "iso_ip";
                descriptions[(System.Int32) IPPorts.JARGON] = "jargon";
                descriptions[(System.Int32) IPPorts.AED_512] = "aed_512";
                descriptions[(System.Int32) IPPorts.SQL_NET] = "sql_net";
                descriptions[(System.Int32) IPPorts.HEMS] = "hems";
                descriptions[(System.Int32) IPPorts.BFTP] = "bftp";
                descriptions[(System.Int32) IPPorts.SGMP] = "sgmp";
                descriptions[(System.Int32) IPPorts.NETSC_PROD] = "netsc_prod";
                descriptions[(System.Int32) IPPorts.NETSC_DEV] = "netsc_dev";
                descriptions[(System.Int32) IPPorts.SQLSRV] = "sqlsrv";
                descriptions[(System.Int32) IPPorts.KNET_CMP] = "knet_cmp";
                descriptions[(System.Int32) IPPorts.PCMAIL_SRV] = "pcmail_srv";
                descriptions[(System.Int32) IPPorts.NSS_ROUTING] = "nss_routing";
                descriptions[(System.Int32) IPPorts.SGMP_TRAPS] = "sgmp_traps";
                descriptions[(System.Int32) IPPorts.SNMP] = "snmp";
                descriptions[(System.Int32) IPPorts.SNMPTRAP] = "snmptrap";
                descriptions[(System.Int32) IPPorts.CMIP_MAN] = "cmip_man";
                descriptions[(System.Int32) IPPorts.CMIP_AGENT] = "cmip_agent";
                descriptions[(System.Int32) IPPorts.XNS_COURIER] = "xns_courier";
                descriptions[(System.Int32) IPPorts.S_NET] = "s_net";
                descriptions[(System.Int32) IPPorts.NAMP] = "namp";
                descriptions[(System.Int32) IPPorts.RSVD] = "rsvd";
                descriptions[(System.Int32) IPPorts.SEND] = "send";
                descriptions[(System.Int32) IPPorts.PRINT_SRV] = "print_srv";
                descriptions[(System.Int32) IPPorts.MULTIPLEX] = "multiplex";
                descriptions[(System.Int32) IPPorts.CL1] = "cl1";
                descriptions[(System.Int32) IPPorts.XYPLEX_MUX] = "xyplex_mux";
                descriptions[(System.Int32) IPPorts.MAILQ] = "mailq";
                descriptions[(System.Int32) IPPorts.VMNET] = "vmnet";
                descriptions[(System.Int32) IPPorts.GENRAD_MUX] = "genrad_mux";
                descriptions[(System.Int32) IPPorts.XDMCP] = "xdmcp";
                descriptions[(System.Int32) IPPorts.NEXTSTEP] = "nextstep";
                descriptions[(System.Int32) IPPorts.BGP] = "bgp";
                descriptions[(System.Int32) IPPorts.RIS] = "ris";
                descriptions[(System.Int32) IPPorts.UNIFY] = "unify";
                descriptions[(System.Int32) IPPorts.AUDIT] = "audit";
                descriptions[(System.Int32) IPPorts.OCBINDER] = "ocbinder";
                descriptions[(System.Int32) IPPorts.OCSERVER] = "ocserver";
                descriptions[(System.Int32) IPPorts.REMOTE_KIS] = "remote_kis";
                descriptions[(System.Int32) IPPorts.KIS] = "kis";
                descriptions[(System.Int32) IPPorts.ACI] = "aci";
                descriptions[(System.Int32) IPPorts.MUMPS] = "mumps";
                descriptions[(System.Int32) IPPorts.QFT] = "qft";
                descriptions[(System.Int32) IPPorts.GACP] = "gacp";
                descriptions[(System.Int32) IPPorts.PROSPERO] = "prospero";
                descriptions[(System.Int32) IPPorts.OSU_NMS] = "osu_nms";
                descriptions[(System.Int32) IPPorts.SRMP] = "srmp";
                descriptions[(System.Int32) IPPorts.IRC] = "irc";
                descriptions[(System.Int32) IPPorts.DN6_NLM_AUD] = "dn6_nlm_aud";
                descriptions[(System.Int32) IPPorts.DN6_SMM_RED] = "dn6_smm_red";
                descriptions[(System.Int32) IPPorts.DLS] = "dls";
                descriptions[(System.Int32) IPPorts.DLS_MON] = "dls_mon";
                descriptions[(System.Int32) IPPorts.SMUX] = "smux";
                descriptions[(System.Int32) IPPorts.SRC] = "src";
                descriptions[(System.Int32) IPPorts.AT_RTMP] = "at_rtmp";
                descriptions[(System.Int32) IPPorts.AT_NBP] = "at_nbp";
                descriptions[(System.Int32) IPPorts.AT_3] = "at_3";
                descriptions[(System.Int32) IPPorts.AT_ECHO] = "at_echo";
                descriptions[(System.Int32) IPPorts.AT_5] = "at_5";
                descriptions[(System.Int32) IPPorts.AT_ZIS] = "at_zis";
                descriptions[(System.Int32) IPPorts.AT_7] = "at_7";
                descriptions[(System.Int32) IPPorts.AT_8] = "at_8";
                descriptions[(System.Int32) IPPorts.QMTP] = "qmtp";
                descriptions[(System.Int32) IPPorts.Z39_50] = "z39.50";
                descriptions[(System.Int32) IPPorts.N914C] = "914c_g";
                descriptions[(System.Int32) IPPorts.ANET] = "anet";
                descriptions[(System.Int32) IPPorts.IPX] = "ipx";
                descriptions[(System.Int32) IPPorts.VMPWSCS] = "vmpwscs";
                descriptions[(System.Int32) IPPorts.SOFTPC] = "softpc";
                descriptions[(System.Int32) IPPorts.CAILIC] = "CAIlic";
                descriptions[(System.Int32) IPPorts.DBASE] = "dbase";
                descriptions[(System.Int32) IPPorts.MPP] = "mpp";
                descriptions[(System.Int32) IPPorts.UARPS] = "uarps";
                descriptions[(System.Int32) IPPorts.IMAP3] = "imap3";
                descriptions[(System.Int32) IPPorts.FLN_SPX] = "fln_spx";
                descriptions[(System.Int32) IPPorts.RSH_SPX] = "rsh_spx";
                descriptions[(System.Int32) IPPorts.CDC] = "cdc";
                descriptions[(System.Int32) IPPorts.MASQDIALER] = "masqdialer";
                descriptions[(System.Int32) IPPorts.DIRECT] = "direct";
                descriptions[(System.Int32) IPPorts.SUR_MEAS] = "sur_meas";
                descriptions[(System.Int32) IPPorts.INBUSINESS] = "inbusiness";
                descriptions[(System.Int32) IPPorts.LINK] = "link";
                descriptions[(System.Int32) IPPorts.DSP3270] = "dsp3270";
                descriptions[(System.Int32) IPPorts.SUBNTBCST_TFTP] = "subntbcst_tftp";
                descriptions[(System.Int32) IPPorts.BHFHS] = "bhfhs";
                descriptions[(System.Int32) IPPorts.RAP2] = "rap2";
                descriptions[(System.Int32) IPPorts.SET] = "set";
                descriptions[(System.Int32) IPPorts.YAK_CHAT] = "yak_chat";
                descriptions[(System.Int32) IPPorts.ESRO_GEN] = "esro_gen";
                descriptions[(System.Int32) IPPorts.OPENPORT] = "openport";
                descriptions[(System.Int32) IPPorts.NSIIOPS] = "nsiiops";
                descriptions[(System.Int32) IPPorts.ARCISDMS] = "arcisdms";
                descriptions[(System.Int32) IPPorts.HDAP] = "hdap";
                descriptions[(System.Int32) IPPorts.BGMP] = "bgmp";
                descriptions[(System.Int32) IPPorts.X_BONE_CTL] = "x_bone_ctl";
                descriptions[(System.Int32) IPPorts.SST] = "sst";
                descriptions[(System.Int32) IPPorts.TD_SERVICE] = "td_service";
                descriptions[(System.Int32) IPPorts.TD_REPLICA] = "td_replica";
                descriptions[(System.Int32) IPPorts.HTTP_MGMT] = "http_mgmt";
                descriptions[(System.Int32) IPPorts.PERSONAL_LINK] = "personal_link";
                descriptions[(System.Int32) IPPorts.CABLEPORT_AX] = "cableport_ax";
                descriptions[(System.Int32) IPPorts.RESCAP] = "rescap";
                descriptions[(System.Int32) IPPorts.CORERJD] = "corerjd";
                descriptions[(System.Int32) IPPorts.FXP_1] = "fxp_1";
                descriptions[(System.Int32) IPPorts.K_BLOCK] = "k_block";
                descriptions[(System.Int32) IPPorts.NOVASTORBAKCUP] = "novastorbakcup";
                descriptions[(System.Int32) IPPorts.ENTRUSTTIME] = "entrusttime";
                descriptions[(System.Int32) IPPorts.BHMDS] = "bhmds";
                descriptions[(System.Int32) IPPorts.ASIP_WEBADMIN] = "asip_webadmin";
                descriptions[(System.Int32) IPPorts.VSLMP] = "vslmp";
                descriptions[(System.Int32) IPPorts.MAGENTA_LOGIC] = "magenta_logic";
                descriptions[(System.Int32) IPPorts.OPALIS_ROBOT] = "opalis_robot";
                descriptions[(System.Int32) IPPorts.DPSI] = "dpsi";
                descriptions[(System.Int32) IPPorts.DECAUTH] = "decauth";
                descriptions[(System.Int32) IPPorts.ZANNET] = "zannet";
                descriptions[(System.Int32) IPPorts.PKIX_TIMESTAMP] = "pkix_timestamp";
                descriptions[(System.Int32) IPPorts.PTP_EVENT] = "ptp_event";
                descriptions[(System.Int32) IPPorts.PTP_GENERAL] = "ptp_general";
                descriptions[(System.Int32) IPPorts.PIP] = "pip";
                descriptions[(System.Int32) IPPorts.RTSPS] = "rtsps";
                descriptions[(System.Int32) IPPorts.TEXAR] = "texar";
                descriptions[(System.Int32) IPPorts.PDAP] = "pdap";
                descriptions[(System.Int32) IPPorts.PAWSERV] = "pawserv";
                descriptions[(System.Int32) IPPorts.ZSERV] = "zserv";
                descriptions[(System.Int32) IPPorts.FATSERV] = "fatserv";
                descriptions[(System.Int32) IPPorts.CSI_SGWP] = "csi_sgwp";
                descriptions[(System.Int32) IPPorts.MFTP] = "mftp";
                descriptions[(System.Int32) IPPorts.MATIP_TYPE_A] = "matip_type_a";
                descriptions[(System.Int32) IPPorts.MATIP_TYPE_B] = "matip_type_b";
                descriptions[(System.Int32) IPPorts.BHOETTY] = "bhoetty";
                descriptions[(System.Int32) IPPorts.DTAG_STE_SB] = "dtag_ste_sb";
                descriptions[(System.Int32) IPPorts.BHOEDAP4] = "bhoedap4";
                descriptions[(System.Int32) IPPorts.NDSAUTH] = "ndsauth";
                descriptions[(System.Int32) IPPorts.BH611] = "bh611";
                descriptions[(System.Int32) IPPorts.DATEX_ASN] = "datex_asn";
                descriptions[(System.Int32) IPPorts.CLOANTO_NET] = "cloanto_net";
                descriptions[(System.Int32) IPPorts.BHEVENT] = "bhevent";
                descriptions[(System.Int32) IPPorts.SHRINKWRAP] = "shrinkwrap";
                descriptions[(System.Int32) IPPorts.NSRMP] = "nsrmp";
                descriptions[(System.Int32) IPPorts.SCOI2ODIALOG] = "scoi2odialog";
                descriptions[(System.Int32) IPPorts.SEMANTIX] = "semantix";
                descriptions[(System.Int32) IPPorts.SRSSEND] = "srssend";
                descriptions[(System.Int32) IPPorts.RSVP_TUNNEL] = "rsvp_tunnel";
                descriptions[(System.Int32) IPPorts.AURORA_CMGR] = "aurora_cmgr";
                descriptions[(System.Int32) IPPorts.DTK] = "dtk";
                descriptions[(System.Int32) IPPorts.ODMR] = "odmr";
                descriptions[(System.Int32) IPPorts.MORTGAGEWARE] = "mortgageware";
                descriptions[(System.Int32) IPPorts.QBIKGDP] = "qbikgdp";
                descriptions[(System.Int32) IPPorts.RPC2PORTMAP] = "rpc2portmap";
                descriptions[(System.Int32) IPPorts.CODAAUTH] = "codaauth";
                descriptions[(System.Int32) IPPorts.CLEARCASE] = "clearcase";
                descriptions[(System.Int32) IPPorts.ULISTPROC] = "ulistproc";
                descriptions[(System.Int32) IPPorts.LEGENT_1] = "legent_1";
                descriptions[(System.Int32) IPPorts.LEGENT_2] = "legent_2";
                descriptions[(System.Int32) IPPorts.HASSLE] = "hassle";
                descriptions[(System.Int32) IPPorts.NIP] = "nip";
                descriptions[(System.Int32) IPPorts.TNETOS] = "tnETOS";
                descriptions[(System.Int32) IPPorts.DSETOS] = "dsETOS";
                descriptions[(System.Int32) IPPorts.IS99C] = "is99c";
                descriptions[(System.Int32) IPPorts.IS99S] = "is99s";
                descriptions[(System.Int32) IPPorts.HP_COLLECTOR] = "hp_collector";
                descriptions[(System.Int32) IPPorts.HP_MANAGED_NODE] = "hp_managed_node";
                descriptions[(System.Int32) IPPorts.HP_ALARM_MGR] = "hp_alarm_mgr";
                descriptions[(System.Int32) IPPorts.ARNS] = "arns";
                descriptions[(System.Int32) IPPorts.IBM_APP] = "ibm_app";
                descriptions[(System.Int32) IPPorts.ASA] = "asa";
                descriptions[(System.Int32) IPPorts.AURP] = "aurp";
                descriptions[(System.Int32) IPPorts.UNIDATA_LDM] = "unidata_ldm";
                descriptions[(System.Int32) IPPorts.UIS] = "uis";
                descriptions[(System.Int32) IPPorts.SYNOTICS_RELAY] = "synotics_relay";
                descriptions[(System.Int32) IPPorts.SYNOTICS_BROKER] = "synotics_broker";
                descriptions[(System.Int32) IPPorts.META5] = "meta5";
                descriptions[(System.Int32) IPPorts.EMBL_NDT] = "embl_ndt";
                descriptions[(System.Int32) IPPorts.NETCP] = "netcp";
                descriptions[(System.Int32) IPPorts.NETWARE_IP] = "netware_ip";
                descriptions[(System.Int32) IPPorts.MPTN] = "mptn";
                descriptions[(System.Int32) IPPorts.KRYPTOLAN] = "kryptolan";
                descriptions[(System.Int32) IPPorts.ISO_TSAP_C2] = "iso_tsap_c2";
                descriptions[(System.Int32) IPPorts.WORK_SOL] = "work_sol";
                descriptions[(System.Int32) IPPorts.UPS] = "ups";
                descriptions[(System.Int32) IPPorts.GENIE] = "genie";
                descriptions[(System.Int32) IPPorts.DECAP] = "decap";
                descriptions[(System.Int32) IPPorts.NCED] = "nced";
                descriptions[(System.Int32) IPPorts.NCLD] = "ncld";
                descriptions[(System.Int32) IPPorts.IMSP] = "imsp";
                descriptions[(System.Int32) IPPorts.TIMBUKTU] = "timbuktu";
                descriptions[(System.Int32) IPPorts.PRM_SM] = "prm_sm";
                descriptions[(System.Int32) IPPorts.PRM_NM] = "prm_nm";
                descriptions[(System.Int32) IPPorts.DECLADEBUG] = "decladebug";
                descriptions[(System.Int32) IPPorts.RMT] = "rmt";
                descriptions[(System.Int32) IPPorts.SYNOPTICS_TRAP] = "synoptics_trap";
                descriptions[(System.Int32) IPPorts.SMSP] = "smsp";
                descriptions[(System.Int32) IPPorts.INFOSEEK] = "infoseek";
                descriptions[(System.Int32) IPPorts.BNET] = "bnet";
                descriptions[(System.Int32) IPPorts.SILVERPLATTER] = "silverplatter";
                descriptions[(System.Int32) IPPorts.ONMUX] = "onmux";
                descriptions[(System.Int32) IPPorts.HYPER_G] = "hyper_g";
                descriptions[(System.Int32) IPPorts.ARIEL1] = "ariel1";
                descriptions[(System.Int32) IPPorts.SMPTE] = "smpte";
                descriptions[(System.Int32) IPPorts.ARIEL2] = "ariel2";
                descriptions[(System.Int32) IPPorts.ARIEL3] = "ariel3";
                descriptions[(System.Int32) IPPorts.OPC_JOB_START] = "opc_job_start";
                descriptions[(System.Int32) IPPorts.OPC_JOB_TRACK] = "opc_job_track";
                descriptions[(System.Int32) IPPorts.ICAD_EL] = "icad_el";
                descriptions[(System.Int32) IPPorts.SMARTSDP] = "smartsdp";
                descriptions[(System.Int32) IPPorts.SVRLOC] = "svrloc";
                descriptions[(System.Int32) IPPorts.OCS_CMU] = "ocs_cmu";
                descriptions[(System.Int32) IPPorts.OCS_AMU] = "ocs_amu";
                descriptions[(System.Int32) IPPorts.UTMPSD] = "utmpsd";
                descriptions[(System.Int32) IPPorts.UTMPCD] = "utmpcd";
                descriptions[(System.Int32) IPPorts.IASD] = "iasd";
                descriptions[(System.Int32) IPPorts.NNSP] = "nnsp";
                descriptions[(System.Int32) IPPorts.MOBILEIP_AGENT] = "mobileip_agent";
                descriptions[(System.Int32) IPPorts.MOBILIP_MN] = "mobilip_mn";
                descriptions[(System.Int32) IPPorts.DNA_CML] = "dna_cml";
                descriptions[(System.Int32) IPPorts.COMSCM] = "comscm";
                descriptions[(System.Int32) IPPorts.DSFGW] = "dsfgw";
                descriptions[(System.Int32) IPPorts.DASP] = "dasp";
                descriptions[(System.Int32) IPPorts.SGCP] = "sgcp";
                descriptions[(System.Int32) IPPorts.DECVMS_SYSMGT] = "decvms_sysmgt";
                descriptions[(System.Int32) IPPorts.CVC_HOSTD] = "cvc_hostd";
                descriptions[(System.Int32) IPPorts.HTTPS] = "https";
                descriptions[(System.Int32) IPPorts.SNPP] = "snpp";
                descriptions[(System.Int32) IPPorts.MICROSOFT_DS] = "microsoft_ds";
                descriptions[(System.Int32) IPPorts.DDM_RDB] = "ddm_rdb";
                descriptions[(System.Int32) IPPorts.DDM_DFM] = "ddm_dfm";
                descriptions[(System.Int32) IPPorts.DDM_SSL] = "ddm_ssl";
                descriptions[(System.Int32) IPPorts.AS_SERVERMAP] = "as_servermap";
                descriptions[(System.Int32) IPPorts.TSERVER] = "tserver";
                descriptions[(System.Int32) IPPorts.SFS_SMP_NET] = "sfs_smp_net";
                descriptions[(System.Int32) IPPorts.SFS_CONFIG] = "sfs_config";
                descriptions[(System.Int32) IPPorts.CREATIVESERVER] = "creativeserver";
                descriptions[(System.Int32) IPPorts.CONTENTSERVER] = "contentserver";
                descriptions[(System.Int32) IPPorts.CREATIVEPARTNR] = "creativepartnr";
                descriptions[(System.Int32) IPPorts.MACON_TCP] = "macon_tcp";
                descriptions[(System.Int32) IPPorts.SCOHELP] = "scohelp";
                descriptions[(System.Int32) IPPorts.APPLEQTC] = "appleqtc";
                descriptions[(System.Int32) IPPorts.AMPR_RCMD] = "ampr_rcmd";
                descriptions[(System.Int32) IPPorts.SKRONK] = "skronk";
                descriptions[(System.Int32) IPPorts.DATASURFSRV] = "datasurfsrv";
                descriptions[(System.Int32) IPPorts.DATASURFSRVSEC] = "datasurfsrvsec";
                descriptions[(System.Int32) IPPorts.ALPES] = "alpes";
                descriptions[(System.Int32) IPPorts.KPASSWD] = "kpasswd";
                descriptions[(System.Int32) IPPorts.DIGITAL_VRC] = "digital_vrc";
                descriptions[(System.Int32) IPPorts.MYLEX_MAPD] = "mylex_mapd";
                descriptions[(System.Int32) IPPorts.PHOTURIS] = "photuris";
                descriptions[(System.Int32) IPPorts.RCP] = "rcp";
                descriptions[(System.Int32) IPPorts.SCX_PROXY] = "scx_proxy";
                descriptions[(System.Int32) IPPorts.MONDEX] = "mondex";
                descriptions[(System.Int32) IPPorts.LJK_LOGIN] = "ljk_login";
                descriptions[(System.Int32) IPPorts.HYBRID_POP] = "hybrid_pop";
                descriptions[(System.Int32) IPPorts.TN_TL_W1] = "tn_tl_w1";
                descriptions[(System.Int32) IPPorts.TCPNETHASPSRV] = "tcpnethaspsrv";
                descriptions[(System.Int32) IPPorts.TN_TL_FD1] = "tn_tl_fd1";
                descriptions[(System.Int32) IPPorts.SS7NS] = "ss7ns";
                descriptions[(System.Int32) IPPorts.SPSC] = "spsc";
                descriptions[(System.Int32) IPPorts.IAFSERVER] = "iafserver";
                descriptions[(System.Int32) IPPorts.IAFDBASE] = "iafdbase";
                descriptions[(System.Int32) IPPorts.PH] = "ph";
                descriptions[(System.Int32) IPPorts.BGS_NSI] = "bgs_nsi";
                descriptions[(System.Int32) IPPorts.ULPNET] = "ulpnet";
                descriptions[(System.Int32) IPPorts.INTEGRA_SME] = "integra_sme";
                descriptions[(System.Int32) IPPorts.POWERBURST] = "powerburst";
                descriptions[(System.Int32) IPPorts.AVIAN] = "avian";
                descriptions[(System.Int32) IPPorts.SAFT] = "saft";
                descriptions[(System.Int32) IPPorts.GSS_HTTP] = "gss_http";
                descriptions[(System.Int32) IPPorts.NEST_PROTOCOL] = "nest_protocol";
                descriptions[(System.Int32) IPPorts.MICOM_PFS] = "micom_pfs";
                descriptions[(System.Int32) IPPorts.GO_LOGIN] = "go_login";
                descriptions[(System.Int32) IPPorts.TICF_1] = "ticf_1";
                descriptions[(System.Int32) IPPorts.TICF_2] = "ticf_2";
                descriptions[(System.Int32) IPPorts.POV_RAY] = "pov_ray";
                descriptions[(System.Int32) IPPorts.INTECOURIER] = "intecourier";
                descriptions[(System.Int32) IPPorts.PIM_RP_DISC] = "pim_rp_disc";
                descriptions[(System.Int32) IPPorts.DANTZ] = "dantz";
                descriptions[(System.Int32) IPPorts.SIAM] = "siam";
                descriptions[(System.Int32) IPPorts.ISO_ILL] = "iso_ill";
                descriptions[(System.Int32) IPPorts.ISAKMP] = "isakmp";
                descriptions[(System.Int32) IPPorts.STMF] = "stmf";
                descriptions[(System.Int32) IPPorts.ASA_APPL_PROTO] = "asa_appl_proto";
                descriptions[(System.Int32) IPPorts.INTRINSA] = "intrinsa";
                descriptions[(System.Int32) IPPorts.CITADEL] = "citadel";
                descriptions[(System.Int32) IPPorts.MAILBOX_LM] = "mailbox_lm";
                descriptions[(System.Int32) IPPorts.OHIMSRV] = "ohimsrv";
                descriptions[(System.Int32) IPPorts.CRS] = "crs";
                descriptions[(System.Int32) IPPorts.XVTTP] = "xvttp";
                descriptions[(System.Int32) IPPorts.SNARE] = "snare";
                descriptions[(System.Int32) IPPorts.FCP] = "fcp";
                descriptions[(System.Int32) IPPorts.PASSGO] = "passgo";
                descriptions[(System.Int32) IPPorts.EXEC] = "exec";
                descriptions[(System.Int32) IPPorts.LOGIN] = "login";
                descriptions[(System.Int32) IPPorts.SHELL] = "shell";
                descriptions[(System.Int32) IPPorts.PRINTER] = "printer";
                descriptions[(System.Int32) IPPorts.VIDEOTEX] = "videotex";
                descriptions[(System.Int32) IPPorts.TALK] = "talk";
                descriptions[(System.Int32) IPPorts.NTALK] = "ntalk";
                descriptions[(System.Int32) IPPorts.UTIME] = "utime";
                descriptions[(System.Int32) IPPorts.EFS] = "efs";
                descriptions[(System.Int32) IPPorts.RIPNG] = "ripng";
                descriptions[(System.Int32) IPPorts.ULP] = "ulp";
                descriptions[(System.Int32) IPPorts.IBM_DB2] = "ibm_db2";
                descriptions[(System.Int32) IPPorts.NCP] = "ncp";
                descriptions[(System.Int32) IPPorts.TIMED] = "timed";
                descriptions[(System.Int32) IPPorts.TEMPO] = "tempo";
                descriptions[(System.Int32) IPPorts.STX] = "stx";
                descriptions[(System.Int32) IPPorts.CUSTIX] = "custix";
                descriptions[(System.Int32) IPPorts.IRC_SERV] = "irc_serv";
                descriptions[(System.Int32) IPPorts.COURIER] = "courier";
                descriptions[(System.Int32) IPPorts.CONFERENCE] = "conference";
                descriptions[(System.Int32) IPPorts.NETNEWS] = "netnews";
                descriptions[(System.Int32) IPPorts.NETWALL] = "netwall";
                descriptions[(System.Int32) IPPorts.MM_ADMIN] = "mm_admin";
                descriptions[(System.Int32) IPPorts.IIOP] = "iiop";
                descriptions[(System.Int32) IPPorts.OPALIS_RDV] = "opalis_rdv";
                descriptions[(System.Int32) IPPorts.NMSP] = "nmsp";
                descriptions[(System.Int32) IPPorts.GDOMAP] = "gdomap";
                descriptions[(System.Int32) IPPorts.APERTUS_LDP] = "apertus_ldp";
                descriptions[(System.Int32) IPPorts.UUCP] = "uucp";
                descriptions[(System.Int32) IPPorts.UUCP_RLOGIN] = "uucp_rlogin";
                descriptions[(System.Int32) IPPorts.COMMERCE] = "commerce";
                descriptions[(System.Int32) IPPorts.KLOGIN] = "klogin";
                descriptions[(System.Int32) IPPorts.KSHELL] = "kshell";
                descriptions[(System.Int32) IPPorts.APPLEQTCSRVR] = "appleqtcsrvr";
                descriptions[(System.Int32) IPPorts.DHCPV6_CLIENT] = "dhcpv6_client";
                descriptions[(System.Int32) IPPorts.DHCPV6_SERVER] = "dhcpv6_server";
                descriptions[(System.Int32) IPPorts.AFPOVERTCP] = "afpovertcp";
                descriptions[(System.Int32) IPPorts.IDFP] = "idfp";
                descriptions[(System.Int32) IPPorts.NEW_RWHO] = "new_rwho";
                descriptions[(System.Int32) IPPorts.CYBERCASH] = "cybercash";
                descriptions[(System.Int32) IPPorts.DEVICESHARE] = "deviceshare";
                descriptions[(System.Int32) IPPorts.PIRP] = "pirp";
                descriptions[(System.Int32) IPPorts.RTSP] = "rtsp";
                descriptions[(System.Int32) IPPorts.DSF] = "dsf";
                descriptions[(System.Int32) IPPorts.REMOTEFS] = "remotefs";
                descriptions[(System.Int32) IPPorts.OPENVMS_SYSIPC] = "openvms_sysipc";
                descriptions[(System.Int32) IPPorts.SDNSKMP] = "sdnskmp";
                descriptions[(System.Int32) IPPorts.TEEDTAP] = "teedtap";
                descriptions[(System.Int32) IPPorts.RMONITOR] = "rmonitor";
                descriptions[(System.Int32) IPPorts.MONITOR] = "monitor";
                descriptions[(System.Int32) IPPorts.CHSHELL] = "chshell";
                descriptions[(System.Int32) IPPorts.NNTPS] = "nntps";
                descriptions[(System.Int32) IPPorts.N9PFS] = "9pfs";
                descriptions[(System.Int32) IPPorts.WHOAMI] = "whoami";
                descriptions[(System.Int32) IPPorts.STREETTALK] = "streettalk";
                descriptions[(System.Int32) IPPorts.BANYAN_RPC] = "banyan_rpc";
                descriptions[(System.Int32) IPPorts.MS_SHUTTLE] = "ms_shuttle";
                descriptions[(System.Int32) IPPorts.MS_ROME] = "ms_rome";
                descriptions[(System.Int32) IPPorts.METER] = "meter";
                descriptions[(System.Int32) IPPorts.METER2] = "meter2";
                descriptions[(System.Int32) IPPorts.SONAR] = "sonar";
                descriptions[(System.Int32) IPPorts.BANYAN_VIP] = "banyan_vip";
                descriptions[(System.Int32) IPPorts.FTP_AGENT] = "ftp_agent";
                descriptions[(System.Int32) IPPorts.VEMMI] = "vemmi";
                descriptions[(System.Int32) IPPorts.IPCD] = "ipcd";
                descriptions[(System.Int32) IPPorts.VNAS] = "vnas";
                descriptions[(System.Int32) IPPorts.IPDD] = "ipdd";
                descriptions[(System.Int32) IPPorts.DECBSRV] = "decbsrv";
                descriptions[(System.Int32) IPPorts.SNTP_HEARTBEAT] = "sntp_heartbeat";
                descriptions[(System.Int32) IPPorts.BDP] = "bdp";
                descriptions[(System.Int32) IPPorts.SCC_SECURITY] = "scc_security";
                descriptions[(System.Int32) IPPorts.PHILIPS_VC] = "philips_vc";
                descriptions[(System.Int32) IPPorts.KEYSERVER] = "keyserver";
                descriptions[(System.Int32) IPPorts.IMAP4_SSL] = "imap4_ssl";
                descriptions[(System.Int32) IPPorts.PASSWORD_CHG] = "password_chg";
                descriptions[(System.Int32) IPPorts.SUBMISSION] = "submission";
                descriptions[(System.Int32) IPPorts.CAL] = "cal";
                descriptions[(System.Int32) IPPorts.EYELINK] = "eyelink";
                descriptions[(System.Int32) IPPorts.TNS_CML] = "tns_cml";
                descriptions[(System.Int32) IPPorts.HTTP_ALT] = "http_alt";
                descriptions[(System.Int32) IPPorts.EUDORA_SET] = "eudora_set";
                descriptions[(System.Int32) IPPorts.HTTP_RPC_EPMAP] = "http_rpc_epmap";
                descriptions[(System.Int32) IPPorts.TPIP] = "tpip";
                descriptions[(System.Int32) IPPorts.CAB_PROTOCOL] = "cab_protocol";
                descriptions[(System.Int32) IPPorts.SMSD] = "smsd";
                descriptions[(System.Int32) IPPorts.PTCNAMESERVICE] = "ptcnameservice";
                descriptions[(System.Int32) IPPorts.SCO_WEBSRVRMG3] = "sco_websrvrmg3";
                descriptions[(System.Int32) IPPorts.ACP] = "acp";
                descriptions[(System.Int32) IPPorts.IPCSERVER] = "ipcserver";
                descriptions[(System.Int32) IPPorts.URM] = "urm";
                descriptions[(System.Int32) IPPorts.NQS] = "nqs";
                descriptions[(System.Int32) IPPorts.SIFT_UFT] = "sift_uft";
                descriptions[(System.Int32) IPPorts.NPMP_TRAP] = "npmp_trap";
                descriptions[(System.Int32) IPPorts.NPMP_LOCAL] = "npmp_local";
                descriptions[(System.Int32) IPPorts.NPMP_GUI] = "npmp_gui";
                descriptions[(System.Int32) IPPorts.HMMP_IND] = "hmmp_ind";
                descriptions[(System.Int32) IPPorts.HMMP_OP] = "hmmp_op";
                descriptions[(System.Int32) IPPorts.SSHELL] = "sshell";
                descriptions[(System.Int32) IPPorts.SCO_INETMGR] = "sco_inetmgr";
                descriptions[(System.Int32) IPPorts.SCO_SYSMGR] = "sco_sysmgr";
                descriptions[(System.Int32) IPPorts.SCO_DTMGR] = "sco_dtmgr";
                descriptions[(System.Int32) IPPorts.DEI_ICDA] = "dei_icda";
                descriptions[(System.Int32) IPPorts.DIGITAL_EVM] = "digital_evm";
                descriptions[(System.Int32) IPPorts.SCO_WEBSRVRMGR] = "sco_websrvrmgr";
                descriptions[(System.Int32) IPPorts.ESCP_IP] = "escp_ip";
                descriptions[(System.Int32) IPPorts.COLLABORATOR] = "collaborator";
                descriptions[(System.Int32) IPPorts.AUX_BUS_SHUNT] = "aux_bus_shunt";
                descriptions[(System.Int32) IPPorts.CRYPTOADMIN] = "cryptoadmin";
                descriptions[(System.Int32) IPPorts.DEC_DLM] = "dec_dlm";
                descriptions[(System.Int32) IPPorts.ASIA] = "asia";
                descriptions[(System.Int32) IPPorts.PASSGO_TIVOLI] = "passgo_tivoli";
                descriptions[(System.Int32) IPPorts.QMQP] = "qmqp";
                descriptions[(System.Int32) IPPorts.AMP3_3COM] = "3com_amp3";
                descriptions[(System.Int32) IPPorts.RDA] = "rda";
                descriptions[(System.Int32) IPPorts.IPP] = "ipp";
                descriptions[(System.Int32) IPPorts.BMPP] = "bmpp";
                descriptions[(System.Int32) IPPorts.SERVSTAT] = "servstat";
                descriptions[(System.Int32) IPPorts.GINAD] = "ginad";
                descriptions[(System.Int32) IPPorts.RLZDBASE] = "rlzdbase";
                descriptions[(System.Int32) IPPorts.LDAPS] = "ldaps";
                descriptions[(System.Int32) IPPorts.LANSERVER] = "lanserver";
                descriptions[(System.Int32) IPPorts.MCNS_SEC] = "mcns_sec";
                descriptions[(System.Int32) IPPorts.MSDP] = "msdp";
                descriptions[(System.Int32) IPPorts.ENTRUST_SPS] = "entrust_sps";
                descriptions[(System.Int32) IPPorts.REPCMD] = "repcmd";
                descriptions[(System.Int32) IPPorts.ESRO_EMSDP] = "esro_emsdp";
                descriptions[(System.Int32) IPPorts.SANITY] = "sanity";
                descriptions[(System.Int32) IPPorts.DWR] = "dwr";
                descriptions[(System.Int32) IPPorts.PSSC] = "pssc";
                descriptions[(System.Int32) IPPorts.LDP] = "ldp";
                descriptions[(System.Int32) IPPorts.DHCP_FAILOVER] = "dhcp_failover";
                descriptions[(System.Int32) IPPorts.RRP] = "rrp";
                descriptions[(System.Int32) IPPorts.AMINET] = "aminet";
                descriptions[(System.Int32) IPPorts.OBEX] = "obex";
                descriptions[(System.Int32) IPPorts.IEEE_MMS] = "ieee_mms";
                descriptions[(System.Int32) IPPorts.HELLO_PORT] = "hello_port";
                descriptions[(System.Int32) IPPorts.REPSCMD] = "repscmd";
                descriptions[(System.Int32) IPPorts.AODV] = "aodv";
                descriptions[(System.Int32) IPPorts.TINC] = "tinc";
                descriptions[(System.Int32) IPPorts.SPMP] = "spmp";
                descriptions[(System.Int32) IPPorts.RMC] = "rmc";
                descriptions[(System.Int32) IPPorts.TENFOLD] = "tenfold";
                descriptions[(System.Int32) IPPorts.URL_RENDEZVOUS] = "url_rendezvous";
                descriptions[(System.Int32) IPPorts.MAC_SRVR_ADMIN] = "mac_srvr_admin";
                descriptions[(System.Int32) IPPorts.HAP] = "hap";
                descriptions[(System.Int32) IPPorts.PFTP] = "pftp";
                descriptions[(System.Int32) IPPorts.PURENOISE] = "purenoise";
                descriptions[(System.Int32) IPPorts.SECURE_AUX_BUS] = "secure_aux_bus";
                descriptions[(System.Int32) IPPorts.SUN_DR] = "sun_dr";
                descriptions[(System.Int32) IPPorts.MDQS] = "mdqs";
                descriptions[(System.Int32) IPPorts.DOOM] = "doom";
                descriptions[(System.Int32) IPPorts.DISCLOSE] = "disclose";
                descriptions[(System.Int32) IPPorts.MECOMM] = "mecomm";
                descriptions[(System.Int32) IPPorts.MEREGISTER] = "meregister";
                descriptions[(System.Int32) IPPorts.VACDSM_SWS] = "vacdsm_sws";
                descriptions[(System.Int32) IPPorts.VACDSM_APP] = "vacdsm_app";
                descriptions[(System.Int32) IPPorts.VPPS_QUA] = "vpps_qua";
                descriptions[(System.Int32) IPPorts.CIMPLEX] = "cimplex";
                descriptions[(System.Int32) IPPorts.ACAP] = "acap";
                descriptions[(System.Int32) IPPorts.DCTP] = "dctp";
                descriptions[(System.Int32) IPPorts.VPPS_VIA] = "vpps_via";
                descriptions[(System.Int32) IPPorts.VPP] = "vpp";
                descriptions[(System.Int32) IPPorts.GGF_NCP] = "ggf_ncp";
                descriptions[(System.Int32) IPPorts.MRM] = "mrm";
                descriptions[(System.Int32) IPPorts.ENTRUST_AAAS] = "entrust_aaas";
                descriptions[(System.Int32) IPPorts.ENTRUST_AAMS] = "entrust_aams";
                descriptions[(System.Int32) IPPorts.XFR] = "xfr";
                descriptions[(System.Int32) IPPorts.CORBA_IIOP] = "corba_iiop";
                descriptions[(System.Int32) IPPorts.CORBA_IIOP_SSL] = "corba_iiop_ssl";
                descriptions[(System.Int32) IPPorts.MDC_PORTMAPPER] = "mdc_portmapper";
                descriptions[(System.Int32) IPPorts.HCP_WISMAR] = "hcp_wismar";
                descriptions[(System.Int32) IPPorts.ASIPREGISTRY] = "asipregistry";
                descriptions[(System.Int32) IPPorts.REALM_RUSD] = "realm_rusd";
                descriptions[(System.Int32) IPPorts.NMAP] = "nmap";
                descriptions[(System.Int32) IPPorts.VATP] = "vatp";
                descriptions[(System.Int32) IPPorts.MSEXCH_ROUTING] = "msexch_routing";
                descriptions[(System.Int32) IPPorts.HYPERWAVE_ISP] = "hyperwave_isp";
                descriptions[(System.Int32) IPPorts.CONNENDP] = "connendp";
                descriptions[(System.Int32) IPPorts.HA_CLUSTER] = "ha_cluster";
                descriptions[(System.Int32) IPPorts.IEEE_MMS_SSL] = "ieee_mms_ssl";
                descriptions[(System.Int32) IPPorts.RUSHD] = "rushd";
                descriptions[(System.Int32) IPPorts.UUIDGEN] = "uuidgen";
                descriptions[(System.Int32) IPPorts.OLSR] = "olsr";
                descriptions[(System.Int32) IPPorts.ACCESSNETWORK] = "accessnetwork";
                descriptions[(System.Int32) IPPorts.ELCSD] = "elcsd";
                descriptions[(System.Int32) IPPorts.AGENTX] = "agentx";
                descriptions[(System.Int32) IPPorts.SILC] = "silc";
                descriptions[(System.Int32) IPPorts.BORLAND_DSJ] = "borland_dsj";
                descriptions[(System.Int32) IPPorts.ENTRUST_KMSH] = "entrust_kmsh";
                descriptions[(System.Int32) IPPorts.ENTRUST_ASH] = "entrust_ash";
                descriptions[(System.Int32) IPPorts.CISCO_TDP] = "cisco_tdp";
                descriptions[(System.Int32) IPPorts.NETVIEWDM1] = "netviewdm1";
                descriptions[(System.Int32) IPPorts.NETVIEWDM2] = "netviewdm2";
                descriptions[(System.Int32) IPPorts.NETVIEWDM3] = "netviewdm3";
                descriptions[(System.Int32) IPPorts.NETGW] = "netgw";
                descriptions[(System.Int32) IPPorts.NETRCS] = "netrcs";
                descriptions[(System.Int32) IPPorts.FLEXLM] = "flexlm";
                descriptions[(System.Int32) IPPorts.FUJITSU_DEV] = "fujitsu_dev";
                descriptions[(System.Int32) IPPorts.RIS_CM] = "ris_cm";
                descriptions[(System.Int32) IPPorts.KERBEROS_ADM] = "kerberos_adm";
                descriptions[(System.Int32) IPPorts.RFILE] = "rfile";
                descriptions[(System.Int32) IPPorts.PUMP] = "pump";
                descriptions[(System.Int32) IPPorts.QRH] = "qrh";
                descriptions[(System.Int32) IPPorts.RRH] = "rrh";
                descriptions[(System.Int32) IPPorts.TELL] = "tell";
                descriptions[(System.Int32) IPPorts.NLOGIN] = "nlogin";
                descriptions[(System.Int32) IPPorts.CON] = "con";
                descriptions[(System.Int32) IPPorts.NS] = "ns";
                descriptions[(System.Int32) IPPorts.RXE] = "rxe";
                descriptions[(System.Int32) IPPorts.QUOTAD] = "quotad";
                descriptions[(System.Int32) IPPorts.CYCLESERV] = "cycleserv";
                descriptions[(System.Int32) IPPorts.OMSERV] = "omserv";
                descriptions[(System.Int32) IPPorts.WEBSTER] = "webster";
                descriptions[(System.Int32) IPPorts.PHONEBOOK] = "phonebook";
                descriptions[(System.Int32) IPPorts.VID] = "vid";
                descriptions[(System.Int32) IPPorts.CADLOCK] = "cadlock";
                descriptions[(System.Int32) IPPorts.RTIP] = "rtip";
                descriptions[(System.Int32) IPPorts.CYCLESERV2] = "cycleserv2";
                descriptions[(System.Int32) IPPorts.SUBMIT] = "submit";
                descriptions[(System.Int32) IPPorts.RPASSWD] = "rpasswd";
                descriptions[(System.Int32) IPPorts.ENTOMB] = "entomb";
                descriptions[(System.Int32) IPPorts.WPAGES] = "wpages";
                descriptions[(System.Int32) IPPorts.WPGS] = "wpgs";
                descriptions[(System.Int32) IPPorts.QSC] = "qsc";
                descriptions[(System.Int32) IPPorts.MDBS_DAEMON] = "mdbs_daemon";
                descriptions[(System.Int32) IPPorts.ITM_MCELL_S] = "itm_mcell_s";
                descriptions[(System.Int32) IPPorts.PKIX_3_CA_RA] = "pkix_3_ca_ra";
                descriptions[(System.Int32) IPPorts.DHCP_FAILOVER2] = "dhcp_failover2";
                descriptions[(System.Int32) IPPorts.RSYNC] = "rsync";
                descriptions[(System.Int32) IPPorts.ICLCNET_LOCATE] = "iclcnet_locate";
                descriptions[(System.Int32) IPPorts.ICLCNET_SVINFO] = "iclcnet_svinfo";
                descriptions[(System.Int32) IPPorts.ACCESSBUILDER] = "accessbuilder";
                descriptions[(System.Int32) IPPorts.CDDBP] = "cddbp";
                descriptions[(System.Int32) IPPorts.OMGINITIALREFS] = "omginitialrefs";
                descriptions[(System.Int32) IPPorts.SMPNAMERES] = "smpnameres";
                descriptions[(System.Int32) IPPorts.IDEAFARM_CHAT] = "ideafarm_chat";
                descriptions[(System.Int32) IPPorts.IDEAFARM_CATCH] = "ideafarm_catch";
                descriptions[(System.Int32) IPPorts.XACT_BACKUP] = "xact_backup";
                descriptions[(System.Int32) IPPorts.FTPS_DATA] = "ftps_data";
                descriptions[(System.Int32) IPPorts.FTPS] = "ftps";
                descriptions[(System.Int32) IPPorts.NAS] = "nas";
                descriptions[(System.Int32) IPPorts.TELNETS] = "telnets";
                descriptions[(System.Int32) IPPorts.IMAPS] = "imaps";
                descriptions[(System.Int32) IPPorts.IRCS] = "ircs";
                descriptions[(System.Int32) IPPorts.POP3S] = "pop3s";
                descriptions[(System.Int32) IPPorts.VSINET] = "vsinet";
                descriptions[(System.Int32) IPPorts.MAITRD] = "maitrd";
                descriptions[(System.Int32) IPPorts.BUSBOY] = "busboy";
                descriptions[(System.Int32) IPPorts.GARCON] = "garcon";
                descriptions[(System.Int32) IPPorts.PUPROUTER] = "puprouter";
                descriptions[(System.Int32) IPPorts.CADLOCK2] = "cadlock2";
                descriptions[(System.Int32) IPPorts.SURF] = "surf";
                descriptions[(System.Int32) IPPorts.RESERVED_1023] = "1023_RESERVED";
                descriptions[(System.Int32) IPPorts.RESERVED_1024] = "1024_RESERVED";
                descriptions[(System.Int32) IPPorts.SOCKS] = "socks";
                descriptions[(System.Int32) IPPorts.HSRP] = "hot standby router";
                descriptions[(System.Int32) IPPorts.AISES] = "aises";
                descriptions[(System.Int32) IPPorts.CVS] = "concurrent version system";
                descriptions[(System.Int32) IPPorts.X11] = "X-Windows";
                
                // todo: table is incomplete
            }
            {
                names[(System.Int32) IPPorts.NONE] = ".";
                names[(System.Int32) IPPorts.RESERVED_0] = "0r";
                names[(System.Int32) IPPorts.TCPMUX] = "tcpmux";
                names[(System.Int32) IPPorts.COMPRESSNET2] = "compressnet2";
                names[(System.Int32) IPPorts.COMPRESSNET] = "compressnet";
                names[(System.Int32) IPPorts.RJE] = "rje";
                names[(System.Int32) IPPorts.ECHO] = "echo";
                names[(System.Int32) IPPorts.DISCARD] = "discard";
                names[(System.Int32) IPPorts.SYSTAT] = "systat";
                names[(System.Int32) IPPorts.DAYTIME] = "daytime";
                names[(System.Int32) IPPorts.QOTD] = "qotd";
                names[(System.Int32) IPPorts.MSP] = "msp";
                names[(System.Int32) IPPorts.CHARGEN] = "chargen";
                names[(System.Int32) IPPorts.FTP_DATA] = "ftp_data";
                names[(System.Int32) IPPorts.FTP] = "ftp";
                names[(System.Int32) IPPorts.SSH] = "ssh";
                names[(System.Int32) IPPorts.TELNET] = "telnet";
                names[(System.Int32) IPPorts.PRIV_MAIL] = "priv_mail";
                names[(System.Int32) IPPorts.SMTP] = "smtp";
                names[(System.Int32) IPPorts.NSW_FE] = "nsw_fe";
                names[(System.Int32) IPPorts.MSG_ICP] = "msg_icp";
                names[(System.Int32) IPPorts.MSG_AUTH] = "msg_auth";
                names[(System.Int32) IPPorts.DSP] = "dsp";
                names[(System.Int32) IPPorts.PRIV_PRINT] = "priv_print";
                names[(System.Int32) IPPorts.TIME] = "time";
                names[(System.Int32) IPPorts.RAP] = "rap";
                names[(System.Int32) IPPorts.RLP] = "rlp";
                names[(System.Int32) IPPorts.GRAPHICS] = "graphics";
                names[(System.Int32) IPPorts.NAME] = "name";
                names[(System.Int32) IPPorts.NAMESERVER] = "nameserver";
                names[(System.Int32) IPPorts.NICNAME] = "nicname";
                names[(System.Int32) IPPorts.MPM_FLAGS] = "mpm_flags";
                names[(System.Int32) IPPorts.MPM] = "mpm";
                names[(System.Int32) IPPorts.MPM_SND] = "mpm_snd";
                names[(System.Int32) IPPorts.NI_FTP] = "ni_ftp";
                names[(System.Int32) IPPorts.AUDITD] = "auditd";
                names[(System.Int32) IPPorts.TACACS] = "tacacs";
                names[(System.Int32) IPPorts.RE_MAIL_CK] = "re_mail_ck";
                names[(System.Int32) IPPorts.LA_MAINT] = "la_maint";
                names[(System.Int32) IPPorts.XNS_TIME] = "xns_time";
                names[(System.Int32) IPPorts.DOMAIN] = "domain";
                names[(System.Int32) IPPorts.XNS_CH] = "xns_ch";
                names[(System.Int32) IPPorts.ISI_GL] = "isi_gl";
                names[(System.Int32) IPPorts.XNS_AUTH] = "xns_auth";
                names[(System.Int32) IPPorts.PRIV_TERMINAL] = "priv_terminal";
                names[(System.Int32) IPPorts.XNS_MAIL] = "xns_mail";
                names[(System.Int32) IPPorts.PRIV_FILE] = "priv_file";
                names[(System.Int32) IPPorts.NI_MAIL] = "ni_mail";
                names[(System.Int32) IPPorts.ACAS] = "acas";
                names[(System.Int32) IPPorts.WHOIS] = "whois++";
                names[(System.Int32) IPPorts.COVIA] = "covia";
                names[(System.Int32) IPPorts.TACACS_DS] = "tacacs_ds";
                names[(System.Int32) IPPorts.SQLSNET] = "sql*net";
                names[(System.Int32) IPPorts.BOOTPS] = "bootps";
                names[(System.Int32) IPPorts.BOOTPC] = "bootpc";
                names[(System.Int32) IPPorts.TFTP] = "tftp";
                names[(System.Int32) IPPorts.GOPHER] = "gopher";
                names[(System.Int32) IPPorts.NETRJS_1] = "netrjs_1";
                names[(System.Int32) IPPorts.NETRJS_2] = "netrjs_2";
                names[(System.Int32) IPPorts.NETRJS_3] = "netrjs_3";
                names[(System.Int32) IPPorts.NETRJS_4] = "netrjs_4";
                names[(System.Int32) IPPorts.PRIV_DIALOUT] = "priv_dialout";
                names[(System.Int32) IPPorts.DEOS] = "deos";
                names[(System.Int32) IPPorts.PRIV_RJE] = "priv_rje";
                names[(System.Int32) IPPorts.VETTCP] = "vettcp";
                names[(System.Int32) IPPorts.FINGER] = "finger";
                names[(System.Int32) IPPorts.HTTP] = "http";
                names[(System.Int32) IPPorts.WWW] = "www";
                names[(System.Int32) IPPorts.HOSTS2_NS] = "hosts2_ns";
                names[(System.Int32) IPPorts.XFER] = "xfer";
                names[(System.Int32) IPPorts.MIT_ML_DEV] = "mit_ml_dev";
                names[(System.Int32) IPPorts.CTF] = "ctf";
                names[(System.Int32) IPPorts.MIT_ML_DEV2] = "mit_ml_dev";
                names[(System.Int32) IPPorts.MFCOBOL] = "mfcobol";
                names[(System.Int32) IPPorts.PRIV_TERMLINK] = "priv_termlink";
                names[(System.Int32) IPPorts.KERBEROS] = "kerberos";
                names[(System.Int32) IPPorts.SU_MIT_TG] = "su_mit_tg";
                names[(System.Int32) IPPorts.DNSIX] = "dnsix";
                names[(System.Int32) IPPorts.MIT_DOV] = "mit_dov";
                names[(System.Int32) IPPorts.NPP] = "npp";
                names[(System.Int32) IPPorts.DCP] = "dcp";
                names[(System.Int32) IPPorts.OBJCALL] = "objcall";
                names[(System.Int32) IPPorts.SUPDUP] = "supdup";
                names[(System.Int32) IPPorts.DIXIE] = "dixie";
                names[(System.Int32) IPPorts.SWIFT_RVF] = "swift_rvf";
                names[(System.Int32) IPPorts.TACNEWS] = "tacnews";
                names[(System.Int32) IPPorts.METAGRAM] = "metagram";
                names[(System.Int32) IPPorts.NEWACCT] = "newacct";
                names[(System.Int32) IPPorts.HOSTNAME] = "hostname";
                names[(System.Int32) IPPorts.ISO_TSAP] = "iso_tsap";
                names[(System.Int32) IPPorts.GPPITNP] = "gppitnp";
                names[(System.Int32) IPPorts.ACR_NEMA] = "acr_nema";
                names[(System.Int32) IPPorts.CSO] = "cso";
                names[(System.Int32) IPPorts.CSNET_NS] = "csnet_ns";
                names[(System.Int32) IPPorts.TSMUX_3COM] = "3com_tsmux";
                names[(System.Int32) IPPorts.RTELNET] = "rtelnet";
                names[(System.Int32) IPPorts.SNAGAS] = "snagas";
                names[(System.Int32) IPPorts.POP2] = "pop2";
                names[(System.Int32) IPPorts.POP3] = "pop3";
                names[(System.Int32) IPPorts.SUNRPC] = "sunrpc";
                names[(System.Int32) IPPorts.MCIDAS] = "mcidas";
                names[(System.Int32) IPPorts.IDENT] = "ident";
                names[(System.Int32) IPPorts.AUTH] = "auth";
                names[(System.Int32) IPPorts.AUDIONEWS] = "audionews";
                names[(System.Int32) IPPorts.SFTP] = "sftp";
                names[(System.Int32) IPPorts.ANSANOTIFY] = "ansanotify";
                names[(System.Int32) IPPorts.UUCP_PATH] = "uucp_path";
                names[(System.Int32) IPPorts.SQLSERV] = "sqlserv";
                names[(System.Int32) IPPorts.NNTP] = "nntp";
                names[(System.Int32) IPPorts.CFDPTKT] = "cfdptkt";
                names[(System.Int32) IPPorts.ERPC] = "erpc";
                names[(System.Int32) IPPorts.SMAKYNET] = "smakynet";
                names[(System.Int32) IPPorts.NTP] = "ntp";
                names[(System.Int32) IPPorts.ANSATRADER] = "ansatrader";
                names[(System.Int32) IPPorts.LOCUS_MAP] = "locus_map";
                names[(System.Int32) IPPorts.NXEDIT] = "nxedit";
                names[(System.Int32) IPPorts.LOCUS_CON] = "locus_con";
                names[(System.Int32) IPPorts.GSS_XLICEN] = "gss_xlicen";
                names[(System.Int32) IPPorts.PWDGEN] = "pwdgen";
                names[(System.Int32) IPPorts.CISCO_FNA] = "cisco_fna";
                names[(System.Int32) IPPorts.CISCO_TNA] = "cisco_tna";
                names[(System.Int32) IPPorts.CISCO_SYS] = "cisco_sys";
                names[(System.Int32) IPPorts.STATSRV] = "statsrv";
                names[(System.Int32) IPPorts.INGRES_NET] = "ingres_net";
                names[(System.Int32) IPPorts.EPMAP] = "epmap";
                names[(System.Int32) IPPorts.PROFILE] = "profile";
                names[(System.Int32) IPPorts.NETBIOS_NS] = "netbios_ns";
                names[(System.Int32) IPPorts.NETBIOS_DGM] = "netbios_dgm";
                names[(System.Int32) IPPorts.NETBIOS_SSN] = "netbios_ssn";
                names[(System.Int32) IPPorts.EMFIS_DATA] = "emfis_data";
                names[(System.Int32) IPPorts.EMFIS_CNTL] = "emfis_cntl";
                names[(System.Int32) IPPorts.BL_IDM] = "bl_idm";
                names[(System.Int32) IPPorts.IMAP] = "imap";
                names[(System.Int32) IPPorts.UMA] = "uma";
                names[(System.Int32) IPPorts.UAAC] = "uaac";
                names[(System.Int32) IPPorts.ISO_TP0] = "iso_tp0";
                names[(System.Int32) IPPorts.ISO_IP] = "iso_ip";
                names[(System.Int32) IPPorts.JARGON] = "jargon";
                names[(System.Int32) IPPorts.AED_512] = "aed_512";
                names[(System.Int32) IPPorts.SQL_NET] = "sql_net";
                names[(System.Int32) IPPorts.HEMS] = "hems";
                names[(System.Int32) IPPorts.BFTP] = "bftp";
                names[(System.Int32) IPPorts.SGMP] = "sgmp";
                names[(System.Int32) IPPorts.NETSC_PROD] = "netsc_prod";
                names[(System.Int32) IPPorts.NETSC_DEV] = "netsc_dev";
                names[(System.Int32) IPPorts.SQLSRV] = "sqlsrv";
                names[(System.Int32) IPPorts.KNET_CMP] = "knet_cmp";
                names[(System.Int32) IPPorts.PCMAIL_SRV] = "pcmail_srv";
                names[(System.Int32) IPPorts.NSS_ROUTING] = "nss_routing";
                names[(System.Int32) IPPorts.SGMP_TRAPS] = "sgmp_traps";
                names[(System.Int32) IPPorts.SNMP] = "snmp";
                names[(System.Int32) IPPorts.SNMPTRAP] = "snmptrap";
                names[(System.Int32) IPPorts.CMIP_MAN] = "cmip_man";
                names[(System.Int32) IPPorts.CMIP_AGENT] = "cmip_agent";
                names[(System.Int32) IPPorts.XNS_COURIER] = "xns_courier";
                names[(System.Int32) IPPorts.S_NET] = "s_net";
                names[(System.Int32) IPPorts.NAMP] = "namp";
                names[(System.Int32) IPPorts.RSVD] = "rsvd";
                names[(System.Int32) IPPorts.SEND] = "send";
                names[(System.Int32) IPPorts.PRINT_SRV] = "print_srv";
                names[(System.Int32) IPPorts.MULTIPLEX] = "multiplex";
                names[(System.Int32) IPPorts.CL1] = "cl1";
                names[(System.Int32) IPPorts.XYPLEX_MUX] = "xyplex_mux";
                names[(System.Int32) IPPorts.MAILQ] = "mailq";
                names[(System.Int32) IPPorts.VMNET] = "vmnet";
                names[(System.Int32) IPPorts.GENRAD_MUX] = "genrad_mux";
                names[(System.Int32) IPPorts.XDMCP] = "xdmcp";
                names[(System.Int32) IPPorts.NEXTSTEP] = "nextstep";
                names[(System.Int32) IPPorts.BGP] = "bgp";
                names[(System.Int32) IPPorts.RIS] = "ris";
                names[(System.Int32) IPPorts.UNIFY] = "unify";
                names[(System.Int32) IPPorts.AUDIT] = "audit";
                names[(System.Int32) IPPorts.OCBINDER] = "ocbinder";
                names[(System.Int32) IPPorts.OCSERVER] = "ocserver";
                names[(System.Int32) IPPorts.REMOTE_KIS] = "remote_kis";
                names[(System.Int32) IPPorts.KIS] = "kis";
                names[(System.Int32) IPPorts.ACI] = "aci";
                names[(System.Int32) IPPorts.MUMPS] = "mumps";
                names[(System.Int32) IPPorts.QFT] = "qft";
                names[(System.Int32) IPPorts.GACP] = "gacp";
                names[(System.Int32) IPPorts.PROSPERO] = "prospero";
                names[(System.Int32) IPPorts.OSU_NMS] = "osu_nms";
                names[(System.Int32) IPPorts.SRMP] = "srmp";
                names[(System.Int32) IPPorts.IRC] = "irc";
                names[(System.Int32) IPPorts.DN6_NLM_AUD] = "dn6_nlm_aud";
                names[(System.Int32) IPPorts.DN6_SMM_RED] = "dn6_smm_red";
                names[(System.Int32) IPPorts.DLS] = "dls";
                names[(System.Int32) IPPorts.DLS_MON] = "dls_mon";
                names[(System.Int32) IPPorts.SMUX] = "smux";
                names[(System.Int32) IPPorts.SRC] = "src";
                names[(System.Int32) IPPorts.AT_RTMP] = "at_rtmp";
                names[(System.Int32) IPPorts.AT_NBP] = "at_nbp";
                names[(System.Int32) IPPorts.AT_3] = "at_3";
                names[(System.Int32) IPPorts.AT_ECHO] = "at_echo";
                names[(System.Int32) IPPorts.AT_5] = "at_5";
                names[(System.Int32) IPPorts.AT_ZIS] = "at_zis";
                names[(System.Int32) IPPorts.AT_7] = "at_7";
                names[(System.Int32) IPPorts.AT_8] = "at_8";
                names[(System.Int32) IPPorts.QMTP] = "qmtp";
                names[(System.Int32) IPPorts.Z39_50] = "z39.50";
                names[(System.Int32) IPPorts.N914C] = "914c_g";
                names[(System.Int32) IPPorts.ANET] = "anet";
                names[(System.Int32) IPPorts.IPX] = "ipx";
                names[(System.Int32) IPPorts.VMPWSCS] = "vmpwscs";
                names[(System.Int32) IPPorts.SOFTPC] = "softpc";
                names[(System.Int32) IPPorts.CAILIC] = "CAIlic";
                names[(System.Int32) IPPorts.DBASE] = "dbase";
                names[(System.Int32) IPPorts.MPP] = "mpp";
                names[(System.Int32) IPPorts.UARPS] = "uarps";
                names[(System.Int32) IPPorts.IMAP3] = "imap3";
                names[(System.Int32) IPPorts.FLN_SPX] = "fln_spx";
                names[(System.Int32) IPPorts.RSH_SPX] = "rsh_spx";
                names[(System.Int32) IPPorts.CDC] = "cdc";
                names[(System.Int32) IPPorts.MASQDIALER] = "masqdialer";
                names[(System.Int32) IPPorts.DIRECT] = "direct";
                names[(System.Int32) IPPorts.SUR_MEAS] = "sur_meas";
                names[(System.Int32) IPPorts.INBUSINESS] = "inbusiness";
                names[(System.Int32) IPPorts.LINK] = "link";
                names[(System.Int32) IPPorts.DSP3270] = "dsp3270";
                names[(System.Int32) IPPorts.SUBNTBCST_TFTP] = "subntbcst_tftp";
                names[(System.Int32) IPPorts.BHFHS] = "bhfhs";
                names[(System.Int32) IPPorts.RAP2] = "rap2";
                names[(System.Int32) IPPorts.SET] = "set";
                names[(System.Int32) IPPorts.YAK_CHAT] = "yak_chat";
                names[(System.Int32) IPPorts.ESRO_GEN] = "esro_gen";
                names[(System.Int32) IPPorts.OPENPORT] = "openport";
                names[(System.Int32) IPPorts.NSIIOPS] = "nsiiops";
                names[(System.Int32) IPPorts.ARCISDMS] = "arcisdms";
                names[(System.Int32) IPPorts.HDAP] = "hdap";
                names[(System.Int32) IPPorts.BGMP] = "bgmp";
                names[(System.Int32) IPPorts.X_BONE_CTL] = "x_bone_ctl";
                names[(System.Int32) IPPorts.SST] = "sst";
                names[(System.Int32) IPPorts.TD_SERVICE] = "td_service";
                names[(System.Int32) IPPorts.TD_REPLICA] = "td_replica";
                names[(System.Int32) IPPorts.HTTP_MGMT] = "http_mgmt";
                names[(System.Int32) IPPorts.PERSONAL_LINK] = "personal_link";
                names[(System.Int32) IPPorts.CABLEPORT_AX] = "cableport_ax";
                names[(System.Int32) IPPorts.RESCAP] = "rescap";
                names[(System.Int32) IPPorts.CORERJD] = "corerjd";
                names[(System.Int32) IPPorts.FXP_1] = "fxp_1";
                names[(System.Int32) IPPorts.K_BLOCK] = "k_block";
                names[(System.Int32) IPPorts.NOVASTORBAKCUP] = "novastorbakcup";
                names[(System.Int32) IPPorts.ENTRUSTTIME] = "entrusttime";
                names[(System.Int32) IPPorts.BHMDS] = "bhmds";
                names[(System.Int32) IPPorts.ASIP_WEBADMIN] = "asip_webadmin";
                names[(System.Int32) IPPorts.VSLMP] = "vslmp";
                names[(System.Int32) IPPorts.MAGENTA_LOGIC] = "magenta_logic";
                names[(System.Int32) IPPorts.OPALIS_ROBOT] = "opalis_robot";
                names[(System.Int32) IPPorts.DPSI] = "dpsi";
                names[(System.Int32) IPPorts.DECAUTH] = "decauth";
                names[(System.Int32) IPPorts.ZANNET] = "zannet";
                names[(System.Int32) IPPorts.PKIX_TIMESTAMP] = "pkix_timestamp";
                names[(System.Int32) IPPorts.PTP_EVENT] = "ptp_event";
                names[(System.Int32) IPPorts.PTP_GENERAL] = "ptp_general";
                names[(System.Int32) IPPorts.PIP] = "pip";
                names[(System.Int32) IPPorts.RTSPS] = "rtsps";
                names[(System.Int32) IPPorts.TEXAR] = "texar";
                names[(System.Int32) IPPorts.PDAP] = "pdap";
                names[(System.Int32) IPPorts.PAWSERV] = "pawserv";
                names[(System.Int32) IPPorts.ZSERV] = "zserv";
                names[(System.Int32) IPPorts.FATSERV] = "fatserv";
                names[(System.Int32) IPPorts.CSI_SGWP] = "csi_sgwp";
                names[(System.Int32) IPPorts.MFTP] = "mftp";
                names[(System.Int32) IPPorts.MATIP_TYPE_A] = "matip_type_a";
                names[(System.Int32) IPPorts.MATIP_TYPE_B] = "matip_type_b";
                names[(System.Int32) IPPorts.BHOETTY] = "bhoetty";
                names[(System.Int32) IPPorts.DTAG_STE_SB] = "dtag_ste_sb";
                names[(System.Int32) IPPorts.BHOEDAP4] = "bhoedap4";
                names[(System.Int32) IPPorts.NDSAUTH] = "ndsauth";
                names[(System.Int32) IPPorts.BH611] = "bh611";
                names[(System.Int32) IPPorts.DATEX_ASN] = "datex_asn";
                names[(System.Int32) IPPorts.CLOANTO_NET] = "cloanto_net";
                names[(System.Int32) IPPorts.BHEVENT] = "bhevent";
                names[(System.Int32) IPPorts.SHRINKWRAP] = "shrinkwrap";
                names[(System.Int32) IPPorts.NSRMP] = "nsrmp";
                names[(System.Int32) IPPorts.SCOI2ODIALOG] = "scoi2odialog";
                names[(System.Int32) IPPorts.SEMANTIX] = "semantix";
                names[(System.Int32) IPPorts.SRSSEND] = "srssend";
                names[(System.Int32) IPPorts.RSVP_TUNNEL] = "rsvp_tunnel";
                names[(System.Int32) IPPorts.AURORA_CMGR] = "aurora_cmgr";
                names[(System.Int32) IPPorts.DTK] = "dtk";
                names[(System.Int32) IPPorts.ODMR] = "odmr";
                names[(System.Int32) IPPorts.MORTGAGEWARE] = "mortgageware";
                names[(System.Int32) IPPorts.QBIKGDP] = "qbikgdp";
                names[(System.Int32) IPPorts.RPC2PORTMAP] = "rpc2portmap";
                names[(System.Int32) IPPorts.CODAAUTH] = "codaauth";
                names[(System.Int32) IPPorts.CLEARCASE] = "clearcase";
                names[(System.Int32) IPPorts.ULISTPROC] = "ulistproc";
                names[(System.Int32) IPPorts.LEGENT_1] = "legent_1";
                names[(System.Int32) IPPorts.LEGENT_2] = "legent_2";
                names[(System.Int32) IPPorts.HASSLE] = "hassle";
                names[(System.Int32) IPPorts.NIP] = "nip";
                names[(System.Int32) IPPorts.TNETOS] = "tnETOS";
                names[(System.Int32) IPPorts.DSETOS] = "dsETOS";
                names[(System.Int32) IPPorts.IS99C] = "is99c";
                names[(System.Int32) IPPorts.IS99S] = "is99s";
                names[(System.Int32) IPPorts.HP_COLLECTOR] = "hp_collector";
                names[(System.Int32) IPPorts.HP_MANAGED_NODE] = "hp_managed_node";
                names[(System.Int32) IPPorts.HP_ALARM_MGR] = "hp_alarm_mgr";
                names[(System.Int32) IPPorts.ARNS] = "arns";
                names[(System.Int32) IPPorts.IBM_APP] = "ibm_app";
                names[(System.Int32) IPPorts.ASA] = "asa";
                names[(System.Int32) IPPorts.AURP] = "aurp";
                names[(System.Int32) IPPorts.UNIDATA_LDM] = "unidata_ldm";
                names[(System.Int32) IPPorts.UIS] = "uis";
                names[(System.Int32) IPPorts.SYNOTICS_RELAY] = "synotics_relay";
                names[(System.Int32) IPPorts.SYNOTICS_BROKER] = "synotics_broker";
                names[(System.Int32) IPPorts.META5] = "meta5";
                names[(System.Int32) IPPorts.EMBL_NDT] = "embl_ndt";
                names[(System.Int32) IPPorts.NETCP] = "netcp";
                names[(System.Int32) IPPorts.NETWARE_IP] = "netware_ip";
                names[(System.Int32) IPPorts.MPTN] = "mptn";
                names[(System.Int32) IPPorts.KRYPTOLAN] = "kryptolan";
                names[(System.Int32) IPPorts.ISO_TSAP_C2] = "iso_tsap_c2";
                names[(System.Int32) IPPorts.WORK_SOL] = "work_sol";
                names[(System.Int32) IPPorts.UPS] = "ups";
                names[(System.Int32) IPPorts.GENIE] = "genie";
                names[(System.Int32) IPPorts.DECAP] = "decap";
                names[(System.Int32) IPPorts.NCED] = "nced";
                names[(System.Int32) IPPorts.NCLD] = "ncld";
                names[(System.Int32) IPPorts.IMSP] = "imsp";
                names[(System.Int32) IPPorts.TIMBUKTU] = "timbuktu";
                names[(System.Int32) IPPorts.PRM_SM] = "prm_sm";
                names[(System.Int32) IPPorts.PRM_NM] = "prm_nm";
                names[(System.Int32) IPPorts.DECLADEBUG] = "decladebug";
                names[(System.Int32) IPPorts.RMT] = "rmt";
                names[(System.Int32) IPPorts.SYNOPTICS_TRAP] = "synoptics_trap";
                names[(System.Int32) IPPorts.SMSP] = "smsp";
                names[(System.Int32) IPPorts.INFOSEEK] = "infoseek";
                names[(System.Int32) IPPorts.BNET] = "bnet";
                names[(System.Int32) IPPorts.SILVERPLATTER] = "silverplatter";
                names[(System.Int32) IPPorts.ONMUX] = "onmux";
                names[(System.Int32) IPPorts.HYPER_G] = "hyper_g";
                names[(System.Int32) IPPorts.ARIEL1] = "ariel1";
                names[(System.Int32) IPPorts.SMPTE] = "smpte";
                names[(System.Int32) IPPorts.ARIEL2] = "ariel2";
                names[(System.Int32) IPPorts.ARIEL3] = "ariel3";
                names[(System.Int32) IPPorts.OPC_JOB_START] = "opc_job_start";
                names[(System.Int32) IPPorts.OPC_JOB_TRACK] = "opc_job_track";
                names[(System.Int32) IPPorts.ICAD_EL] = "icad_el";
                names[(System.Int32) IPPorts.SMARTSDP] = "smartsdp";
                names[(System.Int32) IPPorts.SVRLOC] = "svrloc";
                names[(System.Int32) IPPorts.OCS_CMU] = "ocs_cmu";
                names[(System.Int32) IPPorts.OCS_AMU] = "ocs_amu";
                names[(System.Int32) IPPorts.UTMPSD] = "utmpsd";
                names[(System.Int32) IPPorts.UTMPCD] = "utmpcd";
                names[(System.Int32) IPPorts.IASD] = "iasd";
                names[(System.Int32) IPPorts.NNSP] = "nnsp";
                names[(System.Int32) IPPorts.MOBILEIP_AGENT] = "mobileip_agent";
                names[(System.Int32) IPPorts.MOBILIP_MN] = "mobilip_mn";
                names[(System.Int32) IPPorts.DNA_CML] = "dna_cml";
                names[(System.Int32) IPPorts.COMSCM] = "comscm";
                names[(System.Int32) IPPorts.DSFGW] = "dsfgw";
                names[(System.Int32) IPPorts.DASP] = "dasp";
                names[(System.Int32) IPPorts.SGCP] = "sgcp";
                names[(System.Int32) IPPorts.DECVMS_SYSMGT] = "decvms_sysmgt";
                names[(System.Int32) IPPorts.CVC_HOSTD] = "cvc_hostd";
                names[(System.Int32) IPPorts.HTTPS] = "https";
                names[(System.Int32) IPPorts.SNPP] = "snpp";
                names[(System.Int32) IPPorts.MICROSOFT_DS] = "microsoft_ds";
                names[(System.Int32) IPPorts.DDM_RDB] = "ddm_rdb";
                names[(System.Int32) IPPorts.DDM_DFM] = "ddm_dfm";
                names[(System.Int32) IPPorts.DDM_SSL] = "ddm_ssl";
                names[(System.Int32) IPPorts.AS_SERVERMAP] = "as_servermap";
                names[(System.Int32) IPPorts.TSERVER] = "tserver";
                names[(System.Int32) IPPorts.SFS_SMP_NET] = "sfs_smp_net";
                names[(System.Int32) IPPorts.SFS_CONFIG] = "sfs_config";
                names[(System.Int32) IPPorts.CREATIVESERVER] = "creativeserver";
                names[(System.Int32) IPPorts.CONTENTSERVER] = "contentserver";
                names[(System.Int32) IPPorts.CREATIVEPARTNR] = "creativepartnr";
                names[(System.Int32) IPPorts.MACON_TCP] = "macon_tcp";
                names[(System.Int32) IPPorts.SCOHELP] = "scohelp";
                names[(System.Int32) IPPorts.APPLEQTC] = "appleqtc";
                names[(System.Int32) IPPorts.AMPR_RCMD] = "ampr_rcmd";
                names[(System.Int32) IPPorts.SKRONK] = "skronk";
                names[(System.Int32) IPPorts.DATASURFSRV] = "datasurfsrv";
                names[(System.Int32) IPPorts.DATASURFSRVSEC] = "datasurfsrvsec";
                names[(System.Int32) IPPorts.ALPES] = "alpes";
                names[(System.Int32) IPPorts.KPASSWD] = "kpasswd";
                names[(System.Int32) IPPorts.DIGITAL_VRC] = "digital_vrc";
                names[(System.Int32) IPPorts.MYLEX_MAPD] = "mylex_mapd";
                names[(System.Int32) IPPorts.PHOTURIS] = "photuris";
                names[(System.Int32) IPPorts.RCP] = "rcp";
                names[(System.Int32) IPPorts.SCX_PROXY] = "scx_proxy";
                names[(System.Int32) IPPorts.MONDEX] = "mondex";
                names[(System.Int32) IPPorts.LJK_LOGIN] = "ljk_login";
                names[(System.Int32) IPPorts.HYBRID_POP] = "hybrid_pop";
                names[(System.Int32) IPPorts.TN_TL_W1] = "tn_tl_w1";
                names[(System.Int32) IPPorts.TCPNETHASPSRV] = "tcpnethaspsrv";
                names[(System.Int32) IPPorts.TN_TL_FD1] = "tn_tl_fd1";
                names[(System.Int32) IPPorts.SS7NS] = "ss7ns";
                names[(System.Int32) IPPorts.SPSC] = "spsc";
                names[(System.Int32) IPPorts.IAFSERVER] = "iafserver";
                names[(System.Int32) IPPorts.IAFDBASE] = "iafdbase";
                names[(System.Int32) IPPorts.PH] = "ph";
                names[(System.Int32) IPPorts.BGS_NSI] = "bgs_nsi";
                names[(System.Int32) IPPorts.ULPNET] = "ulpnet";
                names[(System.Int32) IPPorts.INTEGRA_SME] = "integra_sme";
                names[(System.Int32) IPPorts.POWERBURST] = "powerburst";
                names[(System.Int32) IPPorts.AVIAN] = "avian";
                names[(System.Int32) IPPorts.SAFT] = "saft";
                names[(System.Int32) IPPorts.GSS_HTTP] = "gss_http";
                names[(System.Int32) IPPorts.NEST_PROTOCOL] = "nest_protocol";
                names[(System.Int32) IPPorts.MICOM_PFS] = "micom_pfs";
                names[(System.Int32) IPPorts.GO_LOGIN] = "go_login";
                names[(System.Int32) IPPorts.TICF_1] = "ticf_1";
                names[(System.Int32) IPPorts.TICF_2] = "ticf_2";
                names[(System.Int32) IPPorts.POV_RAY] = "pov_ray";
                names[(System.Int32) IPPorts.INTECOURIER] = "intecourier";
                names[(System.Int32) IPPorts.PIM_RP_DISC] = "pim_rp_disc";
                names[(System.Int32) IPPorts.DANTZ] = "dantz";
                names[(System.Int32) IPPorts.SIAM] = "siam";
                names[(System.Int32) IPPorts.ISO_ILL] = "iso_ill";
                names[(System.Int32) IPPorts.ISAKMP] = "isakmp";
                names[(System.Int32) IPPorts.STMF] = "stmf";
                names[(System.Int32) IPPorts.ASA_APPL_PROTO] = "asa_appl_proto";
                names[(System.Int32) IPPorts.INTRINSA] = "intrinsa";
                names[(System.Int32) IPPorts.CITADEL] = "citadel";
                names[(System.Int32) IPPorts.MAILBOX_LM] = "mailbox_lm";
                names[(System.Int32) IPPorts.OHIMSRV] = "ohimsrv";
                names[(System.Int32) IPPorts.CRS] = "crs";
                names[(System.Int32) IPPorts.XVTTP] = "xvttp";
                names[(System.Int32) IPPorts.SNARE] = "snare";
                names[(System.Int32) IPPorts.FCP] = "fcp";
                names[(System.Int32) IPPorts.PASSGO] = "passgo";
                names[(System.Int32) IPPorts.EXEC] = "exec";
                names[(System.Int32) IPPorts.LOGIN] = "login";
                names[(System.Int32) IPPorts.SHELL] = "shell";
                names[(System.Int32) IPPorts.PRINTER] = "printer";
                names[(System.Int32) IPPorts.VIDEOTEX] = "videotex";
                names[(System.Int32) IPPorts.TALK] = "talk";
                names[(System.Int32) IPPorts.NTALK] = "ntalk";
                names[(System.Int32) IPPorts.UTIME] = "utime";
                names[(System.Int32) IPPorts.EFS] = "efs";
                names[(System.Int32) IPPorts.RIPNG] = "ripng";
                names[(System.Int32) IPPorts.ULP] = "ulp";
                names[(System.Int32) IPPorts.IBM_DB2] = "ibm_db2";
                names[(System.Int32) IPPorts.NCP] = "ncp";
                names[(System.Int32) IPPorts.TIMED] = "timed";
                names[(System.Int32) IPPorts.TEMPO] = "tempo";
                names[(System.Int32) IPPorts.STX] = "stx";
                names[(System.Int32) IPPorts.CUSTIX] = "custix";
                names[(System.Int32) IPPorts.IRC_SERV] = "irc_serv";
                names[(System.Int32) IPPorts.COURIER] = "courier";
                names[(System.Int32) IPPorts.CONFERENCE] = "conference";
                names[(System.Int32) IPPorts.NETNEWS] = "netnews";
                names[(System.Int32) IPPorts.NETWALL] = "netwall";
                names[(System.Int32) IPPorts.MM_ADMIN] = "mm_admin";
                names[(System.Int32) IPPorts.IIOP] = "iiop";
                names[(System.Int32) IPPorts.OPALIS_RDV] = "opalis_rdv";
                names[(System.Int32) IPPorts.NMSP] = "nmsp";
                names[(System.Int32) IPPorts.GDOMAP] = "gdomap";
                names[(System.Int32) IPPorts.APERTUS_LDP] = "apertus_ldp";
                names[(System.Int32) IPPorts.UUCP] = "uucp";
                names[(System.Int32) IPPorts.UUCP_RLOGIN] = "uucp_rlogin";
                names[(System.Int32) IPPorts.COMMERCE] = "commerce";
                names[(System.Int32) IPPorts.KLOGIN] = "klogin";
                names[(System.Int32) IPPorts.KSHELL] = "kshell";
                names[(System.Int32) IPPorts.APPLEQTCSRVR] = "appleqtcsrvr";
                names[(System.Int32) IPPorts.DHCPV6_CLIENT] = "dhcpv6_client";
                names[(System.Int32) IPPorts.DHCPV6_SERVER] = "dhcpv6_server";
                names[(System.Int32) IPPorts.AFPOVERTCP] = "afpovertcp";
                names[(System.Int32) IPPorts.IDFP] = "idfp";
                names[(System.Int32) IPPorts.NEW_RWHO] = "new_rwho";
                names[(System.Int32) IPPorts.CYBERCASH] = "cybercash";
                names[(System.Int32) IPPorts.DEVICESHARE] = "deviceshare";
                names[(System.Int32) IPPorts.PIRP] = "pirp";
                names[(System.Int32) IPPorts.RTSP] = "rtsp";
                names[(System.Int32) IPPorts.DSF] = "dsf";
                names[(System.Int32) IPPorts.REMOTEFS] = "remotefs";
                names[(System.Int32) IPPorts.OPENVMS_SYSIPC] = "openvms_sysipc";
                names[(System.Int32) IPPorts.SDNSKMP] = "sdnskmp";
                names[(System.Int32) IPPorts.TEEDTAP] = "teedtap";
                names[(System.Int32) IPPorts.RMONITOR] = "rmonitor";
                names[(System.Int32) IPPorts.MONITOR] = "monitor";
                names[(System.Int32) IPPorts.CHSHELL] = "chshell";
                names[(System.Int32) IPPorts.NNTPS] = "nntps";
                names[(System.Int32) IPPorts.N9PFS] = "9pfs";
                names[(System.Int32) IPPorts.WHOAMI] = "whoami";
                names[(System.Int32) IPPorts.STREETTALK] = "streettalk";
                names[(System.Int32) IPPorts.BANYAN_RPC] = "banyan_rpc";
                names[(System.Int32) IPPorts.MS_SHUTTLE] = "ms_shuttle";
                names[(System.Int32) IPPorts.MS_ROME] = "ms_rome";
                names[(System.Int32) IPPorts.METER] = "meter";
                names[(System.Int32) IPPorts.METER2] = "meter2";
                names[(System.Int32) IPPorts.SONAR] = "sonar";
                names[(System.Int32) IPPorts.BANYAN_VIP] = "banyan_vip";
                names[(System.Int32) IPPorts.FTP_AGENT] = "ftp_agent";
                names[(System.Int32) IPPorts.VEMMI] = "vemmi";
                names[(System.Int32) IPPorts.IPCD] = "ipcd";
                names[(System.Int32) IPPorts.VNAS] = "vnas";
                names[(System.Int32) IPPorts.IPDD] = "ipdd";
                names[(System.Int32) IPPorts.DECBSRV] = "decbsrv";
                names[(System.Int32) IPPorts.SNTP_HEARTBEAT] = "sntp_heartbeat";
                names[(System.Int32) IPPorts.BDP] = "bdp";
                names[(System.Int32) IPPorts.SCC_SECURITY] = "scc_security";
                names[(System.Int32) IPPorts.PHILIPS_VC] = "philips_vc";
                names[(System.Int32) IPPorts.KEYSERVER] = "keyserver";
                names[(System.Int32) IPPorts.IMAP4_SSL] = "imap4_ssl";
                names[(System.Int32) IPPorts.PASSWORD_CHG] = "password_chg";
                names[(System.Int32) IPPorts.SUBMISSION] = "submission";
                names[(System.Int32) IPPorts.CAL] = "cal";
                names[(System.Int32) IPPorts.EYELINK] = "eyelink";
                names[(System.Int32) IPPorts.TNS_CML] = "tns_cml";
                names[(System.Int32) IPPorts.HTTP_ALT] = "http_alt";
                names[(System.Int32) IPPorts.EUDORA_SET] = "eudora_set";
                names[(System.Int32) IPPorts.HTTP_RPC_EPMAP] = "http_rpc_epmap";
                names[(System.Int32) IPPorts.TPIP] = "tpip";
                names[(System.Int32) IPPorts.CAB_PROTOCOL] = "cab_protocol";
                names[(System.Int32) IPPorts.SMSD] = "smsd";
                names[(System.Int32) IPPorts.PTCNAMESERVICE] = "ptcnameservice";
                names[(System.Int32) IPPorts.SCO_WEBSRVRMG3] = "sco_websrvrmg3";
                names[(System.Int32) IPPorts.ACP] = "acp";
                names[(System.Int32) IPPorts.IPCSERVER] = "ipcserver";
                names[(System.Int32) IPPorts.URM] = "urm";
                names[(System.Int32) IPPorts.NQS] = "nqs";
                names[(System.Int32) IPPorts.SIFT_UFT] = "sift_uft";
                names[(System.Int32) IPPorts.NPMP_TRAP] = "npmp_trap";
                names[(System.Int32) IPPorts.NPMP_LOCAL] = "npmp_local";
                names[(System.Int32) IPPorts.NPMP_GUI] = "npmp_gui";
                names[(System.Int32) IPPorts.HMMP_IND] = "hmmp_ind";
                names[(System.Int32) IPPorts.HMMP_OP] = "hmmp_op";
                names[(System.Int32) IPPorts.SSHELL] = "sshell";
                names[(System.Int32) IPPorts.SCO_INETMGR] = "sco_inetmgr";
                names[(System.Int32) IPPorts.SCO_SYSMGR] = "sco_sysmgr";
                names[(System.Int32) IPPorts.SCO_DTMGR] = "sco_dtmgr";
                names[(System.Int32) IPPorts.DEI_ICDA] = "dei_icda";
                names[(System.Int32) IPPorts.DIGITAL_EVM] = "digital_evm";
                names[(System.Int32) IPPorts.SCO_WEBSRVRMGR] = "sco_websrvrmgr";
                names[(System.Int32) IPPorts.ESCP_IP] = "escp_ip";
                names[(System.Int32) IPPorts.COLLABORATOR] = "collaborator";
                names[(System.Int32) IPPorts.AUX_BUS_SHUNT] = "aux_bus_shunt";
                names[(System.Int32) IPPorts.CRYPTOADMIN] = "cryptoadmin";
                names[(System.Int32) IPPorts.DEC_DLM] = "dec_dlm";
                names[(System.Int32) IPPorts.ASIA] = "asia";
                names[(System.Int32) IPPorts.PASSGO_TIVOLI] = "passgo_tivoli";
                names[(System.Int32) IPPorts.QMQP] = "qmqp";
                names[(System.Int32) IPPorts.AMP3_3COM] = "3com_amp3";
                names[(System.Int32) IPPorts.RDA] = "rda";
                names[(System.Int32) IPPorts.IPP] = "ipp";
                names[(System.Int32) IPPorts.BMPP] = "bmpp";
                names[(System.Int32) IPPorts.SERVSTAT] = "servstat";
                names[(System.Int32) IPPorts.GINAD] = "ginad";
                names[(System.Int32) IPPorts.RLZDBASE] = "rlzdbase";
                names[(System.Int32) IPPorts.LDAPS] = "ldaps";
                names[(System.Int32) IPPorts.LANSERVER] = "lanserver";
                names[(System.Int32) IPPorts.MCNS_SEC] = "mcns_sec";
                names[(System.Int32) IPPorts.MSDP] = "msdp";
                names[(System.Int32) IPPorts.ENTRUST_SPS] = "entrust_sps";
                names[(System.Int32) IPPorts.REPCMD] = "repcmd";
                names[(System.Int32) IPPorts.ESRO_EMSDP] = "esro_emsdp";
                names[(System.Int32) IPPorts.SANITY] = "sanity";
                names[(System.Int32) IPPorts.DWR] = "dwr";
                names[(System.Int32) IPPorts.PSSC] = "pssc";
                names[(System.Int32) IPPorts.LDP] = "ldp";
                names[(System.Int32) IPPorts.DHCP_FAILOVER] = "dhcp_failover";
                names[(System.Int32) IPPorts.RRP] = "rrp";
                names[(System.Int32) IPPorts.AMINET] = "aminet";
                names[(System.Int32) IPPorts.OBEX] = "obex";
                names[(System.Int32) IPPorts.IEEE_MMS] = "ieee_mms";
                names[(System.Int32) IPPorts.HELLO_PORT] = "hello_port";
                names[(System.Int32) IPPorts.REPSCMD] = "repscmd";
                names[(System.Int32) IPPorts.AODV] = "aodv";
                names[(System.Int32) IPPorts.TINC] = "tinc";
                names[(System.Int32) IPPorts.SPMP] = "spmp";
                names[(System.Int32) IPPorts.RMC] = "rmc";
                names[(System.Int32) IPPorts.TENFOLD] = "tenfold";
                names[(System.Int32) IPPorts.URL_RENDEZVOUS] = "url_rendezvous";
                names[(System.Int32) IPPorts.MAC_SRVR_ADMIN] = "mac_srvr_admin";
                names[(System.Int32) IPPorts.HAP] = "hap";
                names[(System.Int32) IPPorts.PFTP] = "pftp";
                names[(System.Int32) IPPorts.PURENOISE] = "purenoise";
                names[(System.Int32) IPPorts.SECURE_AUX_BUS] = "secure_aux_bus";
                names[(System.Int32) IPPorts.SUN_DR] = "sun_dr";
                names[(System.Int32) IPPorts.MDQS] = "mdqs";
                names[(System.Int32) IPPorts.DOOM] = "doom";
                names[(System.Int32) IPPorts.DISCLOSE] = "disclose";
                names[(System.Int32) IPPorts.MECOMM] = "mecomm";
                names[(System.Int32) IPPorts.MEREGISTER] = "meregister";
                names[(System.Int32) IPPorts.VACDSM_SWS] = "vacdsm_sws";
                names[(System.Int32) IPPorts.VACDSM_APP] = "vacdsm_app";
                names[(System.Int32) IPPorts.VPPS_QUA] = "vpps_qua";
                names[(System.Int32) IPPorts.CIMPLEX] = "cimplex";
                names[(System.Int32) IPPorts.ACAP] = "acap";
                names[(System.Int32) IPPorts.DCTP] = "dctp";
                names[(System.Int32) IPPorts.VPPS_VIA] = "vpps_via";
                names[(System.Int32) IPPorts.VPP] = "vpp";
                names[(System.Int32) IPPorts.GGF_NCP] = "ggf_ncp";
                names[(System.Int32) IPPorts.MRM] = "mrm";
                names[(System.Int32) IPPorts.ENTRUST_AAAS] = "entrust_aaas";
                names[(System.Int32) IPPorts.ENTRUST_AAMS] = "entrust_aams";
                names[(System.Int32) IPPorts.XFR] = "xfr";
                names[(System.Int32) IPPorts.CORBA_IIOP] = "corba_iiop";
                names[(System.Int32) IPPorts.CORBA_IIOP_SSL] = "corba_iiop_ssl";
                names[(System.Int32) IPPorts.MDC_PORTMAPPER] = "mdc_portmapper";
                names[(System.Int32) IPPorts.HCP_WISMAR] = "hcp_wismar";
                names[(System.Int32) IPPorts.ASIPREGISTRY] = "asipregistry";
                names[(System.Int32) IPPorts.REALM_RUSD] = "realm_rusd";
                names[(System.Int32) IPPorts.NMAP] = "nmap";
                names[(System.Int32) IPPorts.VATP] = "vatp";
                names[(System.Int32) IPPorts.MSEXCH_ROUTING] = "msexch_routing";
                names[(System.Int32) IPPorts.HYPERWAVE_ISP] = "hyperwave_isp";
                names[(System.Int32) IPPorts.CONNENDP] = "connendp";
                names[(System.Int32) IPPorts.HA_CLUSTER] = "ha_cluster";
                names[(System.Int32) IPPorts.IEEE_MMS_SSL] = "ieee_mms_ssl";
                names[(System.Int32) IPPorts.RUSHD] = "rushd";
                names[(System.Int32) IPPorts.UUIDGEN] = "uuidgen";
                names[(System.Int32) IPPorts.OLSR] = "olsr";
                names[(System.Int32) IPPorts.ACCESSNETWORK] = "accessnetwork";
                names[(System.Int32) IPPorts.ELCSD] = "elcsd";
                names[(System.Int32) IPPorts.AGENTX] = "agentx";
                names[(System.Int32) IPPorts.SILC] = "silc";
                names[(System.Int32) IPPorts.BORLAND_DSJ] = "borland_dsj";
                names[(System.Int32) IPPorts.ENTRUST_KMSH] = "entrust_kmsh";
                names[(System.Int32) IPPorts.ENTRUST_ASH] = "entrust_ash";
                names[(System.Int32) IPPorts.CISCO_TDP] = "cisco_tdp";
                names[(System.Int32) IPPorts.NETVIEWDM1] = "netviewdm1";
                names[(System.Int32) IPPorts.NETVIEWDM2] = "netviewdm2";
                names[(System.Int32) IPPorts.NETVIEWDM3] = "netviewdm3";
                names[(System.Int32) IPPorts.NETGW] = "netgw";
                names[(System.Int32) IPPorts.NETRCS] = "netrcs";
                names[(System.Int32) IPPorts.FLEXLM] = "flexlm";
                names[(System.Int32) IPPorts.FUJITSU_DEV] = "fujitsu_dev";
                names[(System.Int32) IPPorts.RIS_CM] = "ris_cm";
                names[(System.Int32) IPPorts.KERBEROS_ADM] = "kerberos_adm";
                names[(System.Int32) IPPorts.RFILE] = "rfile";
                names[(System.Int32) IPPorts.PUMP] = "pump";
                names[(System.Int32) IPPorts.QRH] = "qrh";
                names[(System.Int32) IPPorts.RRH] = "rrh";
                names[(System.Int32) IPPorts.TELL] = "tell";
                names[(System.Int32) IPPorts.NLOGIN] = "nlogin";
                names[(System.Int32) IPPorts.CON] = "con";
                names[(System.Int32) IPPorts.NS] = "ns";
                names[(System.Int32) IPPorts.RXE] = "rxe";
                names[(System.Int32) IPPorts.QUOTAD] = "quotad";
                names[(System.Int32) IPPorts.CYCLESERV] = "cycleserv";
                names[(System.Int32) IPPorts.OMSERV] = "omserv";
                names[(System.Int32) IPPorts.WEBSTER] = "webster";
                names[(System.Int32) IPPorts.PHONEBOOK] = "phonebook";
                names[(System.Int32) IPPorts.VID] = "vid";
                names[(System.Int32) IPPorts.CADLOCK] = "cadlock";
                names[(System.Int32) IPPorts.RTIP] = "rtip";
                names[(System.Int32) IPPorts.CYCLESERV2] = "cycleserv2";
                names[(System.Int32) IPPorts.SUBMIT] = "submit";
                names[(System.Int32) IPPorts.RPASSWD] = "rpasswd";
                names[(System.Int32) IPPorts.ENTOMB] = "entomb";
                names[(System.Int32) IPPorts.WPAGES] = "wpages";
                names[(System.Int32) IPPorts.WPGS] = "wpgs";
                names[(System.Int32) IPPorts.QSC] = "qsc";
                names[(System.Int32) IPPorts.MDBS_DAEMON] = "mdbs_daemon";
                names[(System.Int32) IPPorts.ITM_MCELL_S] = "itm_mcell_s";
                names[(System.Int32) IPPorts.PKIX_3_CA_RA] = "pkix_3_ca_ra";
                names[(System.Int32) IPPorts.DHCP_FAILOVER2] = "dhcp_failover2";
                names[(System.Int32) IPPorts.RSYNC] = "rsync";
                names[(System.Int32) IPPorts.ICLCNET_LOCATE] = "iclcnet_locate";
                names[(System.Int32) IPPorts.ICLCNET_SVINFO] = "iclcnet_svinfo";
                names[(System.Int32) IPPorts.ACCESSBUILDER] = "accessbuilder";
                names[(System.Int32) IPPorts.CDDBP] = "cddbp";
                names[(System.Int32) IPPorts.OMGINITIALREFS] = "omginitialrefs";
                names[(System.Int32) IPPorts.SMPNAMERES] = "smpnameres";
                names[(System.Int32) IPPorts.IDEAFARM_CHAT] = "ideafarm_chat";
                names[(System.Int32) IPPorts.IDEAFARM_CATCH] = "ideafarm_catch";
                names[(System.Int32) IPPorts.XACT_BACKUP] = "xact_backup";
                names[(System.Int32) IPPorts.FTPS_DATA] = "ftps_data";
                names[(System.Int32) IPPorts.FTPS] = "ftps";
                names[(System.Int32) IPPorts.NAS] = "nas";
                names[(System.Int32) IPPorts.TELNETS] = "telnets";
                names[(System.Int32) IPPorts.IMAPS] = "imaps";
                names[(System.Int32) IPPorts.IRCS] = "ircs";
                names[(System.Int32) IPPorts.POP3S] = "pop3s";
                names[(System.Int32) IPPorts.VSINET] = "vsinet";
                names[(System.Int32) IPPorts.MAITRD] = "maitrd";
                names[(System.Int32) IPPorts.BUSBOY] = "busboy";
                names[(System.Int32) IPPorts.GARCON] = "garcon";
                names[(System.Int32) IPPorts.PUPROUTER] = "puprouter";
                names[(System.Int32) IPPorts.CADLOCK2] = "cadlock2";
                names[(System.Int32) IPPorts.SURF] = "surf";
                names[(System.Int32) IPPorts.RESERVED_1023] = "1023r";
                names[(System.Int32) IPPorts.RESERVED_1024] = "1024r";
                names[(System.Int32) IPPorts.SOCKS] = "socks";
                names[(System.Int32) IPPorts.HSRP] = "hsrp";
                names[(System.Int32) IPPorts.CVS] = "cvs";
                names[(System.Int32) IPPorts.AISES] = "aises";
                names[(System.Int32) IPPorts.X11] = "X11";
            }
        }
    }
}
