﻿using Libs;
using ServerDLL;

namespace Zone
{
    class ClientHandlerMethods
    {
        public static void ConfirmVerificationInfo(FiestaClient cln, FiestaPacket pkt)
        {
            TransferCharacter charTransfer;
            ushort worldSessionID;
            Character character;
            InterPacket pInter;
            byte[] clientHash;
            bool querySuccess;
            string charName;
            FiestaPacket p;

            worldSessionID = pkt.ReadUShort();
            charName = pkt.ReadString(16);
            clientHash = pkt.ReadArray(1536);

            charTransfer = TransferCharacters.In[worldSessionID];

            if (charTransfer == null || charTransfer.Name != charName)
            {
                CIO.Write(CType.Warning, "Invalid world session ID");
                cln.Disconnect();
                return;
            }

            querySuccess = CharacterDB.In.TryGetCharacter(out character, charTransfer.AccountID, charTransfer.Name);
            querySuccess = querySuccess ? CharacterDB.In.TryGetEquipment(character) : querySuccess;

            if (charTransfer == null)
            {
                cln.Disconnect();
            }
            else if (clientHash != clientHash)
            {
                SendZoneError(cln, ZoneError.Manipulated);
            }
            else if (!querySuccess)
            {
                //SendZoneError(cln, ZoneError.DBError);
            }
            else
            {
                cln.Username = charTransfer.Username;
                cln.AccountID = charTransfer.AccountID;

                pInter = new InterPacket(InterHeader.CharTransferSuccess);
                pInter.Write(cln.AccountID);
                pInter.WriteByte(character.Slot);

                WorldConnection.In.Send(pInter);

                p = new FiestaPacket(SOPCode.CharacterInfo);
                p.Write(character.ID);
                p.WriteString(character.Name, 21);
                p.WriteByte(character.Level);
                p.Write(character.Equipments.ToArray());
                p.WriteString(character.Map, 12);
                p.Write(character.MapX);
                p.Write(character.MapY);
                p.WriteByte(character.MapD);
                p.Fill(18);
                cln.Send(p);

                p = new FiestaPacket(SOPCode.CharacterShape);
                p.WriteByte(character.ClassGender);
                p.WriteByte(character.Hair);
                p.WriteByte(character.HairColor);
                p.WriteByte(character.Face);
                cln.Send(p);

                // Wait for World Server to send WUnk1, WUnk2 and WUnk3.
                //System.Threading.Thread.Sleep(2);

                SendUnkPacket01_02_03_04(cln, pkt);
                SendUnkPacket05_06_07(cln, pkt);
                SendUnkPacket08_09_10_11(cln, pkt);
                SendUnkPacket12_13_14(cln, pkt);
                SendUnkPacket15(cln, pkt);
                SendUnkPacket16(cln, pkt);
                SendUnkPacket17(cln, pkt);
            }
        }

        public static void SendUnkPacket01_02_03_04(FiestaClient cln, FiestaPacket pkt)
        {
            FiestaPacket pFiesta;
            Packet p;

            // Quest Data
            pFiesta = new FiestaPacket(SOPCode.QuestList);
            pFiesta.WriteHex("02 18 0B 00 01 02"); // Quest List Header
            pFiesta.WriteHex("03 00 06 DA 3A CF 55 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00");
            pFiesta.WriteHex("08 00 06 AE 3E CF 55 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00");
            cln.Send(pFiesta);

            p = new Packet();
            p.WriteHex("22 3B 10");
            p.WriteHex("02 18 0B 00 02 00");
            p.WriteHex("20 00 02 00 00 00 01 00 BE 3A CF 55 00 00 00 00 02 00 D3 3A CF 55 00 00 00 00");
            cln.Send(p);

            p = new Packet();
            p.WriteHex("0A CE 10");
            p.WriteHex("02 18 0B 00 01 00");
            p.WriteHex("57 4E");
            cln.Send(p);

            p = new Packet();
            p.WriteHex("08 D7 10 02 18 0B 00 00 00");
            cln.Send(p);
        }

        public static void SendUnkPacket05_06_07(FiestaClient cln, FiestaPacket pkt)
        {
            Packet p;

            p = new Packet();
            p.WriteHex("08 D7 10 03 18 0B 00 00 00 C0 3D 10 00 03 0F 00 03 18 0B 00 0F 00 49 71 00 00 00 00 00 00 00 00 00 00 16 72 00 00 00 00 00 00 00 00 00 00 F6 72 00 00 00 00 00 00 00 00 00 00 1C 73 00 00 00 00 00 00 00 00 00 00 1D 73 00 00 00 00 00 00 00 00 00 00 1E 73 00 00 00 00 00 00 00 00 00 00 20 73 00 00 00 00 00 00 00 00 00 00 45 73 00 00 00 00 00 00 00 00 00 00 4A 73 00 00 00 00 00 00 00 00 00 00 4B 73 00 00 00 00 00 00 00 00 00 00 4C 73 00 00 00 00 00 00 00 00 00 00 AD 73 00 00 00 00 00 00 00 00 00 00 AE 73 00 00 00 00 00 00 00 00 00 00 CC 73 00 00 00 00 00 00 00 00 00 00 CD 73 00 00 00 00 00 00 00 00 00 00 04 3E 10 00 00");

            cln.Send(p);
        }

        public static void SendUnkPacket08_09_10_11(FiestaClient cln, FiestaPacket pkt)
        {
            Packet p;

            p = new Packet();
            p.WriteHex("12 47 10 01 09 55 0C 00 24 B3 B3 00 00 00 00 00 00 00 00 47 47 10 01 08 15 41 0C 20 FA 00 00 00 00 00 00 00 00 FF FF 00 00 00 00 FF FF 00 00 00 00 FF FF 00 00 00 00 FF FF 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 FF FF FF FF FF FF FF FF FF 00 00 00 00 00 00 00 00 0E 47 10 01 0C 81 08 00 30 18 79 FF EC BB 76 05 47 10 00 0F DB");

            cln.Send(p);
        }

        public static void SendUnkPacket12_13_14(FiestaClient cln, FiestaPacket pkt)
        {
            Packet p;

            p = new Packet();
            p.WriteHex("08 49 10 00 00 00 00 00 00 04 4A 10 00 00 06 48 10 FF FF FF FF");

            cln.Send(p);
        }

        public static void SendUnkPacket15(FiestaClient cln, FiestaPacket pkt)
        {
            Packet p;

            p = new Packet();
            p.WriteHex("12 DE 10 00 00 00 00 00 00 00 00 10 27 00 00 00 00 00 00");

            cln.Send(p);
        }

        public static void SendUnkPacket16(FiestaClient cln, FiestaPacket pkt)
        {
            Packet p;

            p = new Packet();
            p.WriteHex("12 1E 44 F0 7F A4 54 F0 99 F3 54 70 48 F2 54 70 31 FA 54");

            cln.Send(p);
        }

        public static void SendUnkPacket17(FiestaClient cln, FiestaPacket pkt)
        {
            Packet p;

            p = new Packet();
            p.WriteHex("F4 02 18 FD 20 00 00 00 00 00 00 00 00 0A 00 00 00 00 00 00 00 06 00 00 00 06 00 00 00 05 00 00 00 05 00 00 00 03 00 00 00 03 00 00 00 01 00 00 00 01 00 00 00 00 00 FF FF FF FF FF FF 01 00 00 00 01 00 00 00 00 00 00 00 0A 00 00 00 00 00 00 00 0D 00 00 00 00 00 00 00 05 00 00 00 00 00 00 00 08 00 00 00 00 00 00 00 03 00 00 00 00 00 00 00 01 00 00 00 00 00 00 00 01 00 00 00 00 00 00 00 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 34 00 00 00 0A 00 00 00 00 00 00 00 00 00 00 00 0F 00 00 00 07 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 11 01 00 00 D4 00 00 00");

            cln.Send(p);
        }

        public static void Disconnect(FiestaClient cln, FiestaPacket pkt)
        {
            cln.Disconnect();
            CIO.Write(CType.Info, "{0} has disconnected", cln.Username);
        }

        public static void SendZoneError(FiestaClient cln, ZoneError err)
        {
            FiestaPacket p;

            p = new FiestaPacket(SOPCode.ZoneError);
            p.Write((ushort)ZoneError.Manipulated);
            p.WriteByte(0);

            cln.Send(p);
        }
    }
}
