﻿using Libs;

namespace Zone
{
    class WorldHandlerMethods
    {
        public static void RequestZoneAssign(InterClient conn, InterPacket pkt)
        {
            InterPacket p;

            conn.IsAuthenticated = true;

            p = new InterPacket(InterHeader.Assign);
            p.WriteByte(Info.In.ID);

            conn.Send(p);
        }

        public static void SendZoneInfo(InterClient conn, InterPacket pkt)
        {
            if (!conn.IsAuthenticated)
            {
                conn.Disconnect();
                return;
            }

            InterPacket p;
            byte zoneID;

            zoneID = Info.In.ID;

            p = new InterPacket(InterHeader.ServerInfo);
            p.WriteString(Info.In.ZoneIP, 16);
            p.Write((ushort)Info.In.ZonePort);

            conn.Send(p);

            CIO.SetTitle("Zone [{0}]", zoneID);
        }

        public static void StoreCharacterTransfer(InterClient conn, InterPacket pkt)
        {
            if (!conn.IsAuthenticated)
            {
                conn.Disconnect();
                return;
            }

            string username;
            string charName;
            ushort sessID;
            uint accID;

            accID = pkt.ReadUInt();
            username = pkt.ReadString(18);
            charName = pkt.ReadString(16);
            sessID = pkt.ReadUShort();

            TransferCharacters.In.Add(accID, username, charName, sessID);
        }

        public static void Disconnect(InterClient conn, InterPacket pkt)
        {
            CIO.Write(CType.Warning, "Zone already assigned");
            conn.Disconnect();
        }
    }
}
