﻿using Libs;
using System;
using ServerDLL;
using System.Collections.Generic;

namespace Zone
{
    class ZoneClients
    {
        public ZoneClients()
        {
            clientList = new List<ZoneClient>();
        }

        private void ZoneClient_PacketReceived(ZoneClient cln, FiestaPacket pkt)
        {
            if (ClientPacketReceived != null)
                ClientPacketReceived(cln, pkt);
        }

        private void ZoneClient_Disconnected(ZoneClient cln)
        {
            cln.PacketReceived -= ZoneClient_PacketReceived;
            cln.Disconnected -= ZoneClient_Disconnected;

            Remove(cln);

            if (ClientDisconnected != null)
                ClientDisconnected(cln);
        }

        public void Add(ZoneClient cln)
        {
            cln.PacketReceived += ZoneClient_PacketReceived;
            cln.Disconnected += ZoneClient_Disconnected;

            clientList.Add(cln);
        }

        public void Remove(ZoneClient cln)
        {
            clientList.Remove(cln);
        }

        public void Dispose()
        {
            ZoneClient[] list = clientList.ToArray();

            foreach (ZoneClient cln in clientList)
                cln.Disconnect();
        }

        public int Count { get { return clientList.Count; } }

        public static ZoneClients In;
        private List<ZoneClient> clientList;

        public event ZoneClientsClientDisconnected ClientDisconnected;
        public delegate void ZoneClientsClientDisconnected(ZoneClient cln);

        public event ZoneClientsClientPacketReceived ClientPacketReceived;
        public delegate void ZoneClientsClientPacketReceived(ZoneClient cln, FiestaPacket pkt);
    }
}
