﻿using Libs;
using System;
using ServerDLL;

namespace Zone
{
    class Program
    {
        private static void Main()
        {
            Console.Title = "Zone";
            CIO.Write(CType.System, "Welcome to the server CP");

            Initialize();

            string[] input = new string[1];
            input[0] = "start";

            while (Handle(input))
            {
                input = CIO.ReadLine().ToLower().Split(' ');
            }

            CIO.Read();
        }

        private static void Initialize()
        {
            ZoneServer = new ZoneServer();
        }

        private static bool Handle(params string[] args)
        {
            switch (args[0])
            {
                case "":
                    return true;

                case "close":
                    ZoneServer.Stop();
                    return false;

                case "start":
                    ZoneServer.Start();
                    return true;

                case "stop":
                    ZoneServer.Stop();
                    return true;

                default:
                    CIO.Write(CType.Warning, "Unknown command");
                    return true;
            }
        }

        private static ZoneServer ZoneServer;
    }
}
