﻿using Libs;
using ServerDLL;

namespace Zone
{
    public class WorldConnection : InterClient
    {
        public WorldConnection(int bufferSize)
            : base(bufferSize)
        {
            Initialize();
        }

        private void Initialize()
        {
            worldPacketHandler = new WorldPacketHandler();

            base.ConnectionFailed += Base_ConnectionFailed;
            base.PacketReceived += Base_PacketReceived;
            base.Disconnected += Base_Disconnected;
            base.Connected += Base_Connected;
        }

        private void Base_PacketReceived(InterClient sender, InterPacket pkt)
        {
            if (!worldPacketHandler.Handle(sender, pkt))
                pkt.IsValid = false;

            if (PacketReceived != null)
                PacketReceived(this, pkt);
        }

        private void Base_ConnectionFailed(InterClient cln)
        {
            if (ConnectionFailed != null)
                ConnectionFailed(this);
        }

        private void Base_Disconnected(InterClient sender)
        {
            if (Disconnected != null)
                Disconnected(this);
        }

        private void Base_Connected(InterClient sender)
        {
            if (Connected != null)
                Connected(this);
        }

        public void RequestAuthentication()
        {
            InterPacket pkt;

            pkt = new InterPacket(InterHeader.Auth);
            pkt.WriteString(Info.In.Token);

            Send(pkt);
        }

        private WorldPacketHandler worldPacketHandler;

        public static WorldConnection In;

        public new event WorldConnectionConnected Connected;
        public delegate void WorldConnectionConnected(WorldConnection sender);

        public new event WorldConnectionConnectFail ConnectionFailed;
        public delegate void WorldConnectionConnectFail(WorldConnection sender);

        public new event WorldConnectionDisconnected Disconnected;
        public delegate void WorldConnectionDisconnected(WorldConnection sender);

        public new event WorldConnectionPacketReceived PacketReceived;
        public delegate void WorldConnectionPacketReceived(WorldConnection sender, InterPacket pkt);
    }
}
