﻿using Libs;
using ServerDLL;

namespace Zone
{
    class ZoneClient : FiestaClient
    {
        public ZoneClient(Client cln, int buffSize)
            : base(cln, buffSize)
        {
            base.PacketReceived += Base_PacketReceived;
            base.Disconnected += Base_Disconnected;
        }

        private void Base_PacketReceived(FiestaClient cln, FiestaPacket pkt)
        {
            if (PacketReceived != null)
                PacketReceived(this, pkt);
        }

        private void Base_Disconnected(FiestaClient cln)
        {
            if (Disconnected != null)
                Disconnected(this);
        }

        public new event WorldClientDisconnected Disconnected;
        public delegate void WorldClientDisconnected(ZoneClient cln);

        public new event WorldClientPacketReceived PacketReceived;
        public delegate void WorldClientPacketReceived(ZoneClient cln, FiestaPacket pkt);
    }
}
