﻿using Libs;
using System;
using ServerDLL;

namespace Zone
{
    class ZoneListener : Listener
    {
        public ZoneListener(string ip, ushort port, int buffSize, int queueMax, int connMax)
            : base(ip, port, buffSize, queueMax, connMax)
        {
            Initialize();
        }

        private void Initialize()
        {
            TransferCharacters.In = new TransferCharacters();
            clientPacketHandler = new ClientPacketHandler();
            ZoneClients.In = new ZoneClients();

            ZoneClients.In.ClientDisconnected += ZoneClients_ClientDisconnected;
            ZoneClients.In.ClientPacketReceived += ZoneClients_ClientPacketReceived;

            base.SessionBegan += Base_SessionBegan;
            base.SessionEnded += Base_SessionEnded;
            base.ClientAccepted += Base_ClientAccepted;
        }

        private void ZoneClients_ClientPacketReceived(ZoneClient cln, FiestaPacket pkt)
        {
            if (!clientPacketHandler.Handle(cln, pkt))
                pkt.IsValid = false;

            if (ClientPacketReceived != null)
                ClientPacketReceived(cln, pkt);
        }

        private void ZoneClients_ClientDisconnected(ZoneClient cln)
        {
            if (ClientDisconnected != null)
                ClientDisconnected(cln);
        }

        private void Base_ClientAccepted(Client cln)
        {
            ZoneClient clnZone;

            clnZone = new ZoneClient(cln, BufferSize);
            ZoneClients.In.Add(clnZone);

            clnZone.BeginReceive();

            if (ClientAccepted != null)
                ClientAccepted(clnZone);
        }

        private void Base_SessionBegan(Listener sender)
        {
            if (SessionBegan != null)
                SessionBegan(this);
        }

        private void Base_SessionEnded(Listener sender)
        {
            ZoneClients.In.Dispose();

            if (SessionEnded != null)
                SessionEnded(this);
        }

        private ClientPacketHandler clientPacketHandler;

        public new event ZoneListenerSessionBegan SessionBegan;
        public delegate void ZoneListenerSessionBegan(ZoneListener sender);

        public new event ZoneListenerSessionEnded SessionEnded;
        public delegate void ZoneListenerSessionEnded(ZoneListener sender);

        public new event ZoneListenerZoneClientAccepted ClientAccepted;
        public delegate void ZoneListenerZoneClientAccepted(ZoneClient cln);

        public new event ZoneListenerClientDisconnected ClientDisconnected;
        public delegate void ZoneListenerClientDisconnected(ZoneClient cln);

        public new event ZoneListenerClientPacketReceived ClientPacketReceived;
        public delegate void ZoneListenerClientPacketReceived(ZoneClient cln, FiestaPacket pkt);
    }
}
