﻿using Libs;
using System;
using ServerDLL;

namespace Zone
{
    class ZoneServer
    {
        public ZoneServer()
        {
            Initialize();
        }

        private void Initialize()
        {
            Info.In = new Info();
            Info.In.Load("ZoneInfo.txt");

            CharacterDB.In = new CharacterDB(
                Info.In.SqlHost,
                Info.In.SqlPort,
                Info.In.SqlDB,
                Info.In.SqlUser,
                Info.In.SqlPass
            );

            zoneListener = new ZoneListener(
                Info.In.ZoneIP,
                Info.In.ZonePort,
                Info.In.BufferSize,
                Info.In.ZoneQueueCapacity,
                Info.In.ZoneClientCapacity
            );

            WorldConnection.In = new WorldConnection(
                Info.In.BufferSize
            );

            zoneListener.SessionBegan += ZoneListener_SessionBegan;
            zoneListener.SessionEnded += ZoneListener_SessionEnded;
            zoneListener.ClientAccepted += ZoneListener_ClientAccepted;
            zoneListener.ClientDisconnected += ZoneListener_ClientDisconnected;
            zoneListener.ClientPacketReceived += ZoneListener_ClientPacketReceived;

            WorldConnection.In.Connected += WorldConnection_Connected;
            WorldConnection.In.Disconnected += WorldConnection_Disconnected;
            WorldConnection.In.Authenticated += WorldConnection_Authenticated;
            WorldConnection.In.PacketReceived += WorldConnection_PacketReceived;
        }

        public void Start()
        {
            if (WorldConnection.In.Connect(Info.In.WorldIP, Info.In.WorldPort))
            {
                WorldConnection.In.RequestAuthentication();
            }
            else CIO.Write(CType.Warning, "Failed to connect to the World Server");
        }

        public void Stop()
        {
            zoneListener.Stop();
        }

        private void ZoneListener_SessionEnded(ZoneListener sender)
        {
            CIO.Write(CType.System, "Stopped listening for zone clients on {0}", sender.Port);
        }

        private void ZoneListener_SessionBegan(ZoneListener sender)
        {
            CIO.Write(CType.System, "Listening for zone clients on {0}", sender.Port);
        }

        private void ZoneListener_ClientPacketReceived(ZoneClient cln, FiestaPacket pkt)
        {
            if (!pkt.IsValid)
            {
                CIO.Write(CType.Warning, "Invalid packet {0} received from {1}", pkt.HexOpCode, cln.IpEndPoint);

                /*System.IO.File.AppendAllText("InvalidPackets.txt", string.Format("[{0}] {1}\nH: {2} | T: {3}\nPos: {4}\nCont: {5}\n\n",
                    System.DateTime.Now.ToLongTimeString(),
                    pkt.HexOpCode,
                    pkt.Header, pkt.Type,
                    cln.Decryptor.Position,
                    Tool.ToString(pkt.ToArray())
                ));*/
            }
        }

        private void ZoneListener_ClientDisconnected(ZoneClient cln)
        {
            CIO.Write(CType.System, "Zone client {0} has disconnected", cln.IpEndPoint);
        }

        private void ZoneListener_ClientAccepted(ZoneClient cln)
        {
            CIO.Write(CType.System, "Zone client {0} has connected", cln.IpEndPoint);
        }

        private void WorldConnection_Connected(WorldConnection sender)
        {
            CIO.Write(CType.System, "Connected to the World Server");
        }

        private void WorldConnection_Disconnected(WorldConnection sender)
        {
            CIO.Write(CType.System, "Disconnected from the World Server");
        }

        private void WorldConnection_Authenticated(InterClient sender)
        {
            CIO.Write(CType.System, "Authenticated by the World Server");
            
            zoneListener.Listen();
        } 

        private void WorldConnection_PacketReceived(WorldConnection sender, InterPacket pkt)
        {
            if (!pkt.IsValid)
                CIO.Write(CType.Warning, "Invalid inter packet received from World Server");
        }       

        private ZoneListener zoneListener;
    }
}
