/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceListener;
import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeProvider;
import com.aelitis.azureus.core.devices.TranscodeTargetListener;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeFileImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeManagerImpl;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.util.ImportExportUtils;
import com.aelitis.azureus.util.StringCompareUtils;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeviceImpl
implements Device {
    private static final String MY_PACKAGE = "com.aelitis.azureus.core.devices.impl";
    private static final TranscodeProfile blank_profile = new TranscodeProfile(){

        public String getUID() {
            return null;
        }

        public String getName() {
            return "blank";
        }

        public String getDescription() {
            return "blank";
        }

        public boolean isStreamable() {
            return false;
        }

        public String getIconURL() {
            return null;
        }

        public int getIconIndex() {
            return 0;
        }

        public String getFileExtension() {
            return null;
        }

        public String getDeviceClassification() {
            return "blank";
        }

        public TranscodeProvider getProvider() {
            return null;
        }
    };
    private static List<Pattern> device_renames = new ArrayList<Pattern>();
    private static final String PP_REND_WORK_DIR = "tt_work_dir";
    private static final String PP_REND_DEF_TRANS_PROF = "tt_def_trans_prof";
    private static final String PP_REND_TRANS_REQ = "tt_req";
    private static final String PP_REND_TRANS_CACHE = "tt_always_cache";
    private static final String PP_REND_RSS_PUB = "tt_rss_pub";
    protected static final String PP_REND_SHOW_CAT = "tt_show_cat";
    protected static final String PP_REND_CLASSIFICATION = "tt_rend_class";
    protected static final String PP_IP_ADDRESS = "rend_ip";
    protected static final String PP_DONT_AUTO_HIDE = "rend_no_ah";
    protected static final String TP_IP_ADDRESS = "DeviceUPnPImpl:ip";
    protected static final String PP_FILTER_FILES = "rend_filter";
    protected static final String PP_RESTRICT_ACCESS = "restrict_access";
    protected static final String PP_COPY_OUTSTANDING = "copy_outstanding";
    protected static final String PP_AUTO_START = "auto_start";
    protected static final String PP_COPY_TO_FOLDER = "copy_to_folder";
    protected static final String PP_AUTO_COPY = "auto_copy";
    protected static final String PP_EXPORTABLE = "exportable";
    protected static final String PP_LIVENESS_DETECTABLE = "live_det";
    protected static final String PP_TIVO_MACHINE = "tivo_machine";
    protected static final String PP_OD_ENABLED = "od_enabled";
    protected static final String PP_OD_SHOWN_FTUX = "od_shown_ftux";
    protected static final String PP_OD_MANUFACTURER = "od_manufacturer";
    protected static final String PP_OD_STATE_CACHE = "od_state_cache";
    protected static final String PP_OD_XFER_CACHE = "od_xfer_cache";
    protected static final String PP_OD_UPNP_DISC_CACHE = "od_upnp_cache";
    protected static final boolean PR_AUTO_START_DEFAULT = true;
    protected static final boolean PP_AUTO_COPY_DEFAULT = false;
    private static final String GENERIC = "generic";
    private static final Object KEY_FILE_ALLOC_ERROR;
    private DeviceManagerImpl manager;
    private int type;
    private String uid;
    private String secondary_uid;
    private String classification;
    private String name;
    private boolean manual;
    private boolean hidden;
    private boolean auto_hidden;
    private boolean isGenericUSB;
    private long last_seen;
    private boolean can_remove = true;
    private boolean tagged;
    private int busy_count;
    private boolean online;
    private boolean transcoding;
    private Map<String, Object> persistent_properties = new LightHashMap<String, Object>(1);
    private Map<Object, Object> transient_properties = new LightHashMap<Object, Object>(1);
    private long device_files_last_mod;
    private boolean device_files_dirty;
    private Map<String, Map<String, ?>> device_files;
    private WeakReference<Map<String, Map<String, ?>>> device_files_ref;
    private CopyOnWriteList<TranscodeTargetListener> listeners = new CopyOnWriteList();
    private Map<Object, String> errors = new HashMap<Object, String>();
    private Map<Object, String> infos = new HashMap<Object, String>();
    private CopyOnWriteList<DeviceListener> device_listeners;
    private String image_id;
    private boolean isNameAutomatic;

    protected static DeviceImpl importFromBEncodedMapStatic(DeviceManagerImpl manager, Map map) throws IOException {
        String impl = ImportExportUtils.importString(map, "_impl");
        if (impl.startsWith(".")) {
            impl = MY_PACKAGE + impl;
        }
        try {
            Class<?> cla = Class.forName(impl);
            Constructor<?> cons = cla.getDeclaredConstructor(DeviceManagerImpl.class, Map.class);
            cons.setAccessible(true);
            return (DeviceImpl)cons.newInstance(manager, map);
        }
        catch (Throwable e) {
            Debug.out("Can't construct device for " + impl, e);
            throw new IOException("Construction failed: " + Debug.getNestedExceptionMessage(e));
        }
    }

    private static String modifyDeviceDisplayName(String name) {
        for (Pattern p : device_renames) {
            Matcher m = p.matcher(name);
            if (!m.find()) continue;
            String new_name = m.group(1);
            return new_name;
        }
        if (name.startsWith("WDTVLIVE")) {
            name = "WD TV Live";
        }
        return name;
    }

    protected DeviceImpl(DeviceManagerImpl _manager, int _type, String _uid, String _classification, boolean _manual) {
        this(_manager, _type, _uid, _classification, _manual, _classification);
    }

    protected DeviceImpl(DeviceManagerImpl _manager, int _type, String _uid, String _classification, boolean _manual, String _name) {
        this.manager = _manager;
        this.type = _type;
        this.uid = _uid;
        this.classification = _classification;
        this.name = DeviceImpl.modifyDeviceDisplayName(_name);
        this.manual = _manual;
        this.isNameAutomatic = true;
    }

    protected DeviceImpl(DeviceManagerImpl _manager, Map map) throws IOException {
        this.manager = _manager;
        this.type = (int)ImportExportUtils.importLong(map, "_type");
        this.uid = ImportExportUtils.importString(map, "_uid");
        this.classification = ImportExportUtils.importString(map, "_name");
        this.name = ImportExportUtils.importString(map, "_lname");
        this.isNameAutomatic = ImportExportUtils.importBoolean(map, "_autoname", true);
        this.image_id = ImportExportUtils.importString(map, "_image_id");
        if (this.name == null) {
            this.name = this.classification;
        }
        if (ImportExportUtils.importLong(map, "_rn", 0L) == 0L) {
            this.name = DeviceImpl.modifyDeviceDisplayName(this.name);
        }
        this.secondary_uid = ImportExportUtils.importString(map, "_suid");
        this.last_seen = ImportExportUtils.importLong(map, "_ls");
        this.hidden = ImportExportUtils.importBoolean(map, "_hide");
        this.auto_hidden = ImportExportUtils.importBoolean(map, "_ahide");
        this.can_remove = ImportExportUtils.importBoolean(map, "_rm", true);
        this.isGenericUSB = ImportExportUtils.importBoolean(map, "_genericUSB");
        this.manual = ImportExportUtils.importBoolean(map, "_man");
        this.tagged = ImportExportUtils.importBoolean(map, "_tag", false);
        if (map.containsKey("_pprops")) {
            this.persistent_properties = (Map)map.get("_pprops");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportToBEncodedMap(Map map, boolean for_export) throws IOException {
        HashMap<String, Object> pp_copy;
        String cla = this.getClass().getName();
        if (cla.startsWith(MY_PACKAGE)) {
            cla = cla.substring(MY_PACKAGE.length());
        }
        ImportExportUtils.exportString(map, "_impl", cla);
        ImportExportUtils.exportLong(map, "_type", this.type);
        ImportExportUtils.exportString(map, "_uid", this.uid);
        ImportExportUtils.exportString(map, "_name", this.classification);
        ImportExportUtils.exportBoolean(map, "_autoname", this.isNameAutomatic);
        ImportExportUtils.exportLong(map, "_rn", 1L);
        ImportExportUtils.exportString(map, "_lname", this.name);
        ImportExportUtils.exportString(map, "_image_id", this.image_id);
        if (this.secondary_uid != null) {
            ImportExportUtils.exportString(map, "_suid", this.secondary_uid);
        }
        if (!for_export) {
            ImportExportUtils.exportLong(map, "_ls", this.last_seen);
            ImportExportUtils.exportBoolean(map, "_hide", this.hidden);
            ImportExportUtils.exportBoolean(map, "_ahide", this.auto_hidden);
        }
        ImportExportUtils.exportBoolean(map, "_rm", this.can_remove);
        ImportExportUtils.exportBoolean(map, "_genericUSB", this.isGenericUSB);
        ImportExportUtils.exportBoolean(map, "_man", this.manual);
        if (this.tagged) {
            ImportExportUtils.exportBoolean(map, "_tag", this.tagged);
        }
        Map<String, Object> map2 = this.persistent_properties;
        synchronized (map2) {
            pp_copy = new HashMap<String, Object>(this.persistent_properties);
        }
        if (for_export) {
            pp_copy.remove(PP_IP_ADDRESS);
            pp_copy.remove(PP_COPY_OUTSTANDING);
            pp_copy.remove(PP_COPY_TO_FOLDER);
            pp_copy.remove(PP_REND_WORK_DIR);
            map.put("_pprops", pp_copy);
        } else {
            map.put("_pprops", pp_copy);
        }
    }

    protected boolean updateFrom(DeviceImpl other, boolean is_alive) {
        if (this.type != other.type) {
            Debug.out("Inconsistent update operation (type)");
            return false;
        }
        String o_uid = other.uid;
        if (!this.uid.equals(o_uid)) {
            String o_suid = other.secondary_uid;
            boolean borked = false;
            if (this.secondary_uid == null && o_suid == null) {
                borked = true;
            } else if (!(this.secondary_uid == null && this.uid.equals(o_suid) || o_suid == null && o_uid.equals(this.secondary_uid) || o_suid != null && o_suid.equals(this.secondary_uid))) {
                borked = true;
            }
            if (borked) {
                Debug.out("Inconsistent update operation (uids)");
                return false;
            }
        }
        if (!this.classification.equals(other.classification)) {
            this.classification = other.classification;
            this.setDirty();
        }
        if (this.manual != other.manual) {
            this.manual = other.manual;
            this.setDirty();
        }
        if (is_alive) {
            this.alive();
        }
        return true;
    }

    @Override
    public void setExportable(boolean b) {
        this.setPersistentBooleanProperty(PP_EXPORTABLE, b);
    }

    @Override
    public boolean isExportable() {
        return this.getPersistentBooleanProperty(PP_EXPORTABLE, false);
    }

    @Override
    public VuzeFile getVuzeFile() throws IOException {
        return this.manager.exportVuzeFile(this);
    }

    protected void initialise() {
        this.updateStatus(0);
    }

    protected void destroy() {
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getID() {
        return this.uid;
    }

    protected void setSecondaryID(String str) {
        this.secondary_uid = str;
    }

    protected String getSecondaryID() {
        return this.secondary_uid;
    }

    @Override
    public String getImageID() {
        return this.image_id;
    }

    @Override
    public void setImageID(String id) {
        if (!StringCompareUtils.equals(id, this.image_id)) {
            this.image_id = id;
            this.setDirty();
        }
    }

    public Device getDevice() {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String _name, boolean isAutomaticName) {
        if (!this.name.equals(_name) || this.isNameAutomatic != isAutomaticName) {
            this.name = _name;
            this.isNameAutomatic = isAutomaticName;
            this.setDirty();
        }
    }

    @Override
    public boolean isNameAutomatic() {
        return this.isNameAutomatic;
    }

    @Override
    public String getClassification() {
        String explicit_classification = this.getPersistentStringProperty(PP_REND_CLASSIFICATION, null);
        if (explicit_classification != null) {
            return explicit_classification;
        }
        return this.classification;
    }

    @Override
    public String getShortDescription() {
        if (this.getRendererSpecies() == 3) {
            return "iPad, iPhone, iPod, Apple TV";
        }
        return null;
    }

    public int getRendererSpecies() {
        if (this.classification.equalsIgnoreCase("PS3")) {
            return 1;
        }
        if (this.classification.equalsIgnoreCase("XBox 360")) {
            return 2;
        }
        if (this.classification.equalsIgnoreCase("Wii")) {
            return 4;
        }
        if (this.classification.equalsIgnoreCase("Browser")) {
            return 5;
        }
        return 6;
    }

    protected String getDeviceClassification() {
        switch (this.getRendererSpecies()) {
            case 1: {
                return "sony.PS3";
            }
            case 2: {
                return "microsoft.XBox";
            }
            case 4: {
                return "nintendo.Wii";
            }
            case 5: {
                return "browser.generic";
            }
            case 6: {
                if (this.isManual()) {
                    return this.classification;
                }
                if (this.classification.equals("sony.PSP") || this.classification.startsWith("tivo.")) {
                    return this.classification;
                }
                String str = this.getPersistentStringProperty(PP_REND_CLASSIFICATION, null);
                if (str != null) {
                    return str;
                }
                return GENERIC;
            }
        }
        Debug.out("Unknown classification");
        return GENERIC;
    }

    public boolean isNonSimple() {
        return this.getClassification().startsWith("ms_wmp.") || this.isGenericUSB();
    }

    @Override
    public boolean isManual() {
        return this.manual;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(boolean h) {
        if (h != this.hidden) {
            this.hidden = h;
            this.setDirty();
        }
        if (this.auto_hidden) {
            this.auto_hidden = false;
            this.setDirty();
        }
    }

    public boolean isAutoHidden() {
        return this.auto_hidden;
    }

    public void setAutoHidden(boolean h) {
        if (h != this.auto_hidden) {
            this.auto_hidden = h;
            this.setDirty();
        }
    }

    @Override
    public boolean isTagged() {
        return this.tagged;
    }

    @Override
    public void setTagged(boolean t) {
        if (t != this.tagged) {
            this.tagged = t;
            this.setDirty();
        }
    }

    @Override
    public boolean isGenericUSB() {
        return this.isGenericUSB;
    }

    @Override
    public void setGenericUSB(boolean is) {
        if (is != this.isGenericUSB) {
            this.isGenericUSB = is;
            this.setDirty();
        }
    }

    public long getLastSeen() {
        return this.last_seen;
    }

    @Override
    public void alive() {
        this.last_seen = SystemTime.getCurrentTime();
        if (!this.online) {
            this.online = true;
            this.setDirty(false);
        }
    }

    @Override
    public boolean isLivenessDetectable() {
        return !this.manual;
    }

    @Override
    public boolean isAlive() {
        return this.online;
    }

    protected void dead() {
        if (this.online) {
            this.online = false;
            this.setDirty(false);
        }
    }

    @Override
    public URL getWikiURL() {
        return null;
    }

    protected void setDirty() {
        this.setDirty(true);
    }

    protected void setDirty(boolean save_changes) {
        this.manager.configDirty(this, save_changes);
    }

    protected void updateStatus(int tick_count) {
    }

    @Override
    public void requestAttention() {
        this.manager.requestAttention(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFileCount() {
        try {
            DeviceImpl deviceImpl = this;
            synchronized (deviceImpl) {
                if (this.device_files == null) {
                    this.loadDeviceFile();
                }
                return this.device_files.size();
            }
        }
        catch (Throwable e) {
            Debug.out("Failed to load device file", e);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranscodeFileImpl[] getFiles() {
        try {
            DeviceImpl deviceImpl = this;
            synchronized (deviceImpl) {
                if (this.device_files == null) {
                    this.loadDeviceFile();
                }
                ArrayList<TranscodeFileImpl> result = new ArrayList<TranscodeFileImpl>();
                Iterator<Map.Entry<String, Map<String, ?>>> it = this.device_files.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Map<String, ?>> entry = it.next();
                    try {
                        TranscodeFileImpl tf = new TranscodeFileImpl(this, entry.getKey(), this.device_files);
                        result.add(tf);
                    }
                    catch (Throwable e) {
                        it.remove();
                        this.log("Failed to deserialise transcode file", e);
                    }
                }
                return result.toArray(new TranscodeFileImpl[result.size()]);
            }
        }
        catch (Throwable e) {
            Debug.out(e);
            return new TranscodeFileImpl[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranscodeFileImpl allocateFile(TranscodeProfile profile, boolean no_xcode, DiskManagerFileInfo file, boolean for_job) throws TranscodeException {
        TranscodeFileImpl result = null;
        this.setError(KEY_FILE_ALLOC_ERROR, null);
        try {
            DeviceImpl deviceImpl = this;
            synchronized (deviceImpl) {
                String key;
                if (this.device_files == null) {
                    this.loadDeviceFile();
                }
                if (this.device_files.containsKey(key = ByteFormatter.encodeString(file.getDownloadHash()) + ":" + file.getIndex() + ":" + profile.getUID())) {
                    try {
                        result = new TranscodeFileImpl(this, key, this.device_files);
                    }
                    catch (Throwable e) {
                        this.device_files.remove(key);
                        this.log("Failed to deserialise transcode file", e);
                    }
                }
                if (result == null) {
                    String ext = profile.getFileExtension();
                    String target_file = file.getFile(true).getName();
                    if (ext != null && !no_xcode) {
                        int pos = target_file.lastIndexOf(46);
                        if (pos != -1) {
                            target_file = target_file.substring(0, pos);
                        }
                        target_file = target_file + ext;
                    }
                    target_file = this.allocateUniqueFileName(target_file);
                    File output_file = this.getWorkingDirectory(true);
                    if (!output_file.canWrite()) {
                        throw new TranscodeException("Can't write to transcode folder '" + output_file.getAbsolutePath() + "'");
                    }
                    output_file = new File(output_file.getAbsoluteFile(), target_file);
                    result = new TranscodeFileImpl(this, key, profile.getName(), this.device_files, output_file, for_job);
                    result.setSourceFile(file);
                    this.device_files_last_mod = SystemTime.getMonotonousTime();
                    this.device_files_dirty = true;
                } else {
                    result.setSourceFile(file);
                    result.setProfileName(profile.getName());
                }
            }
        }
        catch (Throwable e) {
            this.setError(KEY_FILE_ALLOC_ERROR, Debug.getNestedExceptionMessage(e));
            throw new TranscodeException("File allocation failed", e);
        }
        for (TranscodeTargetListener l : this.listeners) {
            try {
                l.fileAdded(result);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        return result;
    }

    protected String allocateUniqueFileName(String str) {
        HashSet<String> name_set = new HashSet<String>();
        for (Map<String, ?> entry : this.device_files.values()) {
            try {
                name_set.add(new File(ImportExportUtils.importString(entry, "file")).getName());
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        for (int i = 0; i < 1024; ++i) {
            String test_name;
            String string = test_name = i == 0 ? str : i + "_" + str;
            if (name_set.contains(test_name)) continue;
            str = test_name;
            break;
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void revertFileName(TranscodeFileImpl tf) throws TranscodeException {
        File cache_file = tf.getCacheFile();
        if (cache_file.exists()) {
            Debug.out("Cache file already allocated, can't rename");
            return;
        }
        File source_file = tf.getSourceFile().getFile(true);
        String original_name = source_file.getName();
        int pos = original_name.indexOf(46);
        if (pos == -1) {
            return;
        }
        String cf_name = cache_file.getName();
        if (cf_name.endsWith(original_name.substring(pos))) {
            return;
        }
        try {
            DeviceImpl deviceImpl = this;
            synchronized (deviceImpl) {
                if (this.device_files == null) {
                    this.loadDeviceFile();
                }
                String reverted_name = this.allocateUniqueFileName(original_name);
                tf.setCacheFile(new File(cache_file.getParentFile(), reverted_name));
            }
        }
        catch (Throwable e) {
            throw new TranscodeException("File name revertion failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranscodeFileImpl lookupFile(TranscodeProfile profile, DiskManagerFileInfo file) {
        try {
            DeviceImpl deviceImpl = this;
            synchronized (deviceImpl) {
                String key;
                if (this.device_files == null) {
                    this.loadDeviceFile();
                }
                if (this.device_files.containsKey(key = ByteFormatter.encodeString(file.getDownloadHash()) + ":" + file.getIndex() + ":" + profile.getUID())) {
                    try {
                        return new TranscodeFileImpl(this, key, this.device_files);
                    }
                    catch (Throwable e) {
                        this.device_files.remove(key);
                        this.log("Failed to deserialise transcode file", e);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TranscodeFileImpl getTranscodeFile(String key) {
        try {
            DeviceImpl deviceImpl = this;
            synchronized (deviceImpl) {
                if (this.device_files == null) {
                    this.loadDeviceFile();
                }
                if (this.device_files.containsKey(key)) {
                    try {
                        return new TranscodeFileImpl(this, key, this.device_files);
                    }
                    catch (Throwable e) {
                        this.device_files.remove(key);
                        this.log("Failed to deserialise transcode file", e);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public File getWorkingDirectory() {
        return this.getWorkingDirectory(false);
    }

    public File getWorkingDirectory(boolean persist) {
        File f_result;
        String result = this.getPersistentStringProperty(PP_REND_WORK_DIR);
        if (result.length() == 0) {
            File f = this.manager.getDefaultWorkingDirectory(persist);
            if (persist) {
                f.mkdirs();
            }
            String name = FileUtil.convertOSSpecificChars(this.getName(), true);
            for (int i = 0; i < 1024; ++i) {
                String test_name = name + (i == 0 ? "" : "_" + i);
                File test_file = new File(f, test_name);
                if (test_file.exists()) continue;
                f = test_file;
                break;
            }
            result = f.getAbsolutePath();
            if (persist) {
                this.setPersistentStringProperty(PP_REND_WORK_DIR, result);
            }
        }
        if (!(f_result = new File(result)).exists() && persist) {
            f_result.mkdirs();
        }
        return f_result;
    }

    public void setWorkingDirectory(File directory) {
        this.setPersistentStringProperty(PP_REND_WORK_DIR, directory.getAbsolutePath());
    }

    protected void resetWorkingDirectory() {
        this.setPersistentStringProperty(PP_REND_WORK_DIR, "");
    }

    public TranscodeProfile[] getTranscodeProfiles() {
        return this.getTranscodeProfiles(true);
    }

    @Override
    public TranscodeProfile[] getDirectTranscodeProfiles() {
        return this.getTranscodeProfiles(false);
    }

    public TranscodeProfile[] getTranscodeProfiles(boolean walkup) {
        String classification = this.getDeviceClassification();
        TranscodeProfile[] result = this.getTranscodeProfiles(classification);
        if (!walkup || result.length > 0) {
            return result;
        }
        try {
            String[] bits = Constants.PAT_SPLIT_DOT.split(classification);
            for (int i = bits.length - 1; i >= 1; --i) {
                String c = "";
                for (int j = 0; j < i; ++j) {
                    c = c + (c.length() == 0 ? "" : ".") + bits[j];
                }
                result = this.getTranscodeProfiles(c = c + (c.length() == 0 ? "" : ".") + GENERIC);
                if (result.length <= 0) continue;
                return result;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return new TranscodeProfile[0];
    }

    private TranscodeProfile[] getTranscodeProfiles(String classification) {
        TranscodeProvider[] providers;
        ArrayList<TranscodeProfile> profiles = new ArrayList<TranscodeProfile>();
        DeviceManagerImpl dm = this.getManager();
        for (TranscodeProvider provider2 : providers = dm.getProviders()) {
            TranscodeProfile[] ps = provider2.getProfiles(classification);
            if (providers.length == 1) {
                return ps;
            }
            profiles.addAll(Arrays.asList(ps));
        }
        return profiles.toArray(new TranscodeProfile[profiles.size()]);
    }

    public TranscodeProfile getDefaultTranscodeProfile() {
        String uid = this.getPersistentStringProperty(PP_REND_DEF_TRANS_PROF);
        DeviceManagerImpl dm = this.getManager();
        TranscodeManagerImpl tm = dm.getTranscodeManager();
        TranscodeProfile profile = tm.getProfileFromUID(uid);
        if (profile != null) {
            return profile;
        }
        return null;
    }

    public void setDefaultTranscodeProfile(TranscodeProfile profile) {
        if (profile == null) {
            this.removePersistentProperty(PP_REND_DEF_TRANS_PROF);
        } else {
            this.setPersistentStringProperty(PP_REND_DEF_TRANS_PROF, profile.getUID());
        }
    }

    public TranscodeProfile getBlankProfile() {
        return blank_profile;
    }

    protected void setTranscoding(boolean _transcoding) {
        this.transcoding = _transcoding;
        this.manager.deviceChanged(this, false);
    }

    public boolean isTranscoding() {
        return this.transcoding;
    }

    public int getTranscodeRequirement() {
        return this.getPersistentIntProperty(PP_REND_TRANS_REQ, 2);
    }

    public void setTranscodeRequirement(int req) {
        this.setPersistentIntProperty(PP_REND_TRANS_REQ, req);
    }

    public boolean isAudioCompatible(TranscodeFile file) {
        return false;
    }

    public boolean getAlwaysCacheFiles() {
        return this.getPersistentBooleanProperty(PP_REND_TRANS_CACHE, false);
    }

    public void setAlwaysCacheFiles(boolean always_cache) {
        this.setPersistentBooleanProperty(PP_REND_TRANS_CACHE, always_cache);
    }

    public boolean isRSSPublishEnabled() {
        return this.getPersistentBooleanProperty(PP_REND_RSS_PUB, true);
    }

    public void setRSSPublishEnabled(boolean enabled) {
        this.setPersistentBooleanProperty(PP_REND_RSS_PUB, enabled);
    }

    @Override
    public String[][] getDisplayProperties() {
        ArrayList<String[]> dp = new ArrayList<String[]>();
        this.getDisplayProperties(dp);
        String[][] res = new String[2][dp.size()];
        int pos = 0;
        for (String[] entry : dp) {
            res[0][pos] = entry[0];
            res[1][pos] = entry[1];
            ++pos;
        }
        return res;
    }

    protected void getDisplayProperties(List<String[]> dp) {
        if (!this.name.equals(this.classification)) {
            this.addDP(dp, "TableColumn.header.name", this.name);
        }
        this.addDP(dp, "TableColumn.header.class", this.getClassification().toLowerCase());
        this.addDP(dp, "!UID!", this.getID());
        if (!this.manual) {
            this.addDP(dp, "azbuddy.ui.table.online", this.online);
            this.addDP(dp, "device.lastseen", this.last_seen == 0L ? "" : new SimpleDateFormat().format(new Date(this.last_seen)));
        }
    }

    protected void getTTDisplayProperties(List<String[]> dp) {
        this.addDP(dp, "devices.xcode.working_dir", this.getWorkingDirectory(false).getAbsolutePath());
        this.addDP(dp, "devices.xcode.prof_def", this.getDefaultTranscodeProfile());
        this.addDP(dp, "devices.xcode.profs", this.getTranscodeProfiles());
        int tran_req = this.getTranscodeRequirement();
        String tran_req_str = tran_req == 3 ? "device.xcode.always" : (tran_req == 1 ? "device.xcode.never" : "device.xcode.whenreq");
        this.addDP(dp, "device.xcode", MessageText.getString(tran_req_str));
        if (this.errors.size() > 0) {
            String key = "ManagerItem.error";
            for (String error : this.errors.values()) {
                this.addDP(dp, key, error);
                key = "";
            }
        }
    }

    protected void addDP(List<String[]> dp, String name, String value) {
        dp.add(new String[]{name, value});
    }

    protected void addDP(List<String[]> dp, String name, File value) {
        dp.add(new String[]{name, value == null ? "" : value.getAbsolutePath()});
    }

    protected void addDP(List<String[]> dp, String name, String[] values) {
        String value = "";
        for (String v : values) {
            value = value + (value.length() == 0 ? "" : ",") + v;
        }
        dp.add(new String[]{name, value});
    }

    protected void addDP(List<String[]> dp, String name, boolean value) {
        dp.add(new String[]{name, MessageText.getString(value ? "GeneralView.yes" : "GeneralView.no")});
    }

    protected void addDP(List<String[]> dp, String name, TranscodeProfile value) {
        this.addDP(dp, name, value == null ? "" : value.getName());
    }

    protected void addDP(List<String[]> dp, String name, TranscodeProfile[] values) {
        String[] names = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            names[i] = values[i].getName();
        }
        this.addDP(dp, name, names);
    }

    @Override
    public void setCanRemove(boolean can) {
        if (this.can_remove != can) {
            this.can_remove = can;
            this.setDirty();
        }
    }

    @Override
    public boolean canRemove() {
        return this.can_remove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBusy() {
        if (this.isTranscoding()) {
            return true;
        }
        DeviceImpl deviceImpl = this;
        synchronized (deviceImpl) {
            return this.busy_count > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBusy(boolean busy) {
        boolean changed = false;
        DeviceImpl deviceImpl = this;
        synchronized (deviceImpl) {
            changed = busy ? this.busy_count++ == 0 : this.busy_count-- == 1;
        }
        if (changed) {
            this.manager.deviceChanged(this, false);
        }
    }

    @Override
    public void remove() {
        this.manager.removeDevice(this);
    }

    public String getPersistentStringProperty(String prop) {
        return this.getPersistentStringProperty(prop, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPersistentStringProperty(String prop, String def) {
        Map<String, Object> map = this.persistent_properties;
        synchronized (map) {
            try {
                byte[] value = (byte[])this.persistent_properties.get(prop);
                if (value == null) {
                    return def;
                }
                return new String(value, "UTF-8");
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                return def;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPersistentStringProperty(String prop, String value) {
        boolean dirty = false;
        Map<String, Object> map = this.persistent_properties;
        synchronized (map) {
            String existing = this.getPersistentStringProperty(prop);
            if (!existing.equals(value)) {
                try {
                    if (value == null) {
                        this.persistent_properties.remove(prop);
                    } else {
                        this.persistent_properties.put(prop, value.getBytes("UTF-8"));
                    }
                    dirty = true;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        if (dirty) {
            this.setDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Map<String, T> getPersistentMapProperty(String prop, Map<String, T> def) {
        Map<String, Object> map = this.persistent_properties;
        synchronized (map) {
            try {
                Map value = (Map)this.persistent_properties.get(prop);
                if (value == null) {
                    return def;
                }
                return value;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                return def;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setPersistentMapProperty(String prop, Map<String, T> value) {
        boolean dirty = false;
        Map<String, Object> map = this.persistent_properties;
        synchronized (map) {
            Map<String, T> existing = this.getPersistentMapProperty(prop, null);
            if (!BEncoder.mapsAreIdentical(value, existing)) {
                try {
                    if (value == null) {
                        this.persistent_properties.remove(prop);
                    } else {
                        this.persistent_properties.put(prop, value);
                    }
                    dirty = true;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        if (dirty) {
            this.setDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePersistentProperty(String prop) {
        boolean dirty = false;
        Map<String, Object> map = this.persistent_properties;
        synchronized (map) {
            String existing = this.getPersistentStringProperty(prop);
            if (existing != null) {
                try {
                    this.persistent_properties.remove(prop);
                    dirty = true;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        if (dirty) {
            this.setDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getError() {
        Map<Object, String> map = this.errors;
        synchronized (map) {
            if (this.errors.size() == 0) {
                return null;
            }
            String res = "";
            for (String s : this.errors.values()) {
                res = res + (res.length() == 0 ? "" : "; ") + s;
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setError(Object key, String error) {
        String existing;
        boolean changed = false;
        if (error == null || error.length() == 0) {
            Map<Object, String> map = this.errors;
            synchronized (map) {
                changed = this.errors.remove(key) != null;
            }
        }
        Map<Object, String> map = this.errors;
        synchronized (map) {
            existing = this.errors.put(key, error);
        }
        boolean bl = changed = existing == null || !existing.equals(error);
        if (changed) {
            this.manager.deviceChanged(this, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInfo() {
        Map<Object, String> map = this.infos;
        synchronized (map) {
            if (this.infos.size() == 0) {
                return null;
            }
            String res = "";
            for (String s : this.infos.values()) {
                res = res + (res.length() == 0 ? "" : "; ") + s;
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInfo(Object key, String info) {
        String existing;
        boolean changed = false;
        if (info == null || info.length() == 0) {
            Map<Object, String> map = this.infos;
            synchronized (map) {
                changed = this.infos.remove(key) != null;
            }
        }
        Map<Object, String> map = this.infos;
        synchronized (map) {
            existing = this.infos.put(key, info);
        }
        boolean bl = changed = existing == null || !existing.equals(info);
        if (changed) {
            this.manager.deviceChanged(this, false);
        }
    }

    @Override
    public String getStatus() {
        if (this.isLivenessDetectable()) {
            if (this.isAlive()) {
                return MessageText.getString("device.status.online");
            }
            return MessageText.getString("device.od.error.notfound");
        }
        return null;
    }

    public boolean getPersistentBooleanProperty(String prop, boolean def) {
        return this.getPersistentStringProperty(prop, def ? "true" : "false").equals("true");
    }

    public void setPersistentBooleanProperty(String prop, boolean value) {
        this.setPersistentStringProperty(prop, value ? "true" : "false");
    }

    public int getPersistentIntProperty(String prop, int def) {
        return Integer.parseInt(this.getPersistentStringProperty(prop, String.valueOf(def)));
    }

    public void setPersistentIntProperty(String prop, int value) {
        this.setPersistentStringProperty(prop, String.valueOf(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPersistentStringListProperty(String prop) {
        Map<String, Object> map = this.persistent_properties;
        synchronized (map) {
            try {
                List values = (List)this.persistent_properties.get(prop);
                if (values == null) {
                    return new String[0];
                }
                String[] res = new String[values.size()];
                int pos = 0;
                for (byte[] value : values) {
                    res[pos++] = new String(value, "UTF-8");
                }
                return res;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                return new String[0];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPersistentStringListProperty(String prop, String[] values) {
        boolean dirty = false;
        Map<String, Object> map = this.persistent_properties;
        synchronized (map) {
            try {
                ArrayList<byte[]> values_list = new ArrayList<byte[]>();
                for (String value : values) {
                    values_list.add(value.getBytes("UTF-8"));
                }
                this.persistent_properties.put(prop, values_list);
                dirty = true;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (dirty) {
            this.setDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransientProperty(Object key, Object value) {
        Map<Object, Object> map = this.transient_properties;
        synchronized (map) {
            if (value == null) {
                this.transient_properties.remove(key);
            } else {
                this.transient_properties.put(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getTransientProperty(Object key) {
        Map<Object, Object> map = this.transient_properties;
        synchronized (map) {
            return this.transient_properties.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransientProperty(Object key1, Object key2, Object value) {
        Map<Object, Object> map = this.transient_properties;
        synchronized (map) {
            HashMap<Object, Object> l1 = (HashMap<Object, Object>)this.transient_properties.get(key1);
            if (l1 == null) {
                if (value == null) {
                    return;
                }
                l1 = new HashMap<Object, Object>();
                this.transient_properties.put(key1, l1);
            }
            if (value == null) {
                l1.remove(key2);
                if (l1.size() == 0) {
                    this.transient_properties.remove(key1);
                }
            } else {
                l1.put(key2, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getTransientProperty(Object key1, Object key2) {
        Map<Object, Object> map = this.transient_properties;
        synchronized (map) {
            Map l1 = (Map)this.transient_properties.get(key1);
            if (l1 == null) {
                return null;
            }
            return l1.get(key2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        DeviceImpl deviceImpl = this;
        synchronized (deviceImpl) {
            if (this.device_files_dirty) {
                this.saveDeviceFile();
            }
        }
    }

    protected void loadDeviceFile() throws IOException {
        this.device_files_last_mod = SystemTime.getMonotonousTime();
        if (this.device_files_ref != null) {
            this.device_files = (Map)this.device_files_ref.get();
        }
        if (this.device_files == null) {
            Map map = FileUtil.readResilientFile(this.getDeviceFile());
            this.device_files = (Map)map.get("files");
            if (this.device_files == null) {
                this.device_files = new HashMap();
            }
            this.device_files_ref = new WeakReference(this.device_files);
            this.log("Loaded device file for " + this.getName() + ": files=" + this.device_files.size());
        }
        int GC_TIME = 15000;
        new DelayedEvent("Device:gc", 15000L, new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                DeviceImpl deviceImpl = DeviceImpl.this;
                synchronized (deviceImpl) {
                    if (SystemTime.getMonotonousTime() - DeviceImpl.this.device_files_last_mod >= 15000L) {
                        if (DeviceImpl.this.device_files_dirty) {
                            DeviceImpl.this.saveDeviceFile();
                        }
                        DeviceImpl.this.device_files = null;
                    } else {
                        new DelayedEvent("Device:gc2", 15000L, this);
                    }
                }
            }
        });
    }

    protected URL getStreamURL(TranscodeFileImpl file, String host) {
        return this.manager.getStreamURL(file, host);
    }

    protected String getMimeType(TranscodeFileImpl file) {
        return this.manager.getMimeType(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteFile(TranscodeFileImpl file, boolean delete_contents, boolean remove) throws TranscodeException {
        Object f;
        if (file.isDeleted()) {
            return;
        }
        if (delete_contents) {
            f = file.getCacheFile();
            int time = 0;
            while (((File)f).exists() && !((File)f).delete()) {
                if (time > 3000) {
                    this.log("Failed to remove file '" + ((File)f).getAbsolutePath() + "'");
                    break;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                time += 500;
            }
        }
        if (remove) {
            try {
                for (TranscodeTargetListener l : this.listeners) {
                    try {
                        l.fileRemoved(file);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                f = this;
                synchronized (f) {
                    if (this.device_files == null) {
                        this.loadDeviceFile();
                    } else {
                        this.device_files_last_mod = SystemTime.getMonotonousTime();
                    }
                    this.device_files.remove(file.getKey());
                    this.device_files_dirty = true;
                }
            }
            catch (Throwable e) {
                throw new TranscodeException("Delete failed", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fileDirty(TranscodeFileImpl file, int type, Object data) {
        try {
            DeviceImpl deviceImpl = this;
            synchronized (deviceImpl) {
                if (this.device_files == null) {
                    this.loadDeviceFile();
                } else {
                    this.device_files_last_mod = SystemTime.getMonotonousTime();
                }
            }
            this.device_files_dirty = true;
        }
        catch (Throwable e) {
            Debug.out("Failed to load device file", e);
        }
        for (TranscodeTargetListener l : this.listeners) {
            try {
                l.fileChanged(file, type, data);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    protected void saveDeviceFile() {
        this.device_files_dirty = false;
        try {
            this.loadDeviceFile();
            if (this.device_files == null || this.device_files.size() == 0) {
                FileUtil.deleteResilientFile(this.getDeviceFile());
            } else {
                HashMap map = new HashMap();
                map.put("files", this.device_files);
                FileUtil.writeResilientFile(this.getDeviceFile(), map);
            }
        }
        catch (Throwable e) {
            Debug.out("Failed to save device file", e);
        }
    }

    protected File getDeviceFile() throws IOException {
        File dir = this.getDevicesDir();
        return new File(dir, FileUtil.convertOSSpecificChars(this.getID(), false) + ".dat");
    }

    protected File getDevicesDir() throws IOException {
        File dir = new File(SystemProperties.getUserPath());
        if (!(dir = new File(dir, "devices")).exists() && !dir.mkdirs()) {
            throw new IOException("Failed to create '" + dir + "'");
        }
        return dir;
    }

    protected DeviceManagerImpl getManager() {
        return this.manager;
    }

    public void addListener(TranscodeTargetListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(TranscodeTargetListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChanged() {
        List<DeviceListener> l;
        DeviceImpl deviceImpl = this;
        synchronized (deviceImpl) {
            if (this.device_listeners == null) {
                return;
            }
            l = this.device_listeners.getList();
        }
        for (DeviceListener listener : l) {
            try {
                listener.deviceChanged(this);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(DeviceListener listener) {
        DeviceImpl deviceImpl = this;
        synchronized (deviceImpl) {
            if (this.device_listeners == null) {
                this.device_listeners = new CopyOnWriteList();
            }
            this.device_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(DeviceListener listener) {
        DeviceImpl deviceImpl = this;
        synchronized (deviceImpl) {
            if (this.device_listeners != null) {
                this.device_listeners.remove(listener);
                if (this.device_listeners.size() == 0) {
                    this.device_listeners = null;
                }
            }
        }
    }

    protected void log(String str) {
        this.manager.log(str);
    }

    protected void log(String str, Throwable e) {
        this.manager.log(str, e);
    }

    @Override
    public String getString() {
        return "type=" + this.type + ",uid=" + this.uid + ",class=" + this.classification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println(this.getName() + "/" + this.getID() + "/" + this.type);
        try {
            writer.indent();
            writer.println("hidden=" + this.hidden + ", last_seen=" + new SimpleDateFormat().format(new Date(this.last_seen)) + ", online=" + this.online + ", transcoding=" + this.transcoding);
            writer.println("p_props=" + this.persistent_properties);
            writer.println("t_props=" + this.transient_properties);
            writer.println("errors=" + this.errors);
            writer.println("infos=" + this.infos);
            Object var3_2 = null;
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            writer.exdent();
            throw throwable;
        }
    }

    public void generateTT(IndentWriter writer) {
        TranscodeFileImpl[] files = this.getFiles();
        int complete = 0;
        int copied = 0;
        int deleted = 0;
        int template = 0;
        for (TranscodeFileImpl f : files) {
            if (f.isComplete()) {
                ++complete;
            }
            if (f.isCopiedToDevice()) {
                ++copied;
            }
            if (f.isDeleted()) {
                ++deleted;
            }
            if (!f.isTemplate()) continue;
            ++template;
        }
        writer.println("files=" + files.length + ", comp=" + complete + ", copied=" + copied + ", deleted=" + deleted + ", template=" + template);
    }

    static {
        try {
            device_renames.add(Pattern.compile("TV\\s*+\\(([^\\)]*)\\)", 2));
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        KEY_FILE_ALLOC_ERROR = new Object();
    }

    protected class browseLocationImpl
    implements Device.browseLocation {
        private String name;
        private URL url;

        protected browseLocationImpl(String _name, URL _url) {
            this.name = _name;
            this.url = _url;
        }

        public String getName() {
            return this.name;
        }

        public URL getURL() {
            return this.url;
        }
    }
}

