/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.DeviceManagerException;
import com.aelitis.azureus.core.devices.DeviceMediaRenderer;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.DeviceUPnPImpl;
import com.aelitis.net.upnp.UPnPDevice;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceMediaRendererImpl
extends DeviceUPnPImpl
implements DeviceMediaRenderer {
    public DeviceMediaRendererImpl(DeviceManagerImpl _manager, UPnPDevice _device) {
        super(_manager, _device, 3);
    }

    public DeviceMediaRendererImpl(DeviceManagerImpl _manager, String _classification) {
        super(_manager, 3, _classification);
    }

    public DeviceMediaRendererImpl(DeviceManagerImpl _manager, String _uuid, String _classification, boolean _manual, String _name) {
        super(_manager, 3, _uuid, _classification, _manual, _name);
    }

    public DeviceMediaRendererImpl(DeviceManagerImpl _manager, String _uuid, String _classification, boolean _manual) {
        super(_manager, 3, _uuid, _classification, _manual);
    }

    protected DeviceMediaRendererImpl(DeviceManagerImpl _manager, Map _map) throws IOException {
        super(_manager, _map);
    }

    @Override
    public void setAddress(InetAddress address) {
        super.setAddress(address);
        if (this.getType() == 3) {
            DeviceImpl[] devices;
            boolean hasUPnPDevice = this.getUPnPDevice() != null;
            for (DeviceImpl device : devices = this.getManager().getDevices()) {
                String manufacturer;
                if (device == this || device.getID().equals(this.getID()) || !(device instanceof DeviceUPnPImpl)) continue;
                DeviceUPnPImpl deviceUPnP = (DeviceUPnPImpl)device;
                if (!address.equals(device.getAddress()) || !device.isAlive()) continue;
                if (hasUPnPDevice) {
                    int fileCount;
                    boolean no_auto_hide = device.getPersistentBooleanProperty("rend_no_ah", false);
                    if (device.getType() != 3 || no_auto_hide || deviceUPnP.getUPnPDevice() == null || (fileCount = deviceUPnP.getFileCount()) != 0 || device.isHidden()) break;
                    this.log("Hiding " + device.getName() + "/" + device.getClassification() + "/" + device.getID() + " due to " + this.getName() + "/" + this.getClassification() + "/" + this.getID());
                    device.setHidden(true);
                    break;
                }
                if (device.getType() == 3) {
                    boolean no_auto_hide = this.getPersistentBooleanProperty("rend_no_ah", false);
                    if (no_auto_hide) break;
                    int fileCount = this.getFileCount();
                    if (fileCount == 0 && !this.isHidden()) {
                        this.log("hiding " + this.getName() + "/" + this.getClassification() + "/" + this.getID() + " due to " + device.getName() + "/" + device.getClassification() + "/" + device.getID());
                        this.setHidden(true);
                        break;
                    }
                    if (fileCount <= 0 || !Constants.IS_CVS_VERSION || !this.isHidden()) break;
                    this.setHidden(false);
                    break;
                }
                UPnPDevice upnpDevice = deviceUPnP.getUPnPDevice();
                if (upnpDevice == null || (manufacturer = upnpDevice.getManufacturer()) != null && manufacturer.startsWith("Vuze")) break;
                this.log("Linked " + this.getName() + " to UPnP Device " + device.getName());
                this.setUPnPDevice(upnpDevice);
                this.setDirty();
                break;
            }
        }
    }

    @Override
    protected boolean updateFrom(DeviceImpl _other, boolean _is_alive) {
        if (!super.updateFrom(_other, _is_alive)) {
            return false;
        }
        if (!(_other instanceof DeviceMediaRendererImpl)) {
            Debug.out("Inconsistent");
            return false;
        }
        DeviceMediaRendererImpl other = (DeviceMediaRendererImpl)_other;
        return true;
    }

    @Override
    protected void initialise() {
        super.initialise();
    }

    @Override
    protected void destroy() {
        super.destroy();
    }

    @Override
    public boolean canCopyToDevice() {
        return false;
    }

    @Override
    public boolean getAutoCopyToDevice() {
        return false;
    }

    @Override
    public void setAutoCopyToDevice(boolean auto) {
    }

    @Override
    public int getCopyToDevicePending() {
        return 0;
    }

    @Override
    public boolean canAutoStartDevice() {
        return false;
    }

    @Override
    public boolean getAutoStartDevice() {
        return false;
    }

    @Override
    public void setAutoStartDevice(boolean auto) {
    }

    @Override
    public boolean canCopyToFolder() {
        return false;
    }

    @Override
    public void setCanCopyToFolder(boolean can) {
    }

    @Override
    public File getCopyToFolder() {
        return null;
    }

    @Override
    public void setCopyToFolder(File file) {
    }

    @Override
    public int getCopyToFolderPending() {
        return 0;
    }

    @Override
    public boolean getAutoCopyToFolder() {
        return false;
    }

    @Override
    public void setAutoCopyToFolder(boolean auto) {
    }

    @Override
    public void manualCopy() throws DeviceManagerException {
        throw new DeviceManagerException("Unsupported");
    }

    @Override
    public boolean canShowCategories() {
        return false;
    }

    @Override
    public void setShowCategories(boolean b) {
        this.setPersistentBooleanProperty("tt_show_cat", b);
    }

    @Override
    public boolean getShowCategories() {
        return this.getPersistentBooleanProperty("tt_show_cat", this.getShowCategoriesDefault());
    }

    protected boolean getShowCategoriesDefault() {
        return false;
    }

    @Override
    protected void getDisplayProperties(List<String[]> dp) {
        super.getDisplayProperties(dp);
        if (this.canCopyToFolder()) {
            this.addDP(dp, "devices.copy.folder.auto", this.getAutoCopyToFolder());
            this.addDP(dp, "devices.copy.folder.dest", this.getCopyToFolder());
        }
        if (this.canCopyToDevice()) {
            this.addDP(dp, "devices.copy.device.auto", this.getAutoCopyToDevice());
        }
        if (this.canShowCategories()) {
            this.addDP(dp, "devices.cat.show", this.getShowCategories());
        }
        super.getTTDisplayProperties(dp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        super.generate(writer);
        try {
            writer.indent();
            this.generateTT(writer);
            Object var3_2 = null;
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            writer.exdent();
            throw throwable;
        }
    }
}

