/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeProvider;
import com.aelitis.azureus.core.devices.impl.TranscodeManagerImpl;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranscodeProfileImpl
implements TranscodeProfile {
    private TranscodeManagerImpl manager;
    private int pid;
    private String uid;
    private String name;
    private Map<String, Object> properties;

    protected TranscodeProfileImpl(TranscodeManagerImpl _manager, int _provider_id, String _uid, String _name, Map<String, Object> _properties) {
        this.manager = _manager;
        this.pid = _provider_id;
        this.uid = _uid;
        this.name = _name;
        this.properties = _properties;
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    @Override
    public String getName() {
        String displayName = (String)this.properties.get("display-name");
        return displayName == null ? this.name : displayName;
    }

    @Override
    public TranscodeProvider getProvider() throws TranscodeException {
        return this.manager.getProvider(this.pid);
    }

    @Override
    public boolean isStreamable() {
        String res = (String)this.properties.get("streamable");
        return res != null && res.equalsIgnoreCase("yes");
    }

    @Override
    public String getFileExtension() {
        return (String)this.properties.get("file-ext");
    }

    @Override
    public String getDeviceClassification() {
        return (String)this.properties.get("device");
    }

    @Override
    public String getDescription() {
        String res = (String)this.properties.get("desc");
        return res == null ? "" : res;
    }

    @Override
    public String getIconURL() {
        return (String)this.properties.get("icon-url");
    }

    @Override
    public int getIconIndex() {
        Object o = this.properties.get("icon-index");
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return 0;
    }
}

