/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketData;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyError;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyFindNode;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyFindValue;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyKeyBlock;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyPing;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyQueryStorage;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyStats;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyStore;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestFindNode;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestFindValue;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestKeyBlock;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestPing;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestQueryStorage;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestStats;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestStore;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketReply;
import com.aelitis.net.udp.uc.PRUDPPacketReplyDecoder;
import com.aelitis.net.udp.uc.PRUDPPacketRequest;
import com.aelitis.net.udp.uc.PRUDPPacketRequestDecoder;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;

public class DHTUDPPacketHelper {
    public static final int PACKET_MAX_BYTES = 1400;
    public static final int ACT_REQUEST_PING = 1024;
    public static final int ACT_REPLY_PING = 1025;
    public static final int ACT_REQUEST_STORE = 1026;
    public static final int ACT_REPLY_STORE = 1027;
    public static final int ACT_REQUEST_FIND_NODE = 1028;
    public static final int ACT_REPLY_FIND_NODE = 1029;
    public static final int ACT_REQUEST_FIND_VALUE = 1030;
    public static final int ACT_REPLY_FIND_VALUE = 1031;
    public static final int ACT_REPLY_ERROR = 1032;
    public static final int ACT_REPLY_STATS = 1033;
    public static final int ACT_REQUEST_STATS = 1034;
    public static final int ACT_DATA = 1035;
    public static final int ACT_REQUEST_KEY_BLOCK = 1036;
    public static final int ACT_REPLY_KEY_BLOCK = 1037;
    public static final int ACT_REQUEST_QUERY_STORE = 1038;
    public static final int ACT_REPLY_QUERY_STORE = 1039;
    private static boolean registered = false;

    protected static void registerCodecs() {
        if (registered) {
            return;
        }
        registered = true;
        PRUDPPacketRequestDecoder request_decoder = new PRUDPPacketRequestDecoder(){

            public PRUDPPacketRequest decode(PRUDPPacketHandler handler, DataInputStream is, long connection_id, int action, int transaction_id) throws IOException {
                if (handler == null) {
                    throw new IOException("No handler available for DHT packet decode");
                }
                DHTUDPPacketNetworkHandler network_handler = (DHTUDPPacketNetworkHandler)handler.getRequestHandler();
                if (network_handler == null) {
                    throw new IOException("No network handler available for DHT packet decode");
                }
                switch (action) {
                    case 1024: {
                        return new DHTUDPPacketRequestPing(network_handler, is, connection_id, transaction_id);
                    }
                    case 1026: {
                        return new DHTUDPPacketRequestStore(network_handler, is, connection_id, transaction_id);
                    }
                    case 1028: {
                        return new DHTUDPPacketRequestFindNode(network_handler, is, connection_id, transaction_id);
                    }
                    case 1030: {
                        return new DHTUDPPacketRequestFindValue(network_handler, is, connection_id, transaction_id);
                    }
                    case 1034: {
                        return new DHTUDPPacketRequestStats(network_handler, is, connection_id, transaction_id);
                    }
                    case 1035: {
                        return new DHTUDPPacketData(network_handler, is, connection_id, transaction_id);
                    }
                    case 1036: {
                        return new DHTUDPPacketRequestKeyBlock(network_handler, is, connection_id, transaction_id);
                    }
                    case 1038: {
                        return new DHTUDPPacketRequestQueryStorage(network_handler, is, connection_id, transaction_id);
                    }
                }
                throw new IOException("Unknown action type");
            }
        };
        HashMap<Integer, 1> request_decoders = new HashMap<Integer, 1>();
        request_decoders.put(new Integer(1024), request_decoder);
        request_decoders.put(new Integer(1026), request_decoder);
        request_decoders.put(new Integer(1028), request_decoder);
        request_decoders.put(new Integer(1030), request_decoder);
        request_decoders.put(new Integer(1034), request_decoder);
        request_decoders.put(new Integer(1035), request_decoder);
        request_decoders.put(new Integer(1036), request_decoder);
        request_decoders.put(new Integer(1038), request_decoder);
        PRUDPPacketRequest.registerDecoders(request_decoders);
        PRUDPPacketReplyDecoder reply_decoder = new PRUDPPacketReplyDecoder(){

            public PRUDPPacketReply decode(PRUDPPacketHandler handler, InetSocketAddress originator, DataInputStream is, int action, int transaction_id) throws IOException {
                if (handler == null) {
                    throw new IOException("No handler available for DHT packet decode");
                }
                DHTUDPPacketNetworkHandler network_handler = (DHTUDPPacketNetworkHandler)handler.getRequestHandler();
                if (network_handler == null) {
                    throw new IOException("No network handler available for DHT packet decode");
                }
                switch (action) {
                    case 1025: {
                        return new DHTUDPPacketReplyPing(network_handler, originator, is, transaction_id);
                    }
                    case 1027: {
                        return new DHTUDPPacketReplyStore(network_handler, originator, is, transaction_id);
                    }
                    case 1029: {
                        return new DHTUDPPacketReplyFindNode(network_handler, originator, is, transaction_id);
                    }
                    case 1031: {
                        return new DHTUDPPacketReplyFindValue(network_handler, originator, is, transaction_id);
                    }
                    case 1032: {
                        return new DHTUDPPacketReplyError(network_handler, originator, is, transaction_id);
                    }
                    case 1033: {
                        return new DHTUDPPacketReplyStats(network_handler, originator, is, transaction_id);
                    }
                    case 1037: {
                        return new DHTUDPPacketReplyKeyBlock(network_handler, originator, is, transaction_id);
                    }
                    case 1039: {
                        return new DHTUDPPacketReplyQueryStorage(network_handler, originator, is, transaction_id);
                    }
                }
                throw new IOException("Unknown action type");
            }
        };
        HashMap<Integer, 2> reply_decoders = new HashMap<Integer, 2>();
        reply_decoders.put(new Integer(1025), reply_decoder);
        reply_decoders.put(new Integer(1027), reply_decoder);
        reply_decoders.put(new Integer(1029), reply_decoder);
        reply_decoders.put(new Integer(1031), reply_decoder);
        reply_decoders.put(new Integer(1032), reply_decoder);
        reply_decoders.put(new Integer(1033), reply_decoder);
        reply_decoders.put(new Integer(1037), reply_decoder);
        reply_decoders.put(new Integer(1039), reply_decoder);
        PRUDPPacketReply.registerDecoders(reply_decoders);
    }
}

