/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.access.impl;

import com.aelitis.azureus.core.diskmanager.access.DiskAccessController;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessControllerStats;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessRequest;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessRequestListener;
import com.aelitis.azureus.core.diskmanager.access.impl.DiskAccessControllerInstance;
import com.aelitis.azureus.core.diskmanager.access.impl.DiskAccessRequestImpl;
import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class DiskAccessControllerImpl
implements DiskAccessController,
AzureusCoreStatsProvider {
    private DiskAccessControllerInstance read_dispatcher;
    private DiskAccessControllerInstance write_dispatcher;

    public DiskAccessControllerImpl(String _name, int _max_read_threads, int _max_read_mb, int _max_write_threads, int _max_write_mb) {
        boolean enable_read_aggregation = COConfigurationManager.getBooleanParameter("diskmanager.perf.read.aggregate.enable");
        int read_aggregation_request_limit = COConfigurationManager.getIntParameter("diskmanager.perf.read.aggregate.request.limit", 4);
        int read_aggregation_byte_limit = COConfigurationManager.getIntParameter("diskmanager.perf.read.aggregate.byte.limit", 65536);
        boolean enable_write_aggregation = COConfigurationManager.getBooleanParameter("diskmanager.perf.write.aggregate.enable");
        int write_aggregation_request_limit = COConfigurationManager.getIntParameter("diskmanager.perf.write.aggregate.request.limit", 8);
        int write_aggregation_byte_limit = COConfigurationManager.getIntParameter("diskmanager.perf.write.aggregate.byte.limit", 131072);
        this.read_dispatcher = new DiskAccessControllerInstance(_name + "/" + "read", enable_read_aggregation, read_aggregation_request_limit, read_aggregation_byte_limit, _max_read_threads, _max_read_mb);
        this.write_dispatcher = new DiskAccessControllerInstance(_name + "/" + "write", enable_write_aggregation, write_aggregation_request_limit, write_aggregation_byte_limit, _max_write_threads, _max_write_mb);
        HashSet<String> types = new HashSet<String>();
        types.add("disk.read.queue.length");
        types.add("disk.read.queue.bytes");
        types.add("disk.read.request.count");
        types.add("disk.read.request.single");
        types.add("disk.read.request.multiple");
        types.add("disk.read.request.blocks");
        types.add("disk.read.bytes.total");
        types.add("disk.read.bytes.single");
        types.add("disk.read.bytes.multiple");
        types.add("disk.read.io.time");
        types.add("disk.read.io.count");
        types.add("disk.write.queue.length");
        types.add("disk.write.queue.bytes");
        types.add("disk.write.request.count");
        types.add("disk.write.request.blocks");
        types.add("disk.write.bytes.total");
        types.add("disk.write.bytes.single");
        types.add("disk.write.bytes.multiple");
        types.add("disk.write.io.time");
        AzureusCoreStats.registerProvider(types, this);
    }

    public void updateStats(Set types, Map values) {
        if (types.contains("disk.read.queue.length")) {
            values.put("disk.read.queue.length", new Long(this.read_dispatcher.getQueueSize()));
        }
        if (types.contains("disk.read.queue.bytes")) {
            values.put("disk.read.queue.bytes", new Long(this.read_dispatcher.getQueuedBytes()));
        }
        if (types.contains("disk.read.request.count")) {
            values.put("disk.read.request.count", new Long(this.read_dispatcher.getTotalRequests()));
        }
        if (types.contains("disk.read.request.single")) {
            values.put("disk.read.request.single", new Long(this.read_dispatcher.getTotalSingleRequests()));
        }
        if (types.contains("disk.read.request.multiple")) {
            values.put("disk.read.request.multiple", new Long(this.read_dispatcher.getTotalAggregatedRequests()));
        }
        if (types.contains("disk.read.request.blocks")) {
            values.put("disk.read.request.blocks", new Long(this.read_dispatcher.getBlockCount()));
        }
        if (types.contains("disk.read.bytes.total")) {
            values.put("disk.read.bytes.total", new Long(this.read_dispatcher.getTotalBytes()));
        }
        if (types.contains("disk.read.bytes.single")) {
            values.put("disk.read.bytes.single", new Long(this.read_dispatcher.getTotalSingleBytes()));
        }
        if (types.contains("disk.read.bytes.multiple")) {
            values.put("disk.read.bytes.multiple", new Long(this.read_dispatcher.getTotalAggregatedBytes()));
        }
        if (types.contains("disk.read.io.time")) {
            values.put("disk.read.io.time", new Long(this.read_dispatcher.getIOTime()));
        }
        if (types.contains("disk.read.io.count")) {
            values.put("disk.read.io.count", new Long(this.read_dispatcher.getIOCount()));
        }
        if (types.contains("disk.write.queue.length")) {
            values.put("disk.write.queue.length", new Long(this.write_dispatcher.getQueueSize()));
        }
        if (types.contains("disk.write.queue.bytes")) {
            values.put("disk.write.queue.bytes", new Long(this.write_dispatcher.getQueuedBytes()));
        }
        if (types.contains("disk.write.request.count")) {
            values.put("disk.write.request.count", new Long(this.write_dispatcher.getTotalRequests()));
        }
        if (types.contains("disk.write.request.blocks")) {
            values.put("disk.write.request.blocks", new Long(this.write_dispatcher.getBlockCount()));
        }
        if (types.contains("disk.write.bytes.total")) {
            values.put("disk.write.bytes.total", new Long(this.write_dispatcher.getTotalBytes()));
        }
        if (types.contains("disk.write.bytes.single")) {
            values.put("disk.write.bytes.single", new Long(this.write_dispatcher.getTotalSingleBytes()));
        }
        if (types.contains("disk.write.bytes.multiple")) {
            values.put("disk.write.bytes.multiple", new Long(this.write_dispatcher.getTotalAggregatedBytes()));
        }
        if (types.contains("disk.write.io.time")) {
            values.put("disk.write.io.time", new Long(this.write_dispatcher.getIOTime()));
        }
        if (types.contains("disk.write.io.count")) {
            values.put("disk.write.io.count", new Long(this.write_dispatcher.getIOCount()));
        }
    }

    public DiskAccessRequest queueReadRequest(CacheFile file, long offset, DirectByteBuffer buffer, short cache_policy, DiskAccessRequestListener listener) {
        DiskAccessRequestImpl request2 = new DiskAccessRequestImpl(file, offset, buffer, listener, 1, cache_policy);
        this.read_dispatcher.queueRequest(request2);
        return request2;
    }

    public DiskAccessRequest queueWriteRequest(CacheFile file, long offset, DirectByteBuffer buffer, boolean free_buffer, DiskAccessRequestListener listener) {
        DiskAccessRequestImpl request2 = new DiskAccessRequestImpl(file, offset, buffer, listener, free_buffer ? (short)3 : 2, 0);
        this.write_dispatcher.queueRequest(request2);
        return request2;
    }

    public DiskAccessControllerStats getStats() {
        return new DiskAccessControllerStats(){
            long read_total_req;
            long read_total_bytes;
            {
                this.read_total_req = DiskAccessControllerImpl.this.read_dispatcher.getTotalRequests();
                this.read_total_bytes = DiskAccessControllerImpl.this.read_dispatcher.getTotalBytes();
            }

            public long getTotalReadRequests() {
                return this.read_total_req;
            }

            public long getTotalReadBytes() {
                return this.read_total_bytes;
            }
        };
    }

    public String getString() {
        return "read: " + this.read_dispatcher.getString() + ", write: " + this.write_dispatcher.getString();
    }
}

