/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.cache.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileManagerImpl;
import com.aelitis.azureus.core.diskmanager.file.FMFile;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import java.io.File;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class CacheFileWithoutCacheMT
implements CacheFile {
    private static final int MAX_CLONES = 20;
    private static int num_clones;
    private static int max_clone_depth;
    private CacheFileManagerImpl manager;
    private FMFile base_file;
    private FMFile[] files;
    private int[] files_use_count;
    private TOTorrentFile torrent_file;
    private boolean moving;
    private long bytes_written;
    private long bytes_read;

    protected CacheFileWithoutCacheMT(CacheFileManagerImpl _manager, FMFile _file, TOTorrentFile _torrent_file) {
        this.manager = _manager;
        this.base_file = _file;
        this.torrent_file = _torrent_file;
        this.files = new FMFile[]{this.base_file};
        this.files_use_count = new int[]{0};
    }

    public TOTorrentFile getTorrentFile() {
        return this.torrent_file;
    }

    public boolean exists() {
        return this.base_file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void moveFile(File new_file) throws CacheFileManagerException {
        try {
            try {
                var2_2 = this;
                // MONITORENTER : var2_2
                this.moving = true;
                // MONITOREXIT : var2_2
                while (true) {
                    var2_2 = this;
                    // MONITORENTER : var2_2
                    surviving = false;
                    for (i = 1; i < this.files_use_count.length; ++i) {
                        if (this.files_use_count[i] <= 0) continue;
                        surviving = true;
                        break;
                    }
                    if (!surviving) {
                        for (i = 1; i < this.files_use_count.length; ++i) {
                            file = this.files[i];
                            if (file.isClone()) {
                                var6_8 = CacheFileWithoutCacheMT.class;
                                // MONITORENTER : com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileWithoutCacheMT.class
                                --CacheFileWithoutCacheMT.num_clones;
                                // MONITOREXIT : var6_8
                            }
                            file.close();
                        }
                        this.files = new FMFile[]{this.base_file};
                        this.files_use_count = new int[]{this.files_use_count[0]};
                        this.base_file.moveFile(new_file);
                        // MONITOREXIT : var2_2
                        var10_9 = null;
                        var11_12 = this;
                        ** break;
                    }
                    // MONITOREXIT : var2_2
                    try {
                        System.out.println("CacheFileWithoutCacheMT: waiting for clones to die");
                        Thread.sleep(250L);
                    }
                    catch (Throwable e) {}
                }
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(this, e);
                var10_10 = null;
                var11_13 = this;
                // MONITORENTER : var11_13
                this.moving = false;
                // MONITOREXIT : var11_13
                return;
            }
lbl48:
            // 1 sources

            this.moving = false;
            // MONITOREXIT : var11_12
            return;
        }
        catch (Throwable var9_15) {
            var10_11 = null;
            var11_14 = this;
            // MONITORENTER : var11_14
            this.moving = false;
            // MONITOREXIT : var11_14
            throw var9_15;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void renameFile(String new_file) throws CacheFileManagerException {
        try {
            try {
                var2_2 = this;
                // MONITORENTER : var2_2
                this.moving = true;
                // MONITOREXIT : var2_2
                while (true) {
                    var2_2 = this;
                    // MONITORENTER : var2_2
                    surviving = false;
                    for (i = 1; i < this.files_use_count.length; ++i) {
                        if (this.files_use_count[i] <= 0) continue;
                        surviving = true;
                        break;
                    }
                    if (!surviving) {
                        for (i = 1; i < this.files_use_count.length; ++i) {
                            file = this.files[i];
                            if (file.isClone()) {
                                var6_8 = CacheFileWithoutCacheMT.class;
                                // MONITORENTER : com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileWithoutCacheMT.class
                                --CacheFileWithoutCacheMT.num_clones;
                                // MONITOREXIT : var6_8
                            }
                            file.close();
                        }
                        this.files = new FMFile[]{this.base_file};
                        this.files_use_count = new int[]{this.files_use_count[0]};
                        this.base_file.renameFile(new_file);
                        // MONITOREXIT : var2_2
                        var10_9 = null;
                        var11_12 = this;
                        ** break;
                    }
                    // MONITOREXIT : var2_2
                    try {
                        System.out.println("CacheFileWithoutCacheMT: waiting for clones to die");
                        Thread.sleep(250L);
                    }
                    catch (Throwable e) {}
                }
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(this, e);
                var10_10 = null;
                var11_13 = this;
                // MONITORENTER : var11_13
                this.moving = false;
                // MONITOREXIT : var11_13
                return;
            }
lbl48:
            // 1 sources

            this.moving = false;
            // MONITOREXIT : var11_12
            return;
        }
        catch (Throwable var9_15) {
            var10_11 = null;
            var11_14 = this;
            // MONITORENTER : var11_14
            this.moving = false;
            // MONITOREXIT : var11_14
            throw var9_15;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessMode(int mode) throws CacheFileManagerException {
        try {
            CacheFileWithoutCacheMT cacheFileWithoutCacheMT = this;
            synchronized (cacheFileWithoutCacheMT) {
                for (int i = 0; i < this.files.length; ++i) {
                    this.files[i].setAccessMode(mode == 1 ? 1 : 2);
                }
            }
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    public int getAccessMode() {
        return this.base_file.getAccessMode() == 1 ? 1 : 2;
    }

    public void setStorageType(int type) throws CacheFileManagerException {
        throw new CacheFileManagerException(this, "Not Implemented");
    }

    public int getStorageType() {
        return CacheFileManagerImpl.convertFileToCacheType(this.base_file.getStorageType());
    }

    public long getLength() throws CacheFileManagerException {
        try {
            return this.base_file.exists() ? this.base_file.getLength() : 0L;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
            return 0L;
        }
    }

    public long compareLength(long compare_to) throws CacheFileManagerException {
        return this.getLength() - compare_to;
    }

    public void setLength(long length) throws CacheFileManagerException {
        try {
            this.base_file.setLength(length);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    public void setPieceComplete(int piece_number, DirectByteBuffer piece_data) throws CacheFileManagerException {
        try {
            this.base_file.setPieceComplete(piece_number, piece_data);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FMFile getFile() throws CacheFileManagerException {
        CacheFileWithoutCacheMT cacheFileWithoutCacheMT = this;
        synchronized (cacheFileWithoutCacheMT) {
            if (this.moving) {
                this.files_use_count[0] = this.files_use_count[0] + 1;
                return this.files[0];
            }
            int min_index = -1;
            int min = Integer.MAX_VALUE;
            for (int i = 0; i < this.files_use_count.length; ++i) {
                int count = this.files_use_count[i];
                if (count >= min) continue;
                min = count;
                min_index = i;
            }
            if (min == 0 || this.files_use_count.length == 20) {
                int n = min_index;
                this.files_use_count[n] = this.files_use_count[n] + 1;
                return this.files[min_index];
            }
            try {
                FMFile clone = this.base_file.createClone();
                int old_num = this.files.length;
                int new_num = old_num + 1;
                Class<CacheFileWithoutCacheMT> clazz = CacheFileWithoutCacheMT.class;
                synchronized (CacheFileWithoutCacheMT.class) {
                    if (++num_clones % 100 == 0) {
                        // empty if block
                    }
                    if (new_num == 20 || new_num > max_clone_depth) {
                        max_clone_depth = new_num;
                    }
                    // ** MonitorExit[var7_9] (shouldn't be in output)
                    FMFile[] new_files = new FMFile[new_num];
                    int[] new_files_use_count = new int[new_num];
                    System.arraycopy(this.files, 0, new_files, 0, old_num);
                    System.arraycopy(this.files_use_count, 0, new_files_use_count, 0, old_num);
                    new_files[old_num] = clone;
                    new_files_use_count[old_num] = 1;
                    this.files = new_files;
                    this.files_use_count = new_files_use_count;
                    return clone;
                }
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(this, e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseFile(FMFile file) {
        CacheFileWithoutCacheMT cacheFileWithoutCacheMT = this;
        synchronized (cacheFileWithoutCacheMT) {
            for (int i = 0; i < this.files_use_count.length; ++i) {
                if (this.files[i] != file) continue;
                int count = this.files_use_count[i];
                if (count > 0) {
                    // empty if block
                }
                this.files_use_count[i] = --count;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(DirectByteBuffer[] buffers, long position, short policy) throws CacheFileManagerException {
        int read_length = 0;
        for (int i = 0; i < buffers.length; ++i) {
            read_length += buffers[i].remaining((byte)3);
        }
        FMFile file = null;
        try {
            try {
                file = this.getFile();
                file.read(buffers, position);
                this.manager.fileBytesRead(read_length);
                this.bytes_read += (long)read_length;
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(this, e);
                Object var9_8 = null;
                this.releaseFile(file);
            }
            Object var9_7 = null;
            this.releaseFile(file);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.releaseFile(file);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(DirectByteBuffer buffer, long position, short policy) throws CacheFileManagerException {
        int read_length = buffer.remaining((byte)3);
        FMFile file = null;
        try {
            try {
                file = this.getFile();
                file.read(buffer, position);
                this.manager.fileBytesRead(read_length);
                this.bytes_read += (long)read_length;
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(this, e);
                Object var9_7 = null;
                this.releaseFile(file);
            }
            Object var9_6 = null;
            this.releaseFile(file);
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.releaseFile(file);
            throw throwable;
        }
    }

    public void write(DirectByteBuffer buffer, long position) throws CacheFileManagerException {
        int write_length = buffer.remaining((byte)3);
        try {
            this.base_file.write(buffer, position);
            this.manager.fileBytesWritten(write_length);
            this.bytes_written += (long)write_length;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    public void write(DirectByteBuffer[] buffers, long position) throws CacheFileManagerException {
        int write_length = 0;
        for (int i = 0; i < buffers.length; ++i) {
            write_length += buffers[i].remaining((byte)3);
        }
        try {
            this.base_file.write(buffers, position);
            this.manager.fileBytesWritten(write_length);
            this.bytes_written += (long)write_length;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAndHandoverBuffer(DirectByteBuffer buffer, long position) throws CacheFileManagerException {
        int write_length = buffer.remaining((byte)3);
        boolean write_ok = false;
        try {
            try {
                this.base_file.write(buffer, position);
                this.manager.fileBytesWritten(write_length);
                this.bytes_written += (long)write_length;
                write_ok = true;
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(this, e);
                Object var8_6 = null;
                if (write_ok) {
                    buffer.returnToPool();
                }
            }
            Object var8_5 = null;
            if (write_ok) {
                buffer.returnToPool();
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (write_ok) {
                buffer.returnToPool();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeAndHandoverBuffers(DirectByteBuffer[] buffers, long position) throws CacheFileManagerException {
        int write_length = 0;
        for (int i = 0; i < buffers.length; write_length += buffers[i].remaining((byte)3), ++i) {
        }
        boolean write_ok = false;
        try {
            try {
                this.base_file.write(buffers, position);
                this.manager.fileBytesWritten(write_length);
                this.bytes_written += (long)write_length;
                write_ok = true;
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(this, e);
                Object var8_6 = null;
                if (!write_ok) return;
                for (int i = 0; i < buffers.length; ++i) {
                    buffers[i].returnToPool();
                }
                return;
            }
            Object var8_5 = null;
            if (!write_ok) return;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (!write_ok) throw throwable;
            for (int i = 0; i < buffers.length; ++i) {
                buffers[i].returnToPool();
            }
            throw throwable;
        }
        for (int i = 0; i < buffers.length; ++i) {
            buffers[i].returnToPool();
        }
    }

    public void flushCache() throws CacheFileManagerException {
        try {
            this.base_file.flush();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    public void clearCache() throws CacheFileManagerException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void close() throws CacheFileManagerException {
        try {
            CacheFileWithoutCacheMT cacheFileWithoutCacheMT = this;
            // MONITORENTER : cacheFileWithoutCacheMT
            int i = 0;
            while (true) {
                if (i >= this.files.length) {
                    // MONITOREXIT : cacheFileWithoutCacheMT
                    return;
                }
                FMFile file = this.files[i];
                if (file.isClone()) {
                    Class<CacheFileWithoutCacheMT> clazz = CacheFileWithoutCacheMT.class;
                    // MONITORENTER : com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileWithoutCacheMT.class
                    --num_clones;
                    // MONITOREXIT : clazz
                }
                file.close();
                ++i;
            }
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    public boolean isOpen() {
        return this.base_file.isOpen();
    }

    public long getSessionBytesRead() {
        return this.bytes_read;
    }

    public long getSessionBytesWritten() {
        return this.bytes_written;
    }

    public void delete() throws CacheFileManagerException {
        try {
            this.base_file.delete();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }
}

