/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.helpers;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.impl.TorrentOpenOptions;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;

public class TorrentFolderWatcher {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static final String PARAMID_FOLDER = "Watch Torrent Folder";
    private volatile GlobalManager _global_manager;
    private volatile boolean running = false;
    private final ArrayList to_delete = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("TorrentFolderWatcher");
    private FilenameFilter filename_filter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            String lc_name = name.toLowerCase();
            return lc_name.endsWith(".torrent") || lc_name.endsWith(".tor") || lc_name.endsWith(".magnet") || lc_name.endsWith(".mag") || lc_name.endsWith(".dht") || lc_name.endsWith(".vuze");
        }
    };
    private ParameterListener param_listener = new ParameterListener(){

        public void parameterChanged(String parameterName) {
            if (COConfigurationManager.getBooleanParameter(TorrentFolderWatcher.PARAMID_FOLDER)) {
                if (!TorrentFolderWatcher.this.running) {
                    TorrentFolderWatcher.this.running = true;
                    if (!TorrentFolderWatcher.this.watch_thread.isAlive()) {
                        TorrentFolderWatcher.this.watch_thread.setDaemon(true);
                        TorrentFolderWatcher.this.watch_thread.setPriority(1);
                        TorrentFolderWatcher.this.watch_thread.start();
                    }
                }
            } else {
                TorrentFolderWatcher.this.running = false;
            }
        }
    };
    private final Thread watch_thread = new AEThread("FolderWatcher"){
        private long last_run;
        private AESemaphore wait_sem;
        {
            this.last_run = 0L;
            this.wait_sem = new AESemaphore("fw:wait");
            COConfigurationManager.addParameterListener(new String[]{TorrentFolderWatcher.PARAMID_FOLDER, "Watch Torrent Folder Interval Secs"}, new ParameterListener(){

                public void parameterChanged(String name) {
                    wait_sem.release();
                }
            });
        }

        public void runSupport() {
            while (true) {
                int sleep_ms;
                long remaining;
                long now = SystemTime.getMonotonousTime();
                int sleep_secs = COConfigurationManager.getIntParameter("Watch Torrent Folder Interval Secs");
                if (sleep_secs < 1) {
                    sleep_secs = 1;
                }
                if ((remaining = this.last_run + (long)(sleep_ms = sleep_secs * 1000) - now) >= 250L && this.last_run != 0L) {
                    if (remaining < 250L) {
                        remaining = 250L;
                    }
                    this.wait_sem.reserve(remaining);
                    continue;
                }
                this.last_run = now;
                try {
                    if (TorrentFolderWatcher.this.running) {
                        TorrentFolderWatcher.this.importAddedFiles();
                        continue;
                    }
                    this.wait_sem.reserve(60000L);
                    continue;
                }
                catch (Throwable e) {
                    Debug.out(e);
                    continue;
                }
                break;
            }
        }
    };

    public TorrentFolderWatcher(GlobalManager global_manager) {
        this._global_manager = global_manager;
    }

    public void start() {
        if (COConfigurationManager.getBooleanParameter(PARAMID_FOLDER)) {
            this.running = true;
            this.watch_thread.setDaemon(true);
            this.watch_thread.setPriority(1);
            this.watch_thread.start();
        }
        COConfigurationManager.addParameterListener(PARAMID_FOLDER, this.param_listener);
    }

    public void destroy() {
        this.running = false;
        this._global_manager = null;
        COConfigurationManager.removeParameterListener(PARAMID_FOLDER, this.param_listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void importAddedFiles() {
        block38: {
            block37: {
                block36: {
                    block35: {
                        block34: {
                            block33: {
                                try {
                                    this.this_mon.enter();
                                    if (!this.running) {
                                        Object var17_1 = null;
                                        this.this_mon.exit();
                                        return;
                                    }
                                    GlobalManager global_manager = this._global_manager;
                                    if (global_manager == null) {
                                        break block33;
                                    }
                                    boolean save_torrents = COConfigurationManager.getBooleanParameter("Save Torrent Files");
                                    String torrent_save_path = COConfigurationManager.getStringParameter("General_sDefaultTorrent_Directory");
                                    int start_state = COConfigurationManager.getBooleanParameter("Start Watched Torrents Stopped") ? 70 : 75;
                                    String folder_path = COConfigurationManager.getStringParameter("Watch Torrent Folder Path");
                                    String data_save_path = COConfigurationManager.getStringParameter("Default save path");
                                    File folder = null;
                                    if (folder_path != null && folder_path.length() > 0 && !(folder = new File(folder_path)).isDirectory()) {
                                        if (!folder.exists()) {
                                            FileUtil.mkdirs(folder);
                                        }
                                        if (!folder.isDirectory()) {
                                            if (Logger.isEnabled()) {
                                                Logger.log(new LogEvent(LOGID, 3, "[Watch Torrent Folder Path] does not exist or is not a dir"));
                                            }
                                            folder = null;
                                        }
                                    }
                                    if (folder == null) {
                                        if (Logger.isEnabled()) {
                                            Logger.log(new LogEvent(LOGID, 3, "[Watch Torrent Folder Path] not configured"));
                                        }
                                        break block34;
                                    }
                                    File f = null;
                                    if (data_save_path != null && data_save_path.length() > 0 && !(f = new File(data_save_path)).isDirectory()) {
                                        if (!f.exists()) {
                                            FileUtil.mkdirs(f);
                                        }
                                        if (!f.isDirectory()) {
                                            if (Logger.isEnabled()) {
                                                Logger.log(new LogEvent(LOGID, 3, "[Default save path] does not exist or is not a dir"));
                                            }
                                            Logger.log(new LogAlert(false, 3, "[Default save path] does not exist or is not a dir"));
                                            break block35;
                                        }
                                    }
                                    if (f == null) {
                                        if (Logger.isEnabled()) {
                                            Logger.log(new LogEvent(LOGID, 3, "[Default save path] needs to be set for auto-.torrent-import to work"));
                                        }
                                        Logger.log(new LogAlert(false, 3, "[Default save path] needs to be set for auto-.torrent-import to work"));
                                    }
                                    if (torrent_save_path.length() == 0 || torrent_save_path.equals(folder_path) || !new File(torrent_save_path).isDirectory()) {
                                        save_torrents = false;
                                    }
                                    for (int i = 0; i < this.to_delete.size(); ++i) {
                                        TOTorrent torrent = (TOTorrent)this.to_delete.get(i);
                                        try {
                                            TorrentUtils.delete(torrent);
                                            continue;
                                        }
                                        catch (Throwable e) {
                                            Debug.printStackTrace(e);
                                        }
                                    }
                                    this.to_delete.clear();
                                    String[] currentFileList = folder.list(this.filename_filter);
                                    if (currentFileList == null) {
                                        Logger.log(new LogEvent(LOGID, 3, "There was a problem trying to get a listing of torrents from " + folder));
                                        break block36;
                                    }
                                    for (int i = 0; i < currentFileList.length; ++i) {
                                        if (!this.running) {
                                            break block37;
                                        }
                                        File file = new File(folder, currentFileList[i]);
                                        TOTorrent torrent = null;
                                        try {
                                            torrent = TorrentUtils.readFromFile(file, false);
                                        }
                                        catch (Throwable e) {
                                            // empty catch block
                                        }
                                        try {
                                            if (torrent != null) {
                                                if (global_manager.getDownloadManager(torrent) != null) {
                                                    if (!Logger.isEnabled()) continue;
                                                    Logger.log(new LogEvent(LOGID, file.getAbsolutePath() + " is already being downloaded"));
                                                    continue;
                                                }
                                                byte[] hash = null;
                                                try {
                                                    hash = torrent.getHash();
                                                }
                                                catch (Exception e) {
                                                    // empty catch block
                                                }
                                                if (!save_torrents) {
                                                    File imported = new File(folder, file.getName() + ".imported");
                                                    TorrentUtils.move(file, imported);
                                                    global_manager.addDownloadManager(imported.getAbsolutePath(), hash, data_save_path, start_state, true);
                                                } else {
                                                    global_manager.addDownloadManager(file.getAbsolutePath(), hash, data_save_path, start_state, true);
                                                    this.to_delete.add(torrent);
                                                }
                                                if (!Logger.isEnabled()) continue;
                                                Logger.log(new LogEvent(LOGID, "Auto-imported " + file.getAbsolutePath()));
                                                continue;
                                            }
                                            String file_contents = FileUtil.readFileAsString(file, Integer.MAX_VALUE);
                                            String[] lines = file_contents.split("[\r\n]+");
                                            file.delete();
                                            TorrentOpenOptions too = new TorrentOpenOptions();
                                            too.iStartID = COConfigurationManager.getBooleanParameter("Start Watched Torrents Stopped") ? 1 : 0;
                                            TorrentOpener.openTorrentsFromStrings(too, null, null, lines, "", null, false);
                                            continue;
                                        }
                                        catch (Throwable e) {
                                            Debug.out("Failed to auto-import torrent file '" + file.getAbsolutePath() + "' - " + Debug.getNestedExceptionMessage(e));
                                            Debug.printStackTrace(e);
                                        }
                                    }
                                    break block38;
                                }
                                catch (Throwable throwable) {
                                    Object var17_8 = null;
                                    this.this_mon.exit();
                                    throw throwable;
                                }
                            }
                            Object var17_2 = null;
                            this.this_mon.exit();
                            return;
                        }
                        Object var17_3 = null;
                        this.this_mon.exit();
                        return;
                    }
                    Object var17_4 = null;
                    this.this_mon.exit();
                    return;
                }
                Object var17_5 = null;
                this.this_mon.exit();
                return;
            }
            Object var17_6 = null;
            this.this_mon.exit();
            return;
        }
        Object var17_7 = null;
        this.this_mon.exit();
    }
}

