/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.lws;

import com.aelitis.azureus.core.lws.LightWeightSeed;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistration;
import java.util.ArrayList;
import java.util.Map;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerImpl;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManagerAdapter;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.Debug;

public class LWSPeerManagerAdapter
extends LogRelation
implements PEPeerManagerAdapter {
    private static final String[] enabled_networks = new String[]{"Public"};
    private LightWeightSeed lws;
    private PeerManagerRegistration peer_manager_registration;

    public LWSPeerManagerAdapter(LightWeightSeed _lws, PeerManagerRegistration _peer_manager_registration) {
        this.lws = _lws;
        this.peer_manager_registration = _peer_manager_registration;
    }

    public String getDisplayName() {
        return this.lws.getName();
    }

    public PeerManagerRegistration getPeerManagerRegistration() {
        return this.peer_manager_registration;
    }

    public int getUploadRateLimitBytesPerSecond() {
        return 0;
    }

    public int getDownloadRateLimitBytesPerSecond() {
        return 0;
    }

    public int getPermittedBytesToReceive() {
        return Integer.MAX_VALUE;
    }

    public void permittedReceiveBytesUsed(int bytes) {
    }

    public int getPermittedBytesToSend() {
        return Integer.MAX_VALUE;
    }

    public void permittedSendBytesUsed(int bytes) {
    }

    public int getUploadPriority() {
        return 0;
    }

    public int getMaxUploads() {
        return 4;
    }

    public int getMaxConnections() {
        return 0;
    }

    public int getMaxSeedConnections() {
        return 0;
    }

    public boolean isExtendedMessagingEnabled() {
        return true;
    }

    public boolean isPeerExchangeEnabled() {
        return true;
    }

    public boolean isNetworkEnabled(String network) {
        return network == "Public";
    }

    public String[] getEnabledNetworks() {
        return enabled_networks;
    }

    public int getCryptoLevel() {
        return 0;
    }

    public long getRandomSeed() {
        return 0L;
    }

    public boolean isPeriodicRescanEnabled() {
        return false;
    }

    public void setStateFinishing() {
    }

    public void setStateSeeding(boolean never_downloaded) {
    }

    public void restartDownload(boolean recheck) {
        Debug.out("restartDownload called for " + this.getDisplayName());
    }

    public TRTrackerScraperResponse getTrackerScrapeResponse() {
        return null;
    }

    public String getTrackerClientExtensions() {
        return null;
    }

    public void setTrackerRefreshDelayOverrides(int percent) {
    }

    public boolean isMetadataDownload() {
        return false;
    }

    public int getTorrentInfoDictSize() {
        return 0;
    }

    public byte[] getTorrentInfoDict(PEPeer peer) {
        return null;
    }

    public boolean isNATHealthy() {
        return true;
    }

    public void addPeer(PEPeer peer) {
    }

    public void removePeer(PEPeer peer) {
    }

    public void addPiece(PEPiece piece) {
    }

    public void removePiece(PEPiece piece) {
    }

    public void discarded(PEPeer peer, int bytes) {
    }

    public void protocolBytesReceived(PEPeer peer, int bytes) {
    }

    public void dataBytesReceived(PEPeer peer, int bytes) {
    }

    public void protocolBytesSent(PEPeer peer, int bytes) {
    }

    public void dataBytesSent(PEPeer peer, int bytes) {
    }

    public void statsRequest(PEPeer originator, Map request2, Map reply) {
    }

    public void addHTTPSeed(String address, int port) {
    }

    public byte[][] getSecrets(int crypto_level) {
        return this.lws.getSecrets();
    }

    public void enqueueReadRequest(PEPeer peer, DiskManagerReadRequest request2, DiskManagerReadRequestListener listener) {
        this.lws.enqueueReadRequest(peer, request2, listener);
    }

    public int getPosition() {
        return Integer.MAX_VALUE;
    }

    public boolean isPeerSourceEnabled(String peer_source) {
        return true;
    }

    public boolean hasPriorityConnection() {
        return false;
    }

    public void priorityConnectionChanged(boolean added) {
    }

    public LogRelation getLogRelation() {
        return this;
    }

    public String getRelationText() {
        return this.lws.getRelationText();
    }

    public Object[] getQueryableInterfaces() {
        ArrayList<Object> interfaces = new ArrayList<Object>();
        Object[] intf = this.lws.getQueryableInterfaces();
        for (int i = 0; i < intf.length; ++i) {
            if (intf[i] == null) continue;
            interfaces.add(intf[i]);
        }
        interfaces.add(this.lws.getRelation());
        return interfaces.toArray();
    }

    public DownloadManagerImpl getDownload_manager() {
        throw new UnsupportedOperationException("Contact the Creator of the VEM Mod");
    }
}

