/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.utils.MomentsAgoDateFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang.Entities;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.json.simple.JSONObject;

public abstract class Result {
    private static final String HTML_TAGS = "(\\<(/?[^\\>]+)\\>)";
    private static final String DUPLICATE_SPACES = "\\s{2,}";
    private Engine engine;

    public abstract Date getPublishedDate();

    public abstract String getCategory();

    public abstract void setCategory(String var1);

    public abstract String getContentType();

    public abstract void setContentType(String var1);

    public abstract String getName();

    public abstract long getSize();

    public abstract int getNbPeers();

    public abstract int getNbSeeds();

    public abstract int getNbSuperSeeds();

    public abstract int getComments();

    public abstract int getVotes();

    public abstract int getVotesDown();

    public abstract boolean isPrivate();

    public abstract String getDRMKey();

    public abstract String getDownloadLink();

    public abstract String getDownloadButtonLink();

    public abstract String getCDPLink();

    public abstract String getPlayLink();

    public abstract float getAccuracy();

    public abstract String getSearchQuery();

    public abstract String getUID();

    public abstract String getHash();

    protected Result(Engine _engine) {
        this.engine = _engine;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public String toString() {
        return this.getName() + " : " + this.getNbSeeds() + " s, " + this.getNbPeers() + "p, ";
    }

    public float getRank() {
        float rank;
        int votesDown;
        int votes;
        int seeds = this.getNbSeeds();
        int peers = this.getNbPeers();
        if (seeds < 0) {
            seeds = 0;
        }
        if (peers < 0) {
            peers = 0;
        }
        int totalVirtualPeers = 3 * seeds + peers + 2;
        int superSeeds = this.getNbSuperSeeds();
        if (superSeeds > 0) {
            totalVirtualPeers += 50 * superSeeds;
        }
        if ((votes = this.getVotes()) > 0) {
            if (votes > 50) {
                votes = 50;
            }
            totalVirtualPeers += 5 * votes;
        }
        if ((votesDown = this.getVotesDown()) > 0) {
            totalVirtualPeers -= 200 * votesDown;
        }
        if (totalVirtualPeers < 2) {
            totalVirtualPeers = 2;
        }
        if ((rank = (float)(Math.log(totalVirtualPeers) / Math.log(10.0)) / 5.0f) > 2.0f) {
            rank = 2.0f;
        }
        if (this.isPrivate()) {
            rank /= 2.0f;
        }
        String queryString = this.getSearchQuery();
        String name = this.getName();
        if (queryString != null && name != null) {
            name = name.toLowerCase(Locale.ENGLISH);
            String token = "";
            ArrayList<String> tokens = new ArrayList<String>();
            char[] chars = queryString.toCharArray();
            for (char c : chars) {
                if (Character.isLetterOrDigit(c)) {
                    token = token + String.valueOf(c).toLowerCase(Locale.ENGLISH);
                    continue;
                }
                if (token.length() <= 0) continue;
                tokens.add(token);
                token = "";
            }
            if (token.length() > 0) {
                tokens.add(token);
            }
            Object object = tokens.iterator();
            while (object.hasNext()) {
                String s = (String)object.next();
                if (name.contains(s)) continue;
                rank /= 2.0f;
            }
        }
        rank = this.applyRankBias(rank);
        return rank;
    }

    protected float applyRankBias(float _rank) {
        float rank = this.engine.applyRankBias(_rank);
        return rank;
    }

    public Map toJSONMap() {
        String uid;
        String drmKey;
        long size;
        JSONObject object = new JSONObject();
        Date pub_date = this.getPublishedDate();
        if (pub_date == null) {
            object.put("d", "unknown");
            object.put("ts", "0");
        } else {
            try {
                object.put("d", MomentsAgoDateFormatter.getMomentsAgoString(pub_date));
                object.put("ts", "" + pub_date.getTime());
            }
            catch (Exception e) {
                object.put("d", "unknown");
                object.put("ts", "0");
            }
        }
        object.put("c", this.getCategory());
        object.put("n", this.getName());
        int super_seeds = this.getNbSuperSeeds();
        int seeds = this.getNbSeeds();
        int seed_total = -1;
        if (super_seeds > 0) {
            seed_total = 10 * super_seeds + new Random().nextInt(10);
        }
        if (seeds > 0) {
            if (seed_total == -1) {
                seed_total = 0;
            }
            seed_total += seeds;
        }
        object.put("s", "" + seed_total);
        if (this.getNbPeers() >= 0) {
            object.put("p", "" + this.getNbPeers());
        } else {
            object.put("p", "-1");
        }
        int comments = this.getComments();
        if (comments >= 0) {
            object.put("co", "" + comments);
        }
        if ((size = this.getSize()) >= 0L) {
            String size_str = DisplayFormatters.formatByteCountToKiBEtc(size);
            size_str = DisplayFormatters.trimDigits(size_str, 3);
            object.put("l", size_str);
            object.put("lb", "" + size);
        } else {
            object.put("l", "-1");
            object.put("lb", "0");
        }
        object.put("r", "" + this.getRank());
        object.put("ct", this.getContentType());
        float accuracy = this.getAccuracy();
        if (accuracy >= 0.0f) {
            if (accuracy > 1.0f) {
                accuracy = 1.0f;
            }
            object.put("ac", "" + accuracy);
        }
        if (this.getCDPLink().length() > 0) {
            object.put("cdp", this.getCDPLink());
        }
        if (this.getDownloadLink().length() > 0) {
            object.put("dl", this.getDownloadLink());
        }
        if (this.getDownloadButtonLink().length() > 0) {
            object.put("dbl", this.getDownloadButtonLink());
        }
        if (this.getPlayLink().length() > 0) {
            object.put("pl", this.getPlayLink());
        }
        if (this.getVotes() >= 0) {
            object.put("v", "" + this.getVotes());
        }
        if (this.getVotesDown() >= 0) {
            object.put("vd", "" + this.getVotesDown());
        }
        if ((drmKey = this.getDRMKey()) != null) {
            object.put("dk", drmKey);
        }
        if ((uid = this.getUID()) != null) {
            object.put("u", uid);
        }
        object.put("pr", this.isPrivate() ? "1" : "0");
        String hash = this.getHash();
        if (hash != null) {
            object.put("h", hash);
        }
        return object;
    }

    public static void adjustRelativeTerms(Map map) {
        long l_ts;
        String ts = (String)map.get("ts");
        if (ts != null && (l_ts = Long.parseLong(ts)) > 0L) {
            map.put("d", MomentsAgoDateFormatter.getMomentsAgoString(new Date(l_ts)));
        }
    }

    protected static final String removeHTMLTags(String input) {
        if (input == null) {
            return null;
        }
        String result = input.replaceAll(HTML_TAGS, " ");
        return result.replaceAll(DUPLICATE_SPACES, " ").trim();
    }

    protected static final String unescapeEntities(String input) {
        if (input == null) {
            return null;
        }
        return Entities.HTML40.unescape(input);
    }
}

