/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl.plugin;

import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.impl.plugin.PluginEngine;
import java.util.Date;
import java.util.Map;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.plugins.utils.search.SearchResult;

public class PluginResult
extends Result {
    private static final Object NULL_OBJECT = PluginResult.class;
    private SearchResult result;
    private String search_term;
    private Map property_cache = new LightHashMap();

    protected PluginResult(PluginEngine _engine, SearchResult _result, String _search_term) {
        super(_engine);
        this.result = _result;
        this.search_term = _search_term;
    }

    public Date getPublishedDate() {
        return (Date)this.getResultProperty(2);
    }

    public String getCategory() {
        return this.getStringProperty(7);
    }

    public void setCategory(String category) {
    }

    public String getContentType() {
        return this.getStringProperty(10);
    }

    public void setContentType(String contentType) {
    }

    public String getName() {
        return this.getStringProperty(1);
    }

    public long getSize() {
        return this.getLongProperty(3);
    }

    public int getNbPeers() {
        return this.getIntProperty(4);
    }

    public int getNbSeeds() {
        return this.getIntProperty(5);
    }

    public int getNbSuperSeeds() {
        return this.getIntProperty(6);
    }

    public int getComments() {
        return this.getIntProperty(8);
    }

    public int getVotes() {
        return this.getIntProperty(9);
    }

    public int getVotesDown() {
        return this.getIntProperty(19);
    }

    public boolean isPrivate() {
        return this.getBooleanProperty(14);
    }

    public String getDRMKey() {
        return this.getStringProperty(15);
    }

    public String getDownloadLink() {
        return this.getStringProperty(12);
    }

    public String getDownloadButtonLink() {
        return this.getStringProperty(16);
    }

    public String getCDPLink() {
        return this.getStringProperty(11);
    }

    public String getPlayLink() {
        return this.getStringProperty(13);
    }

    public String getUID() {
        return this.getStringProperty(20);
    }

    public String getHash() {
        byte[] hash = this.getByteArrayProperty(21);
        if (hash == null) {
            return null;
        }
        return Base32.encode(hash);
    }

    public float getRank() {
        if (((PluginEngine)this.getEngine()).useAccuracyForRank()) {
            return this.applyRankBias(this.getAccuracy());
        }
        long l_rank = this.getLongProperty(17);
        if (this.getLongProperty(5) >= 0L && this.getLongProperty(4) >= 0L) {
            l_rank = Long.MIN_VALUE;
        }
        if (l_rank == Long.MIN_VALUE) {
            return super.getRank();
        }
        float rank = l_rank;
        if (rank > 100.0f) {
            rank = 100.0f;
        } else if (rank < 0.0f) {
            rank = 0.0f;
        }
        return this.applyRankBias(rank / 100.0f);
    }

    public float getAccuracy() {
        long l_accuracy = this.getLongProperty(18);
        if (l_accuracy == Long.MIN_VALUE) {
            return -1.0f;
        }
        float accuracy = l_accuracy;
        if (accuracy > 100.0f) {
            accuracy = 100.0f;
        } else if (accuracy < 0.0f) {
            accuracy = 0.0f;
        }
        return accuracy / 100.0f;
    }

    public String getSearchQuery() {
        return this.search_term;
    }

    protected int getIntProperty(int name) {
        return (int)this.getLongProperty(name);
    }

    protected long getLongProperty(int name) {
        return this.getLongProperty(name, Long.MIN_VALUE);
    }

    protected long getLongProperty(int name, long def) {
        try {
            Long l = (Long)this.getResultProperty(name);
            if (l == null) {
                return def;
            }
            return l;
        }
        catch (Throwable e) {
            Debug.out("Invalid value returned for Long property " + name);
            return def;
        }
    }

    protected boolean getBooleanProperty(int name) {
        return this.getBooleanProperty(name, false);
    }

    protected boolean getBooleanProperty(int name, boolean def) {
        try {
            Boolean b = (Boolean)this.getResultProperty(name);
            if (b == null) {
                return def;
            }
            return b;
        }
        catch (Throwable e) {
            Debug.out("Invalid value returned for Boolean property " + name);
            return def;
        }
    }

    protected String getStringProperty(int name) {
        return this.getStringProperty(name, "");
    }

    protected String getStringProperty(int name, String def) {
        try {
            String l = (String)this.getResultProperty(name);
            if (l == null) {
                return def;
            }
            return PluginResult.unescapeEntities(PluginResult.removeHTMLTags(l));
        }
        catch (Throwable e) {
            Debug.out("Invalid value returned for String property " + name);
            return def;
        }
    }

    protected byte[] getByteArrayProperty(int name) {
        try {
            return (byte[])this.getResultProperty(name);
        }
        catch (Throwable e) {
            Debug.out("Invalid value returned for byte[] property " + name);
            return null;
        }
    }

    protected synchronized Object getResultProperty(int prop) {
        Integer i_prop = new Integer(prop);
        Object res = this.property_cache.get(i_prop);
        if (res == null) {
            res = this.result.getProperty(prop);
            if (res == null) {
                res = NULL_OBJECT;
            }
            this.property_cache.put(i_prop, res);
        }
        if (res == NULL_OBJECT) {
            return null;
        }
        return res;
    }
}

