/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl.swt;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminImpl;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.updater.UIUpdater;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTStatusEntry;
import org.gudy.azureus2.ui.swt.plugins.UISWTStatusEntryListener;
import org.gudy.azureus2.ui.swt.views.stats.StatsView;

public class NetworkAdminSWTImpl {
    private AzureusCore core;
    private NetworkAdminImpl network_admin;
    private UISWTStatusEntry status;
    private Image icon_grey;
    private Image icon_green;
    private Image icon_yellow;
    private Image icon_red;
    private Image last_icon;
    private String last_tip;
    private volatile boolean is_visible;

    public NetworkAdminSWTImpl(AzureusCore _core, NetworkAdminImpl _network_admin) {
        this.core = _core;
        this.network_admin = _network_admin;
        final PluginInterface default_pi = PluginInitializer.getDefaultInterface();
        default_pi.getUIManager().addUIListener(new UIManagerListener(){

            public void UIAttached(final UIInstance instance) {
                if (instance instanceof UISWTInstance) {
                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                    if (uif != null) {
                        uif.getUIUpdater().addListener(new UIUpdater.UIUpdaterListener(){

                            public void updateComplete(int count) {
                                NetworkAdminSWTImpl.this.updateStatus();
                            }
                        });
                    }
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            ImageLoader imageLoader = ImageLoader.getInstance();
                            NetworkAdminSWTImpl.this.icon_grey = imageLoader.getImage("st_net_grey");
                            NetworkAdminSWTImpl.this.icon_yellow = imageLoader.getImage("st_net_yellow");
                            NetworkAdminSWTImpl.this.icon_green = imageLoader.getImage("st_net_green");
                            NetworkAdminSWTImpl.this.icon_red = imageLoader.getImage("st_net_red");
                            UISWTInstance ui_instance = (UISWTInstance)instance;
                            NetworkAdminSWTImpl.this.status = ui_instance.createStatusEntry();
                            NetworkAdminSWTImpl.this.status.setText(MessageText.getString("label.routing"));
                            NetworkAdminSWTImpl.this.status.setImageEnabled(true);
                            NetworkAdminSWTImpl.this.status.setImage(NetworkAdminSWTImpl.this.icon_grey);
                            String icon_param = "Show IP Bindings Icon";
                            final MenuItem mi_show = default_pi.getUIManager().getMenuManager().addMenuItem(NetworkAdminSWTImpl.this.status.getMenuContext(), "pairing.ui.icon.show");
                            mi_show.setStyle(2);
                            mi_show.setData(false);
                            mi_show.addListener(new MenuItemListener(){

                                public void selected(MenuItem menu, Object target) {
                                    COConfigurationManager.setParameter("Show IP Bindings Icon", false);
                                }
                            });
                            COConfigurationManager.addAndFireParameterListeners(new String[]{"Bind IP", "Show IP Bindings Icon"}, new ParameterListener(){

                                public void parameterChanged(String parameterName) {
                                    String bind_ip = COConfigurationManager.getStringParameter("Bind IP", "").trim();
                                    NetworkAdminSWTImpl.this.is_visible = bind_ip.trim().length() > 0 && COConfigurationManager.getBooleanParameter("Show IP Bindings Icon");
                                    NetworkAdminSWTImpl.this.status.setVisible(NetworkAdminSWTImpl.this.is_visible);
                                    mi_show.setData(new Boolean(NetworkAdminSWTImpl.this.is_visible));
                                    if (NetworkAdminSWTImpl.this.is_visible) {
                                        NetworkAdminSWTImpl.this.updateStatus();
                                    }
                                }
                            });
                            MenuItem mi_sep = default_pi.getUIManager().getMenuManager().addMenuItem(NetworkAdminSWTImpl.this.status.getMenuContext(), "");
                            mi_sep.setStyle(4);
                            MenuItem mi_options = default_pi.getUIManager().getMenuManager().addMenuItem(NetworkAdminSWTImpl.this.status.getMenuContext(), "MainWindow.menu.view.configuration");
                            mi_options.addListener(new MenuItemListener(){

                                public void selected(MenuItem menu, Object target) {
                                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                                    if (uif != null) {
                                        uif.openView(4, "connection.advanced");
                                    }
                                }
                            });
                            UISWTStatusEntryListener click_listener = new UISWTStatusEntryListener(){

                                public void entryClicked(UISWTStatusEntry entry) {
                                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                                    if (uif != null) {
                                        uif.getMDI().loadEntryByID(StatsView.VIEW_ID, true, false, "TransferStatsView");
                                    }
                                }
                            };
                            NetworkAdminSWTImpl.this.status.setListener(click_listener);
                        }
                    });
                }
            }

            public void UIDetached(UIInstance instance) {
            }
        });
    }

    private void updateStatus() {
        if (!this.is_visible) {
            return;
        }
        Object[] bs_status = this.network_admin.getBindingStatus();
        int bs_state = (Integer)bs_status[0];
        String tip = (String)bs_status[1];
        Image icon = bs_state == 0 ? this.icon_grey : (bs_state == 1 ? this.icon_green : (bs_state == 2 ? this.icon_yellow : this.icon_red));
        if (this.last_icon != icon || !tip.equals(this.last_tip)) {
            final Image f_icon = icon;
            final String f_tip = tip;
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    NetworkAdminSWTImpl.this.last_icon = f_icon;
                    NetworkAdminSWTImpl.this.last_tip = f_tip;
                    NetworkAdminSWTImpl.this.status.setImage(f_icon);
                    NetworkAdminSWTImpl.this.status.setTooltipText(f_tip);
                }
            });
        }
    }
}

