/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.RateHandler;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import java.io.IOException;
import org.gudy.azureus2.core3.util.Debug;

public class SinglePeerUploader
implements RateControlledEntity {
    private final NetworkConnectionBase connection;
    private final RateHandler rate_handler;

    public SinglePeerUploader(NetworkConnectionBase connection, RateHandler rate_handler) {
        this.connection = connection;
        this.rate_handler = rate_handler;
    }

    public RateHandler getRateHandler() {
        return this.rate_handler;
    }

    public boolean canProcess(EventWaiter waiter) {
        if (!this.connection.getTransportBase().isReadyForWrite(waiter)) {
            return false;
        }
        if (this.connection.getOutgoingMessageQueue().getTotalSize() < 1) {
            return false;
        }
        return this.rate_handler.getCurrentNumBytesAllowed() >= 1;
    }

    public int doProcessing(EventWaiter waiter, int max_bytes) {
        int num_bytes_available;
        if (!this.connection.getTransportBase().isReadyForWrite(waiter)) {
            return 0;
        }
        int num_bytes_allowed = this.rate_handler.getCurrentNumBytesAllowed();
        if (num_bytes_allowed < 1) {
            return 0;
        }
        if (max_bytes > 0 && max_bytes < num_bytes_allowed) {
            num_bytes_allowed = max_bytes;
        }
        if ((num_bytes_available = this.connection.getOutgoingMessageQueue().getTotalSize()) < 1) {
            if (!this.connection.getOutgoingMessageQueue().isDestroyed()) {
                // empty if block
            }
            return 0;
        }
        int num_bytes_to_write = num_bytes_allowed > num_bytes_available ? num_bytes_available : num_bytes_allowed;
        int written = 0;
        try {
            written = this.connection.getOutgoingMessageQueue().deliverToTransport(num_bytes_to_write, false);
        }
        catch (Throwable e) {
            if (!(e instanceof IOException)) {
                Debug.printStackTrace(e);
            }
            this.connection.notifyOfException(e);
            return 0;
        }
        if (written < 1) {
            return 0;
        }
        this.rate_handler.bytesProcessed(written);
        return written;
    }

    public int getPriority() {
        return 0;
    }

    public boolean getPriorityBoost() {
        return this.connection.getOutgoingMessageQueue().getPriorityBoost();
    }

    public long getBytesReadyToWrite() {
        return this.connection.getOutgoingMessageQueue().getTotalSize();
    }

    public int getConnectionCount(EventWaiter waiter) {
        return 1;
    }

    public int getReadyConnectionCount(EventWaiter waiter) {
        if (this.connection.getTransportBase().isReadyForWrite(waiter)) {
            return 1;
        }
        return 0;
    }

    public String getString() {
        return "SPU: bytes_allowed=" + this.rate_handler.getCurrentNumBytesAllowed() + " " + this.connection.getString();
    }
}

