/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.tag.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.rssgen.RSSGeneratorPlugin;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagDownload;
import com.aelitis.azureus.core.tag.TagFeatureFileLocation;
import com.aelitis.azureus.core.tag.TagFeatureListener;
import com.aelitis.azureus.core.tag.TagFeatureRSSFeed;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerListener;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.core.tag.TaggableLifecycleHandler;
import com.aelitis.azureus.core.tag.TaggableLifecycleListener;
import com.aelitis.azureus.core.tag.TaggableResolver;
import com.aelitis.azureus.core.tag.impl.TagBase;
import com.aelitis.azureus.core.tag.impl.TagPropertyConstraintHandler;
import com.aelitis.azureus.core.tag.impl.TagPropertyTrackerHandler;
import com.aelitis.azureus.core.tag.impl.TagPropertyTrackerTemplateHandler;
import com.aelitis.azureus.core.tag.impl.TagPropertyUntaggedHandler;
import com.aelitis.azureus.core.tag.impl.TagTypeBase;
import com.aelitis.azureus.core.tag.impl.TagTypeDownloadManual;
import com.aelitis.azureus.core.tag.impl.TagWithState;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.IdentityHashSet;
import com.aelitis.azureus.util.MapUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerInitialisationAdapter;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.FrequencyLimitedDispatcher;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.core3.xml.util.XMLEscapeWriter;
import org.gudy.azureus2.core3.xml.util.XUXmlWriter;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadCompletionListener;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagManagerImpl
implements TagManager,
DownloadCompletionListener {
    private static final String CONFIG_FILE = "tag.config";
    private static final int CU_TAG_CREATE = 1;
    private static final int CU_TAG_CHANGE = 2;
    private static final int CU_TAG_CONTENTS = 3;
    private static final int CU_TAG_REMOVE = 4;
    private static final boolean enabled = COConfigurationManager.getBooleanParameter("tagmanager.enable", true);
    private static TagManagerImpl singleton;
    private CopyOnWriteList<TagType> tag_types = new CopyOnWriteList();
    private Map<Integer, TagType> tag_type_map = new HashMap<Integer, TagType>();
    private static final String RSS_PROVIDER = "tags";
    private Set<TagBase> rss_tags = new HashSet<TagBase>();
    private Set<DownloadManager> active_copy_on_complete = new IdentityHashSet<DownloadManager>();
    private RSSGeneratorPlugin.Provider rss_generator = new RSSGeneratorPlugin.Provider(){

        public boolean isEnabled() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean generate(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
            URL url = request2.getAbsoluteURL();
            String path = url.getPath();
            int pos = path.indexOf(63);
            if (pos != -1) {
                path = path.substring(0, pos);
            }
            path = path.substring(TagManagerImpl.RSS_PROVIDER.length() + 1);
            XMLEscapeWriter pw = new XMLEscapeWriter(new PrintWriter(new OutputStreamWriter(response.getOutputStream(), "UTF-8")));
            pw.setEnabled(false);
            if (path.length() <= 1) {
                ArrayList tags;
                response.setContentType("text/html; charset=UTF-8");
                pw.println("<HTML><HEAD><TITLE>Vuze Tag Feeds</TITLE></HEAD><BODY>");
                TreeMap<String, String> lines = new TreeMap<String, String>();
                Iterator iterator = TagManagerImpl.this.rss_tags;
                synchronized (iterator) {
                    tags = new ArrayList(TagManagerImpl.this.rss_tags);
                }
                for (TagBase t : tags) {
                    if (!(t instanceof TagDownload) || !((TagFeatureRSSFeed)((Object)t)).isTagRSSFeedEnabled()) continue;
                    String name = t.getTagName(true);
                    String tag_url = "tags/" + t.getTagType().getTagType() + "-" + t.getTagID();
                    lines.put(name, "<LI><A href=\"" + tag_url + "\">" + name + "</A>&nbsp;&nbsp;-&nbsp;&nbsp;<font size=\"-1\"><a href=\"" + tag_url + "?format=html\">html</a></font></LI>");
                }
                for (String line : lines.values()) {
                    pw.println(line);
                }
                pw.println("</BODY></HTML>");
            } else {
                String tag_id = path.substring(1);
                String[] bits = tag_id.split("-");
                int tt_id = Integer.parseInt(bits[0]);
                int t_id = Integer.parseInt(bits[1]);
                TagDownload tag = null;
                Set tag_url = TagManagerImpl.this.rss_tags;
                synchronized (tag_url) {
                    for (TagBase t : TagManagerImpl.this.rss_tags) {
                        if (t.getTagType().getTagType() != tt_id || t.getTagID() != t_id || !(t instanceof TagDownload)) continue;
                        tag = (TagDownload)((Object)t);
                    }
                }
                if (tag == null) {
                    response.setReplyStatus(404);
                    return true;
                }
                boolean enable_low_noise = RSSGeneratorPlugin.getSingleton().isLowNoiseEnabled();
                Set<DownloadManager> dms = tag.getTaggedDownloads();
                ArrayList<Download> downloads = new ArrayList<Download>(dms.size());
                long dl_marker = 0L;
                for (DownloadManager dm : dms) {
                    DownloadManagerState state;
                    TOTorrent torrent = dm.getTorrent();
                    if (torrent == null || (state = dm.getDownloadState()).getFlag(512L) || !enable_low_noise && state.getFlag(16L) || TorrentUtils.isReallyPrivate(torrent)) continue;
                    dl_marker += dm.getDownloadState().getLongParameter("stats.download.added.time");
                    downloads.add(PluginCoreUtils.wrap(dm));
                }
                if (url.toExternalForm().contains("format=html")) {
                    String host = (String)request2.getHeaders().get("host");
                    if (host != null) {
                        int c_pos = host.indexOf(58);
                        if (c_pos != -1) {
                            host = host.substring(0, c_pos);
                        }
                    } else {
                        host = "127.0.0.1";
                    }
                    response.setContentType("text/html; charset=UTF-8");
                    pw.println("<HTML><HEAD><TITLE>Tag: " + this.escape(tag.getTagName(true)) + "</TITLE></HEAD><BODY>");
                    PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
                    PluginInterface pi = pm.getPluginInterfaceByID("azupnpav", true);
                    if (pi == null) {
                        pw.println("UPnP Media Server plugin not found");
                    } else {
                        for (int i = 0; i < downloads.size(); ++i) {
                            DiskManagerFileInfo[] files;
                            Download download = (Download)downloads.get(i);
                            for (DiskManagerFileInfo file : files = download.getDiskManagerFileInfo()) {
                                File target_file = file.getFile(true);
                                if (!target_file.exists()) continue;
                                try {
                                    URL stream_url = new URL((String)pi.getIPC().invoke("getContentURL", new Object[]{file}));
                                    if (stream_url == null) continue;
                                    stream_url = UrlUtils.setHost(stream_url, host);
                                    String url_ext = stream_url.toExternalForm();
                                    pw.println("<p>");
                                    pw.println("<a href=\"" + url_ext + "\">" + this.escape(target_file.getName()) + "</a>");
                                    url_ext = url_ext + (url_ext.indexOf(63) == -1 ? "?" : "&");
                                    url_ext = url_ext + "action=download";
                                    pw.println("&nbsp;&nbsp;-&nbsp;&nbsp;<font size=\"-1\"><a href=\"" + url_ext + "\">save</a></font>");
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    pw.println("</BODY></HTML>");
                } else {
                    String config_key = "tag.rss.config." + tt_id + "." + t_id;
                    long old_marker = COConfigurationManager.getLongParameter(config_key + ".marker", 0L);
                    long last_modified = COConfigurationManager.getLongParameter(config_key + ".last_mod", 0L);
                    long now = SystemTime.getCurrentTime();
                    if (old_marker == dl_marker) {
                        if (last_modified == 0L) {
                            last_modified = now;
                        }
                    } else {
                        COConfigurationManager.setParameter(config_key + ".marker", dl_marker);
                        last_modified = now;
                    }
                    if (last_modified == now) {
                        COConfigurationManager.setParameter(config_key + ".last_mod", last_modified);
                    }
                    pw.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                    pw.println("<rss version=\"2.0\" xmlns:vuze=\"http://www.vuze.com\">");
                    pw.println("<channel>");
                    pw.println("<title>" + this.escape(tag.getTagName(true)) + "</title>");
                    Collections.sort(downloads, new Comparator<Download>(){

                        @Override
                        public int compare(Download d1, Download d2) {
                            long added1 = this.getAddedTime(d1) / 1000L;
                            long added2 = this.getAddedTime(d2) / 1000L;
                            return (int)(added2 - added1);
                        }
                    });
                    pw.println("<pubDate>" + TimeFormatter.getHTTPDate(last_modified) + "</pubDate>");
                    for (int i = 0; i < downloads.size(); ++i) {
                        Download download = (Download)downloads.get(i);
                        DownloadManager core_download = PluginCoreUtils.unwrap(download);
                        Torrent torrent = download.getTorrent();
                        byte[] hash = torrent.getHash();
                        String hash_str = Base32.encode(hash);
                        pw.println("<item>");
                        pw.println("<title>" + this.escape(download.getName()) + "</title>");
                        pw.println("<guid>" + hash_str + "</guid>");
                        String magnet_url = this.escape(UrlUtils.getMagnetURI(download));
                        pw.println("<link>" + magnet_url + "</link>");
                        long added = core_download.getDownloadState().getLongParameter("stats.download.added.time");
                        pw.println("<pubDate>" + TimeFormatter.getHTTPDate(added) + "</pubDate>");
                        pw.println("<vuze:size>" + torrent.getSize() + "</vuze:size>");
                        pw.println("<vuze:assethash>" + hash_str + "</vuze:assethash>");
                        pw.println("<vuze:downloadurl>" + magnet_url + "</vuze:downloadurl>");
                        DownloadScrapeResult scrape = download.getLastScrapeResult();
                        if (scrape != null && scrape.getResponseType() == 1) {
                            pw.println("<vuze:seeds>" + scrape.getSeedCount() + "</vuze:seeds>");
                            pw.println("<vuze:peers>" + scrape.getNonSeedCount() + "</vuze:peers>");
                        }
                        pw.println("</item>");
                    }
                    pw.println("</channel>");
                    pw.println("</rss>");
                }
            }
            pw.flush();
            return true;
        }

        protected long getAddedTime(Download download) {
            DownloadManager core_download = PluginCoreUtils.unwrap(download);
            return core_download.getDownloadState().getLongParameter("stats.download.added.time");
        }

        protected String escape(String str) {
            return XUXmlWriter.escapeXML(str);
        }
    };
    private FrequencyLimitedDispatcher dirty_dispatcher = new FrequencyLimitedDispatcher(new AERunnable(){

        public void runSupport() {
            try {
                Thread.sleep(1000L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            TagManagerImpl.this.writeConfig();
        }
    }, 30000);
    AsyncDispatcher async_dispatcher = new AsyncDispatcher(5000);
    private Map config;
    private WeakReference<Map> config_ref;
    private boolean config_dirty;
    private List<Object[]> config_change_queue = new ArrayList<Object[]>();
    private CopyOnWriteList<TagManagerListener> listeners = new CopyOnWriteList();
    private CopyOnWriteList<Object[]> feature_listeners = new CopyOnWriteList();
    private Map<Long, LifecycleHandlerImpl> lifecycle_handlers = new HashMap<Long, LifecycleHandlerImpl>();

    public static synchronized TagManagerImpl getSingleton() {
        if (singleton == null) {
            singleton = new TagManagerImpl();
            singleton.init();
        }
        return singleton;
    }

    private TagManagerImpl() {
    }

    @Override
    public boolean isEnabled() {
        return enabled;
    }

    private void init() {
        if (!enabled) {
            return;
        }
        AzureusCore azureus_core = AzureusCoreFactory.getSingleton();
        final TagPropertyTrackerHandler auto_tracker = new TagPropertyTrackerHandler(azureus_core, this);
        new TagPropertyUntaggedHandler(azureus_core, this);
        new TagPropertyTrackerTemplateHandler(azureus_core, this);
        new TagPropertyConstraintHandler(azureus_core, this);
        azureus_core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            public void started(AzureusCore core) {
                core.getPluginManager().getDefaultPluginInterface().getDownloadManager().getGlobalDownloadEventNotifier().addCompletionListener(TagManagerImpl.this);
            }

            public void componentCreated(AzureusCore core, AzureusCoreComponent component) {
                if (component instanceof GlobalManager) {
                    GlobalManager global_manager = (GlobalManager)component;
                    global_manager.addDownloadManagerInitialisationAdapter(new DownloadManagerInitialisationAdapter(){

                        public int getActions() {
                            return 2;
                        }

                        public void initialised(DownloadManager manager, boolean for_seeding) {
                            if (for_seeding) {
                                return;
                            }
                            List<Tag> auto_tags = auto_tracker.getTagsForDownload(manager);
                            HashSet<Tag> tags = new HashSet<Tag>(TagManagerImpl.this.getTagsForTaggable(3, manager));
                            tags.addAll(auto_tags);
                            if (tags.size() > 0) {
                                ArrayList<Tag> sl_tags = new ArrayList<Tag>();
                                for (Tag tag : tags) {
                                    File save_loc;
                                    TagFeatureFileLocation fl = (TagFeatureFileLocation)((Object)tag);
                                    if (!fl.supportsTagInitialSaveFolder() || (save_loc = fl.getTagInitialSaveFolder()) == null) continue;
                                    sl_tags.add(tag);
                                }
                                if (sl_tags.size() > 0) {
                                    File old_loc;
                                    File new_loc;
                                    if (sl_tags.size() > 1) {
                                        Collections.sort(sl_tags, new Comparator<Tag>(){

                                            @Override
                                            public int compare(Tag o1, Tag o2) {
                                                return o1.getTagID() - o2.getTagID();
                                            }
                                        });
                                    }
                                    if (!(new_loc = ((TagFeatureFileLocation)sl_tags.get(0)).getTagInitialSaveFolder()).equals(old_loc = manager.getSaveLocation())) {
                                        manager.setTorrentSaveDir(new_loc.getAbsolutePath());
                                    }
                                }
                            }
                        }
                    });
                }
            }

            public void stopped(AzureusCore core) {
                TagManagerImpl.this.destroy();
            }
        });
        SimpleTimer.addPeriodicEvent("TM:Sync", 30000L, new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                for (TagType tt : TagManagerImpl.this.tag_types) {
                    ((TagTypeBase)tt).sync();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompletion(Download d) {
        final DownloadManager manager = PluginCoreUtils.unwrap(d);
        List<Tag> tags = this.getTagsForTaggable(manager);
        ArrayList<Tag> cc_tags = new ArrayList<Tag>();
        for (Tag tag : tags) {
            File save_loc;
            TagFeatureFileLocation fl;
            if (!tag.getTagType().hasTagTypeFeature(16L) || !(fl = (TagFeatureFileLocation)((Object)tag)).supportsTagCopyOnComplete() || (save_loc = fl.getTagCopyOnCompleteFolder()) == null) continue;
            cc_tags.add(tag);
        }
        if (cc_tags.size() > 0) {
            File old_loc;
            File new_loc;
            if (cc_tags.size() > 1) {
                Collections.sort(cc_tags, new Comparator<Tag>(){

                    @Override
                    public int compare(Tag o1, Tag o2) {
                        return o1.getTagID() - o2.getTagID();
                    }
                });
            }
            if (!(new_loc = ((TagFeatureFileLocation)cc_tags.get(0)).getTagCopyOnCompleteFolder()).equals(old_loc = manager.getSaveLocation())) {
                boolean do_it;
                Set<DownloadManager> set = this.active_copy_on_complete;
                synchronized (set) {
                    if (this.active_copy_on_complete.contains(manager)) {
                        do_it = false;
                    } else {
                        this.active_copy_on_complete.add(manager);
                        do_it = true;
                    }
                }
                if (do_it) {
                    new AEThread2("tm:copy"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void run() {
                            try {
                                try {
                                    long stopped_and_incomplete_start = 0L;
                                    long looks_good_start = 0L;
                                    while (true) {
                                        block18: {
                                            block20: {
                                                long now;
                                                DiskManager dm;
                                                block19: {
                                                    if (manager.isDestroyed()) {
                                                        throw new Exception("Download has been removed");
                                                    }
                                                    dm = manager.getDiskManager();
                                                    if (dm != null) break block19;
                                                    looks_good_start = 0L;
                                                    if (manager.getAssumedComplete()) break;
                                                    now = SystemTime.getMonotonousTime();
                                                    if (stopped_and_incomplete_start == 0L) {
                                                        stopped_and_incomplete_start = now;
                                                        break block18;
                                                    } else if (now - stopped_and_incomplete_start > 30000L) {
                                                        throw new Exception("Download is stopped and incomplete");
                                                    }
                                                    break block18;
                                                }
                                                stopped_and_incomplete_start = 0L;
                                                if (!manager.getAssumedComplete()) break block20;
                                                if (dm.getMoveProgress() == -1 && dm.getCompleteRecheckStatus() == -1) {
                                                    now = SystemTime.getMonotonousTime();
                                                    if (looks_good_start == 0L) {
                                                        looks_good_start = now;
                                                        break block18;
                                                    } else if (now - looks_good_start > 5000L) {
                                                        break;
                                                    }
                                                }
                                                break block18;
                                            }
                                            looks_good_start = 0L;
                                        }
                                        Thread.sleep(1000L);
                                    }
                                    manager.copyDataFiles(new_loc);
                                    Logger.logTextResource(new LogAlert((Object)manager, true, 0, "alert.copy.on.comp.done"), new String[]{manager.getDisplayName(), new_loc.toString()});
                                }
                                catch (Throwable e) {
                                    Logger.logTextResource(new LogAlert((Object)manager, true, 3, "alert.copy.on.comp.fail"), new String[]{manager.getDisplayName(), new_loc.toString(), Debug.getNestedExceptionMessage(e)});
                                    Object var9_7 = null;
                                    Set set2 = TagManagerImpl.this.active_copy_on_complete;
                                    synchronized (set2) {
                                        TagManagerImpl.this.active_copy_on_complete.remove(manager);
                                        return;
                                    }
                                }
                                Object var9_6 = null;
                            }
                            catch (Throwable throwable) {
                                Object var9_8 = null;
                                Set set = TagManagerImpl.this.active_copy_on_complete;
                                synchronized (set) {
                                    TagManagerImpl.this.active_copy_on_complete.remove(manager);
                                    throw throwable;
                                }
                            }
                            Set set = TagManagerImpl.this.active_copy_on_complete;
                            synchronized (set) {
                                TagManagerImpl.this.active_copy_on_complete.remove(manager);
                                return;
                            }
                        }
                    }.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolverInitialized(TaggableResolver resolver) {
        TagTypeDownloadManual ttdm = new TagTypeDownloadManual(resolver);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        TagManagerImpl tagManagerImpl = this;
        synchronized (tagManagerImpl) {
            Map config = this.getConfig();
            Map tt = (Map)config.get(String.valueOf(ttdm.getTagType()));
            if (tt != null) {
                for (Map.Entry entry : tt.entrySet()) {
                    String key = (String)entry.getKey();
                    try {
                        if (!Character.isDigit(key.charAt(0))) continue;
                        int tag_id = Integer.parseInt(key);
                        Map m = (Map)entry.getValue();
                        tags.add(ttdm.createTag(tag_id, m));
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        }
        for (Tag tag : tags) {
            ttdm.addTag(tag);
        }
    }

    private void removeTaggable(TaggableResolver resolver, Taggable taggable) {
        for (TagType tt : this.tag_types) {
            TagTypeBase ttb = (TagTypeBase)tt;
            ttb.removeTaggable(resolver, taggable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTagType(TagType tag_type) {
        if (!enabled) {
            Debug.out("Not enabled");
            return;
        }
        Map<Integer, TagType> map = this.tag_type_map;
        synchronized (map) {
            if (this.tag_type_map.put(tag_type.getTagType(), tag_type) != null) {
                Debug.out("Duplicate tag type!");
            }
        }
        this.tag_types.add(tag_type);
        for (TagManagerListener l : this.listeners) {
            try {
                l.tagTypeAdded(this, tag_type);
            }
            catch (Throwable t) {
                Debug.out(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagType getTagType(int tag_type) {
        Map<Integer, TagType> map = this.tag_type_map;
        synchronized (map) {
            return this.tag_type_map.get(tag_type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTagType(TagType tag_type) {
        Map<Integer, TagType> map = this.tag_type_map;
        synchronized (map) {
            this.tag_type_map.remove(tag_type.getTagType());
        }
        this.tag_types.remove(tag_type);
        for (TagManagerListener l : this.listeners) {
            try {
                l.tagTypeRemoved(this, tag_type);
            }
            catch (Throwable t) {
                Debug.out(t);
            }
        }
        this.removeConfig(tag_type);
    }

    @Override
    public List<TagType> getTagTypes() {
        return this.tag_types.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taggableAdded(TagType tag_type, Tag tag, Taggable tagged) {
        int tt = tag_type.getTagType();
        try {
            File existing_save_loc;
            TOTorrent torrent;
            DownloadManager dm;
            File save_loc;
            TagFeatureFileLocation fl;
            if (tt == 3 && tagged instanceof DownloadManager && (fl = (TagFeatureFileLocation)((Object)tag)).supportsTagInitialSaveFolder() && (save_loc = fl.getTagInitialSaveFolder()) != null && (dm = (DownloadManager)tagged).getState() == 70 && (torrent = dm.getTorrent()) != null && dm.getGlobalManager().getDownloadManager(torrent.getHashWrapper()) != null && !(existing_save_loc = dm.getSaveLocation()).equals(save_loc) && !existing_save_loc.exists()) {
                dm.setTorrentSaveDir(save_loc.getAbsolutePath());
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        if (tt == 3) {
            Map<Long, LifecycleHandlerImpl> map = this.lifecycle_handlers;
            synchronized (map) {
                long type = tagged.getTaggableType();
                LifecycleHandlerImpl handler = this.lifecycle_handlers.get(type);
                if (handler == null) {
                    handler = new LifecycleHandlerImpl();
                    this.lifecycle_handlers.put(type, handler);
                }
                handler.taggableTagged(tag_type, tag, tagged);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taggableRemoved(TagType tag_type, Tag tag, Taggable tagged) {
        int tt = tag_type.getTagType();
        if (tt == 3) {
            Map<Long, LifecycleHandlerImpl> map = this.lifecycle_handlers;
            synchronized (map) {
                long type = tagged.getTaggableType();
                LifecycleHandlerImpl handler = this.lifecycle_handlers.get(type);
                if (handler == null) {
                    handler = new LifecycleHandlerImpl();
                    this.lifecycle_handlers.put(type, handler);
                }
                handler.taggableUntagged(tag_type, tag, tagged);
            }
        }
    }

    @Override
    public List<Tag> getTagsForTaggable(Taggable taggable) {
        HashSet<Tag> result = new HashSet<Tag>();
        for (TagType tt : this.tag_types) {
            result.addAll(tt.getTagsForTaggable(taggable));
        }
        return new ArrayList<Tag>(result);
    }

    @Override
    public List<Tag> getTagsForTaggable(int tts, Taggable taggable) {
        HashSet<Tag> result = new HashSet<Tag>();
        for (TagType tt : this.tag_types) {
            if (tt.getTagType() != tts) continue;
            result.addAll(tt.getTagsForTaggable(taggable));
        }
        return new ArrayList<Tag>(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tag lookupTagByUID(long tag_uid) {
        TagType tt;
        int tag_type_id = (int)(tag_uid >> 32 & 0xFFFFFFFFL);
        Map<Integer, TagType> map = this.tag_type_map;
        synchronized (map) {
            tt = this.tag_type_map.get(tag_type_id);
        }
        if (tt != null) {
            int tag_id = (int)(tag_uid & 0xFFFFFFFFL);
            return tt.getTag(tag_id);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaggableLifecycleHandler registerTaggableResolver(TaggableResolver resolver) {
        LifecycleHandlerImpl handler;
        if (!enabled) {
            return new TaggableLifecycleHandler(){

                @Override
                public void initialized(List<Taggable> initial_taggables) {
                }

                @Override
                public void taggableCreated(Taggable taggable) {
                }

                @Override
                public void taggableDestroyed(Taggable taggable) {
                }
            };
        }
        long type = resolver.getResolverTaggableType();
        Map<Long, LifecycleHandlerImpl> map = this.lifecycle_handlers;
        synchronized (map) {
            handler = this.lifecycle_handlers.get(type);
            if (handler == null) {
                handler = new LifecycleHandlerImpl();
                this.lifecycle_handlers.put(type, handler);
            }
            handler.setResolver(resolver);
        }
        return handler;
    }

    @Override
    public void setTagPublicDefault(boolean pub) {
        COConfigurationManager.setParameter("tag.manager.pub.default", pub);
    }

    @Override
    public boolean getTagPublicDefault() {
        return COConfigurationManager.getBooleanParameter("tag.manager.pub.default", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkRSSFeeds(TagBase tag, boolean enable) {
        Set<TagBase> set = this.rss_tags;
        synchronized (set) {
            if (enable) {
                if (this.rss_tags.contains(tag)) {
                    return;
                }
                this.rss_tags.add(tag);
                if (this.rss_tags.size() > 1) {
                    return;
                }
                RSSGeneratorPlugin.registerProvider(RSS_PROVIDER, this.rss_generator);
            } else {
                this.rss_tags.remove(tag);
                if (this.rss_tags.size() == 0) {
                    RSSGeneratorPlugin.unregisterProvider(RSS_PROVIDER);
                }
            }
        }
    }

    @Override
    public void addTagManagerListener(TagManagerListener listener, boolean fire_for_existing) {
        this.listeners.add(listener);
        if (fire_for_existing) {
            for (TagType tt : this.tag_types) {
                listener.tagTypeAdded(this, tt);
            }
        }
    }

    @Override
    public void removeTagManagerListener(TagManagerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void addTagFeatureListener(int features, TagFeatureListener listener) {
        this.feature_listeners.add(new Object[]{features, listener});
    }

    @Override
    public void removeTagFeatureListener(TagFeatureListener listener) {
        for (Object[] entry : this.feature_listeners) {
            if (entry[1] != listener) continue;
            this.feature_listeners.remove(entry);
        }
    }

    protected void featureChanged(Tag tag, int feature) {
        for (Object[] entry : this.feature_listeners) {
            if (((Integer)entry[0] & feature) == 0) continue;
            try {
                ((TagFeatureListener)entry[1]).tagFeatureChanged(tag, feature);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTaggableLifecycleListener(long taggable_type, TaggableLifecycleListener listener) {
        Map<Long, LifecycleHandlerImpl> map = this.lifecycle_handlers;
        synchronized (map) {
            LifecycleHandlerImpl handler = this.lifecycle_handlers.get(taggable_type);
            if (handler == null) {
                handler = new LifecycleHandlerImpl();
                this.lifecycle_handlers.put(taggable_type, handler);
            }
            handler.addListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTaggableLifecycleListener(long taggable_type, TaggableLifecycleListener listener) {
        Map<Long, LifecycleHandlerImpl> map = this.lifecycle_handlers;
        synchronized (map) {
            LifecycleHandlerImpl handler = this.lifecycle_handlers.get(taggable_type);
            if (handler != null) {
                handler.removeListener(listener);
            }
        }
    }

    protected void tagCreated(TagWithState tag) {
        this.addConfigUpdate(1, tag);
    }

    protected void tagChanged(TagWithState tag) {
        this.addConfigUpdate(2, tag);
    }

    protected void tagRemoved(TagWithState tag) {
        this.addConfigUpdate(4, tag);
    }

    protected void tagContentsChanged(TagWithState tag) {
        this.addConfigUpdate(3, tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConfigUpdate(int type, TagWithState tag) {
        if (!tag.getTagType().isTagTypePersistent()) {
            return;
        }
        if (tag.isRemoved() && type != 4) {
            return;
        }
        TagManagerImpl tagManagerImpl = this;
        synchronized (tagManagerImpl) {
            this.config_change_queue.add(new Object[]{type, tag});
        }
        this.setDirty();
    }

    private void applyConfigUpdates(Map config) {
        HashMap<TagWithState, Integer> updates = new HashMap<TagWithState, Integer>();
        for (Object[] objectArray : this.config_change_queue) {
            Integer existing;
            int type = (Integer)objectArray[0];
            TagWithState tag = (TagWithState)objectArray[1];
            if (tag.isRemoved()) {
                type = 4;
            }
            if ((existing = (Integer)updates.get(tag)) == null) {
                updates.put(tag, type);
                continue;
            }
            if (existing == 4 || type <= existing) continue;
            updates.put(tag, type);
        }
        for (Map.Entry entry : updates.entrySet()) {
            TagWithState tag = (TagWithState)entry.getKey();
            int type = (Integer)entry.getValue();
            TagTypeBase tag_type = tag.getTagType();
            String tt_key = String.valueOf(tag_type.getTagType());
            HashMap tt = (HashMap)config.get(tt_key);
            if (tt == null) {
                if (type == 4) continue;
                tt = new HashMap();
                config.put(tt_key, tt);
            }
            String t_key = String.valueOf(tag.getTagID());
            if (type == 4) {
                tt.remove(t_key);
                continue;
            }
            HashMap t = (HashMap)tt.get(t_key);
            if (t == null) {
                t = new HashMap();
                tt.put(t_key, t);
            }
            tag.exportDetails(t, type == 3);
        }
        this.config_change_queue.clear();
    }

    private void destroy() {
        this.writeConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDirty() {
        TagManagerImpl tagManagerImpl = this;
        synchronized (tagManagerImpl) {
            if (!this.config_dirty) {
                this.config_dirty = true;
                this.dirty_dispatcher.dispatch();
            }
        }
    }

    private Map readConfig() {
        if (!enabled) {
            Debug.out("TagManager is disabled");
            return new HashMap();
        }
        HashMap map = FileUtil.resilientConfigFileExists(CONFIG_FILE) ? FileUtil.readResilientConfigFile(CONFIG_FILE) : new HashMap();
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getConfig() {
        TagManagerImpl tagManagerImpl = this;
        synchronized (tagManagerImpl) {
            if (this.config != null) {
                return this.config;
            }
            if (this.config_ref != null) {
                this.config = (Map)this.config_ref.get();
                if (this.config != null) {
                    return this.config;
                }
            }
            this.config = this.readConfig();
            return this.config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeConfig() {
        if (!enabled) {
            Debug.out("TagManager is disabled");
        }
        TagManagerImpl tagManagerImpl = this;
        synchronized (tagManagerImpl) {
            if (!this.config_dirty) {
                return;
            }
            this.config_dirty = false;
            if (this.config_change_queue.size() > 0) {
                this.applyConfigUpdates(this.getConfig());
            }
            if (this.config != null) {
                FileUtil.writeResilientConfigFile(CONFIG_FILE, this.config);
                this.config_ref = new WeakReference<Map>(this.config);
                this.config = null;
            }
        }
    }

    private Map getConf(TagTypeBase tag_type, TagBase tag, boolean create) {
        HashMap conf;
        String t_key;
        HashMap t;
        String tt_key;
        Map m = this.getConfig();
        HashMap tt = (HashMap)m.get(tt_key = String.valueOf(tag_type.getTagType()));
        if (tt == null) {
            if (create) {
                tt = new HashMap();
                m.put(tt_key, tt);
            } else {
                return null;
            }
        }
        if ((t = (HashMap)tt.get(t_key = String.valueOf(tag.getTagID()))) == null) {
            if (create) {
                t = new HashMap();
                tt.put(t_key, t);
            } else {
                return null;
            }
        }
        if ((conf = (HashMap)t.get("c")) == null && create) {
            conf = new HashMap();
            t.put("c", conf);
        }
        return conf;
    }

    protected Boolean readBooleanAttribute(TagTypeBase tag_type, TagBase tag, String attr, Boolean def) {
        Long result = this.readLongAttribute(tag_type, tag, attr, def == null ? null : Long.valueOf(def != false ? 1L : 0L));
        if (result == null) {
            return null;
        }
        return result == 1L;
    }

    protected boolean writeBooleanAttribute(TagTypeBase tag_type, TagBase tag, String attr, boolean value) {
        return this.writeLongAttribute(tag_type, tag, attr, value ? 1L : 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long readLongAttribute(TagTypeBase tag_type, TagBase tag, String attr, Long def) {
        try {
            TagManagerImpl tagManagerImpl = this;
            synchronized (tagManagerImpl) {
                Map conf = this.getConf(tag_type, tag, false);
                if (conf == null) {
                    return def;
                }
                Long value = (Long)conf.get(attr);
                if (value == null) {
                    return def;
                }
                return value;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
            return def;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writeLongAttribute(TagTypeBase tag_type, TagBase tag, String attr, long value) {
        try {
            TagManagerImpl tagManagerImpl = this;
            synchronized (tagManagerImpl) {
                Map conf = this.getConf(tag_type, tag, true);
                long old = MapUtils.getMapLong(conf, attr, 0L);
                if (old == value && conf.containsKey(attr)) {
                    return false;
                }
                conf.put(attr, value);
                this.setDirty();
                return true;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readStringAttribute(TagTypeBase tag_type, TagBase tag, String attr, String def) {
        try {
            TagManagerImpl tagManagerImpl = this;
            synchronized (tagManagerImpl) {
                Map conf = this.getConf(tag_type, tag, false);
                if (conf == null) {
                    return def;
                }
                return MapUtils.getMapString(conf, attr, def);
            }
        }
        catch (Throwable e) {
            Debug.out(e);
            return def;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeStringAttribute(TagTypeBase tag_type, TagBase tag, String attr, String value) {
        try {
            TagManagerImpl tagManagerImpl = this;
            synchronized (tagManagerImpl) {
                Map conf = this.getConf(tag_type, tag, true);
                String old = MapUtils.getMapString(conf, attr, null);
                if (old == value) {
                    return;
                }
                if (old != null && value != null && old.equals(value)) {
                    return;
                }
                MapUtils.setMapString(conf, attr, value);
                this.setDirty();
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] readStringListAttribute(TagTypeBase tag_type, TagBase tag, String attr, String[] def) {
        try {
            TagManagerImpl tagManagerImpl = this;
            synchronized (tagManagerImpl) {
                Map conf = this.getConf(tag_type, tag, false);
                if (conf == null) {
                    return def;
                }
                List vals = BDecoder.decodeStrings((List)conf.get(attr));
                if (vals == null) {
                    return def;
                }
                return vals.toArray(new String[vals.size()]);
            }
        }
        catch (Throwable e) {
            Debug.out(e);
            return def;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writeStringListAttribute(TagTypeBase tag_type, TagBase tag, String attr, String[] value) {
        try {
            TagManagerImpl tagManagerImpl = this;
            synchronized (tagManagerImpl) {
                Map conf = this.getConf(tag_type, tag, true);
                List old = BDecoder.decodeStrings((List)conf.get(attr));
                if (old == null && value == null) {
                    return false;
                }
                if (old != null && value != null && value.length == old.size()) {
                    boolean diff = false;
                    for (int i = 0; i < value.length; ++i) {
                        if (((String)old.get(i)).equals(value[i])) continue;
                        diff = true;
                        break;
                    }
                    if (!diff) {
                        return false;
                    }
                }
                if (value == null) {
                    conf.remove(attr);
                } else {
                    conf.put(attr, Arrays.asList(value));
                }
                this.setDirty();
                return true;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConfig(TagType tag_type) {
        TagManagerImpl tagManagerImpl = this;
        synchronized (tagManagerImpl) {
            Map m = this.getConfig();
            String tt_key = String.valueOf(tag_type.getTagType());
            Map tt = (Map)m.remove(tt_key);
            if (tt != null) {
                this.setDirty();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConfig(Tag tag) {
        TagType tag_type = tag.getTagType();
        TagManagerImpl tagManagerImpl = this;
        synchronized (tagManagerImpl) {
            Map m = this.getConfig();
            String tt_key = String.valueOf(tag_type.getTagType());
            Map tt = (Map)m.get(tt_key);
            if (tt == null) {
                return;
            }
            String t_key = String.valueOf(tag.getTagID());
            Map t = (Map)tt.remove(t_key);
            if (t != null) {
                this.setDirty();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LifecycleHandlerImpl
    implements TaggableLifecycleHandler {
        private TaggableResolver resolver;
        private boolean initialised;
        private CopyOnWriteList<TaggableLifecycleListener> listeners = new CopyOnWriteList();

        private LifecycleHandlerImpl() {
        }

        private void setResolver(TaggableResolver _resolver) {
            this.resolver = _resolver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addListener(final TaggableLifecycleListener listener) {
            LifecycleHandlerImpl lifecycleHandlerImpl = this;
            synchronized (lifecycleHandlerImpl) {
                List<Taggable> taggables;
                this.listeners.add(listener);
                if (this.initialised && (taggables = this.resolver.getResolvedTaggables()).size() > 0) {
                    TagManagerImpl.this.async_dispatcher.dispatch(new AERunnable(){

                        public void runSupport() {
                            listener.initialised(taggables);
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeListener(TaggableLifecycleListener listener) {
            LifecycleHandlerImpl lifecycleHandlerImpl = this;
            synchronized (lifecycleHandlerImpl) {
                this.listeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void initialized(final List<Taggable> initial_taggables) {
            TagManagerImpl.this.resolverInitialized(this.resolver);
            LifecycleHandlerImpl lifecycleHandlerImpl = this;
            synchronized (lifecycleHandlerImpl) {
                this.initialised = true;
                if (this.listeners.size() > 0) {
                    final List<TaggableLifecycleListener> listeners_ref = this.listeners.getList();
                    TagManagerImpl.this.async_dispatcher.dispatch(new AERunnable(){

                        public void runSupport() {
                            for (TaggableLifecycleListener listener : listeners_ref) {
                                listener.initialised(initial_taggables);
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void taggableCreated(final Taggable t) {
            LifecycleHandlerImpl lifecycleHandlerImpl = this;
            synchronized (lifecycleHandlerImpl) {
                if (this.initialised) {
                    final List<TaggableLifecycleListener> listeners_ref = this.listeners.getList();
                    TagManagerImpl.this.async_dispatcher.dispatch(new AERunnable(){

                        public void runSupport() {
                            for (TaggableLifecycleListener listener : listeners_ref) {
                                try {
                                    listener.taggableCreated(t);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void taggableDestroyed(final Taggable t) {
            TagManagerImpl.this.removeTaggable(this.resolver, t);
            LifecycleHandlerImpl lifecycleHandlerImpl = this;
            synchronized (lifecycleHandlerImpl) {
                if (this.initialised) {
                    final List<TaggableLifecycleListener> listeners_ref = this.listeners.getList();
                    TagManagerImpl.this.async_dispatcher.dispatch(new AERunnable(){

                        public void runSupport() {
                            for (TaggableLifecycleListener listener : listeners_ref) {
                                try {
                                    listener.taggableDestroyed(t);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taggableTagged(final TagType tag_type, final Tag tag, final Taggable taggable) {
            LifecycleHandlerImpl lifecycleHandlerImpl = this;
            synchronized (lifecycleHandlerImpl) {
                if (this.initialised) {
                    final List<TaggableLifecycleListener> listeners_ref = this.listeners.getList();
                    TagManagerImpl.this.async_dispatcher.dispatch(new AERunnable(){

                        public void runSupport() {
                            for (TaggableLifecycleListener listener : listeners_ref) {
                                try {
                                    listener.taggableTagged(tag_type, tag, taggable);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taggableUntagged(final TagType tag_type, final Tag tag, final Taggable taggable) {
            LifecycleHandlerImpl lifecycleHandlerImpl = this;
            synchronized (lifecycleHandlerImpl) {
                if (this.initialised) {
                    final List<TaggableLifecycleListener> listeners_ref = this.listeners.getList();
                    TagManagerImpl.this.async_dispatcher.dispatch(new AERunnable(){

                        public void runSupport() {
                            for (TaggableLifecycleListener listener : listeners_ref) {
                                try {
                                    listener.taggableUntagged(tag_type, tag, taggable);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                }
            }
        }
    }
}

