/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.tag.impl;

import com.aelitis.azureus.core.tag.TagException;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.core.tag.impl.TagBase;
import com.aelitis.azureus.core.tag.impl.TagTypeBase;
import com.aelitis.azureus.core.util.CopyOnWriteSet;
import com.aelitis.azureus.util.MapUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TagWithState
extends TagBase {
    private CopyOnWriteSet<Taggable> objects = new CopyOnWriteSet(true);
    private boolean removed;

    public TagWithState(TagTypeBase tt, int tag_id, String name) {
        super(tt, tag_id, name);
    }

    protected TagWithState(TagTypeBase tt, int tag_id, Map map) {
        super(tt, tag_id, MapUtils.getMapString(map, "n", ""));
        List list;
        if (map != null && (list = (List)map.get("o")) != null) {
            for (byte[] b : list) {
                try {
                    String id = new String(b, "UTF-8");
                    Taggable taggable = tt.resolveTaggable(id);
                    if (taggable == null) continue;
                    this.objects.add(taggable);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    protected void exportDetails(Map map, boolean do_contents) {
        MapUtils.setMapString(map, "n", this.getTagNameRaw());
        if (do_contents) {
            Iterator<Taggable> it = this.objects.iterator();
            ArrayList<byte[]> l = new ArrayList<byte[]>(this.objects.size());
            while (it.hasNext()) {
                try {
                    Taggable taggable = it.next();
                    String id = taggable.getTaggableID();
                    if (id != null) {
                        l.add(id.getBytes("UTF-8"));
                        continue;
                    }
                    Debug.out("No taggable ID for " + taggable);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            map.put("o", l);
        }
    }

    @Override
    public void setTagName(String name) throws TagException {
        super.setTagName(name);
        this.getManager().tagChanged(this);
    }

    @Override
    public void addTaggable(Taggable t) {
        if (this.removed) {
            Debug.out("Tag has been removed");
            return;
        }
        this.objects.add(t);
        super.addTaggable(t);
        this.getManager().tagContentsChanged(this);
    }

    @Override
    public void removeTaggable(Taggable t) {
        boolean removed = this.objects.remove(t);
        super.removeTaggable(t);
        if (removed) {
            this.getManager().tagContentsChanged(this);
        }
    }

    @Override
    public void removeTag() {
        super.removeTag();
        this.removed = true;
    }

    protected boolean isRemoved() {
        return this.removed;
    }

    @Override
    public int getTaggedCount() {
        return this.objects.size();
    }

    @Override
    public boolean hasTaggable(Taggable t) {
        return this.objects.contains(t);
    }

    @Override
    public Set<Taggable> getTagged() {
        return this.objects.getSet();
    }
}

