/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityHashSet<E>
extends AbstractSet<E> {
    private IdentityHashMap<E, Object> identity_map;

    public IdentityHashSet() {
        this.identity_map = new IdentityHashMap();
    }

    public IdentityHashSet(Collection<? extends E> set) {
        this.identity_map = new IdentityHashMap(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        this.addAll(set);
    }

    @Override
    public int size() {
        return this.identity_map.size();
    }

    @Override
    public boolean contains(Object entry) {
        return this.identity_map.containsKey(entry);
    }

    @Override
    public boolean add(E entry) {
        return this.identity_map.put(entry, "") == null;
    }

    @Override
    public boolean remove(Object entry) {
        return this.identity_map.remove(entry) != null;
    }

    @Override
    public void clear() {
        this.identity_map.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return this.identity_map.keySet().iterator();
    }
}

