/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.average;

import com.aelitis.azureus.core.util.average.Average;

public class MovingImmediateAverage
implements Average {
    private final int periods;
    private double[] data;
    private int pos = 0;
    private double total;

    public MovingImmediateAverage(int periods) {
        this.periods = periods;
        this.data = new double[periods];
    }

    public void reset() {
        this.pos = 0;
        this.total = 0.0;
        this.data = new double[this.periods];
    }

    public double update(double newValue) {
        this.total -= this.data[this.pos % this.periods];
        this.total += newValue;
        this.data[this.pos++ % this.periods] = newValue;
        if (this.pos == Integer.MAX_VALUE) {
            this.pos %= this.periods;
        }
        return this.calculateAve();
    }

    public double[] getValues() {
        double[] res = new double[this.periods];
        int p = this.pos;
        for (int i = 0; i < this.periods; ++i) {
            res[i] = this.data[p++ % this.periods];
        }
        return res;
    }

    public double getAverage() {
        return this.calculateAve();
    }

    public int getPeriods() {
        return this.periods;
    }

    public int getSampleCount() {
        return this.pos > this.periods ? this.periods : this.pos;
    }

    private double calculateAve() {
        int lim;
        int n = lim = this.pos > this.periods ? this.periods : this.pos;
        if (lim == 0) {
            return 0.0;
        }
        if (this.pos % this.periods == 0) {
            double sum = 0.0;
            for (int i = 0; i < lim; ++i) {
                sum += this.data[i];
            }
            this.total = sum;
        }
        return this.total / (double)lim;
    }
}

