/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.vuzefile;

import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.BEncoder;

public class VuzeFileImpl
implements VuzeFile {
    private VuzeFileHandler handler;
    private VuzeFileComponent[] components;

    protected VuzeFileImpl(VuzeFileHandler _handler) {
        this.handler = _handler;
        this.components = new VuzeFileComponent[0];
    }

    protected VuzeFileImpl(VuzeFileHandler _handler, Map map) {
        this.handler = _handler;
        List l_comps = (List)map.get("components");
        this.components = new VuzeFileComponent[l_comps.size()];
        for (int i = 0; i < l_comps.size(); ++i) {
            Map comp2 = (Map)l_comps.get(i);
            int type = ((Long)comp2.get("type")).intValue();
            Map content = (Map)comp2.get("content");
            this.components[i] = new comp(type, content);
        }
    }

    public String getName() {
        String str = "";
        for (VuzeFileComponent comp2 : this.components) {
            str = str + (str.length() == 0 ? "" : ",") + comp2.getTypeName();
        }
        return str;
    }

    public VuzeFileComponent[] getComponents() {
        return this.components;
    }

    public VuzeFileComponent addComponent(int type, Map content) {
        comp comp2 = new comp(type, content);
        int old_len = this.components.length;
        VuzeFileComponent[] res = new VuzeFileComponent[old_len + 1];
        System.arraycopy(this.components, 0, res, 0, old_len);
        res[old_len] = comp2;
        this.components = res;
        return comp2;
    }

    public Map exportToMap() throws IOException {
        HashMap map = new HashMap();
        HashMap vuze_map = new HashMap();
        map.put("vuze", vuze_map);
        ArrayList list = new ArrayList();
        vuze_map.put("components", list);
        for (int i = 0; i < this.components.length; ++i) {
            VuzeFileComponent comp2 = this.components[i];
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("type", new Long(comp2.getType()));
            entry.put("content", comp2.getContent());
            list.add(entry);
        }
        return map;
    }

    public byte[] exportToBytes() throws IOException {
        return BEncoder.encode(this.exportToMap());
    }

    public String exportToJSON() throws IOException {
        return BEncoder.encodeToJSON(this.exportToMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File target) throws IOException {
        FileOutputStream fos = new FileOutputStream(target);
        try {
            fos.write(this.exportToBytes());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            fos.close();
            throw throwable;
        }
        fos.close();
    }

    protected class comp
    implements VuzeFileComponent {
        private int type;
        private Map contents;
        private boolean processed;
        private Map user_data;

        protected comp(int _type, Map _contents) {
            this.type = _type;
            this.contents = _contents;
        }

        public int getType() {
            return this.type;
        }

        public String getTypeName() {
            switch (this.type) {
                case 0: {
                    return "None";
                }
                case 1: {
                    return "Search Template";
                }
                case 2: {
                    return "Navigation";
                }
                case 4: {
                    return "Condition Check";
                }
                case 8: {
                    return "Plugin";
                }
                case 16: {
                    return "Subscription";
                }
                case 32: {
                    return "Subscription";
                }
                case 64: {
                    return "Customization";
                }
                case 128: {
                    return "Content Network";
                }
                case 256: {
                    return "Search Operation";
                }
                case 512: {
                    return "Device";
                }
                case 1024: {
                    return "Config Settings";
                }
            }
            return "Unknown";
        }

        public Map getContent() {
            return this.contents;
        }

        public void setProcessed() {
            this.processed = true;
        }

        public boolean isProcessed() {
            return this.processed;
        }

        public synchronized void setData(Object key, Object value) {
            if (this.user_data == null) {
                this.user_data = new HashMap();
            }
            this.user_data.put(key, value);
        }

        public synchronized Object getData(Object key) {
            if (this.user_data == null) {
                return null;
            }
            return this.user_data.get(key);
        }
    }
}

