/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.impl.webseed;

import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReaderFactory;
import com.aelitis.azureus.plugins.extseed.impl.webseed.ExternalSeedReaderWebSeed;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.torrent.Torrent;

public class ExternalSeedReaderFactoryWebSeed
implements ExternalSeedReaderFactory {
    public ExternalSeedReader[] getSeedReaders(ExternalSeedPlugin plugin, Download download) {
        return this.getSeedReaders(plugin, download.getName(), download.getTorrent());
    }

    public ExternalSeedReader[] getSeedReaders(ExternalSeedPlugin plugin, Torrent torrent) {
        return this.getSeedReaders(plugin, torrent.getName(), torrent);
    }

    private ExternalSeedReader[] getSeedReaders(ExternalSeedPlugin plugin, String name, Torrent torrent) {
        try {
            HashMap<String, Object> config = new HashMap<String, Object>();
            Object obj = torrent.getAdditionalProperty("httpseeds");
            if (obj != null) {
                config.put("httpseeds", obj);
            }
            return this.getSeedReaders(plugin, name, torrent, config);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new ExternalSeedReader[0];
        }
    }

    public ExternalSeedReader[] getSeedReaders(ExternalSeedPlugin plugin, Download download, Map config) {
        return this.getSeedReaders(plugin, download.getName(), download.getTorrent(), config);
    }

    private ExternalSeedReader[] getSeedReaders(ExternalSeedPlugin plugin, String name, Torrent torrent, Map config) {
        try {
            Object obj = config.get("httpseeds");
            if (obj instanceof byte[]) {
                ArrayList l = new ArrayList();
                l.add(obj);
                obj = l;
            }
            if (obj instanceof List) {
                List urls = (List)obj;
                ArrayList<ExternalSeedReaderWebSeed> readers = new ArrayList<ExternalSeedReaderWebSeed>();
                Object _params = config.get("httpseeds-params");
                Map params = _params instanceof Map ? (Map)_params : new HashMap();
                for (int i = 0; i < urls.size(); ++i) {
                    if (readers.size() > 10) {
                        Debug.out("Too many WS seeds, truncating");
                        break;
                    }
                    try {
                        String url_str = new String((byte[])urls.get(i));
                        url_str = url_str.replaceAll(" ", "%20");
                        URL url = new URL(url_str);
                        String protocol = url.getProtocol().toLowerCase();
                        if (protocol.equals("http")) {
                            readers.add(new ExternalSeedReaderWebSeed(plugin, torrent, url, params));
                            continue;
                        }
                        plugin.log(name + ": WS unsupported protocol: " + url);
                        continue;
                    }
                    catch (Throwable e) {
                        Object o = urls.get(i);
                        String str = o instanceof byte[] ? new String((byte[])o) : String.valueOf(o);
                        Debug.out("WS seed invalid: " + str, e);
                    }
                }
                ExternalSeedReader[] res = new ExternalSeedReader[readers.size()];
                readers.toArray(res);
                return res;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return new ExternalSeedReader[0];
    }
}

